/* Copyright (c) 2018, 2019 Evan Nemerson <evan@nemerson.com>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#define SIMDE_TESTS_CURRENT_ISAX avx512bw
#include <simde/x86/avx512bw.h>
#include <test/x86/test-avx512.h>

#if defined(SIMDE_AVX512BW_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS)

static MunitResult
test_simde_mm512_adds_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -16), INT8_C( -64), INT8_C( 113),
                           INT8_C(  51), INT8_C(-115), INT8_C(  19), INT8_C( -80),
                           INT8_C(-110), INT8_C( -62), INT8_C( -91), INT8_C(   8),
                           INT8_C(  11), INT8_C( -49), INT8_C( -43), INT8_C(-101),
                           INT8_C(  16), INT8_C(  61), INT8_C(  -2), INT8_C(-100),
                           INT8_C(   1), INT8_C( -80), INT8_C( 127), INT8_C(-105),
                           INT8_C( -74), INT8_C(-126), INT8_C( 122), INT8_C(  30),
                           INT8_C( -73), INT8_C(  48), INT8_C( -33), INT8_C(   2),
                           INT8_C( -82), INT8_C( -10), INT8_C(  33), INT8_C(  20),
                           INT8_C(-120), INT8_C(-120), INT8_C( -46), INT8_C( -54),
                           INT8_C( -43), INT8_C(  63), INT8_C(  81), INT8_C( 103),
                           INT8_C( 118), INT8_C( -84), INT8_C(  76), INT8_C(  47),
                           INT8_C( 101), INT8_C( -83), INT8_C(  15), INT8_C(  23),
                           INT8_C(  36), INT8_C(-116), INT8_C( -88), INT8_C( -45),
                           INT8_C(  -6), INT8_C(  86), INT8_C(  20), INT8_C(  39),
                           INT8_C( 117), INT8_C(  80), INT8_C(  97), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  43), INT8_C(  38), INT8_C(  97),
                           INT8_C(  38), INT8_C(  68), INT8_C(  88), INT8_C(  56),
                           INT8_C( -39), INT8_C(  61), INT8_C( -57), INT8_C( -66),
                           INT8_C(-121), INT8_C(  29), INT8_C( 110), INT8_C( 127),
                           INT8_C(-115), INT8_C(  16), INT8_C( -46), INT8_C(  65),
                           INT8_C( -36), INT8_C(  26), INT8_C(  12), INT8_C( -79),
                           INT8_C( -66), INT8_C( -28), INT8_C( -67), INT8_C( -79),
                           INT8_C( -60), INT8_C( -13), INT8_C(  74), INT8_C(  25),
                           INT8_C(  46), INT8_C(   8), INT8_C(  70), INT8_C( 106),
                           INT8_C(-119), INT8_C(   0), INT8_C( -96), INT8_C( -51),
                           INT8_C( -50), INT8_C(  93), INT8_C(  92), INT8_C(  65),
                           INT8_C( -96), INT8_C(-126), INT8_C(   4), INT8_C(   9),
                           INT8_C(  26), INT8_C(-119), INT8_C(  93), INT8_C(  15),
                           INT8_C(-115), INT8_C(  77), INT8_C( 125), INT8_C( -62),
                           INT8_C(  77), INT8_C( -22), INT8_C( 101), INT8_C(  83),
                           INT8_C(  45), INT8_C( -68), INT8_C(  97), INT8_C( -19)),
      simde_mm512_set_epi8(INT8_C(  92), INT8_C(  27), INT8_C( -26), INT8_C( 127),
                           INT8_C(  89), INT8_C( -47), INT8_C( 107), INT8_C( -24),
                           INT8_C(-128), INT8_C(  -1), INT8_C(-128), INT8_C( -58),
                           INT8_C(-110), INT8_C( -20), INT8_C(  67), INT8_C(  26),
                           INT8_C( -99), INT8_C(  77), INT8_C( -48), INT8_C( -35),
                           INT8_C( -35), INT8_C( -54), INT8_C( 127), INT8_C(-128),
                           INT8_C(-128), INT8_C(-128), INT8_C(  55), INT8_C( -49),
                           INT8_C(-128), INT8_C(  35), INT8_C(  41), INT8_C(  27),
                           INT8_C( -36), INT8_C(  -2), INT8_C( 103), INT8_C( 126),
                           INT8_C(-128), INT8_C(-120), INT8_C(-128), INT8_C(-105),
                           INT8_C( -93), INT8_C( 127), INT8_C( 127), INT8_C( 127),
                           INT8_C(  22), INT8_C(-128), INT8_C(  80), INT8_C(  56),
                           INT8_C( 127), INT8_C(-128), INT8_C( 108), INT8_C(  38),
                           INT8_C( -79), INT8_C( -39), INT8_C(  37), INT8_C(-107),
                           INT8_C(  71), INT8_C(  64), INT8_C( 121), INT8_C( 122),
                           INT8_C( 127), INT8_C(  12), INT8_C( 127), INT8_C(  22)) },
    { simde_mm512_set_epi8(INT8_C(  60), INT8_C(  96), INT8_C(-106), INT8_C(-115),
                           INT8_C(  31), INT8_C(-108), INT8_C(  15), INT8_C(  63),
                           INT8_C( -77), INT8_C( 125), INT8_C(  41), INT8_C( -80),
                           INT8_C(  36), INT8_C(-118), INT8_C(-116), INT8_C( -63),
                           INT8_C( -44), INT8_C(  70), INT8_C(  99), INT8_C(  48),
                           INT8_C(  67), INT8_C(  43), INT8_C(  83), INT8_C(  53),
                           INT8_C(  60), INT8_C(  57), INT8_C(-118), INT8_C(  55),
                           INT8_C( -62), INT8_C( -42), INT8_C(  19), INT8_C(  52),
                           INT8_C( -37), INT8_C( -32), INT8_C(  33), INT8_C(-114),
                           INT8_C( -96), INT8_C(  53), INT8_C(  18), INT8_C( -37),
                           INT8_C(   6), INT8_C( -87), INT8_C( -11), INT8_C( -10),
                           INT8_C(  -4), INT8_C(  84), INT8_C( 104), INT8_C(  55),
                           INT8_C(  92), INT8_C( 117), INT8_C(  16), INT8_C( 115),
                           INT8_C(  83), INT8_C(  80), INT8_C(-125), INT8_C(  64),
                           INT8_C(  74), INT8_C(  -9), INT8_C( -62), INT8_C(  67),
                           INT8_C( 102), INT8_C(  66), INT8_C( -86), INT8_C(-112)),
      simde_mm512_set_epi8(INT8_C( -97), INT8_C(  52), INT8_C( -91), INT8_C(   7),
                           INT8_C(  -1), INT8_C( -19), INT8_C(  38), INT8_C(  15),
                           INT8_C(  76), INT8_C(  63), INT8_C(  10), INT8_C(  18),
                           INT8_C(  54), INT8_C(  73), INT8_C(  15), INT8_C( -54),
                           INT8_C(-114), INT8_C(  63), INT8_C(  44), INT8_C(   4),
                           INT8_C(  41), INT8_C(  90), INT8_C( -78), INT8_C( -67),
                           INT8_C(  95), INT8_C( -14), INT8_C( -10), INT8_C( -44),
                           INT8_C(  53), INT8_C( 102), INT8_C( 127), INT8_C( 120),
                           INT8_C( -89), INT8_C(  10), INT8_C( -36), INT8_C( -50),
                           INT8_C( 118), INT8_C(-106), INT8_C( -52), INT8_C(  76),
                           INT8_C(  66), INT8_C( -36), INT8_C( -79), INT8_C(  91),
                           INT8_C(  14), INT8_C( 103), INT8_C( -73), INT8_C(-123),
                           INT8_C(  68), INT8_C( -54), INT8_C(-103), INT8_C(  38),
                           INT8_C(  58), INT8_C(   0), INT8_C( -62), INT8_C( -76),
                           INT8_C(  93), INT8_C( 119), INT8_C(  14), INT8_C(  84),
                           INT8_C( -83), INT8_C(  76), INT8_C( -47), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C( -37), INT8_C( 127), INT8_C(-128), INT8_C(-108),
                           INT8_C(  30), INT8_C(-127), INT8_C(  53), INT8_C(  78),
                           INT8_C(  -1), INT8_C( 127), INT8_C(  51), INT8_C( -62),
                           INT8_C(  90), INT8_C( -45), INT8_C(-101), INT8_C(-117),
                           INT8_C(-128), INT8_C( 127), INT8_C( 127), INT8_C(  52),
                           INT8_C( 108), INT8_C( 127), INT8_C(   5), INT8_C( -14),
                           INT8_C( 127), INT8_C(  43), INT8_C(-128), INT8_C(  11),
                           INT8_C(  -9), INT8_C(  60), INT8_C( 127), INT8_C( 127),
                           INT8_C(-126), INT8_C( -22), INT8_C(  -3), INT8_C(-128),
                           INT8_C(  22), INT8_C( -53), INT8_C( -34), INT8_C(  39),
                           INT8_C(  72), INT8_C(-123), INT8_C( -90), INT8_C(  81),
                           INT8_C(  10), INT8_C( 127), INT8_C(  31), INT8_C( -68),
                           INT8_C( 127), INT8_C(  63), INT8_C( -87), INT8_C( 127),
                           INT8_C( 127), INT8_C(  80), INT8_C(-128), INT8_C( -12),
                           INT8_C( 127), INT8_C( 110), INT8_C( -48), INT8_C( 127),
                           INT8_C(  19), INT8_C( 127), INT8_C(-128), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C( -80), INT8_C( 122), INT8_C(-100), INT8_C( 123),
                           INT8_C(  82), INT8_C(-107), INT8_C(  95), INT8_C( -80),
                           INT8_C(-115), INT8_C(-109), INT8_C(  60), INT8_C(  72),
                           INT8_C(  57), INT8_C(  99), INT8_C( -30), INT8_C(-115),
                           INT8_C(  69), INT8_C(  18), INT8_C(  -5), INT8_C(  -6),
                           INT8_C( -90), INT8_C( -20), INT8_C(  17), INT8_C( 121),
                           INT8_C(-100), INT8_C( -55), INT8_C(  90), INT8_C( -42),
                           INT8_C(-113), INT8_C( 119), INT8_C(  44), INT8_C(-123),
                           INT8_C( -39), INT8_C( 114), INT8_C(  37), INT8_C( -84),
                           INT8_C( -88), INT8_C(  15), INT8_C(  23), INT8_C( 114),
                           INT8_C(  63), INT8_C( -61), INT8_C(  22), INT8_C(   8),
                           INT8_C(  54), INT8_C(  19), INT8_C( -34), INT8_C(  18),
                           INT8_C( -36), INT8_C( 104), INT8_C(   1), INT8_C(   5),
                           INT8_C(-116), INT8_C(  79), INT8_C( -20), INT8_C(  -4),
                           INT8_C(  95), INT8_C( 103), INT8_C(   3), INT8_C(  64),
                           INT8_C(  34), INT8_C( -49), INT8_C( -27), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C(-116), INT8_C( -44), INT8_C( -44),
                           INT8_C(  67), INT8_C( -66), INT8_C(  77), INT8_C(  60),
                           INT8_C(  74), INT8_C( -19), INT8_C(-123), INT8_C( -81),
                           INT8_C( -74), INT8_C( -21), INT8_C( -32), INT8_C(-122),
                           INT8_C(-110), INT8_C( 116), INT8_C( 115), INT8_C(  99),
                           INT8_C(  29), INT8_C(  50), INT8_C(-119), INT8_C(-126),
                           INT8_C( -53), INT8_C(  68), INT8_C( -37), INT8_C(  84),
                           INT8_C(  23), INT8_C( -10), INT8_C(  15), INT8_C(  37),
                           INT8_C( -93), INT8_C(  57), INT8_C(  28), INT8_C(-116),
                           INT8_C(  56), INT8_C(-124), INT8_C( -93), INT8_C( -67),
                           INT8_C(  27), INT8_C(  -1), INT8_C( -70), INT8_C( -30),
                           INT8_C( -39), INT8_C(  59), INT8_C(  76), INT8_C( 108),
                           INT8_C(  13), INT8_C( -29), INT8_C(  60), INT8_C( 106),
                           INT8_C( 106), INT8_C( -77), INT8_C(-102), INT8_C(   3),
                           INT8_C( -18), INT8_C(  23), INT8_C( 113), INT8_C( -97),
                           INT8_C( 109), INT8_C(  81), INT8_C(  42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  17), INT8_C(   6), INT8_C(-128), INT8_C(  79),
                           INT8_C( 127), INT8_C(-128), INT8_C( 127), INT8_C( -20),
                           INT8_C( -41), INT8_C(-128), INT8_C( -63), INT8_C(  -9),
                           INT8_C( -17), INT8_C(  78), INT8_C( -62), INT8_C(-128),
                           INT8_C( -41), INT8_C( 127), INT8_C( 110), INT8_C(  93),
                           INT8_C( -61), INT8_C(  30), INT8_C(-102), INT8_C(  -5),
                           INT8_C(-128), INT8_C(  13), INT8_C(  53), INT8_C(  42),
                           INT8_C( -90), INT8_C( 109), INT8_C(  59), INT8_C( -86),
                           INT8_C(-128), INT8_C( 127), INT8_C(  65), INT8_C(-128),
                           INT8_C( -32), INT8_C(-109), INT8_C( -70), INT8_C(  47),
                           INT8_C(  90), INT8_C( -62), INT8_C( -48), INT8_C( -22),
                           INT8_C(  15), INT8_C(  78), INT8_C(  42), INT8_C( 126),
                           INT8_C( -23), INT8_C(  75), INT8_C(  61), INT8_C( 111),
                           INT8_C( -10), INT8_C(   2), INT8_C(-122), INT8_C(  -1),
                           INT8_C(  77), INT8_C( 126), INT8_C( 116), INT8_C( -33),
                           INT8_C( 127), INT8_C(  32), INT8_C(  15), INT8_C( 127)) },
    { simde_mm512_set_epi8(INT8_C( -94), INT8_C(  96), INT8_C( -77), INT8_C( -55),
                           INT8_C(  18), INT8_C(  12), INT8_C(  78), INT8_C( -17),
                           INT8_C( -94), INT8_C(  83), INT8_C( -20), INT8_C(-101),
                           INT8_C( -62), INT8_C( -62), INT8_C( -77), INT8_C(  21),
                           INT8_C(  21), INT8_C( -49), INT8_C(-127), INT8_C( -47),
                           INT8_C( -26), INT8_C(  62), INT8_C( -51), INT8_C( -34),
                           INT8_C(   9), INT8_C( -56), INT8_C(  63), INT8_C(   4),
                           INT8_C(  64), INT8_C(  46), INT8_C(  68), INT8_C( -18),
                           INT8_C(-110), INT8_C( 103), INT8_C(-101), INT8_C(  45),
                           INT8_C( -81), INT8_C( 125), INT8_C(   8), INT8_C(  72),
                           INT8_C( -48), INT8_C( -28), INT8_C( 102), INT8_C( -90),
                           INT8_C(-101), INT8_C( -40), INT8_C( -94), INT8_C(-127),
                           INT8_C( -36), INT8_C( -32), INT8_C(  34), INT8_C( -39),
                           INT8_C( -64), INT8_C( 111), INT8_C(  36), INT8_C(  91),
                           INT8_C(  90), INT8_C( -10), INT8_C(  88), INT8_C(-117),
                           INT8_C( 117), INT8_C(-111), INT8_C(-128), INT8_C( -35)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C(  -2), INT8_C(   4), INT8_C( -77),
                           INT8_C(  33), INT8_C(-119), INT8_C( -36), INT8_C(  95),
                           INT8_C( -54), INT8_C(  57), INT8_C( -15), INT8_C(  20),
                           INT8_C( 119), INT8_C( -56), INT8_C( -57), INT8_C(  22),
                           INT8_C( -23), INT8_C( -56), INT8_C( -77), INT8_C( 114),
                           INT8_C( -25), INT8_C(  85), INT8_C(  65), INT8_C( 124),
                           INT8_C(  80), INT8_C(  94), INT8_C(  -6), INT8_C(-128),
                           INT8_C(  25), INT8_C( -80), INT8_C(  31), INT8_C( -23),
                           INT8_C( 123), INT8_C(-123), INT8_C( -56), INT8_C(  34),
                           INT8_C(  72), INT8_C( -39), INT8_C( -17), INT8_C(  39),
                           INT8_C(  29), INT8_C( -88), INT8_C(  65), INT8_C(  81),
                           INT8_C(-120), INT8_C(  80), INT8_C( -76), INT8_C( -59),
                           INT8_C(  48), INT8_C( -90), INT8_C( -85), INT8_C(  82),
                           INT8_C( 115), INT8_C(-114), INT8_C(  84), INT8_C( -40),
                           INT8_C( -69), INT8_C( -11), INT8_C(-118), INT8_C(  39),
                           INT8_C( -17), INT8_C( -23), INT8_C(   4), INT8_C( -37)),
      simde_mm512_set_epi8(INT8_C( -29), INT8_C(  94), INT8_C( -73), INT8_C(-128),
                           INT8_C(  51), INT8_C(-107), INT8_C(  42), INT8_C(  78),
                           INT8_C(-128), INT8_C( 127), INT8_C( -35), INT8_C( -81),
                           INT8_C(  57), INT8_C(-118), INT8_C(-128), INT8_C(  43),
                           INT8_C(  -2), INT8_C(-105), INT8_C(-128), INT8_C(  67),
                           INT8_C( -51), INT8_C( 127), INT8_C(  14), INT8_C(  90),
                           INT8_C(  89), INT8_C(  38), INT8_C(  57), INT8_C(-124),
                           INT8_C(  89), INT8_C( -34), INT8_C(  99), INT8_C( -41),
                           INT8_C(  13), INT8_C( -20), INT8_C(-128), INT8_C(  79),
                           INT8_C(  -9), INT8_C(  86), INT8_C(  -9), INT8_C( 111),
                           INT8_C( -19), INT8_C(-116), INT8_C( 127), INT8_C(  -9),
                           INT8_C(-128), INT8_C(  40), INT8_C(-128), INT8_C(-128),
                           INT8_C(  12), INT8_C(-122), INT8_C( -51), INT8_C(  43),
                           INT8_C(  51), INT8_C(  -3), INT8_C( 120), INT8_C(  51),
                           INT8_C(  21), INT8_C( -21), INT8_C( -30), INT8_C( -78),
                           INT8_C( 100), INT8_C(-128), INT8_C(-124), INT8_C( -72)) },
    { simde_mm512_set_epi8(INT8_C(  31), INT8_C( -81), INT8_C( 115), INT8_C(  18),
                           INT8_C(  20), INT8_C( -33), INT8_C(-125), INT8_C( -45),
                           INT8_C(  54), INT8_C(  82), INT8_C(  61), INT8_C(  81),
                           INT8_C( 123), INT8_C(  18), INT8_C(  89), INT8_C(  34),
                           INT8_C(  10), INT8_C( -54), INT8_C( -24), INT8_C(  54),
                           INT8_C(  49), INT8_C( -70), INT8_C(   7), INT8_C( -12),
                           INT8_C( 110), INT8_C( -16), INT8_C( -10), INT8_C(   4),
                           INT8_C(   3), INT8_C( -17), INT8_C( -46), INT8_C( -29),
                           INT8_C(  26), INT8_C( -38), INT8_C(-107), INT8_C( -25),
                           INT8_C(  61), INT8_C(  -4), INT8_C( -21), INT8_C( -11),
                           INT8_C( -29), INT8_C(  62), INT8_C( 120), INT8_C(  84),
                           INT8_C( -48), INT8_C( -42), INT8_C( -15), INT8_C( -64),
                           INT8_C( -90), INT8_C( 111), INT8_C(-123), INT8_C(  61),
                           INT8_C(  22), INT8_C( -48), INT8_C(-107), INT8_C( 122),
                           INT8_C(  27), INT8_C( 119), INT8_C( -63), INT8_C( -61),
                           INT8_C( -69), INT8_C(  46), INT8_C(  34), INT8_C(-101)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( 101), INT8_C( -48), INT8_C( -49),
                           INT8_C(  63), INT8_C(  93), INT8_C( -48), INT8_C(-122),
                           INT8_C( -67), INT8_C(  27), INT8_C(   1), INT8_C( -55),
                           INT8_C( -79), INT8_C( -44), INT8_C(-115), INT8_C(-126),
                           INT8_C( -42), INT8_C(  29), INT8_C(  66), INT8_C( -83),
                           INT8_C( 108), INT8_C(  -1), INT8_C( -47), INT8_C(-104),
                           INT8_C(  62), INT8_C(  29), INT8_C(   4), INT8_C( -47),
                           INT8_C(  98), INT8_C(-109), INT8_C( -23), INT8_C(  69),
                           INT8_C(-110), INT8_C( -47), INT8_C(  48), INT8_C(-101),
                           INT8_C( -80), INT8_C(-110), INT8_C( -55), INT8_C(  25),
                           INT8_C(  39), INT8_C(  58), INT8_C(   4), INT8_C(-108),
                           INT8_C( -23), INT8_C( -79), INT8_C( 124), INT8_C(  36),
                           INT8_C( 113), INT8_C( 110), INT8_C( 105), INT8_C( 113),
                           INT8_C( -54), INT8_C( -63), INT8_C(  50), INT8_C( -99),
                           INT8_C(  -8), INT8_C( -76), INT8_C( 102), INT8_C(  51),
                           INT8_C(  58), INT8_C(  16), INT8_C( -94), INT8_C( -93)),
      simde_mm512_set_epi8(INT8_C(  75), INT8_C(  20), INT8_C(  67), INT8_C( -31),
                           INT8_C(  83), INT8_C(  60), INT8_C(-128), INT8_C(-128),
                           INT8_C( -13), INT8_C( 109), INT8_C(  62), INT8_C(  26),
                           INT8_C(  44), INT8_C( -26), INT8_C( -26), INT8_C( -92),
                           INT8_C( -32), INT8_C( -25), INT8_C(  42), INT8_C( -29),
                           INT8_C( 127), INT8_C( -71), INT8_C( -40), INT8_C(-116),
                           INT8_C( 127), INT8_C(  13), INT8_C(  -6), INT8_C( -43),
                           INT8_C( 101), INT8_C(-126), INT8_C( -69), INT8_C(  40),
                           INT8_C( -84), INT8_C( -85), INT8_C( -59), INT8_C(-126),
                           INT8_C( -19), INT8_C(-114), INT8_C( -76), INT8_C(  14),
                           INT8_C(  10), INT8_C( 120), INT8_C( 124), INT8_C( -24),
                           INT8_C( -71), INT8_C(-121), INT8_C( 109), INT8_C( -28),
                           INT8_C(  23), INT8_C( 127), INT8_C( -18), INT8_C( 127),
                           INT8_C( -32), INT8_C(-111), INT8_C( -57), INT8_C(  23),
                           INT8_C(  19), INT8_C(  43), INT8_C(  39), INT8_C( -10),
                           INT8_C( -11), INT8_C(  62), INT8_C( -60), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C(  64), INT8_C(  55), INT8_C(  97), INT8_C( -61),
                           INT8_C(  89), INT8_C( 120), INT8_C(  49), INT8_C( 124),
                           INT8_C(  16), INT8_C( 113), INT8_C(  48), INT8_C(  70),
                           INT8_C(  60), INT8_C( -11), INT8_C(  98), INT8_C(  70),
                           INT8_C( 111), INT8_C(  55), INT8_C( -50), INT8_C( -21),
                           INT8_C(-102), INT8_C(   3), INT8_C(  75), INT8_C(  -9),
                           INT8_C(  34), INT8_C(  96), INT8_C(-104), INT8_C(  37),
                           INT8_C(  74), INT8_C(  22), INT8_C(  13), INT8_C(  82),
                           INT8_C(-108), INT8_C(-112), INT8_C(  49), INT8_C( -58),
                           INT8_C( 116), INT8_C(  58), INT8_C( -29), INT8_C(  60),
                           INT8_C( 125), INT8_C( 105), INT8_C( -20), INT8_C(  -4),
                           INT8_C(-106), INT8_C(-111), INT8_C( -29), INT8_C( -32),
                           INT8_C( -43), INT8_C(-103), INT8_C(  84), INT8_C(  40),
                           INT8_C(  63), INT8_C(  88), INT8_C( -74), INT8_C( -49),
                           INT8_C(  10), INT8_C(  50), INT8_C(  38), INT8_C( 108),
                           INT8_C(  42), INT8_C( -40), INT8_C( -81), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 105), INT8_C( -15), INT8_C( -49),
                           INT8_C(  74), INT8_C( -31), INT8_C( -49), INT8_C( 112),
                           INT8_C(-103), INT8_C(  69), INT8_C( -55), INT8_C(-115),
                           INT8_C( -48), INT8_C(  96), INT8_C(  -8), INT8_C( -35),
                           INT8_C( -24), INT8_C( 101), INT8_C(  70), INT8_C( -69),
                           INT8_C(-105), INT8_C( -28), INT8_C( -38), INT8_C( -85),
                           INT8_C( -94), INT8_C(-122), INT8_C( -80), INT8_C(  95),
                           INT8_C(  -1), INT8_C(  87), INT8_C(  21), INT8_C(   6),
                           INT8_C(-103), INT8_C(  38), INT8_C(  15), INT8_C( -98),
                           INT8_C( -27), INT8_C(  57), INT8_C( -76), INT8_C(-112),
                           INT8_C(  77), INT8_C(  -3), INT8_C(  57), INT8_C(   3),
                           INT8_C( 123), INT8_C( -18), INT8_C( -90), INT8_C(-119),
                           INT8_C( 112), INT8_C(  61), INT8_C( -48), INT8_C( -16),
                           INT8_C( -36), INT8_C(-125), INT8_C( -10), INT8_C(  77),
                           INT8_C( 106), INT8_C(  72), INT8_C(  62), INT8_C( -24),
                           INT8_C( -65), INT8_C( 102), INT8_C(-122), INT8_C(  19)),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C( 127), INT8_C(  82), INT8_C(-110),
                           INT8_C( 127), INT8_C(  89), INT8_C(   0), INT8_C( 127),
                           INT8_C( -87), INT8_C( 127), INT8_C(  -7), INT8_C( -45),
                           INT8_C(  12), INT8_C(  85), INT8_C(  90), INT8_C(  35),
                           INT8_C(  87), INT8_C( 127), INT8_C(  20), INT8_C( -90),
                           INT8_C(-128), INT8_C( -25), INT8_C(  37), INT8_C( -94),
                           INT8_C( -60), INT8_C( -26), INT8_C(-128), INT8_C( 127),
                           INT8_C(  73), INT8_C( 109), INT8_C(  34), INT8_C(  88),
                           INT8_C(-128), INT8_C( -74), INT8_C(  64), INT8_C(-128),
                           INT8_C(  89), INT8_C( 115), INT8_C(-105), INT8_C( -52),
                           INT8_C( 127), INT8_C( 102), INT8_C(  37), INT8_C(  -1),
                           INT8_C(  17), INT8_C(-128), INT8_C(-119), INT8_C(-128),
                           INT8_C(  69), INT8_C( -42), INT8_C(  36), INT8_C(  24),
                           INT8_C(  27), INT8_C( -37), INT8_C( -84), INT8_C(  28),
                           INT8_C( 116), INT8_C( 122), INT8_C( 100), INT8_C(  84),
                           INT8_C( -23), INT8_C(  62), INT8_C(-128), INT8_C(  50)) },
    { simde_mm512_set_epi8(INT8_C(  90), INT8_C(-125), INT8_C(  -5), INT8_C( -69),
                           INT8_C( 103), INT8_C( -40), INT8_C(  35), INT8_C( -38),
                           INT8_C( 107), INT8_C(-117), INT8_C( -80), INT8_C( 123),
                           INT8_C(  57), INT8_C( -70), INT8_C( -34), INT8_C(  38),
                           INT8_C( 114), INT8_C(-126), INT8_C(  20), INT8_C( -93),
                           INT8_C(  17), INT8_C(-128), INT8_C(   2), INT8_C(  15),
                           INT8_C(-122), INT8_C( -10), INT8_C(  -2), INT8_C(  84),
                           INT8_C(  93), INT8_C(  89), INT8_C(  57), INT8_C( -50),
                           INT8_C(   4), INT8_C( -63), INT8_C( 118), INT8_C(  19),
                           INT8_C( -68), INT8_C( -29), INT8_C( -16), INT8_C( -30),
                           INT8_C( -76), INT8_C(-110), INT8_C( 121), INT8_C(  87),
                           INT8_C(-117), INT8_C(-113), INT8_C( -94), INT8_C(  61),
                           INT8_C( -29), INT8_C(  43), INT8_C( -69), INT8_C( 123),
                           INT8_C(  79), INT8_C(-101), INT8_C(  40), INT8_C(  64),
                           INT8_C(  34), INT8_C(-102), INT8_C(  77), INT8_C( 114),
                           INT8_C( -49), INT8_C( -31), INT8_C( 103), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(-125), INT8_C( -96), INT8_C(-111),
                           INT8_C(  23), INT8_C(  58), INT8_C(  -5), INT8_C( -22),
                           INT8_C( -80), INT8_C( -90), INT8_C( -33), INT8_C( -65),
                           INT8_C( -34), INT8_C( 100), INT8_C( -10), INT8_C( -57),
                           INT8_C(  37), INT8_C(  -9), INT8_C( -29), INT8_C(-114),
                           INT8_C(-102), INT8_C(  53), INT8_C( 107), INT8_C( 124),
                           INT8_C( -12), INT8_C( -57), INT8_C( -57), INT8_C( -37),
                           INT8_C(  50), INT8_C(  22), INT8_C( -71), INT8_C(  -2),
                           INT8_C( -31), INT8_C(  60), INT8_C(  62), INT8_C(  19),
                           INT8_C( 117), INT8_C(   1), INT8_C( -26), INT8_C(-100),
                           INT8_C(  29), INT8_C(  -6), INT8_C(   7), INT8_C(-100),
                           INT8_C(-120), INT8_C( -33), INT8_C(  17), INT8_C(-103),
                           INT8_C(  10), INT8_C( -45), INT8_C( -76), INT8_C(  10),
                           INT8_C( -10), INT8_C(  15), INT8_C(  36), INT8_C(   2),
                           INT8_C(  74), INT8_C(  44), INT8_C( -16), INT8_C( 122),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -27), INT8_C( -15)),
      simde_mm512_set_epi8(INT8_C( 124), INT8_C(-128), INT8_C(-101), INT8_C(-128),
                           INT8_C( 126), INT8_C(  18), INT8_C(  30), INT8_C( -60),
                           INT8_C(  27), INT8_C(-128), INT8_C(-113), INT8_C(  58),
                           INT8_C(  23), INT8_C(  30), INT8_C( -44), INT8_C( -19),
                           INT8_C( 127), INT8_C(-128), INT8_C(  -9), INT8_C(-128),
                           INT8_C( -85), INT8_C( -75), INT8_C( 109), INT8_C( 127),
                           INT8_C(-128), INT8_C( -67), INT8_C( -59), INT8_C(  47),
                           INT8_C( 127), INT8_C( 111), INT8_C( -14), INT8_C( -52),
                           INT8_C( -27), INT8_C(  -3), INT8_C( 127), INT8_C(  38),
                           INT8_C(  49), INT8_C( -28), INT8_C( -42), INT8_C(-128),
                           INT8_C( -47), INT8_C(-116), INT8_C( 127), INT8_C( -13),
                           INT8_C(-128), INT8_C(-128), INT8_C( -77), INT8_C( -42),
                           INT8_C( -19), INT8_C(  -2), INT8_C(-128), INT8_C( 127),
                           INT8_C(  69), INT8_C( -86), INT8_C(  76), INT8_C(  66),
                           INT8_C( 108), INT8_C( -58), INT8_C(  61), INT8_C( 127),
                           INT8_C( -53), INT8_C( -16), INT8_C(  76), INT8_C(  66)) },
    { simde_mm512_set_epi8(INT8_C( -52), INT8_C(-111), INT8_C(  67), INT8_C( -14),
                           INT8_C(  11), INT8_C( -63), INT8_C( -35), INT8_C( -86),
                           INT8_C(-114), INT8_C( -97), INT8_C( 124), INT8_C( -30),
                           INT8_C(  -1), INT8_C(  55), INT8_C(  84), INT8_C(  12),
                           INT8_C(  86), INT8_C( -43), INT8_C(  81), INT8_C( -30),
                           INT8_C( -25), INT8_C(  74), INT8_C(-105), INT8_C(  11),
                           INT8_C( -97), INT8_C(   0), INT8_C(  98), INT8_C( 106),
                           INT8_C( -83), INT8_C( -89), INT8_C(  16), INT8_C( -42),
                           INT8_C(  81), INT8_C(  35), INT8_C(-127), INT8_C(-127),
                           INT8_C( -38), INT8_C(  51), INT8_C( -75), INT8_C(  24),
                           INT8_C(  86), INT8_C( -37), INT8_C(  97), INT8_C( -82),
                           INT8_C( 109), INT8_C(  21), INT8_C( 127), INT8_C(  16),
                           INT8_C( 101), INT8_C( -69), INT8_C(  95), INT8_C(-121),
                           INT8_C( -66), INT8_C(  39), INT8_C( 104), INT8_C(-109),
                           INT8_C(  -1), INT8_C(  35), INT8_C(  68), INT8_C(  93),
                           INT8_C( -25), INT8_C( 120), INT8_C( -19), INT8_C(  84)),
      simde_mm512_set_epi8(INT8_C(-111), INT8_C(-108), INT8_C( 102), INT8_C( -40),
                           INT8_C(-124), INT8_C( -61), INT8_C(  80), INT8_C( 102),
                           INT8_C( -35), INT8_C(   3), INT8_C( -76), INT8_C(  98),
                           INT8_C(   9), INT8_C( -39), INT8_C( -24), INT8_C( -92),
                           INT8_C( -73), INT8_C( -19), INT8_C(-103), INT8_C( -41),
                           INT8_C( -32), INT8_C(  -8), INT8_C( 126), INT8_C(  75),
                           INT8_C( -64), INT8_C( -26), INT8_C( -15), INT8_C( -35),
                           INT8_C( -20), INT8_C(  -6), INT8_C(  86), INT8_C( -56),
                           INT8_C( -56), INT8_C(  67), INT8_C(  59), INT8_C( -73),
                           INT8_C(  35), INT8_C( -67), INT8_C(  92), INT8_C(  34),
                           INT8_C(  16), INT8_C( -12), INT8_C(  44), INT8_C( -59),
                           INT8_C( -82), INT8_C(-102), INT8_C(  93), INT8_C( -43),
                           INT8_C(  79), INT8_C( -19), INT8_C( -45), INT8_C( -87),
                           INT8_C( -50), INT8_C( -23), INT8_C( -17), INT8_C( 110),
                           INT8_C( 102), INT8_C( -59), INT8_C(-117), INT8_C(  84),
                           INT8_C( -75), INT8_C(  87), INT8_C(  69), INT8_C(  -6)),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C( -54),
                           INT8_C(-113), INT8_C(-124), INT8_C(  45), INT8_C(  16),
                           INT8_C(-128), INT8_C( -94), INT8_C(  48), INT8_C(  68),
                           INT8_C(   8), INT8_C(  16), INT8_C(  60), INT8_C( -80),
                           INT8_C(  13), INT8_C( -62), INT8_C( -22), INT8_C( -71),
                           INT8_C( -57), INT8_C(  66), INT8_C(  21), INT8_C(  86),
                           INT8_C(-128), INT8_C( -26), INT8_C(  83), INT8_C(  71),
                           INT8_C(-103), INT8_C( -95), INT8_C( 102), INT8_C( -98),
                           INT8_C(  25), INT8_C( 102), INT8_C( -68), INT8_C(-128),
                           INT8_C(  -3), INT8_C( -16), INT8_C(  17), INT8_C(  58),
                           INT8_C( 102), INT8_C( -49), INT8_C( 127), INT8_C(-128),
                           INT8_C(  27), INT8_C( -81), INT8_C( 127), INT8_C( -27),
                           INT8_C( 127), INT8_C( -88), INT8_C(  50), INT8_C(-128),
                           INT8_C(-116), INT8_C(  16), INT8_C(  87), INT8_C(   1),
                           INT8_C( 101), INT8_C( -24), INT8_C( -49), INT8_C( 127),
                           INT8_C(-100), INT8_C( 127), INT8_C(  50), INT8_C(  78)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(  5952), INT16_C(-21138), INT16_C( 23605), INT16_C( -3799),
                            INT16_C(  1987), INT16_C( 29254), INT16_C( -4184), INT16_C( 13346),
                            INT16_C( 26203), INT16_C(-24373), INT16_C( 15487), INT16_C( 15569),
                            INT16_C( 13821), INT16_C( -3315), INT16_C( 30667), INT16_C(  9811),
                            INT16_C( 22769), INT16_C( 21964), INT16_C(  -315), INT16_C(-15723),
                            INT16_C( -9658), INT16_C(-27088), INT16_C( 18289), INT16_C( 13213),
                            INT16_C(-12712), INT16_C( 23293), INT16_C( 12497), INT16_C( 16576),
                            INT16_C(-19358), INT16_C(-11263), INT16_C( -3745), INT16_C(  7925)),
      simde_mm512_set_epi16(INT16_C(-22600), INT16_C(  9825), INT16_C( 27347), INT16_C( -4649),
                            INT16_C(  4812), INT16_C( 27489), INT16_C( 14729), INT16_C(-20872),
                            INT16_C(-24487), INT16_C( 23053), INT16_C( 28966), INT16_C(-23890),
                            INT16_C( -9737), INT16_C(-24021), INT16_C( 12009), INT16_C(-16892),
                            INT16_C(-11018), INT16_C( -7664), INT16_C( 22598), INT16_C(  9112),
                            INT16_C(  -468), INT16_C(-16246), INT16_C( 11633), INT16_C(  3402),
                            INT16_C( 12940), INT16_C(-18453), INT16_C(-10463), INT16_C(-24372),
                            INT16_C(  9722), INT16_C(  4912), INT16_C( 14086), INT16_C( -2976)),
      simde_mm512_set_epi16(INT16_C(-16648), INT16_C(-11313), INT16_C( 32767), INT16_C( -8448),
                            INT16_C(  6799), INT16_C( 32767), INT16_C( 10545), INT16_C( -7526),
                            INT16_C(  1716), INT16_C( -1320), INT16_C( 32767), INT16_C( -8321),
                            INT16_C(  4084), INT16_C(-27336), INT16_C( 32767), INT16_C( -7081),
                            INT16_C( 11751), INT16_C( 14300), INT16_C( 22283), INT16_C( -6611),
                            INT16_C(-10126), INT16_C(-32768), INT16_C( 29922), INT16_C( 16615),
                            INT16_C(   228), INT16_C(  4840), INT16_C(  2034), INT16_C( -7796),
                            INT16_C( -9636), INT16_C( -6351), INT16_C( 10341), INT16_C(  4949)) },
    { simde_mm512_set_epi16(INT16_C(-21870), INT16_C( -1966), INT16_C(-26101), INT16_C(  8905),
                            INT16_C(-13069), INT16_C( 13555), INT16_C(-23554), INT16_C(-12947),
                            INT16_C( 31779), INT16_C( 21013), INT16_C( 32688), INT16_C( 12512),
                            INT16_C(-26721), INT16_C(  7598), INT16_C( 21566), INT16_C(-11203),
                            INT16_C( 27021), INT16_C( -8539), INT16_C(  -532), INT16_C(-17200),
                            INT16_C(-18609), INT16_C(-30604), INT16_C(  6829), INT16_C(-13538),
                            INT16_C( 21529), INT16_C( 29340), INT16_C( 23176), INT16_C( 10860),
                            INT16_C( 31408), INT16_C(  3656), INT16_C(-30572), INT16_C( -4393)),
      simde_mm512_set_epi16(INT16_C( 29137), INT16_C( 29112), INT16_C(-21893), INT16_C( 14830),
                            INT16_C( 28350), INT16_C( 21222), INT16_C( 26922), INT16_C( 26197),
                            INT16_C(-25881), INT16_C( 28163), INT16_C(-19268), INT16_C( 10158),
                            INT16_C(-29245), INT16_C( 16103), INT16_C(-23323), INT16_C( 12478),
                            INT16_C( -6515), INT16_C( 24007), INT16_C(-28366), INT16_C(-32677),
                            INT16_C(-27350), INT16_C(-26916), INT16_C(-11979), INT16_C( 13820),
                            INT16_C(-22393), INT16_C(-20903), INT16_C( -9892), INT16_C(-22447),
                            INT16_C(-14286), INT16_C(  3532), INT16_C( 19664), INT16_C(-26842)),
      simde_mm512_set_epi16(INT16_C(  7267), INT16_C( 27146), INT16_C(-32768), INT16_C( 23735),
                            INT16_C( 15281), INT16_C( 32767), INT16_C(  3368), INT16_C( 13250),
                            INT16_C(  5898), INT16_C( 32767), INT16_C( 13420), INT16_C( 22670),
                            INT16_C(-32768), INT16_C( 23701), INT16_C( -1757), INT16_C(  1275),
                            INT16_C( 20506), INT16_C( 15468), INT16_C(-28898), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( -5150), INT16_C(   282),
                            INT16_C(  -864), INT16_C(  8437), INT16_C( 13284), INT16_C(-11587),
                            INT16_C( 17122), INT16_C(  7188), INT16_C(-10908), INT16_C(-31235)) },
    { simde_mm512_set_epi16(INT16_C(-22689), INT16_C( 25207), INT16_C( -9300), INT16_C( 28977),
                            INT16_C(  2270), INT16_C(-32394), INT16_C( 26182), INT16_C( 23367),
                            INT16_C( 31661), INT16_C(  9636), INT16_C(-18580), INT16_C(-28875),
                            INT16_C(-25943), INT16_C( 14067), INT16_C( 10599), INT16_C( 30831),
                            INT16_C(-23557), INT16_C( 11377), INT16_C( -4608), INT16_C( 14955),
                            INT16_C( 11781), INT16_C(-12602), INT16_C( -3223), INT16_C( 11440),
                            INT16_C( -2896), INT16_C(-24304), INT16_C( 29156), INT16_C( -4347),
                            INT16_C( -2421), INT16_C( 31033), INT16_C( -3132), INT16_C(-19324)),
      simde_mm512_set_epi16(INT16_C( -2724), INT16_C(  4704), INT16_C( 23772), INT16_C(-20368),
                            INT16_C(-30374), INT16_C( 15838), INT16_C( 19402), INT16_C( 16976),
                            INT16_C(-28476), INT16_C( -2715), INT16_C(-27679), INT16_C( -8608),
                            INT16_C(-20120), INT16_C( 29206), INT16_C( -1643), INT16_C(-29856),
                            INT16_C( 18656), INT16_C( -9660), INT16_C( -4660), INT16_C(-30272),
                            INT16_C(   610), INT16_C( -3787), INT16_C( 22038), INT16_C(-29446),
                            INT16_C(-26504), INT16_C(-28984), INT16_C(-21830), INT16_C(-27507),
                            INT16_C( 24148), INT16_C(-12945), INT16_C( 24529), INT16_C(  7913)),
      simde_mm512_set_epi16(INT16_C(-25413), INT16_C( 29911), INT16_C( 14472), INT16_C(  8609),
                            INT16_C(-28104), INT16_C(-16556), INT16_C( 32767), INT16_C( 32767),
                            INT16_C(  3185), INT16_C(  6921), INT16_C(-32768), INT16_C(-32768),
                            INT16_C(-32768), INT16_C( 32767), INT16_C(  8956), INT16_C(   975),
                            INT16_C( -4901), INT16_C(  1717), INT16_C( -9268), INT16_C(-15317),
                            INT16_C( 12391), INT16_C(-16389), INT16_C( 18815), INT16_C(-18006),
                            INT16_C(-29400), INT16_C(-32768), INT16_C(  7326), INT16_C(-31854),
                            INT16_C( 21727), INT16_C( 18088), INT16_C( 21397), INT16_C(-11411)) },
    { simde_mm512_set_epi16(INT16_C(-18069), INT16_C( 21685), INT16_C( -5808), INT16_C( 24672),
                            INT16_C( -8190), INT16_C( -2830), INT16_C(-23214), INT16_C(  1083),
                            INT16_C(  6699), INT16_C(   871), INT16_C(-14072), INT16_C( -2337),
                            INT16_C( 13356), INT16_C(  7260), INT16_C(-23788), INT16_C(-19723),
                            INT16_C( 13480), INT16_C(-15429), INT16_C(-20153), INT16_C( 18680),
                            INT16_C(-26180), INT16_C( 27923), INT16_C(-14099), INT16_C( 25829),
                            INT16_C(-27481), INT16_C( 21639), INT16_C( 16654), INT16_C( 19972),
                            INT16_C( 15776), INT16_C( 23126), INT16_C( 30799), INT16_C(-14043)),
      simde_mm512_set_epi16(INT16_C( 16111), INT16_C(-26103), INT16_C( -8800), INT16_C(-24747),
                            INT16_C( 27941), INT16_C(   603), INT16_C( -8112), INT16_C(-28325),
                            INT16_C( -6110), INT16_C(-15530), INT16_C(  -938), INT16_C(-26515),
                            INT16_C( -2492), INT16_C( 16124), INT16_C(-27181), INT16_C( -3573),
                            INT16_C( 11652), INT16_C( 11646), INT16_C(  6964), INT16_C( 27675),
                            INT16_C( 13103), INT16_C( -2742), INT16_C( 27906), INT16_C( -1077),
                            INT16_C(-30636), INT16_C(-23050), INT16_C(  8363), INT16_C( 31350),
                            INT16_C( -4750), INT16_C(  -220), INT16_C( -8954), INT16_C( 15617)),
      simde_mm512_set_epi16(INT16_C( -1958), INT16_C( -4418), INT16_C(-14608), INT16_C(   -75),
                            INT16_C( 19751), INT16_C( -2227), INT16_C(-31326), INT16_C(-27242),
                            INT16_C(   589), INT16_C(-14659), INT16_C(-15010), INT16_C(-28852),
                            INT16_C( 10864), INT16_C( 23384), INT16_C(-32768), INT16_C(-23296),
                            INT16_C( 25132), INT16_C( -3783), INT16_C(-13189), INT16_C( 32767),
                            INT16_C(-13077), INT16_C( 25181), INT16_C( 13807), INT16_C( 24752),
                            INT16_C(-32768), INT16_C( -1411), INT16_C( 25017), INT16_C( 32767),
                            INT16_C( 11026), INT16_C( 22906), INT16_C( 21845), INT16_C(  1574)) },
    { simde_mm512_set_epi16(INT16_C( 25180), INT16_C(-32332), INT16_C(-18604), INT16_C(-25763),
                            INT16_C( 28237), INT16_C(-22027), INT16_C( 18301), INT16_C( 27599),
                            INT16_C( 11815), INT16_C(-14839), INT16_C(-13552), INT16_C( -6300),
                            INT16_C(-30211), INT16_C(-25552), INT16_C(  7375), INT16_C(  5267),
                            INT16_C(-14761), INT16_C(-28375), INT16_C(-32756), INT16_C( 13128),
                            INT16_C( 17683), INT16_C( -4430), INT16_C( -1805), INT16_C(-17763),
                            INT16_C(   206), INT16_C( 15851), INT16_C(  1078), INT16_C( 27402),
                            INT16_C(-15177), INT16_C(  5068), INT16_C(-15079), INT16_C(-13584)),
      simde_mm512_set_epi16(INT16_C( -3533), INT16_C( -3885), INT16_C(   789), INT16_C( -3755),
                            INT16_C(  3668), INT16_C( 19955), INT16_C(-22356), INT16_C(  8403),
                            INT16_C(-16920), INT16_C( 15195), INT16_C( -1853), INT16_C(-12121),
                            INT16_C(  5095), INT16_C( -9909), INT16_C(   574), INT16_C( 31911),
                            INT16_C( -1319), INT16_C( -2880), INT16_C(-31000), INT16_C(-30829),
                            INT16_C(-12917), INT16_C( 21541), INT16_C( 27413), INT16_C(-28040),
                            INT16_C(-19236), INT16_C(-24178), INT16_C(-29369), INT16_C( -3607),
                            INT16_C( -2666), INT16_C(-13470), INT16_C(  4416), INT16_C( 23850)),
      simde_mm512_set_epi16(INT16_C( 21647), INT16_C(-32768), INT16_C(-17815), INT16_C(-29518),
                            INT16_C( 31905), INT16_C( -2072), INT16_C( -4055), INT16_C( 32767),
                            INT16_C( -5105), INT16_C(   356), INT16_C(-15405), INT16_C(-18421),
                            INT16_C(-25116), INT16_C(-32768), INT16_C(  7949), INT16_C( 32767),
                            INT16_C(-16080), INT16_C(-31255), INT16_C(-32768), INT16_C(-17701),
                            INT16_C(  4766), INT16_C( 17111), INT16_C( 25608), INT16_C(-32768),
                            INT16_C(-19030), INT16_C( -8327), INT16_C(-28291), INT16_C( 23795),
                            INT16_C(-17843), INT16_C( -8402), INT16_C(-10663), INT16_C( 10266)) },
    { simde_mm512_set_epi16(INT16_C( 11424), INT16_C( 29699), INT16_C( 29618), INT16_C(-29898),
                            INT16_C(-23079), INT16_C( -6822), INT16_C( -7340), INT16_C(-12296),
                            INT16_C( 17833), INT16_C( -2043), INT16_C(-29766), INT16_C( 30776),
                            INT16_C(-18161), INT16_C(-32768), INT16_C(-31882), INT16_C(  3163),
                            INT16_C( 20808), INT16_C(-24577), INT16_C(  7685), INT16_C(  6279),
                            INT16_C(-27880), INT16_C( 27718), INT16_C(-18275), INT16_C( 24470),
                            INT16_C(  8834), INT16_C( 20594), INT16_C( 23052), INT16_C(-18860),
                            INT16_C(  7784), INT16_C(-16668), INT16_C(-30440), INT16_C(  6387)),
      simde_mm512_set_epi16(INT16_C( 15054), INT16_C(-23448), INT16_C(   866), INT16_C(-23509),
                            INT16_C(    -2), INT16_C(  6267), INT16_C(-15891), INT16_C(-24685),
                            INT16_C( 17511), INT16_C(  7218), INT16_C(-13659), INT16_C(-27162),
                            INT16_C( 10378), INT16_C(-16488), INT16_C(-11578), INT16_C(-27832),
                            INT16_C(-17566), INT16_C(-29377), INT16_C( -2221), INT16_C( 18656),
                            INT16_C(  7516), INT16_C(-30776), INT16_C(-19010), INT16_C( 26269),
                            INT16_C(-18451), INT16_C( 31467), INT16_C(-22066), INT16_C( 30155),
                            INT16_C( -3394), INT16_C( -6131), INT16_C( 13533), INT16_C( 21770)),
      simde_mm512_set_epi16(INT16_C( 26478), INT16_C(  6251), INT16_C( 30484), INT16_C(-32768),
                            INT16_C(-23081), INT16_C(  -555), INT16_C(-23231), INT16_C(-32768),
                            INT16_C( 32767), INT16_C(  5175), INT16_C(-32768), INT16_C(  3614),
                            INT16_C( -7783), INT16_C(-32768), INT16_C(-32768), INT16_C(-24669),
                            INT16_C(  3242), INT16_C(-32768), INT16_C(  5464), INT16_C( 24935),
                            INT16_C(-20364), INT16_C( -3058), INT16_C(-32768), INT16_C( 32767),
                            INT16_C( -9617), INT16_C( 32767), INT16_C(   986), INT16_C( 11295),
                            INT16_C(  4390), INT16_C(-22799), INT16_C(-16907), INT16_C( 28157)) },
    { simde_mm512_set_epi16(INT16_C( 11108), INT16_C(  5360), INT16_C(  8246), INT16_C(  2034),
                            INT16_C(  1485), INT16_C( 28421), INT16_C( 17428), INT16_C(-13900),
                            INT16_C(  4889), INT16_C( 17148), INT16_C( 13806), INT16_C(-26968),
                            INT16_C( -7783), INT16_C( 11345), INT16_C( 17472), INT16_C( 26483),
                            INT16_C(-10340), INT16_C( -7816), INT16_C( 22407), INT16_C( 32028),
                            INT16_C( 18301), INT16_C(-30148), INT16_C( -4736), INT16_C(-10574),
                            INT16_C( 10686), INT16_C( -5463), INT16_C( 19858), INT16_C( -4320),
                            INT16_C(-28154), INT16_C(  8984), INT16_C( 32741), INT16_C( 29052)),
      simde_mm512_set_epi16(INT16_C(-22772), INT16_C(-14596), INT16_C( -9458), INT16_C(  2054),
                            INT16_C(-24090), INT16_C(  1808), INT16_C(  9897), INT16_C( 20003),
                            INT16_C( 21444), INT16_C(  8548), INT16_C( -1773), INT16_C(  8905),
                            INT16_C( 14811), INT16_C(  5752), INT16_C(-17876), INT16_C( -7032),
                            INT16_C(-19669), INT16_C(-30631), INT16_C(-19220), INT16_C( 18906),
                            INT16_C( 15935), INT16_C(  2767), INT16_C(-30937), INT16_C( 13780),
                            INT16_C( 28270), INT16_C( 29263), INT16_C( 11106), INT16_C( 19546),
                            INT16_C( 16947), INT16_C(-29470), INT16_C( -1882), INT16_C(-19990)),
      simde_mm512_set_epi16(INT16_C(-11664), INT16_C( -9236), INT16_C( -1212), INT16_C(  4088),
                            INT16_C(-22605), INT16_C( 30229), INT16_C( 27325), INT16_C(  6103),
                            INT16_C( 26333), INT16_C( 25696), INT16_C( 12033), INT16_C(-18063),
                            INT16_C(  7028), INT16_C( 17097), INT16_C(  -404), INT16_C( 19451),
                            INT16_C(-30009), INT16_C(-32768), INT16_C(  3187), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(-27381), INT16_C(-32768), INT16_C(  3206),
                            INT16_C( 32767), INT16_C( 23800), INT16_C( 30964), INT16_C( 15226),
                            INT16_C(-11207), INT16_C(-20486), INT16_C( 30859), INT16_C(  9062)) },
    { simde_mm512_set_epi16(INT16_C(-30561), INT16_C( -5745), INT16_C( 32288), INT16_C( 11324),
                            INT16_C(-18220), INT16_C(-24874), INT16_C(-10154), INT16_C( 15837),
                            INT16_C( 22748), INT16_C(  6197), INT16_C( 23429), INT16_C(-23495),
                            INT16_C( -9809), INT16_C(-19367), INT16_C(-10631), INT16_C( -3845),
                            INT16_C( -5637), INT16_C(-22436), INT16_C(  6126), INT16_C( 16975),
                            INT16_C(  5830), INT16_C( 26963), INT16_C(-12238), INT16_C( 18631),
                            INT16_C(-23641), INT16_C(-17151), INT16_C(-13103), INT16_C(  5981),
                            INT16_C( 25710), INT16_C( 32081), INT16_C(-26911), INT16_C(-20494)),
      simde_mm512_set_epi16(INT16_C( 30869), INT16_C(-18069), INT16_C(  6380), INT16_C(-23760),
                            INT16_C( -6614), INT16_C( 32014), INT16_C( -2152), INT16_C( 25253),
                            INT16_C( -8172), INT16_C(-22416), INT16_C(  2949), INT16_C(  5712),
                            INT16_C( 30074), INT16_C( 20521), INT16_C( 28471), INT16_C( -3867),
                            INT16_C( -3892), INT16_C( 21304), INT16_C(  2611), INT16_C(  5827),
                            INT16_C(-30009), INT16_C( 31479), INT16_C(-19390), INT16_C(  1047),
                            INT16_C(-19967), INT16_C( 11404), INT16_C( 25909), INT16_C(  6741),
                            INT16_C(  1933), INT16_C(-26599), INT16_C(-25469), INT16_C(-30351)),
      simde_mm512_set_epi16(INT16_C(   308), INT16_C(-23814), INT16_C( 32767), INT16_C(-12436),
                            INT16_C(-24834), INT16_C(  7140), INT16_C(-12306), INT16_C( 32767),
                            INT16_C( 14576), INT16_C(-16219), INT16_C( 26378), INT16_C(-17783),
                            INT16_C( 20265), INT16_C(  1154), INT16_C( 17840), INT16_C( -7712),
                            INT16_C( -9529), INT16_C( -1132), INT16_C(  8737), INT16_C( 22802),
                            INT16_C(-24179), INT16_C( 32767), INT16_C(-31628), INT16_C( 19678),
                            INT16_C(-32768), INT16_C( -5747), INT16_C( 12806), INT16_C( 12722),
                            INT16_C( 27643), INT16_C(  5482), INT16_C(-32768), INT16_C(-32768)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 52), UINT8_C( 29), UINT8_C( 31), UINT8_C(206),
                             UINT8_C( 40), UINT8_C(160), UINT8_C(244), UINT8_C( 85),
                             UINT8_C( 47), UINT8_C(153), UINT8_C(218), UINT8_C(226),
                             UINT8_C( 99), UINT8_C(129), UINT8_C( 68), UINT8_C(218),
                             UINT8_C(122), UINT8_C( 56), UINT8_C(240), UINT8_C( 10),
                             UINT8_C(228), UINT8_C( 40), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C( 67), UINT8_C( 37), UINT8_C( 87), UINT8_C(131),
                             UINT8_C( 29), UINT8_C(175), UINT8_C(167), UINT8_C(223),
                             UINT8_C(170), UINT8_C( 76), UINT8_C( 39), UINT8_C(254),
                             UINT8_C(222), UINT8_C(105), UINT8_C(193), UINT8_C(144),
                             UINT8_C(182), UINT8_C(106), UINT8_C(199), UINT8_C(161),
                             UINT8_C(173), UINT8_C( 65), UINT8_C( 54), UINT8_C(148),
                             UINT8_C(222), UINT8_C(  9), UINT8_C(237), UINT8_C( 76),
                             UINT8_C(149), UINT8_C(196), UINT8_C(194), UINT8_C(114),
                             UINT8_C(167), UINT8_C( 47), UINT8_C(174), UINT8_C(135),
                             UINT8_C(170), UINT8_C(  1), UINT8_C( 40), UINT8_C( 68)),
      simde_x_mm512_set_epu8(UINT8_C(183), UINT8_C(129), UINT8_C(214), UINT8_C( 34),
                             UINT8_C(187), UINT8_C(142), UINT8_C(238), UINT8_C(248),
                             UINT8_C(175), UINT8_C(127), UINT8_C(231), UINT8_C(164),
                             UINT8_C( 16), UINT8_C(128), UINT8_C( 32), UINT8_C( 28),
                             UINT8_C(111), UINT8_C( 40), UINT8_C(  8), UINT8_C(160),
                             UINT8_C( 37), UINT8_C(193), UINT8_C(195), UINT8_C(135),
                             UINT8_C(102), UINT8_C( 87), UINT8_C(146), UINT8_C(206),
                             UINT8_C( 94), UINT8_C(109), UINT8_C(112), UINT8_C( 83),
                             UINT8_C( 63), UINT8_C(215), UINT8_C( 46), UINT8_C( 55),
                             UINT8_C( 78), UINT8_C(211), UINT8_C(175), UINT8_C(210),
                             UINT8_C( 60), UINT8_C(205), UINT8_C(118), UINT8_C(142),
                             UINT8_C(109), UINT8_C( 48), UINT8_C( 54), UINT8_C( 54),
                             UINT8_C( 99), UINT8_C(248), UINT8_C(120), UINT8_C(165),
                             UINT8_C(189), UINT8_C(132), UINT8_C(130), UINT8_C( 16),
                             UINT8_C(  6), UINT8_C(104), UINT8_C(176), UINT8_C(111),
                             UINT8_C(254), UINT8_C(193), UINT8_C(106), UINT8_C(  5)),
      simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C(158), UINT8_C(245), UINT8_C(240),
                             UINT8_C(227), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(222), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(115), UINT8_C(255), UINT8_C(100), UINT8_C(246),
                             UINT8_C(233), UINT8_C( 96), UINT8_C(248), UINT8_C(170),
                             UINT8_C(255), UINT8_C(233), UINT8_C(255), UINT8_C(149),
                             UINT8_C(169), UINT8_C(124), UINT8_C(233), UINT8_C(255),
                             UINT8_C(123), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C( 85), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(242), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(113), UINT8_C(108), UINT8_C(202),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(241),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(130),
                             UINT8_C(173), UINT8_C(151), UINT8_C(255), UINT8_C(246),
                             UINT8_C(255), UINT8_C(194), UINT8_C(146), UINT8_C( 73)) },
    { simde_x_mm512_set_epu8(UINT8_C( 38), UINT8_C(254), UINT8_C(204), UINT8_C( 72),
                             UINT8_C(177), UINT8_C( 63), UINT8_C( 67), UINT8_C( 50),
                             UINT8_C( 71), UINT8_C(226), UINT8_C(146), UINT8_C(  4),
                             UINT8_C(134), UINT8_C( 91), UINT8_C(195), UINT8_C(148),
                             UINT8_C( 28), UINT8_C(158), UINT8_C(223), UINT8_C(181),
                             UINT8_C(218), UINT8_C(114), UINT8_C(200), UINT8_C(243),
                             UINT8_C(255), UINT8_C( 48), UINT8_C(233), UINT8_C( 82),
                             UINT8_C( 22), UINT8_C( 26), UINT8_C(128), UINT8_C(166),
                             UINT8_C( 79), UINT8_C(206), UINT8_C(109), UINT8_C(113),
                             UINT8_C( 86), UINT8_C(112), UINT8_C(215), UINT8_C(187),
                             UINT8_C(174), UINT8_C(250), UINT8_C(225), UINT8_C(206),
                             UINT8_C(242), UINT8_C(141), UINT8_C(197), UINT8_C(179),
                             UINT8_C( 88), UINT8_C(237), UINT8_C(191), UINT8_C(149),
                             UINT8_C(130), UINT8_C( 63), UINT8_C( 54), UINT8_C(129),
                             UINT8_C(126), UINT8_C( 18), UINT8_C( 43), UINT8_C(251),
                             UINT8_C(214), UINT8_C(155), UINT8_C( 61), UINT8_C(138)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C( 33), UINT8_C( 51), UINT8_C(244),
                             UINT8_C( 33), UINT8_C(106), UINT8_C( 75), UINT8_C(210),
                             UINT8_C(121), UINT8_C( 52), UINT8_C(233), UINT8_C(109),
                             UINT8_C(205), UINT8_C(175), UINT8_C(230), UINT8_C( 70),
                             UINT8_C( 28), UINT8_C(216), UINT8_C( 76), UINT8_C(137),
                             UINT8_C(129), UINT8_C(  5), UINT8_C(149), UINT8_C(132),
                             UINT8_C(159), UINT8_C( 55), UINT8_C( 47), UINT8_C(212),
                             UINT8_C(202), UINT8_C( 26), UINT8_C(247), UINT8_C( 19),
                             UINT8_C(109), UINT8_C( 59), UINT8_C( 49), UINT8_C(175),
                             UINT8_C( 15), UINT8_C(240), UINT8_C(155), UINT8_C( 20),
                             UINT8_C( 85), UINT8_C( 57), UINT8_C( 91), UINT8_C(177),
                             UINT8_C(179), UINT8_C(200), UINT8_C( 26), UINT8_C( 99),
                             UINT8_C(  9), UINT8_C(177), UINT8_C(151), UINT8_C(246),
                             UINT8_C(116), UINT8_C(162), UINT8_C(144), UINT8_C( 44),
                             UINT8_C(240), UINT8_C(226), UINT8_C(215), UINT8_C(206),
                             UINT8_C(114), UINT8_C(250), UINT8_C(170), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(210), UINT8_C(169), UINT8_C(142), UINT8_C(255),
                             UINT8_C(192), UINT8_C(255), UINT8_C(255), UINT8_C(113),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(218),
                             UINT8_C( 56), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(119), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(103), UINT8_C(255), UINT8_C(255),
                             UINT8_C(224), UINT8_C( 52), UINT8_C(255), UINT8_C(185),
                             UINT8_C(188), UINT8_C(255), UINT8_C(158), UINT8_C(255),
                             UINT8_C(101), UINT8_C(255), UINT8_C(255), UINT8_C(207),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(223), UINT8_C(255),
                             UINT8_C( 97), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(246), UINT8_C(225), UINT8_C(198), UINT8_C(173),
                             UINT8_C(255), UINT8_C(244), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(231), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(103), UINT8_C(253), UINT8_C( 31), UINT8_C(185),
                             UINT8_C(101), UINT8_C(201), UINT8_C( 20), UINT8_C( 77),
                             UINT8_C(110), UINT8_C(116), UINT8_C(226), UINT8_C( 37),
                             UINT8_C(155), UINT8_C( 44), UINT8_C(198), UINT8_C(182),
                             UINT8_C(132), UINT8_C( 61), UINT8_C(104), UINT8_C(181),
                             UINT8_C( 77), UINT8_C(161), UINT8_C(154), UINT8_C(195),
                             UINT8_C(148), UINT8_C(239), UINT8_C(178), UINT8_C(165),
                             UINT8_C(  6), UINT8_C(251), UINT8_C( 97), UINT8_C(247),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 96), UINT8_C( 34),
                             UINT8_C(233), UINT8_C(  1), UINT8_C(  7), UINT8_C(254),
                             UINT8_C(  3), UINT8_C(  8), UINT8_C(168), UINT8_C(221),
                             UINT8_C(238), UINT8_C(144), UINT8_C( 18), UINT8_C(245),
                             UINT8_C(216), UINT8_C(239), UINT8_C(128), UINT8_C(174),
                             UINT8_C(108), UINT8_C(236), UINT8_C(204), UINT8_C(151),
                             UINT8_C( 83), UINT8_C(224), UINT8_C(253), UINT8_C( 94),
                             UINT8_C( 40), UINT8_C( 10), UINT8_C(195), UINT8_C( 72)),
      simde_x_mm512_set_epu8(UINT8_C(196), UINT8_C(220), UINT8_C(209), UINT8_C(146),
                             UINT8_C( 66), UINT8_C(240), UINT8_C(160), UINT8_C( 58),
                             UINT8_C(206), UINT8_C(157), UINT8_C(225), UINT8_C(238),
                             UINT8_C(235), UINT8_C( 53), UINT8_C( 91), UINT8_C( 97),
                             UINT8_C(175), UINT8_C( 22), UINT8_C( 33), UINT8_C(101),
                             UINT8_C(189), UINT8_C(131), UINT8_C(219), UINT8_C( 30),
                             UINT8_C( 36), UINT8_C( 11), UINT8_C(180), UINT8_C( 46),
                             UINT8_C(126), UINT8_C(239), UINT8_C(135), UINT8_C( 44),
                             UINT8_C(198), UINT8_C(149), UINT8_C(235), UINT8_C( 72),
                             UINT8_C( 18), UINT8_C(214), UINT8_C( 92), UINT8_C(199),
                             UINT8_C( 79), UINT8_C( 28), UINT8_C(156), UINT8_C( 37),
                             UINT8_C(212), UINT8_C(167), UINT8_C( 62), UINT8_C(201),
                             UINT8_C(139), UINT8_C(215), UINT8_C( 68), UINT8_C(117),
                             UINT8_C( 83), UINT8_C(105), UINT8_C(232), UINT8_C(251),
                             UINT8_C(  6), UINT8_C(165), UINT8_C(199), UINT8_C(183),
                             UINT8_C(254), UINT8_C( 55), UINT8_C(167), UINT8_C(238)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(240), UINT8_C(255),
                             UINT8_C(167), UINT8_C(255), UINT8_C(180), UINT8_C(135),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 97), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 83), UINT8_C(137), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(225),
                             UINT8_C(184), UINT8_C(250), UINT8_C(255), UINT8_C(211),
                             UINT8_C(132), UINT8_C(255), UINT8_C(232), UINT8_C(255),
                             UINT8_C(206), UINT8_C(201), UINT8_C(255), UINT8_C(106),
                             UINT8_C(251), UINT8_C(215), UINT8_C( 99), UINT8_C(255),
                             UINT8_C( 82), UINT8_C( 36), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 80), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(196), UINT8_C(255),
                             UINT8_C(191), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C( 89), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 65), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(  7), UINT8_C( 99), UINT8_C(210), UINT8_C(110),
                             UINT8_C(202), UINT8_C( 10), UINT8_C(247), UINT8_C( 68),
                             UINT8_C(177), UINT8_C(186), UINT8_C(247), UINT8_C( 36),
                             UINT8_C(212), UINT8_C(146), UINT8_C(251), UINT8_C( 66),
                             UINT8_C(  0), UINT8_C(  8), UINT8_C(116), UINT8_C(102),
                             UINT8_C(175), UINT8_C(223), UINT8_C( 15), UINT8_C(232),
                             UINT8_C(127), UINT8_C( 63), UINT8_C( 84), UINT8_C(165),
                             UINT8_C( 18), UINT8_C(250), UINT8_C( 71), UINT8_C( 18),
                             UINT8_C(132), UINT8_C(155), UINT8_C(102), UINT8_C( 18),
                             UINT8_C(177), UINT8_C(146), UINT8_C(169), UINT8_C(139),
                             UINT8_C( 21), UINT8_C( 79), UINT8_C(  4), UINT8_C(129),
                             UINT8_C(168), UINT8_C( 42), UINT8_C(  9), UINT8_C(184),
                             UINT8_C( 46), UINT8_C( 53), UINT8_C(243), UINT8_C(140),
                             UINT8_C(158), UINT8_C(112), UINT8_C( 35), UINT8_C( 49),
                             UINT8_C(253), UINT8_C(233), UINT8_C( 33), UINT8_C(178),
                             UINT8_C(117), UINT8_C(161), UINT8_C(168), UINT8_C( 39)),
      simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(218), UINT8_C(162), UINT8_C( 30),
                             UINT8_C(119), UINT8_C(231), UINT8_C(193), UINT8_C(230),
                             UINT8_C(151), UINT8_C( 49), UINT8_C(234), UINT8_C( 78),
                             UINT8_C( 76), UINT8_C( 37), UINT8_C(174), UINT8_C(105),
                             UINT8_C(224), UINT8_C(210), UINT8_C(188), UINT8_C(142),
                             UINT8_C(116), UINT8_C(129), UINT8_C( 93), UINT8_C(124),
                             UINT8_C(248), UINT8_C(145), UINT8_C(230), UINT8_C( 41),
                             UINT8_C( 66), UINT8_C(115), UINT8_C(180), UINT8_C( 47),
                             UINT8_C( 55), UINT8_C(104), UINT8_C(123), UINT8_C(150),
                             UINT8_C(165), UINT8_C( 22), UINT8_C(  0), UINT8_C(101),
                             UINT8_C( 55), UINT8_C( 23), UINT8_C( 90), UINT8_C( 64),
                             UINT8_C( 52), UINT8_C(254), UINT8_C(116), UINT8_C(243),
                             UINT8_C(  4), UINT8_C( 84), UINT8_C( 82), UINT8_C(103),
                             UINT8_C( 43), UINT8_C(237), UINT8_C(  7), UINT8_C( 76),
                             UINT8_C( 88), UINT8_C(212), UINT8_C( 63), UINT8_C(146),
                             UINT8_C(224), UINT8_C(223), UINT8_C(207), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C( 82), UINT8_C(255), UINT8_C(255), UINT8_C(140),
                             UINT8_C(255), UINT8_C(241), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(235), UINT8_C(255), UINT8_C(114),
                             UINT8_C(255), UINT8_C(183), UINT8_C(255), UINT8_C(171),
                             UINT8_C(224), UINT8_C(218), UINT8_C(255), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(108), UINT8_C(255),
                             UINT8_C(255), UINT8_C(208), UINT8_C(255), UINT8_C(206),
                             UINT8_C( 84), UINT8_C(255), UINT8_C(251), UINT8_C( 65),
                             UINT8_C(187), UINT8_C(255), UINT8_C(225), UINT8_C(168),
                             UINT8_C(255), UINT8_C(168), UINT8_C(169), UINT8_C(240),
                             UINT8_C( 76), UINT8_C(102), UINT8_C( 94), UINT8_C(193),
                             UINT8_C(220), UINT8_C(255), UINT8_C(125), UINT8_C(255),
                             UINT8_C( 50), UINT8_C(137), UINT8_C(255), UINT8_C(243),
                             UINT8_C(201), UINT8_C(255), UINT8_C( 42), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 96), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(112), UINT8_C( 62), UINT8_C( 65),
                             UINT8_C( 37), UINT8_C(247), UINT8_C(105), UINT8_C( 54),
                             UINT8_C(214), UINT8_C(255), UINT8_C(145), UINT8_C( 18),
                             UINT8_C(160), UINT8_C( 92), UINT8_C( 29), UINT8_C(253),
                             UINT8_C(230), UINT8_C( 83), UINT8_C(176), UINT8_C( 43),
                             UINT8_C( 78), UINT8_C( 31), UINT8_C(113), UINT8_C(239),
                             UINT8_C( 38), UINT8_C(192), UINT8_C(127), UINT8_C( 44),
                             UINT8_C(218), UINT8_C(134), UINT8_C(224), UINT8_C( 35),
                             UINT8_C(155), UINT8_C(171), UINT8_C( 44), UINT8_C( 53),
                             UINT8_C(101), UINT8_C(234), UINT8_C(121), UINT8_C( 95),
                             UINT8_C(232), UINT8_C(104), UINT8_C( 20), UINT8_C( 52),
                             UINT8_C( 59), UINT8_C( 62), UINT8_C( 55), UINT8_C( 43),
                             UINT8_C(246), UINT8_C( 36), UINT8_C( 25), UINT8_C( 98),
                             UINT8_C(155), UINT8_C(231), UINT8_C( 43), UINT8_C(203),
                             UINT8_C( 77), UINT8_C( 43), UINT8_C( 80), UINT8_C( 85),
                             UINT8_C(227), UINT8_C( 34), UINT8_C( 77), UINT8_C(179)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(183), UINT8_C(190), UINT8_C(248),
                             UINT8_C( 54), UINT8_C(194), UINT8_C(  0), UINT8_C(190),
                             UINT8_C(102), UINT8_C(185), UINT8_C(  5), UINT8_C(238),
                             UINT8_C(188), UINT8_C(104), UINT8_C(139), UINT8_C(163),
                             UINT8_C(242), UINT8_C( 94), UINT8_C(181), UINT8_C(214),
                             UINT8_C(170), UINT8_C(182), UINT8_C(139), UINT8_C( 96),
                             UINT8_C( 80), UINT8_C( 38), UINT8_C(151), UINT8_C(132),
                             UINT8_C(243), UINT8_C( 37), UINT8_C(120), UINT8_C( 30),
                             UINT8_C(115), UINT8_C( 34), UINT8_C(222), UINT8_C(121),
                             UINT8_C(112), UINT8_C(205), UINT8_C(161), UINT8_C( 52),
                             UINT8_C(142), UINT8_C(118), UINT8_C(195), UINT8_C(200),
                             UINT8_C( 59), UINT8_C(  6), UINT8_C(115), UINT8_C(109),
                             UINT8_C( 93), UINT8_C(174), UINT8_C(200), UINT8_C(190),
                             UINT8_C(151), UINT8_C(126), UINT8_C(210), UINT8_C(200),
                             UINT8_C( 79), UINT8_C( 43), UINT8_C( 20), UINT8_C(239),
                             UINT8_C(149), UINT8_C(119), UINT8_C( 96), UINT8_C(120)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(252), UINT8_C(255),
                             UINT8_C( 91), UINT8_C(255), UINT8_C(105), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(150), UINT8_C(255),
                             UINT8_C(255), UINT8_C(196), UINT8_C(168), UINT8_C(255),
                             UINT8_C(255), UINT8_C(177), UINT8_C(255), UINT8_C(255),
                             UINT8_C(248), UINT8_C(213), UINT8_C(252), UINT8_C(255),
                             UINT8_C(118), UINT8_C(230), UINT8_C(255), UINT8_C(176),
                             UINT8_C(255), UINT8_C(171), UINT8_C(255), UINT8_C( 65),
                             UINT8_C(255), UINT8_C(205), UINT8_C(255), UINT8_C(174),
                             UINT8_C(213), UINT8_C(255), UINT8_C(255), UINT8_C(147),
                             UINT8_C(255), UINT8_C(222), UINT8_C(215), UINT8_C(252),
                             UINT8_C(118), UINT8_C( 68), UINT8_C(170), UINT8_C(152),
                             UINT8_C(255), UINT8_C(210), UINT8_C(225), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(253), UINT8_C(255),
                             UINT8_C(156), UINT8_C( 86), UINT8_C(100), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(173), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(150), UINT8_C(150), UINT8_C(146), UINT8_C(157),
                             UINT8_C(103), UINT8_C( 31), UINT8_C(236), UINT8_C(192),
                             UINT8_C(155), UINT8_C( 46), UINT8_C(170), UINT8_C(176),
                             UINT8_C(189), UINT8_C( 74), UINT8_C(246), UINT8_C(  0),
                             UINT8_C( 85), UINT8_C( 30), UINT8_C(190), UINT8_C( 12),
                             UINT8_C(117), UINT8_C( 74), UINT8_C(194), UINT8_C( 97),
                             UINT8_C(132), UINT8_C( 63), UINT8_C(227), UINT8_C( 21),
                             UINT8_C(244), UINT8_C(229), UINT8_C(176), UINT8_C(122),
                             UINT8_C(159), UINT8_C( 35), UINT8_C(115), UINT8_C(240),
                             UINT8_C( 88), UINT8_C(151), UINT8_C(101), UINT8_C(194),
                             UINT8_C( 49), UINT8_C(128), UINT8_C( 87), UINT8_C(152),
                             UINT8_C(173), UINT8_C(242), UINT8_C(150), UINT8_C( 26),
                             UINT8_C(183), UINT8_C( 56), UINT8_C(181), UINT8_C(193),
                             UINT8_C(231), UINT8_C(135), UINT8_C(190), UINT8_C( 42),
                             UINT8_C( 33), UINT8_C(174), UINT8_C( 57), UINT8_C(232),
                             UINT8_C(176), UINT8_C(125), UINT8_C( 87), UINT8_C( 79)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(  1), UINT8_C(208), UINT8_C( 74),
                             UINT8_C(102), UINT8_C(168), UINT8_C( 41), UINT8_C( 41),
                             UINT8_C( 83), UINT8_C( 95), UINT8_C(152), UINT8_C(131),
                             UINT8_C(230), UINT8_C( 27), UINT8_C(126), UINT8_C(230),
                             UINT8_C(128), UINT8_C(133), UINT8_C(107), UINT8_C(197),
                             UINT8_C( 23), UINT8_C(  2), UINT8_C(108), UINT8_C(207),
                             UINT8_C( 82), UINT8_C(175), UINT8_C(247), UINT8_C(180),
                             UINT8_C( 57), UINT8_C( 31), UINT8_C(124), UINT8_C(203),
                             UINT8_C(246), UINT8_C(195), UINT8_C(173), UINT8_C(161),
                             UINT8_C(132), UINT8_C(162), UINT8_C( 13), UINT8_C(205),
                             UINT8_C(225), UINT8_C( 25), UINT8_C( 39), UINT8_C(181),
                             UINT8_C(149), UINT8_C(149), UINT8_C(138), UINT8_C(158),
                             UINT8_C(215), UINT8_C(147), UINT8_C(  0), UINT8_C( 87),
                             UINT8_C(244), UINT8_C( 10), UINT8_C(  1), UINT8_C( 19),
                             UINT8_C(173), UINT8_C(221), UINT8_C(118), UINT8_C( 51),
                             UINT8_C( 98), UINT8_C(183), UINT8_C(125), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(218), UINT8_C(151), UINT8_C(255), UINT8_C(231),
                             UINT8_C(205), UINT8_C(199), UINT8_C(255), UINT8_C(233),
                             UINT8_C(238), UINT8_C(141), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(101), UINT8_C(255), UINT8_C(230),
                             UINT8_C(213), UINT8_C(163), UINT8_C(255), UINT8_C(209),
                             UINT8_C(140), UINT8_C( 76), UINT8_C(255), UINT8_C(255),
                             UINT8_C(214), UINT8_C(238), UINT8_C(255), UINT8_C(201),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(230), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(114), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(126), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(184),
                             UINT8_C(255), UINT8_C(203), UINT8_C(181), UINT8_C(255),
                             UINT8_C(255), UINT8_C(145), UINT8_C(191), UINT8_C( 61),
                             UINT8_C(206), UINT8_C(255), UINT8_C(175), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(212), UINT8_C(171)) },
    { simde_x_mm512_set_epu8(UINT8_C(166), UINT8_C(112), UINT8_C( 16), UINT8_C( 20),
                             UINT8_C(189), UINT8_C( 23), UINT8_C( 28), UINT8_C(226),
                             UINT8_C( 92), UINT8_C(105), UINT8_C(249), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C(153), UINT8_C( 38), UINT8_C( 58),
                             UINT8_C( 86), UINT8_C(191), UINT8_C( 97), UINT8_C(186),
                             UINT8_C(117), UINT8_C( 93), UINT8_C( 63), UINT8_C(142),
                             UINT8_C( 82), UINT8_C(123), UINT8_C(210), UINT8_C(159),
                             UINT8_C(175), UINT8_C(187), UINT8_C( 33), UINT8_C(134),
                             UINT8_C(156), UINT8_C(243), UINT8_C(191), UINT8_C(139),
                             UINT8_C(173), UINT8_C( 70), UINT8_C(113), UINT8_C( 30),
                             UINT8_C(184), UINT8_C( 82), UINT8_C(234), UINT8_C(177),
                             UINT8_C(234), UINT8_C(131), UINT8_C(180), UINT8_C( 12),
                             UINT8_C( 47), UINT8_C(213), UINT8_C( 54), UINT8_C(222),
                             UINT8_C(114), UINT8_C(251), UINT8_C(236), UINT8_C( 57),
                             UINT8_C(205), UINT8_C(187), UINT8_C( 48), UINT8_C(112),
                             UINT8_C( 34), UINT8_C( 49), UINT8_C( 95), UINT8_C(198)),
      simde_x_mm512_set_epu8(UINT8_C(116), UINT8_C(101), UINT8_C(212), UINT8_C(199),
                             UINT8_C( 88), UINT8_C(165), UINT8_C(253), UINT8_C( 88),
                             UINT8_C(138), UINT8_C( 27), UINT8_C(153), UINT8_C(155),
                             UINT8_C(248), UINT8_C(175), UINT8_C(152), UINT8_C(246),
                             UINT8_C( 17), UINT8_C(224), UINT8_C( 49), UINT8_C(127),
                             UINT8_C(200), UINT8_C( 46), UINT8_C( 58), UINT8_C(159),
                             UINT8_C(177), UINT8_C( 24), UINT8_C(139), UINT8_C(240),
                             UINT8_C( 45), UINT8_C(115), UINT8_C(179), UINT8_C(230),
                             UINT8_C(249), UINT8_C(217), UINT8_C(202), UINT8_C( 21),
                             UINT8_C(134), UINT8_C(111), UINT8_C( 79), UINT8_C(153),
                             UINT8_C(130), UINT8_C( 83), UINT8_C(196), UINT8_C(101),
                             UINT8_C(151), UINT8_C(117), UINT8_C(152), UINT8_C(155),
                             UINT8_C(116), UINT8_C(201), UINT8_C(241), UINT8_C( 71),
                             UINT8_C( 24), UINT8_C(105), UINT8_C(212), UINT8_C(191),
                             UINT8_C(  1), UINT8_C(252), UINT8_C( 15), UINT8_C( 49),
                             UINT8_C(105), UINT8_C(159), UINT8_C(109), UINT8_C( 31)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(213), UINT8_C(228), UINT8_C(219),
                             UINT8_C(255), UINT8_C(188), UINT8_C(255), UINT8_C(255),
                             UINT8_C(230), UINT8_C(132), UINT8_C(255), UINT8_C(226),
                             UINT8_C(255), UINT8_C(255), UINT8_C(190), UINT8_C(255),
                             UINT8_C(103), UINT8_C(255), UINT8_C(146), UINT8_C(255),
                             UINT8_C(255), UINT8_C(139), UINT8_C(121), UINT8_C(255),
                             UINT8_C(255), UINT8_C(147), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(212), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(160),
                             UINT8_C(255), UINT8_C(181), UINT8_C(192), UINT8_C(183),
                             UINT8_C(255), UINT8_C(165), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(248), UINT8_C(255), UINT8_C(167),
                             UINT8_C(163), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(138), UINT8_C(255), UINT8_C(255), UINT8_C(248),
                             UINT8_C(206), UINT8_C(255), UINT8_C( 63), UINT8_C(161),
                             UINT8_C(139), UINT8_C(208), UINT8_C(204), UINT8_C(229)) },
    { simde_x_mm512_set_epu8(UINT8_C(239), UINT8_C(174), UINT8_C( 81), UINT8_C( 89),
                             UINT8_C( 63), UINT8_C(160), UINT8_C(219), UINT8_C(204),
                             UINT8_C(161), UINT8_C(  4), UINT8_C(134), UINT8_C(137),
                             UINT8_C( 48), UINT8_C( 33), UINT8_C(178), UINT8_C(122),
                             UINT8_C( 99), UINT8_C(167), UINT8_C( 95), UINT8_C(109),
                             UINT8_C( 38), UINT8_C(191), UINT8_C(  3), UINT8_C( 48),
                             UINT8_C(143), UINT8_C( 51), UINT8_C( 81), UINT8_C( 76),
                             UINT8_C(251), UINT8_C(204), UINT8_C(198), UINT8_C(  1),
                             UINT8_C(175), UINT8_C(123), UINT8_C( 24), UINT8_C(237),
                             UINT8_C(190), UINT8_C( 62), UINT8_C( 87), UINT8_C(255),
                             UINT8_C(119), UINT8_C(202), UINT8_C(  4), UINT8_C( 40),
                             UINT8_C(152), UINT8_C(128), UINT8_C(116), UINT8_C( 72),
                             UINT8_C(245), UINT8_C(148), UINT8_C( 39), UINT8_C(106),
                             UINT8_C(195), UINT8_C(186), UINT8_C(241), UINT8_C(178),
                             UINT8_C( 68), UINT8_C(210), UINT8_C( 61), UINT8_C(218),
                             UINT8_C(116), UINT8_C( 98), UINT8_C( 41), UINT8_C( 22)),
      simde_x_mm512_set_epu8(UINT8_C(  3), UINT8_C(245), UINT8_C(  8), UINT8_C(179),
                             UINT8_C(242), UINT8_C( 19), UINT8_C(107), UINT8_C(170),
                             UINT8_C(178), UINT8_C(175), UINT8_C(174), UINT8_C(170),
                             UINT8_C( 72), UINT8_C(195), UINT8_C(199), UINT8_C( 66),
                             UINT8_C(182), UINT8_C(183), UINT8_C( 58), UINT8_C(245),
                             UINT8_C( 62), UINT8_C( 31), UINT8_C( 93), UINT8_C( 74),
                             UINT8_C(114), UINT8_C( 92), UINT8_C(199), UINT8_C( 53),
                             UINT8_C( 94), UINT8_C(185), UINT8_C(107), UINT8_C(124),
                             UINT8_C(160), UINT8_C(193), UINT8_C( 17), UINT8_C( 65),
                             UINT8_C(242), UINT8_C( 55), UINT8_C(163), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(173), UINT8_C(244), UINT8_C(232),
                             UINT8_C(182), UINT8_C(139), UINT8_C(254), UINT8_C( 81),
                             UINT8_C(228), UINT8_C(175), UINT8_C(104), UINT8_C(167),
                             UINT8_C( 38), UINT8_C(114), UINT8_C(184), UINT8_C(118),
                             UINT8_C(167), UINT8_C( 58), UINT8_C(153), UINT8_C(103),
                             UINT8_C(204), UINT8_C(126), UINT8_C(111), UINT8_C( 63)),
      simde_x_mm512_set_epu8(UINT8_C(242), UINT8_C(255), UINT8_C( 89), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(120), UINT8_C(228), UINT8_C(255), UINT8_C(188),
                             UINT8_C(255), UINT8_C(255), UINT8_C(153), UINT8_C(255),
                             UINT8_C(100), UINT8_C(222), UINT8_C( 96), UINT8_C(122),
                             UINT8_C(255), UINT8_C(143), UINT8_C(255), UINT8_C(129),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 41), UINT8_C(255),
                             UINT8_C(255), UINT8_C(117), UINT8_C(250), UINT8_C(255),
                             UINT8_C(178), UINT8_C(255), UINT8_C(248), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(153),
                             UINT8_C(255), UINT8_C(255), UINT8_C(143), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(235), UINT8_C(255), UINT8_C(214), UINT8_C(255),
                             UINT8_C(255), UINT8_C(224), UINT8_C(152), UINT8_C( 85)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 57245), UINT16_C( 31803), UINT16_C(  9053), UINT16_C( 21282),
                              UINT16_C( 45515), UINT16_C( 57894), UINT16_C( 50445), UINT16_C( 50583),
                              UINT16_C( 54723), UINT16_C( 52144), UINT16_C( 13347), UINT16_C( 57624),
                              UINT16_C( 20975), UINT16_C( 65317), UINT16_C( 16493), UINT16_C( 47193),
                              UINT16_C(  8805), UINT16_C( 17012), UINT16_C( 15383), UINT16_C(  5484),
                              UINT16_C( 64480), UINT16_C( 10898), UINT16_C( 37488), UINT16_C(  8763),
                              UINT16_C( 45480), UINT16_C(  3307), UINT16_C(  9193), UINT16_C( 26229),
                              UINT16_C( 20008), UINT16_C( 59713), UINT16_C( 53564), UINT16_C( 62675)),
      simde_x_mm512_set_epu16(UINT16_C( 56619), UINT16_C( 61703), UINT16_C(  3086), UINT16_C( 41224),
                              UINT16_C(  8421), UINT16_C( 52766), UINT16_C(  7424), UINT16_C( 48822),
                              UINT16_C( 41975), UINT16_C( 22918), UINT16_C( 59915), UINT16_C( 26727),
                              UINT16_C( 53323), UINT16_C( 34707), UINT16_C( 14572), UINT16_C(   716),
                              UINT16_C( 56087), UINT16_C(  9094), UINT16_C( 20814), UINT16_C( 56962),
                              UINT16_C( 14110), UINT16_C( 52082), UINT16_C(  8468), UINT16_C( 11854),
                              UINT16_C(  1576), UINT16_C( 12690), UINT16_C( 32737), UINT16_C( 51663),
                              UINT16_C( 37115), UINT16_C( 18115), UINT16_C( 50682), UINT16_C(  1653)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 12139), UINT16_C( 62506),
                              UINT16_C( 53936), UINT16_C( 65535), UINT16_C( 57869), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 31065), UINT16_C( 47909),
                              UINT16_C( 64892), UINT16_C( 26106), UINT16_C( 36197), UINT16_C( 62446),
                              UINT16_C( 65535), UINT16_C( 62980), UINT16_C( 45956), UINT16_C( 20617),
                              UINT16_C( 47056), UINT16_C( 15997), UINT16_C( 41930), UINT16_C( 65535),
                              UINT16_C( 57123), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 64328)) },
    { simde_x_mm512_set_epu16(UINT16_C(  1128), UINT16_C( 14143), UINT16_C( 19763), UINT16_C( 47819),
                              UINT16_C( 62972), UINT16_C( 13428), UINT16_C( 18537), UINT16_C( 38297),
                              UINT16_C( 21721), UINT16_C( 58861), UINT16_C( 42577), UINT16_C( 39379),
                              UINT16_C( 55643), UINT16_C( 20439), UINT16_C( 34514), UINT16_C( 49721),
                              UINT16_C( 18526), UINT16_C( 46886), UINT16_C( 20377), UINT16_C( 31658),
                              UINT16_C( 32537), UINT16_C( 50044), UINT16_C( 28503), UINT16_C(  5895),
                              UINT16_C(  1666), UINT16_C( 50137), UINT16_C( 30976), UINT16_C(  4047),
                              UINT16_C( 24589), UINT16_C( 29183), UINT16_C( 13128), UINT16_C(  3541)),
      simde_x_mm512_set_epu16(UINT16_C( 38521), UINT16_C( 64382), UINT16_C( 35873), UINT16_C( 42497),
                              UINT16_C( 46178), UINT16_C( 38904), UINT16_C( 15657), UINT16_C(  6453),
                              UINT16_C( 15377), UINT16_C( 45418), UINT16_C( 38208), UINT16_C( 44948),
                              UINT16_C( 17985), UINT16_C( 28923), UINT16_C( 11094), UINT16_C( 61254),
                              UINT16_C( 41028), UINT16_C(  4939), UINT16_C( 61438), UINT16_C( 34821),
                              UINT16_C(  9578), UINT16_C( 46329), UINT16_C( 53213), UINT16_C( 42297),
                              UINT16_C( 42846), UINT16_C( 12973), UINT16_C( 32628), UINT16_C( 10992),
                              UINT16_C( 56871), UINT16_C( 37695), UINT16_C( 16317), UINT16_C(  4356)),
      simde_x_mm512_set_epu16(UINT16_C( 39649), UINT16_C( 65535), UINT16_C( 55636), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52332), UINT16_C( 34194), UINT16_C( 44750),
                              UINT16_C( 37098), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 49362), UINT16_C( 45608), UINT16_C( 65535),
                              UINT16_C( 59554), UINT16_C( 51825), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 42115), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 48192),
                              UINT16_C( 44512), UINT16_C( 63110), UINT16_C( 63604), UINT16_C( 15039),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 29445), UINT16_C(  7897)) },
    { simde_x_mm512_set_epu16(UINT16_C( 14747), UINT16_C( 30570), UINT16_C( 56275), UINT16_C( 58793),
                              UINT16_C( 48636), UINT16_C( 11396), UINT16_C( 12142), UINT16_C( 25883),
                              UINT16_C( 48137), UINT16_C( 31445), UINT16_C( 15524), UINT16_C( 49322),
                              UINT16_C(  6761), UINT16_C( 42681), UINT16_C(  8586), UINT16_C( 53309),
                              UINT16_C( 48898), UINT16_C( 23142), UINT16_C( 17912), UINT16_C( 20578),
                              UINT16_C( 42157), UINT16_C( 25705), UINT16_C( 39154), UINT16_C( 32521),
                              UINT16_C(  7302), UINT16_C( 65263), UINT16_C(  7623), UINT16_C( 47267),
                              UINT16_C( 41612), UINT16_C(  7723), UINT16_C( 51815), UINT16_C( 23273)),
      simde_x_mm512_set_epu16(UINT16_C( 29783), UINT16_C( 35133), UINT16_C( 18722), UINT16_C( 24788),
                              UINT16_C(  4507), UINT16_C( 64908), UINT16_C( 18120), UINT16_C( 53792),
                              UINT16_C( 40447), UINT16_C(  2013), UINT16_C( 19329), UINT16_C( 18474),
                              UINT16_C( 45067), UINT16_C( 37105), UINT16_C( 40003), UINT16_C( 11523),
                              UINT16_C( 28865), UINT16_C(  9988), UINT16_C( 16394), UINT16_C( 60605),
                              UINT16_C( 29530), UINT16_C(   612), UINT16_C( 21547), UINT16_C( 12463),
                              UINT16_C( 46586), UINT16_C(  6619), UINT16_C( 39845), UINT16_C(  4328),
                              UINT16_C( 31818), UINT16_C( 16334), UINT16_C( 57400), UINT16_C( 58095)),
      simde_x_mm512_set_epu16(UINT16_C( 44530), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 53143), UINT16_C( 65535), UINT16_C( 30262), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 33458), UINT16_C( 34853), UINT16_C( 65535),
                              UINT16_C( 51828), UINT16_C( 65535), UINT16_C( 48589), UINT16_C( 64832),
                              UINT16_C( 65535), UINT16_C( 33130), UINT16_C( 34306), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 26317), UINT16_C( 60701), UINT16_C( 44984),
                              UINT16_C( 53888), UINT16_C( 65535), UINT16_C( 47468), UINT16_C( 51595),
                              UINT16_C( 65535), UINT16_C( 24057), UINT16_C( 65535), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 30682), UINT16_C( 30851), UINT16_C(  8660), UINT16_C( 19219),
                              UINT16_C( 10963), UINT16_C(   474), UINT16_C( 23728), UINT16_C( 46528),
                              UINT16_C( 63120), UINT16_C( 45881), UINT16_C( 63086), UINT16_C( 25197),
                              UINT16_C(  2704), UINT16_C(  4513), UINT16_C( 59294), UINT16_C( 60752),
                              UINT16_C( 50954), UINT16_C( 23266), UINT16_C( 27902), UINT16_C(  8814),
                              UINT16_C(  4863), UINT16_C(  1260), UINT16_C( 11681), UINT16_C( 46962),
                              UINT16_C( 62057), UINT16_C(  1167), UINT16_C( 44133), UINT16_C( 29723),
                              UINT16_C( 20503), UINT16_C( 47951), UINT16_C(  6645), UINT16_C( 27511)),
      simde_x_mm512_set_epu16(UINT16_C( 15286), UINT16_C(  5686), UINT16_C( 62529), UINT16_C( 52414),
                              UINT16_C( 64942), UINT16_C( 55157), UINT16_C(  1921), UINT16_C(   414),
                              UINT16_C( 57075), UINT16_C( 38949), UINT16_C( 49837), UINT16_C( 16574),
                              UINT16_C( 63519), UINT16_C( 21815), UINT16_C( 16534), UINT16_C(  5264),
                              UINT16_C( 40611), UINT16_C(  7582), UINT16_C( 27508), UINT16_C( 40060),
                              UINT16_C( 17332), UINT16_C( 48486), UINT16_C( 46457), UINT16_C(  3074),
                              UINT16_C( 49520), UINT16_C( 35694), UINT16_C( 14820), UINT16_C( 26739),
                              UINT16_C( 52931), UINT16_C( 30426), UINT16_C( 34639), UINT16_C( 60126)),
      simde_x_mm512_set_epu16(UINT16_C( 45968), UINT16_C( 36537), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 55631), UINT16_C( 25649), UINT16_C( 46942),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41771),
                              UINT16_C( 65535), UINT16_C( 26328), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 30848), UINT16_C( 55410), UINT16_C( 48874),
                              UINT16_C( 22195), UINT16_C( 49746), UINT16_C( 58138), UINT16_C( 50036),
                              UINT16_C( 65535), UINT16_C( 36861), UINT16_C( 58953), UINT16_C( 56462),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41284), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 20277), UINT16_C(  2901), UINT16_C(  9119), UINT16_C( 39166),
                              UINT16_C( 42714), UINT16_C( 26596), UINT16_C( 65466), UINT16_C( 41724),
                              UINT16_C( 43509), UINT16_C( 36161), UINT16_C( 14559), UINT16_C( 39814),
                              UINT16_C( 39598), UINT16_C( 35810), UINT16_C( 32670), UINT16_C(  2206),
                              UINT16_C( 28889), UINT16_C( 41636), UINT16_C( 48990), UINT16_C( 37294),
                              UINT16_C( 39242), UINT16_C( 39778), UINT16_C(  6979), UINT16_C( 54232),
                              UINT16_C( 47738), UINT16_C( 57923), UINT16_C( 37900), UINT16_C( 45798),
                              UINT16_C( 44781), UINT16_C( 27960), UINT16_C(  1998), UINT16_C( 61149)),
      simde_x_mm512_set_epu16(UINT16_C( 20730), UINT16_C( 18080), UINT16_C( 51364), UINT16_C( 27968),
                              UINT16_C( 47873), UINT16_C( 51993), UINT16_C( 18829), UINT16_C( 15054),
                              UINT16_C( 50771), UINT16_C( 37023), UINT16_C( 39205), UINT16_C( 18252),
                              UINT16_C( 53613), UINT16_C( 36736), UINT16_C( 53958), UINT16_C( 13137),
                              UINT16_C( 43763), UINT16_C( 19789), UINT16_C(  2934), UINT16_C( 22986),
                              UINT16_C( 46964), UINT16_C( 64986), UINT16_C( 13395), UINT16_C( 61287),
                              UINT16_C( 61677), UINT16_C( 22301), UINT16_C( 41322), UINT16_C( 35063),
                              UINT16_C( 22663), UINT16_C( 28062), UINT16_C( 45351), UINT16_C( 21097)),
      simde_x_mm512_set_epu16(UINT16_C( 41007), UINT16_C( 20981), UINT16_C( 60483), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56778),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 53764), UINT16_C( 58066),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 15343),
                              UINT16_C( 65535), UINT16_C( 61425), UINT16_C( 51924), UINT16_C( 60280),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 20374), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 56022), UINT16_C( 47349), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 29192), UINT16_C(  8654), UINT16_C( 22850), UINT16_C( 62764),
                              UINT16_C( 24193), UINT16_C( 41054), UINT16_C( 47201), UINT16_C( 29473),
                              UINT16_C(  7514), UINT16_C( 21604), UINT16_C( 55170), UINT16_C( 17089),
                              UINT16_C( 58910), UINT16_C( 18576), UINT16_C( 50942), UINT16_C( 19375),
                              UINT16_C( 32394), UINT16_C(  6670), UINT16_C( 34291), UINT16_C( 10597),
                              UINT16_C( 63848), UINT16_C( 24622), UINT16_C( 55141), UINT16_C( 33399),
                              UINT16_C( 17676), UINT16_C( 53111), UINT16_C( 57678), UINT16_C( 53869),
                              UINT16_C(  1069), UINT16_C( 35377), UINT16_C( 20392), UINT16_C(  6033)),
      simde_x_mm512_set_epu16(UINT16_C( 30110), UINT16_C(  5765), UINT16_C( 21533), UINT16_C( 32154),
                              UINT16_C( 47788), UINT16_C(  4708), UINT16_C( 49450), UINT16_C( 15569),
                              UINT16_C( 11433), UINT16_C( 48528), UINT16_C( 18868), UINT16_C( 49914),
                              UINT16_C( 29591), UINT16_C( 10234), UINT16_C( 18676), UINT16_C( 18833),
                              UINT16_C( 53298), UINT16_C( 44056), UINT16_C(   163), UINT16_C( 14043),
                              UINT16_C( 52308), UINT16_C( 55462), UINT16_C(  1379), UINT16_C( 56593),
                              UINT16_C( 40649), UINT16_C( 10209), UINT16_C( 62181), UINT16_C(  6865),
                              UINT16_C( 33659), UINT16_C( 12643), UINT16_C( 58853), UINT16_C( 27590)),
      simde_x_mm512_set_epu16(UINT16_C( 59302), UINT16_C( 14419), UINT16_C( 44383), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 45762), UINT16_C( 65535), UINT16_C( 45042),
                              UINT16_C( 18947), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 28810), UINT16_C( 65535), UINT16_C( 38208),
                              UINT16_C( 65535), UINT16_C( 50726), UINT16_C( 34454), UINT16_C( 24640),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56520), UINT16_C( 65535),
                              UINT16_C( 58325), UINT16_C( 63320), UINT16_C( 65535), UINT16_C( 60734),
                              UINT16_C( 34728), UINT16_C( 48020), UINT16_C( 65535), UINT16_C( 33623)) },
    { simde_x_mm512_set_epu16(UINT16_C( 54408), UINT16_C( 44486), UINT16_C( 24517), UINT16_C( 51207),
                              UINT16_C(  2791), UINT16_C( 45592), UINT16_C( 48586), UINT16_C( 36784),
                              UINT16_C( 53369), UINT16_C( 43811), UINT16_C( 65046), UINT16_C( 44235),
                              UINT16_C( 48681), UINT16_C( 21401), UINT16_C( 55417), UINT16_C(  5581),
                              UINT16_C( 56410), UINT16_C( 42092), UINT16_C( 49678), UINT16_C( 22777),
                              UINT16_C( 15839), UINT16_C( 59069), UINT16_C(  3836), UINT16_C( 55877),
                              UINT16_C( 35316), UINT16_C( 40611), UINT16_C( 30925), UINT16_C( 38925),
                              UINT16_C( 44290), UINT16_C( 48844), UINT16_C( 41388), UINT16_C( 24135)),
      simde_x_mm512_set_epu16(UINT16_C(  7663), UINT16_C(  4305), UINT16_C( 48670), UINT16_C( 39779),
                              UINT16_C(  2052), UINT16_C( 40026), UINT16_C( 47264), UINT16_C(  7297),
                              UINT16_C( 11022), UINT16_C( 64822), UINT16_C( 63292), UINT16_C( 56921),
                              UINT16_C(  8160), UINT16_C( 61766), UINT16_C( 22014), UINT16_C( 41597),
                              UINT16_C( 60919), UINT16_C( 45399), UINT16_C( 45462), UINT16_C( 35135),
                              UINT16_C( 13486), UINT16_C( 42127), UINT16_C(  6466), UINT16_C(  5931),
                              UINT16_C( 30448), UINT16_C( 27493), UINT16_C( 24921), UINT16_C( 23842),
                              UINT16_C( 21170), UINT16_C( 62954), UINT16_C(  7914), UINT16_C( 35527)),
      simde_x_mm512_set_epu16(UINT16_C( 62071), UINT16_C( 48791), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C(  4843), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44081),
                              UINT16_C( 64391), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 56841), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 47178),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 57912),
                              UINT16_C( 29325), UINT16_C( 65535), UINT16_C( 10302), UINT16_C( 61808),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 55846), UINT16_C( 62767),
                              UINT16_C( 65460), UINT16_C( 65535), UINT16_C( 49302), UINT16_C( 59662)) },
    { simde_x_mm512_set_epu16(UINT16_C( 61865), UINT16_C( 23426), UINT16_C(  1768), UINT16_C( 58636),
                              UINT16_C( 57533), UINT16_C( 19108), UINT16_C( 59802), UINT16_C( 30792),
                              UINT16_C( 61240), UINT16_C(  6209), UINT16_C( 32476), UINT16_C( 14300),
                              UINT16_C(  7420), UINT16_C(  1985), UINT16_C( 25770), UINT16_C( 58800),
                              UINT16_C( 51482), UINT16_C( 20894), UINT16_C(   680), UINT16_C( 29487),
                              UINT16_C( 45202), UINT16_C( 20181), UINT16_C( 14712), UINT16_C( 17612),
                              UINT16_C( 16683), UINT16_C(  1453), UINT16_C( 15990), UINT16_C( 36509),
                              UINT16_C( 51737), UINT16_C( 56324), UINT16_C( 34493), UINT16_C( 17761)),
      simde_x_mm512_set_epu16(UINT16_C( 37550), UINT16_C( 51250), UINT16_C( 42874), UINT16_C(  8384),
                              UINT16_C( 13698), UINT16_C( 33689), UINT16_C( 64372), UINT16_C( 20393),
                              UINT16_C( 17692), UINT16_C( 65383), UINT16_C(   545), UINT16_C( 27220),
                              UINT16_C( 18321), UINT16_C( 26532), UINT16_C( 40835), UINT16_C( 14036),
                              UINT16_C(  3666), UINT16_C(  2040), UINT16_C( 61839), UINT16_C( 38748),
                              UINT16_C( 62699), UINT16_C( 55831), UINT16_C( 23293), UINT16_C( 13208),
                              UINT16_C( 60975), UINT16_C( 12632), UINT16_C( 13392), UINT16_C( 63703),
                              UINT16_C( 41286), UINT16_C(  6117), UINT16_C( 32645), UINT16_C( 56152)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44642), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52797), UINT16_C( 65535), UINT16_C( 51185),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 33021), UINT16_C( 41520),
                              UINT16_C( 25741), UINT16_C( 28517), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 55148), UINT16_C( 22934), UINT16_C( 62519), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 38005), UINT16_C( 30820),
                              UINT16_C( 65535), UINT16_C( 14085), UINT16_C( 29382), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 62441), UINT16_C( 65535), UINT16_C( 65535)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_shuffle_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C( -94), INT8_C( -41), INT8_C( -59),
                           INT8_C(  40), INT8_C(  78), INT8_C(  93), INT8_C( 107),
                           INT8_C( -47), INT8_C(  66), INT8_C(  -8), INT8_C( -52),
                           INT8_C(  50), INT8_C(  78), INT8_C(  13), INT8_C(  26),
                           INT8_C( -33), INT8_C( 120), INT8_C(  67), INT8_C( -12),
                           INT8_C(  80), INT8_C(  88), INT8_C( -65), INT8_C(  49),
                           INT8_C(  28), INT8_C(  96), INT8_C( -99), INT8_C(-119),
                           INT8_C( 126), INT8_C(  24), INT8_C(  35), INT8_C(  11),
                           INT8_C( -43), INT8_C( -24), INT8_C(   1), INT8_C( -61),
                           INT8_C( 101), INT8_C(   5), INT8_C(  67), INT8_C( -42),
                           INT8_C( -46), INT8_C(-115), INT8_C(-105), INT8_C( -92),
                           INT8_C(  -3), INT8_C( -44), INT8_C(  13), INT8_C( -36),
                           INT8_C( 110), INT8_C( -38), INT8_C( -48), INT8_C(  36),
                           INT8_C( 117), INT8_C( -59), INT8_C( 109), INT8_C( -27),
                           INT8_C( -62), INT8_C(  98), INT8_C(-121), INT8_C(-108),
                           INT8_C(  -7), INT8_C(-112), INT8_C( -52), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(  34), INT8_C( -71), INT8_C( -63),
                           INT8_C( -34), INT8_C(-128), INT8_C( 113), INT8_C( -72),
                           INT8_C(  86), INT8_C( -73), INT8_C( -43), INT8_C(  95),
                           INT8_C(   3), INT8_C(  13), INT8_C(  19), INT8_C(  -1),
                           INT8_C( -54), INT8_C( 114), INT8_C(  27), INT8_C( -30),
                           INT8_C(  52), INT8_C( -54), INT8_C(  78), INT8_C(  23),
                           INT8_C(  71), INT8_C(  87), INT8_C( 107), INT8_C( -27),
                           INT8_C( -35), INT8_C(-122), INT8_C(  40), INT8_C(  55),
                           INT8_C(  -2), INT8_C(  40), INT8_C( -63), INT8_C(  85),
                           INT8_C( -25), INT8_C( -93), INT8_C(  25), INT8_C(  70),
                           INT8_C( 117), INT8_C(  66), INT8_C( -79), INT8_C(  57),
                           INT8_C(-115), INT8_C( -27), INT8_C(  59), INT8_C(  25),
                           INT8_C(  -6), INT8_C(  42), INT8_C( -27), INT8_C( -34),
                           INT8_C( -16), INT8_C(   5), INT8_C( -55), INT8_C(  74),
                           INT8_C( -29), INT8_C(  77), INT8_C( -17), INT8_C(  16),
                           INT8_C( -98), INT8_C( -38), INT8_C( 116), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  13), INT8_C(   0),
                           INT8_C(  66), INT8_C(   0), INT8_C(   0), INT8_C(  56),
                           INT8_C(  50), INT8_C( -41), INT8_C(  50), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(  80), INT8_C(   0),
                           INT8_C(-119), INT8_C(   0), INT8_C( 120), INT8_C(  28),
                           INT8_C(  28), INT8_C(  28), INT8_C(  80), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  49), INT8_C(  28),
                           INT8_C(   0), INT8_C( -42), INT8_C(   0), INT8_C(-105),
                           INT8_C(   0), INT8_C(   0), INT8_C(  67), INT8_C(-115),
                           INT8_C(-105), INT8_C( -44), INT8_C(   0), INT8_C(  67),
                           INT8_C(   0), INT8_C(   0), INT8_C( 101), INT8_C(  67),
                           INT8_C(   0), INT8_C( -59), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-121), INT8_C(   0), INT8_C( -59),
                           INT8_C(   0), INT8_C( -48), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(-108), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( -75), INT8_C(-123), INT8_C( -44), INT8_C( -97),
                           INT8_C(  61), INT8_C(-112), INT8_C( 109), INT8_C(  27),
                           INT8_C(  -9), INT8_C( -31), INT8_C(-111), INT8_C( -59),
                           INT8_C(  94), INT8_C( 110), INT8_C(  31), INT8_C(  50),
                           INT8_C( -86), INT8_C(  24), INT8_C(  91), INT8_C(-105),
                           INT8_C(  39), INT8_C(  25), INT8_C( -65), INT8_C(  69),
                           INT8_C( -59), INT8_C( -57), INT8_C( -98), INT8_C(  26),
                           INT8_C( -35), INT8_C(  -2), INT8_C( 114), INT8_C( -51),
                           INT8_C( -16), INT8_C( 101), INT8_C( -92), INT8_C(  65),
                           INT8_C( -88), INT8_C(  19), INT8_C(-102), INT8_C( -51),
                           INT8_C( -94), INT8_C( -30), INT8_C(  60), INT8_C(  -9),
                           INT8_C(   4), INT8_C( -93), INT8_C( 110), INT8_C(-102),
                           INT8_C( 109), INT8_C(   1), INT8_C( 113), INT8_C( 114),
                           INT8_C( 100), INT8_C(  80), INT8_C(  18), INT8_C(  -7),
                           INT8_C( -87), INT8_C(   0), INT8_C( -55), INT8_C(  37),
                           INT8_C(  13), INT8_C(  86), INT8_C(-114), INT8_C(-125)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C(  11), INT8_C(  73), INT8_C(  57),
                           INT8_C( -54), INT8_C(   9), INT8_C(  69), INT8_C( -45),
                           INT8_C(  71), INT8_C(  -6), INT8_C( -68), INT8_C(  -8),
                           INT8_C(  14), INT8_C( -27), INT8_C(  84), INT8_C( -90),
                           INT8_C( -10), INT8_C( -81), INT8_C(  77), INT8_C(-113),
                           INT8_C(  32), INT8_C(  17), INT8_C(  62), INT8_C( -18),
                           INT8_C( 124), INT8_C( -42), INT8_C( -52), INT8_C(-109),
                           INT8_C( -19), INT8_C(  30), INT8_C( -51), INT8_C(-111),
                           INT8_C( 100), INT8_C(  63), INT8_C( -80), INT8_C(-126),
                           INT8_C(   3), INT8_C( 119), INT8_C(  38), INT8_C( -44),
                           INT8_C( -48), INT8_C( -43), INT8_C(   6), INT8_C(-113),
                           INT8_C(  -5), INT8_C( -18), INT8_C(  58), INT8_C(  77),
                           INT8_C( -49), INT8_C(-107), INT8_C( -77), INT8_C( 119),
                           INT8_C(  -6), INT8_C(  92), INT8_C(-122), INT8_C(  43),
                           INT8_C(  85), INT8_C(-111), INT8_C( -15), INT8_C(  90),
                           INT8_C(-104), INT8_C(  31), INT8_C(  -4), INT8_C(  57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(  61), INT8_C( 109), INT8_C( 109),
                           INT8_C(   0), INT8_C( 109), INT8_C(-111), INT8_C(   0),
                           INT8_C(  -9), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-123), INT8_C(   0), INT8_C( -59), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C( -51), INT8_C( 114), INT8_C(  24), INT8_C(   0),
                           INT8_C(-105), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -9), INT8_C( -16), INT8_C(   0), INT8_C(   0),
                           INT8_C(   4), INT8_C( -94), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  19), INT8_C( -92),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -87),
                           INT8_C(   0), INT8_C( 114), INT8_C(   0), INT8_C( 100),
                           INT8_C( -55), INT8_C(   0), INT8_C(   0), INT8_C(  80),
                           INT8_C(   0), INT8_C( 109), INT8_C(   0), INT8_C(  18)) },
    { simde_mm512_set_epi8(INT8_C( -54), INT8_C(  53), INT8_C(  35), INT8_C(  51),
                           INT8_C(  24), INT8_C( 100), INT8_C(  80), INT8_C(   7),
                           INT8_C(  54), INT8_C( 114), INT8_C( -42), INT8_C(  -2),
                           INT8_C(  18), INT8_C( 100), INT8_C(  26), INT8_C( -68),
                           INT8_C(  82), INT8_C( -30), INT8_C(  -4), INT8_C( 110),
                           INT8_C(  24), INT8_C(  88), INT8_C(-100), INT8_C(-120),
                           INT8_C( -17), INT8_C(-109), INT8_C(  92), INT8_C(-105),
                           INT8_C( -20), INT8_C(  34), INT8_C(  98), INT8_C( -17),
                           INT8_C(   2), INT8_C(   6), INT8_C(  37), INT8_C( -85),
                           INT8_C( 118), INT8_C(  28), INT8_C(  34), INT8_C( 117),
                           INT8_C(  77), INT8_C( -32), INT8_C(  25), INT8_C( -74),
                           INT8_C(  93), INT8_C(-108), INT8_C(   3), INT8_C( -90),
                           INT8_C(  13), INT8_C( -29), INT8_C( -88), INT8_C( 116),
                           INT8_C(  14), INT8_C( -29), INT8_C(  30), INT8_C( -26),
                           INT8_C(-115), INT8_C( -36), INT8_C(  94), INT8_C(-125),
                           INT8_C( 118), INT8_C( 125), INT8_C( -91), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C( -74), INT8_C( -13), INT8_C( -87), INT8_C( -10),
                           INT8_C(  21), INT8_C(  49), INT8_C( -64), INT8_C(  52),
                           INT8_C( -97), INT8_C(-103), INT8_C(-127), INT8_C(  53),
                           INT8_C(  99), INT8_C(  80), INT8_C(  55), INT8_C( 111),
                           INT8_C(  61), INT8_C( -93), INT8_C( -87), INT8_C(  81),
                           INT8_C( 108), INT8_C(  89), INT8_C(  63), INT8_C(-109),
                           INT8_C( -47), INT8_C( -32), INT8_C( 105), INT8_C(  91),
                           INT8_C(  88), INT8_C(  85), INT8_C( -96), INT8_C(  88),
                           INT8_C( -85), INT8_C(   3), INT8_C( 124), INT8_C( -33),
                           INT8_C( -21), INT8_C(  -7), INT8_C( -31), INT8_C(-126),
                           INT8_C(   3), INT8_C( -17), INT8_C(  40), INT8_C(   5),
                           INT8_C( 126), INT8_C( -60), INT8_C( -91), INT8_C(-112),
                           INT8_C(  88), INT8_C(  11), INT8_C( 100), INT8_C( 114),
                           INT8_C( 112), INT8_C( -53), INT8_C(  89), INT8_C(  78),
                           INT8_C( 115), INT8_C( 117), INT8_C( -33), INT8_C(  14),
                           INT8_C( -42), INT8_C( -15), INT8_C(  80), INT8_C( -46)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -42), INT8_C(  26), INT8_C(   0), INT8_C(  -2),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C(  18), INT8_C( -68), INT8_C(  54), INT8_C( -54),
                           INT8_C(  -4), INT8_C(   0), INT8_C(   0), INT8_C(  98),
                           INT8_C( 110), INT8_C(-100), INT8_C(  82), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-100), INT8_C(  24),
                           INT8_C(-120), INT8_C(  92), INT8_C(   0), INT8_C(-120),
                           INT8_C(   0), INT8_C(  93), INT8_C( -85), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( 117), INT8_C(  25),
                           INT8_C(   6), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -26), INT8_C(  14), INT8_C(-125), INT8_C( 125),
                           INT8_C(  31), INT8_C(   0), INT8_C(  30), INT8_C( -29),
                           INT8_C( 118), INT8_C(  94), INT8_C(   0), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  31), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-109), INT8_C(  14), INT8_C( -91), INT8_C( -44),
                           INT8_C(  79), INT8_C(  -4), INT8_C(  88), INT8_C(  49),
                           INT8_C( -95), INT8_C( -92), INT8_C(-116), INT8_C(   8),
                           INT8_C(  25), INT8_C(  30), INT8_C( -55), INT8_C(-120),
                           INT8_C( -58), INT8_C( -84), INT8_C(  99), INT8_C( -92),
                           INT8_C( -29), INT8_C( -47), INT8_C(  42), INT8_C( -56),
                           INT8_C( 109), INT8_C( -71), INT8_C( -73), INT8_C( -30),
                           INT8_C( -15), INT8_C(-106), INT8_C( -91), INT8_C( -57),
                           INT8_C(  51), INT8_C(  -8), INT8_C(  55), INT8_C(  36),
                           INT8_C( -55), INT8_C(-103), INT8_C(  51), INT8_C( -28),
                           INT8_C(  70), INT8_C( 114), INT8_C(  -3), INT8_C(  49),
                           INT8_C(  23), INT8_C( -28), INT8_C( -87), INT8_C(  57),
                           INT8_C(  28), INT8_C( -12), INT8_C( -51), INT8_C(  37),
                           INT8_C(  29), INT8_C( -58), INT8_C( -69), INT8_C(  30),
                           INT8_C(  43), INT8_C( -65), INT8_C(  -2), INT8_C( -83),
                           INT8_C( -27), INT8_C(-122), INT8_C(  77), INT8_C(  47)),
      simde_mm512_set_epi8(INT8_C(-116), INT8_C(-127), INT8_C( -95), INT8_C( -97),
                           INT8_C( -78), INT8_C( -53), INT8_C( -36), INT8_C(  62),
                           INT8_C(  63), INT8_C(  28), INT8_C( -37), INT8_C(  40),
                           INT8_C( -14), INT8_C(   2), INT8_C( -65), INT8_C( -67),
                           INT8_C(  79), INT8_C(  51), INT8_C( -51), INT8_C( -64),
                           INT8_C( -40), INT8_C(-102), INT8_C(-107), INT8_C(  82),
                           INT8_C(  20), INT8_C(  54), INT8_C(  66), INT8_C(   7),
                           INT8_C(  33), INT8_C( 108), INT8_C( -88), INT8_C(  69),
                           INT8_C(  98), INT8_C(  43), INT8_C(  25), INT8_C(  58),
                           INT8_C( 117), INT8_C( -34), INT8_C( -70), INT8_C(   3),
                           INT8_C(   1), INT8_C( 100), INT8_C(   3), INT8_C(  14),
                           INT8_C( 117), INT8_C( -91), INT8_C( -89), INT8_C(  66),
                           INT8_C(  32), INT8_C( -35), INT8_C( 104), INT8_C(  65),
                           INT8_C(-100), INT8_C(  27), INT8_C(  42), INT8_C(  91),
                           INT8_C( -47), INT8_C(  39), INT8_C( -65), INT8_C(-124),
                           INT8_C( -84), INT8_C( -95), INT8_C( -46), INT8_C(-113)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  14),
                           INT8_C(-109), INT8_C( -44), INT8_C(   0), INT8_C(  49),
                           INT8_C(   0), INT8_C(  30), INT8_C(   0), INT8_C(   0),
                           INT8_C( -58), INT8_C( -15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-106),
                           INT8_C( -30), INT8_C( -71), INT8_C(-106), INT8_C( 109),
                           INT8_C( -91), INT8_C( -92), INT8_C(   0), INT8_C( -73),
                           INT8_C( -28), INT8_C( -55), INT8_C(  51), INT8_C(-103),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  23),
                           INT8_C( -87), INT8_C(  49), INT8_C(  23), INT8_C(  -8),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C( -28),
                           INT8_C(  47), INT8_C(   0), INT8_C(  30), INT8_C(  77),
                           INT8_C(   0), INT8_C(  29), INT8_C( -58), INT8_C(  29),
                           INT8_C(   0), INT8_C(  43), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-119), INT8_C(  55), INT8_C( -13), INT8_C(-118),
                           INT8_C(   5), INT8_C(  14), INT8_C(-103), INT8_C(  58),
                           INT8_C( 109), INT8_C(-113), INT8_C( -44), INT8_C( 126),
                           INT8_C(  70), INT8_C(-126), INT8_C(  24), INT8_C(-117),
                           INT8_C(  80), INT8_C(  25), INT8_C(  64), INT8_C( -89),
                           INT8_C(  60), INT8_C(   5), INT8_C(-119), INT8_C( -29),
                           INT8_C( -95), INT8_C( -26), INT8_C(  25), INT8_C( -65),
                           INT8_C( -81), INT8_C( -84), INT8_C(  46), INT8_C(  62),
                           INT8_C( -25), INT8_C(-116), INT8_C(-126), INT8_C(-103),
                           INT8_C( 126), INT8_C( -39), INT8_C( 111), INT8_C( -10),
                           INT8_C( -48), INT8_C( 122), INT8_C( -86), INT8_C( -25),
                           INT8_C(  35), INT8_C(  -4), INT8_C(  -7), INT8_C(  76),
                           INT8_C(-116), INT8_C(   1), INT8_C( 126), INT8_C( -30),
                           INT8_C( -11), INT8_C(  82), INT8_C(  81), INT8_C(  27),
                           INT8_C( -15), INT8_C( -14), INT8_C(  56), INT8_C(  60),
                           INT8_C( -29), INT8_C( -65), INT8_C( -35), INT8_C(  21)),
      simde_mm512_set_epi8(INT8_C( 125), INT8_C( -43), INT8_C( -42), INT8_C( -51),
                           INT8_C( -36), INT8_C(  38), INT8_C(  42), INT8_C(  18),
                           INT8_C(  24), INT8_C( -25), INT8_C(  19), INT8_C(  15),
                           INT8_C(-119), INT8_C(-124), INT8_C( 104), INT8_C( -93),
                           INT8_C(  22), INT8_C( -16), INT8_C(  31), INT8_C( 116),
                           INT8_C( -99), INT8_C(  45), INT8_C( -54), INT8_C(  50),
                           INT8_C( -72), INT8_C(-107), INT8_C(  48), INT8_C( 118),
                           INT8_C( -68), INT8_C( -15), INT8_C(-108), INT8_C( -29),
                           INT8_C( 118), INT8_C(  96), INT8_C( -51), INT8_C( 107),
                           INT8_C( -23), INT8_C( -97), INT8_C(  -6), INT8_C(  91),
                           INT8_C( -57), INT8_C( -67), INT8_C(-105), INT8_C(  68),
                           INT8_C( -50), INT8_C(  16), INT8_C( -86), INT8_C(   6),
                           INT8_C(  55), INT8_C(-118), INT8_C( 112), INT8_C( 125),
                           INT8_C(  92), INT8_C(  91), INT8_C( -27), INT8_C(  53),
                           INT8_C(  28), INT8_C( -66), INT8_C( -69), INT8_C(-117),
                           INT8_C( -30), INT8_C(-106), INT8_C(   1), INT8_C(  95)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-113), INT8_C(  14), INT8_C(-126),
                           INT8_C(  58), INT8_C(   0), INT8_C(  70), INT8_C(-119),
                           INT8_C(   0), INT8_C(   0), INT8_C(  58), INT8_C(   0),
                           INT8_C( -26), INT8_C(   0), INT8_C(  80), INT8_C( -65),
                           INT8_C(   0), INT8_C(  64), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(  62), INT8_C( -26),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 122), INT8_C(  76), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -25),
                           INT8_C(   0), INT8_C(  76), INT8_C(   0), INT8_C( 122),
                           INT8_C( -15), INT8_C(   0), INT8_C(  21), INT8_C( 126),
                           INT8_C( -30), INT8_C( -11), INT8_C(   0), INT8_C(  56),
                           INT8_C( -30), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -35), INT8_C(-116)) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(-124), INT8_C(  -6), INT8_C( -41),
                           INT8_C(-109), INT8_C(  19), INT8_C(  47), INT8_C(  73),
                           INT8_C( -58), INT8_C( -50), INT8_C(  73), INT8_C( 110),
                           INT8_C(  56), INT8_C( -30), INT8_C( -79), INT8_C( 123),
                           INT8_C(  77), INT8_C(  62), INT8_C( -28), INT8_C(  45),
                           INT8_C( -95), INT8_C(  12), INT8_C(  53), INT8_C(  75),
                           INT8_C(  66), INT8_C( -89), INT8_C(  46), INT8_C( -47),
                           INT8_C(   6), INT8_C(   4), INT8_C( 112), INT8_C( -34),
                           INT8_C( 121), INT8_C(  -3), INT8_C(-102), INT8_C(-115),
                           INT8_C( -12), INT8_C(  80), INT8_C(   3), INT8_C(  56),
                           INT8_C(  85), INT8_C( -43), INT8_C( -93), INT8_C(  34),
                           INT8_C( -58), INT8_C(-101), INT8_C(  51), INT8_C(   1),
                           INT8_C( -18), INT8_C( -90), INT8_C( -71), INT8_C(  74),
                           INT8_C(  -5), INT8_C(-113), INT8_C(  71), INT8_C(  61),
                           INT8_C(  92), INT8_C(  73), INT8_C( 116), INT8_C( 110),
                           INT8_C(-117), INT8_C(  96), INT8_C( -77), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C(  52), INT8_C( -84), INT8_C( 103), INT8_C(-105),
                           INT8_C( -57), INT8_C(  17), INT8_C(-110), INT8_C(-113),
                           INT8_C(  56), INT8_C( 125), INT8_C(  56), INT8_C( -88),
                           INT8_C( -31), INT8_C( 119), INT8_C( -86), INT8_C( 114),
                           INT8_C( -85), INT8_C(  14), INT8_C(  60), INT8_C(  84),
                           INT8_C( -61), INT8_C(-111), INT8_C(  74), INT8_C( 113),
                           INT8_C(  13), INT8_C( -89), INT8_C(-114), INT8_C( -79),
                           INT8_C( -34), INT8_C( -73), INT8_C(  -9), INT8_C(-108),
                           INT8_C(  93), INT8_C( -78), INT8_C(  -1), INT8_C(-102),
                           INT8_C(  12), INT8_C( 117), INT8_C(  80), INT8_C(  44),
                           INT8_C(  29), INT8_C(  18), INT8_C(  91), INT8_C( -23),
                           INT8_C( 110), INT8_C(-126), INT8_C( -71), INT8_C(  65),
                           INT8_C( -76), INT8_C(  85), INT8_C(  93), INT8_C( -86),
                           INT8_C(-123), INT8_C(-115), INT8_C(-105), INT8_C(  75),
                           INT8_C(  45), INT8_C(  22), INT8_C(  73), INT8_C(  74),
                           INT8_C( 107), INT8_C( -60), INT8_C( -28), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(   0), INT8_C( -58), INT8_C(   0),
                           INT8_C(   0), INT8_C( -79), INT8_C(   0), INT8_C(   0),
                           INT8_C(  73), INT8_C(  -6), INT8_C(  73), INT8_C(   0),
                           INT8_C(   0), INT8_C( -58), INT8_C(   0), INT8_C( -30),
                           INT8_C(   0), INT8_C(  62), INT8_C(  45), INT8_C( -47),
                           INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C( 112),
                           INT8_C( -28), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-102), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-115), INT8_C( -93), INT8_C(   1), INT8_C(-115),
                           INT8_C(-102), INT8_C(-101), INT8_C( -12), INT8_C(   0),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C( 116), INT8_C( -71), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -5),
                           INT8_C( -71), INT8_C(  73), INT8_C(  71), INT8_C(-113),
                           INT8_C(  -5), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(   4), INT8_C( -30), INT8_C( -68), INT8_C(  57),
                           INT8_C(  73), INT8_C(  25), INT8_C( -45), INT8_C( 112),
                           INT8_C(  41), INT8_C(  41), INT8_C( -56), INT8_C( -93),
                           INT8_C(  29), INT8_C(  99), INT8_C(  15), INT8_C( 122),
                           INT8_C(  74), INT8_C(   0), INT8_C(  89), INT8_C(  61),
                           INT8_C( 124), INT8_C(  36), INT8_C( -87), INT8_C( -25),
                           INT8_C(  42), INT8_C(-125), INT8_C( -87), INT8_C(  69),
                           INT8_C(  81), INT8_C(   4), INT8_C(  55), INT8_C( 107),
                           INT8_C(   0), INT8_C(  -7), INT8_C(  37), INT8_C( -15),
                           INT8_C( 117), INT8_C(   9), INT8_C( -27), INT8_C(  11),
                           INT8_C(  16), INT8_C(  87), INT8_C( 119), INT8_C(-107),
                           INT8_C( -22), INT8_C(  27), INT8_C( -86), INT8_C( -63),
                           INT8_C(  90), INT8_C( -44), INT8_C(-113), INT8_C(-126),
                           INT8_C( -75), INT8_C(  67), INT8_C(  88), INT8_C( 105),
                           INT8_C(  80), INT8_C(   7), INT8_C(  66), INT8_C( 126),
                           INT8_C(  17), INT8_C( -20), INT8_C( -91), INT8_C( -99)),
      simde_mm512_set_epi8(INT8_C( 123), INT8_C( 117), INT8_C(  18), INT8_C(   2),
                           INT8_C(-105), INT8_C( -51), INT8_C(  -9), INT8_C(  72),
                           INT8_C(  69), INT8_C(-116), INT8_C(  95), INT8_C(-110),
                           INT8_C( -32), INT8_C( 110), INT8_C(  -8), INT8_C(  85),
                           INT8_C( -41), INT8_C(  80), INT8_C( -44), INT8_C( 110),
                           INT8_C( -28), INT8_C( 116), INT8_C(  41), INT8_C( -31),
                           INT8_C(  12), INT8_C(  40), INT8_C(   5), INT8_C(   1),
                           INT8_C( -14), INT8_C(  66), INT8_C( -95), INT8_C( 106),
                           INT8_C(  66), INT8_C( -91), INT8_C( -20), INT8_C(-109),
                           INT8_C( -46), INT8_C(  41), INT8_C(  82), INT8_C( -61),
                           INT8_C(   2), INT8_C(   3), INT8_C(  62), INT8_C( -90),
                           INT8_C(  99), INT8_C( -54), INT8_C( -28), INT8_C( -21),
                           INT8_C( 126), INT8_C( 115), INT8_C( -46), INT8_C(  76),
                           INT8_C( -43), INT8_C(  46), INT8_C( 107), INT8_C(  75),
                           INT8_C( -93), INT8_C(  67), INT8_C( -37), INT8_C(   4),
                           INT8_C(-127), INT8_C( -50), INT8_C( -26), INT8_C(  99)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -56), INT8_C(  99), INT8_C(  99),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 112),
                           INT8_C( -56), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C( -30), INT8_C(   0), INT8_C( -56),
                           INT8_C(   0), INT8_C( 107), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  69), INT8_C( -87), INT8_C(   0),
                           INT8_C(  61), INT8_C( -25), INT8_C( -87), INT8_C(  55),
                           INT8_C(   0), INT8_C(   4), INT8_C(   0), INT8_C(  36),
                           INT8_C(  27), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -27), INT8_C(  27), INT8_C(   0),
                           INT8_C(  27), INT8_C( -22), INT8_C(  -7), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -44), INT8_C(  17), INT8_C(   0), INT8_C(-126),
                           INT8_C(   0), INT8_C( -44), INT8_C( -75), INT8_C( -75),
                           INT8_C(   0), INT8_C(  17), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  17)) },
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C(  24), INT8_C( -33), INT8_C(  82),
                           INT8_C(  72), INT8_C(  63), INT8_C(-114), INT8_C(  14),
                           INT8_C(   2), INT8_C(  71), INT8_C( -31), INT8_C( -46),
                           INT8_C(  64), INT8_C( -11), INT8_C(  35), INT8_C(  -7),
                           INT8_C( -78), INT8_C( 125), INT8_C( -28), INT8_C( -59),
                           INT8_C(   6), INT8_C(-127), INT8_C(  34), INT8_C(  64),
                           INT8_C(  88), INT8_C( -88), INT8_C(  70), INT8_C( -90),
                           INT8_C(  47), INT8_C( -21), INT8_C(-104), INT8_C( -27),
                           INT8_C( -16), INT8_C( -29), INT8_C(  51), INT8_C(-116),
                           INT8_C( -87), INT8_C(  91), INT8_C(-106), INT8_C(  -3),
                           INT8_C( -55), INT8_C( -15), INT8_C(-109), INT8_C(-108),
                           INT8_C( -41), INT8_C(  79), INT8_C(  54), INT8_C(  68),
                           INT8_C( -51), INT8_C(-108), INT8_C( -83), INT8_C( 104),
                           INT8_C(  18), INT8_C(-128), INT8_C( -75), INT8_C( -12),
                           INT8_C(  56), INT8_C(-104), INT8_C(  56), INT8_C(  47),
                           INT8_C( -30), INT8_C( -15), INT8_C(-115), INT8_C(  88)),
      simde_mm512_set_epi8(INT8_C( 107), INT8_C( 125), INT8_C(-111), INT8_C( -89),
                           INT8_C(  -9), INT8_C( 122), INT8_C(  -2), INT8_C( -26),
                           INT8_C(-100), INT8_C(  80), INT8_C(  89), INT8_C(  38),
                           INT8_C(  95), INT8_C( -82), INT8_C( -66), INT8_C( 108),
                           INT8_C( 104), INT8_C( -20), INT8_C(  72), INT8_C( -82),
                           INT8_C(  23), INT8_C( -45), INT8_C( -20), INT8_C(   8),
                           INT8_C(  -2), INT8_C( -77), INT8_C(-112), INT8_C( 102),
                           INT8_C(  83), INT8_C(  80), INT8_C(  56), INT8_C( -53),
                           INT8_C( -83), INT8_C( -86), INT8_C(  15), INT8_C(  30),
                           INT8_C( -92), INT8_C(  -2), INT8_C(  42), INT8_C( -79),
                           INT8_C( 108), INT8_C(  44), INT8_C(  17), INT8_C(  83),
                           INT8_C( -49), INT8_C( -44), INT8_C( -42), INT8_C( -54),
                           INT8_C(-127), INT8_C(  12), INT8_C(  88), INT8_C(-118),
                           INT8_C( -23), INT8_C( -69), INT8_C( -23), INT8_C( -36),
                           INT8_C( -23), INT8_C( -80), INT8_C(  33), INT8_C(  82),
                           INT8_C( -43), INT8_C( -91), INT8_C( -36), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  72), INT8_C( -33), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -7), INT8_C(-114), INT8_C(  71),
                           INT8_C(  56), INT8_C(   0), INT8_C(   0), INT8_C(  82),
                           INT8_C(  64), INT8_C(   0), INT8_C(  64), INT8_C(   0),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C(  64),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -88),
                           INT8_C(  47), INT8_C( -27), INT8_C(  64), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C(-116), INT8_C(-116), INT8_C(  54), INT8_C( -41),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 104), INT8_C( -12), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-115), INT8_C( -15),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_shuffle_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpeq_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -32),
                           INT8_C( 100), INT8_C( 125), INT8_C(  89), INT8_C(  95),
                           INT8_C( -23), INT8_C(  76), INT8_C(  84), INT8_C( -43),
                           INT8_C(  86), INT8_C(  29), INT8_C(  64), INT8_C(  30),
                           INT8_C( -17), INT8_C( -61), INT8_C( 115), INT8_C( -53),
                           INT8_C(-100), INT8_C( 104), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C(  20), INT8_C(  31), INT8_C(-121),
                           INT8_C(  90), INT8_C(  18), INT8_C(   6), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  39), INT8_C( -25),
                           INT8_C(  60), INT8_C( 110), INT8_C(  45), INT8_C( 113),
                           INT8_C(  81), INT8_C(  78), INT8_C( -53), INT8_C(  11),
                           INT8_C( -27), INT8_C(-113), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C( 111),
                           INT8_C( -91), INT8_C( -21), INT8_C( 102), INT8_C(   8),
                           INT8_C( -41), INT8_C( -47), INT8_C( -90), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C(  89), INT8_C( -62)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -46),
                           INT8_C(  72), INT8_C(  42), INT8_C(  65), INT8_C( -27),
                           INT8_C( -37), INT8_C(  76), INT8_C(  84), INT8_C( -95),
                           INT8_C( -29), INT8_C(  29), INT8_C(  64), INT8_C(  75),
                           INT8_C( -17), INT8_C( -61), INT8_C(  76), INT8_C(  88),
                           INT8_C(-100), INT8_C( -91), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C( -17), INT8_C(  31), INT8_C(  68),
                           INT8_C(  90), INT8_C(  18), INT8_C(-110), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  24), INT8_C( -25),
                           INT8_C(  80), INT8_C( 122), INT8_C( 103), INT8_C(-115),
                           INT8_C(  81), INT8_C(  24), INT8_C(  32), INT8_C(  82),
                           INT8_C( -27), INT8_C( 105), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C(-121),
                           INT8_C( -91), INT8_C(-124), INT8_C( 102), INT8_C(  46),
                           INT8_C( -41), INT8_C( 101), INT8_C(  51), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C( -12), INT8_C( -62)),
      UINT64_C(0xe066cbadd08bea9d) },
    { simde_mm512_set_epi8(INT8_C( -84), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C(  27), INT8_C( 124), INT8_C(-120),
                           INT8_C(   3), INT8_C(  26), INT8_C(  43), INT8_C( -96),
                           INT8_C( -63), INT8_C(  49), INT8_C( 127), INT8_C(   0),
                           INT8_C( -20), INT8_C( -31), INT8_C( 125), INT8_C(  14),
                           INT8_C( -53), INT8_C( -87), INT8_C( 115), INT8_C( -20),
                           INT8_C( -93), INT8_C(  70), INT8_C(  29), INT8_C( -90),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C(-106),
                           INT8_C(  94), INT8_C( -52), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  81),
                           INT8_C(  35), INT8_C( 120), INT8_C(  47), INT8_C( -25),
                           INT8_C( 110), INT8_C(  55), INT8_C(  40), INT8_C( -31),
                           INT8_C(  93), INT8_C( -23), INT8_C(   4), INT8_C(  45),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( -52),
                           INT8_C(  42), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( -31), INT8_C(-113), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C(  25), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C( 119), INT8_C( 122), INT8_C(  82),
                           INT8_C(   3), INT8_C(-111), INT8_C(  60), INT8_C( -96),
                           INT8_C(  26), INT8_C(   3), INT8_C(  -7), INT8_C(  -8),
                           INT8_C(  94), INT8_C( -31), INT8_C( -71), INT8_C(  14),
                           INT8_C(-105), INT8_C( -87), INT8_C( 115), INT8_C( -68),
                           INT8_C( -93), INT8_C(  70), INT8_C( -47), INT8_C(-106),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C( 105),
                           INT8_C(  94), INT8_C(  84), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  39),
                           INT8_C(  35), INT8_C( -87), INT8_C( -83), INT8_C( -25),
                           INT8_C( 110), INT8_C(   2), INT8_C( -90), INT8_C( -31),
                           INT8_C(  19), INT8_C( -23), INT8_C(   4), INT8_C(  16),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( 127),
                           INT8_C( -60), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( 109), INT8_C(-113), INT8_C(  25)),
      UINT64_C(0x789056cebe996e7a) },
    { simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C(  25),
                           INT8_C( -37), INT8_C( -25), INT8_C( -34), INT8_C(-108),
                           INT8_C( -77), INT8_C(-114), INT8_C(  79), INT8_C( -50),
                           INT8_C( -94), INT8_C(  22), INT8_C( -28), INT8_C(-105),
                           INT8_C( 110), INT8_C(  29), INT8_C(  -9), INT8_C( -13),
                           INT8_C( -71), INT8_C( 107), INT8_C(-115), INT8_C(  86),
                           INT8_C(-127), INT8_C(-100), INT8_C(   1), INT8_C(  21),
                           INT8_C( -55), INT8_C( -85), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C(  39), INT8_C(  18), INT8_C( -92),
                           INT8_C(  11), INT8_C( -32), INT8_C( -53), INT8_C(  38),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  45), INT8_C( -24),
                           INT8_C( -47), INT8_C(  95), INT8_C(  50), INT8_C( 105),
                           INT8_C(  58), INT8_C(  25), INT8_C( -53), INT8_C( -61),
                           INT8_C( -90), INT8_C(  92), INT8_C(  83), INT8_C( 120),
                           INT8_C( 107), INT8_C( -72), INT8_C(   3), INT8_C(  -1)),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C( -75),
                           INT8_C( -37), INT8_C( -25), INT8_C(  14), INT8_C(-108),
                           INT8_C(   5), INT8_C(-114), INT8_C(  79), INT8_C(  57),
                           INT8_C( -94), INT8_C(  22), INT8_C(   4), INT8_C(   3),
                           INT8_C(  66), INT8_C(  29), INT8_C(  -9), INT8_C(  20),
                           INT8_C(  93), INT8_C( 107), INT8_C(   6), INT8_C(  86),
                           INT8_C(  84), INT8_C(-100), INT8_C(  81), INT8_C(  21),
                           INT8_C( 117), INT8_C(  22), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C( -17), INT8_C(  19), INT8_C( 106),
                           INT8_C( 114), INT8_C( -32), INT8_C(  98), INT8_C( -16),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  97), INT8_C(  29),
                           INT8_C( -47), INT8_C( -47), INT8_C(  50), INT8_C(-111),
                           INT8_C(  58), INT8_C( 115), INT8_C( -53), INT8_C(  93),
                           INT8_C( -90), INT8_C( -27), INT8_C(  41), INT8_C( 120),
                           INT8_C( 119), INT8_C(  86), INT8_C( -36), INT8_C(  -1)),
      UINT64_C(0xed6c655384fcaa91) },
    { simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C(  91), INT8_C( -99),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(  96),
                           INT8_C(  14), INT8_C(  -1), INT8_C(  14), INT8_C( 100),
                           INT8_C(-114), INT8_C(  63), INT8_C(  68), INT8_C(-113),
                           INT8_C( -59), INT8_C( -42), INT8_C( -14), INT8_C(-111),
                           INT8_C(   6), INT8_C(  68), INT8_C(  11), INT8_C(-108),
                           INT8_C( -62), INT8_C(  87), INT8_C( -72), INT8_C( -23),
                           INT8_C(  78), INT8_C( -18), INT8_C( -36), INT8_C(  -6),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( 127),
                           INT8_C( -36), INT8_C(  21), INT8_C(  38), INT8_C(-106),
                           INT8_C(  33), INT8_C( -66), INT8_C(-121), INT8_C(  36),
                           INT8_C(  24), INT8_C(  61), INT8_C(  66), INT8_C(  20),
                           INT8_C(  63), INT8_C( -18), INT8_C(  11), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  62), INT8_C(  85), INT8_C(  62)),
      simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C( -74), INT8_C( -47),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(-128),
                           INT8_C(  94), INT8_C(  -1), INT8_C(  99), INT8_C( 100),
                           INT8_C( -25), INT8_C(   7), INT8_C(  59), INT8_C(-113),
                           INT8_C( 119), INT8_C( -42), INT8_C( -14), INT8_C(  79),
                           INT8_C(   4), INT8_C(-111), INT8_C(  11), INT8_C(  80),
                           INT8_C( -78), INT8_C(  87), INT8_C( -72), INT8_C(-111),
                           INT8_C( -95), INT8_C( -18), INT8_C( -36), INT8_C( -40),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( -50),
                           INT8_C( -36), INT8_C(  10), INT8_C(  47), INT8_C(  62),
                           INT8_C( -15), INT8_C( -66), INT8_C(-122), INT8_C(  36),
                           INT8_C( -22), INT8_C(  61), INT8_C( -11), INT8_C(  20),
                           INT8_C(  63), INT8_C(  82), INT8_C(-113), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  23), INT8_C(  85), INT8_C(  62)),
      UINT64_C(0xce516266e8559ffb) },
    { simde_mm512_set_epi8(INT8_C(  -7), INT8_C(   2), INT8_C(-111), INT8_C(  64),
                           INT8_C(-100), INT8_C(  87), INT8_C( 100), INT8_C( -30),
                           INT8_C( -39), INT8_C( -38), INT8_C( 121), INT8_C(  55),
                           INT8_C( -64), INT8_C(  81), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C( -34),
                           INT8_C( -13), INT8_C(  63), INT8_C(  26), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C( -17),
                           INT8_C(-100), INT8_C( -71), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( 100), INT8_C(  36),
                           INT8_C(  17), INT8_C( 116), INT8_C( -30), INT8_C(  16),
                           INT8_C( 110), INT8_C(  98), INT8_C(  11), INT8_C( -42),
                           INT8_C( -78), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C(  12), INT8_C( -40), INT8_C( -27), INT8_C( -40),
                           INT8_C(-102), INT8_C(-109), INT8_C(  39), INT8_C(  29),
                           INT8_C(  21), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -49), INT8_C(   7), INT8_C(  91), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(   2), INT8_C( -91), INT8_C(  64),
                           INT8_C(-100), INT8_C(  41), INT8_C( -34), INT8_C( -46),
                           INT8_C( -39), INT8_C(  31), INT8_C(  13), INT8_C(  55),
                           INT8_C( -42), INT8_C(  33), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C(  90),
                           INT8_C( -13), INT8_C(  63), INT8_C(  51), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C(-112),
                           INT8_C(-100), INT8_C(  41), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( -85), INT8_C(-109),
                           INT8_C( 113), INT8_C( 116), INT8_C( 100), INT8_C(  16),
                           INT8_C(   5), INT8_C( -50), INT8_C( -51), INT8_C( -42),
                           INT8_C( -95), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C( -73), INT8_C(  71), INT8_C(  65), INT8_C( -40),
                           INT8_C(-102), INT8_C(   7), INT8_C(  94), INT8_C(  29),
                           INT8_C(  65), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -33), INT8_C(   7), INT8_C(-101), INT8_C(  15)),
      UINT64_C(0x5893edebc5171975) },
    { simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C( 105), INT8_C(-124),
                           INT8_C( -33), INT8_C( -79), INT8_C(  -6), INT8_C(  54),
                           INT8_C(  81), INT8_C( -11), INT8_C(  67), INT8_C(  63),
                           INT8_C( 103), INT8_C( 119), INT8_C( -89), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  71), INT8_C(  66),
                           INT8_C(-106), INT8_C( -45), INT8_C(  18), INT8_C( 100),
                           INT8_C( 122), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C( -39), INT8_C(  37), INT8_C( -70), INT8_C(  13),
                           INT8_C(  99), INT8_C( -57), INT8_C( -88), INT8_C( -36),
                           INT8_C(-103), INT8_C(  25), INT8_C(  94), INT8_C(-107),
                           INT8_C( -32), INT8_C( -12), INT8_C( -14), INT8_C(  32),
                           INT8_C( -38), INT8_C(  10), INT8_C(  89), INT8_C( -69),
                           INT8_C(  -8), INT8_C(  69), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( 102),
                           INT8_C( 119), INT8_C( -58), INT8_C( -49), INT8_C(  80),
                           INT8_C( -15), INT8_C( -97), INT8_C(  45), INT8_C(  96)),
      simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C(  81), INT8_C(-115),
                           INT8_C( -33), INT8_C( -79), INT8_C(-117), INT8_C( -34),
                           INT8_C(  81), INT8_C( -11), INT8_C( -63), INT8_C( -61),
                           INT8_C(  53), INT8_C( 119), INT8_C(  26), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  25), INT8_C( -23),
                           INT8_C( -16), INT8_C( -45), INT8_C( -64), INT8_C( 100),
                           INT8_C(  91), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C(  81), INT8_C( -76), INT8_C( -70), INT8_C(  13),
                           INT8_C(  26), INT8_C( -57), INT8_C( -88), INT8_C( -64),
                           INT8_C( -68), INT8_C( -91), INT8_C(-123), INT8_C(  38),
                           INT8_C( -32), INT8_C(  29), INT8_C(  82), INT8_C(  54),
                           INT8_C(-107), INT8_C(  10), INT8_C(  89), INT8_C(  28),
                           INT8_C( -27), INT8_C(  41), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( -30),
                           INT8_C(  97), INT8_C(  18), INT8_C( -90), INT8_C( 107),
                           INT8_C(  99), INT8_C(  10), INT8_C(  45), INT8_C(  96)),
      UINT64_C(0xccc5c57360863e03) },
    { simde_mm512_set_epi8(INT8_C(  48), INT8_C(  94), INT8_C( 112), INT8_C(-107),
                           INT8_C( -34), INT8_C( -86), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C( -99), INT8_C(  28), INT8_C(  47),
                           INT8_C(-117), INT8_C( -22), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(-107), INT8_C( -23), INT8_C(  77),
                           INT8_C(  60), INT8_C( 104), INT8_C(-116), INT8_C( -86),
                           INT8_C(-113), INT8_C( -79), INT8_C( -64), INT8_C( -15),
                           INT8_C(-123), INT8_C(  99), INT8_C(  25), INT8_C(  27),
                           INT8_C( -40), INT8_C( 126), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C( -12), INT8_C(  16),
                           INT8_C( 122), INT8_C( 124), INT8_C( -75), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  -3),
                           INT8_C(  29), INT8_C( -20), INT8_C( -45), INT8_C( -46),
                           INT8_C( -45), INT8_C( -14), INT8_C(  99), INT8_C(  84),
                           INT8_C( -62), INT8_C( -99), INT8_C(-104), INT8_C( -78),
                           INT8_C( 106), INT8_C(-117), INT8_C( -94), INT8_C(   3)),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C( -74), INT8_C(   2), INT8_C( -83),
                           INT8_C(-112), INT8_C( -91), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C(  52), INT8_C(  28), INT8_C( -65),
                           INT8_C(-117), INT8_C( -90), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(  16), INT8_C(-124), INT8_C(  77),
                           INT8_C(  60), INT8_C( -64), INT8_C(-116), INT8_C( -89),
                           INT8_C(  -7), INT8_C( -79), INT8_C(  46), INT8_C( 114),
                           INT8_C(-107), INT8_C(  99), INT8_C( -79), INT8_C(  80),
                           INT8_C( -40), INT8_C( -81), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C(  66), INT8_C(  71),
                           INT8_C( 122), INT8_C(  95), INT8_C( -43), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  95),
                           INT8_C(   5), INT8_C( -20), INT8_C( -45), INT8_C(-118),
                           INT8_C(  70), INT8_C(  81), INT8_C(   0), INT8_C(  84),
                           INT8_C( -62), INT8_C(-101), INT8_C(  13), INT8_C(  33),
                           INT8_C(-104), INT8_C(-117), INT8_C( -11), INT8_C(  20)),
      UINT64_C(0x3ab9a44bc9e6184) },
    { simde_mm512_set_epi8(INT8_C(  67), INT8_C(  34), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  58),
                           INT8_C(  57), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(  33), INT8_C(-122), INT8_C(  69),
                           INT8_C(  57), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C( -22), INT8_C(-100), INT8_C(  18), INT8_C( -65),
                           INT8_C( -60), INT8_C(-105), INT8_C(  27), INT8_C( -71),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(  64),
                           INT8_C(  20), INT8_C(  51), INT8_C(  87), INT8_C(  43),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C( -40),
                           INT8_C(  87), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C(  42), INT8_C( -93),
                           INT8_C(  44), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  96),
                           INT8_C(  72), INT8_C(  48), INT8_C( -46), INT8_C(  24),
                           INT8_C( -10), INT8_C( -98), INT8_C( -56), INT8_C( -41)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C( -63), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  -8),
                           INT8_C(  82), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(   0), INT8_C( -25), INT8_C(  69),
                           INT8_C(  27), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C(  -7), INT8_C( -28), INT8_C(  18), INT8_C( -65),
                           INT8_C(  67), INT8_C(  -3), INT8_C(  57), INT8_C( -68),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(-128),
                           INT8_C(  20), INT8_C(  37), INT8_C(   9), INT8_C(  80),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C(   9),
                           INT8_C( -98), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C( -81), INT8_C( -93),
                           INT8_C( 116), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  37),
                           INT8_C(  72), INT8_C( -73), INT8_C( -19), INT8_C(  96),
                           INT8_C(  52), INT8_C( -98), INT8_C( -45), INT8_C( -41)),
      UINT64_C(0xbe79730e8e7d7e85) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpeq_epi8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_uint64(r, ==, test_vec[i].r);
   }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cvtepi16_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C( 14423), INT16_C(  3775), INT16_C( 16156), INT16_C( 17811),
                            INT16_C(-14881), INT16_C(-30283), INT16_C( 27295), INT16_C(-12290),
                            INT16_C( 12394), INT16_C( 32764), INT16_C(  8681), INT16_C( 21255),
                            INT16_C(-21785), INT16_C(-24065), INT16_C(-28005), INT16_C( 15206),
                            INT16_C(  6131), INT16_C(-29323), INT16_C( -9530), INT16_C( -6655),
                            INT16_C( 14785), INT16_C( -9158), INT16_C(  7009), INT16_C(  4834),
                            INT16_C(-15579), INT16_C(  5296), INT16_C( 20054), INT16_C( 12832),
                            INT16_C( 15724), INT16_C(  5918), INT16_C( 25398), INT16_C( 14084)),
      simde_mm256_set_epi8(INT8_C(  87), INT8_C( -65), INT8_C(  28), INT8_C(-109),
                           INT8_C( -33), INT8_C( -75), INT8_C( -97), INT8_C(  -2),
                           INT8_C( 106), INT8_C(  -4), INT8_C( -23), INT8_C(   7),
                           INT8_C( -25), INT8_C(  -1), INT8_C(-101), INT8_C( 102),
                           INT8_C( -13), INT8_C( 117), INT8_C( -58), INT8_C(   1),
                           INT8_C( -63), INT8_C(  58), INT8_C(  97), INT8_C( -30),
                           INT8_C(  37), INT8_C( -80), INT8_C(  86), INT8_C(  32),
                           INT8_C( 108), INT8_C(  30), INT8_C(  54), INT8_C(   4)) },
    { simde_mm512_set_epi16(INT16_C(  8455), INT16_C(  1140), INT16_C(-23383), INT16_C( 22825),
                            INT16_C(-21438), INT16_C(  8713), INT16_C(-25940), INT16_C(-31180),
                            INT16_C(-13214), INT16_C( 10200), INT16_C(-21253), INT16_C(  2612),
                            INT16_C(-27891), INT16_C( 14031), INT16_C( -9014), INT16_C( 10287),
                            INT16_C(-11660), INT16_C( 26858), INT16_C(-19518), INT16_C(  2472),
                            INT16_C( 27637), INT16_C( 14857), INT16_C( 30034), INT16_C(-24153),
                            INT16_C( 31935), INT16_C( -6397), INT16_C( -2502), INT16_C( 31062),
                            INT16_C( 30236), INT16_C(  5156), INT16_C( 18439), INT16_C(-13074)),
      simde_mm256_set_epi8(INT8_C(   7), INT8_C( 116), INT8_C( -87), INT8_C(  41),
                           INT8_C(  66), INT8_C(   9), INT8_C( -84), INT8_C(  52),
                           INT8_C(  98), INT8_C( -40), INT8_C(  -5), INT8_C(  52),
                           INT8_C(  13), INT8_C( -49), INT8_C( -54), INT8_C(  47),
                           INT8_C( 116), INT8_C( -22), INT8_C( -62), INT8_C( -88),
                           INT8_C( -11), INT8_C(   9), INT8_C(  82), INT8_C( -89),
                           INT8_C( -65), INT8_C(   3), INT8_C(  58), INT8_C(  86),
                           INT8_C(  28), INT8_C(  36), INT8_C(   7), INT8_C( -18)) },
    { simde_mm512_set_epi16(INT16_C( 18175), INT16_C( -3760), INT16_C( 10318), INT16_C(-31849),
                            INT16_C(-32429), INT16_C(-26500), INT16_C( 24084), INT16_C(-23946),
                            INT16_C(  2525), INT16_C(  2478), INT16_C(-15141), INT16_C(-27410),
                            INT16_C( 30961), INT16_C(-31554), INT16_C( -9533), INT16_C(-20012),
                            INT16_C(-21820), INT16_C( 11767), INT16_C(-17849), INT16_C( 24518),
                            INT16_C(-22206), INT16_C(-24996), INT16_C(-19566), INT16_C( 17826),
                            INT16_C( 25765), INT16_C( 29123), INT16_C( 28065), INT16_C(  1432),
                            INT16_C(-24949), INT16_C( 30580), INT16_C( 20499), INT16_C(-29164)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  80), INT8_C(  78), INT8_C(-105),
                           INT8_C(  83), INT8_C( 124), INT8_C(  20), INT8_C( 118),
                           INT8_C( -35), INT8_C( -82), INT8_C( -37), INT8_C( -18),
                           INT8_C( -15), INT8_C( -66), INT8_C( -61), INT8_C( -44),
                           INT8_C( -60), INT8_C(  -9), INT8_C(  71), INT8_C( -58),
                           INT8_C(  66), INT8_C(  92), INT8_C(-110), INT8_C( -94),
                           INT8_C( -91), INT8_C( -61), INT8_C( -95), INT8_C(-104),
                           INT8_C(-117), INT8_C( 116), INT8_C(  19), INT8_C(  20)) },
    { simde_mm512_set_epi16(INT16_C( 10816), INT16_C( 16713), INT16_C( 29707), INT16_C( 15186),
                            INT16_C( 31860), INT16_C(-28520), INT16_C( 18947), INT16_C(-27460),
                            INT16_C( 10883), INT16_C(   310), INT16_C(  8277), INT16_C(-28768),
                            INT16_C( -4553), INT16_C( 23273), INT16_C(-27696), INT16_C(-20678),
                            INT16_C( 13089), INT16_C( -6620), INT16_C( 31575), INT16_C(-20169),
                            INT16_C( 14440), INT16_C( -9264), INT16_C(-26919), INT16_C(-25720),
                            INT16_C(-18371), INT16_C( 25765), INT16_C(-13162), INT16_C(-16808),
                            INT16_C(  5695), INT16_C(-25080), INT16_C( 19142), INT16_C(  3825)),
      simde_mm256_set_epi8(INT8_C(  64), INT8_C(  73), INT8_C(  11), INT8_C(  82),
                           INT8_C( 116), INT8_C(-104), INT8_C(   3), INT8_C( -68),
                           INT8_C(-125), INT8_C(  54), INT8_C(  85), INT8_C( -96),
                           INT8_C(  55), INT8_C( -23), INT8_C( -48), INT8_C(  58),
                           INT8_C(  33), INT8_C(  36), INT8_C(  87), INT8_C(  55),
                           INT8_C( 104), INT8_C( -48), INT8_C( -39), INT8_C(-120),
                           INT8_C(  61), INT8_C( -91), INT8_C(-106), INT8_C(  88),
                           INT8_C(  63), INT8_C(   8), INT8_C( -58), INT8_C( -15)) },
    { simde_mm512_set_epi16(INT16_C(  5079), INT16_C(-24746), INT16_C( 23487), INT16_C(-22087),
                            INT16_C( -8346), INT16_C( 29848), INT16_C( 14241), INT16_C( 18254),
                            INT16_C( -3124), INT16_C(-16186), INT16_C(-13364), INT16_C( 10652),
                            INT16_C( 31028), INT16_C( 21346), INT16_C(  1443), INT16_C(-20222),
                            INT16_C(-17028), INT16_C(-21899), INT16_C( 18933), INT16_C(  6935),
                            INT16_C( 24619), INT16_C(  1737), INT16_C( 12596), INT16_C( 31606),
                            INT16_C(-32691), INT16_C( 11392), INT16_C( 32126), INT16_C(-32712),
                            INT16_C( 20927), INT16_C(-27859), INT16_C( 22640), INT16_C(  8969)),
      simde_mm256_set_epi8(INT8_C( -41), INT8_C(  86), INT8_C( -65), INT8_C( -71),
                           INT8_C( 102), INT8_C(-104), INT8_C( -95), INT8_C(  78),
                           INT8_C( -52), INT8_C( -58), INT8_C( -52), INT8_C(-100),
                           INT8_C(  52), INT8_C(  98), INT8_C( -93), INT8_C(   2),
                           INT8_C( 124), INT8_C( 117), INT8_C( -11), INT8_C(  23),
                           INT8_C(  43), INT8_C( -55), INT8_C(  52), INT8_C( 118),
                           INT8_C(  77), INT8_C(-128), INT8_C( 126), INT8_C(  56),
                           INT8_C( -65), INT8_C(  45), INT8_C( 112), INT8_C(   9)) },
    { simde_mm512_set_epi16(INT16_C(  6901), INT16_C(-23435), INT16_C(-26040), INT16_C(-11295),
                            INT16_C(   623), INT16_C(-23058), INT16_C( 17549), INT16_C(-23291),
                            INT16_C( 17215), INT16_C( -4892), INT16_C(  -849), INT16_C( 21086),
                            INT16_C(-13056), INT16_C( 19549), INT16_C( 16492), INT16_C(-22767),
                            INT16_C(-24079), INT16_C(  6429), INT16_C( 15302), INT16_C( -9175),
                            INT16_C( 17671), INT16_C(-29856), INT16_C(-12718), INT16_C(-22914),
                            INT16_C(-19613), INT16_C( 14088), INT16_C(-10443), INT16_C( 31757),
                            INT16_C( 24994), INT16_C( 24174), INT16_C( -9596), INT16_C(-22481)),
      simde_mm256_set_epi8(INT8_C( -11), INT8_C( 117), INT8_C(  72), INT8_C( -31),
                           INT8_C( 111), INT8_C( -18), INT8_C(-115), INT8_C(   5),
                           INT8_C(  63), INT8_C( -28), INT8_C( -81), INT8_C(  94),
                           INT8_C(   0), INT8_C(  93), INT8_C( 108), INT8_C(  17),
                           INT8_C( -15), INT8_C(  29), INT8_C( -58), INT8_C(  41),
                           INT8_C(   7), INT8_C(  96), INT8_C(  82), INT8_C( 126),
                           INT8_C(  99), INT8_C(   8), INT8_C(  53), INT8_C(  13),
                           INT8_C( -94), INT8_C( 110), INT8_C(-124), INT8_C(  47)) },
    { simde_mm512_set_epi16(INT16_C( 15520), INT16_C( 15679), INT16_C(  8541), INT16_C(-20376),
                            INT16_C(  8861), INT16_C( 12926), INT16_C( 25712), INT16_C( -8433),
                            INT16_C( -7066), INT16_C(-23691), INT16_C(-20251), INT16_C( 18056),
                            INT16_C(  5498), INT16_C(-18751), INT16_C(-26321), INT16_C(  7918),
                            INT16_C(  1647), INT16_C( 21774), INT16_C(  5430), INT16_C(-19512),
                            INT16_C(-14894), INT16_C( 12466), INT16_C( -9612), INT16_C(-23130),
                            INT16_C( 18357), INT16_C( 32349), INT16_C(-25760), INT16_C( -6559),
                            INT16_C(-24198), INT16_C( 13614), INT16_C( 13473), INT16_C(-25578)),
      simde_mm256_set_epi8(INT8_C( -96), INT8_C(  63), INT8_C(  93), INT8_C( 104),
                           INT8_C( -99), INT8_C( 126), INT8_C( 112), INT8_C(  15),
                           INT8_C( 102), INT8_C( 117), INT8_C( -27), INT8_C(-120),
                           INT8_C( 122), INT8_C( -63), INT8_C(  47), INT8_C( -18),
                           INT8_C( 111), INT8_C(  14), INT8_C(  54), INT8_C( -56),
                           INT8_C( -46), INT8_C( -78), INT8_C( 116), INT8_C( -90),
                           INT8_C( -75), INT8_C(  93), INT8_C(  96), INT8_C(  97),
                           INT8_C( 122), INT8_C(  46), INT8_C( -95), INT8_C(  22)) },
    { simde_mm512_set_epi16(INT16_C(-13944), INT16_C( 30422), INT16_C( 10523), INT16_C( 28986),
                            INT16_C(-23789), INT16_C(-20754), INT16_C( 29282), INT16_C(-10845),
                            INT16_C( 10721), INT16_C(  2777), INT16_C(-18838), INT16_C(  8324),
                            INT16_C( 19192), INT16_C(   114), INT16_C( -9073), INT16_C(  2615),
                            INT16_C( 21008), INT16_C( 12652), INT16_C(-14859), INT16_C(  5734),
                            INT16_C( -5598), INT16_C(-10707), INT16_C(  2170), INT16_C( 23903),
                            INT16_C( 29988), INT16_C( 24405), INT16_C(  5383), INT16_C(-29994),
                            INT16_C(  7143), INT16_C( 22270), INT16_C( -1480), INT16_C( 15491)),
      simde_mm256_set_epi8(INT8_C(-120), INT8_C( -42), INT8_C(  27), INT8_C(  58),
                           INT8_C(  19), INT8_C( -18), INT8_C(  98), INT8_C( -93),
                           INT8_C( -31), INT8_C( -39), INT8_C( 106), INT8_C(-124),
                           INT8_C(  -8), INT8_C( 114), INT8_C(-113), INT8_C(  55),
                           INT8_C(  16), INT8_C( 108), INT8_C( -11), INT8_C( 102),
                           INT8_C(  34), INT8_C(  45), INT8_C( 122), INT8_C(  95),
                           INT8_C(  36), INT8_C(  85), INT8_C(   7), INT8_C( -42),
                           INT8_C( -25), INT8_C(  -2), INT8_C(  56), INT8_C(-125)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm512_cvtepi16_epi8(test_vec[i].a);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cvtepi8_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(   7), INT8_C(  68), INT8_C( -86), INT8_C( -36),
                           INT8_C( -19), INT8_C(  73), INT8_C(  92), INT8_C( -27),
                           INT8_C(  55), INT8_C( -65), INT8_C( -50), INT8_C(  19),
                           INT8_C(-111), INT8_C( -79), INT8_C( -16), INT8_C(  70),
                           INT8_C(  27), INT8_C( -28), INT8_C( 116), INT8_C(  42),
                           INT8_C(  -4), INT8_C(  78), INT8_C(  31), INT8_C(  51),
                           INT8_C(  92), INT8_C(  39), INT8_C(-125), INT8_C(  94),
                           INT8_C( -78), INT8_C(  67), INT8_C( -43), INT8_C( -71)),
      simde_mm512_set_epi16(INT16_C(     7), INT16_C(    68), INT16_C(   -86), INT16_C(   -36),
                            INT16_C(   -19), INT16_C(    73), INT16_C(    92), INT16_C(   -27),
                            INT16_C(    55), INT16_C(   -65), INT16_C(   -50), INT16_C(    19),
                            INT16_C(  -111), INT16_C(   -79), INT16_C(   -16), INT16_C(    70),
                            INT16_C(    27), INT16_C(   -28), INT16_C(   116), INT16_C(    42),
                            INT16_C(    -4), INT16_C(    78), INT16_C(    31), INT16_C(    51),
                            INT16_C(    92), INT16_C(    39), INT16_C(  -125), INT16_C(    94),
                            INT16_C(   -78), INT16_C(    67), INT16_C(   -43), INT16_C(   -71)) },
    { simde_mm256_set_epi8(INT8_C(  29), INT8_C( -37), INT8_C(  27), INT8_C(  10),
                           INT8_C( -22), INT8_C(  -9), INT8_C(-125), INT8_C(  -3),
                           INT8_C( -53), INT8_C(  92), INT8_C( 103), INT8_C(  92),
                           INT8_C( 123), INT8_C(  74), INT8_C(  36), INT8_C(  59),
                           INT8_C(  46), INT8_C( -29), INT8_C(-103), INT8_C(  -4),
                           INT8_C( 109), INT8_C( -54), INT8_C(  41), INT8_C(  79),
                           INT8_C(  15), INT8_C( -92), INT8_C( 102), INT8_C( 116),
                           INT8_C( -42), INT8_C(  52), INT8_C( -61), INT8_C( -99)),
      simde_mm512_set_epi16(INT16_C(    29), INT16_C(   -37), INT16_C(    27), INT16_C(    10),
                            INT16_C(   -22), INT16_C(    -9), INT16_C(  -125), INT16_C(    -3),
                            INT16_C(   -53), INT16_C(    92), INT16_C(   103), INT16_C(    92),
                            INT16_C(   123), INT16_C(    74), INT16_C(    36), INT16_C(    59),
                            INT16_C(    46), INT16_C(   -29), INT16_C(  -103), INT16_C(    -4),
                            INT16_C(   109), INT16_C(   -54), INT16_C(    41), INT16_C(    79),
                            INT16_C(    15), INT16_C(   -92), INT16_C(   102), INT16_C(   116),
                            INT16_C(   -42), INT16_C(    52), INT16_C(   -61), INT16_C(   -99)) },
    { simde_mm256_set_epi8(INT8_C(  -9), INT8_C( -47), INT8_C( 107), INT8_C( -74),
                           INT8_C(-126), INT8_C(  34), INT8_C(  64), INT8_C( 115),
                           INT8_C( -65), INT8_C(-124), INT8_C(  54), INT8_C(  27),
                           INT8_C(  41), INT8_C( 112), INT8_C(  61), INT8_C(   6),
                           INT8_C(   7), INT8_C(  39), INT8_C(-109), INT8_C( -99),
                           INT8_C(  63), INT8_C( -35), INT8_C(-111), INT8_C( -72),
                           INT8_C( 109), INT8_C( -39), INT8_C( -99), INT8_C(  26),
                           INT8_C(  66), INT8_C( -78), INT8_C(  30), INT8_C(  38)),
      simde_mm512_set_epi16(INT16_C(    -9), INT16_C(   -47), INT16_C(   107), INT16_C(   -74),
                            INT16_C(  -126), INT16_C(    34), INT16_C(    64), INT16_C(   115),
                            INT16_C(   -65), INT16_C(  -124), INT16_C(    54), INT16_C(    27),
                            INT16_C(    41), INT16_C(   112), INT16_C(    61), INT16_C(     6),
                            INT16_C(     7), INT16_C(    39), INT16_C(  -109), INT16_C(   -99),
                            INT16_C(    63), INT16_C(   -35), INT16_C(  -111), INT16_C(   -72),
                            INT16_C(   109), INT16_C(   -39), INT16_C(   -99), INT16_C(    26),
                            INT16_C(    66), INT16_C(   -78), INT16_C(    30), INT16_C(    38)) },
    { simde_mm256_set_epi8(INT8_C( -72), INT8_C( -80), INT8_C( 101), INT8_C(  81),
                           INT8_C(  23), INT8_C( -68), INT8_C( -57), INT8_C(-111),
                           INT8_C(  -3), INT8_C(  21), INT8_C( 121), INT8_C( -22),
                           INT8_C(-104), INT8_C( -10), INT8_C( -37), INT8_C(  66),
                           INT8_C( -93), INT8_C( -80), INT8_C(  34), INT8_C( 104),
                           INT8_C( -39), INT8_C( -99), INT8_C(  18), INT8_C( 110),
                           INT8_C(-118), INT8_C(  38), INT8_C( 112), INT8_C( -67),
                           INT8_C(  60), INT8_C(  47), INT8_C(  32), INT8_C(  33)),
      simde_mm512_set_epi16(INT16_C(   -72), INT16_C(   -80), INT16_C(   101), INT16_C(    81),
                            INT16_C(    23), INT16_C(   -68), INT16_C(   -57), INT16_C(  -111),
                            INT16_C(    -3), INT16_C(    21), INT16_C(   121), INT16_C(   -22),
                            INT16_C(  -104), INT16_C(   -10), INT16_C(   -37), INT16_C(    66),
                            INT16_C(   -93), INT16_C(   -80), INT16_C(    34), INT16_C(   104),
                            INT16_C(   -39), INT16_C(   -99), INT16_C(    18), INT16_C(   110),
                            INT16_C(  -118), INT16_C(    38), INT16_C(   112), INT16_C(   -67),
                            INT16_C(    60), INT16_C(    47), INT16_C(    32), INT16_C(    33)) },
    { simde_mm256_set_epi8(INT8_C( 120), INT8_C( -90), INT8_C(-101), INT8_C(-106),
                           INT8_C(  70), INT8_C( -49), INT8_C(  29), INT8_C( -43),
                           INT8_C( -42), INT8_C(  38), INT8_C(  16), INT8_C( -43),
                           INT8_C( -40), INT8_C( -76), INT8_C( -67), INT8_C(  53),
                           INT8_C( -73), INT8_C( -17), INT8_C(  66), INT8_C(  57),
                           INT8_C( -65), INT8_C( -63), INT8_C(  17), INT8_C(  -9),
                           INT8_C(  95), INT8_C( -50), INT8_C(-118), INT8_C( 114),
                           INT8_C(  58), INT8_C( -28), INT8_C( -81), INT8_C( -37)),
      simde_mm512_set_epi16(INT16_C(   120), INT16_C(   -90), INT16_C(  -101), INT16_C(  -106),
                            INT16_C(    70), INT16_C(   -49), INT16_C(    29), INT16_C(   -43),
                            INT16_C(   -42), INT16_C(    38), INT16_C(    16), INT16_C(   -43),
                            INT16_C(   -40), INT16_C(   -76), INT16_C(   -67), INT16_C(    53),
                            INT16_C(   -73), INT16_C(   -17), INT16_C(    66), INT16_C(    57),
                            INT16_C(   -65), INT16_C(   -63), INT16_C(    17), INT16_C(    -9),
                            INT16_C(    95), INT16_C(   -50), INT16_C(  -118), INT16_C(   114),
                            INT16_C(    58), INT16_C(   -28), INT16_C(   -81), INT16_C(   -37)) },
    { simde_mm256_set_epi8(INT8_C( -97), INT8_C(  10), INT8_C( -75), INT8_C(-120),
                           INT8_C( -32), INT8_C(-105), INT8_C( -75), INT8_C(-101),
                           INT8_C(  71), INT8_C(-122), INT8_C(-112), INT8_C(  -2),
                           INT8_C(  60), INT8_C( -71), INT8_C( 101), INT8_C(  -1),
                           INT8_C(  95), INT8_C( -58), INT8_C( -70), INT8_C( 102),
                           INT8_C( 115), INT8_C( -68), INT8_C(-110), INT8_C( -36),
                           INT8_C(   6), INT8_C(  58), INT8_C(  73), INT8_C(  97),
                           INT8_C( -51), INT8_C(  -4), INT8_C(  58), INT8_C(  31)),
      simde_mm512_set_epi16(INT16_C(   -97), INT16_C(    10), INT16_C(   -75), INT16_C(  -120),
                            INT16_C(   -32), INT16_C(  -105), INT16_C(   -75), INT16_C(  -101),
                            INT16_C(    71), INT16_C(  -122), INT16_C(  -112), INT16_C(    -2),
                            INT16_C(    60), INT16_C(   -71), INT16_C(   101), INT16_C(    -1),
                            INT16_C(    95), INT16_C(   -58), INT16_C(   -70), INT16_C(   102),
                            INT16_C(   115), INT16_C(   -68), INT16_C(  -110), INT16_C(   -36),
                            INT16_C(     6), INT16_C(    58), INT16_C(    73), INT16_C(    97),
                            INT16_C(   -51), INT16_C(    -4), INT16_C(    58), INT16_C(    31)) },
    { simde_mm256_set_epi8(INT8_C( -73), INT8_C(-123), INT8_C( -11), INT8_C(  62),
                           INT8_C( -96), INT8_C(-103), INT8_C(  85), INT8_C(  88),
                           INT8_C( -19), INT8_C(  28), INT8_C(-107), INT8_C( -81),
                           INT8_C(-125), INT8_C(  88), INT8_C(  84), INT8_C( 115),
                           INT8_C( 105), INT8_C( -47), INT8_C(  68), INT8_C(-124),
                           INT8_C(  32), INT8_C(-100), INT8_C(  10), INT8_C( -69),
                           INT8_C( 124), INT8_C( -51), INT8_C( -89), INT8_C( -72),
                           INT8_C( -92), INT8_C(  -5), INT8_C( -46), INT8_C( 115)),
      simde_mm512_set_epi16(INT16_C(   -73), INT16_C(  -123), INT16_C(   -11), INT16_C(    62),
                            INT16_C(   -96), INT16_C(  -103), INT16_C(    85), INT16_C(    88),
                            INT16_C(   -19), INT16_C(    28), INT16_C(  -107), INT16_C(   -81),
                            INT16_C(  -125), INT16_C(    88), INT16_C(    84), INT16_C(   115),
                            INT16_C(   105), INT16_C(   -47), INT16_C(    68), INT16_C(  -124),
                            INT16_C(    32), INT16_C(  -100), INT16_C(    10), INT16_C(   -69),
                            INT16_C(   124), INT16_C(   -51), INT16_C(   -89), INT16_C(   -72),
                            INT16_C(   -92), INT16_C(    -5), INT16_C(   -46), INT16_C(   115)) },
    { simde_mm256_set_epi8(INT8_C( 104), INT8_C(  66), INT8_C(  51), INT8_C(  81),
                           INT8_C( -69), INT8_C( 104), INT8_C( 126), INT8_C( -43),
                           INT8_C( -40), INT8_C(  23), INT8_C(-124), INT8_C(  98),
                           INT8_C(-125), INT8_C(  95), INT8_C( -36), INT8_C(  46),
                           INT8_C(-115), INT8_C( -93), INT8_C(   2), INT8_C( -77),
                           INT8_C(  80), INT8_C(-116), INT8_C(  61), INT8_C( -89),
                           INT8_C( -37), INT8_C(   9), INT8_C(  84), INT8_C( -64),
                           INT8_C(  94), INT8_C(  67), INT8_C( -53), INT8_C( 111)),
      simde_mm512_set_epi16(INT16_C(   104), INT16_C(    66), INT16_C(    51), INT16_C(    81),
                            INT16_C(   -69), INT16_C(   104), INT16_C(   126), INT16_C(   -43),
                            INT16_C(   -40), INT16_C(    23), INT16_C(  -124), INT16_C(    98),
                            INT16_C(  -125), INT16_C(    95), INT16_C(   -36), INT16_C(    46),
                            INT16_C(  -115), INT16_C(   -93), INT16_C(     2), INT16_C(   -77),
                            INT16_C(    80), INT16_C(  -116), INT16_C(    61), INT16_C(   -89),
                            INT16_C(   -37), INT16_C(     9), INT16_C(    84), INT16_C(   -64),
                            INT16_C(    94), INT16_C(    67), INT16_C(   -53), INT16_C(   111)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_cvtepi8_epi16(test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cvtsepi16_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m256i r;
  } test_vec[8] = {
        { simde_mm512_set_epi16(INT16_C(  8002), INT16_C(   -42), INT16_C(   317), INT16_C(     3),
                            INT16_C(     2), INT16_C(    22), INT16_C(     2), INT16_C(   102),
                            INT16_C(     0), INT16_C(   130), INT16_C(   297), INT16_C(  4068),
                            INT16_C(  -202), INT16_C(  4593), INT16_C(  1545), INT16_C(    -2),
                            INT16_C( -4392), INT16_C( -3947), INT16_C(   301), INT16_C(-11526),
                            INT16_C(    -1), INT16_C(     1), INT16_C(  -437), INT16_C(     4),
                            INT16_C(  -139), INT16_C( -4859), INT16_C(    -1), INT16_C(    12),
                            INT16_C(  -591), INT16_C(   -40), INT16_C(  -269), INT16_C(   -24)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C( -42), INT8_C( 127), INT8_C(   3),
                           INT8_C(   2), INT8_C(  22), INT8_C(   2), INT8_C( 102),
                           INT8_C(   0), INT8_C( 127), INT8_C( 127), INT8_C( 127),
                           INT8_C(-128), INT8_C( 127), INT8_C( 127), INT8_C(  -2),
                           INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C(-128),
                           INT8_C(  -1), INT8_C(   1), INT8_C(-128), INT8_C(   4),
                           INT8_C(-128), INT8_C(-128), INT8_C(  -1), INT8_C(  12),
                           INT8_C(-128), INT8_C( -40), INT8_C(-128), INT8_C( -24)) },
    { simde_mm512_set_epi16(INT16_C(     2), INT16_C(    49), INT16_C(     2), INT16_C(   131),
                            INT16_C(     1), INT16_C(-15743), INT16_C(  1984), INT16_C(     9),
                            INT16_C(-20648), INT16_C( -5458), INT16_C(    -1), INT16_C(    -1),
                            INT16_C( -3713), INT16_C(   -60), INT16_C( -1328), INT16_C(     4),
                            INT16_C(   150), INT16_C(    -8), INT16_C(  1864), INT16_C(   -14),
                            INT16_C(    20), INT16_C(   194), INT16_C(     0), INT16_C(  5954),
                            INT16_C(   -13), INT16_C(  -288), INT16_C(  3162), INT16_C(     1),
                            INT16_C(    14), INT16_C(  2628), INT16_C(    -1), INT16_C(    -8)),
      simde_mm256_set_epi8(INT8_C(   2), INT8_C(  49), INT8_C(   2), INT8_C( 127),
                           INT8_C(   1), INT8_C(-128), INT8_C( 127), INT8_C(   9),
                           INT8_C(-128), INT8_C(-128), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(-128), INT8_C( -60), INT8_C(-128), INT8_C(   4),
                           INT8_C( 127), INT8_C(  -8), INT8_C( 127), INT8_C( -14),
                           INT8_C(  20), INT8_C( 127), INT8_C(   0), INT8_C( 127),
                           INT8_C( -13), INT8_C(-128), INT8_C( 127), INT8_C(   1),
                           INT8_C(  14), INT8_C( 127), INT8_C(  -1), INT8_C(  -8)) },
    { simde_mm512_set_epi16(INT16_C(  -562), INT16_C(    -4), INT16_C( 14830), INT16_C( 23439),
                            INT16_C(  -872), INT16_C(     2), INT16_C(  -152), INT16_C(    42),
                            INT16_C( 23882), INT16_C(    -7), INT16_C(-27326), INT16_C(  5025),
                            INT16_C(  7663), INT16_C(-14858), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    27), INT16_C(     3), INT16_C(    -6), INT16_C(    54),
                            INT16_C(   -16), INT16_C(  -120), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    50), INT16_C(    -3), INT16_C(     1), INT16_C(  -128),
                            INT16_C( -6425), INT16_C(     1), INT16_C(    -1), INT16_C(  -167)),
      simde_mm256_set_epi8(INT8_C(-128), INT8_C(  -4), INT8_C( 127), INT8_C( 127),
                           INT8_C(-128), INT8_C(   2), INT8_C(-128), INT8_C(  42),
                           INT8_C( 127), INT8_C(  -7), INT8_C(-128), INT8_C( 127),
                           INT8_C( 127), INT8_C(-128), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  27), INT8_C(   3), INT8_C(  -6), INT8_C(  54),
                           INT8_C( -16), INT8_C(-120), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  50), INT8_C(  -3), INT8_C(   1), INT8_C(-128),
                           INT8_C(-128), INT8_C(   1), INT8_C(  -1), INT8_C(-128)) },
    { simde_mm512_set_epi16(INT16_C(   117), INT16_C(    75), INT16_C(   -56), INT16_C(    -1),
                            INT16_C(    53), INT16_C(  -283), INT16_C(   138), INT16_C(     3),
                            INT16_C(    -1), INT16_C(  6705), INT16_C(   138), INT16_C( -3521),
                            INT16_C(    22), INT16_C(  1779), INT16_C(  2888), INT16_C(    -1),
                            INT16_C(  -189), INT16_C( 17712), INT16_C(   -18), INT16_C(   923),
                            INT16_C(     1), INT16_C(     1), INT16_C(  2605), INT16_C(   353),
                            INT16_C(   201), INT16_C(  -120), INT16_C(-28865), INT16_C(   -13),
                            INT16_C(  -701), INT16_C(   945), INT16_C( -2270), INT16_C(     0)),
      simde_mm256_set_epi8(INT8_C( 117), INT8_C(  75), INT8_C( -56), INT8_C(  -1),
                           INT8_C(  53), INT8_C(-128), INT8_C( 127), INT8_C(   3),
                           INT8_C(  -1), INT8_C( 127), INT8_C( 127), INT8_C(-128),
                           INT8_C(  22), INT8_C( 127), INT8_C( 127), INT8_C(  -1),
                           INT8_C(-128), INT8_C( 127), INT8_C( -18), INT8_C( 127),
                           INT8_C(   1), INT8_C(   1), INT8_C( 127), INT8_C( 127),
                           INT8_C( 127), INT8_C(-120), INT8_C(-128), INT8_C( -13),
                           INT8_C(-128), INT8_C( 127), INT8_C(-128), INT8_C(   0)) },
    { simde_mm512_set_epi16(INT16_C(   127), INT16_C(   406), INT16_C(    74), INT16_C(    -2),
                            INT16_C(   -12), INT16_C(   196), INT16_C(    -4), INT16_C( -4852),
                            INT16_C(    38), INT16_C(   -10), INT16_C(  -408), INT16_C(   453),
                            INT16_C( -6833), INT16_C(    37), INT16_C( -3464), INT16_C(    -2),
                            INT16_C(  -488), INT16_C(     0), INT16_C(   643), INT16_C(     6),
                            INT16_C(    51), INT16_C(     0), INT16_C(    -4), INT16_C(    -1),
                            INT16_C(-14928), INT16_C(   -46), INT16_C(    58), INT16_C(    -3),
                            INT16_C(     0), INT16_C(  -343), INT16_C(-10019), INT16_C(     0)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C( 127), INT8_C(  74), INT8_C(  -2),
                           INT8_C( -12), INT8_C( 127), INT8_C(  -4), INT8_C(-128),
                           INT8_C(  38), INT8_C( -10), INT8_C(-128), INT8_C( 127),
                           INT8_C(-128), INT8_C(  37), INT8_C(-128), INT8_C(  -2),
                           INT8_C(-128), INT8_C(   0), INT8_C( 127), INT8_C(   6),
                           INT8_C(  51), INT8_C(   0), INT8_C(  -4), INT8_C(  -1),
                           INT8_C(-128), INT8_C( -46), INT8_C(  58), INT8_C(  -3),
                           INT8_C(   0), INT8_C(-128), INT8_C(-128), INT8_C(   0)) },
    { simde_mm512_set_epi16(INT16_C(    -1), INT16_C(  -378), INT16_C(  3797), INT16_C(     1),
                            INT16_C(   -61), INT16_C( -6468), INT16_C(     0), INT16_C(-18745),
                            INT16_C(     3), INT16_C(    -5), INT16_C(    -1), INT16_C(  4066),
                            INT16_C(    -1), INT16_C(   -11), INT16_C(    -2), INT16_C(   881),
                            INT16_C(  -116), INT16_C(    22), INT16_C(     1), INT16_C( -1127),
                            INT16_C(    15), INT16_C(  2276), INT16_C(  -149), INT16_C(  7345),
                            INT16_C(   850), INT16_C(   -84), INT16_C(    -2), INT16_C(     0),
                            INT16_C(    -6), INT16_C( -3696), INT16_C(    -2), INT16_C(  2136)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(-128), INT8_C( 127), INT8_C(   1),
                           INT8_C( -61), INT8_C(-128), INT8_C(   0), INT8_C(-128),
                           INT8_C(   3), INT8_C(  -5), INT8_C(  -1), INT8_C( 127),
                           INT8_C(  -1), INT8_C( -11), INT8_C(  -2), INT8_C( 127),
                           INT8_C(-116), INT8_C(  22), INT8_C(   1), INT8_C(-128),
                           INT8_C(  15), INT8_C( 127), INT8_C(-128), INT8_C( 127),
                           INT8_C( 127), INT8_C( -84), INT8_C(  -2), INT8_C(   0),
                           INT8_C(  -6), INT8_C(-128), INT8_C(  -2), INT8_C( 127)) },
    { simde_mm512_set_epi16(INT16_C(  -368), INT16_C( -1403), INT16_C(   -10), INT16_C(  2787),
                            INT16_C(  6145), INT16_C(  -228), INT16_C(  2519), INT16_C(    -1),
                            INT16_C(  -244), INT16_C(    10), INT16_C(    14), INT16_C(   113),
                            INT16_C(    23), INT16_C(     1), INT16_C( 21613), INT16_C(    -2),
                            INT16_C(    -2), INT16_C(   -29), INT16_C(  9866), INT16_C(   356),
                            INT16_C(  -254), INT16_C(   -21), INT16_C(     9), INT16_C(     9),
                            INT16_C(   249), INT16_C(  3052), INT16_C( -8880), INT16_C(     7),
                            INT16_C(     0), INT16_C( -4602), INT16_C( -8839), INT16_C( 18288)),
      simde_mm256_set_epi8(INT8_C(-128), INT8_C(-128), INT8_C( -10), INT8_C( 127),
                           INT8_C( 127), INT8_C(-128), INT8_C( 127), INT8_C(  -1),
                           INT8_C(-128), INT8_C(  10), INT8_C(  14), INT8_C( 113),
                           INT8_C(  23), INT8_C(   1), INT8_C( 127), INT8_C(  -2),
                           INT8_C(  -2), INT8_C( -29), INT8_C( 127), INT8_C( 127),
                           INT8_C(-128), INT8_C( -21), INT8_C(   9), INT8_C(   9),
                           INT8_C( 127), INT8_C( 127), INT8_C(-128), INT8_C(   7),
                           INT8_C(   0), INT8_C(-128), INT8_C(-128), INT8_C( 127)) },
    { simde_mm512_set_epi16(INT16_C(   502), INT16_C(    22), INT16_C(    -4), INT16_C(     1),
                            INT16_C(     2), INT16_C( -1148), INT16_C(     1), INT16_C(     8),
                            INT16_C(    25), INT16_C(  8616), INT16_C(    -1), INT16_C(     0),
                            INT16_C(  1091), INT16_C(  -370), INT16_C(     0), INT16_C(    -1),
                            INT16_C( -1549), INT16_C(    12), INT16_C(    -2), INT16_C(     4),
                            INT16_C( -3952), INT16_C(  1681), INT16_C(     3), INT16_C(    35),
                            INT16_C(    -6), INT16_C(     0), INT16_C(    -2), INT16_C(    51),
                            INT16_C(     0), INT16_C(  3760), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C(  22), INT8_C(  -4), INT8_C(   1),
                           INT8_C(   2), INT8_C(-128), INT8_C(   1), INT8_C(   8),
                           INT8_C(  25), INT8_C( 127), INT8_C(  -1), INT8_C(   0),
                           INT8_C( 127), INT8_C(-128), INT8_C(   0), INT8_C(  -1),
                           INT8_C(-128), INT8_C(  12), INT8_C(  -2), INT8_C(   4),
                           INT8_C(-128), INT8_C( 127), INT8_C(   3), INT8_C(  35),
                           INT8_C(  -6), INT8_C(   0), INT8_C(  -2), INT8_C(  51),
                           INT8_C(   0), INT8_C( 127), INT8_C(  -1), INT8_C(  -1)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm512_cvtsepi16_epi8(test_vec[i].a);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

#endif /* defined(SIMDE_avx512bw_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS) */

HEDLEY_DIAGNOSTIC_PUSH
HEDLEY_DIAGNOSTIC_DISABLE_CAST_QUAL

#if HEDLEY_HAS_WARNING("-Wold-style-cast")
  #pragma clang diagnostic ignored "-Wold-style-cast"
#endif
#if HEDLEY_HAS_WARNING("-Wzero-as-null-pointer-constant")
  #pragma clang diagnostic ignored "-Wzero-as-null-pointer-constant"
#endif

static MunitTest test_suite_tests[] = {
#if defined(SIMDE_AVX512BW_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS)
  SIMDE_TESTS_DEFINE_TEST(mm512_adds_epi8),
  SIMDE_TESTS_DEFINE_TEST(mm512_adds_epi16),
  SIMDE_TESTS_DEFINE_TEST(mm512_adds_epu8),
  SIMDE_TESTS_DEFINE_TEST(mm512_adds_epu16),

  SIMDE_TESTS_DEFINE_TEST(mm512_shuffle_epi8),
  SIMDE_TESTS_DEFINE_TEST(mm512_cmpeq_epi8_mask),

  SIMDE_TESTS_DEFINE_TEST(mm512_cvtepi8_epi16),
  SIMDE_TESTS_DEFINE_TEST(mm512_cvtepi16_epi8),

  SIMDE_TESTS_DEFINE_TEST(mm512_cvtsepi16_epi8),

#endif /* defined(SIMDE_AVX512bw_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS) */
  { NULL, NULL, NULL, NULL, MUNIT_TEST_OPTION_NONE, NULL }
};

HEDLEY_C_DECL MunitSuite* SIMDE_TESTS_GENERATE_SYMBOL(suite)(void) {
  static MunitSuite suite = { (char*) "/" HEDLEY_STRINGIFY(SIMDE_TESTS_CURRENT_ISAX), test_suite_tests, NULL, 1, MUNIT_SUITE_OPTION_NONE };

  return &suite;
}

#if defined(SIMDE_TESTS_SINGLE_ISAX)
int main(int argc, char* argv[HEDLEY_ARRAY_PARAM(argc + 1)]) {
  static MunitSuite suite = { "", test_suite_tests, NULL, 1, MUNIT_SUITE_OPTION_NONE };

  return munit_suite_main(&suite, NULL, argc, argv);
}
#endif /* defined(SIMDE_TESTS_SINGLE_ISAX) */

HEDLEY_DIAGNOSTIC_POP
