from java.awt.event import InputEvent

##
# The Shift key modifier constant. 
# This equals to java.awt.event.InputEvent.SHIFT_MASK.
KEY_SHIFT = InputEvent.SHIFT_MASK
##
# The Ctrl key modifier constant. 
# This equals to java.awt.event.InputEvent.CTRL_MASK.
KEY_CTRL = InputEvent.CTRL_MASK
##
# The Meta/Windows/Apple key modifier constant. 
# This equals to java.awt.event.InputEvent.META_MASK.
KEY_META = InputEvent.META_MASK
##
# The Apple(Command) key modifier constant. 
# This equals to java.awt.event.InputEvent.META_MASK.
KEY_CMD  = InputEvent.META_MASK
##
# The Windows key modifier constant. 
# This equals to java.awt.event.InputEvent.META_MASK.
KEY_WIN  = InputEvent.META_MASK
##
# The Alt key modifier constant. 
# This equals to java.awt.event.InputEvent.ALT_MASK.
KEY_ALT = InputEvent.ALT_MASK

##
# class Key contains the constants of all special keys.
class Key:
   ##
   # ENTER 
   ENTER       = "\n"
   ##
   # BACKSPACE
   BACKSPACE   = "\b"
   ##
   # TAB
   TAB         = "\t"
   ##
   # ESC
   ESC         = u"\u001b"
   ##
   # UP
   UP          = u"\ue000"
   ##
   # RIGHT
   RIGHT       = u"\ue001"
   ##
   # DOWN
   DOWN        = u"\ue002"
   ##
   # LEFT
   LEFT        = u"\ue003"
   ##
   # PAGE_UP
   PAGE_UP     = u"\ue004"
   ##
   # PAGE_DOWN
   PAGE_DOWN   = u"\ue005"
   ##
   # DELETE
   DELETE      = u"\ue006"
   ##
   # END
   END         = u"\ue007"
   ##
   # HOME
   HOME        = u"\ue008"
   ##
   # INSERT
   INSERT      = u"\ue009"
   ##
   # F1
   F1          = u"\ue011"
   ##
   # F2
   F2          = u"\ue012"
   ##
   # F3
   F3          = u"\ue013"
   ##
   # F4
   F4          = u"\ue014"
   ##
   # F5
   F5          = u"\ue015"
   ##
   # F6
   F6          = u"\ue016"
   ##
   # F7
   F7          = u"\ue017"
   ##
   # F8
   F8          = u"\ue018"
   ##
   # F9
   F9          = u"\ue019"
   ##
   # F10
   F10         = u"\ue01A"
   ##
   # F11
   F11         = u"\ue01B"
   ##
   # F12
   F12         = u"\ue01C"
   ##
   # F13
   F13         = u"\ue01D"
   ##
   # F14
   F14         = u"\ue01E"
   ##
   # F15
   F15         = u"\ue01F"
   ##
   # SHIFT
   SHIFT       = u"\ue020"
   ##
   # CTRL
   CTRL        = u"\ue021"
   ##
   # ALT
   ALT         = u"\ue022"
   ##
   # META
   META        = u"\ue023"
   ##
   # META
   CMD         = u"\ue023"
   ##
   # META
   WIN         = u"\ue023"

   ##
   # PRINTSCREEN
   PRINTSCREEN = u"\ue024"
   ##
   # SCROLL_LOCK
   SCROLL_LOCK	= u"\ue025"
   ##
   # PAUSE
   PAUSE	= u"\ue026"
   ##
   # CAPS_LOCK
   CAPS_LOCK	= u"\ue027"

   ##
   # NUM0	
   NUM0		= u"\ue030"
   ##
   # NUM1	
   NUM1		= u"\ue031"
   ##
   # NUM2	
   NUM2		= u"\ue032"
   ##
   # NUM3	
   NUM3		= u"\ue033"
   ##
   # NUM4	
   NUM4		= u"\ue034"
   ##
   # NUM5	
   NUM5		= u"\ue035"
   ##
   # NUM6	
   NUM6		= u"\ue036"
   ##
   # NUM7	
   NUM7		= u"\ue037"
   ##
   # NUM8	
   NUM8		= u"\ue038"
   ##
   # NUM9	
   NUM9		= u"\ue039"
   ##
   # SEPARATOR (numpad)
   SEPARATOR	= u"\ue03A"
   ##
   # NUM_LOCK
   NUM_LOCK	= u"\ue03B"
   ##
   # ADD (numpad)
   ADD		= u"\ue03C"
   ##
   # MINUS (numpad)
   MINUS	= u"\ue03D"
   ##
   # MULTIPLY (numpad)
   MULTIPLY	= u"\ue03E"
   ##
   # DIVIDE (numpad)
   DIVIDE	= u"\ue03F"



