/***************************************************************************
                          replace.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIRMREPLACE_H
#define CONFIRMREPLACE_H

#include <qvariant.h>
#include <qfile.h>

#include <kdialog.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

class ConfirmReplace : public KDialog
{
    Q_OBJECT

public:                                                                                       
    /**
    	construct a dialog to display 2 images with the same name
    */
    ConfirmReplace( QWidget* parent, QString name, QString org, QString dest);
    ~ConfirmReplace();

    /**
    	return the name of the renamed file
    */
    QString getRename();

protected slots:
        void slotSkip();
        void slotCancel();
        void slotRename();
        void slotReplaceAll();
        void slotReplace();

private:
    void init();
    
    QString* org;
    QString* dest;
    QString rename;
    
    QGroupBox* GroupBox1_2;
    QLabel* fileDest;
    QLabel* tailleDest;
    QLabel* previewDest;
    QLabel* dimDest;
    QButtonGroup* ButtonGroup1;
    QRadioButton* NoImageRadioButton;
    QRadioButton* showThumbnailsRadioButton2;
    QRadioButton* showFullImagesRadioButton3;
    QGroupBox* GroupBox1;
    QLabel* previewOrig;
    QLabel* dimOrig;
    QLabel* fileOrig;
    QLabel* tailleOrig;
    QCheckBox* scrollInUnisonCheckBox1;
    QPushButton* skipButton;
    QPushButton* cancelButton;
    QPushButton* zoomPushButton;
    QPushButton* dezoomPushButton;
    QPushButton* zoomorigPushButton;
    QGroupBox* GroupBox4;
    QLabel* TextLabel4;
    QPushButton* renamePushButton;
    QLineEdit* renameLineEdit;
    QPushButton* replaceAllButton;
    QPushButton* replaceButton;

};

#endif // CONFIRMREPLACE_H
