/***************************************************************************
                         rename.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __RENAMESERIES_H__
#define __RENAMESERIES_H__

#include <qvariant.h>
#include <qspinbox.h>

#include <kdatepicker.h>
#include <kdialog.h>

#include "batchrenamer.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class KDateWidget;
class QButtonGroup;
class QCheckBox;
class QFrame;
class QGroupBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QPushButton;
class QRadioButton;
class QSpinBox;
class QToolButton;

class KCompletion;
class KLineEdit;


class RenameSeries : public KDialog
{
    Q_OBJECT

public:
    /**
    	construct a dialog to rename in series files
    */
    RenameSeries( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~RenameSeries();

    /**
    	@param filename a file to add for rename
    */
    void addFile(QString filename);
    
    /**
    	re-init all data
    */
    void clear();
    int exec ();
    

public slots:
        void accept();

protected:
    QString getPath( QString fn );
    bool checkErrors(bool checkDir=true);

    QListViewItem *last;
    QMemArray<QString*> arrayNames;
    int taille;

    BatchRenamer *newNames;
    QListViewItem* currentItem;
    QPixmap *pix;

     QGroupBox* GroupBox1;
    QLabel* TextLabel1;
    QCheckBox* checkExtension;
    QCheckBox* overwrite;
    QLineEdit* paternLineEdit;
    QGroupBox* GroupBox9;
    QLabel* TextLabel2_2;
    QSpinBox* spinIndex;
    QButtonGroup* ButtonGroup1;
    QRadioButton* optionCopy;
    QRadioButton* optionMove;
    QLineEdit* dirname;
    QPushButton* buttonChooseDir;
    QRadioButton* optionRename;
    QGroupBox* GroupBox5;
    QCheckBox* CheckBox7;
    KDateWidget* kDatePicker;
    QFrame* Line2;
    QLabel* TextLabel2;
    QListView* remanedPreviewListView;
    QToolButton* moveUpPushButton;
    QToolButton* moveDownPushButton;
    QCheckBox* previewCheckBox;
    QLabel* PixmapLabel1;
    QPushButton* renamePushButton;
    QPushButton* cancelPushButton;

protected:
    QVBoxLayout* RenameSeriesLayout;
    QHBoxLayout* GroupBox1Layout;
    QVBoxLayout* layout13;
    QGridLayout* layout11;
    QHBoxLayout* GroupBox9Layout;
    QHBoxLayout* Layout1;
    QVBoxLayout* ButtonGroup1Layout;
    QGridLayout* layout5;
    QVBoxLayout* GroupBox5Layout;
    QVBoxLayout* layout14;
    QHBoxLayout* layout13_2;
    QVBoxLayout* layout7;
    QVBoxLayout* layout12;
    QVBoxLayout* layout15;
    QHBoxLayout* layout14_2;
    QHBoxLayout* layout2;



protected slots:
    virtual void languageChange();

    virtual void slotMoveDown();
    virtual void slotMoveUp();
    virtual void slotSetImagePreview(int);
    virtual void slotUpdatePreview(QListViewItem*);
    virtual void slotUpdateRenamed(const QString &);
    virtual void slotUpdateRenamed();

    void chooseDir();
};

#endif 
