/***************************************************************************
                          rename.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rename.h"

#include <qvariant.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include <qtoolbutton.h>

#include <kdatewidget.h>
#include <klocale.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kiconloader.h>

/*
 *  Constructs a RenameSeries which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
RenameSeries::RenameSeries( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : KDialog( parent, name, modal, fl )
{

    if ( !name )
	setName( "RenameSeries" );

    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMaximumSize( QSize( 1024, 768 ) );
    RenameSeriesLayout = new QVBoxLayout( this, 11, 6, "RenameSeriesLayout");

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setFrameShape( QGroupBox::GroupBoxPanel );
    GroupBox1->setFrameShadow( QGroupBox::Sunken );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 6 );
    GroupBox1->layout()->setMargin( 11 );
    GroupBox1Layout = new QHBoxLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );

    layout13 = new QVBoxLayout( 0, 0, 6, "layout13");

    layout11 = new QGridLayout( 0, 1, 1, 0, 6, "layout11");

    TextLabel1 = new QLabel( GroupBox1, "TextLabel1" );
    TextLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, 0, 0, TextLabel1->sizePolicy().hasHeightForWidth() ) );

    layout11->addMultiCellWidget( TextLabel1, 0, 0, 0, 1 );

    checkExtension = new QCheckBox( GroupBox1, "checkExtension" );
    checkExtension->setChecked( TRUE );

    layout11->addWidget( checkExtension, 1, 1 );

    overwrite = new QCheckBox( GroupBox1, "overwrite" );

    layout11->addMultiCellWidget( overwrite, 2, 2, 0, 1 );

    paternLineEdit = new QLineEdit( GroupBox1, "paternLineEdit" );
    paternLineEdit->setCursor( QCursor( 0 ) );

    layout11->addWidget( paternLineEdit, 1, 0 );
    layout13->addLayout( layout11 );

    GroupBox9 = new QGroupBox( GroupBox1, "GroupBox9" );
    GroupBox9->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, 0, 0, GroupBox9->sizePolicy().hasHeightForWidth() ) );
    GroupBox9->setColumnLayout(0, Qt::Vertical );
    GroupBox9->layout()->setSpacing( 6 );
    GroupBox9->layout()->setMargin( 11 );
    GroupBox9Layout = new QHBoxLayout( GroupBox9->layout() );
    GroupBox9Layout->setAlignment( Qt::AlignTop );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");

    TextLabel2_2 = new QLabel( GroupBox9, "TextLabel2_2" );
    Layout1->addWidget( TextLabel2_2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    spinIndex = new QSpinBox( 1, 65000, 1, GroupBox9, "spinIndex" );
    Layout1->addWidget( spinIndex );
    GroupBox9Layout->addLayout( Layout1 );
    layout13->addWidget( GroupBox9 );

    ButtonGroup1 = new QButtonGroup( GroupBox1, "ButtonGroup1" );
    ButtonGroup1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, 0, 0, ButtonGroup1->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 6 );
    ButtonGroup1->layout()->setMargin( 11 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );

    optionCopy = new QRadioButton( ButtonGroup1, "optionCopy" );
    ButtonGroup1Layout->addWidget( optionCopy );

    optionMove = new QRadioButton( ButtonGroup1, "optionMove" );
    ButtonGroup1Layout->addWidget( optionMove );

    layout5 = new QGridLayout( 0, 1, 1, 0, 6, "layout5");

    dirname = new QLineEdit( ButtonGroup1, "dirname" );
    dirname->setEnabled( FALSE );

    layout5->addWidget( dirname, 1, 0 );

    buttonChooseDir = new QPushButton( ButtonGroup1, "buttonChooseDir" );
    buttonChooseDir->setEnabled( FALSE );
    //buttonChooseDir->setPixmap( image0 );
    buttonChooseDir->setPixmap(QPixmap(BarIcon("folder_open",16 )));
    buttonChooseDir->setFlat( FALSE );

    layout5->addWidget( buttonChooseDir, 1, 1 );

    optionRename = new QRadioButton( ButtonGroup1, "optionRename" );
    optionRename->setChecked( TRUE );

    layout5->addMultiCellWidget( optionRename, 0, 0, 0, 1 );
    ButtonGroup1Layout->addLayout( layout5 );
    layout13->addWidget( ButtonGroup1 );

    GroupBox5 = new QGroupBox( GroupBox1, "GroupBox5" );
    GroupBox5->setColumnLayout(0, Qt::Vertical );
    GroupBox5->layout()->setSpacing( 6 );
    GroupBox5->layout()->setMargin( 11 );
    GroupBox5Layout = new QVBoxLayout( GroupBox5->layout() );
    GroupBox5Layout->setAlignment( Qt::AlignTop );

    CheckBox7 = new QCheckBox( GroupBox5, "CheckBox7" );
    GroupBox5Layout->addWidget( CheckBox7 );

    kDatePicker = new KDateWidget( GroupBox5, "kDatePicker" );
    kDatePicker->setEnabled( FALSE );
    GroupBox5Layout->addWidget( kDatePicker );
    layout13->addWidget( GroupBox5 );
    QSpacerItem* spacer_2 = new QSpacerItem( 21, 61, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout13->addItem( spacer_2 );
    GroupBox1Layout->addLayout( layout13 );

    Line2 = new QFrame( GroupBox1, "Line2" );
    Line2->setFrameShape( QFrame::VLine );
    Line2->setFrameShadow( QFrame::Sunken );
    Line2->setFrameShape( QFrame::VLine );
    GroupBox1Layout->addWidget( Line2 );

    layout14 = new QVBoxLayout( 0, 0, 6, "layout14");

    layout13_2 = new QHBoxLayout( 0, 0, 6, "layout13_2");

    layout7 = new QVBoxLayout( 0, 0, 6, "layout7");

    TextLabel2 = new QLabel( GroupBox1, "TextLabel2" );
    layout7->addWidget( TextLabel2 );

    remanedPreviewListView = new QListView( GroupBox1, "remanedPreviewListView" );
    remanedPreviewListView->addColumn( tr( "origin" ) );
    remanedPreviewListView->header()->setClickEnabled( FALSE, remanedPreviewListView->header()->count() - 1 );
    remanedPreviewListView->addColumn( tr( "renamed" ) );
    remanedPreviewListView->header()->setClickEnabled( FALSE, remanedPreviewListView->header()->count() - 1 );
    remanedPreviewListView->header()->setResizeEnabled( FALSE, remanedPreviewListView->header()->count() - 1 );
    remanedPreviewListView->setMouseTracking( FALSE );
    remanedPreviewListView->setFocusPolicy( QListView::NoFocus );
    remanedPreviewListView->setFrameShape( QListView::Box );
    remanedPreviewListView->setFrameShadow( QListView::Plain );
    remanedPreviewListView->setLineWidth( 1 );
    remanedPreviewListView->setMargin( 0 );
    remanedPreviewListView->setMidLineWidth( 0 );
    remanedPreviewListView->setAllColumnsShowFocus( TRUE );
    remanedPreviewListView->setShowSortIndicator( TRUE );
    remanedPreviewListView->setItemMargin( 1 );
    remanedPreviewListView->setRootIsDecorated( FALSE );
    layout7->addWidget( remanedPreviewListView );
    layout13_2->addLayout( layout7 );

    layout12 = new QVBoxLayout( 0, 0, 6, "layout12");

    //moveUpPushButton = new QToolButton(Qt::UpArrow,  GroupBox1, "moveUpPushButton" );
    moveUpPushButton = new QToolButton(Qt::UpArrow,  GroupBox1, "moveUpPushButton" );
    moveUpPushButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, moveUpPushButton->sizePolicy().hasHeightForWidth() ) );
    moveUpPushButton->setMinimumSize( QSize( 0, 0 ) );
    layout12->addWidget( moveUpPushButton );

    //moveDownPushButton = new QToolButton(Qt::DownArrow,  GroupBox1, "moveDownPushButton" );
    moveDownPushButton = new QToolButton(Qt::DownArrow,  GroupBox1, "moveDownPushButton" );
    moveDownPushButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, moveDownPushButton->sizePolicy().hasHeightForWidth() ) );
    layout12->addWidget( moveDownPushButton );
    layout13_2->addLayout( layout12 );
    layout14->addLayout( layout13_2 );

    layout15 = new QVBoxLayout( 0, 0, 6, "layout15");

    previewCheckBox = new QCheckBox( GroupBox1, "previewCheckBox" );
    layout15->addWidget( previewCheckBox );

    layout14_2 = new QHBoxLayout( 0, 0, 6, "layout14_2");
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout14_2->addItem( spacer_3 );

    PixmapLabel1 = new QLabel( GroupBox1, "PixmapLabel1" );
    PixmapLabel1->setEnabled( FALSE );
    PixmapLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, PixmapLabel1->sizePolicy().hasHeightForWidth() ) );
    PixmapLabel1->setFrameShape( QLabel::Box );
    PixmapLabel1->setFrameShadow( QLabel::Raised );
    //PixmapLabel1->setPixmap( image1 );
    PixmapLabel1->setScaledContents( TRUE );
    layout14_2->addWidget( PixmapLabel1 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout14_2->addItem( spacer_4 );
    layout15->addLayout( layout14_2 );
    layout14->addLayout( layout15 );
    GroupBox1Layout->addLayout( layout14 );
    RenameSeriesLayout->addWidget( GroupBox1 );

    layout2 = new QHBoxLayout( 0, 0, 6, "layout2");
    QSpacerItem* spacer_5 = new QSpacerItem( 61, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( spacer_5 );

    renamePushButton = new QPushButton( this, "renamePushButton" );
    layout2->addWidget( renamePushButton );

    cancelPushButton = new QPushButton( this, "cancelPushButton" );
    layout2->addWidget( cancelPushButton );
    RenameSeriesLayout->addLayout( layout2 );
    languageChange();
    resize( QSize(570, 561).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    //connect( cancelPushButton, SIGNAL( pressed() ), this, SLOT( reject() ) );
    connect( CheckBox7, SIGNAL( toggled(bool) ), kDatePicker, SLOT( setEnabled(bool) ) );
    connect( optionCopy, SIGNAL( toggled(bool) ), dirname, SLOT( setEnabled(bool) ) );
    connect( optionCopy, SIGNAL( toggled(bool) ), buttonChooseDir, SLOT( setEnabled(bool) ) );
    connect( optionMove, SIGNAL( toggled(bool) ), dirname, SLOT( setEnabled(bool) ) );
    connect( optionMove, SIGNAL( toggled(bool) ), buttonChooseDir, SLOT( setEnabled(bool) ) );
    connect( optionRename, SIGNAL( toggled(bool) ), dirname, SLOT( setDisabled(bool) ) );
    connect( optionRename, SIGNAL( toggled(bool) ), buttonChooseDir, SLOT( setDisabled(bool) ) );
    connect( previewCheckBox, SIGNAL( stateChanged(int) ), this, SLOT( slotSetImagePreview(int) ) );
    connect( previewCheckBox, SIGNAL( toggled(bool) ), PixmapLabel1, SLOT( setEnabled(bool) ) );
    connect( remanedPreviewListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotUpdatePreview(QListViewItem*) ) );

    // tab order
    setTabOrder( paternLineEdit, checkExtension );
    setTabOrder( checkExtension, spinIndex );
    setTabOrder( spinIndex, previewCheckBox );
    setTabOrder( previewCheckBox, renamePushButton );
    setTabOrder( renamePushButton, cancelPushButton );
    setTabOrder( cancelPushButton, remanedPreviewListView );

	//
	//
	//
	//
	//
	//
	connect( renamePushButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( cancelPushButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( previewCheckBox, SIGNAL( stateChanged(int) ), this, SLOT( slotSetImagePreview(int) ) );
	connect( remanedPreviewListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotUpdatePreview(QListViewItem*) ) );
	connect( moveUpPushButton, SIGNAL( clicked() ), this, SLOT( slotMoveUp() ) );
	connect( moveDownPushButton, SIGNAL( clicked() ), this, SLOT( slotMoveDown() ) );
	connect( buttonChooseDir, SIGNAL( clicked()), this, SLOT( chooseDir() ));

	//
	connect( spinIndex,   SIGNAL( valueChanged( int ) ), this, SLOT( slotUpdateRenamed() ) );
	connect( checkExtension,   SIGNAL( toggled ( bool ) ), this, SLOT( slotUpdateRenamed() ) );
	//
	connect( paternLineEdit, SIGNAL(  textChanged ( const QString & ) ), this, SLOT( slotUpdateRenamed(const QString &)) );
	connect( paternLineEdit, SIGNAL( returnPressed() ), this, SLOT( accept() ) );

	paternLineEdit->setFocus();

	pix = new QPixmap(180, 160);
	pix->fill(this, 0, 0);
	PixmapLabel1->setPixmap(QPixmap(*pix));
	PixmapLabel1->setScaledContents( TRUE );
	PixmapLabel1->setMaximumSize( QSize(180, 160) );

	moveUpPushButton->setFixedWidth(16);
	moveDownPushButton->setFixedWidth(16);

	last=NULL;
	currentItem=NULL;
	newNames = NULL;

	clear();


}

/*
 *  Destroys the object and frees any allocated resources
 */
RenameSeries::~RenameSeries()
{
	// no need to delete child widgets, Qt does it all for us
}

void RenameSeries::clear()
{
	delete(newNames);
	newNames = new BatchRenamer();

	arrayNames = QMemArray<QString*>();
	taille=0;
	last=NULL;
	currentItem=NULL;

	remanedPreviewListView->clear();

	previewCheckBox->setChecked(false);

	paternLineEdit->setText( i18n( "Pattern_#" ) );
	spinIndex->setValue(1);
}


void RenameSeries::chooseDir()
{
 	 QString s (QFileDialog::getExistingDirectory ( QString::null, this ));
 	 if(!s.isEmpty())
 		dirname->setText( s );
}


void RenameSeries::addFile(QString filename)
{
	int pos = filename.findRev ("/");
	QString name = filename.right (filename.length () - pos-1);

	QListViewItem *item = new QListViewItem( remanedPreviewListView, last);
	last=item;
	item->setText( 0,  name );
	item->setText( 1,  paternLineEdit->text()+QString().setNum(taille));
	taille++;
	QString order;
	order.sprintf ("%0300d",taille);
	item->setText( 2,  order);

	arrayNames.resize(taille);
	arrayNames[taille-1]=new QString(filename);
}

void RenameSeries::slotMoveDown()
{
	remanedPreviewListView->disconnect(this);

	if(currentItem)
	{
		QListViewItem* apres=currentItem->itemBelow();
		if(currentItem->itemBelow ())
		{
			QString sBelow=apres->text(0);
			apres->setText(0, currentItem->text(0));
			currentItem->setText(0, sBelow);

			remanedPreviewListView->setCurrentItem(apres);
			remanedPreviewListView->setSelected(apres, true);
			currentItem = apres;

			////////
			int indice =(int)((float)remanedPreviewListView->itemPos(currentItem)/currentItem->height())-1;

			QString* tmp = arrayNames[indice+1];
			arrayNames[indice+1] = arrayNames[indice];
			arrayNames[indice]=tmp;
		}
	}
	connect( remanedPreviewListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotUpdatePreview(QListViewItem*) ) );
}

void RenameSeries::slotMoveUp()
{
	remanedPreviewListView->disconnect(this);
	if(currentItem)
		if(currentItem->itemAbove())
		{
			QListViewItem* avant=currentItem->itemAbove();
			if(avant)
			{
				QString sBelow=avant->text(0);
				avant->setText(0, currentItem->text(0));
				currentItem->setText(0, sBelow);

				remanedPreviewListView->setCurrentItem(avant);
				remanedPreviewListView->setSelected(avant, true);
				currentItem=avant;

				//////
				int indice =(int)((float)remanedPreviewListView->itemPos(currentItem)/currentItem->height()+1);

				QString* tmp = arrayNames[indice-1];
				arrayNames[indice-1] = arrayNames[indice];
				arrayNames[indice]=tmp;
			}
		}
	connect( remanedPreviewListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotUpdatePreview(QListViewItem*) ) );
}

void RenameSeries::slotSetImagePreview(int)
{
	if(! previewCheckBox->isChecked())
	{
		PixmapLabel1->setPixmap(QPixmap(*pix));
	}
	else
	{
		if(!currentItem)
			return;

		KApplication::setOverrideCursor (waitCursor);	  // this might take time

		int indice =(int)((float)remanedPreviewListView->itemPos(currentItem)/currentItem->height());

		QImage im = QImage(*arrayNames[indice]);
		im = im.smoothScale(PixmapLabel1->width(), PixmapLabel1->height());
		QPixmap pix;
		pix.convertFromImage(im);
		PixmapLabel1->setPixmap(pix);

		KApplication::restoreOverrideCursor ();   // restore original cursor
	}
}

void RenameSeries::slotUpdatePreview(QListViewItem* item)
{
	currentItem = item;

	if(previewCheckBox->isChecked())
	{
		KApplication::setOverrideCursor (waitCursor);	    // this might take time

		int indice =(int)((float)remanedPreviewListView->itemPos(item)/item->height());
		QImage im = QImage(*arrayNames[indice]);
		im = im.smoothScale(PixmapLabel1->width(), PixmapLabel1->height());
		QPixmap pix;
		pix.convertFromImage(im);
		PixmapLabel1->setPixmap(pix);

		KApplication::restoreOverrideCursor ();     // restore original cursor
	}
}

int RenameSeries::exec ()
{
//	remanedPreviewListView->setSorting(2, true);
//	remanedPreviewListView->sort();
	slotUpdateRenamed();
	return QDialog::exec();
}

void RenameSeries::slotUpdateRenamed()
{
	slotUpdateRenamed(NULL);
}

void RenameSeries::slotUpdateRenamed(const QString &)
{
	QString fileName, tmp;
	QListViewItem * myChild = remanedPreviewListView->firstChild();
	int pos=0;
	QFileInfo fi;
	while( myChild )
    	{
		 fileName = QFileInfo(myChild->text(0)).baseName();

		fileName = newNames->doEscape( fileName );
		tmp = newNames->findOldName( fileName, paternLineEdit->text() );
		tmp = newNames->findOldNameLower( fileName, tmp );
		tmp = newNames->findOldNameUpper( fileName, tmp );
		tmp = newNames->findStar( fileName, tmp );
		tmp = newNames->findNumbers( tmp, pos, arrayNames.size(), spinIndex->value());

		// Add Extension if necesary
		tmp = newNames->unEscape( tmp );
		 if(checkExtension->isChecked())
		 {
			fi.setFile( *arrayNames[pos] );
			if( !fi.extension().isEmpty())
			{
				tmp+="."+fi.extension();
			}
		 }

		 myChild->setText(1,tmp);

		 pos++;
		 myChild = myChild->nextSibling();
	}
}

bool RenameSeries::checkErrors(bool checkDir)
{
	// Error checking:
	QDir d;
	if( paternLineEdit->text().stripWhiteSpace().isEmpty() ) {
		KMessageBox::sorry( this, i18n("Please add an expression to rename the files.") );
		return false;
	}
	else
	if( (checkDir) && (dirname->text().isEmpty() && !optionRename->isChecked()) )
	{
		KMessageBox::sorry( this, i18n("Please give a destination directory.") );
		return false;
	}
	else
	if((3+paternLineEdit->text().find('#')+paternLineEdit->text().find('$')+paternLineEdit->text().find('%'))==0)
	{
	 	 KMessageBox::sorry( this, i18n("The expression must contain '#', '$', or '%%'.") );
	 	 return false;
	}
	else
	if( (checkDir) && (!optionRename->isChecked()) )
	{
		if( dirname->text().left(1).compare("/") )
		{
			dirname->setText(QString("%1/").arg(dirname->text()));
		}
	}
	else
	if( (checkDir) && (!optionRename->isChecked()) )
	{
		if( d.exists( dirname->text(), FALSE ))
		{
			KMessageBox::sorry( this, "The given destination directory does not exist." );
			return false;
		}
	}
	return true;

}

QString RenameSeries::getPath( QString fn )
{
	int pos = fn.findRev( "/" );
	return fn.mid( 0, pos + 1 );
}

void RenameSeries::accept()
{
	if(!checkErrors())
		return;

	//comp->addItem(paternLineEdit->text());

	QFileInfo fi;
	data* files = new data[arrayNames.size()];
	values* val = new values;

	ProgressDialog *p = new ProgressDialog( parentWidget(), true, "renamed ProgressDialog", false );
	p->init(arrayNames.size());
	p->print(QString("Renaming %1 files....").arg(arrayNames.size()));

	for(unsigned int i=0; i<arrayNames.size();i++)
	{
		fi.setFile( *arrayNames[i] );
		files[i].source = fi.baseName();
		files[i].extension = fi.extension();
		files[i].count = arrayNames.size();
		if(! files[i].extension.isEmpty() )
			files[i].extension.insert( 0, '.' );

	    files[i].source_path = getPath(fi.filePath());
	}
	BatchRenamer *b = new BatchRenamer(p);

	//
	enum mode m = RENAME;
	if( optionCopy->isChecked() )
	{
	    m = COPY;
	}
	else
	if( optionMove->isChecked() )
	{
	    m = MOVE;
	}
	else
	if( optionRename->isChecked() )
	{
	    m = RENAME;
	}

	//
	val->text = paternLineEdit->text();
	val->dirname = dirname->text();
	val->dvals.date = kDatePicker->date();
	val->index = spinIndex->value();
	val->extension = checkExtension->isChecked();
	val->overwrite = overwrite->isChecked();
	val->dvals.bDate = CheckBox7->isChecked();
	if( val->dvals.bDate )
	{
		val->dvals.changeModification = true;
		val->dvals.changeAccess = true;
		val->dvals.hour = 0;
		val->dvals.minute = 0;
		val->dvals.second = 0;
	}

	hide();
	p->show();
	b->processFiles( files, m, val/*, true */);

	delete(b);
	delete(p);

	QDialog::accept();
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void RenameSeries::languageChange()
{
    setCaption( i18n( "Rename Series" ) );
    QWhatsThis::add( this, i18n( "<u>Description:</u><br>\n"
"\n"
"Add an expression describing the final filename. Valid tokens are:<br>\n"
"<br>\n"
"<b>$</b> old filename<br><b>%</b> old filename converted to lower case<br><b>Both old filenames are without the old file extension.</b><br>\n"
"<br>\n"
"<b>#</b> Adds a number to the filename starting with StartIndex.<br><b>Example:</b>pic_$_#.jpg ." ) );
    GroupBox1->setTitle( i18n( "Options" ) );
    TextLabel1->setText( i18n( "Rename pattern:" ) );
    checkExtension->setText( i18n( "&Use original file extension" ) );
    QToolTip::add( checkExtension, i18n( "This option should be enabled." ) );
    QWhatsThis::add( checkExtension, i18n( "<u>Description:</u><br>\n"
"The original file extension will be added to the final filename. Useful if you want to rename many files of different filetypes." ) );
    overwrite->setText( i18n( "Overwrite &existing file" ) );
    paternLineEdit->setText( i18n( "Pattern_#" ) );
    GroupBox9->setTitle( i18n( "Numbers" ) );
    QWhatsThis::add( GroupBox9, i18n( "<u>Describtion:</u><br>\n"
"<b>This field is only necessary if you added a \"#\" to the filename.</b><br>\n"
"The first file will get the number start index, the second file start index + 1 and so on. E.g. if your file name is picture#, the files will be named picture1, picture2, ... .<br>\n"
"<br>\n"
"\"Fill with 0's\" adds 0 before the number if you have more than 9 files to rename. E.g. picture01,picture02, ... picture10." ) );
    TextLabel2_2->setText( i18n( "Start Index" ) );
    QToolTip::add( spinIndex, i18n( "Start index, if numbers (#) are used in the filename." ) );
    ButtonGroup1->setTitle( i18n( "Type" ) );
    QWhatsThis::add( ButtonGroup1, i18n( "<u>Description:</u><br>This option should be self explanatory.<br>  <br><b>Warning:</b> moving files does not work between different partitions but you can copy them." ) );
    optionCopy->setText( i18n( "&Copy files to destination directory" ) );
    QToolTip::add( optionCopy, i18n( "Your files will be copied<br>to the destination directory and then renamed." ) );
    QWhatsThis::add( optionCopy, QString::null );
    optionMove->setText( i18n( "&Move files to destination directory" ) );
    QToolTip::add( optionMove, i18n( "Your files will be moved<br>to the destination directory and then renamed." ) );
    buttonChooseDir->setText( QString::null );
    QToolTip::add( buttonChooseDir, i18n( "Select a directory where<br>your files should be moved or copied." ) );
    optionRename->setText( i18n( "&Rename input files" ) );
    QToolTip::add( optionRename, i18n( "Your files will be copied<br>to the destination directory and then renamed." ) );
    GroupBox5->setTitle( i18n( "Date" ) );
    CheckBox7->setText( i18n( "&Change date && time" ) );
    QToolTip::add( CheckBox7, i18n( "Changes the creation date and time of files" ) );
    QToolTip::add( kDatePicker, i18n( "Pick a date" ) );
    TextLabel2->setText( i18n( "Renamed preview:" ) );
    remanedPreviewListView->header()->setLabel( 0, i18n( "origin" ) );
    remanedPreviewListView->header()->setLabel( 1, i18n( "renamed" ) );
    remanedPreviewListView->clear();

    moveUpPushButton->setText( i18n( "&up" ) );
    moveDownPushButton->setText( i18n( "&down" ) );
    QToolTip::add( moveDownPushButton, i18n( "Move item down" ) );
    QWhatsThis::add( moveDownPushButton, i18n( "Move the selected item down" ) );
    previewCheckBox->setText( i18n( "Show image &preview" ) );
    renamePushButton->setText( i18n( "&Rename..." ) );
    cancelPushButton->setText( i18n( "&Cancel" ) );
}

#include "rename.moc"
