//
// Copyright (c) 2000-2001 - Andrew Richards <ajr@users.sourceforge.net>
//                    2003 - Richard Groult <rgroult@jalix.org>
//
// This file is part of the PikView image viewer released under the GNU GPL.
// For license details see the file COPYING included with this distribution.
//

#ifndef __KMAGICK_H__
#define __KMAGICK_H__

#include <qimage.h>
#include <qfileinfo.h>

#include <kstandarddirs.h>
#include <kprocess.h>


void
kimgio_magick_read(QImageIO *_imageio)
{
	QImage img;

	char imagename[255];

	strcpy(imagename, _imageio->fileName().ascii());

	KShellProcess *proc = new KShellProcess ();
	QString com;
	com.append (locate("appdata", "convert2png.pl"));
	com.append (" ");
	com.append (KShellProcess::quote(imagename));

	*proc <<  com;
	proc->start (KShellProcess::Block);
	img.load("/tmp/showimgFromPSD.png");
	_imageio->setImage(img);
	_imageio->setStatus(0);
}


void
kimgio_magick_write(QImageIO *)
{
}

void
kimgio_magick_register()
{
/*
	// I think only XV puts this kinda header on it
	QImageIO::defineIOHandler("PICT", "^PICSoftware", 0,
														kimgio_magick_read, kimgio_magick_write);

	QImageIO::defineIOHandler("DCX", "\261h\336", 0,
														kimgio_magick_read, kimgio_magick_write);

	QImageIO::defineIOHandler("PCX", "\xa\x5\x1\x8", 0,

														kimgio_magick_read, kimgio_magick_write);

	// ImageMagick Image File Formt
	QImageIO::defineIOHandler("MIF", "^id\\=ImageMagick", 0,
														kimgio_magick_read, kimgio_magick_write);

	//Windows BMP/DIB
	QImageIO::defineIOHandler("BMP", "^BM", 0,
														kimgio_magick_read, kimgio_magick_write);

	// FITS
	QImageIO::defineIOHandler("FITS", "^SIMPLE  =", 0,
														kimgio_magick_read, kimgio_magick_write);

	// Khoros Visualization image file
	QImageIO::defineIOHandler("VIFF", "^\xab", 0,
														kimgio_magick_read, kimgio_magick_write);

	// pgb
	QImageIO::defineIOHandler("PNM", "^P[4-6]", 0,
														kimgio_magick_read, kimgio_magick_write);

	// eps
	QImageIO::defineIOHandler("EPS", "^%!PS-Adobe-", "T",
														kimgio_magick_read, kimgio_magick_write);
 */
	QImageIO::defineIOHandler("PSD", "^8BPS", 0,
														kimgio_magick_read, NULL);
/*
	QImageIO::defineIOHandler("TGA", 0, 0,
														kimgio_magick_read, kimgio_magick_write);
   */
}

#endif
