

/***************************************************************************
                          imagelistview.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "imagelistview.h"

#include "imageloader.h"
#include "mainwindow.h"
#include "kexifpropsplugin.h"
#include "khexeditpropsplugin.h"
#include "qtfileicondrag.h"
#include "imagefileiconitem.h"
#include "dirfileiconitem.h"
#include "imageviewer.h"

#ifdef HAVE_LIBDIGIKAM
#include <digikamplugins/digikampluginmanager.h>
#endif /* HAVE_LIBDIGIKAM */

#include <kprocess.h>
#include <kiconview.h>
#include <kfileiconview.h>
#include <kaccel.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kpropsdlg.h>
#include <kopenwith.h>
#include <klineeditdlg.h>
#include <kurlrequesterdlg.h>
#include <kglobalsettings.h>
#include <kio/job.h>
#include <kfiledialog.h>
#include <kfileitem.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kiconeffect.h>
#include <kpixmapio.h>
#include <kcursor.h>
#include <kglobalsettings.h>
#include <konq_operations.h>
#include <kapplication.h>

#include <qmessagebox.h>
#include <qevent.h>
#include <qmime.h>
#include <qiconview.h>
#include <qevent.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qdragobject.h>
#include <qstringlist.h>
#include <qlistview.h>
#include <qtextcodec.h>

#include <stdlib.h>

KToolTip::KToolTip(QWidget *parent, ImageListView *imageList)
: QToolTip(parent)
{
	this->imageList=imageList;
}


void
KToolTip::maybeTip(const QPoint &pos)
{
	FileIconItem *item = (FileIconItem*)imageList->itemAt(imageList->viewportToContents(pos));
	if(!item)
		return;
	QRect r = item->pixmapRect(false);
	r.moveTopLeft(imageList->contentsToViewport(r.topLeft()));
	if ( !r.isValid() )
		return;
	tip(r, item->toolTipStr());
}


void
KToolTip::tip ( const QRect & r, const QString & text )
{
	QToolTip::tip(r, text);
}

/////////////////////////
ImageListView::ImageListView (QWidget * parent, const char *name,
				MainWindow * mw)
	:KIconView (parent, name)
{
	this->mw = mw;

	m_popup = new KPopupMenu ();
		m_popup->insertTitle("", 1);
	m_popup_openWith = new KPopupMenu ();
	m_popupEmpty = new KPopupMenu ();

	il = new ImageLoader ();

	sortMode=0;
	loop=true;
	p=true;
	random=false;
	curIt=NULL;
	dscr=NULL;
	isLoadingThumbnail=false;
	mouseIsPressed=false;

	connect(this, SIGNAL(selectionChanged()),
			SLOT(selectionChanged()));
	connect(this, SIGNAL(onItem(QIconViewItem*)),
			SLOT(highlight(QIconViewItem *)));
	connect(this, SIGNAL(onViewport()),
			SLOT(onViewport()));
	connect(this, SIGNAL(contextMenuRequested(QIconViewItem *, const QPoint &)),
			SLOT(popup(QIconViewItem *, const QPoint &)));

	setResizeMode (Adjust);
	setWordWrapIconText(false);
	setShowToolTips(true);
	setSelectionMode (Extended);
	setItemsMovable ( true );
	setItemTextPos( Bottom );
	setArrangement(LeftToRight);
	setSpacing(3);
	setAutoArrange(true);

	toolTips = new KToolTip(viewport(), this);
	iconEffect=new KIconEffect();

	this->currentIconSize=48;
}


KPopupMenu*
ImageListView::popupOpenWith()
{
	popup(currentItem(), QPoint());
	return m_popup_openWith;
}

void
ImageListView::popup(QIconViewItem *item, const QPoint &)
{
	m_popup_openWith->clear();
	m_popup_openWith->disconnect();

	if(!item)
	{
		m_popup_openWith->setEnabled(false);
		return;
	}
	else
	{
		m_popup_openWith->setEnabled(true);
	}

	if(((FileIconItem*)item)->mimetype().left(5)=="image")
	{
		actionCollection->action("Open with Gimp")->plug(m_popup_openWith);
		m_popup_openWith->insertSeparator ();
	}
	//
	m_offerList = KTrader::self()->query(((FileIconItem*)item)->mimetype(), "Type == 'Application'");
	for (uint i=0; i < m_offerList.count(); i++)
	{
		m_popup_openWith->insertItem(SmallIcon(m_offerList[i]->icon()), m_offerList[i]->name(), i+1);
	}
	if(m_offerList.size()!=0)
		m_popup_openWith->insertSeparator ();

	actionCollection->action("Open with")->plug(m_popup_openWith);
	connect(m_popup_openWith, SIGNAL(activated(int)), this, SLOT(slotRun(int)));
  mouseIsPressed=false;
}

void
ImageListView::slotRun(int  id)
{		
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::slotRun(int  id)" << endl;
	if((uint)id>=1 && (uint)id<=m_offerList.size())
	{
		KURL::List list;
		for ( FileIconItem *item = firstItem(); item; item = item->nextItem() )
		{
			if ( item->isSelected() )
			list << "file:/"+item->fullName();
		}
		if (KRun::run(*m_offerList[id-1], list)==0)
		{
			KMessageBox::error(this, "<qt>"+i18n("Error while running %1.").arg((*m_offerList[id-1]).name())+"</qt>");
		}
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::slotRun(int  id)" << endl;
}


bool
ImageListView::doPreload()
{
	return p;
}

void
ImageListView::setPreload(bool p)
{
	this->p=p;
}

bool
ImageListView::doLoop()
{
	return loop;
}

void
ImageListView::setLoop(bool loop)
{
	this->loop=loop;
}

bool
ImageListView::doRandom()
{
	return random;
}

void
ImageListView::setRandom(bool ran)
{
	this->random=ran;
}

FileIconItem*
ImageListView::itemAt(QPoint pos)
{
	return (FileIconItem*)QIconView::findItem(pos);
}

void
ImageListView::setThumbnailSize(QSize newSize, bool refresh)
{
	if(newSize.width()==80) currentIconSize=32;
	else if(newSize.width()==120) currentIconSize=48;
	else currentIconSize=64;

	if(mw->preview())
	{
		if(itemTextPos()==Right)
			setGridX(2*newSize.width()+2*spacing());
		else
			setGridX(newSize.width()+2*spacing());
		setGridY(newSize.height()+this->font().pointSize()+2*spacing());
	}
	else
	{
		setGridX(currentIconSize+spacing());
		setGridY(currentIconSize+spacing());
	}
	setMaxItemTextLength(gridX());	
	il->setThumbnailSize(newSize);	
	for (FileIconItem *i = firstItem(); i; i=i->nextItem() )
	{
		i->setHasPreview (false);
		if(!mw->preview())
			i->setPixmap(i->fileInfo()->pixmap(currentIconSize));
	}
	arrangeItemsInGrid();
	if(refresh && mw->preview()) slotLoadFirst();	
}

void
ImageListView::slotUpdate ()
{
	setContentsPos(0,0);
	arrangeItemsInGrid();
}

void
ImageListView::slotResetThumbnail()
{
	stopLoading();
	for (FileIconItem * item = firstItem (); item != 0; item = item->nextItem ())
		item->setPixmap(item->fileInfo()->pixmap(currentIconSize));
	arrangeItemsInGrid();
}


void
ImageListView::slotRename()
{
	if(KIconView::currentItem())
	{
		bool ok;
		QString name=((ImageFileIconItem*)KIconView::currentItem())->text(0);
		const QString newName(KLineEditDlg::getText(i18n("Rename '<b>%1</b>':").arg(name),
					 name,
					 &ok, mw->iv).stripWhiteSpace());
		if(ok && newName!="")
		{
			((ImageFileIconItem*)KIconView::currentItem())->setText(newName);
		}
	}
}

void
ImageListView::initMenu(KActionCollection *actionCollection)
{
	this->actionCollection=actionCollection;

	KPopupMenu *popupnew = new KPopupMenu ();
		actionCollection->action("editdirnew")->plug(popupnew);
		actionCollection->action("editalbumnew")->plug(popupnew);
	m_popupEmpty->insertItem(i18n("Create &New"), popupnew);

	actionCollection->action("editpaste")->plug(m_popupEmpty);

	m_popupEmpty->insertSeparator();
	KPopupMenu *popupsort = new KPopupMenu ();
	actionCollection->action("by name")->plug(popupsort);
	actionCollection->action("by extension")->plug(popupsort);
	actionCollection->action("by size")->plug(popupsort);
	actionCollection->action("by date")->plug(popupsort);
	m_popupEmpty->insertItem(i18n("Sorting"), popupsort);

	KPopupMenu *popupar = new KPopupMenu ();
		KPopupMenu *popupIc = new KPopupMenu ();
		actionCollection->action("From left to right")->plug(popupIc);
		actionCollection->action("From top to bottom")->plug(popupIc);
		popupar->insertItem(i18n("Icons"), popupIc);

		KPopupMenu *popupTxt = new KPopupMenu ();
		actionCollection->action("on the right")->plug(popupTxt);
		actionCollection->action("at the bottom")->plug(popupTxt);
		popupar->insertItem(i18n("Text"), popupTxt);
	m_popupEmpty->insertItem(i18n("Arrangement"), popupar);

	actionCollection->action("view_icons")->plug(m_popupEmpty);

	m_popupEmpty->insertSeparator();
	actionCollection->action("SelectAll")->plug(m_popupEmpty);
	actionCollection->action("Unselect All")->plug(m_popupEmpty);
	actionCollection->action("Invert Selection")->plug(m_popupEmpty);

	/////////////
	actionCollection->action("editcopy")->plug(m_popup);

	m_popup->insertSeparator();
	actionCollection->action("rename")->plug(m_popup);
	actionCollection->action("edittrash")->plug(m_popup);
	actionCollection->action("editdelete")->plug(m_popup);

	m_popup->insertSeparator();
	actionCollection->action("copyFilesTo")->plug(m_popup);
	actionCollection->action("moveFilesTo")->plug(m_popup);


	m_popup->insertSeparator();
	m_popup_openWith = new KPopupMenu ();
	m_popup->insertItem(i18n("Open with"), m_popup_openWith);

	m_popup->insertSeparator();
	actionCollection->action("Image Info")->plug(m_popup);
	actionCollection->action("Edit File Type")->plug(m_popup);
	actionCollection->action("Properties")->plug(m_popup);
}


void
ImageListView::refresh ()
{
//	kdDebug() << __FILE__ << __LINE__ << " ImageListView::refresh ()" << endl;
	mw->slotRefresh();
}


QString
ImageListView::currentItemName()
{
	if(currentItem())
		return currentItem()->text();
	else
		return QString();
}


void
ImageListView::setCurrentItemName(QString itemName, bool select)
{
	 KIconView::setCurrentItem(findItem(itemName));
	 if(currentItem())
	 {
	 	KIconView::setSelected(currentItem(), select, false);
		KIconView::ensureItemVisible (currentItem());
		kapp->processEvents();
	 	if(select) currentItem()->setSelected(true);
	}
}

bool
ImageListView::hasImages()
{
	return KIconView::count()!=0;
}

bool
ImageListView::hasImageSelected()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::hasImageSelected()" << endl;
	if(!hasImages())
		return false;
	for (FileIconItem *i = firstItem(); i; i=i->nextItem() )
	{
		if(i->isSelected())
		{
			return true;
		}
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::hasImageSelected()" << endl;
	return false;
}

int
ImageListView::countSelected()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::hasImageSelected()" << endl;
	int number=0;
	for (FileIconItem *i = firstItem(); i; i=i->nextItem() )
		if(i->isSelected())
			number++;
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::hasImageSelected()" << endl;
	return number;
}


bool
ImageListView::hasOnlyOneImageSelected()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::hasOnlyOneImageSelected()" << endl;
	int number=0;
	for (FileIconItem *i = firstItem(); i; i=i->nextItem() )
	{
		if(i->isSelected())
			number++;
		if(number>=2) return false;

	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::hasOnlyOneImageSelected()" << endl;
	return true;
}


FileIconItem*
ImageListView::firstSelected()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::firstSelected()" << endl;
	for (FileIconItem *i = firstItem(); i; i=i->nextItem() )
	{
		if(i->isSelected())
		{
			return i;
		}
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::firstSelected()" << endl;
	return NULL;
}



void
ImageListView::selectionChanged()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::selectionChanged()" << endl;
	mw->setHasImageSelected(hasImageSelected());
#ifdef HAVE_LIBDIGIKAM
	if (hasImageSelected())
		emitItemsSelected(true);
	else
		emitItemsSelected(false);
#endif /* HAVE_LIBDIGIKAM */

//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::selectionChanged()" << endl;
}

void
ImageListView::slotLoadFirst()
{
//	kdDebug() << __FILE__ << __LINE__ << " ImageListView::slotLoadFirst ()" << endl;
	if (mw->preview() && count()>0 && !isLoadingThumbnail)
	{
		stopLoading();
		mw->slotReset ();
		imageLoading = firstItem();
		if(count()==1)
		{
			if(!imageLoading->hasPreview() && imageLoading->isImage())
			{
				isLoadingThumbnail=true;
				QFileInfo *fi = new QFileInfo(imageLoading->fullName());
				il->loadMiniImage (fi, this,  true);
			}
			else imageLoading=NULL;
		}
		else
		{
			while(imageLoading && (imageLoading->hasPreview() || !imageLoading->isImage()))
			{
				imageLoading=imageLoading->nextItem ();
				mw->slotPreviewDone ();
			}
			if(imageLoading)
			{
				isLoadingThumbnail=true;
				slotLoadNext ();
			}
		}
	if(!imageLoading){ mw->slotDone();}
	}
}

void
ImageListView::slotLoadFirst(FileIconItem *item)
{
	if (mw->preview())
	{
		stopLoading();
		mw->slotReset (false);
		imageLoading = item;
		if(imageLoading)
		{
			isLoadingThumbnail=true;
			slotLoadNext ();
		}
		else
			mw->slotDone ();
	}
}

void
ImageListView::slotLoadNext ()
{
	if(!isLoadingThumbnail) return;

	if(imageLoading)
	{
		while(QFileInfo(imageLoading->fullName()).extension(true).lower()=="psd")
		{
			imageLoading = imageLoading->nextItem ();
			if(!imageLoading)break;
		}
	}
	if(imageLoading)
	{
		QFileInfo *fi = new QFileInfo(imageLoading->fullName());
		il->loadMiniImage (fi, this,  true);
	}
}


void
ImageListView::slotSetPixmap (const QPixmap pm)
{
	if(!isLoadingThumbnail) return;

	nbrTh++;
	if(imageLoading)
	{
		imageLoading->setPixmap (pm, true);

		mw->slotPreviewDone ();
		imageLoading = imageLoading->nextItem ();
		while(imageLoading && !imageLoading->isImage())
		{
			imageLoading = imageLoading->nextItem ();
		}
	}
	else
	{
		return;
	}


	if (imageLoading)
	{
		slotLoadNext ();
	}
	else
	{
		isLoadingThumbnail=false;
		mw->slotDone();
		arrangeItemsInGrid();
	}
}


void
ImageListView::next ()
{
	if(!hasImages())
		return;

	FileIconItem *item=NULL;
	if(doRandom())
	{
		srand(time(NULL));
		while(item==NULL)
		{
			int x = (int)(rand()/(RAND_MAX+1.0)*contentsWidth());
			int y = (int)(rand()/(RAND_MAX+1.0)*contentsHeight());
			item=(FileIconItem *)KIconView::findItem((const QPoint&)QPoint(x,y));
		}
	}
	else
	{
		item=currentItem();
		if(!item)
			item=firstItem();
		else
			item=item->nextItem();
	}
	if(item)
	{
		while(item && !item->isImage())
			item=item->nextItem ();
		if(item)
		{
	 		KIconView::ensureItemVisible (item);
	 		KIconView::setCurrentItem (item);
	 		KIconView::setSelected (item, true, false);
	 		item ->setSelected (true);
			if(dscr)slotImageInfo();
		}
		else if(loop) first();
	}
	else if(loop) first();
}


void
ImageListView::previous ()
{
	if(!hasImages())
		return;

	FileIconItem *item=NULL;
	if(doRandom())
	{
		srand(time(NULL));
		while(item==NULL)
		{
			int x = (int)(rand()/(RAND_MAX+1.0)*contentsWidth());
			int y = (int)(rand()/(RAND_MAX+1.0)*contentsHeight());
			item=(FileIconItem *)KIconView::findItem((const QPoint&)QPoint(x,y));
		}
	}
	else
	{
		item=currentItem();
		if(!item)
			item=firstItem();
		else
			item=item->prevItem();
	}
	if(item)
	{
		while(item && !item->isImage())
			item=item->prevItem ();
		if(item)
		{
	 		KIconView::ensureItemVisible (item);
	 		KIconView::setCurrentItem (item);
	 		KIconView::setSelected (item, true, false);
	 		item ->setSelected (true);
			if(dscr)slotImageInfo();
		}
		else if(loop) last();
	}
	else if(loop) last();
}

void
ImageListView::contentsMousePressEvent (QMouseEvent * e)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::contentsMousePressEvent (QMouseEvent * e)" << endl;
	KIconView::contentsMousePressEvent (e);
  mouseIsPressed=true;

	if (e->button () == RightButton)
	{
		int nbS = countSelected();
		if(nbS != 0)
		{
			if(nbS == 1)
				m_popup->changeTitle(1, currentItem()->text());
			else
				m_popup->changeTitle(1, i18n("%1 selected files").arg(nbS));

			popup(currentItem(), e->globalPos ());
			m_popup->exec(e->globalPos ());
		}
		else
			m_popupEmpty->exec (e->globalPos ());
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::contentsMousePressEvent (QMouseEvent * e)" << endl;
}

void
ImageListView::contentsMouseReleaseEvent (QMouseEvent * e)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::contentsMouseReleaseEvent (QMouseEvent * e)" << endl;
	mouseIsPressed=false;
	if (e->button () == LeftButton)
	{
		int nbs=0;
		for (FileIconItem * item = firstItem (); item != 0; item = item->nextItem ())
		{
			if (item->isSelected () )
			{
				nbs++;
				if(nbs==2) break;
			}
		}
		if(nbs!=1)
		{
			KIconView::contentsMouseReleaseEvent ( e );
			return;
		}
	}
	mousePress(e);
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::contentsMouseReleaseEvent (QMouseEvent * e)" << endl;
}


void
ImageListView::mousePress (QMouseEvent * e)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::mousePress (QMouseEvent * e) " << endl;		
	FileIconItem *si = firstSelected();	
	if (e->button () == MidButton)
	{
		contentsMouseDoubleClickEvent(e);
	}
	else
	if (e->button () == LeftButton)
	{
		KIconView::contentsMouseReleaseEvent ( e );
		if(!KGlobalSettings::singleClick())
		{
			if(si)
			{
				si->setSelected (true);
				if(dscr)slotImageInfo();
			}
		}
		else
		{
			if(!si) return;
			if(si->fileInfo()->mimetype().right(9)=="directory")
			{
				curIt=NULL;
				KApplication::restoreOverrideCursor ();
				mw->openDir(QDir::cleanDirPath(si->fullName()));
			}
			else
			{
				si->setSelected (true);
			}
		}
	}
	mouseIsPressed=false;
//  kdDebug() << __FILE__ << __LINE__ << " end ImageListView::mousePress (QMouseEvent * e) " << endl;	
}

void
ImageListView::contentsMouseDoubleClickEvent ( QMouseEvent * e)
{
	if (!currentItem () || e->button () == RightButton) return;
	if( currentItem()->isImage())
	{
		mw->slotFullScreen ();
		currentItem ()->setSelected (true);
	}
	else
	if(currentItem()->fileInfo()->mimetype().right(9)=="directory")
	{
		curIt=NULL;KApplication::restoreOverrideCursor ();
		mw->openDir(QDir::cleanDirPath(((FileIconItem*)currentItem())->fullName()));
	}
	else
		KRun::runURL("file://"+currentItem()->fullName(), currentItem()->fileInfo()->mimetype());
}

void
ImageListView::sort()
{
	switch(sortMode)
	{
		case 0:slotByName(); break;
		case 1:slotByExtension(); break;
		case 2:slotBySize(); break;
		case 3:slotByDate(); break;
	}
}


void
ImageListView::slotByName()
{
	sortMode=0;
	FileIconItem *i;
	for (i=(FileIconItem*)KIconView::firstItem(); i; i = (FileIconItem*)i->nextItem() )
	{
		i->setKey("name");
	}
	KIconView::sort();
}


void
ImageListView::slotByExtension()
{
	sortMode=1;
	FileIconItem *i;
	for (i=(FileIconItem*)KIconView::firstItem(); i; i = (FileIconItem*)i->nextItem() )
	{
		i->setKey("type");
	}
	KIconView::sort();
}


void
ImageListView::slotBySize()
{
	sortMode=2;
	FileIconItem *i;
	for (i=(FileIconItem*)KIconView::firstItem(); i; i = (FileIconItem*)i->nextItem() )
	{
		i->setKey("size");
	}
	KIconView::sort();
}


void
ImageListView::slotByDate()
{
	sortMode=3;
	FileIconItem *i;
	for (i=firstItem(); i; i = i->nextItem() )
	{
		i->setKey("date");
	}
	KIconView::sort();
}


QDragObject *
ImageListView::dragObject ()
{
	if ( !currentItem() )
	return 0;
	QPoint orig = viewportToContents( viewport()->mapFromGlobal( QCursor::pos() ) );
	QtFileIconDrag *drag = new QtFileIconDrag( viewport() );
	drag->setPixmap( *currentItem()->pixmap(),
				QPoint( currentItem()->pixmapRect().width() / 2, currentItem()->pixmapRect().height() / 2 ) );
	for ( FileIconItem *item = firstItem(); item; item = item->nextItem() )
	{
		if ( item->isSelected() )
		{
			QIconDragItem id;

			id.setData(QUriDrag::localFileToUri(item->fullName()));
			drag->append( id,
				QRect( item->pixmapRect( FALSE ).x() - orig.x(),
				item->pixmapRect( FALSE ).y() - orig.y(),
				item->pixmapRect().width(), item->pixmapRect().height() ),
				QRect( item->textRect( FALSE ).x() - orig.x(),
				item->textRect( FALSE ).y() - orig.y(),
				item->textRect().width(), item->textRect().height() ),
				QUriDrag::localFileToUri(item->fullName()));
		}
	}
    return drag;
}


void
ImageListView::slotWallpaper ()
{
	FileIconItem *item = currentItem ();
	if (!item)
		return;
	currentItem ()->setWallpaper ();
}


void
ImageListView::slotFileProperty()
{
	if(!currentItem())
		return;
	KApplication::setOverrideCursor (waitCursor);
	//
	KFileItemList itemList;
	for (FileIconItem * item = firstItem (); item != 0; item = item->nextItem ())
	{
		if (item->isSelected ())
		{
			itemList.append(item->fileInfo());
		}
	}
	KPropertiesDialog *prop	= new KPropertiesDialog( itemList,
		mw->iv, "KPropertiesDialog",
		true, false);
	//
	if(itemList.count()==1)
	{
		KEXIFPropsPlugin *exifProp=NULL;
		if(showMeta() && QFileInfo(currentItem()->fullName()).extension().lower()=="jpg")
		{
			exifProp= new KEXIFPropsPlugin(prop, currentItem()->fullName());
			prop->insertPlugin(exifProp);
		}
		//
		if(currentItem()->fileInfo()->mimetype().right(9)!="directory")
		{
			QFile::Offset big = 0x500000;// 5MB
			QFile qfile( currentItem()->fullName() );
			if(showHexa() && qfile.size() < big)
			{
				KHexeditPropsPlugin *hexeditProp = new KHexeditPropsPlugin(prop, currentItem()->fullName());
				prop->insertPlugin(hexeditProp);
			}
		}
	}
	//
	KApplication::restoreOverrideCursor ();
	prop->exec();
	//
}


void
ImageListView::slotImageProperty()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO ImageListView::slotImageProperty() " << endl;
}


void
ImageListView::slotImageInfo()
{
 	if(!currentItem()) return;

	KApplication::setOverrideCursor (waitCursor);
	if(!dscr)
	{
		dscr = new Describe(mw->iv, currentItem()->fullName(), "ImageInfo", false);
		connect(dscr, SIGNAL(close()), SLOT(slotDescribeClose()));
	}
	else
		dscr->setImageFile(currentItem()->fullName());
	KApplication::restoreOverrideCursor ();
	dscr->show();
}

void
ImageListView::slotDescribeClose()
{
	delete(dscr); dscr=NULL;
}

void
ImageListView::slotKhexedit()
{
	FileIconItem *item = currentItem ();
	if (!item)
		return;

	KRun::run("khexedit",KURL::List(QStringList("file:/"+item->fullName())));
}


void
ImageListView::slotGimp ()
{
//	kdDebug() << __FILE__ << __LINE__ << " debut IImageListView::slotGimp ()" << endl;
	KURL::List list;
	for ( FileIconItem *item = firstItem(); item; item = item->nextItem() )
	{
		if ( item->isSelected() )
		list << "file:/"+item->fullName();
	}
	if (list.isEmpty()) return;
	if (KRun::run("gimp-remote -n",list)==0)
	{
		KMessageBox::error(this, "<qt>"+i18n("Error while running Gimp.<br>Please check \"gimp-remote\" on your system.")+"</qt>");
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::slotGimp ()" << endl;
}


void
ImageListView::slotEndGimp (KProcess *proc)
{
	if(proc->exitStatus()!=0)
	{
		FileIconItem* item = currentItem ();
		if (!item)
			return;
		KRun::run("gimp",KURL::List(QStringList("file:/"+item->fullName())));
	}
}



void
ImageListView::slotSupprimmer ()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin ImageListView::slotSupprimmer ()" << endl;
	KURL::List list;
	QPtrList < FileIconItem > iconList;
	FileIconItem *nextItem = 0;
	for (FileIconItem * item = firstItem (); item != 0; item = item->nextItem ())
	{
		if (item->isSelected ())
		{
			nextItem = item->nextItem ();
			if (item->text (3) == "file")
			{
				list.append(item->getURL());
			}
			else
			{
				iconList.append(item);
			}
		}
	}
	if(!list.empty())
	{
		KonqOperations::del(mw, KonqOperations::DEL, list);
	}

	for ( FileIconItem * item = iconList.first(); item; item = iconList.next() )
		item->suppression(false);


	if (nextItem)
	{
		KIconView::setCurrentItem (nextItem);
		nextItem->setSelected (true);
		ensureItemVisible (currentItem());
	}
//	kdDebug() << __FILE__ << __LINE__ << " end ImageListView::slotSupprimmer ()" << endl;
}


void
ImageListView::deletionDone( KIO::Job *job)
{
	if(job->error()!=0) job->showErrorDialog();
  refresh();
}


void
ImageListView::slotMoveToTrash()
{
	FileIconItem *nextItem = NULL;
	QPtrList < FileIconItem > iconList;
	KURL::List list;
	for (FileIconItem * item = firstItem (); item != 0; item = item->nextItem ())
	{
		if (item->isSelected ())
		{
			nextItem = item->nextItem ();
			if (item->text (3) == "file")
			{
				list.append(item->getURL());
			}
			else
			{
				iconList.append(item);
			}
		}
	}
	if(!list.empty())
	{
		KonqOperations::del(mw, KonqOperations::TRASH, list);
	}
	for ( FileIconItem * item = iconList.first(); item; item = iconList.next() )
		item->moveToTrash();

	if (nextItem)
	{
		KIconView::setCurrentItem (nextItem);
		nextItem->setSelected (true);
		ensureItemVisible (currentItem());
	}
}


void
ImageListView::slotShred()
{
	KURL::List list;
	QPtrList < FileIconItem > iconList;
	FileIconItem *nextItem = 0;
	for (FileIconItem * item = firstItem ();
	    item != 0; item =  item->nextItem ())
	{
		if (item->isSelected ())
		{
			nextItem = item->nextItem ();
			if (item->text (3) == "file")
			{
				list.append(item->getURL());
			}
			else
			{
				iconList.append(item);
			}
		}
	}
	if(!list.empty())
	{
		KonqOperations::del(mw, KonqOperations::SHRED, list);
	}
	for ( FileIconItem * item = iconList.first(); item; item = iconList.next() )
		item->shred();

	if (nextItem)
	{
		KIconView::setCurrentItem (nextItem);
		nextItem->setSelected (true);
		ensureItemVisible (currentItem());
	}
}


void ImageListView::stopLoading ()
{
	imageLoading=NULL;
	isLoadingThumbnail=false;


	il->stopLoading (true);
	mw->slotDone();

	nbrTh=0;
	arrangeItemsInGrid();
}


void ImageListView::first ()
{
	if(!hasImages())
	{
		mw->setEmptyImage();
		return;
	}
	FileIconItem *item=firstItem();
	while(item && !item->isImage())
		item=item->nextItem ();
	if(!item) {mw->setEmptyImage(); return;}
	KIconView::ensureItemVisible (item);
	KIconView::setCurrentItem (item);
	KIconView::setSelected (item, true, false);
	item ->setSelected (true);
	if(dscr)slotImageInfo();

}



void ImageListView::last ()
{
	if(!hasImages())
		return;

	FileIconItem *item=lastItem();
	while(item && !item->isImage())
		item=item->prevItem ();
	if(!item) return;
	KIconView::ensureItemVisible (item);
	KIconView::setCurrentItem (item);
	KIconView::setSelected (item, true, false);
	item ->setSelected (true);
	if(dscr)slotImageInfo();
}

FileIconItem*
ImageListView::findItem (const QString & text, bool fullname)
{
	for (FileIconItem *i=firstItem(); i; i=i->nextItem())
	{
		if(fullname)
		{
			if(i->fullName()==text)
				return i;
		}
		else
		if(i->text(0)==text)
			return i;
	}
	return NULL;
}

void ImageListView::slotOpenWith()
{
	FileIconItem *item = currentItem ();
	if (!item)
		return;
	if(mw->fullScreen())
		mw->slotFullScreen();
	KURL::List url((QStringList)item->fullName());
	KOpenWithDlg dialog(url, mw);
	if(dialog.exec()!=0)
		KRun::run(dialog.text(), KURL::List(QStringList("file:/"+item->fullName())));
}

void ImageListView::slotUnselectAll()
{
	clearSelection ();
}

void ImageListView::slotInvertSelection()
{
	KIconView::invertSelection () ;
}

void ImageListView::slotSelectAll()
{
	KIconView::selectAll(true);
}

bool
ImageListView::checkTrash()
{
	return trash;
}

void
ImageListView::setCheckTrash(bool trash)
{
	this->trash=trash;
}

bool
ImageListView::checkDelete()
{
	return del;
}

void
ImageListView::setCheckDelete(bool del)
{
	this->del=del;
}

bool
ImageListView::checkShred()
{
	return shred;
}

void
ImageListView::setCheckShred(bool shred)
{
	this->shred=shred;
}
void
ImageListView::setPreloadIm(bool prel)
{
	__preload__=prel;
}
bool
ImageListView::preloadIm()
{
	return __preload__;
}



bool
ImageListView::showMeta()
{
	return __sMeta__;
}
void
ImageListView::setShowMeta(bool sMeta)
{
	__sMeta__=sMeta;
}
bool
ImageListView::showHexa()
{
	return __sHexa__;
}
void
ImageListView::setShowHexa(bool sHexa)
{
	__sHexa__=sHexa;

}


void
ImageListView::setItemTextPos ( ItemTextPos pos )
{
	if(itemTextPos()==pos)
		return;
	if(pos==Bottom)
	{
		setGridX(gridX()-200+10);
		setWordWrapIconText (true);
}
	else
	{
		setGridX(gridX()+200-10);
		setWordWrapIconText (true);
	}
	KIconView::setItemTextPos(pos);
	arrangeItemsInGrid ();
}


void
ImageListView::slotFilesMoveTo()
{
	QStringList uris;
	for (FileIconItem* item = firstItem (); item != 0; item =  item->nextItem ())
	{
		if (item->isSelected () )
		{
			uris.append(QUriDrag::localFileToUri(item->fullName()));
		}
	}
	if(!uris.isEmpty())
	{
		QString destDir=KFileDialog::getExistingDirectory(!lastDestDir.isEmpty()?lastDestDir:mw->currentURL(), 
						mw, i18n("Move selected files to..."));
		if(!destDir.isEmpty())
		{
			lastDestDir=destDir;
			mw->moveFilesTo(uris, destDir+"/");
		}
	}
}

void
ImageListView::slotFilesCopyTo()
{
	QStringList uris;
	for (FileIconItem* item = firstItem (); item != 0; item = item->nextItem())
	{
		if (item->isSelected () )
		{
			uris.append(QUriDrag::localFileToUri(item->fullName()));
		}
	}
	if(!uris.isEmpty())
	{
		QString destDir=KFileDialog::getExistingDirectory(!lastDestDir.isEmpty()?lastDestDir:mw->currentURL(), 
					mw, i18n("Copy selected files to..."));
		if(!destDir.isEmpty())
		{
			lastDestDir=destDir;
			mw->copyFilesTo(uris, destDir+"/");
		}
	}
}

void
ImageListView::highlight(QIconViewItem *item)
{
	if (curIt) onViewport();
	if (!item || ! iconEffect->hasEffect(0,1))
	{
		if(KGlobalSettings::changeCursorOverIcon()) KApplication::restoreOverrideCursor ();
		return;
	}
  if(mouseIsPressed) return;
  if(KGlobalSettings::changeCursorOverIcon()) KApplication::setOverrideCursor (KCursor::handCursor());
	currentIconItem = new QPixmap(*(item->pixmap()));
	currentIconItemName = item->text();
	curIt=item;
	item->setPixmap(iconEffect->apply(*item->pixmap(),0,1));
	repaintItem(item);
}


void
ImageListView::onViewport()
{
	if(curIt && currentIconItemName == curIt->text())
	{
		curIt->setPixmap(*currentIconItem);
		repaintItem(curIt);
		if(KGlobalSettings::changeCursorOverIcon()) KApplication::restoreOverrideCursor ();

		curIt=NULL;
	}
}

void
ImageListView::leaveEvent(QEvent *e)
{
	KIconView::leaveEvent(e);
	onViewport();
}

FileIconItem*
ImageListView::firstItem ()
{
	return (FileIconItem *) KIconView::firstItem ();
}

FileIconItem*
ImageListView::currentItem()
{
	return (FileIconItem *)KIconView::currentItem ();
}

FileIconItem*
ImageListView::lastItem()
{
	return (FileIconItem *)KIconView::lastItem ();
}


/** functions for Digikam::AlbumItemHandler*/
QStringList
ImageListView::allItems()
{
	QStringList itemList;

	for (FileIconItem *it = firstItem(); it; it = it->nextItem())
	{
		if((it->getType() == "file" || it->getType() == "filealbum")) itemList.append(it->text());
	}

	return itemList;
}

QStringList
ImageListView::selectedItems()
{
//	kdDebug() << __FILE__ << __LINE__ << __FUNCTION__ << " begin ImageListView::selectedItems()" << endl;
	QStringList itemList;

	for (FileIconItem *it = firstItem(); it; it = it->nextItem())
	{
		if (it->isSelected() && (it->getType() == "file" || it->getType() == "filealbum") )
			itemList.append(it->text());
	}
//	kdDebug() << __FILE__ << __LINE__ << __FUNCTION__ << " end ImageListView::selectedItems()" << endl;
	return itemList;
}

QStringList
ImageListView::allItemsPath()
{
	QStringList itemList;

	for (FileIconItem *it = firstItem(); it; it = it->nextItem())
	{
		FileIconItem *item = (FileIconItem*) it;
		if((it->getType() == "file" || it->getType() == "filealbum")) itemList.append(item->fullName());
	}

	return itemList;
}

QStringList
ImageListView::selectedItemsPath()
{
	QStringList itemList;

	for (FileIconItem *it = firstItem(); it; it = it->nextItem())
	{
		if (it->isSelected())
		{
			FileIconItem *item = (FileIconItem*) it;
			if((it->getType() == "file" || it->getType() == "filealbum")) itemList.append(item->fullName());
		}
	}

	return itemList;
}

void 
ImageListView::refreshItems(const QStringList& )
{
//	kdDebug() << __FILE__ << __LINE__ << __FUNCTION__ <<" refreshItems(const QStringList& itemList) " << itemList.first() << endl;
	refresh();
}

 /* HAVE_LIBDIGIKAM */



#include "imagelistview.moc"

