/***************************************************************************
                          imagefileiconitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "imagefileiconitem.h"

#include "imageloader.h"
#include "directory.h"
#include "imageviewer.h"
#include "imagelistview.h"
#include "imagefileinfo.h"
#include "exif.h"

#include <qdragobject.h>
#include <qdropsite.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qpopupmenu.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qapplication.h>
#include <qdragobject.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qiconview.h>
#include <qpixmapcache.h>
#include <qurloperator.h>
#include <qregexp.h>

#include <kiconloader.h>
#include <kfilemetainfo.h>
#include <kapplication.h>
#include <kpixmap.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kglobalsettings.h>
#include <konq_operations.h>
#include <kio/job.h>
#include <kdebug.h>

ImageFileIconItem::ImageFileIconItem (ImageListView * parent,
				Directory * parentDir,
				QString filename,
				QString path,
				ImageViewer *iv,
				QString description):
   FileIconItem (parent, path, filename, "image", iv)
{
	this->parentDir = parentDir;
	this->description=description;

	QIconViewItem::setText(f.name());

	readable = TRUE;
	selected = false;

	full.append (path);
	full.append (filename);

	setRenameEnabled(false);

	QFileInfo info(fullName());

	size.sprintf ("%020d", info.size ());

	QDateTime epoch( QDate( 1980, 1, 1 ) );
	date.sprintf("%08d", epoch.secsTo(info.lastModified())) ;

	extension = info.extension().lower()+"Z"+fullName();

	type = "file";

	doPreload = true;
	setName("ImageFileIconItem");

	setPixmap(fileInfo()->pixmap(imageList->currentIconSize));

	__isimage__ = ((fileInfo()->mimetype().left(5)=="image") || (info.extension().lower()=="mng"));
	__ismovable__=__isimage__;
}

ImageFileIconItem::~ImageFileIconItem ()
{
}

void
ImageFileIconItem::setText( const QString & text )
{
	if(text==this->text())
		return;

	QFileInfo *itemFileInfo = new QFileInfo( fullName() );
	QDir dir( itemFileInfo->dir() );

	if(QFileInfo(itemFileInfo->dirPath(TRUE)+"/"+text).exists())
	{
		KMessageBox::error(iv, "<qt>"+i18n("The file '<b>%1</b>' already exists").arg(text)+"</qt>");
		delete itemFileInfo;
		return;
	}

	if ( dir.rename( itemFileInfo->fileName(), text ) )
	{
		QString itemFileName = itemFileInfo->dirPath( TRUE ) + "/" + text;
		full = QString("%1/%2")
				.arg(itemFileInfo->dirPath( TRUE ))
				.arg(text);

		delete itemFileInfo;
		itemFileInfo = new QFileInfo( itemFileName );

		f.setName(text);
		QIconViewItem::setText( this->text() );
	}
	else
	{
		KMessageBox::error(iv, "<qt>"+i18n("The file <b>%1</b> cannot be renamed").arg(text)+"</qt>");
	}
	delete itemFileInfo;
}

bool
ImageFileIconItem::suppression (bool suprFile)
{
	if (suprFile)
		return suppression ();
	else
	{
		parentDir->removeImage (this);
		return true;
	}
}

bool
ImageFileIconItem::suppression ()
{
	if (QDir().remove (fullName ()))
	{
		parentDir->removeImage (this);
		return true;
	}
	else
	{
		return false;
	}
}

bool
ImageFileIconItem::moveToTrash()
{
	return suppression(false);
}

bool
ImageFileIconItem::shred()
{
	suppression(false);
	return true;
}


QString
ImageFileIconItem::shrink(QString str, int len) const
{
	if(str.length()<=(unsigned int)len)
		return str;
	else
	{
		return str.left(len/2) + "..." + str.right(len/2);
	}
}

QString
ImageFileIconItem::toolTipStr() const
{
	QString tip;
	ImageFileInfo iminfo(fullName(), IMAGE, true);

	tip = "<table><tr><td>"
		+i18n("<b>name</b>: %1<br><b>location</b>: %2<br>%3 %4")
			.arg(KURL(fullName()).fileName())
			.arg(shrink(parentDir->fullName()))
			.arg((QFileInfo(fullName()).extension().lower()=="jpg"?i18n("<b>dimension</b>: ")+ProcessFile(fullName().ascii(),true):QString(" ")))
			.arg(iminfo.hasInfo()?i18n("<br><b>description</b>: <u>")+iminfo.getTitle()+"</u>":QString(" "))
		+"</td></tr></table>";

	tip+=fileInfo()->getToolTipText();
	return tip;
}

QString
ImageFileIconItem::text (int column) const
{

	if (column == 0)
		return KIconViewItem::text();
	else if (column == 1)
		return extension;
	else if (column == 2)
		return size;
	else
		return type;
}

