/***************************************************************************
                          formatconversion.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "formatconversion.h"

#include "jpgoptions.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>



/*
 *  Constructs a FormatConversion which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
FormatConversion::FormatConversion( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : KDialog( parent, name, modal, fl )
{
	if ( !name )
	    setName( "FormatConversion" );
	setCaption( i18n( "Format Conversion" ) );
	QWhatsThis::add(  this, i18n( "Frame to choose the format conversion" ) );
    FormatConversionLayout = new QVBoxLayout( this, 11, 6, "FormatConversionLayout");

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 6 );
    GroupBox1->layout()->setMargin( 11 );
    GroupBox1Layout = new QVBoxLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );

    layout8 = new QHBoxLayout( 0, 0, 6, "layout8"); 

    listViewFormat = new QListView( GroupBox1, "listViewFormat" );
    listViewFormat->addColumn( i18n( "Extension" ) );
    listViewFormat->header()->setClickEnabled( FALSE, listViewFormat->header()->count() - 1 );
    listViewFormat->header()->setResizeEnabled( FALSE, listViewFormat->header()->count() - 1 );
    listViewFormat->addColumn( i18n( "Description" ) );
    listViewFormat->header()->setClickEnabled( FALSE, listViewFormat->header()->count() - 1 );
    listViewFormat->header()->setResizeEnabled( FALSE, listViewFormat->header()->count() - 1 );
    listViewFormat->setAllColumnsShowFocus( TRUE );
    layout8->addWidget( listViewFormat );

    layout2 = new QVBoxLayout( 0, 0, 6, "layout2"); 
    QSpacerItem* spacer = new QSpacerItem( 20, 41, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout2->addItem( spacer );

    pushButtonSetting = new QPushButton( GroupBox1, "pushButtonSetting" );
    pushButtonSetting->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, 0, 0, pushButtonSetting->sizePolicy().hasHeightForWidth() ) );
    layout2->addWidget( pushButtonSetting );
    layout8->addLayout( layout2 );
    GroupBox1Layout->addLayout( layout8 );

    layout6 = new QHBoxLayout( 0, 0, 6, "layout6"); 

    CheckBox1 = new QCheckBox( GroupBox1, "CheckBox1" );
    layout6->addWidget( CheckBox1 );
    QSpacerItem* spacer_2 = new QSpacerItem( 111, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout6->addItem( spacer_2 );
    GroupBox1Layout->addLayout( layout6 );
    FormatConversionLayout->addWidget( GroupBox1 );

    layout3 = new QHBoxLayout( 0, 0, 6, "layout3"); 
    QSpacerItem* spacer_3 = new QSpacerItem( 41, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout3->addItem( spacer_3 );

    pushButtonOK = new QPushButton( this, "pushButtonOK" );
    layout3->addWidget( pushButtonOK );

    pushButtonCancel = new QPushButton( this, "pushButtonCancel" );
    layout3->addWidget( pushButtonCancel );
    FormatConversionLayout->addLayout( layout3 );

    resize( QSize(433, 326).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( pushButtonOK, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( pushButtonCancel, SIGNAL( released() ), this, SLOT( reject() ) );
    connect( listViewFormat, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( enabledDisabledSettingButton(QListViewItem*) ) );

    // tab order
    setTabOrder( listViewFormat, pushButtonSetting );
    setTabOrder( pushButtonSetting, pushButtonOK );
    setTabOrder( pushButtonOK, pushButtonCancel );

    //////////////////////////////

	QListViewItem * item = new QListViewItem( listViewFormat, 0 );
	item->setText( 0,  "BMP"  );
	item->setText( 1, ( "Microsoft Windows Bitmap image file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "GIF"  );
	item->setText( 1, ( " CompuServe Graphics Interchange format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "JPG"  );
	item->setText( 1, ( "Joint Photographic Experts Group JFIF format" ) );
	listViewFormat->setCurrentItem (item);

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PNG"  );
	item->setText( 1, ( "Portable Network Graphics" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "TGA"  );
	item->setText( 1, ( "Truevision Targa image file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "TIF"  );
	item->setText( 1, ( "Tagged Image File Format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "XPM"  );
	item->setText( 1, ( "X Windows system pixmap file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PS"  );
	item->setText( 1, ( "Adobe PostScript file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "EPS"  );
	item->setText( 1, ( "Adobe Encapsulated PostScript file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PDF"  );
	item->setText( 1, ( "Portable Document Format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PCX"  );
	item->setText( 1, ( "ZSoft IBM PC Paintbrush file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "ICO"  );
	item->setText( 1, ( "Microsoft icon" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PNM"  );
	item->setText( 1, ( "Portable anymap" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "MNG"  );
	item->setText( 1, ( "Multiple-image Network Graphics" ) );

	listViewFormat->setGeometry( QRect( 70, 20, 270, 160 ) );
	listViewFormat->setAllColumnsShowFocus( TRUE );
	QWhatsThis::add(  listViewFormat, i18n( "Choose your format here" ) );


    QWhatsThis::add( listViewFormat, i18n( "Choose your format here" ) );
    pushButtonSetting->setText( i18n( "Format &Setting ..." ) );
    QWhatsThis::add( pushButtonSetting, i18n( "Edit the setting of\n"
"the selected format" ) );
    CheckBox1->setText( i18n( "Remove/replace original" ) );
    QWhatsThis::add( CheckBox1, i18n( "Have to replace the original ?" ) );
    pushButtonOK->setText( i18n( "&OK" ) );
    pushButtonCancel->setText( i18n( "&Cancel" ) );

	////
	options=QString(" ");
	connect( listViewFormat, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( enabledDisabledSettingButton(QListViewItem*) ) );
	connect( pushButtonSetting, SIGNAL( clicked() ), this, SLOT( showJPGOption() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
FormatConversion::~FormatConversion()
{
	// no need to delete child widgets, Qt does it all for us
}
QString FormatConversion::getOptions()
{
	return options;
}

QString FormatConversion::getType()
{
	return listViewFormat->currentItem()->text(0).lower();
}

bool FormatConversion::replace()
{
	return CheckBox1->isChecked();
}

void FormatConversion::enabledDisabledSettingButton(QListViewItem* item)
{
	QString type=item->text(0);
	options="";
	if(type=="JPG")
		pushButtonSetting->setEnabled(true);
	else
		pushButtonSetting->setEnabled(false);
}
void FormatConversion::showJPGOption()
{
	JPGOptions opt (this);
	int res = opt.exec();
	switch(res)
	{
		case QDialog::Accepted : options = opt.getOptions();
		default:;
	}
}

#include "formatconversion.moc"
