/***************************************************************************
                         describe.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "describe.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfileinfo.h> 

#include <klocale.h>


/* 
 *  Constructs a Describe which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
Describe::Describe( QWidget* parent,  QString imagefile, const char* name, bool modal, WFlags fl )
    : KDialog( parent, name, modal, fl )
{
	if ( !name )
	    setName( "Describe" );
	resize( 480, 260 );
	setCaption( i18n( "Describe ")+imagefile);

	QWidget* privateLayoutWidget = new QWidget( this, "Layout4" );
	privateLayoutWidget->setGeometry( QRect( 0, 40, 490, 166 ) );
	Layout4 = new QHBoxLayout( privateLayoutWidget );
	Layout4->setSpacing( 6 );
	Layout4->setMargin( 0 );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout4->addItem( spacer );

	GroupBox2 = new QGroupBox( privateLayoutWidget, "GroupBox2" );
	GroupBox2->setTitle( i18n( "Information" ) );

	QWidget* privateLayoutWidget_2 = new QWidget( GroupBox2, "Layout5" );
	privateLayoutWidget_2->setGeometry( QRect( 10, 20, 196, 140 ) );
	Layout5 = new QHBoxLayout( privateLayoutWidget_2 );
	Layout5->setSpacing( 6 );
	Layout5->setMargin( 0 );

	Layout14 = new QVBoxLayout;
	Layout14->setSpacing( 13 );
	Layout14->setMargin( 0 );

	TextLabel2_2 = new QLabel( privateLayoutWidget_2, "TextLabel2_2" );
	TextLabel2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, TextLabel2_2->sizePolicy().hasHeightForWidth() ) );
	TextLabel2_2->setText( i18n( "Event" ) );
	TextLabel2_2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
	Layout14->addWidget( TextLabel2_2 );

	TextLabel3_2 = new QLabel( privateLayoutWidget_2, "TextLabel3_2" );
	TextLabel3_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, TextLabel3_2->sizePolicy().hasHeightForWidth() ) );
	TextLabel3_2->setText( i18n( "Location" ) );
	TextLabel3_2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
	Layout14->addWidget( TextLabel3_2 );

	TextLabel4_2 = new QLabel( privateLayoutWidget_2, "TextLabel4_2" );
	TextLabel4_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, TextLabel4_2->sizePolicy().hasHeightForWidth() ) );
	TextLabel4_2->setText( i18n( "People" ) );
	TextLabel4_2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
	Layout14->addWidget( TextLabel4_2 );

	TextLabel5_2 = new QLabel( privateLayoutWidget_2, "TextLabel5_2" );
	TextLabel5_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, TextLabel5_2->sizePolicy().hasHeightForWidth() ) );
	TextLabel5_2->setText( i18n( "Date" ) );
	TextLabel5_2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
	Layout14->addWidget( TextLabel5_2 );
	Layout5->addLayout( Layout14 );
	QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
	Layout5->addItem( spacer_2 );

	Layout16 = new QVBoxLayout;
	Layout16->setSpacing( 6 );
	Layout16->setMargin( 1 );

	event = new QLineEdit( privateLayoutWidget_2, "event" );
	QToolTip::add(  event, i18n( "The event where the image was taken" ) );
	Layout16->addWidget( event );

	location = new QLineEdit( privateLayoutWidget_2, "location" );
	QToolTip::add(  location, i18n( "The location where the image was taken" ) );
	Layout16->addWidget( location );

	people = new QLineEdit( privateLayoutWidget_2, "people" );
	QToolTip::add(  people, i18n( "The names of the people on the picture" ) );
	QWhatsThis::add(  people, i18n( "Should be a comma separated\n"
		"list without the word \"and\" to allow for easy parsing for a future\n"
		"search feature. For example:\n"
		"Colin, Mike, Steph, Jeff, Marc" ) );
	Layout16->addWidget( people );

	date = new QLineEdit( privateLayoutWidget_2, "date" );
	QToolTip::add(  date, i18n( "The date and time the picture was taken" ) );
	Layout16->addWidget( date );
	Layout5->addLayout( Layout16 );
	Layout4->addWidget( GroupBox2 );

	GroupBox6 = new QGroupBox( privateLayoutWidget, "GroupBox6" );
	GroupBox6->setTitle( i18n( "Describe" ) );

	longDescr = new QMultiLineEdit( GroupBox6, "longDescr" );
	longDescr->setGeometry( QRect( 10, 20, 200, 120 ) );
	QToolTip::add(  longDescr, i18n( "A description of the picture and any other information" ) );
	Layout4->addWidget( GroupBox6 );
	QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout4->addItem( spacer_3 );

	QWidget* privateLayoutWidget_3 = new QWidget( this, "Layout3" );
	privateLayoutWidget_3->setGeometry( QRect( 10, 10, 450, 24 ) );
	Layout3 = new QHBoxLayout( privateLayoutWidget_3 );
	Layout3->setSpacing( 6 );
	Layout3->setMargin( 0 );

	TextLabel1 = new QLabel( privateLayoutWidget_3, "TextLabel1" );
	TextLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, TextLabel1->sizePolicy().hasHeightForWidth() ) );
	TextLabel1->setText( i18n( "Title  " ) );
	Layout3->addWidget( TextLabel1 );
	QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
	Layout3->addItem( spacer_4 );

	LineEdit1 = new QLineEdit( privateLayoutWidget_3, "LineEdit1" );
	QToolTip::add(  LineEdit1, i18n( "Type a short title for the picture" ) );
	Layout3->addWidget( LineEdit1 );
	QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout3->addItem( spacer_5 );

	okButton = new QPushButton( this, "okButton" );
	okButton->setGeometry( QRect( 190, 220, 90, 30 ) );
	okButton->setText( i18n( "&Ok" ) );

	applyButton = new QPushButton( this, "applyButton" );
	applyButton->setGeometry( QRect( 290, 220, 90, 30 ) );
	applyButton->setText( i18n( "&Apply" ) );

	cancelButton = new QPushButton( this, "cancelButton" );
	cancelButton->setGeometry( QRect( 390, 220, 80, 30 ) );
	cancelButton->setText( i18n( "&Cancel" ) );



	// signals and slots connections
	connect( okButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( applyButton, SIGNAL( clicked() ), this, SLOT( apply() ) );
	connect( cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( LineEdit1, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
	connect( event, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
	connect( location, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
	connect( people, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
	connect( date, SIGNAL( returnPressed() ), this, SLOT( accept() ) );

	// tab order
	setTabOrder( LineEdit1, event );
	setTabOrder( event, location );
	setTabOrder( location, people );
	setTabOrder( people, date );
	setTabOrder( date, longDescr );
	setTabOrder( longDescr, okButton );
	setTabOrder( okButton, cancelButton );

	/////////////
	iinfo = NULL;
	setImageFile(imagefile);
	LineEdit1->setFocus();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
Describe::~Describe()
{
	// no need to delete child widgets, Qt does it all for us
}

void 
Describe::setImageFile(QString imagefile)
{
	setCaption(imagefile);	
	iinfo = new ImageFileInfo(imagefile, 0);
	LineEdit1->setText(iinfo->getTitle());
	event->setText(iinfo->getEvent());
	location->setText(iinfo->getLocation());
	people->setText(iinfo->getPeople());
	date->setText(iinfo->getDate());
	longDescr->setText(iinfo->getDescription());
}


void
Describe::accept()
{
	iinfo->write(LineEdit1->text(),event->text(),
			location->text(),people->text(),
			date->text(), longDescr->text()  );
	QDialog::accept();
	emit close();
}

void
Describe::reject()
{
	QDialog::reject();
	emit close();
}

void
Describe::apply()
{
	iinfo->write(LineEdit1->text(),event->text(),
			location->text(),people->text(),
			date->text(), longDescr->text()  );
}





#include "describe.moc"
