/***************************************************************************
                          confshowimg.cpp -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "confshowimg.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qwhatsthis.h>
#include <qbuttongroup.h>
#include <qvbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qfiledialog.h>

#include <kcolorbutton.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpixmapeffect.h>
#include <kpixmap.h>
#include <kstandarddirs.h>
#include <klistview.h>


ConfShowImg::ConfShowImg(QWidget *parent)
:KDialogBase(IconList/*Tabbed*/, i18n("Configure showimg"),
		Help|Ok|Cancel, Ok,
		parent, "Configure showimg", true)
{
	addPage1();
	addPage2();
#ifdef HAVE_LIBDIGIKAM
	addPage8();
#endif /* HAVE_LIBDIGIKAM */
	addPage7();
	addPage6();
	addPage3();
	addPage4();
	addPage5();

	setHelp("configure.anchor", "showimg");
	adjustSize();
}

ConfShowImg::~ConfShowImg()
{
}


void
ConfShowImg::initFiling(int openType, QString openDir, bool showSP)
{
	if(openType==0) openHome->setChecked( TRUE );
	else if(openType==1) openLast->setChecked( TRUE );
	else open_custom->setChecked( TRUE );
	LineEdit2->setText(openDir);
	this->showSP->setChecked(showSP);

}


int
ConfShowImg::getOpenDirType()
{
	if(openHome->isChecked()) return 0;
	else if(openLast->isChecked()) return 1;
	else return 2;
}
QString
ConfShowImg::getOpenDir()
{
	return LineEdit2->text();
}
bool
ConfShowImg::checkshowSP()
{
	return showSP->isChecked();
}



void
ConfShowImg::addPage1()
{
	page1 = addPage( i18n("Filing"),
			 i18n("Filing"),
	    		 BarIcon("fileopen", 32));


    page1Layout = new QVBoxLayout( page1, 11, 6, "page1Layout");


    GroupBox13 = new QButtonGroup( page1, "GroupBox13" );
    GroupBox13->setColumnLayout(0, Qt::Vertical );
    GroupBox13->layout()->setSpacing( 6 );
    GroupBox13->layout()->setMargin( 11 );
    GroupBox13Layout = new QVBoxLayout( GroupBox13->layout() );
    GroupBox13Layout->setAlignment( Qt::AlignTop );

    openHome = new QRadioButton( GroupBox13, "openHome" );
    openHome->setChecked( TRUE );
    GroupBox13Layout->addWidget( openHome );

    openLast = new QRadioButton( GroupBox13, "openLast" );
    GroupBox13Layout->addWidget( openLast );

    open_custom = new QRadioButton( GroupBox13, "open_custom" );
    GroupBox13Layout->addWidget( open_custom );

    layout1_2 = new QHBoxLayout( 0, 0, 6, "layout1_2");

    LineEdit2 = new QLineEdit( GroupBox13, "LineEdit2" );
    LineEdit2->setEnabled( FALSE );
    LineEdit2->setEdited( FALSE );
    layout1_2->addWidget( LineEdit2 );

    chooseButton = new QPushButton( GroupBox13, "chooseButton" );
    chooseButton->setMaximumSize( QSize( 30, 30 ) );
    layout1_2->addWidget( chooseButton );
    GroupBox13Layout->addLayout( layout1_2 );

    showSP = new QCheckBox( GroupBox13, "showSP" );
    showSP->setChecked( TRUE );
    GroupBox13Layout->addWidget( showSP );
    page1Layout->addWidget( GroupBox13 );
    QSpacerItem* spacer = new QSpacerItem( 20, 125, QSizePolicy::Minimum, QSizePolicy::Expanding );
    page1Layout->addItem( spacer );


//////////////
//////////////
//////////////

    GroupBox13->setTitle( i18n( "On starting open:" ) );
    openHome->setText( i18n( "&home directory" ) );
    openLast->setText( i18n( "&last directory" ) );
    open_custom->setText( i18n( "&specified directory :" ) );
    //chooseButton->setText( i18n( "PushButton1" ) );
    showSP->setText( i18n( "Show splash screen" ) );

    chooseButton->setPixmap( QPixmap(BarIcon("folder_open",16 )));
    chooseButton->setDisabled(true);

	    // signals and slots connections
	connect( open_custom, SIGNAL( toggled(bool) ), LineEdit2, SLOT( setEnabled(bool) ) );
	connect( open_custom, SIGNAL( toggled(bool) ), chooseButton, SLOT( setEnabled(bool) ) );
	connect( chooseButton, SIGNAL( clicked()), this, SLOT( chooseDir() ));

}
void
ConfShowImg::chooseDir()
{
 	 QString s (QFileDialog::getExistingDirectory ( LineEdit2->text(), this ));
 	 if(!s.isEmpty())
 		LineEdit2->setText( s );
}


void
ConfShowImg::initMiscellaneous(bool storeth,  bool showf, bool useexif,
                               bool smooth, bool loadfim,
                               bool sHDir, bool sHFile, bool sDir, bool sAll,
                               bool sprelodim)
{
	storethCheck->setChecked(storeth);
	showFrame->setChecked(showf);
	useEXIF->setChecked(useexif);
	smoothCheck->setChecked(smooth);
	sHiddenDirCheck ->setChecked(sHDir);
	sHiddenFileCheck ->setChecked(sHFile);
	sDirCheck ->setChecked(sDir);
	sAllCheck ->setChecked(sAll);
	prelodimCheck ->setChecked(sprelodim);
	loadfirstimCheck->setChecked(loadfim);
}

bool
ConfShowImg::getStoreth()
{
	return storethCheck->isChecked();
}
bool
ConfShowImg::getShowFrame()
{
	return showFrame->isChecked();
}
bool
ConfShowImg::getUseEXIF()
{
	return useEXIF->isChecked();
}
bool
ConfShowImg::getSmooth()
{
	return smoothCheck->isChecked();
}
bool
ConfShowImg::getShowHiddenDir()
{
	return sHiddenDirCheck->isChecked();
}
bool
ConfShowImg::getShowHiddenFile()
{
	return sHiddenFileCheck->isChecked();
}
bool
ConfShowImg::getShowDir()
{
	return sDirCheck->isChecked();
}
bool
ConfShowImg::getShowAll()
{
	return sAllCheck->isChecked();
}
bool
ConfShowImg::getPreloadIm()
{
	return prelodimCheck->isChecked();
}
bool
ConfShowImg::getLoadFirstImage()
{
	return loadfirstimCheck->isChecked();
}

void
ConfShowImg::addPage2()
{
	page2 = addPage( i18n("Miscellaneous"),
			 i18n("Miscellaneous"),
	    		 BarIcon("misc", 32));

    page2Layout = new QVBoxLayout( page2, 11, 6, "page2Layout");

    groupboxThumbnails = new QGroupBox( page2, "groupboxThumbnails" );
    groupboxThumbnails->setColumnLayout(0, Qt::Vertical );
    groupboxThumbnails->layout()->setSpacing( 6 );
    groupboxThumbnails->layout()->setMargin( 11 );
    groupboxThumbnailsLayout = new QGridLayout( groupboxThumbnails->layout() );
    groupboxThumbnailsLayout->setAlignment( Qt::AlignTop );

    storethCheck = new QCheckBox( groupboxThumbnails, "storethCheck" );
    storethCheck->setEnabled( FALSE );

    groupboxThumbnailsLayout->addWidget( storethCheck, 0, 0 );

    showFrame = new QCheckBox( groupboxThumbnails, "showFrame" );

    groupboxThumbnailsLayout->addWidget( showFrame, 1, 0 );

    useEXIF = new QCheckBox( groupboxThumbnails, "useEXIF" );

    groupboxThumbnailsLayout->addWidget( useEXIF, 0, 1 );
    page2Layout->addWidget( groupboxThumbnails );

    layout6 = new QHBoxLayout( 0, 0, 6, "layout6");

    groupBox3 = new QGroupBox( page2, "groupBox3" );
    groupBox3->setColumnLayout(0, Qt::Vertical );
    groupBox3->layout()->setSpacing( 6 );
    groupBox3->layout()->setMargin( 11 );
    groupBox3Layout = new QGridLayout( groupBox3->layout() );
    groupBox3Layout->setAlignment( Qt::AlignTop );

    smoothCheck = new QCheckBox( groupBox3, "smoothCheck" );

    groupBox3Layout->addWidget( smoothCheck, 0, 0 );
    layout6->addWidget( groupBox3 );

    groupBox4 = new QGroupBox( page2, "groupBox4" );
    groupBox4->setColumnLayout(0, Qt::Vertical );
    groupBox4->layout()->setSpacing( 6 );
    groupBox4->layout()->setMargin( 11 );
    groupBox4Layout = new QVBoxLayout( groupBox4->layout() );
    groupBox4Layout->setAlignment( Qt::AlignTop );

    prelodimCheck = new QCheckBox( groupBox4, "prelodimCheck" );
    groupBox4Layout->addWidget( prelodimCheck );

    loadfirstimCheck = new QCheckBox( groupBox4, "loadfirstimCheck" );
    groupBox4Layout->addWidget( loadfirstimCheck );
    layout6->addWidget( groupBox4 );
    page2Layout->addLayout( layout6 );

    groupBox5 = new QGroupBox( page2, "groupBox5" );
    groupBox5->setColumnLayout(0, Qt::Vertical );
    groupBox5->layout()->setSpacing( 6 );
    groupBox5->layout()->setMargin( 11 );
    groupBox5Layout = new QGridLayout( groupBox5->layout() );
    groupBox5Layout->setAlignment( Qt::AlignTop );

    sHiddenDirCheck = new QCheckBox( groupBox5, "sHiddenDirCheck" );

    groupBox5Layout->addWidget( sHiddenDirCheck, 0, 0 );

    sHiddenFileCheck = new QCheckBox( groupBox5, "sHiddenFileCheck" );

    groupBox5Layout->addWidget( sHiddenFileCheck, 1, 0 );

    sAllCheck = new QCheckBox( groupBox5, "sAllCheck" );

    groupBox5Layout->addWidget( sAllCheck, 0, 1 );

    sDirCheck = new QCheckBox( groupBox5, "sDirCheck" );

    groupBox5Layout->addWidget( sDirCheck, 1, 1 );
    page2Layout->addWidget( groupBox5 );


    ///////
    groupboxThumbnails->setTitle( i18n( "Thumbnails" ) );
    storethCheck->setText( i18n( "Store &thumbnails" ) );
    showFrame->setText( i18n( "Show &frame" ) );
    useEXIF->setText( i18n( "Use EXIF &header" ) );
    QToolTip::add( useEXIF, i18n( "Load quick preview for images containing EXIF header, but not take into account modifications on the image" ) );
    groupBox3->setTitle( i18n( "Zoom mode" ) );
    smoothCheck->setText( i18n( "Smooth &scale" ) );
    QToolTip::add( smoothCheck, i18n( "Better quality but slower and requires more memory" ) );
    groupBox4->setTitle( i18n( "Preloading" ) );
    prelodimCheck->setText( i18n( "Preload next image" ) );
    loadfirstimCheck->setText( i18n( "Load the first image" ) );
    QToolTip::add( loadfirstimCheck, i18n( "Load the first image of the selected directory" ) );
    groupBox5->setTitle( i18n( "Files and directories" ) );
    sHiddenDirCheck->setText( i18n( "Show hidden &directories" ) );
    sHiddenFileCheck->setText( i18n( "Show hidden &files" ) );
    sAllCheck->setText( i18n( "Show all &files" ) );
    sDirCheck->setText( i18n( "Show &directories" ) );

}

void
ConfShowImg::initColor(QColor bgcolor, int gray)
{
	color->setColor(bgcolor);
	gray = (gray<50?50:gray);
	graySlider->setValue((int)(gray));
	setGrayscale(gray);
}

QColor
ConfShowImg::getColor()
{
	return color->color();
}

int
ConfShowImg::getGrayscale()
{
	return graySlider->value();
}

void
ConfShowImg::addPage3()
{
	page3 = addPage( i18n("Colors"),
			 i18n("Colors"),
	    		 BarIcon("colorize", 32));

	ButtonGroup2 = new QButtonGroup(page3 , "ButtonGroup2" );
	ButtonGroup2->setGeometry( QRect( 10, 10, 270, 110 ) );
	ButtonGroup2->setTitle( i18n( "Background" ) );

	RadioButton5 = new QRadioButton( ButtonGroup2, "RadioButton5" );
	RadioButton5->setEnabled( FALSE );
	RadioButton5->setGeometry( QRect( 130, 30, 130, 20 ) );
	RadioButton5->setText( i18n( "Tiled Image:" ) );

	PushButton1 = new QPushButton( ButtonGroup2, "PushButton1" );
	PushButton1->setEnabled( FALSE );
	PushButton1->setGeometry( QRect( 140, 60, 90, 30 ) );
	PushButton1->setText( i18n( "Choose..." ) );

	RadioButton4 = new QRadioButton( ButtonGroup2, "RadioButton4" );
	RadioButton4->setGeometry( QRect( 20, 30, 110, 20 ) );
	RadioButton4->setText( i18n( "Color:" ) );
	RadioButton4->setChecked( TRUE );

	color = new KColorButton( ButtonGroup2, "color" );
	color->setGeometry( QRect( 40, 60, 60, 30 ) );
	color->setFlat( TRUE );

	GroupBox6 = new QGroupBox( page3, "GroupBox6" );
	GroupBox6->setGeometry( QRect( 10, 130, 310, 100 ) );
	GroupBox6->setTitle( i18n( "Grayscale" ) );

	graySlider = new QSlider( GroupBox6, "graySlider" );
	graySlider->setGeometry( QRect( 20, 50, 150, 20 ) );
	graySlider->setMinValue( 30 );
	graySlider->setMaxValue( 100 );
	graySlider->setLineStep( 10 );
	graySlider->setValue( 10 );
	graySlider->setTracking( FALSE );
	graySlider->setOrientation( QSlider::Horizontal );
	graySlider->setTickmarks( QSlider::Both );

	PixmapLabel1 = new QLabel( GroupBox6, "PixmapLabel1" );
	PixmapLabel1->setGeometry( QRect( 210, 20, 80, 70 ) );
	image0 = new QPixmap(locate("appdata", "pics/gradient.png"));
	PixmapLabel1->setPixmap( *image0 );
	PixmapLabel1->setScaledContents( TRUE );

	// signals and slots connections
	connect( RadioButton4, SIGNAL( toggled(bool) ), color, SLOT( setEnabled(bool) ) );
	connect( RadioButton5, SIGNAL( toggled(bool) ), PushButton1, SLOT( setEnabled(bool) ) );
	connect( graySlider, SIGNAL( sliderMoved(int) ), this, SLOT( setGrayscale(int) ) );

	// tab order
	setTabOrder( RadioButton4, color );
	setTabOrder( color, PushButton1 );
}

void
ConfShowImg::initSlideshow(int type, int time)
{
	if(type==0)
		forward->setChecked( TRUE );
	else
	if(type==1)
		backward->setChecked( TRUE );
	else
	if(type==2)
		random->setChecked( TRUE );

	timeSlide->setValue(time);
}

int
ConfShowImg::getSlideshowType()
{
	if(forward->isChecked())
		return 0;
	else
	if(backward->isChecked())
		return 1;
	else
		return 2;
}

int
ConfShowImg::getSlideshowTime()
{
	return timeSlide->value();
}

void
ConfShowImg::addPage4()
{
	page4 = addPage( i18n("Slide show"),
			 i18n("Slide show"),
	    		 BarIcon("run", 32));

	GroupBox2 = new QGroupBox(page4 , "GroupBox2" );
	GroupBox2->setGeometry( QRect( 210, 20, 200, 151 ) );
	GroupBox2->setTitle( i18n( "Timed slide show" ) );

	timeSlide = new QSlider( GroupBox2, "timeSlide" );
	timeSlide->setGeometry( QRect( 11, 40, 180, 21 ) );
	timeSlide->setOrientation( QSlider::Horizontal );
	timeSlide->setMinValue( 1 );
	timeSlide->setMaxValue( 600 );

	timeLabel = new QLabel( GroupBox2, "timeLabel" );
	timeLabel->setGeometry( QRect( 10, 90, 180, 31 ) );
	timeLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignCenter ) );

	ButtonGroup3 = new QButtonGroup(page4 , "ButtonGroup3" );
	ButtonGroup3->setGeometry( QRect( 10, 10, 191, 161 ) );
	ButtonGroup3->setTitle( i18n( "Sequence" ) );

	wraparound = new QCheckBox( ButtonGroup3, "wraparound" );
	wraparound->setGeometry( QRect( 20, 130, 151, 21 ) );
	wraparound->setText( i18n( "Wrap around" ) );

	Line1 = new QFrame( ButtonGroup3, "Line1" );
	Line1->setGeometry( QRect( 21, 110, 160, 20 ) );
	Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

	backward = new QRadioButton( ButtonGroup3, "backward" );
	backward->setGeometry( QRect( 20, 60, 160, 21 ) );
	backward->setText( i18n( "&Backward" ) );
	ButtonGroup3->insert( backward, 1 );

	random = new QRadioButton( ButtonGroup3, "random" );
	random->setGeometry( QRect( 20, 90, 160, 21 ) );
	random->setText( i18n( "&Random" ) );
	ButtonGroup3->insert( random, 2 );

	forward = new QRadioButton( ButtonGroup3, "forward" );
	forward->setGeometry( QRect( 20, 30, 160, 21 ) );
	forward->setText( i18n( "&Forward" ) );
	forward->setChecked( TRUE );
	ButtonGroup3->insert( forward, 0 );

	// signals and slots connections
	connect( timeSlide, SIGNAL( valueChanged(int) ), this, SLOT( slotChangeTime(int) ) );

	// tab order
	setTabOrder( forward, wraparound );
	setTabOrder( wraparound, timeSlide );
	setTabOrder( timeSlide, backward );
}


void
ConfShowImg::slotChangeTime(int)
{
	 int t = timeSlide->value();
	 QString temps = QString("%1 %2")
	 			.arg(t)
				.arg(t==1?i18n("second"):i18n("seconds"));
	timeLabel->setText(temps);
}

int
ConfShowImg::getLayout()
{
	if(radioButton_1->isChecked())
		return 1;
	else
	if(radioButton_2->isChecked())
		return 2;
	else
	if(radioButton_3->isChecked())
		return 3;
	else
	if(radioButton_4->isChecked())
		return 4;
	else
		return 5;
}

void
ConfShowImg::setLayout(int l)
{
	if(l==1)
		radioButton_1->setChecked(true);
	else
	if(l==2)
		radioButton_2->setChecked(true);
	else
	if(l==3)
		radioButton_3->setChecked(true);
	else
	if(l==4)
		radioButton_4->setChecked(true);
	else
		radioButton_5->setChecked(true);
}

void
ConfShowImg::addPage5()
{
	page5 = addPage( i18n("Layout"),
			 i18n("Layout"),
			 BarIcon("view_choose", 32));

	QPixmap image0(locate("appdata", "pics/layout1.png"));
	QPixmap image1(locate("appdata", "pics/layout2.png"));
	QPixmap image2(locate("appdata", "pics/layout3.png"));
	QPixmap image3(locate("appdata", "pics/layout4.png"));

	QButtonGroup *ButtonGroup2 = new QButtonGroup( page5, "ButtonGroup2" );
	ButtonGroup2->setGeometry( QRect( 10, 10, 230, 220 ) );
	ButtonGroup2->setTitle( i18n( "Layout" ) );

	radioButton_1 = new QRadioButton( ButtonGroup2, "radioButton_1" );
	radioButton_1->setGeometry( QRect( 10, 20, 100, 80 ) );
	radioButton_1->setPixmap( image0 );

	radioButton_2 = new QRadioButton( ButtonGroup2, "radioButton_2" );
	radioButton_2->setGeometry( QRect( 110, 20, 100, 80 ) );
	radioButton_2->setPixmap( image1 );

	radioButton_3 = new QRadioButton( ButtonGroup2, "radioButton_3" );
	radioButton_3->setGeometry( QRect( 10, 100, 100, 80 ) );
	radioButton_3->setPixmap( image2 );

	radioButton_4 = new QRadioButton( ButtonGroup2, "radioButton_4" );
	radioButton_4->setGeometry( QRect( 110, 100, 100, 80 ) );
	radioButton_4->setPixmap( image3 );

	radioButton_5 = new QRadioButton( ButtonGroup2, "radioButton_5" );
	radioButton_5->setGeometry( QRect( 110, 190, 100, 20 ) );
	radioButton_5->setText( i18n("&current"));
	radioButton_5->setChecked( TRUE );
}



void
ConfShowImg::setGrayscale(int val)
{
	KPixmap pix(*image0);
	float taux=((float)val)/100;
	PixmapLabel1->setPixmap(KPixmapEffect::desaturate( pix, taux));
}

void
ConfShowImg::initFullscreen(bool showToolbar, bool showStatusbar)
{
	sToolbar->setChecked( showToolbar );
	sStatusbar->setChecked( showStatusbar );
}

bool
ConfShowImg::getShowToolbar()
{
	return sToolbar->isChecked();
}
bool
ConfShowImg::getShowStatusbar()
{
	return sStatusbar->isChecked();
}

void
ConfShowImg::addPage6()
{
	page6 = addPage( i18n("Full Screen"),
			 i18n("Full Screen"),
			 BarIcon("window_fullscreen", 32));
	fsButtonGroup=new QButtonGroup( page6, "fsButtonGroup" );
	fsButtonGroup->setGeometry( QRect(10, 10, 220, 100 ) );
	fsButtonGroup->setTitle( i18n( "Full Screen" ) );

	sStatusbar=new QCheckBox(fsButtonGroup , "sStatusbar" );
	sStatusbar->setGeometry( QRect(10, 15, 200, 30 ) );
	sStatusbar->setText( i18n( "Show &status bar" ) );

	sToolbar=new QCheckBox(fsButtonGroup , "sStatusbar" );
	sToolbar->setGeometry( QRect(10, 50, 200, 30 ) );
	sToolbar->setText( i18n( "Show &toolbar" ) );
}


void
ConfShowImg::initProperties(bool sMeta, bool sHexa)
{
	showMeta->setChecked(sMeta);
	showHexa->setChecked(sHexa);
}


bool
ConfShowImg::getShowMeta()
{
	return showMeta->isChecked();
}
bool
ConfShowImg::getShowHexa()
{
	return showHexa->isChecked();
}


void
ConfShowImg::addPage7()
{
	page7 = addPage( i18n("Properties"),
			 i18n("Properties"),
			 BarIcon("properties", 32));


    page7Layout = new QHBoxLayout( page7, 11, 6, "page7Layout");

    layoutTab = new QVBoxLayout( 0, 0, 6, "layoutTab");

    groupBoxTab = new QGroupBox( page7, "groupBoxTab" );
    groupBoxTab->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 0, 0, groupBoxTab->sizePolicy().hasHeightForWidth() ) );
    groupBoxTab->setColumnLayout(0, Qt::Vertical );
    groupBoxTab->layout()->setSpacing( 6 );
    groupBoxTab->layout()->setMargin( 11 );
    groupBoxTabLayout = new QGridLayout( groupBoxTab->layout() );
    groupBoxTabLayout->setAlignment( Qt::AlignTop );

    layoutCheckBoxTab = new QVBoxLayout( 0, 0, 6, "layoutCheckBoxTab");

    showMeta = new QCheckBox( groupBoxTab, "showMeta" );
    layoutCheckBoxTab->addWidget( showMeta );

    showHexa = new QCheckBox( groupBoxTab, "showHexa" );
    layoutCheckBoxTab->addWidget( showHexa );

    groupBoxTabLayout->addLayout( layoutCheckBoxTab, 0, 0 );
    layoutTab->addWidget( groupBoxTab );
    QSpacerItem* spacer = new QSpacerItem( 20, 51, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layoutTab->addItem( spacer );
    page7Layout->addLayout( layoutTab );

    groupBoxTab->setTitle( i18n( "Show/hide tabs" ) );
    showMeta->setText( i18n( "Show &meta-data tab" ) );
    showHexa->setText( i18n( "Show &hexadecimal tab" ) );

}

void
ConfShowImg::initPlugins(QStringList lista, QStringList listl)
{
    QStringList::Iterator it = lista.begin();
    while(  it != lista.end() )
    {
	QCheckListItem *item = new QCheckListItem (pluginList, *it, QCheckListItem::CheckBox);
	item->setText(0, *it);
	if(listl.contains(*it)) item->setOn(true);
	it++;
	item->setText(1, *it);
	it++;
    }
}

QStringList
ConfShowImg::getPluginList()
{
        QStringList list;
        QCheckListItem * item = (QCheckListItem*)pluginList->firstChild();
        while( item )
	{
	    if(item->isOn () )
	    	list.append(item->text(0));
            item = (QCheckListItem*)item->nextSibling();
        }
	return list;
}

void
ConfShowImg::addPage8()
{
	page8 = addPage( i18n("Plugins"),
			 i18n("Plugins"),
			 BarIcon("digikam", 32));

    Form1Layoutp8 = new QVBoxLayout( page8, 11, 6, "Form1Layout");

    pluginList = new KListView( page8, "pluginList" );
    pluginList->setAllColumnsShowFocus( TRUE );
    pluginList->setResizeMode( KListView::LastColumn );
    pluginList->setFullWidth( TRUE );
    Form1Layoutp8->addWidget( pluginList );

    resize( QSize(404, 276).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    pluginList->addColumn( i18n( "Name" ) );
    pluginList->addColumn( i18n( "Description" ) );
}


#include "confshowimg.moc"
