/****************************************************************************
 * Driver for Solarflare network controllers
 *           (including support for SFE4001 10GBT NIC)
 *
 * Copyright 2005-2006: Fen Systems Ltd.
 * Copyright 2006-2008: Solarflare Communications Inc,
 *                      9501 Jeronimo Road, Suite 250,
 *                      Irvine, CA 92618, USA
 *
 * Initially developed by Michael Brown <mbrown@fensystems.co.uk>
 * Maintained by Solarflare Communications <linux-net-drivers@solarflare.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 ****************************************************************************
 */

#ifndef EFX_IOCTL_H
#define EFX_IOCTL_H

#if defined(__KERNEL__)
#include <linux/if.h>
#else
#include <net/if.h>
#endif
#include <linux/sockios.h>
#include <linux/types.h>
#include "enum.h"

/*
 * Efx private ioctls
 */

/* Efx private ioctl number */
#define SIOCEFX SIOCDEVPRIVATE

/* Testing/QA: perform full reset while running *****************************/
#define EFX_RESET 0xef01

/* Parameters for EFX_RESET */
struct efx_reset_ioctl {
	enum reset_type method;
} __attribute__ ((packed));

/* Testing/QA: re-acknowledge specified event queue *************************/
#define EFX_EVQ_ACK 0xef02

/* Parameters for EFX_EVQ_ACK */
struct efx_evq_ack_ioctl {
	/** Channel number */
	__u16 channel;
} __attribute__ ((packed));

/* Testing/QA: set loopback mode ********************************************/
#define EFX_SET_LOOPBACK 0xef03

/* Parameters for EFX_SET_LOOPBACK */
struct efx_set_loopback_ioctl {
	/** Loopback mode */
	enum efx_loopback_mode mode;
} __attribute__ ((packed));


/* Deprecated ***************************************************************/
#define EFX_RESET_MODE 0xef04


/* Testing/QA: debug MDIO access ********************************************/
#define EFX_MDIO 0xef05

/* Parameters for EFX_MDIO */
struct efx_mdio_ioctl {
	/** MDIO access */
	__u16 read;
	__u16 clause45;
	__u32 value;
	__u16 addr;
	__u8 dev;
	int prt;
} __attribute__ ((packed));

/* Testing/QA: debug I2C access *********************************************/
#define EFX_I2C 0xef06

#define EFX_I2C_READ (0x01)
#define EFX_I2C_WRITE (0x02)

struct efx_i2c_ioctl {
	/** I2C access */
	__u16 op;
	__u16 offset;
	__u16 size;
	__u8 nic_id;
	__u8 id;
	__u8 buf[1 << 8];
} __attribute__ ((packed));


/* Testing/QA: SMBus access to PCIe PHY on B0 FPGA board ********************/
#define EFX_GL7914 0xef07


/* For testing the swapping between 10G and 1G MAC **************************/
#define EFX_SWAP_MAC 0xef08

struct efx_swap_mac_ioctl {
	__u8 is10g;
} __attribute__ ((packed));


/* For setting the netif carrier on/off *************************************/
#define EFX_SET_CARRIER 0xef09

struct efx_set_carrier_ioctl {
	__u8 on;
} __attribute__ ((packed));


/* For resetting the XAUI link between Falcon and the PHY *******************/
#define EFX_RESET_XAUI 0xef0a

/* For setting the PHY power state ******************************************/
#define EFX_SET_PHY_POWER 0xef0b

struct efx_set_phy_power {
	__u8 on;
} __attribute__ ((packed));

/* Efx private ioctl command structure **************************************/
struct efx_ioctl {
	char if_name[IFNAMSIZ];
	/** Command to run */
	__u16 cmd;
	/** Parameters */
	union {
		struct efx_reset_ioctl reset;
		struct efx_reset_ioctl reset_mode;
		struct efx_evq_ack_ioctl evq_ack;
		struct efx_set_loopback_ioctl set_loopback;
		struct efx_mdio_ioctl mdio;
		struct efx_i2c_ioctl i2c;
		struct efx_swap_mac_ioctl swapmac;
		struct efx_set_carrier_ioctl set_carrier;
		struct efx_set_phy_power set_phy_power;
	} u;
} __attribute__ ((packed));


/******************************************************************************/
extern int ioctl_init(void);
extern void ioctl_fini(void);

#endif /* EFX_IOCTL_H */
