// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_SEQUENCE_JOURNALED_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEQUENCE_JOURNALED_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_node.h"(79)

//____________________________________________________________________________
// InsertionBuffer

template <typename T> struct InsertionBuffer;       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(128)

//____________________________________________________________________________
// JournalEntries

template <typename TNode, typename TTreeSpec> class JournalEntries;       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(51)
template <typename TNode, typename TTreeSpec> class JournalEntries;       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(61)

//____________________________________________________________________________
// JournalEntriesIterSpec

template <typename TJournalEntriesSpec> struct JournalEntriesIterSpec;       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(47)
template <typename TJournalEntriesSpec> struct JournalEntriesIterSpec;       	// "projects/library/seqan/sequence_journaled/sequence_journaled_forwards.h"(47)

//____________________________________________________________________________
// JournalEntriesUnorderedTreeNode

template <typename TCargo> struct JournalEntriesUnorderedTreeNode;       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_node.h"(53)

//____________________________________________________________________________
// JournalEntry

template <typename TPos_, typename TSize_> struct JournalEntry;       	// "projects/library/seqan/sequence_journaled/journal_entry.h"(55)

//____________________________________________________________________________
// JournalEntryLtByVirtualPos

template <typename TPos, typename TSize> struct JournalEntryLtByVirtualPos;       	// "projects/library/seqan/sequence_journaled/journal_entry.h"(94)

//____________________________________________________________________________
// JournalType

template <typename T> struct JournalType;       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(211)

//____________________________________________________________________________
// Journaled

template <typename THostSpec, typename TJournalSpec , typename TBufferSpec > struct Journaled;       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(59)

//____________________________________________________________________________
// JournaledStringIterSpec

template <typename TJournaledStringSpec> struct JournaledStringIterSpec;       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(47)

//____________________________________________________________________________
// SortedArray

struct SortedArray;       	// "projects/library/seqan/sequence_journaled/sequence_journaled_forwards.h"(44)
struct SortedArray;       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(47)

//____________________________________________________________________________
// UnbalancedTree

struct UnbalancedTree;       	// "projects/library/seqan/sequence_journaled/sequence_journaled_forwards.h"(42)
struct UnbalancedTree;       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(57)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _addToVirtualPositionsRightOf

template <typename TNode> inline void _addToVirtualPositionsRightOf(TNode * node, typename Position<TNode>::Type const & pos, typename Position<TNode>::Type const & delta);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(288)

//____________________________________________________________________________
// _checkSortedArrayTree

template <typename TCargo> bool _checkSortedArrayTree(JournalEntries<TCargo, SortedArray> const & tree);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(116)

//____________________________________________________________________________
// _copyJournalEntriesNodes

template <typename TNode, typename TAllocator> void _copyJournalEntriesNodes(TNode * & target, TAllocator & allocator, TNode * const & source);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(120)

//____________________________________________________________________________
// _initJournalEntriesIterator

template <typename TJournalEntries> inline void _initJournalEntriesIterator(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator, TJournalEntries & tree);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(193)

//____________________________________________________________________________
// _initJournalEntriesIteratorEnd

template <typename TJournalEntries> inline void _initJournalEntriesIteratorEnd(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator, TJournalEntries & tree);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(211)

//____________________________________________________________________________
// _initJournaledStringIterator

template <typename TJournaledString, typename TJournalSpec> inline void _initJournaledStringIterator(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator, TJournaledString & journalString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(211)

//____________________________________________________________________________
// _initJournaledStringIteratorEnd

template <typename TJournaledString, typename TJournalSpec> inline void _initJournaledStringIteratorEnd(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator, TJournaledString & journalString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(224)

//____________________________________________________________________________
// _subtractFromVirtualPositionsRightOf

template <typename TNode> inline void _subtractFromVirtualPositionsRightOf(TNode * node, typename Position<TNode>::Type const & pos, typename Position<TNode>::Type const & delta);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(264)

//____________________________________________________________________________
// _updateSegmentIterators

template <typename TJournaledString, typename TJournalSpec> inline void _updateSegmentIterators(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(234)

//____________________________________________________________________________
// assignInfix

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos, typename TSequence2> inline void assignInfix(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & beginPos, TPos const & endPos, TSequence2 const & valueString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(379)

//____________________________________________________________________________
// assignValue

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos, typename TValue2> inline void assignValue(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & pos, TValue2 const & value);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(391)

//____________________________________________________________________________
// atEnd

template <typename TJournalEntries> inline bool atEnd(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(347)
template <typename TJournalEntries> inline bool atEnd(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(356)

//____________________________________________________________________________
// begin

template <typename TNode> inline typename Iterator<JournalEntries<TNode, UnbalancedTree> const, Standard>::Type begin(JournalEntries<TNode, UnbalancedTree> const & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(146)
template <typename TNode> inline typename Iterator<JournalEntries<TNode, UnbalancedTree>, Standard>::Type begin(JournalEntries<TNode, UnbalancedTree> & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(155)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Iterator<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const, Standard>::Type begin(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journalString, Standard const &);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(164)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Iterator<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> >, Standard>::Type begin(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journalString, Standard const &);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(174)
template <typename TCargo> typename Iterator<JournalEntries<TCargo, SortedArray>, Standard>::Type begin(JournalEntries<TCargo, SortedArray> & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(139)
template <typename TCargo> typename Iterator<JournalEntries<TCargo, SortedArray> const, Standard>::Type begin(JournalEntries<TCargo, SortedArray> const & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(148)

//____________________________________________________________________________
// cargo

template <typename TCargo> typename Cargo<JournalEntriesUnorderedTreeNode<TCargo> >::Type & cargo(JournalEntriesUnorderedTreeNode<TCargo> & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_node.h"(119)

//____________________________________________________________________________
// checkOrder

template <typename TNode> inline bool checkOrder(TNode * const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(183)

//____________________________________________________________________________
// checkOrderRec

template <typename TNode> inline bool checkOrderRec(TNode * const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(166)

//____________________________________________________________________________
// checkStructure

template <typename TNode> inline bool checkStructure(TNode * const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(210)

//____________________________________________________________________________
// checkStructureRec

template <typename TNode> inline bool checkStructureRec(TNode * const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(193)

//____________________________________________________________________________
// checkVirtualPositions

template <typename TNode> inline bool checkVirtualPositions(TNode * const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(157)

//____________________________________________________________________________
// checkVirtualPositionsRec

template <typename TNode> inline bool checkVirtualPositionsRec(TNode * const & node, unsigned & virtualPosition);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(139)

//____________________________________________________________________________
// clear

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline void clear(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(303)

//____________________________________________________________________________
// end

template <typename TNode> inline typename Iterator<JournalEntries<TNode, UnbalancedTree> const, Standard>::Type end(JournalEntries<TNode, UnbalancedTree> const & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(164)
template <typename TNode> inline typename Iterator<JournalEntries<TNode, UnbalancedTree>, Standard>::Type end(JournalEntries<TNode, UnbalancedTree> & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(177)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Iterator<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const, Standard>::Type end(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journalString, Standard);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(184)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Iterator<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> >, Standard>::Type end(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journalString, Standard const &);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(196)
template <typename TCargo> typename Iterator<JournalEntries<TCargo, SortedArray>, Standard>::Type end(JournalEntries<TCargo, SortedArray> & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(157)
template <typename TCargo> typename Iterator<JournalEntries<TCargo, SortedArray> const, Standard>::Type end(JournalEntries<TCargo, SortedArray> const & journalTree, Standard const &);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(166)

//____________________________________________________________________________
// erase

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos> inline void erase(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & pos, TPos const & posEnd);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(323)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos> inline void erase(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & pos);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(338)

//____________________________________________________________________________
// findInJournalEntries

template <typename TCargo> inline typename Iterator<JournalEntries<TCargo, SortedArray> const, Standard>::Type findInJournalEntries(JournalEntries<TCargo, SortedArray> const & journalEntries, typename Position<TCargo>::Type const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(188)
template <typename TCargo> inline typename Iterator<JournalEntries<TCargo, UnbalancedTree> const, Standard>::Type findInJournalEntries(JournalEntries<TCargo, UnbalancedTree> const & journalEntries, typename Position<TCargo>::Type const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(308)

//____________________________________________________________________________
// findJournalEntry

template <typename TCargo> inline TCargo const & findJournalEntry(JournalEntries<TCargo, SortedArray> const & journalEntries, typename Position<TCargo>::Type const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(213)
template <typename TCargo> inline TCargo const & findJournalEntry(JournalEntries<TCargo, UnbalancedTree> const & journalEntries, typename Position<TCargo>::Type const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(340)

//____________________________________________________________________________
// getValue

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename GetValue<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const>::Type getValue(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString, typename Position<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > >::Type const & pos);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(473)
template <typename TJournaledString, typename TJournalSpec> inline typename GetValue<Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > >::Type getValue(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(291)
template <typename TJournaledString, typename TJournalSpec> inline typename GetValue<Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > >::Type getValue(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(305)

//____________________________________________________________________________
// goLeft

template <typename TJournalEntries> inline bool goLeft(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(285)

//____________________________________________________________________________
// goRight

template <typename TJournalEntries> inline bool goRight(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(307)

//____________________________________________________________________________
// goUp

template <typename TJournalEntries> inline bool goUp(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(329)

//____________________________________________________________________________
// hasLeftChild

template <typename TJournalEntries> inline bool hasLeftChild(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(276)

//____________________________________________________________________________
// hasParent

template <typename TJournalEntries> inline bool hasParent(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(320)

//____________________________________________________________________________
// hasRightChild

template <typename TJournalEntries> inline bool hasRightChild(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(298)

//____________________________________________________________________________
// host

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Host<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > >::Type & host(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(280)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Host<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > >::Type const & host(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(289)

//____________________________________________________________________________
// id

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline const void * id(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(520)
template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline const void * id(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(529)

//____________________________________________________________________________
// insert

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TString, typename TPos> inline void insert(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & pos, TString const & seq);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(350)

//____________________________________________________________________________
// insertValue

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos, typename TValue2> inline void insertValue(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TPos const & pos, TValue2 const & value);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(364)

//____________________________________________________________________________
// isGapInHost

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos> inline bool isGapInHost(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString, TPos const & pos);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(509)
template <typename TNode, typename TJournalSpec, typename TPos> inline bool isGapInHost(JournalEntries<TNode, TJournalSpec> const & journalEntries, TPos const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(464)

//____________________________________________________________________________
// journalTreeToDot

template <typename TStream, typename TNode> void journalTreeToDot(TStream & stream, unsigned & nextId, JournalEntries<TNode, UnbalancedTree> const & journalTree);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(687)

//____________________________________________________________________________
// journalTreeToDotRec

template <typename TStream, typename TNode> void journalTreeToDotRec(TStream & stream, unsigned & nextId, TNode const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(668)

//____________________________________________________________________________
// length

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline typename Size<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > >::Type length(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(452)

//____________________________________________________________________________
// operator!=

template <typename TJournalEntries> inline bool operator!=(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & a, Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & b);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(511)
template <typename TJournalEntries> inline bool operator!=(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & a, typename IterComplementConst<Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > >::Type const & b);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(521)
template <typename TJournaledString, typename TJournalSpec> inline bool operator!=(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & a, Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & b);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(463)
template <typename TJournaledString, typename TJournalSpec> inline bool operator!=(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & a, typename IterComplementConst<Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > >::Type const & b);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(473)

//____________________________________________________________________________
// operator*

template <typename TJournaledString, typename TJournalSpec> inline typename Value<TJournaledString>::Type operator*(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(357)
template <typename TJournaledString, typename TJournalSpec> inline typename Value<TJournaledString>::Type operator*(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(366)

//____________________________________________________________________________
// operator+

template <typename TJournaledString, typename TJournalSpec> inline Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > operator+(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & iterator, typename Size<TJournaledString>::Type const & len);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(418)

//____________________________________________________________________________
// operator++

template <typename TJournalEntries> inline Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & operator++(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(366)
template <typename TJournalEntries> inline Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > operator++(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator, int );       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(412)
template <typename TJournaledString, typename TJournalSpec> inline Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & operator++(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(319)
template <typename TJournaledString, typename TJournalSpec> inline Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > operator++(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator, int );       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(346)

//____________________________________________________________________________
// operator+=

template <typename TJournaledString, typename TJournalSpec> inline Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & operator+=(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator, typename Size<TJournaledString>::Type len);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(376)

//____________________________________________________________________________
// operator--

template <typename TJournalEntries> inline Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & operator--(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(423)
template <typename TJournalEntries> inline Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > operator--(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator, int );       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(479)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec> inline TStream & operator<<(TStream & stream, String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & s);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(237)
template <typename TStream, typename TCargo> TStream & operator<<(TStream & stream, JournalEntriesUnorderedTreeNode<TCargo> const & node);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_node.h"(99)
template <typename TStream, typename TPos, typename TSize> TStream & operator<<(TStream & stream, JournalEntry<TPos, TSize> const & entry);       	// "projects/library/seqan/sequence_journaled/journal_entry.h"(133)
template <typename TStream, typename TNode> inline TStream & operator<<(TStream & stream, JournalEntries<TNode, SortedArray> const & tree);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(104)
template <typename TStream, typename TNode> inline TStream & operator<<(TStream & stream, JournalEntries<TNode, UnbalancedTree> const & tree);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(234)

//____________________________________________________________________________
// operator==

template <typename TJournalEntries> inline bool operator==(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & a, Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & b);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(491)
template <typename TJournalEntries> inline bool operator==(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & a, typename IterComplementConst<Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > >::Type const & b);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(501)
template <typename TJournaledString, typename TJournalSpec> inline bool operator==(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & a, Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & b);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(430)
template <typename TJournaledString, typename TJournalSpec> inline bool operator==(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & a, typename IterComplementConst<Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > >::Type const & b);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(452)

//____________________________________________________________________________
// recordErase

template <typename TCargo> inline void recordErase(JournalEntries<TCargo, SortedArray> & tree, typename Position<TCargo>::Type const & pos, typename Position<TCargo>::Type const & posEnd);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(296)
template <typename TCargo> inline void recordErase(JournalEntries<TCargo, UnbalancedTree> & tree, typename Position<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type const & pos, typename Position<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type const & posEnd);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(351)

//____________________________________________________________________________
// recordInsertion

template <typename TCargo> inline void recordInsertion(JournalEntries<TCargo, SortedArray> & tree, typename Position<TCargo>::Type const & virtualPosition, typename Position<TCargo>::Type const & physicalBeginPos, typename Size<TCargo>::Type const & len);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(224)
template <typename TCargo> inline void recordInsertion(JournalEntries<TCargo, UnbalancedTree> & tree, typename Position<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type const & virtualPos, typename Position<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type const & physicalBeginPos, typename Size<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type const & length);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(538)

//____________________________________________________________________________
// reinit

template <typename TCargo> inline void reinit(JournalEntries<TCargo, SortedArray> & tree, typename Size<TCargo>::Type originalStringLength);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(176)
template <typename TCargo> inline void reinit(JournalEntries<TCargo, UnbalancedTree> & tree, typename Size<typename JournalEntries<TCargo, UnbalancedTree>::TNode>::Type originalStringLength);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree.h"(245)

//____________________________________________________________________________
// setHost

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TSequence2> inline void setHost(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > & journaledString, TSequence2 & str);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(264)

//____________________________________________________________________________
// value

template <typename TJournalEntries> inline typename Value<Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > >::Type value(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(234)
template <typename TJournalEntries> inline typename Value<Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > >::Type value(Iter<TJournalEntries, JournalEntriesIterSpec<UnbalancedTree> > const & iterator);       	// "projects/library/seqan/sequence_journaled/journal_entries_unbalanced_tree_iterator.h"(243)
template <typename TJournaledString, typename TJournalSpec> inline typename Value<TJournaledString>::Type value(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > const & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(263)
template <typename TJournaledString, typename TJournalSpec> inline typename Value<TJournaledString>::Type value(Iter<TJournaledString, JournaledStringIterSpec<TJournalSpec> > & iterator);       	// "projects/library/seqan/sequence_journaled/sequence_journaled_iterator.h"(277)

//____________________________________________________________________________
// virtualToHostPosition

template <typename TValue, typename THostSpec, typename TJournalSpec, typename TBufferSpec, typename TPos> inline typename Position<String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > >::Type virtualToHostPosition(String<TValue, Journaled<THostSpec, TJournalSpec, TBufferSpec> > const & journaledString, TPos const & pos);       	// "projects/library/seqan/sequence_journaled/sequence_journaled.h"(497)
template <typename TNode, typename TJournalSpec, typename TPos> inline typename Position<typename Cargo<TNode>::Type >::Type virtualToHostPosition(JournalEntries<TNode, TJournalSpec> const & journalEntries, TPos const & pos);       	// "projects/library/seqan/sequence_journaled/journal_entries_sorted_array.h"(423)

} //namespace seqan

#endif

