// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_SEEDS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEEDS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ChainMerge_

struct ChainMerge_;       	// "projects/library/seqan/seeds/seed_base.h"(69)

//____________________________________________________________________________
// ExtendSeedGappedXDrop_

struct ExtendSeedGappedXDrop_;       	// "projects/library/seqan/seeds/seed_base.h"(81)

//____________________________________________________________________________
// FreeInt_

struct FreeInt_;       	// "projects/library/seqan/seeds/memoryManager_int.h"(58)

//____________________________________________________________________________
// FreePointer_

struct FreePointer_;       	// "projects/library/seqan/seeds/memoryManager_base.h"(55)

//____________________________________________________________________________
// MemoryManager

template <typename TValue, typename TSPec, typename TFree> class MemoryManager;       	// "projects/library/seqan/seeds/memoryManager_base.h"(59)

//____________________________________________________________________________
// PropertyMap

template <typename TValue, typename TSPec> class PropertyMap;       	// "projects/library/seqan/seeds/propertyMap.h"(54)

//____________________________________________________________________________
// Seed

template <typename TPosition , typename TSpecSeed > class Seed;       	// "projects/library/seqan/seeds/seed_base.h"(119)

//____________________________________________________________________________
// SeedIterator

struct SeedIterator;       	// "projects/library/seqan/seeds/seedSet_base.h"(40)

//____________________________________________________________________________
// SeedMulti_

struct SeedMulti_;       	// "projects/library/seqan/seeds/seed_multi.h"(39)

//____________________________________________________________________________
// SeedSet

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec > class SeedSet;       	// "projects/library/seqan/seeds/seedSet_base.h"(114)

//____________________________________________________________________________
// SeedSimple_

struct SeedSimple_;       	// "projects/library/seqan/seeds/seed_base.h"(41)

//____________________________________________________________________________
// SortProcess

template <class TTriple> struct SortProcess;       	// "projects/library/seqan/seeds/seedSet_base.h"(1356)

//____________________________________________________________________________
// _extendSeed_Match

struct _extendSeed_Match;       	// "projects/library/seqan/seeds/seed_base.h"(74)

//____________________________________________________________________________
// _extendSeed_UnGappedXDrop

struct _extendSeed_UnGappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(78)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ChainedSeed

typedef Tag<SeedMulti_> const ChainedSeed;       	// "projects/library/seqan/seeds/seed_multi.h"(40)

//____________________________________________________________________________
// FreeMemoryInt

typedef Tag<FreeInt_> const FreeMemoryInt;       	// "projects/library/seqan/seeds/memoryManager_int.h"(59)

//____________________________________________________________________________
// FreeMemoryPointer

typedef Tag<FreePointer_> const FreeMemoryPointer;       	// "projects/library/seqan/seeds/memoryManager_base.h"(56)

//____________________________________________________________________________
// GappedXDrop

typedef Tag<ExtendSeedGappedXDrop_> const GappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(82)

//____________________________________________________________________________
// MatchExtend

typedef Tag<_extendSeed_Match> const MatchExtend;       	// "projects/library/seqan/seeds/seed_base.h"(75)

//____________________________________________________________________________
// Merge

typedef Tag<ChainMerge_> const Merge;       	// "projects/library/seqan/seeds/seed_base.h"(70)

//____________________________________________________________________________
// SimpleSeed

typedef Tag<SeedSimple_> const SimpleSeed;       	// "projects/library/seqan/seeds/seed_base.h"(42)

//____________________________________________________________________________
// UngappedXDrop

typedef Tag<_extendSeed_UnGappedXDrop> const UngappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(79)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _bandedGotoh

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> TScoreValue _bandedGotoh(Matrix<TScoreValue, DIMENSION> & matrix_diag, Matrix<TScoreValue, DIMENSION> & matrix_vert, Matrix<TScoreValue, DIMENSION> & matrix_hori, Seed<TValue, TSpecSeed> const &seed, TValue2 k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(134)
template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TSpecSeed> TScoreValue _bandedGotoh(Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(302)

//____________________________________________________________________________
// _bandedGotohRectangleFirst

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> void _bandedGotohRectangleFirst(Matrix<TScoreValue, DIMENSION> & matrix_diag, Matrix<TScoreValue, DIMENSION> & matrix_vert, Matrix<TScoreValue, DIMENSION> & matrix_hori, Seed<TValue, TSpecSeed> const &seed, TValue2 k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1438)

//____________________________________________________________________________
// _bandedGotohTrace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION, typename TValue> void _bandedGotohTrace(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, TValue position_);       	// "projects/library/seqan/seeds/banded_align.h"(558)

//____________________________________________________________________________
// _bandedGotohTrace2

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> typename Size<Matrix<TScoreValue, DIMENSION> >::Type _bandedGotohTrace2(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_ );       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(399)

//____________________________________________________________________________
// _bandedNeedlemanWunsch

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TSpecSeed> TScoreValue _bandedNeedlemanWunsch(Matrix<TScoreValue, DIMENSION> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(50)
template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> TScoreValue _bandedNeedlemanWunsch(Matrix<TScoreValue, DIMENSION> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue2 k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(202)

//____________________________________________________________________________
// _bandedNeedlemanWunschRectangleFirst

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> void _bandedNeedlemanWunschRectangleFirst(Matrix<TScoreValue, DIMENSION> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue2 k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(1179)

//____________________________________________________________________________
// _bandedNeedlemanWunschTrace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> void _bandedNeedlemanWunschTrace(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(217)

//____________________________________________________________________________
// _bandedNeedlemanWunschTrace2

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> typename Size<Matrix<TScoreValue, DIMENSION> >::Type _bandedNeedlemanWunschTrace2(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, DIMENSION> & matrix, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align.h"(369)

//____________________________________________________________________________
// _calculateBandedSeed

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateBandedSeed(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(615)

//____________________________________________________________________________
// _calculateBandedSeedGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateBandedSeedGotoh(TSeed const &seed, TDiff k, TMatrix &matrix_diag, TMatrix &matrix_vert, TMatrix &matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(540)

//____________________________________________________________________________
// _calculateFirstRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateFirstRectangle(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(695)

//____________________________________________________________________________
// _calculateFirstRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateFirstRectangleGotoh(TSeed const &seed, TDiff k, TMatrix &matrix_diag, TMatrix &matrix_vert, TMatrix &matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(636)

//____________________________________________________________________________
// _calculateLastRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateLastRectangle(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(744)

//____________________________________________________________________________
// _calculateLastRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateLastRectangleGotoh(TSeed const &seed, TDiff k, TMatrix & matrix_diag, TMatrix & matrix_vert, TMatrix & matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString & score_str_diag, TScoreString & score_str_vert, TScoreString & score_str_hori, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(692)

//____________________________________________________________________________
// _calculateRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateRectangle(TSeed const &seed, TSeed const &seed2, TDiff k_begin, TDiff k_end, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(823)

//____________________________________________________________________________
// _calculateRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateRectangleGotoh(TSeed const &seed, TSeed const &seed2, TDiff k_begin, TDiff k_end, TMatrix & matrix_diag, TMatrix & matrix_vert, TMatrix & matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, ::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > & alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(785)

//____________________________________________________________________________
// _calculateScoringValue

template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue qPos1, TValue dPos1, TValue qPos2, TValue dPos2, Score<TScore, Simple> const &matrix, Manhattan);       	// "projects/library/seqan/seeds/seedSet_score.h"(48)
template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue qPos1, TValue&, TValue qPos2, TValue &, Score<TScore, Simple> const &matrix, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(60)
template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue &, TValue dPos1, TValue &, TValue dPos2, Score<TScore, Simple> const &matrix, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(72)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, Score<TScore, Simple> &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_score.h"(83)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue dPos, TValue &, TScore score, Manhattan);       	// "projects/library/seqan/seeds/seedSet_score.h"(96)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue &, TValue &, TScore score, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(108)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue &, TValue dPos, TValue &, TScore score, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(120)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, TValue &, TScore &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_score.h"(132)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue dPos, TValue &, Manhattan);       	// "projects/library/seqan/seeds/seedSet_base.h"(54)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue &, TValue &, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(60)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue &, TValue dPos, TValue &, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(66)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, TValue &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_base.h"(72)

//____________________________________________________________________________
// _chainToAlignmentGotoh

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore _chainToAlignmentGotoh(TContainer const &seedChain, TValue k, TAlign & whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(47)

//____________________________________________________________________________
// _chainToAlignmentNeedlemanWunsch

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore _chainToAlignmentNeedlemanWunsch(TContainer const &seedChain, TValue k, TAlign & whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(96)

//____________________________________________________________________________
// _constructAlignment

template <typename TValue, typename TAlign, typename TAlign2> void _constructAlignment(::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > >const &me, TAlign2 &wholeAlignment);       	// "projects/library/seqan/seeds/banded_chain_align.h"(157)

//____________________________________________________________________________
// _deleteAlignment

template <typename TValue, typename TAlign, typename TSize> void _deleteAlignment(::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &me, TSize old_end, TSize new_end);       	// "projects/library/seqan/seeds/banded_chain_align.h"(574)

//____________________________________________________________________________
// _deleteEverything

template <typename TValue, typename TSeedSpec, typename TQualityFactor, typename TGapCosts, typename TScore> void _deleteEverything(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, TScore> >, void> &deletionTarget, TValue currentPos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1643)
template <typename TValue, typename TSeedSpec, typename TQualityFactor, typename TGapCosts> void _deleteEverything(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, void> &deletionTarget, TValue currentPos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1477)

//____________________________________________________________________________
// _extendSeed

template <typename TValue, typename TText> void _extendSeed(Triple<TValue,TValue,TValue> &position, Segment<String<TText> const, InfixSegment> qSeg, Segment<String<TText> const, InfixSegment> dSeg);       	// "projects/library/seqan/seeds/seedSet_base.h"(1344)

//____________________________________________________________________________
// _extendSeedOneDirection

template <typename TSeedSpec, typename TPosition, typename DatabaseInfix, typename QueryInfix, typename TScore, typename TSize> TScore _extendSeedOneDirection(Seed<TPosition, TSeedSpec > & seed, DatabaseInfix const & dataSeg, QueryInfix const & querySeg, TScore scoreDropOff, Score<TScore, Simple> const & scoreMatrix, TSize direction);       	// "projects/library/seqan/seeds/seed_base.h"(888)

//____________________________________________________________________________
// _findPrev

template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type _findPrev(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find, SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/seeds/global_seed_chain.h"(45)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type _findPrev(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find);       	// "projects/library/seqan/seeds/global_seed_chain.h"(57)

//____________________________________________________________________________
// _findSeedsChain

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> > >::Type >::iterator _findSeedsChain(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(1681)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> >::Value> > >::Type >::iterator _findSeedsChain(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(1514)

//____________________________________________________________________________
// _findSeedsMerge

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> > >::Type >::iterator _findSeedsMerge(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue , typename ScoreType<TScoringSpec>::Type score, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(1733)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> >::Value> > >::Type >::iterator _findSeedsMerge(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length_, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(1554)

//____________________________________________________________________________
// _gapFill

template <typename TValue, typename TText> void _gapFill(TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, std::list<Triple<TValue, TValue, TValue> > &diagList, String<TText> const &query, String<TText> const &database, TValue q);       	// "projects/library/seqan/seeds/seedSet_base.h"(1377)

//____________________________________________________________________________
// _getDiagSet

template <typename TPosition> inline const std::list<Triple<TPosition, TPosition, TPosition> >& _getDiagSet(Seed<TPosition,ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(204)
template <typename TPosition> inline std::list<Triple<TPosition, TPosition, TPosition> >& _getDiagSet(Seed<TPosition,ChainedSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(211)

//____________________________________________________________________________
// _getFirstDiag

template <typename TPosition> Triple<TPosition, TPosition, TPosition>& _getFirstDiag(Seed<TPosition,ChainedSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(239)
template <typename TPosition> const Triple<TPosition, TPosition, TPosition>& _getFirstDiag(Seed<TPosition,ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(246)

//____________________________________________________________________________
// _getLastDiag

template <typename TPosition> Triple<TPosition, TPosition, TPosition>& _getLastDiag(Seed<TPosition,ChainedSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(253)
template <typename TPosition> const Triple<TPosition, TPosition, TPosition>& _getLastDiag(Seed<TPosition,ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(260)

//____________________________________________________________________________
// _getPosition

template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type _getPosition(MemoryManager<TValue,Block<SPACE>, TFree > const &manager, const void* pointer);       	// "projects/library/seqan/seeds/memoryManager_base.h"(360)

//____________________________________________________________________________
// _gotoh2

template <typename TScoreValue, unsigned DIMENSION, typename TString> void _gotoh2(Matrix<TScoreValue, DIMENSION> & matrix_diag, Matrix<TScoreValue, DIMENSION> & matrix_vert, Matrix<TScoreValue, DIMENSION> & matrix_hori, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1194)

//____________________________________________________________________________
// _gotohRectangle

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> void _gotohRectangle(Matrix<TScoreValue, DIMENSION> & matrix_diag, Matrix<TScoreValue, DIMENSION> & matrix_vert, Matrix<TScoreValue, DIMENSION> & matrix_hori, Seed<TValue, TSpecSeed> const &seed1, Seed<TValue, TSpecSeed> const &seed2, TValue2 k_begin, TValue2 k_end, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(889)

//____________________________________________________________________________
// _gotohTraceLastRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> TScoreValue _gotohTraceLastRectangle(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(470)

//____________________________________________________________________________
// _gotohTraceRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION, typename TValue, typename TMatrix> TValue _gotohTraceRectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > & diag_source, TMatrix & diag_matrix_, TMatrix & vert_matrix_, TMatrix & hori_matrix_, TValue width_stop, TValue height_stop);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1362)

//____________________________________________________________________________
// _mergeTwoSeeds

template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, ChainedSeed> &firstSeed, TPosition qPos, TPosition dPos, TPosition length, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(278)
template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, ChainedSeed> &firstSeed, Seed<TPosition, ChainedSeed> const &secondSeed, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(327)
template <typename TValue, typename TSeedSpec> void _mergeTwoSeeds(Seed<TValue, TSeedSpec> &seed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(1010)
template <typename TValue> void _mergeTwoSeeds(Seed<TValue, SimpleSeed> &firstSeed, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(1030)
template <typename TValue> void _mergeTwoSeeds(Seed<TValue, ChainedSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(1053)
template <typename TValue, typename TText, typename TValue2> void _mergeTwoSeeds(Seed<TValue, ChainedSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TValue2, Simple> const &scoreMatrix, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1150)
template <typename TValue, typename TText> void _mergeTwoSeeds(Seed<TValue, ChainedSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, TValue q, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1296)
template <typename TPosition, typename TSpecSeed> void _mergeTwoSeeds(Seed<TPosition, TSpecSeed> &firstSeed, Seed<TPosition, TSpecSeed> const &secondSeed, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(569)
template <typename TPosition, typename TSpecSeed> void _mergeTwoSeeds(Seed<TPosition, TSpecSeed> &firstSeed, TPosition q, TPosition d, TPosition l, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(589)
template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, SimpleSeed> &firstSeed, TPosition qlPos, TPosition dlPos, TPosition qrPos, TPosition drPos, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(608)

//____________________________________________________________________________
// _mergeTwoSeedsScore

template <typename TValue, typename TSeedSpec> void _mergeTwoSeedsScore(Seed<TValue, TSeedSpec> &seed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(768)
template <typename TValue> void _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(788)
template <typename TValue, typename TScore, typename TText, typename TGapCost> TValue _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TScore, Simple> const &scoreMatrix, TGapCost tag, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(952)
template <typename TValue, typename TScore, typename TText, typename TGapCost> TValue _mergeTwoSeedsScore(Seed<TValue, ChainedSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TScore, Simple> const &scoreMatrix, TGapCost tag, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1014)
template <typename TValue, typename TText, typename TScore, typename TGapCosts> TScore _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue q, TGapCosts tag, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1261)
template <typename TValue, typename TText, typename TScore, typename TGapCosts> TScore _mergeTwoSeedsScore(Seed<TValue, ChainedSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue q, TGapCosts tag, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1321)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, ChainedSeed> &firstSeed, TPosition3 &score1, TPosition qPos, TPosition dPos, TPosition length, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(394)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, ChainedSeed> &firstSeed, TPosition3 &score1, Seed<TPosition, ChainedSeed> const &secondSeed, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(463)
template <typename TPosition, typename TSpecSeed, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, TSpecSeed> &firstSeed, TPosition3 &score1, Seed<TPosition, TSpecSeed> const &secondSeed, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(639)
template <typename TPosition, typename TPosition2, typename TSpecSeed, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, TSpecSeed> &firstSeed, TPosition3 &score1, TPosition q, TPosition d, TPosition l, TPosition3 score2, Score<TPosition2, Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(666)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, SimpleSeed> &firstSeed, TPosition3 &score1, TPosition qlPos, TPosition dlPos, TPosition qrPos, TPosition drPos, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(692)

//____________________________________________________________________________
// _needlemanWunschRectangle

template <typename TScoreValue, unsigned DIMENSION, typename TString, typename TValue, typename TValue2, typename TSpecSeed> void _needlemanWunschRectangle(Matrix<TScoreValue, DIMENSION> & matrix_, Seed<TValue, TSpecSeed> const &seed1, Seed<TValue, TSpecSeed> const &seed2, TValue2 k_begin, TValue2 k_end, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(914)

//____________________________________________________________________________
// _needlemanWunschTraceLastRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> int _needlemanWunschTraceLastRectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align.h"(459)

//____________________________________________________________________________
// _needlemanWunschTraceRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION, typename TValue, typename TMatrix> TValue _needlemanWunschTraceRectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_, TMatrix matrix, TValue width_stop, TValue height_stop);       	// "projects/library/seqan/seeds/banded_chain_align.h"(1081)

//____________________________________________________________________________
// _qualityReached

template <typename TSeed, typename TScore> inline bool _qualityReached(TSeed &, TScore score, TScore qualityValue, SeedScore);       	// "projects/library/seqan/seeds/seedSet_base.h"(89)
template <typename TSeed, typename TScore> inline bool _qualityReached(TSeed const &seed, TScore , TScore qualityValue, SeedLength);       	// "projects/library/seqan/seeds/seedSet_base.h"(95)

//____________________________________________________________________________
// _raiseMemory

template <typename TValue, unsigned int SPACE> void _raiseMemory(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, typename Size<String<TValue, Block<SPACE> > >::Type leng);       	// "projects/library/seqan/seeds/memoryManager_int.h"(273)
template <typename TValue, unsigned int SPACE, typename TFree> void _raiseMemory(MemoryManager<TValue,Block<SPACE>, TFree > &manager, typename Size<String<TValue, Block<SPACE> > >::Type leng);       	// "projects/library/seqan/seeds/memoryManager_base.h"(280)

//____________________________________________________________________________
// _recDelete

template <typename TAlign, typename TValue> void _recDelete(::std::vector< ::std::map<TValue,Pair<TValue, TAlign> > > &vec, TValue index, TValue position);       	// "projects/library/seqan/seeds/banded_chain_align.h"(545)

//____________________________________________________________________________
// _scoreMap

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline PropertyMap<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> >* _scoreMap(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(340)

//____________________________________________________________________________
// _setExtendedSeedDimensions

template <typename TPosition, typename TBound, typename TExtension, typename TSize> void _setExtendedSeedDimensions(Seed<TPosition, ChainedSeed> & seed, TBound lowerBound, TBound upperBound, TExtension extLengthQuery, TExtension extLengthDatabase, TSize direction);       	// "projects/library/seqan/seeds/seed_multi.h"(534)
template <typename TPosition, typename TBound, typename TExtension, typename TSize> void _setExtendedSeedDimensions(Seed<TPosition, SimpleSeed> & seed, TBound lowerBound, TBound upperBound, TExtension extLengthQuery, TExtension extLengthDatabase, TSize direction);       	// "projects/library/seqan/seeds/seed_base.h"(857)

//____________________________________________________________________________
// addSeed

template <typename TValue, typename TSpec, typename TScoringSpec, typename TPosition, typename TSize2, typename TScore, typename TSeedSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize2 length, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(356)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TPosition, typename TSize, typename TSeedSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize length, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(385)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TPosition, typename TScore> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TPosition qBeginPos, TPosition dBeginPos, TPosition qEndPos, TPosition dEndPos, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(400)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(426)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore> bool addSeed(SeedSet<TValue, ChainedSeed, TScoringSpec, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(453)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TPosition, typename TSize2, typename TScoringSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize2 length, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(493)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TPosition, typename TSize, typename TScoringSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize length, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(525)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(537)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(569)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(618)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(654)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(670)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(700)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, ChainedSeed, TScoringSpec, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(731)
template <typename TValue, typename TText, typename TSpec, typename TPosition, typename TSize2, typename TScoringSpec, typename TSpecSeed> bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize2 length, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(821)
template <typename TValue, typename TText, typename TSpec, typename TPosition, typename TSize, typename TScoringSpec, typename TSpecSeed> inline bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TPosition qPos, TPosition dPos, TSize length, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(857)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, ChainedSeed, TScoringSpec, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(872)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(912)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1085)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> inline bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1129)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, ChainedSeed, TScoringSpec, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1144)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1202)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(510)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qBeginPos, TValue dBeginPos, TValue qEndPos, TValue dEndPos, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(530)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(548)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(567)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length_, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(785)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(816)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(848)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(889)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(921)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(947)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(974)
template <typename TValue, typename TSeedSpec, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1079)
template <typename TValue, typename TValue2, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1112)
template <typename TValue, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1206)
template <typename TValue, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, ChainedSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, ChainedSeed> const &seed, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1246)

//____________________________________________________________________________
// addSeedSet

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1567)
template <typename TValue, typename TSeedSpec, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1584)
template <typename TValue, typename TSeedSpec, typename TText, typename TSpec, typename TScoringSpec, typename TAlgoSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, String<TText> const &query, String<TText> const &database, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1612)

//____________________________________________________________________________
// addSeeds

template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1395)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1422)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TText, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1441)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TText, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1468)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 const &scoreSource, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1491)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 &scoreSource, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1517)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TText, typename TSpec, typename TScoringSpec, typename TAlgoSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 const &scoreSource, String<TText> const &query, String<TText> const &database, int gapDistance, TAlgoSpec algoSpec);       	// "projects/library/seqan/seeds/seedSet_score.h"(1537)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TAlgoSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(594)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(634)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(660)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TAlgoSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer &source, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(683)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(707)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(727)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(754)

//____________________________________________________________________________
// addSeedsIt

template <typename TSeedSet, typename TIterator> bool addSeedsIt(TSeedSet &set, TIterator begin, TIterator end, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(616)

//____________________________________________________________________________
// append

template <typename TValue, typename TSeedSpec, typename TContainer1, typename TContainer2, typename TSpec, typename TScoringSpec> void append(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, TContainer1 &seedSource, TContainer2 &scoreSource);       	// "projects/library/seqan/seeds/seedSet_score.h"(264)
template <typename TValue, typename TSeedSpec, typename TContainer2, typename TSpecScoring, typename TSpec> void append(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &target, TContainer2 &source);       	// "projects/library/seqan/seeds/seedSet_base.h"(282)

//____________________________________________________________________________
// appendDiag

template <typename TPosition> void appendDiag(Seed<TPosition,ChainedSeed> & seed, Triple<TPosition, TPosition, TPosition> diag);       	// "projects/library/seqan/seeds/seed_multi.h"(232)

//____________________________________________________________________________
// appendValue

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec, typename TValue2> void appendValue(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, Seed<TValue, TSeedSpec> &seed, TValue2 score);       	// "projects/library/seqan/seeds/seedSet_score.h"(282)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void appendValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &target, Seed<TValue, TSeedSpec> &seed);       	// "projects/library/seqan/seeds/seedSet_base.h"(294)

//____________________________________________________________________________
// assign

template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt>& target, TSource const& source);       	// "projects/library/seqan/seeds/memoryManager_int.h"(181)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( PropertyMap<TValue, Block<SPACE> >& target, TSource const& source);       	// "projects/library/seqan/seeds/propertyMap.h"(138)
template <typename TValue, unsigned int SPACE, typename TFree, typename TSource> inline void assign( MemoryManager<TValue, Block<SPACE>, TFree>& target, TSource const& source);       	// "projects/library/seqan/seeds/memoryManager_base.h"(191)

//____________________________________________________________________________
// assignValue

template <typename TValue, unsigned int SPACE, typename TPosition> void assignValue(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, TPosition pos, TValue value);       	// "projects/library/seqan/seeds/memoryManager_int.h"(329)
template <typename TValue, unsigned int SPACE, typename TFree, typename TPosition> void assignValue(MemoryManager<TValue,Block<SPACE>, TFree > &manager, TPosition pos, TValue value);       	// "projects/library/seqan/seeds/memoryManager_base.h"(377)

//____________________________________________________________________________
// bandedAlignment

template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_, NeedlemanWunsch);       	// "projects/library/seqan/seeds/banded_align.h"(631)
template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_, Gotoh);       	// "projects/library/seqan/seeds/banded_align.h"(653)
template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(693)

//____________________________________________________________________________
// bandedChainAlignment

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore bandedChainAlignment(TContainer const &seedChain, TValue k, TAlign &whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(61)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec>, Standard >::Type begin(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(303)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const, Standard>::Type begin(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(322)

//____________________________________________________________________________
// capacity

template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const & me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(260)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(PropertyMap<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/seeds/propertyMap.h"(216)
template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(MemoryManager<TValue, Block<SPACE>, TFree > const & me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(267)

//____________________________________________________________________________
// clear

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> void clear(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(312)
template <typename TValue, unsigned int SPACE> inline void clear(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt >& me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(228)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> void clear(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(355)
template <typename TValue, unsigned int SPACE> inline void clear(PropertyMap<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/seeds/propertyMap.h"(185)
template <typename TValue, unsigned int SPACE, typename TFree> inline void clear(MemoryManager<TValue, Block<SPACE>, TFree >& me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(235)

//____________________________________________________________________________
// dimension

template <typename TPosition, typename TSpec > inline typename Size< Seed< TPosition, TSpec > >::Type dimension( Seed< TPosition, TSpec > & );       	// "projects/library/seqan/seeds/seed_base.h"(321)

//____________________________________________________________________________
// end

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec>, Standard >::Type end(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(312)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> const, Standard>::Type end(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(331)

//____________________________________________________________________________
// endDiagonal

template <typename TPosition> inline TPosition endDiagonal(Seed<TPosition, ChainedSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(101)
template <typename TPosition, typename TSpecSeed> inline TPosition endDiagonal(Seed<TPosition, TSpecSeed> const &me);       	// "projects/library/seqan/seeds/seed_base.h"(218)

//____________________________________________________________________________
// extendSeed

template <typename TPosition, typename TSpecSeed, typename TQuery, typename TDatabase, typename TDirection> void extendSeed(Seed<TPosition, TSpecSeed> &seed, TQuery const &query, TDatabase const &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seed_base.h"(752)
template <typename TPosition, typename TSpecSeed, typename TQuery, typename TDatabase, typename TScore, typename TDirection> void extendSeed(Seed<TPosition,TSpecSeed> &seed, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, TQuery const &query, TDatabase const &database, TDirection direction, UngappedXDrop);       	// "projects/library/seqan/seeds/seed_base.h"(793)
template <typename TSeedSpec, typename TPosition, typename TQuery, typename TDatabase, typename TScore, typename TSize> void extendSeed(Seed<TPosition, TSeedSpec> &seed, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, TQuery const &query, TDatabase const &database, TSize direction, GappedXDrop);       	// "projects/library/seqan/seeds/seed_base.h"(1065)

//____________________________________________________________________________
// extendSeedScore

template <typename TValue, typename TSeedSpec, typename TText, typename TValue2, typename TValue3, typename TDirection> void extendSeedScore(Seed<TValue, TSeedSpec> &seed, TValue3 &currentScore, Score<TValue2, Simple> const &matrix, String<TText> const &query, String<TText> const &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1990)
template <typename TValue, typename TSeedSpec, typename TText, typename TScore, typename TDirection> void extendSeedScore(Seed<TValue,TSeedSpec> &seed, TScore &currentScore, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TDirection direction, UngappedXDrop);       	// "projects/library/seqan/seeds/seedSet_score.h"(2037)
template <typename TSeedSpec, typename TPosition, typename TQuery, typename TDatabase, typename TScore, typename TSize> void extendSeedScore(Seed<TPosition, TSeedSpec> &seed, TScore &currentScore, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, TQuery const &query, TDatabase const &database, TSize direction, GappedXDrop);       	// "projects/library/seqan/seeds/seedSet_score.h"(2112)

//____________________________________________________________________________
// extendSeeds

template <typename TContainer, typename TQuery, typename TDatabase, typename TDirection> void extendSeeds(TContainer &seedSet, String<TQuery> &query, String<TDatabase> &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_base.h"(1631)
template <typename TIterator, typename TQuery, typename TDatabase, typename TDirection> void extendSeeds(TIterator begin, TIterator end, String<TQuery> &query, String<TDatabase> &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_base.h"(1647)
template <typename TContainer, typename TQuery, typename TDatabase, typename TextendSeedSpec, typename TValue, typename TValue2, typename TDirection> void extendSeeds(TContainer &seedSet, TValue scoreDropOff, Score<TValue2, Simple> const &scoreMatrix, String<TQuery> const &query, String<TDatabase> const &database, TDirection direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(1662)
template <typename TIterator, typename TextendSeedSpec, typename TValue, typename TQuery, typename TDatabase, typename TDirection> void extendSeeds(TIterator begin, TIterator end, TValue scoreDropOff, Score<TValue, Simple> const &scoreMatrix, String<TQuery> const &query, String<TDatabase> const &database, TDirection direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(1681)

//____________________________________________________________________________
// extendSeedsScore

template <typename TContainer, typename TContainer2, typename TText, typename TValue, typename TDirection> void extendSeedsScore(TContainer &seedSet, TContainer2 &scores, Score<TValue, Simple> const &matrix, String<TText> const &query, String<TText> const &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1851)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TText, typename TScoringSpec, typename TDirection> void extendSeedsScore(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &seedSet, String<TText> const &query, String<TText> const &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1872)
template <typename TIterator, typename TIterator2, typename TText, typename TValue, typename TDirection> void extendSeedsScore(TIterator begin, TIterator end, TIterator2 itScore, Score<TValue, Simple> const &matrix, String<TText> const &query, String<TText> const &database, TDirection direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1892)
template <typename TContainer, typename TText, typename TContainer2, typename TextendSeedSpec, typename TValue, typename TValue2, typename TDirection> void extendSeedsScore(TContainer &seedSet, TContainer2 &scores, TValue scoreDropOff, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TDirection direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1909)
template <typename TText, typename TExtendSeedSpec, typename TValue, typename TSpec, typename TScoringSpec, typename TDirection> void extendSeedsScore(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &seedSet, TValue scoreDropOff, String<TText> const &query, String<TText> const &database, TDirection direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1930)
template <typename TText, typename TExtendSeedSpec, typename TValue, typename TSpec, typename TScoringSpec, typename TDirection> void extendSeedsScore(SeedSet<TValue, ChainedSeed, TScoringSpec, TSpec> &seedSet, TValue scoreDropOff, String<TText> const &query, String<TText> const &database, TDirection direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1949)
template <typename TIterator, typename TIterator2, typename TExtendSeedSpec, typename TValue, typename TText, typename TDirection> void extendSeedsScore(TIterator begin, TIterator end, TIterator2 itScore, TValue scoreDropOff, Score<TValue, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TDirection direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1971)

//____________________________________________________________________________
// getAlignment

template <typename TPosition, typename TText, typename TPosition2> int getAlignment(Seed<TPosition,ChainedSeed> &seed, Align<String<TText>, ArrayGaps> &aligned, String<TText> &query, String<TText> &database, Score<TPosition2, Simple> &scoreMatrix);       	// "projects/library/seqan/seeds/seed_multi.h"(588)

//____________________________________________________________________________
// getScoreMatrix

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline Score<int,Simple> getScoreMatrix(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(304)

//____________________________________________________________________________
// globalChaining

template <typename TValue, typename TSeedSpec, typename TScoreSpec, typename TSpec, typename TTargetContainer> typename ScoreType<TScoreSpec>::Type globalChaining(SeedSet<TValue, TSeedSpec, TScoreSpec, TSpec> const &source, TTargetContainer &result);       	// "projects/library/seqan/seeds/global_seed_chain.h"(104)
template <typename TValue, typename TValue2, typename TSeedSpec, typename TScoreSpec, typename TSpec, typename TTargetContainer, typename TScore> TScore globalChaining(SeedSet<TValue, TSeedSpec, TScoreSpec, TSpec> const &source, TTargetContainer &result, TScore gapCost, TValue2 xLength, TValue2 yLength);       	// "projects/library/seqan/seeds/global_seed_chain.h"(178)
template <typename TValue, typename TSeedSpec, typename TScoreSpec, typename TSpec, typename TTargetContainer, typename TScore> TScore globalChaining(SeedSet<TValue, TSeedSpec, TScoreSpec, TSpec> const &source, TTargetContainer &result, TScore gapCost);       	// "projects/library/seqan/seeds/global_seed_chain.h"(250)

//____________________________________________________________________________
// goNext

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& goNext(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(222)

//____________________________________________________________________________
// insertTriple

template <typename TValue, typename TChainElement> void insertTriple(Map<Pair<TValue, TChainElement*> > &list, TChainElement* pElement);       	// "projects/library/seqan/seeds/global_seed_chain.h"(272)

//____________________________________________________________________________
// leftDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition leftDiagonal(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(410)

//____________________________________________________________________________
// leftDim0

template <typename TPosition> inline TPosition leftDim0(Seed<TPosition, ChainedSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(109)
template <typename TPosition, typename TSpecSeed> inline TPosition leftDim0(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(338)

//____________________________________________________________________________
// leftDim1

template <typename TPosition> inline TPosition leftDim1(Seed<TPosition, ChainedSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(125)
template <typename TPosition, typename TSpecSeed> inline TPosition leftDim1(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(374)

//____________________________________________________________________________
// leftPosition

template <typename TPosition, typename TSpecSeed, typename TSize> inline TPosition leftPosition(Seed<TPosition, TSpecSeed> & me, TSize dim);       	// "projects/library/seqan/seeds/seed_base.h"(239)

//____________________________________________________________________________
// length

template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const & me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(248)
template <typename TPosition> inline TPosition length(Seed<TPosition, ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(140)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline int length(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(339)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline int length(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(347)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(PropertyMap<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/seeds/propertyMap.h"(204)
template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type length(MemoryManager<TValue, Block<SPACE>, TFree > const & me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(255)
template <typename TPosition, typename TSpecSeed> inline TPosition length(Seed<TPosition, TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(437)

//____________________________________________________________________________
// maximumDistance

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline TValue maximumDistance(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(433)

//____________________________________________________________________________
// obtainID

template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type obtainID(MemoryManager<TValue,Block<SPACE>,FreeMemoryInt > &manager);       	// "projects/library/seqan/seeds/memoryManager_int.h"(299)
template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type obtainID(MemoryManager<TValue,Block<SPACE>,TFree > &manager);       	// "projects/library/seqan/seeds/memoryManager_base.h"(328)

//____________________________________________________________________________
// operator!=

template <typename TSeedSet> inline bool operator!=(Iter<TSeedSet, SeedIterator > it1, Iter<TSeedSet, SeedIterator > it2);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(274)

//____________________________________________________________________________
// operator*

template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> const>::Type operator* (Iter<TSeedSet, SeedIterator> & me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(258)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet const, SeedIterator> const>::Type operator* (Iter<TSeedSet const, SeedIterator> & me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(266)

//____________________________________________________________________________
// operator++

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& operator++(Iter<TSeedSet, SeedIterator > &me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(213)

//____________________________________________________________________________
// operator--

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& operator--(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(231)

//____________________________________________________________________________
// qualityValue

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline TValue qualityValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(451)

//____________________________________________________________________________
// raiseMemory

template <typename TValue, unsigned int SPACE> void raiseMemory(PropertyMap<TValue,Block<SPACE> > &manager);       	// "projects/library/seqan/seeds/propertyMap.h"(227)

//____________________________________________________________________________
// releaseID

template <typename TValue, unsigned int SPACE, typename TPosition> void releaseID(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, TPosition pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(288)
template <typename TValue, unsigned int SPACE, typename TFree, typename TPosition> void releaseID(MemoryManager<TValue,Block<SPACE>, TFree > &manager, TPosition pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(307)

//____________________________________________________________________________
// rightDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition rightDiagonal(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(428)

//____________________________________________________________________________
// rightDim0

template <typename TPosition> inline TPosition rightDim0(Seed<TPosition, ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(117)
template <typename TPosition, typename TSpecSeed> inline TPosition rightDim0(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(356)

//____________________________________________________________________________
// rightDim1

template <typename TPosition> inline TPosition rightDim1(Seed<TPosition, ChainedSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(132)
template <typename TPosition, typename TSpecSeed> inline TPosition rightDim1(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(392)

//____________________________________________________________________________
// rightPosition

template <typename TPosition, typename TSpecSeed, typename TSize> inline TPosition rightPosition(Seed<TPosition, TSpecSeed> & me, TSize dim);       	// "projects/library/seqan/seeds/seed_base.h"(282)

//____________________________________________________________________________
// scoreSeed

template <typename TPosition, typename TText, typename TScore> TScore scoreSeed(Seed<TPosition, ChainedSeed> &seed, String<TText> &query, String<TText> &database, Score<TScore, Simple> &matrix);       	// "projects/library/seqan/seeds/seed_multi.h"(730)

//____________________________________________________________________________
// seedScore

template <typename TSeedSet> inline typename ScoreType<typename ScoringScheme<TSeedSet>::Type>::Type & seedScore(Iter<TSeedSet, SeedIterator > it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(290)
template <typename TSeedSet> inline typename ScoreType<typename ScoringScheme<TSeedSet>::Type>::Type const& seedScore(Iter<TSeedSet const, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(300)

//____________________________________________________________________________
// setLeftDiagonal

template <typename TPosition, typename TSpecSeed> inline void setLeftDiagonal(Seed<TPosition, TSpecSeed> &me, TPosition diag);       	// "projects/library/seqan/seeds/seed_base.h"(533)

//____________________________________________________________________________
// setLeftDim0

template <typename TPosition> inline void setLeftDim0(Seed<TPosition, ChainedSeed> &seed, TPosition start);       	// "projects/library/seqan/seeds/seed_multi.h"(151)
template <typename TPosition, typename TSpecSeed> inline void setLeftDim0(Seed<TPosition, TSpecSeed> &me, TPosition start);       	// "projects/library/seqan/seeds/seed_base.h"(457)

//____________________________________________________________________________
// setLeftDim1

template <typename TPosition> inline void setLeftDim1(Seed<TPosition, ChainedSeed> &seed, TPosition start);       	// "projects/library/seqan/seeds/seed_multi.h"(174)
template <typename TPosition, typename TSpecSeed> inline void setLeftDim1(Seed<TPosition, TSpecSeed> &me, TPosition start);       	// "projects/library/seqan/seeds/seed_base.h"(495)

//____________________________________________________________________________
// setLeftPosition

template <typename TPosition, typename TSpecSeed, typename TSize, typename TPosition2> inline TPosition setLeftPosition(Seed<TPosition, TSpecSeed> & me, TSize dim, TPosition2 new_pos);       	// "projects/library/seqan/seeds/seed_base.h"(260)

//____________________________________________________________________________
// setMaximumDistance

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void setMaximumDistance(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set, TValue distance);       	// "projects/library/seqan/seeds/seedSet_base.h"(395)

//____________________________________________________________________________
// setQualityValue

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void setQualityValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set, TValue value);       	// "projects/library/seqan/seeds/seedSet_base.h"(415)

//____________________________________________________________________________
// setRightDiagonal

template <typename TPosition, typename TSpecSeed> inline void setRightDiagonal(Seed<TPosition,TSpecSeed> & seed, TPosition diag);       	// "projects/library/seqan/seeds/seed_base.h"(552)

//____________________________________________________________________________
// setRightDim0

template <typename TPosition> inline void setRightDim0(Seed<TPosition,ChainedSeed> & seed, TPosition end);       	// "projects/library/seqan/seeds/seed_multi.h"(164)
template <typename TPosition, typename TSpecSeed> inline void setRightDim0(Seed<TPosition,TSpecSeed> & me, TPosition end);       	// "projects/library/seqan/seeds/seed_base.h"(476)

//____________________________________________________________________________
// setRightDim1

template <typename TPosition> inline void setRightDim1(Seed<TPosition,ChainedSeed> & seed, TPosition end);       	// "projects/library/seqan/seeds/seed_multi.h"(187)
template <typename TPosition, typename TSpecSeed> inline void setRightDim1(Seed<TPosition,TSpecSeed> & me, TPosition end);       	// "projects/library/seqan/seeds/seed_base.h"(514)

//____________________________________________________________________________
// setRightPosition

template <typename TPosition, typename TSpecSeed, typename TSize, typename TPosition2> inline TPosition setRightPosition(Seed<TPosition, TSpecSeed> & me, TSize dim, TPosition2 new_pos);       	// "projects/library/seqan/seeds/seed_base.h"(304)

//____________________________________________________________________________
// setScore

template <typename TSeedSet, typename TSize> void setScore(Iter<TSeedSet, SeedIterator > &it, TSize score);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(308)

//____________________________________________________________________________
// setScoreMatrix

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline void setScoreMatrix(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Score<int,Simple> matrix);       	// "projects/library/seqan/seeds/seedSet_score.h"(295)

//____________________________________________________________________________
// startDiagonal

template <typename TPosition> inline TPosition startDiagonal(Seed<TPosition, ChainedSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(94)
template <typename TPosition, typename TSpecSeed> inline TPosition startDiagonal(Seed<TPosition, TSpecSeed> const &me);       	// "projects/library/seqan/seeds/seed_base.h"(200)

//____________________________________________________________________________
// value

template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt >& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(209)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(220)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> >::Type value(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(240)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> const>::Type value(Iter<TSeedSet, SeedIterator> const &me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(248)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( PropertyMap<TValue, Block<SPACE> >& stack, TPos const pos);       	// "projects/library/seqan/seeds/propertyMap.h"(165)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( PropertyMap<TValue, Block<SPACE> > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/propertyMap.h"(176)
template <typename TValue, unsigned int SPACE, typename TFree, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, TFree >& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(217)
template <typename TValue, unsigned int SPACE, typename TFree, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value(MemoryManager<TValue, Block<SPACE>, TFree > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(227)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

