// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_CHAINING_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_CHAINING_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ChainGenericEntry_

template <typename TPos, typename TWeight> struct ChainGenericEntry_;       	// "projects/library/seqan/chaining/chain_generic.h"(43)

//____________________________________________________________________________
// ChainGenericSortFragsPredFunctional_

template <typename TSource> struct ChainGenericSortFragsPredFunctional_;       	// "projects/library/seqan/chaining/chain_generic.h"(53)

//____________________________________________________________________________
// Complete

struct Complete;       	// "projects/library/seqan/chaining/skip_list_type.h"(150)

//____________________________________________________________________________
// Deferred

struct Deferred;       	// "projects/library/seqan/chaining/skip_list_type.h"(152)

//____________________________________________________________________________
// EmptyCargo_

struct EmptyCargo_;       	// "projects/library/seqan/chaining/skip_list_type.h"(133)

//____________________________________________________________________________
// Pair

template <typename T1_, typename T2_, typename Compressed > struct Pair;       	// "projects/library/seqan/chaining/skip_list_type.h"(62)

//____________________________________________________________________________
// SkipBaseElement

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipBaseElement;       	// "projects/library/seqan/chaining/skip_list_type.h"(163)

//____________________________________________________________________________
// SkipElement

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_list_type.h"(160)

//____________________________________________________________________________
// SkipList

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/skip_list_type.h"(166)

//____________________________________________________________________________
// SkipListDynamic

struct SkipListDynamic;       	// "projects/library/seqan/chaining/skip_list_type.h"(146)

//____________________________________________________________________________
// SkipListStatic

struct SkipListStatic;       	// "projects/library/seqan/chaining/skip_list_type.h"(148)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// ChainPoint_

template <typename T, typename TSpec > struct ChainPoint_;       	// "projects/library/seqan/chaining/chain_base.h"(60)
template <typename TFragType, typename TSpec > struct ChainPoint_;       	// "projects/library/seqan/chaining/chain_point.h"(191)

//____________________________________________________________________________
// ChainSoP

struct ChainSoP;       	// "projects/library/seqan/chaining/score_chain.h"(46)

//____________________________________________________________________________
// ChainSorter_

template <typename T > struct ChainSorter_;       	// "projects/library/seqan/chaining/tree_chain_utils.h"(302)

//____________________________________________________________________________
// ChainSpecType_

template <typename Spec > struct ChainSpecType_;       	// "projects/library/seqan/chaining/chain_base.h"(101)

//____________________________________________________________________________
// ClassPool

template <typename TClass, typename TType, typename TParentAllocator > struct ClassPool;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(75)

//____________________________________________________________________________
// Complete

struct Complete;       	// "projects/library/seqan/chaining/rt_base.h"(59)

//____________________________________________________________________________
// Deferred

struct Deferred;       	// "projects/library/seqan/chaining/rt_base.h"(62)

//____________________________________________________________________________
// DeferredStruct_

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct DeferredStruct_;       	// "projects/library/seqan/chaining/skip_base_element.h"(110)

//____________________________________________________________________________
// DynamicStruct_

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct DynamicStruct_;       	// "projects/library/seqan/chaining/skip_base_element.h"(82)

//____________________________________________________________________________
// GInftyCost

struct GInftyCost;       	// "projects/library/seqan/chaining/chain_base.h"(92)

//____________________________________________________________________________
// GOneCost

struct GOneCost;       	// "projects/library/seqan/chaining/chain_base.h"(88)

//____________________________________________________________________________
// GSumOfPairCost

struct GSumOfPairCost;       	// "projects/library/seqan/chaining/chain_base.h"(96)

//____________________________________________________________________________
// GZeroCost

struct GZeroCost;       	// "projects/library/seqan/chaining/chain_base.h"(84)

//____________________________________________________________________________
// GenericChaining_

struct GenericChaining_;       	// "projects/library/seqan/chaining/chain_base.h"(76)

//____________________________________________________________________________
// Limited

struct Limited;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(54)

//____________________________________________________________________________
// MaxTree

template <typename TSpec > struct MaxTree;       	// "projects/library/seqan/chaining/rmt_base.h"(73)

//____________________________________________________________________________
// MetaFragment_

template <typename T > struct MetaFragment_;       	// "projects/library/seqan/chaining/chain_base.h"(68)
template <typename TFragType > struct MetaFragment_;       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(160)

//____________________________________________________________________________
// MultiSeed

struct MultiSeed;       	// "projects/library/seqan/chaining/fragment.h"(59)

//____________________________________________________________________________
// RT

template <typename TSpec > struct RT;       	// "projects/library/seqan/chaining/rt_base.h"(52)

//____________________________________________________________________________
// RangeCargo_

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct RangeCargo_;       	// "projects/library/seqan/chaining/rt_skip_element.h"(47)

//____________________________________________________________________________
// RangeMaxCargo_

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct RangeMaxCargo_;       	// "projects/library/seqan/chaining/rmt_skip_element.h"(43)

//____________________________________________________________________________
// RangeTree

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > class RangeTree;       	// "projects/library/seqan/chaining/rmt_base.h"(76)
template <typename TObject, typename TModus, typename TSpec , typename TStructuring > class RangeTree;       	// "projects/library/seqan/chaining/rt_base.h"(69)

//____________________________________________________________________________
// RangeTreeAllocators

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct RangeTreeAllocators;       	// "projects/library/seqan/chaining/rt_base.h"(93)

//____________________________________________________________________________
// RangeTreeChaining_

struct RangeTreeChaining_;       	// "projects/library/seqan/chaining/chain_base.h"(79)

//____________________________________________________________________________
// SearchPath_

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SearchPath_;       	// "projects/library/seqan/chaining/skip_list_base.h"(90)

//____________________________________________________________________________
// SemiDeferred

struct SemiDeferred;       	// "projects/library/seqan/chaining/rt_base.h"(56)

//____________________________________________________________________________
// SkipBaseElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipBaseElement;       	// "projects/library/seqan/chaining/skip_base_element.h"(821)

//____________________________________________________________________________
// SkipElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_element.h"(66)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_element.h"(367)

//____________________________________________________________________________
// SkipList

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/skip_list_impl.h"(424)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/rt_base.h"(66)

//____________________________________________________________________________
// Unlimited

struct Unlimited;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(51)

//____________________________________________________________________________
// Weight

template <typename T > struct Weight;       	// "projects/library/seqan/chaining/rmt_base.h"(103)

//____________________________________________________________________________
// WrapperPoint_

template <typename T > struct WrapperPoint_;       	// "projects/library/seqan/chaining/chain_base.h"(64)
template <typename TFragType > struct WrapperPoint_;       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(154)

//____________________________________________________________________________
// Zero

struct Zero;       	// "projects/library/seqan/chaining/score_chain.h"(44)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// GenericChaining

typedef Tag<GenericChaining_> const GenericChaining;       	// "projects/library/seqan/chaining/chain_base.h"(77)

//____________________________________________________________________________
// RangetreeChaining

typedef Tag<RangeTreeChaining_> const RangetreeChaining;       	// "projects/library/seqan/chaining/chain_base.h"(80)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _chainGenericChainable

template <typename TFrag> inline bool _chainGenericChainable(TFrag & f1, TFrag & f2);       	// "projects/library/seqan/chaining/chain_generic.h"(119)

//____________________________________________________________________________
// _chainGenericFindBest

template <typename TSource, typename TFrags, typename TIterator, typename TScoring> inline void _chainGenericFindBest(TSource & source, TFrags & frags, TIterator & it_act, TScoring scoring);       	// "projects/library/seqan/chaining/chain_generic.h"(143)

//____________________________________________________________________________
// _chainGenericInitFrags

template <typename TSource, typename TFrags, typename TScoring> inline void _chainGenericInitFrags(TSource & source, TFrags & frags, TScoring scoring);       	// "projects/library/seqan/chaining/chain_generic.h"(89)

//____________________________________________________________________________
// _chainGenericTraceback

template <typename TSource, typename TFrags, typename TIterator, typename TDest, typename TFragment> inline void _chainGenericTraceback(TSource & source, TFrags & frags, TIterator & it_best, TDest & dest, TFragment & bottom);       	// "projects/library/seqan/chaining/chain_generic.h"(175)

//____________________________________________________________________________
// _initCargo

template <typename TTag, typename TCargo > inline void _initCargo( TTag * , TCargo & );       	// "projects/library/seqan/chaining/skip_list_type.h"(386)

//____________________________________________________________________________
// getValue

template <typename TKey, typename TVal > inline TVal & getValue( Pair<TKey, TVal> & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(75)

//____________________________________________________________________________
// globalChaining

template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type globalChaining(TSource & source, TDest & dest, TScoring const & scoring, GenericChaining);       	// "projects/library/seqan/chaining/chain_generic.h"(207)

//____________________________________________________________________________
// key

template <typename TKey, typename TVal > inline TKey & key( Pair<TKey, TVal> & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(69)
template <typename TKey, typename TVal > inline TKey key( std::pair< TKey, TVal > & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(100)

//____________________________________________________________________________
// setKey

template <typename TKey2, typename TVal > void setKey( Pair<TKey2, TVal> & p, TKey2 theKey);       	// "projects/library/seqan/chaining/skip_list_type.h"(81)
template <typename TKey, typename TVal > void setKey( std::pair<TKey, TVal> & p, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_type.h"(106)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _activate

template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void _activate( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TObject * obj, TSize dim );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(164)

//____________________________________________________________________________
// _activateHigherLayer

template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void _activateHigherLayer( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TObject * obj, TSize dim );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(134)

//____________________________________________________________________________
// _activatePriority

template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _activatePriority( MetaFragment_< FragType > &, ChainPoint_< FragType, SpecType > &, GZeroCost, TScore const &, TSize );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(228)
template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _activatePriority( MetaFragment_< FragType > & last_meta, ChainPoint_< FragType, SpecType > & point, GOneCost, TScore const & score_, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(240)

//____________________________________________________________________________
// _activateScoreBuild

template <typename TObject, typename TSpec, typename TStructuring > inline void _activateScoreBuild( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** search_path );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(75)

//____________________________________________________________________________
// _add

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename THeight > inline void _add( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, THeight height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path );       	// "projects/library/seqan/chaining/skip_list_base.h"(839)

//____________________________________________________________________________
// _addMax

template <typename TObject, typename TSpec, typename TStructuring, typename THeight > inline void _addMax( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, THeight height, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(313)

//____________________________________________________________________________
// _beginDefault

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > , Standard >::Type _beginDefault( SkipList< TObject, TModus, TSpec, TStructuring > & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(145)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > , Standard >::Type _beginDefault( SkipList< TObject, TModus, TSpec, TStructuring > const & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(154)

//____________________________________________________________________________
// _bottomSearch

template <typename TObject, typename TModus, typename TSpec, typename TResultSet > void _bottomSearch( SkipList< TObject, TModus, RT< TSpec >, Deferred > * list, TObject * left_border, TObject * right_border, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(111)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet > void _bottomSearch( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(143)

//____________________________________________________________________________
// _buildAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TSize dim );       	// "projects/library/seqan/chaining/rt_skip_element.h"(107)

//____________________________________________________________________________
// _buildAssocStruct_left

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct_left( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * left, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(345)

//____________________________________________________________________________
// _buildAssocStruct_right

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct_right( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * left, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(360)

//____________________________________________________________________________
// _buildChainEnvironment

template <typename FragType, typename TSource, typename TMetas, typename TWPoints, typename TCPoints, typename TSpec > inline void _buildChainEnvironment( TSource & source, TMetas & metas, TWPoints & wPoints, TCPoints & cPoints, FragType & startingFrag, FragType & endFrag, TSpec );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(392)
template <typename FragType, typename TSource, typename TMetas, typename TWPoints, typename TPoints, typename TPerm, typename TSpec > inline void _buildChainEnvironment( TSource & source, TMetas & metas, TWPoints & wPoints, TPoints & tPoints, FragType & startingFrag, FragType & endFrag, TPerm & perm, typename Size< FragType >::Type fac, TSpec &);       	// "projects/library/seqan/chaining/tree_chain_utils.h"(459)

//____________________________________________________________________________
// _buildChainTrees

template <typename TTrees, typename TTPoints, typename TSize > void _buildChainTrees( TTrees & trees, TTPoints & tPoints, TSize dim, TSize facValue );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(539)

//____________________________________________________________________________
// _buildMaxTowers

template <typename TObject, typename TSpec, typename TStructuring > void _buildMaxTowers( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(260)

//____________________________________________________________________________
// _buildTowers

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > void _buildTowers( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(486)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > void _buildTowers( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(68)

//____________________________________________________________________________
// _calcPivot

template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _calcPivot( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & base );       	// "projects/library/seqan/chaining/skip_list_base.h"(255)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * _calcPivot( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > & base );       	// "projects/library/seqan/chaining/skip_list_base.h"(273)

//____________________________________________________________________________
// _chainTrace

template <typename TDest, typename TMetas > typename Weight< typename Value< TDest >::Type >::Type _chainTrace( TDest & dest, TMetas & metas );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(338)

//____________________________________________________________________________
// _chainTransformCoords

template <typename FragType, typename SpecType, typename TPerm > inline void _chainTransformCoords( ChainPoint_< FragType, SpecType > & point_src, ChainPoint_< FragType, SpecType > & point_dst, TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(136)

//____________________________________________________________________________
// _chainTransformCoordsSearch

template <typename FragType, typename SpecType, typename TPerm > inline void _chainTransformCoordsSearch( ChainPoint_< FragType, SpecType > & point_src, ChainPoint_< FragType, SpecType > & point_dst, TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(154)

//____________________________________________________________________________
// _checkAssocThresh

template <typename TObject, typename TSpec, typename TStructuring > inline bool _checkAssocThresh( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * first, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * second );       	// "projects/library/seqan/chaining/rmt_base.h"(205)
template <typename TObject, typename TSpec, typename TStructuring > inline bool _checkAssocThresh( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * first, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * second );       	// "projects/library/seqan/chaining/rt_base.h"(138)

//____________________________________________________________________________
// _checkBaseElementsLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _checkBaseElementsLeft( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * left_border, TObject * right_border, TSize dim, TKey left_theKey, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(132)

//____________________________________________________________________________
// _checkBaseElementsLeftBottom

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _checkBaseElementsLeftBottom( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * , TObject * , TKey left_theKey, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(165)

//____________________________________________________________________________
// _checkBaseElementsRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline void _checkBaseElementsRight( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * left_border, TObject * right_border, TSize dim, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(197)

//____________________________________________________________________________
// _clearSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _clearSearchPath( SearchPath_< TObject, TModus, TSpec, TStructuring > & sp, TSize size );       	// "projects/library/seqan/chaining/skip_list_base.h"(127)

//____________________________________________________________________________
// _collectAssocStructs

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _collectAssocStructs( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * tower_buffer, TObject * left_border, TObject * right_border, TSize dim, TKey search_theKey, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(104)

//____________________________________________________________________________
// _completeBuild

template <typename TObject, typename TSpec, typename TStructuring > inline void _completeBuild( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, typename Size< TObject >::Type dim );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(61)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _completeBuild( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(519)
template <typename TObject, typename TModus, typename TSpec > inline void _completeBuild( SkipList< TObject, TModus, TSpec, Deferred > & );       	// "projects/library/seqan/chaining/skip_list_base.h"(529)
template <typename TObject, typename TSpec > inline void _completeBuild( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Deferred > & list, typename Size< TObject >::Type dim );       	// "projects/library/seqan/chaining/rmt_def_algos.h"(51)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _completeBuild( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, TSize dim );       	// "projects/library/seqan/chaining/rt_common_algos.h"(51)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _completeBuild( SkipList< TObject, TModus, RT< TSpec >, Deferred > & , TSize );       	// "projects/library/seqan/chaining/rt_common_algos.h"(61)

//____________________________________________________________________________
// _computeChain

template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring, typename TSpec > TScoreValue _computeChain( TSource & source, TDest & dest, GSumOfPairCost, Score< TScoreValue, TScoreType > const & score_, TStructuring, TSpec spec );       	// "projects/library/seqan/chaining/tree_chain_sop.h"(51)
template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring, typename TCostModell, typename TSpec > TScoreValue _computeChain( TSource & source, TDest & dest, TCostModell cost, Score< TScoreValue, TScoreType > const & score_, TStructuring, TSpec spec );       	// "projects/library/seqan/chaining/tree_chain.h"(51)

//____________________________________________________________________________
// _connect

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TSize > inline void _connect( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TSize height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(817)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect( SkipList< TObject, TModus, RT< TSpec >, Deferred > & , SkipBaseElement< TObject, TModus, RT< TSpec >, Deferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Deferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(269)

//____________________________________________________________________________
// _connectUpdate

template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connectUpdate( SkipList< TObject, TModus, RT< MaxTree< TSpec > >, Complete > & list, SkipBaseElement< TObject, TModus, RT< MaxTree< TSpec > >, Complete > * base, TSize height, SkipElement< TObject, TModus, RT< MaxTree< TSpec > >, Complete > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(103)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TSize > inline void _connectUpdate( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TSize height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(794)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connectUpdate( SkipList< TObject, TModus, RT< TSpec >, Deferred > & , SkipBaseElement< TObject, TModus, RT< TSpec >, Deferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Deferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(245)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connectUpdate( SkipList< TObject, TModus, RT< TSpec >, SemiDeferred > & , SkipBaseElement< TObject, TModus, RT< TSpec >, SemiDeferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, SemiDeferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(291)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connectUpdate( SkipList< TObject, TModus, RT< TSpec >, Complete > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, Complete > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Complete > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(316)

//____________________________________________________________________________
// _connectUpdateMax

template <typename TObject, typename TSpec, typename TStructuring, typename TSize, typename TKey > void _connectUpdateMax( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, TSize height, TKey searchKey, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** search_path, TObject * max_obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(231)

//____________________________________________________________________________
// _costGOne

template <typename FragType, typename TScore, typename TSize > typename Weight< FragType >::Type _costGOne( MetaFragment_< FragType > & upper, MetaFragment_< FragType > & lower, TScore const & score, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(252)

//____________________________________________________________________________
// _costGSoP

template <typename FragType, typename TItPerm, typename TScoreValue, typename TScoreType, typename TSize > typename Weight< FragType >::Type _costGSoP( MetaFragment_< FragType > & upper, MetaFragment_< FragType > & lower, Score< TScoreValue, TScoreType > const & score, TItPerm permBeg, TItPerm, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(272)

//____________________________________________________________________________
// _create

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TContainer, typename TSize > void _create( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, TContainer & data, RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & Tree, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(123)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > void _create( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * first, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * last, RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & Tree, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(148)

//____________________________________________________________________________
// _createAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _createAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TSize dim );       	// "projects/library/seqan/chaining/rt_skip_element.h"(183)

//____________________________________________________________________________
// _deleteAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _deleteAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(136)

//____________________________________________________________________________
// _deleteBase

template <typename TObject, typename TSpec, typename TStructuring > void _deleteBase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& base );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(354)

//____________________________________________________________________________
// _deleteChainTrees

template <typename TTrees, typename TSize > void _deleteChainTrees( TTrees & trees, TSize facValue );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(556)

//____________________________________________________________________________
// _deleteSearchFrom

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _deleteSearchFrom( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, typename Key< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type theKey, SkipElement< TObject, SkipListDynamic, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(269)

//____________________________________________________________________________
// _deleteTower

template <typename TObject, typename TSpec, typename TStructuring > void _deleteTower( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipElement< TObject, SkipListDynamic, TSpec, TStructuring > ** search_path, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * base, typename Size< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type height );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(330)

//____________________________________________________________________________
// _endDefault

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring >, Standard>::Type _endDefault( SkipList< TObject, TModus, TSpec, TStructuring > & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(184)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > const, Standard>::Type _endDefault( SkipList< TObject, TModus, TSpec, TStructuring > const & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(192)

//____________________________________________________________________________
// _findTowerTop

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet, typename TSize, typename TKey > inline SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * _findTowerTop( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base_buffer, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TKey theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(81)

//____________________________________________________________________________
// _fingerSearch

template <typename TObject, typename TModus, typename TSpec, typename TResultSet, typename TSize > void _fingerSearch( SkipList< TObject, TModus, RT< TSpec >, Deferred > * list, TObject * left_border, TObject * right_border, TSize dim, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(67)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet, typename TSize > void _fingerSearch( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(115)

//____________________________________________________________________________
// _geomRand

template <typename T > inline T _geomRand( );       	// "projects/library/seqan/chaining/geom_distribution.h"(56)

//____________________________________________________________________________
// _getAssoc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, TSpec, TStructuring > * _getAssoc( RangeMaxCargo_< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(58)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, TSpec, TStructuring > * _getAssoc( RangeCargo_< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(60)

//____________________________________________________________________________
// _getAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, RT< TSpec >, TStructuring > * _getAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(87)

//____________________________________________________________________________
// _getBaseAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipBaseElement< TObject, TModus, TSpec, TStructuring >, Unlimited, SimpleAllocator> > & _getBaseAlloc( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(337)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< SimpleAlloc<> > & _getBaseAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(213)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< SimpleAlloc<> > & _getBaseAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(101)

//____________________________________________________________________________
// _getBaseStore

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getBaseStore( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(379)

//____________________________________________________________________________
// _getCount

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getCount( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(774)

//____________________________________________________________________________
// _getCurrentLayer

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getCurrentLayer( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(398)

//____________________________________________________________________________
// _getDown

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getDown( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(129)

//____________________________________________________________________________
// _getElementAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, TSpec, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(327)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, RT< TSpec >, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(197)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, RT< TSpec >, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(84)

//____________________________________________________________________________
// _getFrag

template <typename TFragType > inline TFragType & _getFrag( WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(80)
template <typename TFragType > inline TFragType & _getFrag( const WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(90)
template <typename TFragType, typename TSpec > inline TFragType & _getFrag( ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(114)
template <typename TFragType, typename TSpec > inline TFragType & _getFrag( const ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(122)
template <typename TFragType > inline TFragType & _getFrag( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(105)
template <typename TFragType > inline TFragType & _getFrag( const MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(112)

//____________________________________________________________________________
// _getHeight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline typename Size< SkipElement< TObject, TModus, TSpec, TStructuring > >::Type _getHeight( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(237)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getHeight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(698)

//____________________________________________________________________________
// _getInitialState

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _getInitialState( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(158)

//____________________________________________________________________________
// _getLBorderObj

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * _getLBorderObj( RangeTree< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(223)

//____________________________________________________________________________
// _getLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getLeft( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(534)
template <typename TObject, typename TModus, typename TSpec > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _getLeft( SkipBaseElement< TObject, TModus, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(542)

//____________________________________________________________________________
// _getLeftSideStore

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getLeftSideStore( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(369)

//____________________________________________________________________________
// _getList

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, RT< TSpec >, TStructuring > * _getList( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(241)

//____________________________________________________________________________
// _getListAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipList< TObject, TModus, RT< TSpec >, TStructuring >, Unlimited, SimpleAllocator > > & _getListAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(205)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipList< TObject, TModus, RT< TSpec >, TStructuring >, Unlimited, SimpleAllocator > > & _getListAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(93)

//____________________________________________________________________________
// _getMaxObject

template <typename TObject, typename TSpec, typename TStructuring > inline TObject * _getMaxObject( RangeMaxCargo_< TObject, SkipListStatic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(76)
template <typename TObject,typename TSpec, typename TStructuring > inline TObject * _getMaxObject( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(91)

//____________________________________________________________________________
// _getMaximalSLTowerHeight

template <typename TNumber > inline TNumber _getMaximalSLTowerHeight( TNumber elements );       	// "projects/library/seqan/chaining/skip_list_base.h"(190)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getMaximalSLTowerHeight( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_base.h"(199)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, RT< TSpec >, TStructuring > >::Type _getMaximalSLTowerHeight( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & rt );       	// "projects/library/seqan/chaining/rt_base.h"(330)

//____________________________________________________________________________
// _getNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getNext( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(193)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(668)

//____________________________________________________________________________
// _getNextBlock

template <typename TClass, typename TSpec, typename TParentAlloc > inline TClass * _getNextBlock( Allocator< ClassPool< TClass, TSpec, TParentAlloc > > & , TClass & block );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(102)

//____________________________________________________________________________
// _getPerm

template <typename TData, typename TItPerm, typename TSize > inline void _getPerm( TData * values, TItPerm perm, TSize length );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(91)

//____________________________________________________________________________
// _getPermDifference

template <typename TData, typename TSize, typename FragType > void _getPermDifference( TData * values, TSize dim, FragType & upper, FragType & lower );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(119)

//____________________________________________________________________________
// _getPred

template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * _getPred( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(464)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _getPred( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(472)
template <typename TFragType > inline MetaFragment_< TFragType > & _getPred( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(120)
template <typename TFragType > inline MetaFragment_< TFragType > & _getPred( const MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(127)

//____________________________________________________________________________
// _getRBorderObj

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * _getRBorderObj( RangeTree< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(232)

//____________________________________________________________________________
// _getRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getRight(SkipElement< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_element.h"(103)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getRight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(590)
template <typename TObject, typename TSpec > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * _getRight( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(599)
template <typename TObject, typename TSpec > inline SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > * _getRight( SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(607)

//____________________________________________________________________________
// _getRightBorder

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getRightBorder( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(359)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > * _getRightBorder( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(63)

//____________________________________________________________________________
// _getRoot

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getRoot( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(318)

//____________________________________________________________________________
// _getSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > ** _getSearchPath( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(388)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > ** _getSearchPath( SearchPath_< TObject, TModus, TSpec, TStructuring > & sp );       	// "projects/library/seqan/chaining/skip_list_base.h"(118)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline SkipElement< TObject, TModus, RT< TSpec >, TStructuring > ** _getSearchPath( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, TParam dim );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(46)

//____________________________________________________________________________
// _getSucc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getSucc( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(386)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _getSucc( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(394)

//____________________________________________________________________________
// _getUp

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > & _getUp( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(365)

//____________________________________________________________________________
// _hasAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(155)

//____________________________________________________________________________
// _hasBigAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasBigAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(171)

//____________________________________________________________________________
// _hasSmallAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasSmallAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(163)

//____________________________________________________________________________
// _incKey

template <typename TFragType, typename TSpec, typename TSize > inline void _incKey( ChainPoint_< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(105)

//____________________________________________________________________________
// _initBases

template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListStatic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(919)
template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(949)
template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(173)

//____________________________________________________________________________
// _initPerm

template <typename TPerm, typename TSize > inline void _initPerm( TPerm & perm, TSize length );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(63)

//____________________________________________________________________________
// _initSL

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _initSL( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * first_base, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(982)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _initSL( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * first_base, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * , TSize numEntries, TSize );       	// "projects/library/seqan/chaining/rt_sl_base.h"(201)

//____________________________________________________________________________
// _initStartingFrag

template <typename FragType, typename TSize > inline void _initStartingFrag( FragType & frag, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(367)

//____________________________________________________________________________
// _insertBack

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > void _insertBack( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(169)

//____________________________________________________________________________
// _insertInPlace

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > void _insertInPlace( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(193)

//____________________________________________________________________________
// _isBegin

template <typename TFragType > inline bool _isBegin( WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(133)
template <typename TFragType > inline bool _isBegin( const WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(140)

//____________________________________________________________________________
// _isEnd

template <typename TFragType > inline bool _isEnd( WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(119)
template <typename TFragType > inline bool _isEnd( const WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(126)

//____________________________________________________________________________
// _maxPriority

template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _maxPriority( MetaFragment_< FragType > & , MetaFragment_< FragType > & current_meta, ChainPoint_< FragType, SpecType > & point, GZeroCost, TScore const &, TSize );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(189)
template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _maxPriority( MetaFragment_< FragType > &, MetaFragment_< FragType > & current_meta, ChainPoint_< FragType, SpecType > & point, GOneCost, TScore const & score_, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(203)

//____________________________________________________________________________
// _meta

template <typename TFragType > inline MetaFragment_< TFragType > & _meta( WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(100)
template <typename TFragType, typename TSpec > inline MetaFragment_< TFragType > & _meta( ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(131)
template <typename TFragType, typename TSpec > inline MetaFragment_< TFragType > & _meta( const ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(138)

//____________________________________________________________________________
// _noInitialState

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _noInitialState( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(166)

//____________________________________________________________________________
// _performDestructorAction

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _performDestructorAction( SkipElement< TObject, TModus, TSpec, TStructuring > & );       	// "projects/library/seqan/chaining/skip_element.h"(302)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _performDestructorAction( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(235)

//____________________________________________________________________________
// _performRMQ

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(135)
template <typename TObject, typename TSpec, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Complete > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(180)
template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TBorder & , typename Key< TObject >::Type searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(222)
template <typename TObject, typename TSpec, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Deferred > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_def_algos.h"(77)

//____________________________________________________________________________
// _performSmallRMQ

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > inline void _performSmallRMQ( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * elem, typename Size< TObject >::Type dim, TBorder & border, TObject *& max_object );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(267)

//____________________________________________________________________________
// _processRMQ

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > inline void _processRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, typename Size< TObject >::Type dim, TBorder & borderObj, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(86)

//____________________________________________________________________________
// _pushBack

template <typename TTarget, typename TSource > inline void _pushBack( TTarget & target, TSource const & source );       	// "projects/library/seqan/chaining/rt_base.h"(146)

//____________________________________________________________________________
// _renewConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(442)
template <typename TObject, typename TSpec, typename TSize > inline void _renewConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & elem, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(455)

//____________________________________________________________________________
// _renewDynConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , TSize , TSize );       	// "projects/library/seqan/chaining/skip_list_base.h"(403)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, TModus, TSpec, Deferred > & elem, SkipBaseElement< TObject, TModus, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(412)
template <typename TObject, typename TSpec, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & elem, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(425)

//____________________________________________________________________________
// _renewLeftTower

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > void _renewLeftTower( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(70)

//____________________________________________________________________________
// _renewSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewSearchPath( SkipList< TObject, TModus, TSpec, TStructuring > & list, TSize old_size, TSize new_size );       	// "projects/library/seqan/chaining/skip_list_base.h"(140)

//____________________________________________________________________________
// _resetPerm

template <typename TPerm > inline void _resetPerm( TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(74)

//____________________________________________________________________________
// _scanAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultsSet, typename TSize > inline void _scanAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TResultsSet & results );       	// "projects/library/seqan/chaining/rt_skip_element.h"(204)

//____________________________________________________________________________
// _searchFrom

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _searchFrom( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(547)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _searchFrom( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(600)

//____________________________________________________________________________
// _setAssoc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssoc( RangeMaxCargo_< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * list );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(66)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssoc( RangeCargo_< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * list);       	// "projects/library/seqan/chaining/rt_skip_element.h"(69)

//____________________________________________________________________________
// _setAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list );       	// "projects/library/seqan/chaining/rt_skip_element.h"(96)

//____________________________________________________________________________
// _setCount

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setCount( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TSize count );       	// "projects/library/seqan/chaining/skip_base_element.h"(794)

//____________________________________________________________________________
// _setCurrentLayer

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setCurrentLayer( SkipList< TObject, TModus, TSpec, TStructuring > & me, TSize layer );       	// "projects/library/seqan/chaining/skip_list_impl.h"(408)

//____________________________________________________________________________
// _setDefConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDefConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_list_base.h"(886)
template <typename TObject, typename TSpec > inline void _setDefConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * left, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(895)

//____________________________________________________________________________
// _setDeferredCounts

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDeferredCounts( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(105)
template <typename TObject, typename TModus, typename TSpec > inline void _setDeferredCounts( SkipList< TObject, TModus, TSpec, Deferred > & , SkipBaseElement< TObject, TModus, TSpec, Deferred > * preceding_elem, SkipBaseElement< TObject, TModus, TSpec, Deferred > * new_elem );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(114)

//____________________________________________________________________________
// _setDown

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setDown( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * down );       	// "projects/library/seqan/chaining/skip_element.h"(173)

//____________________________________________________________________________
// _setDynConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDynConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_list_base.h"(866)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setDynConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * pred, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_list_base.h"(875)

//____________________________________________________________________________
// _setHeight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setHeight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TSize height );       	// "projects/library/seqan/chaining/skip_base_element.h"(718)

//____________________________________________________________________________
// _setLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setLeft( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_base_element.h"(562)
template <typename TObject, typename TModus, typename TSpec > inline void _setLeft( SkipBaseElement< TObject, TModus, TSpec, Deferred > & me, SkipBaseElement< TObject, TModus, TSpec, Deferred > * left );       	// "projects/library/seqan/chaining/skip_base_element.h"(570)

//____________________________________________________________________________
// _setLeftPosition

template <typename TBorder, typename TSpec, typename TSize, typename TPosition > inline void _setLeftPosition( Seed< TBorder, TSpec > & me, TSize dim, TPosition value );       	// "projects/library/seqan/chaining/fragment.h"(317)

//____________________________________________________________________________
// _setLength

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setLength( SkipList< TObject, TModus, TSpec, TStructuring > & me, TSize num_elems );       	// "projects/library/seqan/chaining/skip_list_impl.h"(210)

//____________________________________________________________________________
// _setMaxInfty

template <typename TObject, typename TSize > inline void _setMaxInfty( TObject & me, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(176)

//____________________________________________________________________________
// _setMaxObject

template <typename TObject, typename TSpec, typename TStructuring > inline void _setMaxObject( RangeMaxCargo_< TObject, SkipListStatic, TSpec, TStructuring > & me, TObject * obj );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(84)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setMaxObject( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me, TObject * maxObj );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(99)

//____________________________________________________________________________
// _setMeta

template <typename TFragType > inline void _setMeta( WrapperPoint_< TFragType > & me, MetaFragment_< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(110)
template <typename TFragType, typename TSpec > inline void _setMeta( ChainPoint_< TFragType, TSpec > & me, MetaFragment_< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_point.h"(147)
template <typename TFragType, typename TSpec > inline void _setMeta( const ChainPoint_< TFragType, TSpec > & me, MetaFragment_< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_point.h"(155)

//____________________________________________________________________________
// _setMinInfty

template <typename TObject, typename TSize > inline void _setMinInfty( TObject & me, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(161)

//____________________________________________________________________________
// _setNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setNext( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_element.h"(217)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_base_element.h"(678)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setNext( SkipList< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_list_impl.h"(348)

//____________________________________________________________________________
// _setNextBlock

template <typename TClass, typename TSpec, typename TParentAlloc > inline void _setNextBlock( Allocator< ClassPool< TClass, TSpec, TParentAlloc > > & , TClass & dest, TClass * block );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(111)

//____________________________________________________________________________
// _setObject

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TObject * obj );       	// "projects/library/seqan/chaining/skip_base_element.h"(315)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * data );       	// "projects/library/seqan/chaining/skip_base_element.h"(325)

//____________________________________________________________________________
// _setPred

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setPred( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_base_element.h"(508)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setPred( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * goPrevious );       	// "projects/library/seqan/chaining/skip_base_element.h"(516)
template <typename TFragType > inline void _setPred( MetaFragment_< TFragType > & me, MetaFragment_< TFragType > & pred );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(136)
template <typename TFragType > inline void _setPred( const MetaFragment_< TFragType > & me, MetaFragment_< TFragType > & pred );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(144)

//____________________________________________________________________________
// _setRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setRight( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_element.h"(153)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setRight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_base_element.h"(644)
template <typename TObject, typename TSpec > inline void _setRight( SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > & , SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > * );       	// "projects/library/seqan/chaining/skip_base_element.h"(651)
template <typename TObject, typename TSpec > inline void _setRight( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * right );       	// "projects/library/seqan/chaining/skip_base_element.h"(659)

//____________________________________________________________________________
// _setRightPosition

template <typename TBorder, typename TSpec, typename TSize, typename TPosition > inline void _setRightPosition( Seed< TBorder, TSpec > & me, TSize dim, TPosition value );       	// "projects/library/seqan/chaining/fragment.h"(335)

//____________________________________________________________________________
// _setSucc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setSucc( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * );       	// "projects/library/seqan/chaining/skip_base_element.h"(431)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setSucc( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_base_element.h"(439)

//____________________________________________________________________________
// _setUp

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setUp( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > & up );       	// "projects/library/seqan/chaining/skip_base_element.h"(346)

//____________________________________________________________________________
// _sort

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _sort( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(296)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TExtraParam > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _sort( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right_border, TExtraParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(309)

//____________________________________________________________________________
// _sortEquals

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _sortEquals( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem );       	// "projects/library/seqan/chaining/skip_list_base.h"(345)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void _sortEquals( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , TKey );       	// "projects/library/seqan/chaining/skip_list_base.h"(355)
template <typename TObject, typename TModus, typename TSpec, typename TKey > void _sortEquals( SkipList< TObject, TModus, TSpec, Deferred > & , SkipBaseElement< TObject, TModus, TSpec, Deferred > * elem, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(364)

//____________________________________________________________________________
// _sortRecursive

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _sortRecursive( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(471)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _sortRecursive( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * elem, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(54)

//____________________________________________________________________________
// _specialSearch

template <typename TObject, typename TModus, typename TSpec, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _specialSearch( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipElement< TObject, TModus, TSpec, Deferred > * layer_element, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(641)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _specialSearch( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(653)

//____________________________________________________________________________
// _split

template <typename TObject, typename TModus, typename TSpec, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, Deferred > * _split( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * base, TKey theKey, SkipElement< TObject, TModus, TSpec, Deferred > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(740)

//____________________________________________________________________________
// _splitAction

template <typename TObject, typename TModus, typename TSpec, typename TParam, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _splitAction( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * base, TKey theKey, SkipElement< TObject, TModus, TSpec, Deferred > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(716)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _splitAction( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TKey , SkipElement< TObject, TModus, TSpec, TStructuring > ** , TParam & );       	// "projects/library/seqan/chaining/skip_list_base.h"(728)

//____________________________________________________________________________
// _swapBases

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _swapBases( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & first, SkipBaseElement< TObject, TModus, TSpec, TStructuring > & second );       	// "projects/library/seqan/chaining/skip_list_base.h"(235)

//____________________________________________________________________________
// _testBruteForce

template <typename TObject, typename TSize > inline bool _testBruteForce( TObject & elem, TObject & first, TObject & second, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(291)

//____________________________________________________________________________
// _testBruteForceMax

template <typename TObject, typename TSize > inline void _testBruteForceMax( TObject * elem, TObject * border, TObject *& max_object, TSize _dim );       	// "projects/library/seqan/chaining/rmt_base.h"(171)

//____________________________________________________________________________
// _testRange

template <typename TObject, typename TSize > inline bool _testRange( TObject & elem, TObject & first, TObject & second, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(311)

//____________________________________________________________________________
// _testRangeMax

template <typename TObject, typename TBorder, typename TSize > inline void _testRangeMax( TObject * elem, TBorder * border, TObject *& max_object, TSize dim );       	// "projects/library/seqan/chaining/rmt_base.h"(189)

//____________________________________________________________________________
// _throwCoin

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename THeight > inline typename seqan::Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _throwCoin( SkipList< TObject, TModus, TSpec, TStructuring > & , THeight max_height);       	// "projects/library/seqan/chaining/skip_list_base.h"(210)

//____________________________________________________________________________
// activate

template <typename TObject, typename TSpec, typename TStructuring > inline void activate( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TObject & obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(111)
template <typename TObject, typename TSpec, typename TStructuring, typename TWeight > inline void activate( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TObject & obj, TWeight prio );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(120)

//____________________________________________________________________________
// allocate

template <typename TClass, typename TParentAlloc, typename TSize > void allocate( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TClass *& dest, TSize number );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(187)
template <typename TClass, typename TParentAlloc, typename TSize > void allocate( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TClass *& dest, TSize number );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(316)

//____________________________________________________________________________
// append

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void append( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(73)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void append( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam1 & , TParam2 & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(82)

//____________________________________________________________________________
// appendValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void appendValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(90)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void appendValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam1 & , TParam2 & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(99)

//____________________________________________________________________________
// assign

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void assign( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(108)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void assign( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam1 & , TParam2 & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(117)

//____________________________________________________________________________
// assignValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue> inline void assignValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * , TValue const & );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(112)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue> inline void assignValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const * , TValue const & );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(122)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void assignValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(125)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void assignValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TParam1 & , TParam2 & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(134)

//____________________________________________________________________________
// capacity

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type capacity( SkipList< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_list_impl.h"(165)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type capacity( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(174)

//____________________________________________________________________________
// clear

template <typename TClass, typename TParentAlloc > inline void clear( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(249)
template <typename TClass, typename TParentAlloc > void clear( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(363)

//____________________________________________________________________________
// computeChain

template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring > TScoreValue computeChain( TSource & source, TDest & dest, Score< TScoreValue, TScoreType > const & score_, TStructuring structuring );       	// "projects/library/seqan/chaining/chain_base.h"(187)

//____________________________________________________________________________
// deallocate

template <typename TClass, typename TParentAlloc, typename TSize > inline void deallocate( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TClass * location, TSize );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(239)
template <typename TClass, typename TParentAlloc, typename TSize > void deallocate( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TClass * location, TSize count );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(354)

//____________________________________________________________________________
// dimension

template <typename TFragType > inline typename Size< TFragType >::Type dimension( const WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(147)
template <typename TBorder > inline typename Size< Seed< TBorder, MultiSeed > >::Type dimension( Seed< TBorder, MultiSeed > & me );       	// "projects/library/seqan/chaining/fragment.h"(250)
template <typename TFragType, typename TSpec > inline typename Size< TFragType >::Type dimension( ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(162)
template <typename TFragType, unsigned int ISize > inline typename Size< TFragType >::Type dimension( ChainPoint_< TFragType, Array< ISize > > &);       	// "projects/library/seqan/chaining/chain_point.h"(169)

//____________________________________________________________________________
// dump

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void dump( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_base_element.h"(54)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void dump( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(332)
template <typename TFragType > inline void dump( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(151)

//____________________________________________________________________________
// erase

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > bool erase( SkipList< TObject, TModus, TSpec, TStructuring > & , TKey );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(376)
template <typename TObject, typename TSpec, typename TStructuring, typename TKey > bool erase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(385)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > bool erase( SkipList< TObject, TModus, TSpec, TStructuring > & , TObject & );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(407)
template <typename TObject, typename TSpec, typename TStructuring > bool erase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(418)

//____________________________________________________________________________
// fac

template <typename TSimpleType > inline TSimpleType fac( TSimpleType data );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(49)

//____________________________________________________________________________
// getObject

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline TObject * getObject( SkipElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_element.h"(83)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * getObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_base_element.h"(293)

//____________________________________________________________________________
// getValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(222)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > const >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(230)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > * >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_base_element.h"(238)

//____________________________________________________________________________
// globalChaining

template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type globalChaining(TSource & source, TDest & dest, TScoring const & scoring, RangetreeChaining);       	// "projects/library/seqan/chaining/chain_base.h"(264)
template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type globalChaining(TSource & source, TDest & dest, TScoring const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(324)
template <typename TSource, typename TDest, typename TValue> inline TValue globalChaining(TSource & source, TDest & dest, Score<TValue, Zero> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(333)
template <typename TSource, typename TDest, typename TValue> inline TValue globalChaining(TSource & source, TDest & dest, Score<TValue, Manhattan> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(342)
template <typename TSource, typename TDest, typename TValue> inline TValue globalChaining(TSource & source, TDest & dest, Score<TValue, ChainSoP> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(351)
template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type globalChaining(TSource & source, TDest & dest, TScoring const & scoring);       	// "projects/library/seqan/chaining/chain_base.h"(362)

//____________________________________________________________________________
// goNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void goNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(402)
template <typename TObject, typename TSpec, typename TStructuring > inline void goNext( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(410)

//____________________________________________________________________________
// goPrevious

template <typename TObject, typename TSpec, typename TStructuring > inline void goPrevious( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(480)
template <typename TObject, typename TSpec, typename TStructuring > inline void goPrevious( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(488)

//____________________________________________________________________________
// insert

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void insert( SkipList< TObject, TModus, TSpec, TStructuring > & , TObject & );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(147)
template <typename TObject, typename TSpec, typename TStructuring > inline void insert( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(157)
template <typename TObject, typename TSpec, typename TStructuring, typename TParam > inline void insert( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(230)

//____________________________________________________________________________
// key

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline typename Key< TObject >::Type key( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(255)
template <typename TFragType > inline typename Key< TFragType >::Type key( WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(63)
template <typename TFragType > inline typename Key< TFragType >::Type key( const WrapperPoint_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(70)
template <typename TType, typename TIterType > inline typename Key< typename Value< Iter< TType, TIterType > >::Type >::Type key( Iter< TType, TIterType > & it );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(96)
template <typename TType, typename TIterType, typename TParam > inline typename Key< typename Value< Iter< TType, TIterType > >::Type >::Type key( Iter< TType, TIterType > & it, TParam & param );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(104)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Key< TObject >::Type key( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(746)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline typename Key< TObject >::Type key( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TParam & );       	// "projects/library/seqan/chaining/skip_base_element.h"(755)
template <typename TFragType, typename TSpec, typename TSize > inline typename Key< TFragType >::Type key( ChainPoint_< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(65)
template <typename TFragType, typename TSpec, typename TSize > inline typename Key< TFragType >::Type key( const ChainPoint_< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(75)

//____________________________________________________________________________
// leftPosition

template <typename TBorder, typename TSize > inline TBorder leftPosition( Seed< TBorder, MultiSeed > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(258)
template <typename TBorder, typename TSize > inline TBorder leftPosition( const Seed< TBorder, MultiSeed > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(266)

//____________________________________________________________________________
// length

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type length( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(201)

//____________________________________________________________________________
// makeBeginFragment

template <typename TFragment> inline void makeBeginFragment(TFragment & me);       	// "projects/library/seqan/chaining/fragment.h"(355)

//____________________________________________________________________________
// makeEndFragment

template <typename TFragment, typename TFragments> inline void makeEndFragment(TFragment & me, TFragments & fragments);       	// "projects/library/seqan/chaining/fragment.h"(369)

//____________________________________________________________________________
// moveValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue > inline void moveValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > *& , TValue const & );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(132)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue > inline void moveValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const *& , TValue const & );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(141)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TPos & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(220)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > const & , TPos & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(228)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > & , TPos const & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(236)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > const & , TPos const & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(244)

//____________________________________________________________________________
// operator+

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter< SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator+ (Iter< SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(182)
template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator+ (TIntegral left, Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(196)

//____________________________________________________________________________
// operator+=

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(215)

//____________________________________________________________________________
// operator-

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator- (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(233)

//____________________________________________________________________________
// operator-=

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(264)

//____________________________________________________________________________
// parentAllocator

template <typename TClass, typename TParentAlloc > inline TParentAlloc & parentAllocator( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(169)
template <typename TClass, typename TParentAlloc > inline TParentAlloc & parentAllocator( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(299)

//____________________________________________________________________________
// position

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec> inline typename Position<Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(151)
template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TContainer2> inline typename Position<Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & me, TContainer2 const &);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(169)

//____________________________________________________________________________
// printElementValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void printElementValue( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(344)

//____________________________________________________________________________
// printLayerScores

template <typename TObject, typename TSpec, typename TStructuring, typename TSize1, typename TSize2 > void printLayerScores( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TSize1 layer, TSize2 _dim );       	// "projects/library/seqan/chaining/rmt_base.h"(216)
template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void printLayerScores( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > * , TSize , TSize );       	// "projects/library/seqan/chaining/rt_base.h"(341)

//____________________________________________________________________________
// printScores

template <typename TObject, typename TSpec, typename TStructuring > void printScores( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list );       	// "projects/library/seqan/chaining/rmt_base.h"(284)

//____________________________________________________________________________
// priority

template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type priority( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_base_element.h"(52)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type priority( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(121)
template <typename TFragType, typename TSpec > inline typename Weight< TFragType >::Type priority( ChainPoint_< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(176)
template <typename TFragType > inline typename Weight< TFragType >::Type priority( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(89)

//____________________________________________________________________________
// rangeMaxQuery

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > TObject * rangeMaxQuery( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TBorder & border_obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(71)

//____________________________________________________________________________
// rangeQuery

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet > void rangeQuery( RangeTree< TObject, TModus, TSpec, TStructuring > & me, TObject & first, TObject & second, TResultSet & results );       	// "projects/library/seqan/chaining/rt_base.h"(277)

//____________________________________________________________________________
// replace

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > & , TPos & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(254)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > const & , TPos & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(263)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > & , TPos const & );       	// "projects/library/seqan/chaining/skip_list_impl.h"(272)

//____________________________________________________________________________
// right

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void right( SkipElement< TObject, TModus, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_element.h"(111)
template <typename TObject, typename TSpec, typename TStructuring > inline void right( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(616)
template <typename TObject, typename TSpec, typename TStructuring > inline void right( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(624)

//____________________________________________________________________________
// rightPosition

template <typename TBorder, typename TSize > inline TBorder rightPosition( Seed< TBorder, MultiSeed > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(274)
template <typename TBorder, typename TSize > inline TBorder rightPosition( const Seed< TBorder, MultiSeed > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(282)

//____________________________________________________________________________
// score

template <typename TValue, typename T> inline TValue score(Score<TValue, Zero> const & , T const & , T const & );       	// "projects/library/seqan/chaining/score_zero.h"(132)
template <typename TFragType > inline typename Weight< TFragType >::Type score( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(73)

//____________________________________________________________________________
// scoreChainGap

template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, Zero> const &, TFragment &, TFragment &);       	// "projects/library/seqan/chaining/score_zero.h"(144)
template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, Manhattan> const & me, TFragment & f1, TFragment & f2);       	// "projects/library/seqan/chaining/score_manhattan.h"(171)
template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, ChainSoP> const & me, TFragment & f1, TFragment & f2);       	// "projects/library/seqan/chaining/score_chain_sop.h"(217)

//____________________________________________________________________________
// scoreGap

template <typename TValue> inline TValue scoreGap(Score<TValue, Zero> &);       	// "projects/library/seqan/chaining/score_zero.h"(106)
template <typename TValue> inline TValue const scoreGap(Score<TValue, Zero> const &);       	// "projects/library/seqan/chaining/score_zero.h"(112)
template <typename TValue> inline TValue scoreGap(Score<TValue, Manhattan> & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(130)
template <typename TValue> inline TValue const & scoreGap(Score<TValue, Manhattan> const & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(136)
template <typename TValue> inline TValue & scoreGap(Score<TValue, ChainSoP> & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(175)
template <typename TValue> inline TValue const & scoreGap(Score<TValue, ChainSoP> const & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(182)

//____________________________________________________________________________
// scoreMatch

template <typename TValue> inline TValue scoreMatch(Score<TValue, Zero> &);       	// "projects/library/seqan/chaining/score_zero.h"(80)
template <typename TValue> inline TValue const scoreMatch(Score<TValue, Zero> const &);       	// "projects/library/seqan/chaining/score_zero.h"(86)
template <typename TValue> inline TValue scoreMatch(Score<TValue, Manhattan> & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(104)
template <typename TValue> inline TValue scoreMatch(Score<TValue, Manhattan> const & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(110)
template <typename TValue> inline TValue & scoreMatch(Score<TValue, ChainSoP> & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(149)
template <typename TValue> inline TValue const & scoreMatch(Score<TValue, ChainSoP> const & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(155)

//____________________________________________________________________________
// scoreMismatch

template <typename TValue> inline TValue scoreMismatch(Score<TValue, Zero> & );       	// "projects/library/seqan/chaining/score_zero.h"(93)
template <typename TValue> inline TValue const scoreMismatch(Score<TValue, Zero> const &);       	// "projects/library/seqan/chaining/score_zero.h"(99)
template <typename TValue> inline TValue scoreMismatch(Score<TValue, Manhattan> & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(117)
template <typename TValue> inline TValue scoreMismatch(Score<TValue, Manhattan> const & me);       	// "projects/library/seqan/chaining/score_manhattan.h"(123)
template <typename TValue> inline TValue & scoreMismatch(Score<TValue, ChainSoP> & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(162)
template <typename TValue> inline TValue const & scoreMismatch(Score<TValue, ChainSoP> const & me);       	// "projects/library/seqan/chaining/score_chain_sop.h"(168)

//____________________________________________________________________________
// searchElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > >::Type searchElement( SkipList< TObject, TModus, TSpec, TStructuring > & list, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_base.h"(675)

//____________________________________________________________________________
// setKey

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > __inline void setKey( SkipElement< TObject, TModus, TSpec, TStructuring > & me, TKey pos );       	// "projects/library/seqan/chaining/skip_element.h"(264)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void setKey( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TKey theKey);       	// "projects/library/seqan/chaining/skip_base_element.h"(729)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void setKey( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me, TKey theKey);       	// "projects/library/seqan/chaining/skip_base_element.h"(738)
template <typename TFragType, typename TSpec, typename TSize, typename TKey > inline void setKey( ChainPoint_< TFragType, TSpec > & me, TSize dim, TKey val );       	// "projects/library/seqan/chaining/chain_point.h"(86)
template <typename TFragType, typename TSpec, typename TSize, typename TKey > inline void setKey( const ChainPoint_< TFragType, TSpec > & me, TSize dim, TKey val );       	// "projects/library/seqan/chaining/chain_point.h"(96)

//____________________________________________________________________________
// setLeftPosition

template <typename TPosition, typename TSize, typename TPosition2> inline void setLeftPosition(Seed<TPosition, MultiSeed> & me, TSize dim, TPosition2 new_pos);       	// "projects/library/seqan/chaining/fragment.h"(326)

//____________________________________________________________________________
// setParentAllocator

template <typename TClass, typename TParentAlloc > inline void setParentAllocator( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TParentAlloc & alloc_);       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(178)
template <typename TClass, typename TParentAlloc > inline void setParentAllocator( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TParentAlloc & alloc_);       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(308)

//____________________________________________________________________________
// setPriority

template <typename TFragType, typename TSpec, typename TPrio > inline void setPriority( ChainPoint_< TFragType, TSpec > & me, TPrio prio );       	// "projects/library/seqan/chaining/chain_point.h"(184)
template <typename TFragType, typename TWeight > inline void setPriority( MetaFragment_< TFragType > & me, TWeight prio );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(97)

//____________________________________________________________________________
// setRightPosition

template <typename TPosition, typename TSize, typename TPosition2> inline void setRightPosition(Seed<TPosition, MultiSeed> & me, TSize dim, TPosition2 new_pos);       	// "projects/library/seqan/chaining/fragment.h"(344)

//____________________________________________________________________________
// setScore

template <typename TFragType, typename TWeight > inline void setScore( MetaFragment_< TFragType > & me, TWeight score );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(81)

//____________________________________________________________________________
// setWeight

template <typename TBorder, typename TSpec, typename TWeight > inline void setWeight( Seed< TBorder, TSpec > & me, TWeight weight );       	// "projects/library/seqan/chaining/fragment.h"(308)
template <typename TFragType, typename TWeight> inline void setWeight( MetaFragment_< TFragType > & me, TWeight weight );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(65)

//____________________________________________________________________________
// value

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_base_element.h"(191)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const & me);       	// "projects/library/seqan/chaining/skip_base_element.h"(199)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me);       	// "projects/library/seqan/chaining/skip_base_element.h"(207)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const * me);       	// "projects/library/seqan/chaining/skip_base_element.h"(214)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos> inline typename Reference< SkipList< TObject, TModus, TSpec, TStructuring > >::Type value( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(283)
template <typename TObject, typename TSpec, typename TStructuring, typename TPos> inline typename Reference< SkipList< TObject, SkipListStatic, TSpec, TStructuring > >::Type value( SkipList< TObject, SkipListStatic, TSpec, TStructuring > & me, TPos pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(300)

//____________________________________________________________________________
// valueConstruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > __inline void valueConstruct( SkipElement< TObject, TModus, TSpec, TStructuring > * it, SkipElement< TObject, TModus, TSpec, TStructuring > * right, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * down, TKey theKey );       	// "projects/library/seqan/chaining/skip_element.h"(359)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it );       	// "projects/library/seqan/chaining/skip_base_element.h"(255)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it, TObject * obj );       	// "projects/library/seqan/chaining/skip_base_element.h"(264)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it, TObject * obj, TKey key );       	// "projects/library/seqan/chaining/skip_base_element.h"(274)

//____________________________________________________________________________
// valueDestruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueDestruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it );       	// "projects/library/seqan/chaining/skip_base_element.h"(247)

//____________________________________________________________________________
// weight

template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type weight( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_base_element.h"(44)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type weight( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(113)
template <typename TBorder, typename TSpec > inline typename Weight< Seed< TBorder, TSpec > >::Type weight( Seed< TBorder, TSpec > & me );       	// "projects/library/seqan/chaining/fragment.h"(292)
template <typename TBorder, typename TSpec > inline typename Weight< Seed< TBorder, TSpec > >::Type weight( const Seed< TBorder, TSpec > & me );       	// "projects/library/seqan/chaining/fragment.h"(299)
template <typename TFragType > inline typename Weight< TFragType >::Type weight( MetaFragment_< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(57)

} //namespace seqan

#endif

