//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#include <getopt.h>
#include "perform.h"
#include "mainwnd.h"
#include "midifile.h"

/* struct for command parsing */
static struct 
option long_options[] = {

    {"file",     required_argument, 0, 'f'},
    {"help",     0, 0, 'h'},
    {"showmidi",     0, 0, 's'},
    {"stats",     0, 0, 'S' },
    {"priority", 0, 0, 'p' },
    {"ignore",required_argument, 0, 'i'},
	{"pass_sysex", 0, 0, 'P'},
    {0, 0, 0, 0}

};

bool global_showmidi = false;
bool global_priority = false;
bool global_device_ignore = false;
int global_device_ignore_num = 0;
bool global_stats = false;
bool global_pass_sysex = false;

int 
main (int argc, char *argv[])
{

    /* the main performance object */
    perform p; 

    /* all GTK applications must have a gtk_main(). Control ends here
       and waits for an event to occur (like a key press or mouse event). */
    Gtk::Main kit(argc, argv);


    /* parse parameters */
    int c;
    
    midifile *f;

    while (1){
	
      /* getopt_long stores the option index here. */
      int option_index = 0;

      c = getopt_long (argc, argv, "p:f:v", long_options, &option_index);

      /* Detect the end of the options. */
      if (c == -1)
	  break;

      switch (c){

      case '?':
      case 'h':

	  printf( "usage: seq24 [options]\n\n" );
	  printf( "options:\n" );
	  printf( "    --help : show this message\n" );
	  printf( "    --file <filename> : load midi file on startup\n" );
	  printf( "    --showmidi : dumps incoming midi to screen\n" );
  	  printf( "    --priority : runs higher priority with FIFO scheduler (must be root)\n" );
  	  printf( "    --pass_sysex : passes any incoming sysex messages to all outputs \n" );
	  printf( "\n\n\n" );

	  return 0;
	  break;
	
      case 'S':

	global_stats = true;
	break;

      case 's':
      
          global_showmidi = true;

	  break;

      case 'p':
      
          global_priority = true;

	  break;

	  case 'P':
      
          global_pass_sysex = true;

		  break;

      case 'f':
    
	  /* import that midi file */
	  f = new midifile( optarg );
	  f->parse( &p, 0 );
	  delete f;

          break;

      case 'i':

	  printf( "i\n" );
	  /* ignore alsa device */
	  global_device_ignore = true;
	  global_device_ignore_num = atoi( optarg );
	  break;


      default:
	  break;
      }

    } /* end while */

    p.launch_input_thread();
 
    mainwnd mainwnd( &p );
    kit.run();

    return 0;
}
