//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------


#ifndef SEQ24_PERFTIME
#define SEQ24_PERFTIME

#include "perform.h"
#include "seqtime.h"

#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/widget.h>
#include <gtk--/adjustment.h> 

#include "globals.h"

using namespace Gtk;

/* piano time*/
class perftime: public Gtk::DrawingArea
{

 private: 

    Gdk_GC       m_gc;
    Gdk_Window   m_window;
    Gdk_Color    m_black, m_white, m_grey;

    Gdk_Pixmap   m_pixmap;

    perform      *m_mainperf;

    Adjustment   *m_hadjust;

    int m_window_x, m_window_y;

    int m_4bar_offset;

    void realize_impl();
    int expose_event_impl(GdkEventExpose* a_ev);
    int button_press_event_impl(GdkEventButton* a_ev); 
    int button_release_event_impl(GdkEventButton* a_ev);
    void size_allocate_impl(GtkAllocation* a_r );

    void update_sizes();
    void draw_pixmap_on_window();
    void draw_progress_on_window();
    void update_pixmap();

    int idle_progress();

    void change_horz( void );

 public:

    perftime( perform *a_perf, Adjustment *a_hadjust );

    void reset();
    void set_scale( int a_scale );

    void increment_size();
};

#endif
