/*
 * Copyright (C) 2005 Alex Murray <pragmatine@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ACTIVE_SENSOR_H
#define ACTIVE_SENSOR_H

#include "sensors-applet.h"

struct _ActiveSensor {
	/* widgets to render to display the sensor */
	GtkLabel *label;
	GtkImage *icon;
	GtkLabel *value;

	GtkTreeRowReference *sensor_row;

	/* alarm related stuff */
	gint alarm_timeout_id;
	gchar *alarm_command;

	gdouble sensor_value;
	
};

/* value range icons used to overlay onto sensor device icons */
#define VERY_LOW_TEMP_ICON PIXMAPS_DIR "very-low-temp-icon.png"
#define LOW_TEMP_ICON PIXMAPS_DIR "low-temp-icon.png"
#define NORMAL_TEMP_ICON PIXMAPS_DIR "normal-temp-icon.png"
#define HIGH_TEMP_ICON PIXMAPS_DIR "high-temp-icon.png"
#define VERY_HIGH_TEMP_ICON PIXMAPS_DIR "very-high-temp-icon.png"

#define VERY_LOW_FAN_ICON PIXMAPS_DIR "very-low-fan-icon.png"
#define LOW_FAN_ICON PIXMAPS_DIR "low-fan-icon.png"
#define NORMAL_FAN_ICON PIXMAPS_DIR "normal-fan-icon.png"
#define HIGH_FAN_ICON PIXMAPS_DIR "high-fan-icon.png"
#define VERY_HIGH_FAN_ICON PIXMAPS_DIR "very-high-fan-icon.png"

/* value ranges */
enum {
	VERY_LOW_TEMP_UPPER_VALUE = 30,
	LOW_TEMP_UPPER_VALUE = 40,	
	NORMAL_TEMP_UPPER_VALUE = 60,
	HIGH_TEMP_UPPER_VALUE = 70,
	VERY_HIGH_TEMP_UPPER_VALUE
};

enum {
	VERY_LOW_FAN_UPPER_VALUE = 1000,
	LOW_FAN_UPPER_VALUE = 2000,
	NORMAL_FAN_UPPER_VALUE = 4000,
	HIGH_FAN_UPPER_VALUE = 5000,
	VERY_HIGH_FAN_UPPER_VALUE
};


gint active_sensor_compare(ActiveSensor *a, ActiveSensor *b);
void active_sensor_update(ActiveSensor *sensor, SensorsApplet *sensors_applet);
void active_sensor_icon_changed(ActiveSensor *sensor, SensorsApplet *sensors_applet);

#endif /* ACTIVE_SENSOR_H */
