/*
 * Copyright (C) 2005 Alex Murray <murray.alex@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SENSORS_APPLET_GCONF_H
#define SENSORS_APPLET_GCONF_H

#include "sensors-applet.h"
#include <panel-applet-gconf.h>

#define IS_SETUP "setup"  /* have we actually set up this instance of
			   * the applet (gets set to true after
			   * closing prefences dialog) */
#define FAHRENHEIT "fahrenheit" /* use fahrenheit temp scale or not
				 * (otherwise celcius) */
#define SHOW_LABELS "show_labels" /* show labels or not */
#define LABELS_INLINE "display_labels_inline" /* whether labels are
					       * placed on the same
					       line as sensor readings
					       or on separate line */

#define SHOW_UNITS "show_units" /* display units along with sensor
				   readings or not */
#define NUM_SENSORS "num_sensors" /* number of sensors per group */
#define PATHS "paths" /* full paths to filenames */
#define IDS "ids" /* a list of the sensor device ids */
#define INTERFACES "interfaces" /* a list of the sensor device
				 * interface for each sensor */
#define LABELS "labels"  /* user defined labels for each sensor */
#define ENABLES "sensor_enables" /* list of booleans corresponding to
				  * the filenames of whether a sensor
				  * is enabled or not */
#define ALARM_VALUES "alarm_values" /* stored as ints (1000 * double
				     * value) for accuracy, since can
				     * only do ints easily */
#define ALARM_TYPES "alarm_types" /* stores an int for each alarm as
				     to whether it is sounded when
				     value is greater than or less than
				     the sensor value */
#define ALARM_ENABLES "alarm_enables" /* list of whether each sensor
				       * has its alarm enabled */
#define ALARM_COMMANDS "alarm_commands" /* list of commands to execute
					 * when each alarm is
					 * activated */

#define ALARM_TIMEOUTS "alarm_timeouts" /* list of how often each
					   alarm should be sounded (in
					   seconds) */

#define SENSOR_TYPES "sensor_types" /* used to identify a sensor in a
				       list */

#define MULTIPLIERS "multipliers"
#define OFFSETS "offsets"
#define TIMEOUT "timeout_delay" /* delay (in ms) between refreshes */
#define FONT_SIZE "font_size" /* xx-small, x-small, smalll, medium,
			       * large, x-large, xx-large */


gboolean sensors_applet_gconf_save_sensors(SensorsApplet *sensors_applet);
gboolean sensors_applet_gconf_setup_sensors(SensorsApplet *sensors_applet);

#endif /* SENSORS_APPLET_GCONF_H*/
