Summary: SELinux example policy configuration
Name: policy
Version: 1.12
Release: 1
License: GPL
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/policy-%{version}.tgz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-buildroot

BuildArch: noarch
BuildRequires: checkpolicy m4 policycoreutils 

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

This package contains the SELinux example policy configuration along
with the Flask configuration information and the application
configuration files.  

%prep
%setup -q

%build
mv domains/misc/unused/*.te domains/misc
mv domains/program/unused/*.te domains/program/
(cd domains/program/; mv dpk* gatekeeper* qmail* config-* xprint* uml_net* tiny* seuser* unused/)
make policy
rm -rf tmp

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/root
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/security/
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/security/selinux
make DESTDIR="${RPM_BUILD_ROOT}" install
make clean
make DESTDIR="${RPM_BUILD_ROOT}" install-src

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%dir %{_sysconfdir}/security/selinux
%config(noreplace) %{_sysconfdir}/security/selinux/file_contexts
%config(noreplace) %{_sysconfdir}/security/selinux/policy\.*
%config(noreplace) %{_sysconfdir}/security/default_contexts
%config(noreplace) %{_sysconfdir}/security/default_type
%config(noreplace) %{_sysconfdir}/security/initrc_context
%config(noreplace) %{_sysconfdir}/security/failsafe_context
%config(noreplace) /root/.default_contexts

%package sources
Summary: SELinux example policy configuration source files 
Group: System Environment/Base
Requires: m4 make checkpolicy policycoreutils 
Requires: policy = %{version}-%{release}
BuildRequires: checkpolicy  policycoreutils 

%description sources
This subpackage includes the source files used to build the policy
configuration.  Includes policy.conf and the Makefiles, macros and
source files for it.

%files sources
%defattr(0600,root,root,0700)
%config(noreplace) %{_sysconfdir}/security/selinux/src/policy/users
%config(noreplace) %{_sysconfdir}/security/selinux/src/policy/tunable.te
%dir %{_sysconfdir}/security/selinux/src
%dir %{_sysconfdir}/security/selinux/src/policy
%{_sysconfdir}/security/selinux/src/policy/*

%post sources
if [ -x /usr/bin/selinuxenabled ]; then 
   make -W /etc/security/selinux/src/policy/users \
        -C /etc/security/selinux/src/policy > /dev/null 2>&1
   /usr/bin/selinuxenabled && [ -e /selinux/policyvers ] && \
      make -C /etc/security/selinux/src/policy load 
fi
exit 0

%post
[ -x /usr/bin/selinuxenabled ] && /usr/bin/selinuxenabled && [ -e /selinux/policyvers ] && \
/usr/sbin/load_policy /etc/security/selinux/policy.`cat /selinux/policyvers`
exit 0

%changelog
* Wed Apr 28 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-21
- Add macros for userhelper

* Fri Apr 23 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-19
- Merge in Russell's Changes

* Thu Apr 22 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-18
- Allow rw of usb devices
- Check if /selinux is mounted before reload

* Thu Apr 22 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-17
- Add better mount support
- Add sysfs to several files
- Add fifo support for rpm

* Wed Apr 21 2004 Colin Walters <walters@redhat.com> 1.11.2-16
- More dontaudits for postfix and net_conf_t
- Dontaudit for screensaver accessing fortunes 

* Wed Apr 21 2004 Colin Walters <walters@redhat.com> 1.11.2-15
- userhelper_t to rpm_t fix for up2date

* Tue Apr 20 2004 Colin Walters <walters@redhat.com> 1.11.2-14
- GPG key creation fix

* Tue Apr 20 2004 Colin Walters <walters@redhat.com> 1.11.2-13
- More LVM stuff from Russell
- Ignore ramfs access from e.g. nautilus

* Mon Apr 19 2004 Colin Walters <walters@redhat.com> 1.11.2-12
- More LVM-related fixes

* Mon Apr 19 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-11
- Allow NFS and mount to play together.
- Fix lvm

* Mon Apr 19 2004 Colin Walters <walters@redhat.com> 1.11.2-10
- Fix at
- Allow sysadm to loopback mount (new type sysadm_mount_source_t)

* Fri Apr 16 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-9
- Fix udev.
- Misc fixes

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-8
- Fix default contexts for root.

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-7
- fix atd

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-6
- Add usernetctl
- Add Nogin fixes

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-5
- Fix up2date

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-4
- Fix mailman

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-3
- Fix XServer XFree86->Xorg

* Wed Apr 14 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-2
- Fix sendmail 

* Tue Apr 12 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-1
- Update with latest NSA

* Tue Apr 12 2004 Dan Walsh <dwalsh@redhat.com> 1.11.1-3
- fix amanda, games and samba

* Mon Apr 12 2004 Dan Walsh <dwalsh@redhat.com> 1.11.1-2
- fix gpg

* Mon Apr 12 2004 Dan Walsh <dwalsh@redhat.com> 1.11.1-1
- Update to merge in NSA changes

* Sat Apr 10 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-5
- Fix post execution.
- More fixes for snmpd

* Fri Apr 9 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-5
- Fix rpmscript to allow get_security

* Fri Apr 9 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-3
- Add games support
- Fix some samba issues

* Thu Apr 8 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-2
- Add apmd support for killof

* Thu Apr 8 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-1
- Lots of fixes for snmpd

* Wed Apr 7 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-5
- Force rebuild always
- Add cifs support
- Macroize sudo

* Wed Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-4
- Many fixes to minor problems
- Pamconsole
- slapd
- mailman

* Tue Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-3
- Add can_exec($1_t, usr_t) to allow the execing of third party apps.

* Tue Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-2
- Add unconfined_t

* Tue Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.10.1-1
- Update to match NSA policy

* Tue Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-13
- Fixes for gpasswd
- Fix dhcp_defined macros

* Mon Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-12
- More fixes for spec file

* Mon Apr 5 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-11
- Fix policy spec
- Fix gnucash

* Sat Apr 3 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-10
- Fix print of test pages

* Sat Apr 3 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-9
- Fix /var/www file context.

* Fri Apr 2 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-8
- More fixes for running on older kernels

* Fri Apr 2 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-8
- Fix mozilla
- Add mount capability to users
- Allow rw capability for not ext attr files systems

* Thu Apr 2 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-6
- Fix printing
- Fix login problem

* Thu Apr 1 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-5
- fix Makefile

* Thu Apr 1 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-4
- fix login

* Thu Apr 1 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-3
- Fix su to not read homedir

* Thu Apr 1 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-2
- Add dovecot

* Wed Mar 31 2004 Dan Walsh <dwalsh@redhat.com> 1.9.2-1
- Turn on policy.16
- Fix userhelper

* Wed Mar 31 2004 Dan Walsh <dwalsh@redhat.com> 1.9.1-5
- Add postfix fix

* Tue Mar 30 2004 Dan Walsh <dwalsh@redhat.com> 1.9.1-4
- Fix cups reading fonts.

* Tue Mar 30 2004 Dan Walsh <dwalsh@redhat.com> 1.9.1-3
- More fixes, fix for userhelper, postfix, screensaver

* Mon Mar 29 2004 Dan Walsh <dwalsh@redhat.com> 1.9.1-2
- Misc fixes.

* Sun Mar 28 2004 Dan Walsh <dwalsh@redhat.com> 1.9.1-1
- Pull cyrus user out of users and create new serviceusers file

* Sat Mar 27 2004 Dan Walsh <dwalsh@redhat.com> 1.9-18
- Latest from NSA
- Add Screen Saver
- Many Fixes.

* Tue Mar 23 2004 Dan Walsh <dwalsh@redhat.com> 1.9-16
- Change policy.15 to be configfile

* Tue Mar 23 2004 Dan Walsh <dwalsh@redhat.com> 1.9-14
- Add cups changes

* Tue Mar 23 2004 Dan Walsh <dwalsh@redhat.com> 1.9-13
- Add changes recommended by Stephen Smalley

* Tue Mar 23 2004 Dan Walsh <dwalsh@redhat.com> 1.9-12
- Make NFS server work.

* Mon Mar 22 2004 Dan Walsh <dwalsh@redhat.com> 1.9-11
- Cleanup cyrus

* Mon Mar 22 2004 Dan Walsh <dwalsh@redhat.com> 1.9-10
- fix syntax of post install script

* Mon Mar 22 2004 Dan Walsh <dwalsh@redhat.com> 1.9-9
- Update with latest from Russell

* Sat Mar 20 2004 Dan Walsh <dwalsh@redhat.com> 1.9-8
- Allow user domains full access for test2 
- Add default_t to base_read 
- Change apps to allow read of policy_config_t so they can read file_contexts file

* Sat Mar 20 2004 Dan Walsh <dwalsh@redhat.com> 1.9-7
- Add Jeremy fix for mdadm

* Thu Mar 18 2004 Dan Walsh <dwalsh@redhat.com> 1.9-6
- Fix kerberos with su problem

* Thu Mar 18 2004 Dan Walsh <dwalsh@redhat.com> 1.9-5
- fix startx

* Thu Mar 18 2004 Dan Walsh <dwalsh@redhat.com> 1.9-4
- More fixes
- Make lsmod work

* Thu Mar 18 2004 Dan Walsh <dwalsh@redhat.com> 1.9-3
- Add /usr/bin/sesh for sudo

* Thu Mar 18 2004 Dan Walsh <dwalsh@redhat.com> 1.9-2
- move extra file_contexts/filecontexts to sources
- fixed rpm -V problem with prelink
- Fixed default_contexs 

* Wed Mar 17 2004 Dan Walsh <dwalsh@redhat.com> 1.8-23
- Fix for setsched on automount

* Wed Mar 17 2004 Dan Walsh <dwalsh@redhat.com> 1.8-22
- Use new genhomdircon

* Wed Mar 17 2004 Dan Walsh <dwalsh@redhat.com> 1.8-21
- Change relabel to not relabel file systems mounted with security context

* Wed Mar 17 2004 Jeremy Katz <katzj@redhat.com> 1.8-20
- changes for firstboot to be able to create users and nfsv4 mounting to work

* Tue Mar 16 2004 Dan Walsh <dwalsh@redhat.com> 1.8-19
- Fixed to get kerberos to work

* Tue Mar 16 2004 Dan Walsh <dwalsh@redhat.com> 1.8-18
- Allow users to fscreatecon

* Tue Mar 16 2004 Dan Walsh <dwalsh@redhat.com> 1.8-17
- Add cups fixes.
- More Russell Merges

* Mon Mar 15 2004 Dan Walsh <dwalsh@redhat.com> 1.8-16
- Lots of fixes

* Sun Mar 14 2004 Dan Walsh <dwalsh@redhat.com> 1.8-15
- Merges from Russells patches.
- Fix for cups

* Fri Mar 12 2004 Dan Walsh <dwalsh@redhat.com> 1.8-14
- Fix setattr on .ssh dir
- Cleanup based on comments from NSA

* Fri Mar 12 2004 Dan Walsh <dwalsh@redhat.com> 1.8-13
- Fix lvm and gconv
- fix rpc_pipefs

* Fri Mar 12 2004 Dan Walsh <dwalsh@redhat.com> 1.8-10
- more cleanup
- Fix lvm and gconv

* Thu Mar 11 2004 Dan Walsh <dwalsh@redhat.com> 1.8-10
-fix prelink and rpm interaction

* Thu Mar 11 2004 Dan Walsh <dwalsh@redhat.com> 1.8-9
- add ptal context
- fix su with kerberos.

* Thu Mar 11 2004 Dan Walsh <dwalsh@redhat.com> 1.8-8
- Fix ssh into ypbox.
- Fix hotplug to allow writing of network files

* Thu Mar 11 2004 Dan Walsh <dwalsh@redhat.com> 1.8-7
- fix ssh to allow use of .ssh dir
- Fix use_pop flags

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.8-6
- fix pam.fc

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.8-5
- Bump version

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.8-5
- Add krberos patch.
- More cleanup on nfs.

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.8-4
- Do postinstall load of policy

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.8-2
- Fix kudzu
- Change back to using shell_exec_t

* Tue Mar 9 2004 Dan Walsh <dwalsh@redhat.com> 1.8-1
- Update to latest release from NSA

* Tue Mar 9 2004 Dan Walsh <dwalsh@redhat.com> 1.7-12
- Uncontrolled_daemon

* Tue Mar 9 2004 Dan Walsh <dwalsh@redhat.com> 1.7-11
- Latest changes from NSA
- HOME_DIR stuff from tresys

* Mon Mar 8 2004 Dan Walsh <dwalsh@redhat.com> 1.7-10
- Replace file_t with default_t
- More NFS/YP fixes.
- 

* Mon Mar 8 2004 Dan Walsh <dwalsh@redhat.com> 1.7-9
- Merge in Russell and Stephen changes.
- More NFS and YP fixes.

* Fri Mar 5 2004 Dan Walsh <dwalsh@redhat.com> 1.7-8
- Put can_ypbind back in.

* Fri Mar 5 2004 Dan Walsh <dwalsh@redhat.com> 1.7-7
- Allow normal user to su in unlimitedUsers mode

* Fri Mar 5 2004 Dan Walsh <dwalsh@redhat.com> 1.7-6
- Cleanup NFS problems.

* Fri Mar 5 2004 Dan Walsh <dwalsh@redhat.com> 1.7-5
- Fix many more problems clean reboot

* Wed Mar 3 2004 Dan Walsh <dwalsh@redhat.com> 1.7-3
- Fix creation of aliases.db

* Wed Mar 3 2004 Dan Walsh <dwalsh@redhat.com> 1.7-2
- Fix mailman, su and other problems.

* Mon Mar 2 2004 Dan Walsh <dwalsh@redhat.com> 1.7-1
- New version from NSA.

* Mon Feb 27 2004 Dan Walsh <dwalsh@redhat.com> 1.6-16
- First version of loosened policy

* Mon Feb 27 2004 Dan Walsh <dwalsh@redhat.com> 1.6-15
- Add Russell's changes

* Fri Feb 27 2004 Dan Walsh <dwalsh@redhat.com> 1.6-14
- add sysctl controls
- Add firstboot and mdadm

* Fri Feb 27 2004 Dan Walsh <dwalsh@redhat.com> 1.6-13
- Add Russell etc_domain stuff

* Thu Feb 26 2004 Dan Walsh <dwalsh@redhat.com> 1.6-12
- Fix fd inheritance

* Thu Feb 26 2004 Dan Walsh <dwalsh@redhat.com> 1.6-11
- fix locate

* Thu Feb 26 2004 Dan Walsh <dwalsh@redhat.com> 1.6-10
- Add Russells latest

* Wed Feb 25 2004 Dan Walsh <dwalsh@redhat.com> 1.6-9
- Allow reading of src_t, file_t and unlabeled_t

* Tue Feb 24 2004 Dan Walsh <dwalsh@redhat.com> 1.6-8
- Cleanup some of the merge

* Tue Feb 24 2004 Dan Walsh <dwalsh@redhat.com> 1.6-7
- Merge russell's changes.

* Mon Feb 23 2004 Dan Walsh <dwalsh@redhat.com> 1.6-6
- Add Udev policy

* Mon Feb 23 2004 Jeremy Katz <katzj@redhat.com> 1.6-5
- Fix for depmod to auto-transition when run from rpm scriptlet
- Make /usr/lib/locale locale_t instead of lib_t
- Fixes to allow more domain transitions from anaconda_t
- grpconv, pwunconv and grpunconv also need to be admin_passwd_exec_t

* Mon Feb 23 2004 Dan Walsh <dwalsh@redhat.com> 1.6-4
- More fixes from test machines

* Mon Feb 23 2004 Jeremy Katz <katzj@redhat.com> - 1.6-3
- /boot/grub/* needs to be boot_runtime_t so that grub can change as needed

* Sun Feb 22 2004 Dan Walsh <dwalsh@redhat.com> 1.6-2
- Rebase off of NSA
- Add Russells latest patches for RPM

* Fri Feb 20 2004 Jeremy Katz <katzj@redhat.com> - 1.4.17-8
- rpm_script_t -> ldconfig_t so that ld.so.conf has right context

* Fri Feb 20 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-7
- A couple of more missing policies

* Fri Feb 20 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-6
- Add /lib64 support continue working on kde and yp, nis, nfs support

* Thu Feb 19 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-5
- More file_trans rules.

* Thu Feb 19 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-4
- Add kde support
- More ypbind stuff

* Thu Feb 19 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-3
- Add udev, dmesg and more can_ypbind

* Wed Feb 18 2004 Dan Walsh <dwalsh@redhat.com> 1.4.17-2
- Latest from Russell and matched up against stephen.
- Move singledomain to use typealias

* Mon Feb 16 2004 Dan Walsh <dwalsh@redhat.com> 1.4.16-2
- Latest from Russell
- Added lots more ypbind fixes
- put back in krb5_conf_t so can dontaudit writes.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Dan Walsh <dwalsh@redhat.com> 1.4.15-1
- Latest from Russell

* Thu Feb 12 2004 Dan Walsh <dwalsh@redhat.com> 1.4.14-6
- add privoxy and canna back in

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.14-5
- Merge in latest changes from NSA
- Add requirement so sources pulls policy
- fix epoch
- More rules for nfs homedirs and mozilla

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.14-2
- Add support for nfs homedirs and automount

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.14-1
- Latest from Russell

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.13-6
- Fix build and include policy sources only in policy-sources

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.13-4
- Build file_contexts/file_contexts

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.13-4
- Add back privfd for su macros to fix su in different context

* Tue Feb 10 2004 Dan Walsh <dwalsh@redhat.com> 1.4.13-2
- Change to move policy files around in build instead of install

* Mon Feb 9 2004 Dan Walsh <dwalsh@redhat.com> 1.4.13-1
- Add Stephens changes, add hostname.fc

* Fri Feb 6 2004 Dan Walsh <dwalsh@redhat.com> 1.4.12-2
- added privoxy, cannaping and cleaned up reboot.

* Fri Feb 6 2004 Dan Walsh <dwalsh@redhat.com> 1.4.12-1
- Updated with latest merge of Russell and Stephen

* Sun Jan 31 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-8
- Fix regression 

* Sat Jan 31 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-7
- Add policy for handling ypbind and update for fc2-test1

* Wed Jan 28 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-6
- Add privown to su_macros to allow terminal relabel work for su

* Wed Jan 28 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-5
- Add Stephen su patches

* Wed Jan 28 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-4
- Use genhomedircon rather than homedir.py
- Add back in some of Stephen Changes that Russell removed

* Tue Jan 27 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-3
- Add file_context for /

* Tue Jan 27 2004 Jeremy Katz <katzj@redhat.com> - 1.4.10-2
- don't try to label /sys

* Mon Jan 26 2004 Dan Walsh <dwalsh@redhat.com> 1.4.10-1
- New policy from Russell

* Sun Jan 25 2004 Dan Walsh <dwalsh@redhat.com> 1.4.9-1
- Fix several minor problems

* Sun Jan 25 2004 Dan Walsh <dwalsh@redhat.com> 1.4.9-1
- Integrate Steven Smalleys changes into russells
- Add sudo, mrtg and systat fixes

* Sun Jan 25 2004 Dan Walsh <dwalsh@redhat.com> 1.4.8-2
- remove readahead
- fix sudo

* Sun Jan 25 2004 Dan Walsh <dwalsh@redhat.com> 1.4.8-1
- Another update

* Fri Jan 23 2004 Dan Walsh <dwalsh@redhat.com> 1.4.7-1
- Russell's latest 

* Thu Jan 22 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-10
- Add rootok patch

* Thu Jan 22 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-9
- Update prelink patch, add font support

* Wed Jan 21 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-8
- Sort file_contexts/file_contexts and eliminate dups

* Fri Jan 16 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-7
- Minor change to get su to relabel terminal permission

* Thu Jan 15 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-6
- Add roletrans stuff from NSA
- Allows init scripts to run under proper context

* Tue Jan 13 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-5
- Add /usr/share files
- add krb5.conf to user_macros
- fix sudo in failure situation

* Tue Jan 13 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-4
- Fix file permissions

* Tue Jan 13 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-4
- Change file_context/file_context to world readable

* Mon Jan 12 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-2
- Add user homedir support for make relabel
- add file_context/file_context

* Fri Jan 9 2004 Dan Walsh <dwalsh@redhat.com> 1.4.6-1
- Russell's latest

* Fri Jan 9 2004 Dan Walsh <dwalsh@redhat.com> 1.4.5-2
- Add Requires checkpolicy to sources.
- Move policy files up from unused

* Thu Jan 8 2004 Dan Walsh <dwalsh@redhat.com> 1.4.5-1
- First version of minimal policy

* Wed Jan 7 2004 Dan Walsh <dwalsh@redhat.com> 1.4.4-3
- Add My own mods

* Wed Jan 7 2004 Dan Walsh <dwalsh@redhat.com> 1.4.4-2
- Add run daemon patch

* Mon Jan 5 2004 Dan Walsh <dwalsh@redhat.com> 1.4.4-1
- Many changes added, access to random device
- add directories ownership

* Tue Dec 23 2003 Dan Walsh <dwalsh@redhat.com> 1.4.2-2
- Fix bluetooth

* Tue Dec 23 2003 Dan Walsh <dwalsh@redhat.com> 1.4.2-1
- Latest policy with Russel and My changes.
- Add Bluetooth and pam

* Mon Dec 8 2003 Dan Walsh <dwalsh@redhat.com> 1.4.1-1
- Incorporate latest release from NSA

* Sat Dec 6 2003 Dan Walsh <dwalsh@redhat.com> 1.3.4-1
- More changes to get Fedora working
- add m4 make policycoreutils requirement
- remove rhat patch

* Thu Dec 3 2003 Dan Walsh <dwalsh@redhat.com> 1.3.3-1
- Many changes to get Fedora working

* Wed Dec 3 2003 Dan Walsh <dwalsh@redhat.com> 1.3.2-2
- Fix xserver to read userhelper files
- fix default context

* Tue Dec 2 2003 Dan Walsh <dwalsh@redhat.com> 1.3.2-1
- Latest policy from Russell

* Tue Nov 4 2003 Dan Walsh <dwalsh@redhat.com> 1.3-3
- Patch to make minimal policy work

* Fri Oct 24 2003 Dan Walsh <dwalsh@redhat.com> 1.3-1
- Russel's policy file

* Thu Oct 2 2003 Dan Walsh <dwalsh@redhat.com> 1.0-3
- Latest from NSA

* Mon Aug 18 2003 Paul Nasrat <pauln@truemesh.com> 1.2-1
- Enable non-root build

* Mon Jun 2 2003 Dan Walsh <dwalsh@redhat.com> 1.0-1
- Initial version









