#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "v3dtex.h"

#include "obj.h"
#include "objutils.h"
#include "fire.h"
#include "sar.h"
#include "config.h"


int FireCreate(
	sar_core_struct *core_ptr, sar_scene_struct *scene,
	sar_object_struct ***ptr, int *total,
	const sar_position_struct *pos,
	float radius, float height,
        int ref_object,
        const char *tex_name
);

/*
 *	Creates a fire object at the specified position referenced by
 *	ref_object (currently not used).
 *
 *	Returns the new fire object index.
 */
int FireCreate(
	sar_core_struct *core_ptr, sar_scene_struct *scene,
	sar_object_struct ***ptr, int *total,
	const sar_position_struct *pos,
	float radius, float height,
	int ref_object,
	const char *tex_name
)
{
	int obj_num;
	sar_object_struct *obj_ptr;
	sar_object_fire_struct *obj_fire_ptr;
        const sar_option_struct *opt = &core_ptr->option;
	if((scene == NULL) || (pos == NULL))
	    return(-1);

	/* Create fire object. */
	obj_num = SARObjCreate(
	    scene, ptr, total,
	    SAR_OBJ_TYPE_FIRE
	);
	if(obj_num < 0)
	    return(-1);

	obj_ptr = (*ptr)[obj_num];
	if(obj_ptr == NULL)
	    return(-1);


	/* Begin setting new values. */

	/* Initial position. */
	memcpy(
	    &obj_ptr->pos, pos, sizeof(sar_position_struct)
	);

        /* Set visible range based on radius. */
        if(radius >= 100.0f)
            obj_ptr->range = (float)SFMMilesToMeters(16.0);
        else if(radius >= 70.0f)
            obj_ptr->range = (float)SFMMilesToMeters(14.0);
        else if(radius >= 30.0f)
            obj_ptr->range = (float)SFMMilesToMeters(12.0);
        else if(radius >= 10.0f)
            obj_ptr->range = (float)SFMMilesToMeters(10.0);
	else
	    obj_ptr->range = (float)SFMMilesToMeters(7.0);

	/* Get pointer to fire sub structure. */
	obj_fire_ptr = SAR_OBJ_GET_FIRE(obj_ptr);
	if(obj_fire_ptr == NULL)
	    return(-1);

	/* Set size of fire. */
	obj_fire_ptr->radius = radius;
	obj_fire_ptr->height = height;

	/* Set frame animation values. */
        obj_fire_ptr->cur_frame = 0;
/* Use explosion frame increment interval. */
        obj_fire_ptr->frame_inc_int = opt->explosion_frame_int;
        obj_fire_ptr->next_frame_inc = cur_millitime +
            obj_fire_ptr->frame_inc_int;

	obj_fire_ptr->cur_frame = 0;
        obj_fire_ptr->frame_repeats = 0;
        obj_fire_ptr->total_frame_repeats = 1;

	/* Get texture. */
	obj_fire_ptr->tex_num = SARGetTextureRefNumberByName(
	    scene, tex_name
	);

	/* Set reference object. */
/*
	obj_fire_ptr->ref_object = ref_object;
 */
obj_fire_ptr->ref_object = -1;

	/* Return newly created fire object. */
	return(obj_num);
}
