/* Copyright (C) 1994-1998 Revolution Software Ltd.
 * Copyright (C) 2003-2005 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sword2/console.h,v 1.26.2.1 2005/10/18 02:11:27 sev Exp $
 */

#ifndef	C_ONSOLE_H
#define	C_ONSOLE_H

#include "common/debugger.h"
#include "sword2/debug.h"

namespace Sword2 {

class Debugger : public Common::Debugger<Debugger> {
private:
	void varGet(int var);
	void varSet(int var, int val);

	bool _displayDebugText;
	bool _displayWalkGrid;
	bool _displayMouseMarker;
	bool _displayTime;
	bool _displayPlayerMarker;
	bool _displayTextNumbers;

	bool _rectFlicker;

	int32 _startTime;

	int32 _showVar[MAX_SHOWVARS];

	byte _debugTextBlocks[MAX_DEBUG_TEXTS];

	void clearDebugTextBlocks();
	void makeDebugTextBlock(char *text, int16 x, int16 y);

	void plotCrossHair(int16 x, int16 y, uint8 pen);
	void drawRect(int16 x, int16 y, int16 x2, int16 y2, uint8 pen);

public:
	Debugger(Sword2Engine *vm);

	int16 _rectX1, _rectY1;
	int16 _rectX2, _rectY2;

	uint8 _draggingRectangle;
	bool _definingRectangles;

	bool _testingSnR;

	int32 _speechScriptWaiting;

	int32 _textNumber;

	ObjectGraphic _playerGraphic;
	uint32 _playerGraphicNoFrames;

	void buildDebugText();
	void drawDebugGraphics();

protected:
	Sword2Engine *_vm;

	virtual void preEnter();
	virtual void postEnter();

	// Commands
	bool Cmd_Exit(int argc, const char **argv);
	bool Cmd_Help(int argc, const char **argv);
	bool Cmd_Mem(int argc, const char **argv);
	bool Cmd_Tony(int argc, const char **argv);
	bool Cmd_Res(int argc, const char **argv);
	bool Cmd_ResList(int argc, const char **argv);
	bool Cmd_Starts(int argc, const char **argv);
	bool Cmd_Start(int argc, const char **argv);
	bool Cmd_Info(int argc, const char **argv);
	bool Cmd_WalkGrid(int argc, const char **argv);
	bool Cmd_Mouse(int argc, const char **argv);
	bool Cmd_Player(int argc, const char **argv);
	bool Cmd_ResLook(int argc, const char **argv);
	bool Cmd_CurrentInfo(int argc, const char **argv);
	bool Cmd_RunList(int argc, const char **argv);
	bool Cmd_Kill(int argc, const char **argv);
	bool Cmd_Nuke(int argc, const char **argv);
	bool Cmd_Var(int argc, const char **argv);
	bool Cmd_Rect(int argc, const char **argv);
	bool Cmd_Clear(int argc, const char **argv);
	bool Cmd_DebugOn(int argc, const char **argv);
	bool Cmd_DebugOff(int argc, const char **argv);
	bool Cmd_SaveRest(int argc, const char **argv);
	bool Cmd_TimeOn(int argc, const char **argv);
	bool Cmd_TimeOff(int argc, const char **argv);
	bool Cmd_Text(int argc, const char **argv);
	bool Cmd_ShowVar(int argc, const char **argv);
	bool Cmd_HideVar(int argc, const char **argv);
	bool Cmd_Version(int argc, const char **argv);
	bool Cmd_AnimTest(int argc, const char **argv);
	bool Cmd_TextTest(int argc, const char **argv);
	bool Cmd_LineTest(int argc, const char **argv);
	bool Cmd_Events(int argc, const char **argv);
	bool Cmd_Sfx(int argc, const char **argv);
	bool Cmd_English(int argc, const char **argv);
	bool Cmd_Finnish(int argc, const char **argv);
	bool Cmd_Polish(int argc, const char **argv);
};

} // End of namespace Sword2

#endif
