#include <PalmOS.h>
#include "b_globals.h"

static void PlayerV2_note_lengths() {
	UInt8 note_lengths[] = {
		0,  
		0,  0,  2,
		0,  3,  4,
		5,  6,  8,
		9, 12, 16,
		18, 24, 32,
		36, 48, 64,
		72, 96
	};

	writeRecord(note_lengths, sizeof(note_lengths), GBVARS_NOTELENGTHS_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_hull_offsets() {
	UInt16 hull_offsets[] = {
		0, 12, 24, 36, 48, 60, 
		72, 88, 104, 120, 136, 256, 
		152, 164, 180
	};

	writeRecord(hull_offsets, sizeof(hull_offsets), GBVARS_HULLOFFSETS_INDEX , GBVARS_SCUMM);
}

typedef Int16 int16;

static void PlayerV2_hulls() {
	Int16 hulls[] = {
		// hull 0
		3, -1, 0, 0, 0, 0, 0, 0,
		0, -1, 0, 0,
		// hull 1 (staccato)
		3, -1, 0, 32, 0, -1, 0, 0,
		0, -1, 0, 0,
		// hull 2 (legato)
		3, -1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0,
		// hull 3 (staccatissimo)
		3, -1, 0, 2, 0, -1, 0, 0,
		0, -1, 0, 0,
		// hull 4
		3, -1, 0, 6, 0, -1, 0, 0,
		0, -1, 0, 0,
		// hull 5
		3, -1, 0, 16, 0, -1, 0, 0,
		0, -1, 0, 0,
		// hull 6
		(int16) 60000, -1, -1000, 20, 0, 0, 0, 0,
		(int16) 40000, -1, -5000,  5, 0, -1, 0, 0,
		// hull 7
		(int16) 50000, -1, 0, 8, 30000, -1, 0, 0,
		28000, -1, -5000,  5, 0, -1, 0, 0,
		// hull 8
		(int16) 60000, -1, -2000, 16, 0, 0, 0, 0,
		28000, -1, -6000,  5, 0, -1, 0, 0,
		// hull 9
		(int16) 55000, -1,     0,  8, (int16) 35000, -1, 0, 0,
		(int16) 40000, -1, -2000, 10, 0, -1, 0, 0,
		// hull 10
		(int16) 60000, -1,     0,  4, -2000, 8, 0, 0,
		(int16) 40000, -1, -6000,  5, 0, -1, 0, 0,
		// hull 12
		0, -1,   150, 340, -150, 340, 0, -1,
		0, -1, 0, 0,
		// hull 13  == 164
		20000, -1,  4000,  7, 1000, 15, 0, 0,
		(int16) 35000, -1, -2000, 15, 0, -1, 0, 0,

		// hull 14  == 180
		(int16) 35000, -1,   500, 20, 0,  0, 0, 0,
		(int16) 45000, -1,  -500, 60, 0, -1, 0, 0,

		// hull misc = 196
		(int16) 44000, -1, -4400, 10, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 53000, -1, -5300, 10, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 63000, -1, -6300, 10, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 44000, -1, -1375, 32, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 53000, -1, -1656, 32, 0, -1, 0, 0,
		0, -1, 0, 0,

		// hull 11 == 256
		(int16) 63000, -1, -1968, 32, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 44000, -1, - 733, 60, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 53000, -1, - 883, 60, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 63000, -1, -1050, 60, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 44000, -1, - 488, 90, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 53000, -1, - 588, 90, 0, -1, 0, 0,
		0, -1, 0, 0,

		(int16) 63000, -1, - 700, 90, 0, -1, 0, 0,
		0, -1, 0, 0
	};
	
	writeRecord(hulls, sizeof(hulls), GBVARS_HULLS_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_freqmod_lengths() {
	UInt16 freqmod_lengths[] = {
		0x1000, 0x1000, 0x20, 0x2000, 0x1000
	};
	
	writeRecord(freqmod_lengths, sizeof(freqmod_lengths), GBVARS_FREQMODLENGTHS_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_freqmod_offsets() {
	UInt16 freqmod_offsets[] = {
	0, 0x100, 0x200, 0x302, 0x202
	};
	
	writeRecord(freqmod_offsets, sizeof(freqmod_offsets), GBVARS_FREQMODOFFSETS_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_freqmod_table() {
	Int8 freqmod_table[0x502] = {
     0,   3,   6,   9,  12,  15,  18,  21,
    24,  27,  30,  33,  36,  39,  42,  45,
    48,  51,  54,  57,  59,  62,  65,  67,
    70,  73,  75,  78,  80,  82,  85,  87,
    89,  91,  94,  96,  98, 100, 102, 103,
   105, 107, 108, 110, 112, 113, 114, 116,
   117, 118, 119, 120, 121, 122, 123, 123,
   124, 125, 125, 126, 126, 126, 126, 126,
   126, 126, 126, 126, 126, 126, 125, 125,
   124, 123, 123, 122, 121, 120, 119, 118,
   117, 116, 114, 113, 112, 110, 108, 107,
   105, 103, 102, 100,  98,  96,  94,  91,
    89,  87,  85,  82,  80,  78,  75,  73,
    70,  67,  65,  62,  59,  57,  54,  51,
    48,  45,  42,  39,  36,  33,  30,  27,
    24,  21,  18,  15,  12,   9,   6,   3,
     0,  -3,  -6,  -9, -12, -15, -18, -21,
   -24, -27, -30, -33, -36, -39, -42, -45,
   -48, -51, -54, -57, -59, -62, -65, -67,
   -70, -73, -75, -78, -80, -82, -85, -87,
   -89, -91, -94, -96, -98,-100,-102,-103,
  -105,-107,-108,-110,-112,-113,-114,-116,
  -117,-118,-119,-120,-121,-122,-123,-123,
  -124,-125,-125,-126,-126,-126,-126,-126,
  -126,-126,-126,-126,-126,-126,-125,-125,
  -124,-123,-123,-122,-121,-120,-119,-118,
  -117,-116,-114,-113,-112,-110,-108,-107,
  -105,-103,-102,-100, -98, -96, -94, -91,
   -89, -87, -85, -82, -80, -78, -75, -73,
   -70, -67, -65, -62, -59, -57, -54, -51,
   -48, -45, -42, -39, -36, -33, -30, -27,
   -24, -21, -18, -15, -12,  -9,  -6,  -3,
  
     0,   1,   2,   3,   4,   5,   6,   7,
     8,   9,  10,  11,  12,  13,  14,  15,
    16,  17,  18,  19,  20,  21,  22,  23,
    24,  25,  26,  27,  28,  29,  30,  31,
    32,  33,  34,  35,  36,  37,  38,  39,
    40,  41,  42,  43,  44,  45,  46,  47,
    48,  49,  50,  51,  52,  53,  54,  55,
    56,  57,  58,  59,  60,  61,  62,  63,
    64,  65,  66,  67,  68,  69,  70,  71,
    72,  73,  74,  75,  76,  77,  78,  79,
    80,  81,  82,  83,  84,  85,  86,  87,
    88,  89,  90,  91,  92,  93,  94,  95,
    96,  97,  98,  99, 100, 101, 102, 103,
   104, 105, 106, 107, 108, 109, 110, 111,
   112, 113, 114, 115, 116, 117, 118, 119,
   120, 121, 122, 123, 124, 125, 126, 127,
  -128,-127,-126,-125,-124,-123,-122,-121,
  -120,-119,-118,-117,-116,-115,-114,-113,
  -112,-111,-110,-109,-108,-107,-106,-105,
  -104,-103,-102,-101,-100, -99, -98, -97,
   -96, -95, -94, -93, -92, -91, -90, -89,
   -88, -87, -86, -85, -84, -83, -82, -81,
   -80, -79, -78, -77, -76, -75, -74, -73,
   -72, -71, -70, -69, -68, -67, -66, -65,
   -64, -63, -62, -61, -60, -59, -58, -57,
   -56, -55, -54, -53, -52, -51, -50, -49,
   -48, -47, -46, -45, -44, -43, -42, -41,
   -40, -39, -38, -37, -36, -35, -34, -33,
   -32, -31, -30, -29, -28, -27, -26, -25,
   -24, -23, -22, -21, -20, -19, -18, -17,
   -16, -15, -14, -13, -12, -11, -10,  -9,
    -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,
  
  -120, 120,
  
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
  -120,-120,-120,-120,-120,-120,-120,-120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,
   120, 120, 120, 120, 120, 120, 120, 120,

    41,  35, -66,-124, -31, 108, -42, -82,
    82,-112,  73, -15, -15, -69, -23, -21,
   -77, -90, -37,  60,-121,  12,  62,-103,
    36,  94,  13,  28,   6, -73,  71, -34,
   -77,  18,  77, -56,  67, -69,-117, -90,
    31,   3,  90, 125,   9,  56,  37,  31,
    93, -44, -53,  -4,-106, -11,  69,  59,
    19,  13,-119,  10,  28, -37, -82,  50,
    32,-102,  80, -18,  64, 120,  54,  -3,
    18,  73,  50, -10, -98, 125,  73, -36,
   -83,  79,  20, -14,  68,  64, 102, -48,
   107, -60,  48, -73,  50,  59, -95,  34,
   -10,  34,-111, -99, -31,-117,  31, -38,
   -80, -54,-103,   2, -71, 114, -99,  73,
    44,-128, 126, -59,-103, -43, -23,-128,
   -78, -22, -55, -52,  83, -65, 103, -42,
   -65,  20, -42, 126,  45, -36,-114, 102,
  -125, -17,  87,  73,  97,  -1, 105,-113,
    97, -51, -47,  30, -99,-100,  22, 114,
   114, -26,  29, -16,-124,  79,  74, 119,
     2, -41, -24,  57,  44,  83, -53, -55,
    18,  30,  51, 116, -98,  12, -12, -43,
   -44, -97, -44, -92,  89, 126,  53, -49,
    50,  34, -12, -52, -49, -45,-112,  45,
    72, -45,-113, 117, -26, -39,  29,  42,
   -27, -64,  -9,  43, 120,-127,-121,  68,
    14,  95,  80,   0, -44,  97,-115, -66,
   123,   5,  21,   7,  59,  51,-126,  31,
    24, 112,-110, -38, 100,  84, -50, -79,
  -123,  62, 105,  21,  -8,  70, 106,   4,
  -106, 115,  14, -39,  22,  47, 103, 104,
   -44,  -9,  74,  74, -48,  87, 104, 118,
    -6,  22, -69,  17, -83, -82,  36,-120,
   121,  -2,  82, -37,  37,  67, -27,  60,
   -12,  69, -45, -40,  40, -50,  11, -11,
   -59,  96,  89,  61,-105,  39,-118,  89,
   118,  45, -48, -62, -55, -51, 104, -44,
    73, 106, 121,  37,   8,  97,  64,  20,
   -79,  59, 106, -91,  17,  40, -63,-116,
   -42, -87,  11,-121,-105,-116,  47, -15,
    21,  29,-102,-107, -63,-101, -31, -64,
   126, -23, -88,-102, -89,-122, -62, -75,
    84, -65,-102, -25, -39,  35, -47,  85,
  -112,  56,  40, -47, -39, 108, -95, 102,
    94,  78, -31,  48,-100,  -2, -39, 113,
   -97, -30, -91, -30,  12,-101, -76,  71,
   101,  56,  42,  70,-119, -87,-126, 121,
   122, 118, 120, -62,  99, -79,  38, -33,
   -38,  41, 109,  62,  98, -32,-106,  18,
    52, -65,  57, -90,  63,-119,  94, -15,
   109,  14, -29, 108,  40, -95,  30,  32,
    29, -53, -62,   3,  63,  65,   7,-124,
    15,  20,   5, 101,  27,  40,  97, -55,
   -59, -25,  44,-114,  70,  54,   8, -36,
   -13, -88,-115,  -2, -66, -14, -21, 113,
    -1, -96, -48,  59, 117,   6,-116, 126,
  -121, 120, 115,  77, -48, -66,-126, -66,
   -37, -62,  70,  65,  43,-116,  -6,  48,
   127, 112, -16, -89,  84,-122,  50,-107,
   -86,  91, 104,  19,  11, -26,  -4, -11,
   -54, -66, 125, -97,-119,-118,  65,  27,
    -3, -72,  79, 104, -10, 114, 123,  20,
  -103, -51, -45,  13, -16,  68,  58, -76,
   -90, 102,  83,  51,  11, -53, -95,  16
};
	
	writeRecord(freqmod_table, sizeof(freqmod_table), GBVARS_FREQMODTABLE_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_spk_freq_table() {
	UInt16  spk_freq_table[12] = {
	36484, 34436, 32503, 30679, 28957, 27332, 
	25798, 24350, 22983, 21693, 20476, 19326
};
	
	writeRecord(spk_freq_table, sizeof(spk_freq_table), GBVARS_SPKFREQTABLE_INDEX , GBVARS_SCUMM);
}

static void PlayerV2_pcjr_freq_table() {
	UInt16 pcjr_freq_table[12] = {
	65472, 61760, 58304, 55040, 52032, 49024, 
	46272, 43648, 41216, 38912, 36736, 34624
};
	
	writeRecord(pcjr_freq_table, sizeof(pcjr_freq_table), GBVARS_PCJRFREQTABLE_INDEX , GBVARS_SCUMM);
}

void addPlayerV2() {
	PlayerV2_note_lengths();
	PlayerV2_hull_offsets();
	PlayerV2_hulls();
	PlayerV2_freqmod_lengths();
	PlayerV2_freqmod_offsets();
	PlayerV2_freqmod_table();
	PlayerV2_spk_freq_table();
	PlayerV2_pcjr_freq_table();
}
