#include <PalmOS.h>
#include "b_globals.h"

typedef struct  {
	const char name[11];								// Nstr
	signed char state,faceDirection;				// S,F
	signed char body,bf,rf,af;
	const char animation[80];							// SANIMstr
	signed char ff;
} SpeechParameters;

UInt8 *ptr;

static UInt32 resize(void *p, UInt32 more) {
	UInt32 old = MemPtrSize(p);
	UInt8 *np = MemPtrNew(old + more);
	MemMove(np, ptr, old);
	MemPtrFree(ptr);
	ptr = np;

	return old;
}

#define	DO_AddFunc(XX)	\
	static UInt32 addTalk_speechParameters_part##XX() {	\
		SpeechParameters _speechParameters_part[] = {

#define DO_EndFunc	\
		};		\
		UInt32 size = sizeof(_speechParameters_part);		\
		UInt32 old	= resize(ptr, size);					\
		MemMove(ptr + old, _speechParameters_part, size);	\
		return MemPtrSize(ptr); \
	}
	
DO_AddFunc(1)
	{ "JOE",0,1,1,10,2,3,"",0},
	{ "JOE",0,3,3,28,2,3,"",0},
	{ "JOE",0,4,5,38,1,0,"",0},
	
	{ "JOE",1,1,1,45,-1,0,"",0},
	{ "JOE",1,3,3,28,2,3,"",0},
	{ "JOE",1,4,5,38,1,0,"",0},
	
	{ "JOE",2,1,1,46,-1,0,"",0},
	{ "JOE",2,3,3,28,2,3,"",0},
	{ "JOE",2,4,5,38,1,0,"",0},
	
	{ "JOE",3,1,1,47,-1,0,"",0},
	{ "JOE",3,3,3,28,2,3,"",0},
	{ "JOE",3,4,5,38,1,0,"",0},
	
	{ "JOE",4,1,1,50,-1,0,"",0},
	{ "JOE",4,3,3,28,2,3,"",0},
	{ "JOE",4,4,5,38,1,0,"",0},
	
	{ "JOE",5,1,2,0,0,0,"",0},
	{ "JOE",5,3,4,0,0,0,"",0},
	{ "JOE",5,4,6,0,0,0,"",0},
	
	{ "JOE",6,1,1,48,0,1,"",0},
	{ "JOE",6,3,3,28,2,3,"",0},
	{ "JOE",6,4,5,38,1,0,"",0},

	{ "JOE",7,1,1,51,0,1,"",0},
	{ "JOE",7,3,3,28,2,3,"",0},
	{ "JOE",7,4,5,38,1,0,"",0},
	
	{ "JOE",8,1,1,26,0,0,"",0},
	{ "JOE",8,3,3,28,2,3,"",0},
	{ "JOE",8,4,5,38,1,0,"",0},
	
	{ "JOE",9,1,1,29,0,0,"",0},
	{ "JOE",9,3,3,28,0,0,"",0},
	{ "JOE",9,4,5,38,0,0,"",0},
	
	{ "JOE",10,1,1,12,0,0,"T046,010,010,010,012,012,012,012,012,012,012,012,012,012,012,012,012,012,010,000",0},
	{ "JOE",10,3,3,18,0,0,"",0},
	{ "JOE",10,4,5,44,0,0,"",0},
	
	{ "JOE",11,1,1,53,-1,0,"",0},
	{ "JOE",11,3,3,28,2,3,"",0},
	{ "JOE",11,4,5,38,1,0,"",0},
	
	{ "JOE",12,1,1,10,2,3,"",0},
	{ "JOE",12,3,3,28,2,0,"",0},
	{ "JOE",12,4,5,38,1,0,"",0},
	
	{ "JOE",13,1,1,10,2,3,"T012,013,019,019,019,019,019,019,019,019,019,019,013,010,000",0},
	{ "JOE",13,3,3,28,2,3,"",0},
	{ "JOE",13,4,5,38,1,0,"",0},

	{ "JOE",14,1,1,16,2,3,"",16},
	{ "JOE",14,3,3,28,2,3,"",0},
	{ "JOE",14,4,5,38,1,0,"",0},

	{ "JOE",15,1,1,58,-1,0,"",0},
	{ "JOE",15,3,3,28,2,3,"",0},
	{ "JOE",15,4,5,38,1,0,"",0},

	{ "JOE",16,1,1,59,-1,0,"",0},
	{ "JOE",16,3,3,28,2,3,"",0},
	{ "JOE",16,4,5,38,1,0,"",0},

	{ "JOE",17,1,1,56,-1,0,"",0},
	{ "JOE",17,3,3,28,2,3,"",0},
	{ "JOE",17,4,5,38,1,0,"",0},

	{ "JOE",18,1,56,16,2,3,"T056,057,057,057,056,056,000",0},
	{ "JOE",18,3,3,28,2,3,"",0},
	{ "JOE",18,4,5,38,1,0,"",0},

	{ "JOE",19,1,54,16,2,3,"T054,055,057,056,000",0},
	{ "JOE",19,3,3,28,2,3,"",0},
	{ "JOE",19,4,5,38,1,0,"",0},

	{ "JOE",20,1,56,16,2,3,"T056,057,055,054,001,000",0},
	{ "JOE",20,3,3,28,2,3,"",0},
	{ "JOE",20,4,5,38,1,0,"",0},
	{ "JOE",21,1,1,60,-1,0,"",0},
	{ "JOE",21,3,3,28,2,3,"",0},
	{ "JOE",21,4,61,38,1,0,"",0},

	{ "JOE",22,1,1,16,2,3,"T063,060,000",0},
	{ "JOE",22,3,3,28,2,3,"",0},
	{ "JOE",22,4,5,38,1,0,"",0},

	{ "JOE",23,1,1,16,2,3,"T060,063,001,000",0},
	{ "JOE",23,3,3,28,2,3,"",0},
	{ "JOE",23,4,5,38,1,0,"",0},

	{ "JOE",24,1,1,47,-2,0,"",0},
	{ "JOE",24,3,3,28,2,3,"",0},
	{ "JOE",24,4,5,38,1,0,"",0},

	{ "RICO",0,0,1,7,1,3,"",7},
	{ "RICO",1,0,1,5,-1,0,"",7},
	{ "RICO",2,0,1,9,0,3,"",7},
	{ "RICO",3,0,1,4,-1,0,"",7},

	{ "EDDY",0,0,14,18,1,3,"",18},
	{ "EDDY",1,0,14,0,0,0,"T016,017,017,016,016,017,017,016,016,017,017,000",18},

	{ "MIKE",0,0,1,2,2,3,"",2},

	{ "LOLA",0,0,30,33,2,3,"",33},
	{ "LOLA",1,0,9,10,2,3,"",33},
	{ "LOLA",2,0,30,33,2,3,"",33},
	{ "LOLA",3,0,32,33,2,3,"",33},
	{ "LOLA",4,0,8,0,0,0,"",33},
	{ "LOLA",5,0,31,0,0,0,"",0},
	{ "LOLA",6,0,31,0,0,0,"047,048,049,050,000",33},
DO_EndFunc
DO_AddFunc(2)
	{ "LOLA_SHOWER",0,0,7,10,2,3,"",10},
	{ "LOLA_SHOWER",1,0,9,10,2,3,"",10},
	{ "LOLA_SHOWER",2,0,30,33,2,3,"",10},
	{ "LOLA_SHOWER",3,0,32,33,2,3,"",10},
	{ "LOLA_SHOWER",4,0,8,0,0,0,"",0},
	{ "LOLA_SHOWER",5,0,61,0,0,0,"",0},
	{ "LOLA_SHOWER",6,0,64,10,2,3,"",0},
	{ "LOLA_SHOWER",7,0,31,0,0,0,"062,063,064,000",0},

	{ "SECRETARY",0,0,1,12,2,3,"",12},
	{ "SECRETARY",1,0,1,12,2,0,"",12},
	{ "SECRETARY",2,0,1,12,2,0,"",12},

	{ "SPARKY",0,0,21,23,2,3,"",23},
	{ "SPARKY",1,0,21,22,0,0,"",0},
	{ "SPARKY",2,0,21,22,0,0,"021,042,043,000",0},
	{ "SPARKY",3,0,21,22,0,0,"043,042,021,000",0},
	{ "SPARKY",4,0,43,43,1,0,"",0},
	{ "SPARKY",14,0,21,29,5,0,"",29},

	{ "SPARKY-F",0,0,45,23,5,0,"",23},
	{ "SPARKY-F",1,0,45,47,0,0,"",0},
	{ "SPARKY-F",2,0,45,23,5,0,"045,046,046,045,000",23},
	{ "SPARKY-F",14,0,45,29,5,0,"",29},

	{ "FAYE",0,0,19,35,2,3,"",35},
	{ "FAYE",1,0,19,41,2,3,"",35},
	{ "FAYE",2,0,19,28,-1,0,"",35},
	{ "FAYE",3,0,19,20,0,0,"",0},
	{ "FAYE",4,0,19,27,-1,0,"",35},
	{ "FAYE",5,0,19,29,-1,0,"",35},
	{ "FAYE",6,0,59,35,2,3,"",35},
	{ "FAYE",7,0,19,30,-1,0,"",35},
	{ "FAYE",8,0,19,31,-1,0,"",35},

	{ "BOB",0,0,27,34,2,3,"",34},
	{ "BOB",1,0,27,28,-1,0,"",34},
	{ "BOB",2,0,30,0,0,0,"",0},
	{ "BOB",3,0,31,0,0,0,"",0},
	{ "BOB",4,0,27,61,-1,0,"",34},
	{ "BOB",5,0,27,42,1,0,"",42},

	{ "PYGMY",0,0,20,21,2,6,"",0},
	{ "PYGMY",1,0,20,21,2,6,"020,068,068,068,068,068,068,068,068,020,000",0},
	{ "PYGMY",2,0,20,21,2,6,"T028,029,030,031,031,031,031,030,029,028,035,000",0},
	{ "PYGMY",3,0,20,21,2,6,"T035,036,037,038,037,038,037,038,036,035,000",0},
	{ "PYGMY",4,0,20,21,2,6,"T032,033,032,033,032,033,035,000",0},
	{ "PYGMY",5,0,20,21,2,6,"T023,022,021,022,023,024,025,026,027,026,025,024,023,000",0},
	{ "PYGMY",6,0,20,21,2,6,"T034,034,034,035,000",0},

	{ "WITCH",0,0,39,40,2,6,"",40},
	{ "WITCH",1,0,39,40,2,6,"073,074,000",40},
	{ "WITCH",2,0,39,40,2,6,"074,073,000",40},
	{ "WITCH",3,0,39,40,2,6,"T047,048,049,050,051,000",40},
	{ "WITCH",4,0,39,40,2,6,"T052,053,054,055,056,057,058,057,056,056,056,055,054,053,052,000",40},
	{ "WITCH",5,0,39,40,2,6,"069,070,071,072,073,074,000",40},
	{ "WITCH",6,0,39,40,2,6,"074,073,072,071,070,069,070,000",40},
	{ "WITCH",7,0,39,51,-1,0,"",40},
	{ "WITCH",8,0,39,40,2,6,"T051,050,049,048,047,000",40},

	{ "CHIEF",0,0,1,7,1,7,"",3},
	{ "CHIEF",1,0,1,2,2,6,"062,063,064,065,066,000",0},
	{ "CHIEF",2,0,1,2,2,6,"066,065,064,063,062,000",0},
	{ "CHIEF",3,0,1,17,-1,0,"",3},
	{ "CHIEF",4,0,1,18,-1,0,"",3},
	{ "CHIEF",5,0,1,19,-1,0,"",3},

	{ "NAOMI",0,0,1,2,2,3,"",2},
	{ "NAOMI",1,0,1,2,2,6,"048,049,050,051,052,053,054,055,000",0},
	{ "NAOMI",2,0,1,2,2,6,"055,054,053,052,051,050,049,048,000",0},
	{ "NAOMI",3,0,1,13,-1,0,"",2},
	{ "NAOMI",4,0,1,14,-1,0,"",2},
	{ "NAOMI",5,0,1,10,-1,0,"",2},
	{ "NAOMI",6,0,1,12,-1,0,"",2},
	{ "NAOMI",7,0,1,12,-1,0,"T008,008,008,002,000",2},

	{ "WEDGEWOOD",0,0,8,1,2,0,"",8},
	{ "WEDGEWOOD",1,0,1,1,3,0,"",1},

	{ "BUD",0,0,1,2,3,2,"",2},
	{ "BUD",1,0,1,2,4,2,"T017,018,000",2},
	{ "BUD",2,0,1,21,-1,0,"",2},
	{ "BUD",3,0,1,14,-1,0,"",2},
	{ "BUD",4,0,1,15,-1,0,"",2},
	{ "BUD",5,0,1,20,-1,0,"",2},
	{ "BUD",6,0,1,16,-1,0,"",2},
	{ "BUD",7,0,1,19,-1,0,"",2},
	{ "BUD",8,0,1,17,-1,0,"",2},
	{ "BUD",9,0,1,14,-1,0,"T014,008,008,003,003,008,008,003,003,010,010,012,012,000",2},

	{ "LOU",0,0,1,2,2,3,"",2},
	{ "LOU",1,0,1,2,4,2,"013,014,015,016,017,018,000",2},
	{ "LOU",2,0,1,2,4,2,"018,017,016,015,014,013,000",2},

	{ "JIMMY",0,0,16,17,2,3,"",17},
	{ "JIMMY",1,0,16,25,-1,0,"",17},
	{ "JIMMY",2,0,16,26,-1,0,"",17},
	{ "JIMMY",3,0,16,27,-1,0,"",17},
	{ "JIMMY",4,0,16,28,-1,0,"",17},
	{ "JIMMY",5,0,16,29,-1,0,"",17},

	{ "TAMMY",0,0,1,2,2,3,"",2},
	{ "TAMMY",1,0,1,2,2,3,"T008,008,009,009,008,008,009,009,008,008,009,009,002,000",2},
	{ "TAMMY",2,0,1,2,2,3,"T002,010,010,010,002,000",2},
	{ "TAMMY",3,0,1,2,2,3,"T011,011,011,011,011,002,000",2},
	{ "TAMMY",4,0,1,2,2,3,"T013,014,015,013,014,015,013,009,001,000",2},

	{ "SKULL",0,0,9,9,4,0,"",0},
	{ "SKULL",1,0,1,9,4,0,"001,002,003,004,005,006,007,008,009,000",0},
	{ "SKULL",2,0,1,9,4,0,"009,008,007,006,005,004,003,002,001,000",0},
DO_EndFunc
DO_AddFunc(3)
	{ "APE",0,0,1,6,7,0,"",6},
	{ "APE",1,0,1,6,7,0,"002,001,000",6},
	{ "APE",2,0,1,6,7,0,"002,003,001,000",6},
	{ "APE",3,0,1,6,7,0,"004,005,004,005,004,001,000",6},
	{ "APE",4,0,1,6,7,0,"001,003,005,004,005,004,001,000",6},

	{ "APE1",0,0,15,16,7,0,"",16},
	{ "APE2",0,0,14,6,7,0,"",6},

	{ "SHOWERAM",0,0,1,2,3,0,"",2},
	{ "SHOWERAM",1,0,1,2,3,0,"026,027,028,029,001,000",2},
	{ "SHOWERAM",2,0,1,2,3,0,"001,029,028,027,026,000",2},

	{ "PRINCESS1",0,0,19,23,2,3,"",23},
	{ "PRINCESS1",1,0,19,41,-1,0,"",23},
	{ "PRINCESS1",2,0,19,42,-1,0,"",23},
	{ "PRINCESS1",3,0,19,45,-1,0,"",23},
	{ "PRINCESS1",4,0,19,40,-1,0,"",23},
	{ "PRINCESS1",5,0,19,45,2,3,"T40,043,044,045,000",45},
	{ "PRINCESS1",6,0,19,45,-1,0,"T041,038,000",38},
	{ "PRINCESS1",7,0,22,0,0,0,"",0},
	{ "PRINCESS1",8,0,19,45,2,3,"T045,044,043,040,039,000",39},

	{ "PRINCESS2",0,0,46,23,2,3,"",23},
	{ "PRINCESS2",1,0,46,29,2,3,"",29},
	{ "PRINCESS2",2,0,46,29,2,3,"T029,036,035,000",35},

	{ "GUARDS",0,0,7,7,0,0,"",7},

	{ "AMGUARD",0,0,19,22,2,3,"",22},

	{ "MAN1",0,0,2,3,2,3,"",3},
	{ "MAN2",0,0,9,10,1,2,"",10},

	{ "DOG",0,0,6,6,1,0,"",0},
	{ "DOG",1,0,6,6,1,0,"010,009,008,000",0},
	{ "DOG",2,0,6,6,1,0,"008,009,010,000",0},

	{ "CHEF",0,0,5,6,2,3,"",6},

	{ "HENRY",0,0,7,9,2,3,"",9},
	{ "HENRY",1,0,7,21,-1,0,"",9},
	{ "HENRY",2,0,7,19,-1,0,"",9},
	{ "HENRY",3,0,7,20,-1,0,"",9},
	{ "HENRY",4,0,8,9,2,3,"",9},
	{ "HENRY",5,0,23,9,-1,0,"",9},
	{ "HENRY",6,0,7,9,2,3,"T019,015,017,017,017,017,017,017,017,015,009,000",9},
	{ "HENRY",7,0,7,9,2,3,"T018,010,000",10},
	{ "HENRY",8,0,7,9,2,3,"T018,016,000",16},
	{ "HENRY",9,0,7,9,2,3,"T018,011,000",11},
	{ "HENRY",10,0,29,33,1,1,"",33},
	{ "HENRY",11,0,7,30,2,0,"",9},
	{ "HENRY",12,0,7,9,2,3,"025,026,000",26},
	{ "HENRY",13,0,7,9,2,3,"027,028,027,028,000",28},
	{ "HENRY",14,0,7,9,2,3,"026,025,007,000",9},

	{ "JOHAN",0,0,1,15,2,3,"",15},
	{ "JOHAN",1,0,1,0,0,0,"T006,007,008,000",15},
	{ "JOHAN",2,0,1,15,2,3,"T002,003,004,005,004,005,004,005,004,005,004,005,004,003,002,000",15},
	{ "JOHAN",3,0,1,8,-1,0,"",15},
	{ "JOHAN",4,0,1,0,0,0,"T008,007,006,001,000",15},

	{ "KLUNK",0,0,1,2,2,3,"",2},
	{ "KLUNK",1,0,1,2,2,3,"019,020,021,022,001,000",2},
	{ "KLUNK",2,0,1,2,2,3,"001,022,021,020,019,016,517,000",2},
	{ "KLUNK",3,0,1,2,2,3,"T010,011,010,011,010,011,009,000",2},

	{ "FRANK",0,0,13,14,2,3,"",14},
	{ "FRANK",1,0,13,20,0,1,"",14},
	{ "FRANK",2,0,13,14,2,3,"025,026,027,027,027,026,026,026,027,027,026,026,027,025,013,000",14},
	{ "FRANK",3,0,28,14,2,3,"",14},

	{ "DEATH",0,0,1,2,2,3,"",2},
	{ "DEATH",1,0,1,2,2,3,"013,014,015,016,017,001,000",0},
	{ "DEATH",2,0,1,2,2,3,"001,017,016,015,014,013,000",0},
	{ "DEATH",3,0,1,2,2,3,"T018,019,020,021,021,022,022,020,021,022,020,021,022,023,024,524,000",2},
	{ "DEATH",4,0,1,2,2,3,"T025,026,027,028,028,028,028,028,028,028,028,028,029,035,000",2},
	{ "DEATH",5,0,1,2,2,3,"T030,031,032,033,033,033,033,033,033,033,033,033,034,035,000",2},
	{ "DEATH",6,0,1,2,2,3,"T023,022,020,019,018,001,000",2},

	{ "JASPAR",0,0,1,1,22,0,"026,027,028,029,028,029,028,029,030,023,000",0},
	{ "JASPAR",1,0,1,1,22,0,"023,026,000",0},

	{ "ORACLE",0,0,1,5,3,0,"",0},

	{ "ZOMBIE",0,0,1,5,2,3,"",5},
	{ "ZOMBIE",1,0,1,12,-1,0,"",5},
	{ "ZOMBIE",2,0,1,13,-1,0,"",5},
	{ "ZOMBIE",3,0,1,1,5,5,"",5},

	{ "ZOMBIE2",0,0,14,14,0,0,"",0},
	{ "ZOMBIE3",0,0,18,18,0,0,"",0},

	{ "ANDERSON",0,0,7,8,2,3,"",8},
	{ "ANDERSON",1,0,7,8,1,0,"",8},
	{ "ANDERSON",2,0,7,16,-1,0,"",8},
	{ "ANDERSON",3,0,7,18,-1,0,"",8},
	{ "ANDERSON",4,0,7,19,-1,0,"",8},
	{ "ANDERSON",5,0,7,20,-1,0,"",8},
	{ "ANDERSON",6,0,7,21,1,0,"",8},

	{ "COMPY",0,0,12,12,-1,0,"",0},
	{ "COMPY",1,0,10,10,10,0,"010,011,012,012,013,014,014,000",0},
	{ "COMPY",2,0,10,10,10,0,"014,013,012,000",0},

	{ "DEINO",0,0,13,13,-1,0,"",0},
	{ "DEINO",1,0,9,9,9,0,"009,010,000",0},

	{ "TMPD",0,0,19,22,2,3,"",22},

	{ "IAN",0,0,7,9,2,3,"",9},
	{ "IAN",1,0,8,25,3,0,"",25},
	{ "IAN",2,0,7,21,-1,0,"",9},
	{ "IAN",3,0,7,22,1,0,"",9},
	{ "IAN",4,0,7,22,-1,0,"",9},
	{ "IAN",5,0,7,24,-1,0,"",9},
	{ "IAN",6,0,7,9,2,3,"034,034,034,035,035,036,036,035,035,036,035,036,035,000",9},
	{ "IAN",7,0,7,31,-1,0,"",9},
DO_EndFunc
DO_AddFunc(4)
	{ "FAYE-H",0,0,1,1,4,1,"",1},
	{ "FAYE-H",1,0,1,1,4,1,"007,000",7},
	{ "FAYE-H",2,0,1,1,4,1,"009,010,011,009,001,000",1},
	{ "FAYE-H",3,0,1,1,4,1,"E012,013,000",1},
	{ "FAYE-H",4,0,1,1,4,1,"E015,000",1},
	{ "FAYE-H",5,0,1,1,4,1,"E014,000",1},

	{ "AZURA-H",0,0,1,1,4,1,"",1},
	{ "AZURA-H",1,0,1,1,4,1,"007,000",7},
	{ "AZURA-H",2,0,1,1,4,1,"009,010,011,009,001,000",1},
	{ "AZURA-H",3,0,1,1,4,1,"E012,013,000",1},
	{ "AZURA-H",4,0,1,1,4,1,"E015,000",1},
	{ "AZURA-H",5,0,1,1,4,1,"E014,000",1},

	{ "FRANK-H",0,0,1,1,4,1,"",1},
	{ "FRANK-H",1,0,1,1,4,1,"E009,000",1},
	{ "FRANK-H",2,0,1,1,4,1,"E007,000",1},
	{ "FRANK-H",3,0,1,1,4,1,"010,011,012,013,014,015,010,000",1},

	{ "JOE-E",0,0,1,2,4,1,"",2},
	{ "JOE-E",6,0,1,2,4,1,"008,009,008,002,000",2},

	{ "AZURA-E",0,0,1,1,5,1,"",1},
	{ "AZURA-E",1,0,1,1,5,1,"009,010,009,008,000",1},

	{ "FAYE-E",0,0,1,4,4,1,"",1},
	{ "FAYE-E",1,0,1,4,4,1,"002,003,002,001,000",1},

	{ "ANDSON-E",0,0,1,3,4,1,"",1},
	{ "ANDSON-E",1,0,1,3,4,1,"002,001,000",1},

	{ "JOE-H",0,0,1,1,4,4,"",1},
	{ "JOE-H",1,0,1,1,2,3,"012,013,014,000",14},
	{ "JOE-H",2,0,1,1,2,3,"010,011,000",11},
	{ "JOE-H",3,0,1,1,2,3,"014,013,012,001,000",1},
	{ "JOE-H",4,0,1,13,1,0,"",13},

	{ "RITA-H",0,0,7,1,2,3,"",1},
	{ "RITA-H",1,0,7,0,0,0,"009,010,011,012,013,000",13},
	{ "RITA-H",2,0,7,0,0,0,"014,015,016,000",16},
	{ "RITA-H",3,0,7,0,0,0,"013,012,011,010,000",10},
	{ "RITA-H",4,0,7,0,0,0,"009,007,008,007,009,000",9},
	{ "RITA-H",5,0,7,0,0,0,"016,015,014,000",14},

	{ "RITA",0,0,1,4,2,3,"",4},
	{ "RITA",1,0,2,4,2,3,"",4},

	{ "SPARKY-H",0,0,1,1,2,3,"",1},

	{ "HUGH",0,0,1,1,2,3,"",1},
	{ "HUGH",1,0,7,7,2,3,"",7},

	{ "X2_JOE",0,0,1,1,2,3,"",1},
	{ "X2_JOE",1,0,1,1,2,3,"001,007,008,008,007,001,000",1},

	{ "X2_RITA",0,0,1,1,2,3,"",1},
	{ "X2_RITA",1,0,1,1,2,3,"001,007,008,008,007,001,000",1},

	{ "X3_RITA",0,0,1,1,4,1,"",1},
	{ "X3_RITA",1,0,1,1,4,1,"007,000",7},
	{ "X3_RITA",2,0,1,1,4,1,"009,010,011,009,001,000",1},
	{ "X3_RITA",3,0,1,1,4,1,"E012,013,000",1},
	{ "X3_RITA",4,0,1,1,4,1,"E015,000",1},
	{ "X3_RITA",5,0,1,1,4,1,"E014,000",1},

	{ "X4_JOE",0,0,1,1,3,4,"",1},
	{ "X4_JOE",1,0,1,13,2,3,"",13},
	{ "X4_JOE",2,0,1,1,3,4,"009,010,011,012,013,000",13},
	{ "X4_JOE",3,0,1,1,3,4,"012,011,010,009,000",9},
	{ "X4_JOE",4,0,1,1,3,4,"001,019,000",19},

	{ "X4_RITA",0,0,1,1,0,1,"",1},
	{ "X4_RITA",1,0,1,7,0,1,"",7},
	{ "X4_RITA",2,0,1,1,3,4,"004,005,006,006,006,006,007,000",7},
	{ "X4_RITA",3,0,1,1,3,4,"005,004,001,000",1},
	{ "X4_RITA",4,0,1,1,3,4,"001,003,000",3},

	{ "X5_SPARKY",0,0,1,1,2,3,"",1},
	{ "X5_SPARKY",1,0,1,1,2,3,"001,010,011,011,001,000",1},
	{ "X5_SPARKY",2,0,1,1,2,3,"001,007,008,009,000",9},

	{ "X6_HUGH",0,0,1,1,2,3,"",1},
	{ "X6_HUGH",1,0,1,1,2,3,"007,007,007,007,,001,000",1},
	{ "X6_HUGH",2,0,1,1,2,3,"008,008,008,008,008,009,009,008,008,008,009,008,000",8},

	{ "X10_JOE",0,0,1,2,2,3,"",2},
	{ "X10_JOE",1,0,1,8,2,3,"",8},
	{ "X10_JOE",2,0,1,2,2,3,"014,014,014,015,015,014,014,015,015,000",2},

	{ "X10_RITA",0,0,1,2,2,3,"",2},

	{ "X11_JOE",0,0,1,2,0,1,"",2},

	{ "X11_RITA",0,0,1,2,0,1,"",2},
	{ "X11_RITA",1,0,1,2,1,0,"003,004,000",4},

	{ "JOHN", 0, 0, 1, 2, 2, 3, "", 1 },
	{ "JOHN", 1, 0, 1, 15, -1, 0, "", 1 },
	{ "JOHN", 2, 0, 1, 16, -1, 0, "", 1 },
	{ "JOHN", 3, 0, 1, 17, -1, 0, "", 1 },

	{ "STEVE", 0, 0, 8, 2, 2, 3, "", 2 },
	{ "STEVE", 1, 0, 8, 16, -1, 0, "", 2 },
	{ "STEVE", 2, 0, 9, 18, -1, 0, "T016,017,017,016,008,000", 2 },
	{ "STEVE", 3, 0, 8, 18, -1, 0, "", 2 },

	{ "TONY", 0, 0, 1, 2, 2, 3, "", 1 },
	{ "TONY", 1, 0, 1, 12, -1, 0, "", 1 },

	{ "*",0,0,0,0,0,0,"",0}
DO_EndFunc

static void addTalk_speechParameters() {
	UInt32 remove, size;

	remove = 10;
	ptr = MemPtrNew(remove);
	
	size = addTalk_speechParameters_part1();
	size = addTalk_speechParameters_part2();
	size = addTalk_speechParameters_part3();
	size = addTalk_speechParameters_part4();

	size = MemPtrSize(ptr) - remove;

	writeRecord(ptr + remove, size, GBVARS_SPEECHPARAMETERS_INDEX , GBVARS_QUEEN);
	MemPtrFree(ptr);
}

void Queen_addTalk() {
	addTalk_speechParameters();
}
