/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compacts/74comp.h,v 1.11 2004/01/06 12:45:33 fingolfin Exp $ 
 *
 */

#ifndef SKY74COMP_H
#define SKY74COMP_H




namespace Sky {

namespace SkyCompact {

Compact sc74_monitor3 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	258,	// xcood
	186,	// ycood
	57*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_MONITOR3_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

Compact sc74_pod = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_FOREGROUND+ST_RECREATE,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	340,	// xcood
	193,	// ycood
	109*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_POD_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

Compact sc74_terminal = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	204,	// xcood
	227,	// ycood
	0,	// frame
	51,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	230-204,	// mouseSize_x
	253-227,	// mouseSize_y
	SC74_TERMINAL_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 sc74_int_table[] = {
	ID_SC74_FLOOR,
	GT_SC74_FLOOR,
	ID_SC74_DOOR,
	GT_SC74_FLOOR,
	ID_SC74_MONITOR1,
	GT_SC74_FLOOR,
	ID_SC74_LEFT_TV,
	GT_SC74_FLOOR,
	ID_SC74_RIGHT_TV,
	GT_SC74_FLOOR,
	ID_SC74_INTERFACE,
	RET_OK,
	ID_SC74_INT_SLOT,
	GT_SC74_FLOOR,
	ID_SC74_TERMINAL,
	GT_SC74_FLOOR,
	65535
};

Compact sc74_interface = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	74,	// screen
	0,	// place
	sc74_int_table,	// getToTable
	340,	// xcood
	241,	// ycood
	0,	// frame
	56,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	366-340,	// mouseSize_x
	290-241,	// mouseSize_y
	SC74_INTERFACE_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 sc74_mon4_anim[] = {
	58*64,
	281,
	186,
	0,
	281,
	186,
	0,
	281,
	186,
	0,
	281,
	186,
	0,
	281,
	186,
	0,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	2,
	281,
	186,
	2,
	281,
	186,
	2,
	281,
	186,
	2,
	281,
	186,
	2,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	9,
	281,
	186,
	9,
	281,
	186,
	9,
	281,
	186,
	9,
	281,
	186,
	9,
	281,
	186,
	10,
	281,
	186,
	10,
	281,
	186,
	10,
	281,
	186,
	10,
	281,
	186,
	10,
	281,
	186,
	11,
	281,
	186,
	11,
	281,
	186,
	11,
	281,
	186,
	11,
	281,
	186,
	11,
	281,
	186,
	12,
	281,
	186,
	12,
	281,
	186,
	12,
	281,
	186,
	12,
	281,
	186,
	12,
	281,
	186,
	13,
	281,
	186,
	13,
	281,
	186,
	13,
	281,
	186,
	13,
	281,
	186,
	13,
	281,
	186,
	14,
	281,
	186,
	14,
	281,
	186,
	14,
	281,
	186,
	14,
	281,
	186,
	14,
	281,
	186,
	15,
	281,
	186,
	15,
	281,
	186,
	15,
	281,
	186,
	15,
	281,
	186,
	15,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	17,
	281,
	186,
	17,
	281,
	186,
	17,
	281,
	186,
	17,
	281,
	186,
	17,
	281,
	186,
	18,
	281,
	186,
	18,
	281,
	186,
	18,
	281,
	186,
	18,
	281,
	186,
	18,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	28,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	27,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	26,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	25,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	24,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	23,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	22,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	21,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	20,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	19,
	281,
	186,
	29,
	281,
	186,
	29,
	281,
	186,
	29,
	281,
	186,
	29,
	281,
	186,
	29,
	281,
	186,
	30,
	281,
	186,
	30,
	281,
	186,
	30,
	281,
	186,
	30,
	281,
	186,
	30,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	16,
	281,
	186,
	31,
	281,
	186,
	31,
	281,
	186,
	31,
	281,
	186,
	31,
	281,
	186,
	31,
	281,
	186,
	32,
	281,
	186,
	32,
	281,
	186,
	32,
	281,
	186,
	32,
	281,
	186,
	32,
	281,
	186,
	33,
	281,
	186,
	33,
	281,
	186,
	33,
	281,
	186,
	33,
	281,
	186,
	33,
	281,
	186,
	34,
	281,
	186,
	34,
	281,
	186,
	34,
	281,
	186,
	34,
	281,
	186,
	34,
	281,
	186,
	35,
	281,
	186,
	35,
	281,
	186,
	35,
	281,
	186,
	35,
	281,
	186,
	35,
	281,
	186,
	36,
	281,
	186,
	36,
	281,
	186,
	36,
	281,
	186,
	36,
	281,
	186,
	36,
	281,
	186,
	37,
	281,
	186,
	37,
	281,
	186,
	37,
	281,
	186,
	37,
	281,
	186,
	37,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	8,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	7,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	6,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	5,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	4,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	3,
	281,
	186,
	38,
	281,
	186,
	38,
	281,
	186,
	38,
	281,
	186,
	38,
	281,
	186,
	38,
	281,
	186,
	39,
	281,
	186,
	39,
	281,
	186,
	39,
	281,
	186,
	39,
	281,
	186,
	39,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	281,
	186,
	1,
	0
};

uint16 sc74_rtv_anim[] = {
	60*64,
	298,
	212,
	0,
	298,
	212,
	0,
	298,
	212,
	1,
	298,
	212,
	1,
	298,
	212,
	2,
	298,
	212,
	2,
	298,
	212,
	3,
	298,
	212,
	3,
	298,
	212,
	4,
	298,
	212,
	4,
	298,
	212,
	5,
	298,
	212,
	5,
	298,
	212,
	6,
	298,
	212,
	6,
	298,
	212,
	7,
	298,
	212,
	7,
	298,
	212,
	8,
	298,
	212,
	8,
	298,
	212,
	9,
	298,
	212,
	9,
	298,
	212,
	10,
	298,
	212,
	10,
	298,
	212,
	11,
	298,
	212,
	11,
	298,
	212,
	12,
	298,
	212,
	12,
	298,
	212,
	13,
	298,
	212,
	13,
	298,
	212,
	14,
	298,
	212,
	14,
	298,
	212,
	15,
	298,
	212,
	15,
	298,
	212,
	16,
	298,
	212,
	16,
	298,
	212,
	17,
	298,
	212,
	17,
	298,
	212,
	18,
	298,
	212,
	18,
	298,
	212,
	19,
	298,
	212,
	19,
	298,
	212,
	20,
	298,
	212,
	20,
	298,
	212,
	21,
	298,
	212,
	21,
	298,
	212,
	22,
	298,
	212,
	22,
	298,
	212,
	23,
	298,
	212,
	23,
	298,
	212,
	24,
	298,
	212,
	24,
	298,
	212,
	25,
	298,
	212,
	25,
	298,
	212,
	25,
	298,
	212,
	25,
	298,
	212,
	25,
	298,
	212,
	25,
	298,
	212,
	26,
	298,
	212,
	26,
	298,
	212,
	27,
	298,
	212,
	27,
	298,
	212,
	28,
	298,
	212,
	28,
	298,
	212,
	29,
	298,
	212,
	29,
	298,
	212,
	30,
	298,
	212,
	30,
	298,
	212,
	31,
	298,
	212,
	31,
	298,
	212,
	32,
	298,
	212,
	32,
	298,
	212,
	33,
	298,
	212,
	33,
	298,
	212,
	34,
	298,
	212,
	34,
	298,
	212,
	35,
	298,
	212,
	35,
	298,
	212,
	36,
	298,
	212,
	36,
	298,
	212,
	37,
	298,
	212,
	37,
	298,
	212,
	38,
	298,
	212,
	38,
	298,
	212,
	39,
	298,
	212,
	39,
	298,
	212,
	40,
	298,
	212,
	40,
	298,
	212,
	41,
	298,
	212,
	41,
	298,
	212,
	42,
	298,
	212,
	42,
	298,
	212,
	43,
	298,
	212,
	43,
	298,
	212,
	44,
	298,
	212,
	44,
	298,
	212,
	45,
	298,
	212,
	45,
	298,
	212,
	46,
	298,
	212,
	46,
	298,
	212,
	47,
	298,
	212,
	47,
	298,
	212,
	48,
	298,
	212,
	48,
	298,
	212,
	49,
	298,
	212,
	49,
	298,
	212,
	50,
	298,
	212,
	50,
	298,
	212,
	51,
	298,
	212,
	51,
	298,
	212,
	52,
	298,
	212,
	52,
	298,
	212,
	53,
	298,
	212,
	53,
	298,
	212,
	54,
	298,
	212,
	54,
	298,
	212,
	54,
	298,
	212,
	54,
	298,
	212,
	54,
	298,
	212,
	54,
	298,
	212,
	55,
	298,
	212,
	55,
	298,
	212,
	56,
	298,
	212,
	56,
	298,
	212,
	57,
	298,
	212,
	57,
	298,
	212,
	58,
	298,
	212,
	58,
	298,
	212,
	59,
	298,
	212,
	59,
	298,
	212,
	60,
	298,
	212,
	60,
	298,
	212,
	61,
	298,
	212,
	61,
	298,
	212,
	62,
	298,
	212,
	62,
	298,
	212,
	63,
	0
};

uint16 sc74_pod_down[] = {
	109*64,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	1,
	340,
	193,
	2,
	340,
	193,
	3,
	340,
	193,
	4,
	340,
	193,
	5,
	340,
	193,
	6,
	340,
	193,
	7,
	340,
	193,
	8,
	340,
	193,
	9,
	340,
	193,
	10,
	340,
	193,
	11,
	340,
	193,
	12,
	340,
	193,
	13,
	340,
	193,
	14,
	340,
	193,
	15,
	340,
	193,
	16,
	340,
	193,
	17,
	340,
	193,
	18,
	340,
	193,
	19,
	340,
	193,
	20,
	340,
	193,
	21,
	340,
	193,
	22,
	340,
	193,
	23,
	340,
	193,
	24,
	340,
	193,
	25,
	340,
	193,
	26,
	340,
	193,
	27,
	340,
	193,
	28,
	340,
	193,
	29,
	340,
	193,
	30,
	340,
	193,
	31,
	340,
	193,
	32,
	340,
	193,
	33,
	340,
	193,
	34,
	340,
	193,
	35,
	340,
	193,
	36,
	340,
	193,
	36,
	340,
	193,
	36,
	0
};

uint16 sc74_lights_anim[] = {
	61*64,
	243,
	253,
	0,
	243,
	253,
	0,
	243,
	253,
	0,
	243,
	253,
	1,
	243,
	253,
	1,
	243,
	253,
	1,
	0
};

uint16 sc74_pod_up[] = {
	110*64,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	0,
	340,
	193,
	1,
	340,
	193,
	2,
	340,
	193,
	3,
	340,
	193,
	4,
	340,
	193,
	5,
	340,
	193,
	6,
	340,
	193,
	7,
	340,
	193,
	8,
	340,
	193,
	9,
	340,
	193,
	10,
	340,
	193,
	11,
	340,
	193,
	12,
	340,
	193,
	13,
	340,
	193,
	14,
	340,
	193,
	15,
	340,
	193,
	16,
	340,
	193,
	17,
	340,
	193,
	18,
	340,
	193,
	19,
	340,
	193,
	20,
	340,
	193,
	21,
	340,
	193,
	22,
	340,
	193,
	23,
	340,
	193,
	24,
	340,
	193,
	25,
	340,
	193,
	26,
	340,
	193,
	27,
	340,
	193,
	28,
	340,
	193,
	29,
	340,
	193,
	30,
	340,
	193,
	31,
	340,
	193,
	32,
	340,
	193,
	33,
	340,
	193,
	34,
	340,
	193,
	35,
	0
};

Compact sc74_int_slot = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	377,	// xcood
	266,	// ycood
	94*64,	// frame
	50,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65529,	// mouseRel_x
	1,	// mouseRel_y
	378-370,	// mouseSize_x
	270-267,	// mouseSize_y
	SC74_INT_SLOT_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_INT_SLOT_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_mouse_list[] = {
	ID_SC74_INT_SLOT,
	ID_SC74_INTERFACE,
	ID_SC74_TERMINAL,
	ID_SC74_MONITOR1,
	ID_SC74_LEFT_TV,
	ID_SC74_RIGHT_TV,
	ID_SC74_DOOR,
	ID_SC74_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 sc74_chip_list[] = {
	IT_SC74_LAYER_0+DISK_7,
	IT_SC74_LAYER_1+DISK_7,
	IT_SC74_LAYER_2+DISK_7,
	IT_SC74_GRID_1+DISK_7,
	IT_SC74_GRID_2+DISK_7,
	IT_SC74_MONITOR1+DISK_7,
	IT_SC74_MONITOR2+DISK_7,
	IT_SC74_MONITOR3+DISK_7,
	IT_SC74_MONITOR4+DISK_7,
	IT_SC74_LEFT_TV+DISK_7,
	IT_SC74_LIGHTS+DISK_7,
	IT_SC74_POD_DOWN+DISK_7,
	IT_SC74_POD_UP+DISK_7,
	IT_SC74_FOST_SIT+DISK_7,
	IT_SC74_GET_UP+DISK_7,
	IT_SC74_USECARD+DISK_7,
	IT_SC74_USECARD2+DISK_7,
	IT_SC74_RPOCKET+DISK_7,
	94+DISK_7,
	0
};

Compact sc74_monitor2 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	235,	// xcood
	186,	// ycood
	56*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_MONITOR2_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_floor_table[] = {
	ID_SC74_FLOOR,
	RET_OK,
	ID_SC74_DOOR,
	GT_SC74_DOOR,
	0,
	SC74_DOOR_WALK_ON,
	ID_SC74_MONITOR1,
	GT_SC74_MONITOR1,
	ID_SC74_LEFT_TV,
	GT_SC74_LEFT_TV,
	ID_SC74_RIGHT_TV,
	GT_SC74_RIGHT_TV,
	ID_SC74_INTERFACE,
	GT_SC74_INTERFACE,
	ID_SC74_INT_SLOT,
	GT_SC74_INT_SLOT,
	ID_SC74_TERMINAL,
	GT_SC74_TERMINAL,
	65535
};

Compact sc74_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	74,	// screen
	0,	// place
	sc74_floor_table,	// getToTable
	150,	// xcood
	260,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	447-150,	// mouseSize_x
	327-260,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 reset_73_74[] = {
	C_SCREEN,
	74,
	C_PLACE,
	ID_SC74_FLOOR,
	C_XCOOD,
	160,
	C_YCOOD,
	280,
	65535
};

uint16 sc74_ltv_anim[] = {
	59*64,
	243,
	212,
	0,
	243,
	212,
	0,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	2,
	243,
	212,
	2,
	243,
	212,
	3,
	243,
	212,
	3,
	243,
	212,
	4,
	243,
	212,
	4,
	243,
	212,
	5,
	243,
	212,
	5,
	243,
	212,
	6,
	243,
	212,
	6,
	243,
	212,
	7,
	243,
	212,
	7,
	243,
	212,
	8,
	243,
	212,
	8,
	243,
	212,
	9,
	243,
	212,
	9,
	243,
	212,
	10,
	243,
	212,
	10,
	243,
	212,
	11,
	243,
	212,
	11,
	243,
	212,
	12,
	243,
	212,
	12,
	243,
	212,
	13,
	243,
	212,
	13,
	243,
	212,
	14,
	243,
	212,
	14,
	243,
	212,
	15,
	243,
	212,
	15,
	243,
	212,
	16,
	243,
	212,
	16,
	243,
	212,
	17,
	243,
	212,
	17,
	243,
	212,
	18,
	243,
	212,
	18,
	243,
	212,
	19,
	243,
	212,
	19,
	243,
	212,
	20,
	243,
	212,
	20,
	243,
	212,
	21,
	243,
	212,
	21,
	243,
	212,
	22,
	243,
	212,
	22,
	243,
	212,
	23,
	243,
	212,
	23,
	243,
	212,
	24,
	243,
	212,
	24,
	243,
	212,
	25,
	243,
	212,
	25,
	243,
	212,
	26,
	243,
	212,
	26,
	243,
	212,
	27,
	243,
	212,
	27,
	243,
	212,
	28,
	243,
	212,
	28,
	243,
	212,
	29,
	243,
	212,
	29,
	243,
	212,
	30,
	243,
	212,
	30,
	243,
	212,
	31,
	243,
	212,
	31,
	243,
	212,
	32,
	243,
	212,
	32,
	243,
	212,
	33,
	243,
	212,
	33,
	243,
	212,
	34,
	243,
	212,
	34,
	243,
	212,
	35,
	243,
	212,
	35,
	243,
	212,
	36,
	243,
	212,
	36,
	243,
	212,
	37,
	243,
	212,
	37,
	243,
	212,
	38,
	243,
	212,
	38,
	243,
	212,
	39,
	243,
	212,
	39,
	243,
	212,
	40,
	243,
	212,
	40,
	243,
	212,
	41,
	243,
	212,
	41,
	243,
	212,
	42,
	243,
	212,
	42,
	243,
	212,
	43,
	243,
	212,
	43,
	243,
	212,
	44,
	243,
	212,
	44,
	243,
	212,
	45,
	243,
	212,
	45,
	243,
	212,
	46,
	243,
	212,
	46,
	243,
	212,
	47,
	243,
	212,
	47,
	243,
	212,
	48,
	243,
	212,
	48,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	49,
	243,
	212,
	48,
	243,
	212,
	48,
	243,
	212,
	47,
	243,
	212,
	47,
	243,
	212,
	46,
	243,
	212,
	46,
	243,
	212,
	45,
	243,
	212,
	45,
	243,
	212,
	44,
	243,
	212,
	44,
	243,
	212,
	43,
	243,
	212,
	43,
	243,
	212,
	42,
	243,
	212,
	42,
	243,
	212,
	41,
	243,
	212,
	41,
	243,
	212,
	40,
	243,
	212,
	40,
	243,
	212,
	39,
	243,
	212,
	39,
	243,
	212,
	50,
	243,
	212,
	51,
	243,
	212,
	52,
	243,
	212,
	53,
	243,
	212,
	54,
	243,
	212,
	55,
	243,
	212,
	35,
	243,
	212,
	35,
	243,
	212,
	56,
	243,
	212,
	57,
	243,
	212,
	58,
	243,
	212,
	59,
	243,
	212,
	60,
	243,
	212,
	61,
	243,
	212,
	62,
	243,
	212,
	63,
	243,
	212,
	64,
	243,
	212,
	65,
	243,
	212,
	66,
	243,
	212,
	67,
	243,
	212,
	68,
	243,
	212,
	69,
	243,
	212,
	70,
	243,
	212,
	71,
	243,
	212,
	72,
	243,
	212,
	73,
	243,
	212,
	74,
	243,
	212,
	75,
	243,
	212,
	76,
	243,
	212,
	77,
	243,
	212,
	78,
	243,
	212,
	78,
	243,
	212,
	79,
	243,
	212,
	79,
	243,
	212,
	80,
	243,
	212,
	80,
	243,
	212,
	81,
	243,
	212,
	81,
	243,
	212,
	19,
	243,
	212,
	19,
	243,
	212,
	82,
	243,
	212,
	82,
	243,
	212,
	83,
	243,
	212,
	83,
	243,
	212,
	84,
	243,
	212,
	84,
	243,
	212,
	85,
	243,
	212,
	85,
	243,
	212,
	14,
	243,
	212,
	14,
	243,
	212,
	13,
	243,
	212,
	13,
	243,
	212,
	12,
	243,
	212,
	12,
	243,
	212,
	86,
	243,
	212,
	86,
	243,
	212,
	87,
	243,
	212,
	87,
	243,
	212,
	9,
	243,
	212,
	9,
	243,
	212,
	8,
	243,
	212,
	8,
	243,
	212,
	7,
	243,
	212,
	7,
	243,
	212,
	6,
	243,
	212,
	6,
	243,
	212,
	5,
	243,
	212,
	5,
	243,
	212,
	4,
	243,
	212,
	4,
	243,
	212,
	3,
	243,
	212,
	3,
	243,
	212,
	2,
	243,
	212,
	2,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	243,
	212,
	1,
	0
};

Compact sc74_left_tv = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	243,	// xcood
	212,	// ycood
	59*64,	// frame
	57,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65534,	// mouseRel_x
	(int16) 65533,	// mouseRel_y
	263-241,	// mouseSize_x
	230-209,	// mouseSize_y
	SC74_MONITORS_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_LEFT_TV_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_usecard[] = {
	70*64,
	360,
	240,
	0,
	360,
	240,
	1,
	360,
	240,
	2,
	360,
	240,
	2,
	360,
	240,
	2,
	360,
	240,
	2,
	360,
	240,
	2,
	360,
	240,
	1,
	360,
	240,
	0,
	0
};

uint32 *grid74 = 0;

uint16 sc74_fost_sit[] = {
	92*64,
	345,
	244,
	0,
	342,
	244,
	1,
	342,
	244,
	2,
	342,
	243,
	3,
	342,
	240,
	4,
	342,
	241,
	5,
	342,
	241,
	6,
	342,
	241,
	7,
	342,
	241,
	8,
	342,
	241,
	8,
	0
};

Compact sc74_door = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	183,	// xcood
	231,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_LEFT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	195-183,	// mouseSize_x
	288-231,	// mouseSize_y
	SC74_DOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact sc74_monitor4 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	281,	// xcood
	186,	// ycood
	58*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_MONITOR4_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_mon3_anim[] = {
	57*64,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	5,
	258,
	186,
	5,
	258,
	186,
	5,
	258,
	186,
	5,
	258,
	186,
	5,
	258,
	186,
	6,
	258,
	186,
	6,
	258,
	186,
	6,
	258,
	186,
	6,
	258,
	186,
	6,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	8,
	258,
	186,
	8,
	258,
	186,
	8,
	258,
	186,
	8,
	258,
	186,
	8,
	258,
	186,
	9,
	258,
	186,
	9,
	258,
	186,
	9,
	258,
	186,
	9,
	258,
	186,
	9,
	258,
	186,
	10,
	258,
	186,
	10,
	258,
	186,
	10,
	258,
	186,
	10,
	258,
	186,
	10,
	258,
	186,
	11,
	258,
	186,
	11,
	258,
	186,
	11,
	258,
	186,
	11,
	258,
	186,
	11,
	258,
	186,
	12,
	258,
	186,
	12,
	258,
	186,
	12,
	258,
	186,
	12,
	258,
	186,
	12,
	258,
	186,
	13,
	258,
	186,
	13,
	258,
	186,
	13,
	258,
	186,
	13,
	258,
	186,
	13,
	258,
	186,
	14,
	258,
	186,
	14,
	258,
	186,
	14,
	258,
	186,
	14,
	258,
	186,
	14,
	258,
	186,
	15,
	258,
	186,
	15,
	258,
	186,
	15,
	258,
	186,
	15,
	258,
	186,
	15,
	258,
	186,
	16,
	258,
	186,
	16,
	258,
	186,
	16,
	258,
	186,
	16,
	258,
	186,
	16,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	29,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	28,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	27,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	26,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	25,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	24,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	23,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	22,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	21,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	20,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	19,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	18,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	17,
	258,
	186,
	30,
	258,
	186,
	30,
	258,
	186,
	30,
	258,
	186,
	30,
	258,
	186,
	30,
	258,
	186,
	31,
	258,
	186,
	31,
	258,
	186,
	31,
	258,
	186,
	31,
	258,
	186,
	31,
	258,
	186,
	32,
	258,
	186,
	32,
	258,
	186,
	32,
	258,
	186,
	32,
	258,
	186,
	32,
	258,
	186,
	33,
	258,
	186,
	33,
	258,
	186,
	33,
	258,
	186,
	33,
	258,
	186,
	33,
	258,
	186,
	34,
	258,
	186,
	34,
	258,
	186,
	34,
	258,
	186,
	34,
	258,
	186,
	34,
	258,
	186,
	35,
	258,
	186,
	35,
	258,
	186,
	35,
	258,
	186,
	35,
	258,
	186,
	35,
	258,
	186,
	36,
	258,
	186,
	36,
	258,
	186,
	36,
	258,
	186,
	36,
	258,
	186,
	36,
	258,
	186,
	37,
	258,
	186,
	37,
	258,
	186,
	37,
	258,
	186,
	37,
	258,
	186,
	37,
	258,
	186,
	38,
	258,
	186,
	38,
	258,
	186,
	38,
	258,
	186,
	38,
	258,
	186,
	38,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	7,
	258,
	186,
	39,
	258,
	186,
	39,
	258,
	186,
	39,
	258,
	186,
	39,
	258,
	186,
	39,
	258,
	186,
	40,
	258,
	186,
	40,
	258,
	186,
	40,
	258,
	186,
	40,
	258,
	186,
	40,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	4,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	3,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	2,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	1,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	258,
	186,
	0,
	0
};

uint16 sc74_get_up[] = {
	93*64,
	342,
	241,
	0,
	342,
	241,
	1,
	342,
	241,
	2,
	342,
	241,
	3,
	342,
	240,
	4,
	342,
	243,
	5,
	342,
	244,
	6,
	346,
	244,
	7,
	350,
	244,
	8,
	355,
	242,
	9,
	0
};

Compact sc74_monitor1 = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	213,	// xcood
	189,	// ycood
	55*64,	// frame
	20654,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65534,	// mouseRel_x
	(int16) 65533,	// mouseRel_y
	346-211,	// mouseSize_x
	206-186,	// mouseSize_y
	SC74_MONITORS_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_MONITOR1_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_mon1_anim[] = {
	55*64,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	10,
	213,
	189,
	11,
	213,
	189,
	11,
	213,
	189,
	12,
	213,
	189,
	13,
	213,
	189,
	14,
	213,
	189,
	15,
	213,
	189,
	16,
	213,
	189,
	17,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	19,
	213,
	189,
	20,
	213,
	189,
	21,
	213,
	189,
	21,
	213,
	189,
	22,
	213,
	189,
	23,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	25,
	213,
	189,
	26,
	213,
	189,
	26,
	213,
	189,
	27,
	213,
	189,
	28,
	213,
	189,
	29,
	213,
	189,
	30,
	213,
	189,
	31,
	213,
	189,
	31,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	10,
	213,
	189,
	11,
	213,
	189,
	11,
	213,
	189,
	12,
	213,
	189,
	13,
	213,
	189,
	14,
	213,
	189,
	15,
	213,
	189,
	16,
	213,
	189,
	17,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	19,
	213,
	189,
	20,
	213,
	189,
	21,
	213,
	189,
	21,
	213,
	189,
	22,
	213,
	189,
	23,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	25,
	213,
	189,
	26,
	213,
	189,
	26,
	213,
	189,
	27,
	213,
	189,
	28,
	213,
	189,
	29,
	213,
	189,
	30,
	213,
	189,
	31,
	213,
	189,
	31,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	10,
	213,
	189,
	11,
	213,
	189,
	11,
	213,
	189,
	12,
	213,
	189,
	13,
	213,
	189,
	14,
	213,
	189,
	15,
	213,
	189,
	16,
	213,
	189,
	17,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	19,
	213,
	189,
	20,
	213,
	189,
	21,
	213,
	189,
	21,
	213,
	189,
	22,
	213,
	189,
	23,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	25,
	213,
	189,
	26,
	213,
	189,
	26,
	213,
	189,
	27,
	213,
	189,
	28,
	213,
	189,
	29,
	213,
	189,
	30,
	213,
	189,
	31,
	213,
	189,
	31,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	10,
	213,
	189,
	11,
	213,
	189,
	11,
	213,
	189,
	12,
	213,
	189,
	13,
	213,
	189,
	14,
	213,
	189,
	15,
	213,
	189,
	16,
	213,
	189,
	17,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	19,
	213,
	189,
	20,
	213,
	189,
	21,
	213,
	189,
	21,
	213,
	189,
	22,
	213,
	189,
	23,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	25,
	213,
	189,
	26,
	213,
	189,
	26,
	213,
	189,
	27,
	213,
	189,
	28,
	213,
	189,
	29,
	213,
	189,
	30,
	213,
	189,
	31,
	213,
	189,
	31,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	10,
	213,
	189,
	11,
	213,
	189,
	11,
	213,
	189,
	12,
	213,
	189,
	13,
	213,
	189,
	14,
	213,
	189,
	15,
	213,
	189,
	16,
	213,
	189,
	17,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	18,
	213,
	189,
	19,
	213,
	189,
	20,
	213,
	189,
	21,
	213,
	189,
	21,
	213,
	189,
	22,
	213,
	189,
	23,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	24,
	213,
	189,
	25,
	213,
	189,
	26,
	213,
	189,
	26,
	213,
	189,
	27,
	213,
	189,
	28,
	213,
	189,
	29,
	213,
	189,
	30,
	213,
	189,
	31,
	213,
	189,
	31,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	32,
	213,
	189,
	0,
	213,
	189,
	1,
	213,
	189,
	2,
	213,
	189,
	2,
	213,
	189,
	3,
	213,
	189,
	4,
	213,
	189,
	4,
	213,
	189,
	5,
	213,
	189,
	6,
	213,
	189,
	7,
	213,
	189,
	8,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	213,
	189,
	9,
	0
};

uint16 sc74_palette[] = {
	0,
	256,
	514,
	516,
	515,
	516,
	1026,
	1028,
	772,
	1029,
	1797,
	771,
	1539,
	772,
	1542,
	1288,
	2565,
	1028,
	1798,
	1285,
	2055,
	1800,
	1799,
	2312,
	2566,
	2057,
	2825,
	2059,
	2312,
	2058,
	3080,
	2826,
	2570,
	2573,
	2568,
	2572,
	3081,
	3341,
	2572,
	3594,
	3082,
	3086,
	3594,
	3343,
	3853,
	3089,
	4621,
	2828,
	4109,
	2830,
	4368,
	3855,
	3596,
	4367,
	3602,
	3085,
	4882,
	4623,
	4364,
	4369,
	4367,
	5651,
	3600,
	4117,
	4881,
	4114,
	4120,
	4112,
	5395,
	4881,
	4115,
	4118,
	5395,
	4623,
	5652,
	5648,
	4627,
	4120,
	4887,
	6419,
	4371,
	5651,
	4120,
	6680,
	5654,
	7446,
	4371,
	6676,
	5393,
	6168,
	6163,
	5658,
	4377,
	5403,
	5138,
	5146,
	5912,
	7445,
	5141,
	5658,
	5655,
	6937,
	6171,
	7961,
	5143,
	6935,
	5657,
	5150,
	6934,
	6429,
	5150,
	7449,
	6936,
	6427,
	7448,
	8475,
	5401,
	7448,
	6943,
	5662,
	8217,
	7958,
	7194,
	6435,
	6937,
	6942,
	7198,
	5918,
	8479,
	7710,
	6940,
	5666,
	8217,
	9507,
	6683,
	7711,
	6944,
	7970,
	9245,
	7959,
	7712,
	8731,
	7714,
	6692,
	8989,
	8477,
	8735,
	9759,
	7448,
	9251,
	8738,
	7969,
	8230,
	9250,
	9251,
	8484,
	10274,
	8474,
	8743,
	9508,
	9253,
	7209,
	10016,
	10023,
	8485,
	10021,
	9251,
	9769,
	10790,
	9759,
	9767,
	10024,
	10276,
	9769,
	10788,
	10538,
	10538,
	11302,
	10538,
	10028,
	11560,
	11308,
	10284,
	11562,
	11562,
	11053,
	12076,
	10537,
	11823,
	12588,
	12079,
	12081,
	14137,
	2867,
	0,
	21,
	7936,
	0,
	42,
	13312,
	0,
	63,
	0,
	2108,
	16191,
	15893,
	15934,
	15934,
	15934,
	15934,
	15934,
	15934,
	15678,
	15934,
	15933,
	15678,
	15934,
	15933,
	15678,
	15934,
	15933,
	15678,
	15934,
	15933,
	15421,
	15678,
	15932,
	15421,
	15678,
	15676,
	15421,
	15677,
	15676,
	15421,
	15677,
	15676,
	15165,
	15677,
	15675,
	15165,
	15421,
	15675,
	15164,
	15421,
	15675,
	15164,
	15421,
	15675,
	14908,
	15421,
	15674,
	14908,
	15421,
	15418,
	14908,
	15420,
	15418,
	14908,
	15164,
	15418,
	14651,
	15164,
	15417,
	14651,
	15164,
	15417,
	14651,
	15164,
	15417,
	14651,
	15164,
	15417,
	14651,
	15164,
	15417,
	14395,
	15164,
	15160,
	14394,
	14907,
	15160,
	14394,
	14907,
	15160,
	14394,
	14907,
	15160,
	14138,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	14655,
	13111,
	14137,
	14643,
	13111,
	14137,
	13875,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 sc74_fast_list[] = {
	12+DISK_7,
	51+DISK_7,
	52+DISK_7,
	53+DISK_7,
	54+DISK_7,
	268+DISK_7,
	0
};

uint16 sc74_usecard2[] = {
	71*64,
	200,
	232,
	0,
	200,
	232,
	1,
	200,
	232,
	2,
	200,
	232,
	3,
	200,
	232,
	3,
	200,
	232,
	3,
	200,
	232,
	3,
	200,
	232,
	4,
	200,
	232,
	0,
	0
};

uint16 sc74_rpocket[] = {
	62*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 reset_linc_74[] = {
	C_SCREEN,
	74,
	C_PLACE,
	ID_SC74_INTERFACE,
	C_XCOOD,
	0X156,
	C_YCOOD,
	0XF1,
	C_FRAME,
	8+92*64,
	C_STATUS,
	ST_SORT+ST_RECREATE+ST_LOGIC+ST_AR_PRIORITY+ST_COLLISION,
	65535
};

Compact sc74_right_tv = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	298,	// xcood
	212,	// ycood
	60*64,	// frame
	57,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65532,	// mouseRel_x
	(int16) 65533,	// mouseRel_y
	319-294,	// mouseSize_x
	229-209,	// mouseSize_y
	SC74_MONITORS_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_RIGHT_TV_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_logic_list[] = {
	ID_FOSTER,
	ID_MEDI,
	ID_GALLAGHER,
	ID_KEN,
	ID_SC74_MONITOR1,
	ID_SC74_MONITOR2,
	ID_SC74_MONITOR3,
	ID_SC74_MONITOR4,
	ID_SC74_LEFT_TV,
	ID_SC74_LIGHTS,
	ID_SC74_INT_SLOT,
	ID_SC74_POD,
	ID_SC75_TONGS,
	0XFFFF,
	ID_STD_MENU_LOGIC
};

uint16 sc74_mon2_anim[] = {
	56*64,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	23,
	235,
	186,
	23,
	235,
	186,
	23,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	23,
	235,
	186,
	23,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	22,
	235,
	186,
	21,
	235,
	186,
	21,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	20,
	235,
	186,
	19,
	235,
	186,
	19,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	18,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	17,
	235,
	186,
	16,
	235,
	186,
	16,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	15,
	235,
	186,
	14,
	235,
	186,
	14,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	13,
	235,
	186,
	12,
	235,
	186,
	12,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	11,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	10,
	235,
	186,
	9,
	235,
	186,
	9,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	8,
	235,
	186,
	7,
	235,
	186,
	7,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	6,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	5,
	235,
	186,
	4,
	235,
	186,
	4,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	3,
	235,
	186,
	2,
	235,
	186,
	2,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	1,
	235,
	186,
	0,
	235,
	186,
	0,
	235,
	186,
	23,
	235,
	186,
	23,
	235,
	186,
	23,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	29,
	235,
	186,
	28,
	235,
	186,
	28,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	27,
	235,
	186,
	26,
	235,
	186,
	26,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	25,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	24,
	235,
	186,
	23,
	235,
	186,
	23,
	0
};

Compact sc74_lights = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND,	// status
	0,	// sync
	74,	// screen
	0,	// place
	0,	// getToTable
	243,	// xcood
	253,	// ycood
	61*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC74_LIGHTS_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc74_slot_flash[] = {
	94*64,
	377,
	266,
	0,
	377,
	266,
	0,
	377,
	266,
	0,
	377,
	266,
	1,
	377,
	266,
	1,
	377,
	266,
	1,
	0
};

} // namespace SkyCompact

} // namespace Sky

#endif
