/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compacts/0compact.h,v 1.11 2004/01/06 12:45:32 fingolfin Exp $ 
 *
 */

#ifndef SKY0COMPACT_H
#define SKY0COMPACT_H


#include "2compact.h"
#include "4compact.h"
#include "3compact.h"
#include "1compact.h"


namespace Sky {

namespace SkyCompact {

uint16 slide2_seq[] = {
	170*64,
	293,
	141,
	0,
	284,
	141,
	1,
	280,
	141,
	2,
	282,
	142,
	3,
	279,
	162,
	4,
	285,
	173,
	5,
	279,
	180,
	6,
	279,
	180,
	6,
	281,
	173,
	7,
	281,
	168,
	8,
	290,
	173,
	9,
	291,
	170,
	10,
	297,
	169,
	11,
	308,
	172,
	12,
	308,
	180,
	13,
	308,
	195,
	14,
	308,
	215,
	15,
	308,
	235,
	14,
	308,
	250,
	16,
	308,
	257,
	17,
	308,
	257,
	17,
	309,
	251,
	18,
	309,
	245,
	19,
	322,
	242,
	20,
	330,
	241,
	21,
	0,
	0
};

uint16 m_ss_st_up[] = {
	75*64,
	1,
	1,
	36,
	0
};

uint16 crouch_seq[] = {
	76*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 fost_open_cup[] = {
	141*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	142*64+0,
	SEND_SYNC,
	ID_CUPBOARD,
	2,
	1,
	1,
	142*64+1,
	1,
	1,
	142*64+2,
	1,
	1,
	142*64+2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

Compact fan3 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	169*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN3_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 ss_smokes_1[] = {
	106*64,
	293,
	223,
	0,
	293,
	223,
	0,
	293,
	223,
	1,
	293,
	223,
	1,
	293,
	223,
	2,
	293,
	223,
	2,
	293,
	223,
	3,
	293,
	223,
	3,
	293,
	223,
	3,
	293,
	223,
	3,
	293,
	223,
	4,
	293,
	223,
	4,
	293,
	223,
	5,
	293,
	223,
	5,
	293,
	223,
	6,
	293,
	223,
	6,
	293,
	223,
	7,
	293,
	223,
	7,
	293,
	223,
	8,
	293,
	223,
	8,
	293,
	223,
	9,
	293,
	223,
	9,
	293,
	223,
	10,
	293,
	223,
	10,
	293,
	223,
	11,
	293,
	223,
	11,
	293,
	223,
	12,
	293,
	223,
	12,
	293,
	223,
	13,
	293,
	223,
	13,
	293,
	223,
	14,
	293,
	223,
	14,
	293,
	223,
	13,
	293,
	223,
	13,
	293,
	223,
	14,
	293,
	223,
	14,
	293,
	223,
	13,
	293,
	223,
	13,
	293,
	223,
	7,
	293,
	223,
	7,
	293,
	223,
	8,
	293,
	223,
	8,
	293,
	223,
	7,
	293,
	223,
	7,
	293,
	223,
	6,
	293,
	223,
	6,
	0,
	0
};

Compact fan7 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	17*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN7_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 slide_seq[] = {
	167*64,
	309,
	217,
	0,
	302,
	218,
	1,
	302,
	220,
	2,
	302,
	220,
	3,
	286,
	226,
	4,
	283,
	221,
	5,
	273,
	222,
	6,
	273,
	225,
	7,
	276,
	231,
	8,
	276,
	244,
	9,
	277,
	259,
	10,
	0,
	0
};

uint16 f_ss_st_right[] = {
	99*64,
	1,
	1,
	38,
	0
};

uint32 *c74 = (uint32*)(&mini_so);

uint16 f_ss_left[] = {
	4,
	16+99*64,
	65532,
	0,
	4,
	17+99*64,
	65532,
	0,
	4,
	18+99*64,
	65532,
	0,
	4,
	19+99*64,
	65532,
	0,
	4,
	20+99*64,
	65532,
	0,
	4,
	21+99*64,
	65532,
	0,
	4,
	22+99*64,
	65532,
	0,
	4,
	23+99*64,
	65532,
	0,
	0
};

uint16 m_ss_down[] = {
	1,
	8+75*64,
	0,
	1,
	1,
	9+75*64,
	0,
	1,
	1,
	10+75*64,
	0,
	1,
	1,
	11+75*64,
	0,
	1,
	1,
	12+75*64,
	0,
	1,
	1,
	13+75*64,
	0,
	1,
	1,
	14+75*64,
	0,
	1,
	1,
	15+75*64,
	0,
	1,
	0
};

uint16 s2_pal[] = {
	0,
	1024,
	1028,
	1030,
	2054,
	1028,
	1542,
	2056,
	2054,
	1546,
	1544,
	2568,
	2056,
	2570,
	3082,
	2572,
	3596,
	2570,
	3082,
	2574,
	4108,
	3596,
	4112,
	3596,
	3092,
	4106,
	3598,
	4108,
	3602,
	4624,
	4116,
	4114,
	5138,
	3612,
	5646,
	3602,
	4626,
	4630,
	5652,
	5140,
	4630,
	7190,
	4638,
	6160,
	5652,
	5658,
	5646,
	6166,
	6678,
	7184,
	6166,
	5662,
	6168,
	7192,
	6680,
	7194,
	5146,
	6680,
	7196,
	6680,
	7194,
	6684,
	7708,
	6959,
	11030,
	4630,
	5939,
	10004,
	5144,
	6693,
	7704,
	6174,
	5939,
	7188,
	7710,
	8483,
	7184,
	8990,
	7205,
	13594,
	5657,
	8478,
	8993,
	8478,
	6963,
	9496,
	5667,
	7725,
	8466,
	10017,
	8993,
	11043,
	6686,
	6199,
	10004,
	4645,
	8995,
	12581,
	5662,
	7221,
	10518,
	8481,
	9517,
	11536,
	7713,
	9005,
	8472,
	11045,
	8999,
	9511,
	10021,
	7733,
	11034,
	4649,
	10033,
	11538,
	8997,
	10023,
	12585,
	5671,
	9011,
	12062,
	4139,
	9525,
	9496,
	11561,
	10541,
	10012,
	10537,
	11570,
	11541,
	10023,
	10539,
	10533,
	11051,
	11573,
	10000,
	12587,
	11051,
	12587,
	9513,
	12085,
	13591,
	7217,
	11563,
	14125,
	9001,
	11059,
	11049,
	12079,
	11567,
	14125,
	4657,
	12077,
	11055,
	13103,
	12083,
	14637,
	5171,
	13113,
	12054,
	12593,
	12589,
	13111,
	12081,
	13105,
	12595,
	13619,
	13617,
	13619,
	13107,
	13881,
	13586,
	13621,
	14131,
	15161,
	5176,
	14133,
	14135,
	13623,
	14135,
	13111,
	14649,
	14643,
	14653,
	14649,
	15161,
	15163,
	14651,
	15677,
	16187,
	16191,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	9216,
	0,
	42,
	12544,
	0,
	56,
	16128,
	0,
	5183,
	16128,
	28,
	8767,
	16128,
	38,
	11327,
	16128,
	16191,
	16191,
	16191,
	16191,
	16191,
	16191,
	16191,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	13824,
	15159,
	11308,
	9010,
	8995,
	9766,
	7979,
	9503,
	6425,
	5407,
	6419,
	3346,
	3603,
	3337,
	16191,
	15104,
	2570,
	16191,
	14143,
	14649,
	13105,
	11827,
	12335,
	11307,
	10285,
	10793,
	9765,
	8487,
	9249,
	7455,
	7713,
	7705,
	5660,
	5912,
	4881,
	3602,
	3598,
	2570,
	1030,
	4,
	0,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9520,
	10288,
	11292,
	5153,
	6696,
	9230,
	2066,
	3104,
	11267,
	2056,
	8721,
	7696,
	6957,
	10262,
	3863,
	3612,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	11051,
	8753,
	10530,
	6939,
	5410,
	6419,
	3347,
	3092,
	2823,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	16191,
	63,
	16191,
	16128,
	63,
	16191,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 foster_hanging[] = {
	102*64,
	207,
	185,
	0,
	202,
	186,
	1,
	196,
	187,
	2,
	192,
	187,
	3,
	189,
	187,
	4,
	186,
	187,
	5,
	183,
	187,
	6,
	185,
	192,
	7,
	189,
	203,
	8,
	191,
	212,
	9,
	191,
	206,
	10,
	203,
	203,
	11,
	209,
	202,
	12,
	211,
	202,
	13,
	0,
	0
};

Compact fan4 = {
	L_SCRIPT,	// logic
	ST_FOREGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	171*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN4_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 rs_ss_to_1[] = {
	C_XCOOD,
	176,
	C_YCOOD,
	240,
	C_SCREEN,
	1,
	C_PLACE,
	95,
	65535
};

uint16 rs_foster_to_one[] = {
	C_XCOOD,
	240-48-16,
	C_YCOOD,
	240,
	C_SCREEN,
	1,
	C_PLACE,
	95,
	65535
};

uint16 m_ss_r_to_d[] = {
	47-8+75*64,
	0
};

uint16 f_ss_l_to_u[] = {
	43-8+99*64,
	0
};

Compact load_point = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC+ST_RECREATE+ST_MOUSE,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0XB0,	// xcood
	0X119,	// ycood
	162*64,	// frame
	84+T7,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	7,	// mouseRel_y
	6,	// mouseSize_x
	5,	// mouseSize_y
	LOAD_POINT_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	LOAD_POINT_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 rs_foster_5_0[] = {
	C_XCOOD,
	152,
	C_YCOOD,
	280,
	C_SCREEN,
	0,
	C_PLACE,
	ID_LOW_FLOOR,
	C_DIR,
	RIGHT,
	C_FRAME,
	42+13*64,
	C_MEGA_SET,
	0,
	65535
};

uint16 fost_pull_knob[] = {
	153*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	SEND_SYNC,
	ID_KNOB,
	1,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 m_ss_r_to_u[] = {
	45-8+75*64,
	0
};

uint16 rs_foster_to_1[] = {
	C_XCOOD,
	240,
	C_YCOOD,
	240,
	C_SCREEN,
	1,
	C_PLACE,
	95,
	65535
};

uint32 *rs_jobs_4_2 = (uint32*)rs_foster_4_2;

uint16 monitor_seq[] = {
	151*64,
	222,
	200,
	0,
	222,
	200,
	1,
	222,
	200,
	2,
	222,
	200,
	3,
	0,
	0
};

uint16 joey_door_seq[] = {
	216*64,
	175,
	172,
	0,
	175,
	172,
	0,
	175,
	172,
	1,
	175,
	172,
	1,
	175,
	172,
	2,
	175,
	172,
	2,
	175,
	172,
	3,
	175,
	172,
	3,
	175,
	172,
	4,
	175,
	172,
	4,
	175,
	172,
	5,
	175,
	172,
	5,
	175,
	172,
	6,
	175,
	172,
	6,
	175,
	172,
	7,
	175,
	172,
	7,
	175,
	172,
	8,
	175,
	172,
	8,
	175,
	172,
	9,
	175,
	172,
	10,
	175,
	172,
	11,
	175,
	172,
	12,
	175,
	172,
	13,
	175,
	172,
	14,
	175,
	172,
	15,
	175,
	172,
	16,
	175,
	172,
	17,
	175,
	172,
	9,
	175,
	172,
	10,
	175,
	172,
	11,
	175,
	172,
	12,
	175,
	172,
	13,
	175,
	172,
	14,
	175,
	172,
	15,
	175,
	172,
	16,
	175,
	172,
	17,
	175,
	172,
	9,
	175,
	172,
	10,
	175,
	172,
	11,
	175,
	172,
	12,
	175,
	172,
	13,
	175,
	172,
	14,
	175,
	172,
	15,
	175,
	172,
	16,
	175,
	172,
	17,
	175,
	172,
	8,
	175,
	172,
	8,
	175,
	172,
	7,
	175,
	172,
	7,
	175,
	172,
	6,
	175,
	172,
	6,
	175,
	172,
	5,
	175,
	172,
	5,
	175,
	172,
	4,
	175,
	172,
	4,
	175,
	172,
	3,
	175,
	172,
	3,
	175,
	172,
	2,
	175,
	172,
	2,
	175,
	172,
	1,
	175,
	172,
	1,
	175,
	172,
	0,
	0,
	0
};

uint16 small_opens[] = {
	104*64,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 fost_knob_locked[] = {
	153*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 s4_pal[] = {
	0,
	768,
	771,
	771,
	773,
	773,
	1285,
	1285,
	1797,
	1287,
	2823,
	1285,
	1799,
	1799,
	2311,
	1803,
	1795,
	2313,
	2313,
	2313,
	2825,
	1809,
	3843,
	1289,
	1811,
	2307,
	3339,
	1813,
	2819,
	2827,
	2827,
	3341,
	2315,
	2835,
	3333,
	3853,
	3341,
	2833,
	3855,
	3343,
	4877,
	3339,
	3853,
	3343,
	4367,
	3855,
	3857,
	4881,
	4369,
	4881,
	3857,
	4881,
	4371,
	5395,
	4883,
	4885,
	5397,
	4888,
	5395,
	6165,
	6165,
	6170,
	6168,
	6168,
	6682,
	6680,
	6680,
	7194,
	6168,
	6682,
	6170,
	7196,
	7194,
	7198,
	7196,
	7198,
	8220,
	6684,
	6688,
	7200,
	7710,
	8220,
	9760,
	6172,
	7712,
	8222,
	8222,
	8222,
	7712,
	8736,
	8224,
	9248,
	7712,
	8230,
	8734,
	8738,
	8738,
	9764,
	8226,
	8740,
	8740,
	9252,
	9252,
	9252,
	9764,
	9256,
	10786,
	8740,
	9766,
	8230,
	11304,
	9770,
	8738,
	9770,
	9768,
	10792,
	9766,
	10278,
	10280,
	9768,
	10280,
	11306,
	9768,
	10284,
	10794,
	10794,
	10796,
	11816,
	9770,
	11306,
	10796,
	11820,
	11306,
	11312,
	11820,
	11312,
	10794,
	13358,
	11824,
	11306,
	11824,
	11820,
	12340,
	11310,
	11824,
	11824,
	12336,
	12334,
	13362,
	11312,
	12336,
	13366,
	12336,
	12850,
	13360,
	11826,
	12848,
	12854,
	14642,
	12854,
	12848,
	12852,
	12852,
	13878,
	13362,
	13362,
	13371,
	12854,
	13369,
	13876,
	13366,
	13881,
	13362,
	15158,
	14644,
	15161,
	12854,
	14646,
	13878,
	15161,
	14651,
	15670,
	13881,
	15163,
	14646,
	15675,
	15165,
	15673,
	14653,
	15677,
	16187,
	16191,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	5918,
	9728,
	31,
	10542,
	13824,
	51,
	16191,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	13111,
	12849,
	11822,
	11054,
	10796,
	10536,
	9510,
	8230,
	8737,
	7197,
	6173,
	6424,
	5140,
	4117,
	4368,
	3341,
	2317,
	2313,
	3072,
	0,
	19,
	6913,
	769,
	803,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13827,
	9520,
	10289,
	11549,
	5409,
	6441,
	9487,
	2322,
	2849,
	11781,
	2056,
	8975,
	7185,
	6701,
	10516,
	3862,
	3612,
	4864,
	12036,
	12333,
	10282,
	9515,
	9763,
	10282,
	9007,
	10529,
	6427,
	6180,
	7443,
	2831,
	2836,
	2820,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	16191,
	63,
	16191,
	16128,
	63,
	16191,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 alarm_seq[] = {
	164*64,
	284,
	208,
	0,
	284,
	208,
	1,
	284,
	208,
	2,
	284,
	208,
	3,
	284,
	208,
	4,
	284,
	208,
	5,
	284,
	208,
	6,
	284,
	208,
	7,
	284,
	208,
	8,
	284,
	208,
	9,
	0
};

uint16 reverse_seq[] = {
	156*64,
	246,
	256,
	13,
	244,
	256,
	12,
	242,
	256,
	11,
	240,
	256,
	10,
	0
};

Compact press = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC+ST_MOUSE,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	18*64,	// frame
	4146,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	25,	// mouseSize_x
	16,	// mouseSize_y
	PRESS_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	PRESS_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 furnace_seq[] = {
	211*64,
	226,
	239,
	0,
	226,
	239,
	1,
	226,
	239,
	2,
	226,
	239,
	3,
	226,
	239,
	4,
	226,
	239,
	5,
	226,
	239,
	6,
	226,
	239,
	7,
	226,
	239,
	8,
	226,
	239,
	9,
	226,
	239,
	10,
	0
};

uint16 load_point_seq[] = {
	162*64,
	176,
	281,
	0,
	176,
	281,
	1,
	176,
	281,
	2,
	176,
	281,
	3,
	176,
	281,
	4,
	176,
	281,
	5,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	6,
	176,
	281,
	7,
	176,
	281,
	8,
	176,
	281,
	9,
	176,
	281,
	10,
	176,
	281,
	11,
	176,
	281,
	12,
	176,
	281,
	13,
	176,
	281,
	14,
	176,
	281,
	15,
	176,
	281,
	16,
	176,
	281,
	17,
	176,
	281,
	18,
	176,
	281,
	19,
	176,
	281,
	20,
	176,
	281,
	21,
	176,
	281,
	22,
	176,
	281,
	23,
	176,
	281,
	24,
	176,
	281,
	25,
	176,
	281,
	26,
	176,
	281,
	27,
	176,
	281,
	28,
	176,
	281,
	29,
	176,
	281,
	30,
	176,
	281,
	31,
	176,
	281,
	32,
	0,
	1,
	1,
	0,
	0
};

uint16 m_ss_right[] = {
	2,
	24+75*64,
	2,
	0,
	2,
	25+75*64,
	2,
	0,
	2,
	26+75*64,
	2,
	0,
	2,
	27+75*64,
	2,
	0,
	2,
	28+75*64,
	2,
	0,
	2,
	29+75*64,
	2,
	0,
	2,
	30+75*64,
	2,
	0,
	2,
	31+75*64,
	2,
	0,
	0
};

uint16 use_bar2[] = {
	91*64,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	0,
	1,
	1,
	0,
	0
};

uint16 fost_cant_open[] = {
	141*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	142*64+0,
	SEND_SYNC,
	ID_CUPBOARD,
	2,
	1,
	1,
	142*64+1,
	0
};

uint16 f_ss_l_to_r[] = {
	41-8+99*64,
	40-8+99*64,
	47-8+99*64,
	0
};

uint16 f_ss_u_to_d[] = {
	43-8+99*64,
	42-8+99*64,
	41-8+99*64,
	0
};

uint16 push_small[] = {
	23*64,
	165,
	260,
	0,
	165,
	260,
	1,
	165,
	260,
	2,
	165,
	260,
	3,
	165,
	260,
	4,
	165,
	260,
	5,
	165,
	260,
	5,
	165,
	260,
	5,
	165,
	260,
	6,
	165,
	260,
	0,
	0
};

uint16 ss_auto[32];

uint16 m_ss_l_to_d[] = {
	41-8+75*64,
	0
};

uint16 s0_pal[] = {
	0,
	1024,
	1028,
	1028,
	1542,
	1542,
	1544,
	2056,
	2056,
	2056,
	2570,
	2568,
	2570,
	3084,
	3082,
	3082,
	3598,
	3084,
	3088,
	3598,
	3598,
	3598,
	4112,
	3598,
	4112,
	5138,
	4112,
	4624,
	4628,
	4626,
	4628,
	4624,
	5652,
	4630,
	4628,
	6164,
	5140,
	5654,
	5140,
	5144,
	5652,
	6166,
	5654,
	7196,
	5652,
	6166,
	5656,
	6680,
	5660,
	6166,
	6168,
	6168,
	6170,
	7192,
	6680,
	6686,
	7194,
	6686,
	7706,
	7194,
	7194,
	7198,
	7708,
	6689,
	7196,
	8476,
	7706,
	7715,
	8478,
	7710,
	8995,
	7710,
	6697,
	8478,
	8993,
	8481,
	7717,
	10019,
	8483,
	8485,
	9507,
	8997,
	11041,
	8993,
	9507,
	9513,
	10021,
	10017,
	9515,
	10023,
	10019,
	10543,
	10533,
	9007,
	9509,
	12071,
	10025,
	9513,
	11049,
	10535,
	12075,
	10021,
	10029,
	10535,
	11049,
	10535,
	10033,
	13097,
	9523,
	12071,
	9003,
	10543,
	11051,
	11563,
	10035,
	13609,
	10023,
	11049,
	10545,
	13099,
	11051,
	11055,
	11565,
	11561,
	12597,
	12075,
	10551,
	13097,
	9517,
	12077,
	11057,
	13615,
	11569,
	12591,
	11567,
	11573,
	11051,
	14639,
	12591,
	12075,
	13105,
	12089,
	11559,
	14641,
	12591,
	14135,
	8499,
	12085,
	13105,
	12593,
	12593,
	14135,
	10547,
	13103,
	12605,
	14643,
	13105,
	14651,
	11059,
	13619,
	14133,
	13107,
	14137,
	13607,
	13621,
	14139,
	13093,
	15157,
	14647,
	12587,
	16183,
	14133,
	15675,
	11575,
	14135,
	15673,
	10553,
	15167,
	13603,
	15673,
	14649,
	15159,
	14137,
	15679,
	14635,
	15675,
	15163,
	15675,
	14653,
	15677,
	16189,
	16191,
	0,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	5120,
	2048,
	2056,
	3598,
	4110,
	4624,
	4630,
	4628,
	6164,
	6680,
	4638,
	4118,
	6678,
	6675,
	5662,
	8732,
	7705,
	7205,
	10274,
	9504,
	9259,
	11304,
	9010,
	11559,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	16191,
	63,
	16191,
	16128,
	63,
	16191,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint32 *grid3 = 0;

uint16 foster_shot[] = {
	103*64,
	213,
	240,
	0,
	218,
	240,
	1,
	221,
	240,
	2,
	221,
	240,
	3,
	223,
	246,
	4,
	225,
	246,
	5,
	231,
	240,
	6,
	234,
	240,
	7,
	222,
	240,
	8,
	219,
	240,
	9,
	212,
	246,
	10,
	210,
	248,
	11,
	205,
	254,
	12,
	204,
	265,
	13,
	205,
	270,
	14,
	202,
	284,
	15,
	201,
	290,
	16,
	195,
	295,
	17,
	194,
	297,
	18,
	191,
	307,
	19,
	190,
	306,
	20,
	188,
	310,
	21,
	184,
	316,
	22,
	183,
	318,
	23,
	0,
	0
};

uint16 lazer_stop_seq[] = {
	60*64,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 rs_start_alarm[] = {
	C_STATUS,
	ST_FOREGROUND+ST_LOGIC,
	65535
};

Compact fan1 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	45*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN1_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 f_ss_d_to_u[] = {
	47-8+99*64,
	46-8+99*64,
	45-8+99*64,
	0
};

uint32 *grid4 = 0;

uint16 ss_smokes_3[] = {
	108*64,
	282,
	220,
	0,
	282,
	220,
	1,
	282,
	220,
	2,
	282,
	220,
	2,
	282,
	220,
	3,
	282,
	220,
	3,
	282,
	220,
	4,
	282,
	220,
	4,
	282,
	220,
	5,
	282,
	220,
	5,
	282,
	220,
	0,
	0,
	0
};

uint16 lights1_seq[] = {
	212*64,
	248,
	194,
	0,
	248,
	194,
	0,
	248,
	194,
	1,
	248,
	194,
	1,
	248,
	194,
	2,
	248,
	194,
	2,
	248,
	194,
	3,
	248,
	194,
	3,
	248,
	194,
	4,
	248,
	194,
	4,
	248,
	194,
	5,
	248,
	194,
	5,
	248,
	194,
	6,
	248,
	194,
	6,
	248,
	194,
	7,
	248,
	194,
	7,
	248,
	194,
	8,
	248,
	194,
	8,
	0
};

uint16 eye_open[] = {
	213*64,
	1,
	1,
	1,
	1,
	1,
	2,
	0
};

uint16 press_seq[] = {
	18*64,
	269,
	246,
	0,
	65534,
	257,
	127,
	269,
	246,
	1,
	269,
	246,
	2,
	269,
	246,
	3,
	269,
	246,
	4,
	269,
	246,
	5,
	269,
	246,
	6,
	269,
	246,
	7,
	269,
	246,
	8,
	269,
	246,
	8,
	269,
	246,
	9,
	269,
	246,
	10,
	269,
	246,
	10,
	269,
	246,
	9,
	269,
	246,
	8,
	269,
	246,
	11,
	65534,
	256,
	127,
	269,
	246,
	0,
	269,
	246,
	0,
	269,
	246,
	0,
	269,
	246,
	0,
	0
};

uint16 cup_close_seq[] = {
	57*64,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 low_lift_down_seq1[] = {
	204*64,
	298,
	141,
	11,
	298,
	141,
	10,
	294,
	141,
	9,
	289,
	141,
	8,
	285,
	141,
	7,
	280,
	141,
	6,
	275,
	141,
	5,
	250,
	141,
	4,
	250,
	141,
	3,
	250,
	141,
	2,
	250,
	141,
	1,
	250,
	141,
	0,
	0
};

uint16 barrel_in_seq[] = {
	207*64,
	267,
	257,
	0,
	264,
	257,
	1,
	261,
	257,
	1,
	258,
	257,
	1,
	255,
	257,
	1,
	252,
	257,
	1,
	249,
	257,
	1,
	246,
	257,
	1,
	243,
	257,
	1,
	240,
	257,
	1,
	237,
	257,
	1,
	234,
	257,
	1,
	231,
	257,
	1,
	228,
	257,
	1,
	227,
	257,
	2,
	227,
	257,
	3,
	227,
	257,
	4,
	227,
	257,
	5,
	227,
	258,
	6,
	0
};

uint16 rs_big_foster[] = {
	C_XCOOD,
	184,
	C_YCOOD,
	208,
	C_FRAME,
	12*64+40,
	C_DIR,
	1,
	C_PLACE,
	17,
	C_GET_TO_FLAG,
	0,
	65535
};

uint16 screen0_low_logic[] = {
	ID_FOSTER,
	JOBS,
	ID_CUPBOARD,
	ID_KNOB,
	ID_LAZER,
	ID_CHUCK,
	MINI_SS,
	ID_LOADER,
	ID_TOP_LIFT,
	4344,
	ID_TOP_BARREL,
	90,
	105,
	85,
	ID_FAN1,
	ID_FAN2,
	ID_FAN3,
	ID_FAN4,
	ID_FAN5,
	ID_FAN6,
	ID_FAN7,
	ID_PRESS,
	ID_UPLOAD,
	ID_LIGHT1,
	ID_PANEL,
	0XFFFF,
	ID_MENU_LOGIC
};

uint16 rs_foster_2_0[] = {
	C_XCOOD,
	408,
	C_YCOOD,
	272,
	C_SCREEN,
	0,
	C_PLACE,
	ID_LOW_FLOOR,
	C_DIR,
	2,
	C_FRAME,
	42+13*64,
	65535
};

uint16 foster_g_d[] = {
	141*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	6,
	0
};

uint16 fost_but_seq[] = {
	152*64,
	365,
	146,
	0,
	365,
	146,
	1,
	365,
	146,
	2,
	365,
	146,
	3,
	365,
	146,
	4,
	365,
	146,
	3,
	365,
	146,
	5,
	365,
	146,
	3,
	365,
	146,
	5,
	365,
	146,
	3,
	365,
	146,
	4,
	365,
	146,
	6,
	365,
	146,
	1,
	365,
	146,
	7,
	365,
	146,
	7,
	365,
	146,
	7,
	0,
	0
};

uint16 jobs_look_scrn[] = {
	146*64,
	220,
	191,
	0,
	220,
	191,
	0,
	220,
	191,
	0,
	220,
	191,
	1,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	1,
	220,
	191,
	0,
	220,
	191,
	0,
	220,
	191,
	0,
	220,
	191,
	0,
	220,
	191,
	1,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	3,
	220,
	191,
	4,
	220,
	191,
	3,
	220,
	191,
	4,
	220,
	191,
	3,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	2,
	220,
	191,
	2,
	0,
	0
};

uint16 jobs_chuck_look[] = {
	144*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	0,
	0
};

uint16 eye_blink[] = {
	213*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	0
};

uint16 fan1_seq[] = {
	45*64,
	283,
	137,
	0,
	283,
	137,
	1,
	283,
	137,
	2,
	0
};

uint16 m_ss_st_right[] = {
	75*64,
	1,
	1,
	38,
	0
};

uint16 screen0_low_mouse[] = {
	69,
	JOBS,
	MINI_SS,
	105,
	111,
	ID_PRESS,
	17,
	ID_LOADER,
	ID_UPLOAD,
	ID_LOW_FLOOR,
	18,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 fan7_seq[] = {
	17*64,
	388,
	172,
	0,
	388,
	172,
	1,
	388,
	172,
	2,
	388,
	172,
	3,
	388,
	172,
	4,
	0
};

uint16 f_ss_r_to_d[] = {
	47-8+99*64,
	0
};

uint16 r1_opens[] = {
	96*64,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 f_ss_u_to_l[] = {
	43-8+99*64,
	0
};

uint16 rs_mini_ss[] = {
	C_FRAME,
	19+75*64,
	C_MODE,
	0,
	C_BASE_SUB,
	MORE_SS,
	C_BASE_SUB+2,
	0,
	C_LOGIC,
	L_SCRIPT,
	C_XCOOD,
	192,
	C_YCOOD,
	280,
	65535
};

uint16 s3_pal[] = {
	0,
	512,
	512,
	4,
	1024,
	512,
	6,
	2048,
	0,
	516,
	1540,
	514,
	518,
	2052,
	2,
	522,
	3586,
	0,
	14,
	2050,
	516,
	1034,
	2050,
	1540,
	1034,
	2564,
	1540,
	1036,
	4098,
	2,
	1038,
	5124,
	2,
	1042,
	3586,
	1542,
	1044,
	3586,
	520,
	1044,
	3076,
	2056,
	1552,
	3590,
	2056,
	1050,
	5632,
	518,
	2066,
	6150,
	1030,
	1052,
	5634,
	1032,
	2070,
	6150,
	520,
	1564,
	7684,
	1030,
	3090,
	8968,
	6,
	2586,
	9988,
	4,
	3094,
	9992,
	516,
	2078,
	8454,
	520,
	2083,
	6658,
	1548,
	2593,
	9986,
	518,
	3100,
	6150,
	2574,
	2595,
	8964,
	1546,
	3102,
	8968,
	1036,
	3614,
	11014,
	520,
	3614,
	10504,
	522,
	2599,
	11526,
	8,
	2603,
	11010,
	1034,
	2605,
	9986,
	1038,
	3623,
	8454,
	1554,
	4131,
	10504,
	1550,
	3115,
	11528,
	1036,
	3119,
	8450,
	2578,
	3117,
	12042,
	1548,
	4137,
	9992,
	2066,
	3631,
	12548,
	526,
	5665,
	10508,
	2578,
	3125,
	12036,
	1552,
	3635,
	14084,
	1036,
	4145,
	11524,
	1554,
	5163,
	11014,
	2580,
	4655,
	11528,
	1556,
	4657,
	12552,
	2578,
	4151,
	13574,
	1554,
	5677,
	10508,
	3608,
	4663,
	13062,
	2068,
	5171,
	13066,
	1558,
	6695,
	14610,
	2066,
	5683,
	12042,
	2074,
	5683,
	11534,
	3612,
	6199,
	12552,
	4122,
	6711,
	12042,
	3614,
	6711,
	11532,
	5153,
	7221,
	14612,
	2078,
	7735,
	12558,
	5153,
	7735,
	14608,
	3105,
	9013,
	13074,
	5671,
	9017,
	15126,
	5155,
	10551,
	14616,
	5675,
	3391,
	11520,
	8,
	1822,
	0,
	44,
	13627,
	9728,
	22,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	16191,
	14080,
	3111,
	8756,
	12810,
	2077,
	6447,
	11527,
	1300,
	4394,
	10244,
	781,
	2341,
	8962,
	262,
	1055,
	6912,
	3,
	279,
	4608,
	0,
	13,
	2048,
	0,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	12036,
	12079,
	11563,
	8751,
	9506,
	9767,
	8497,
	11803,
	4379,
	5671,
	7942,
	273,
	1813,
	1792,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2623,
	13578,
	1285,
	293,
	6913,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	63,
	0,
	0,
	0,
	0,
	0,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 ss_smokes_2[] = {
	107*64,
	285,
	222,
	0,
	285,
	222,
	0,
	285,
	222,
	1,
	285,
	222,
	1,
	285,
	222,
	2,
	285,
	222,
	2,
	285,
	222,
	3,
	285,
	222,
	3,
	285,
	222,
	0,
	285,
	222,
	0,
	285,
	222,
	4,
	285,
	222,
	4,
	285,
	222,
	5,
	285,
	222,
	6,
	285,
	222,
	7,
	285,
	222,
	7,
	285,
	222,
	8,
	285,
	222,
	8,
	285,
	222,
	9,
	285,
	222,
	9,
	285,
	222,
	10,
	285,
	222,
	10,
	285,
	222,
	11,
	285,
	222,
	11,
	285,
	222,
	12,
	285,
	222,
	12,
	285,
	222,
	13,
	285,
	222,
	13,
	285,
	222,
	14,
	285,
	222,
	14,
	285,
	222,
	15,
	285,
	222,
	15,
	285,
	222,
	16,
	285,
	222,
	16,
	0,
	0
};

uint16 m_ss_up[] = {
	1,
	0+75*64,
	0,
	65535,
	1,
	1+75*64,
	0,
	65535,
	1,
	2+75*64,
	0,
	65535,
	1,
	3+75*64,
	0,
	65535,
	1,
	4+75*64,
	0,
	65535,
	1,
	5+75*64,
	0,
	65535,
	1,
	6+75*64,
	0,
	65535,
	1,
	7+75*64,
	0,
	65535,
	0
};

uint16 m_ss_left[] = {
	2,
	16+75*64,
	65534,
	0,
	2,
	17+75*64,
	65534,
	0,
	2,
	18+75*64,
	65534,
	0,
	2,
	19+75*64,
	65534,
	0,
	2,
	20+75*64,
	65534,
	0,
	2,
	21+75*64,
	65534,
	0,
	2,
	22+75*64,
	65534,
	0,
	2,
	23+75*64,
	65534,
	0,
	0
};

uint16 m_ss_st_down[] = {
	75*64,
	1,
	1,
	32,
	0
};

uint16 m_ss_st_left[] = {
	75*64,
	1,
	1,
	34,
	0
};

uint16 m_ss_st_talk[] = {
	44*64,
	1,
	1,
	0,
	0
};

uint16 m_ss_u_to_d[] = {
	43-8+75*64,
	42-8+75*64,
	41-8+75*64,
	0
};

uint16 m_ss_u_to_l[] = {
	43-8+75*64,
	0
};

uint16 m_ss_u_to_r[] = {
	45-8+75*64,
	0
};

uint16 m_ss_d_to_u[] = {
	47-8+75*64,
	46-8+75*64,
	45-8+75*64,
	0
};

uint16 m_ss_d_to_l[] = {
	41-8+75*64,
	0
};

uint16 m_ss_d_to_r[] = {
	47-8+75*64,
	0
};

uint16 m_ss_l_to_u[] = {
	43-8+75*64,
	0
};

uint16 m_ss_l_to_r[] = {
	41-8+75*64,
	40-8+75*64,
	47-8+75*64,
	0
};

uint16 m_ss_r_to_l[] = {
	45-8+75*64,
	44-8+75*64,
	43-8+75*64,
	0
};

TurnTable mini_so_turnTable0 = {
	{ // turnTableUp
		0,
		m_ss_u_to_d,
		m_ss_u_to_l,
		m_ss_u_to_r,
		0
	},
	{ // turnTableDown
		m_ss_d_to_u,
		0,
		m_ss_d_to_l,
		m_ss_d_to_r,
		0
	},
	{ // turnTableLeft
		m_ss_l_to_u,
		m_ss_l_to_d,
		0,
		m_ss_l_to_r,
		0
	},
	{ // turnTableRight
		m_ss_r_to_u,
		m_ss_r_to_d,
		m_ss_r_to_l,
		0,
		0
	},
	{ // turnTableTalk
		0,
		0,
		0,
		0,
		0
	}
};

MegaSet mini_so_megaSet0 = {
	0,	// gridWidth
	0,	// colOffset
	8,	// colWidth
	8,	// lastChr
	m_ss_up,	// animUp
	m_ss_down,	// animDown
	m_ss_left,	// animLeft
	m_ss_right,	// animRight
	m_ss_st_up,	// standUp
	m_ss_st_down,	// standDown
	m_ss_st_left,	// standLeft
	m_ss_st_right,	// standRight
	m_ss_st_talk,	// standTalk
	&mini_so_turnTable0
};

ExtCompact mini_so_ext = {
	0,	// actionSub
	0,	// actionSub_off
	0,	// getToSub
	0,	// getToSub_off
	0,	// extraSub
	0,	// extraSub_off
	0,	// dir
	STD_MEGA_STOP,	// stopScript
	STD_MINI_BUMP,	// miniBump
	0,	// leaving
	0,	// atWatch
	0,	// atWas
	0,	// alt
	0,	// request
	96,	// spWidth_xx
	SP_COL_SO,	// spColour
	0,	// spTextId
	0,	// spTime
	0,	// arAnimIndex
	0,	// turnProg
	0,	// waitingFor
	0,	// arTarget_x
	0,	// arTarget_y
	ss_auto,	// animScratch
	0,	// megaSet
	&mini_so_megaSet0,
	0,
	0,
	0
};

Compact mini_so = {
	L_SCRIPT,	// logic
	ST_SORT+ST_RECREATE+ST_LOGIC+ST_GRID_PLOT+ST_MOUSE,	// status
	0,	// sync
	0,	// screen
	ID_LOW_FLOOR,	// place
	0,	// getToTable
	158,	// xcood
	280,	// ycood
	75*64,	// frame
	16,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65532,	// mouseRel_x
	(int16) 65516,	// mouseRel_y
	8,	// mouseSize_x
	28,	// mouseSize_y
	MEGA_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	0,	// mode
	START_MINI_SS,	// baseSub
	0,	// baseSub_off
	&mini_so_ext
};

uint16 unload_seq1[] = {
	160*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	12,
	0
};

uint16 open_r1[] = {
	98*64,
	196,
	202,
	0,
	191,
	202,
	1,
	187,
	202,
	2,
	187,
	202,
	3,
	188,
	201,
	4,
	194,
	202,
	5,
	197,
	202,
	6,
	196,
	202,
	7,
	0
};

uint16 get_bar_out[] = {
	88*64,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	0
};

uint16 fost_close_cup[] = {
	141*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	142*64+0,
	1,
	1,
	142*64+2,
	1,
	1,
	142*64+1,
	SEND_SYNC,
	ID_CUPBOARD,
	1,
	1,
	1,
	142*64+0,
	1,
	1,
	8,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 barrel_down_seq2[] = {
	206*64,
	270,
	205,
	0,
	270,
	210,
	1,
	270,
	215,
	2,
	270,
	220,
	3,
	270,
	224,
	4,
	270,
	229,
	5,
	270,
	234,
	6,
	270,
	238,
	7,
	270,
	243,
	7,
	270,
	248,
	7,
	270,
	252,
	7,
	270,
	257,
	8,
	0
};

uint16 ss_kick[] = {
	100*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	0
};

uint32 *grid1 = 0;

uint16 full_ss_auto[32];

uint16 f_ss_up[] = {
	2,
	0+99*64,
	0,
	65534,
	2,
	1+99*64,
	0,
	65534,
	2,
	2+99*64,
	0,
	65534,
	2,
	3+99*64,
	0,
	65534,
	2,
	4+99*64,
	0,
	65534,
	2,
	5+99*64,
	0,
	65534,
	2,
	6+99*64,
	0,
	65534,
	2,
	7+99*64,
	0,
	65534,
	0
};

uint16 f_ss_down[] = {
	2,
	8+99*64,
	0,
	2,
	2,
	9+99*64,
	0,
	2,
	2,
	10+99*64,
	0,
	2,
	2,
	11+99*64,
	0,
	2,
	2,
	12+99*64,
	0,
	2,
	2,
	13+99*64,
	0,
	2,
	2,
	14+99*64,
	0,
	2,
	2,
	15+99*64,
	0,
	2,
	0
};

uint16 f_ss_right[] = {
	4,
	24+99*64,
	4,
	0,
	4,
	25+99*64,
	4,
	0,
	4,
	26+99*64,
	4,
	0,
	4,
	27+99*64,
	4,
	0,
	4,
	28+99*64,
	4,
	0,
	4,
	29+99*64,
	4,
	0,
	4,
	30+99*64,
	4,
	0,
	4,
	31+99*64,
	4,
	0,
	0
};

uint16 f_ss_st_up[] = {
	99*64,
	1,
	1,
	36,
	0
};

uint16 f_ss_st_down[] = {
	99*64,
	1,
	1,
	32,
	0
};

uint16 f_ss_st_left[] = {
	99*64,
	1,
	1,
	34,
	0
};

uint16 f_ss_u_to_r[] = {
	45-8+99*64,
	0
};

uint16 f_ss_d_to_l[] = {
	41-8+99*64,
	0
};

uint16 f_ss_d_to_r[] = {
	47-8+99*64,
	0
};

uint16 f_ss_l_to_d[] = {
	41-8+99*64,
	0
};

uint16 f_ss_r_to_u[] = {
	45-8+99*64,
	0
};

uint16 f_ss_r_to_l[] = {
	45-8+99*64,
	44-8+99*64,
	43-8+99*64,
	0
};

TurnTable full_so_turnTable0 = {
	{ // turnTableUp
		0,
		f_ss_u_to_d,
		f_ss_u_to_l,
		f_ss_u_to_r,
		0
	},
	{ // turnTableDown
		f_ss_d_to_u,
		0,
		f_ss_d_to_l,
		f_ss_d_to_r,
		0
	},
	{ // turnTableLeft
		f_ss_l_to_u,
		f_ss_l_to_d,
		0,
		f_ss_l_to_r,
		0
	},
	{ // turnTableRight
		f_ss_r_to_u,
		f_ss_r_to_d,
		f_ss_r_to_l,
		0,
		0
	},
	{ // turnTableTalk
		0,
		0,
		0,
		0,
		0
	}
};

MegaSet full_so_megaSet0 = {
	3,	// gridWidth
	8,	// colOffset
	16,	// colWidth
	24,	// lastChr
	f_ss_up,	// animUp
	f_ss_down,	// animDown
	f_ss_left,	// animLeft
	f_ss_right,	// animRight
	f_ss_st_up,	// standUp
	f_ss_st_down,	// standDown
	f_ss_st_left,	// standLeft
	f_ss_st_right,	// standRight
	0,	// standTalk
	&full_so_turnTable0
};

ExtCompact full_so_ext = {
	0,	// actionSub
	0,	// actionSub_off
	0,	// getToSub
	0,	// getToSub_off
	0,	// extraSub
	0,	// extraSub_off
	3,	// dir
	STD_PLAYER_STOP,	// stopScript
	STD_MINI_BUMP,	// miniBump
	0,	// leaving
	0,	// atWatch
	0,	// atWas
	0,	// alt
	0,	// request
	96,	// spWidth_xx
	SP_COL_SO,	// spColour
	0,	// spTextId
	0,	// spTime
	0,	// arAnimIndex
	0,	// turnProg
	0,	// waitingFor
	0,	// arTarget_x
	0,	// arTarget_y
	full_ss_auto,	// animScratch
	0,	// megaSet
	&full_so_megaSet0,
	0,
	0,
	0
};

Compact full_so = {
	L_SCRIPT,	// logic
	ST_SORT+ST_RECREATE+ST_LOGIC+ST_GRID_PLOT+ST_COLLISION,	// status
	0,	// sync
	0,	// screen
	17,	// place
	0,	// getToTable
	288,	// xcood
	224,	// ycood
	31+99*64,	// frame
	0,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	(int16) 65488,	// mouseRel_y
	32,	// mouseSize_x
	48,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	0,	// mode
	FULL_SS_CUT,	// baseSub
	0,	// baseSub_off
	&full_so_ext
};

uint16 panel_seq[] = {
	165*64,
	321,
	187,
	0,
	321,
	187,
	1,
	321,
	187,
	2,
	321,
	187,
	3,
	0,
	0
};

uint16 chip_list_0[] = {
	14+0X8000,
	15+0X8000,
	71+0X8000,
	103+0X8000,
	24,
	75,
	44,
	270,
	273,
	86,
	87+0X8000,
	88+0X8000,
	89,
	91+0X8000,
	100,
	76,
	110,
	104,
	18,
	224,
	106,
	107,
	108,
	109,
	162,
	45,
	168,
	169,
	171,
	172,
	16,
	17,
	227+0X8000,
	99,
	0
};

uint16 use_the_bar[] = {
	91*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	0
};

uint16 small_closes[] = {
	104*64,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	0
};

uint16 jobs_buttons[] = {
	145*64,
	248,
	183,
	0,
	248,
	183,
	1,
	248,
	183,
	2,
	248,
	183,
	1,
	248,
	183,
	3,
	248,
	183,
	4,
	248,
	183,
	3,
	248,
	183,
	4,
	248,
	183,
	2,
	248,
	183,
	1,
	248,
	183,
	3,
	248,
	183,
	0,
	0,
	0
};

uint16 up_stairs[] = {
	14*64,
	189,
	296,
	0,
	190,
	294,
	1,
	192,
	293,
	2,
	194,
	291,
	3,
	193,
	290,
	4,
	194,
	288,
	5,
	196,
	285,
	6,
	197,
	284,
	7,
	197,
	283,
	8,
	198,
	281,
	9,
	200,
	279,
	10,
	201,
	278,
	11,
	201,
	277,
	12,
	202,
	276,
	13,
	204,
	273,
	14,
	205,
	272,
	15,
	205,
	271,
	16,
	207,
	269,
	17,
	210,
	267,
	18,
	210,
	266,
	11,
	210,
	265,
	12,
	211,
	264,
	13,
	213,
	261,
	14,
	214,
	260,
	15,
	214,
	259,
	16,
	216,
	257,
	17,
	219,
	255,
	18,
	219,
	254,
	11,
	219,
	253,
	12,
	220,
	252,
	13,
	222,
	249,
	14,
	223,
	248,
	15,
	223,
	247,
	16,
	225,
	246,
	19,
	228,
	246,
	20,
	230,
	246,
	21,
	230,
	242,
	22,
	231,
	242,
	23,
	236,
	241,
	24,
	234,
	241,
	25,
	234,
	240,
	26,
	234,
	240,
	27,
	234,
	240,
	28,
	236,
	235,
	29,
	235,
	235,
	30,
	230,
	240,
	31,
	225,
	246,
	32,
	225,
	246,
	33,
	225,
	235,
	34,
	224,
	235,
	35,
	219,
	240,
	36,
	215,
	240,
	37,
	216,
	240,
	38,
	215,
	235,
	39,
	213,
	235,
	40,
	209,
	240,
	41,
	208,
	240,
	42,
	206,
	240,
	43,
	206,
	240,
	44,
	206,
	240,
	45,
	204,
	233,
	46,
	204,
	232,
	47,
	204,
	232,
	48,
	204,
	232,
	49,
	0,
	0
};

uint16 chuck_seq[] = {
	59*64,
	334,
	222,
	0,
	334,
	222,
	1,
	334,
	222,
	2,
	0,
	0
};

uint16 rs_foster_to_0[] = {
	C_XCOOD,
	400+16,
	C_YCOOD,
	224-8,
	C_SCREEN,
	0,
	C_PLACE,
	17,
	65535
};

Compact fire_notice = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_MOUSE,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	399+2,	// xcood
	172,	// ycood
	0,	// frame
	4151,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	6,	// mouseSize_x
	10,	// mouseSize_y
	NOTICE_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	NOTICE_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 screen0_high_mouse[] = {
	70,
	17,
	ID_LOW_FLOOR,
	85,
	ID_NOTICE,
	90,
	18,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 foster_g_up[] = {
	141*64,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 rs_foster_s3[] = {
	C_XCOOD,
	336,
	C_YCOOD,
	288,
	C_PLACE,
	ID_S3_FLOOR,
	C_STATUS,
	ST_SORT+ST_RECREATE+ST_LOGIC+ST_AR_PRIORITY+ST_GRID_PLOT+ST_COLLISION,
	65535
};

uint16 rs_mini_foster[] = {
	C_XCOOD,
	192,
	C_YCOOD,
	312,
	C_FRAME,
	13*64+42,
	C_DIR,
	2,
	C_PLACE,
	69,
	C_GET_TO_FLAG,
	0,
	65535
};

uint16 bolt1_seq[] = {
	214*64,
	210,
	177,
	0,
	245,
	197,
	1,
	294,
	227,
	2,
	0
};

uint16 rs_foster_4_2[] = {
	C_XCOOD,
	424,
	C_YCOOD,
	248,
	C_SCREEN,
	2,
	C_PLACE,
	115,
	C_DIR,
	2,
	65535
};

uint16 screen0_high_logic[] = {
	ID_FOSTER,
	JOBS,
	ID_CUPBOARD,
	ID_KNOB,
	ID_LAZER,
	ID_CHUCK,
	MINI_SS,
	85,
	90,
	97,
	105,
	ID_FAN1,
	ID_FAN2,
	ID_FAN3,
	ID_FAN4,
	ID_FAN5,
	ID_FAN6,
	ID_FAN7,
	ID_PRESS,
	ID_LAZER_GUN,
	ID_UPLOAD,
	ID_NOTICE,
	ID_NOTICE2,
	ID_LOADER,
	ID_TOP_LIFT,
	4344,
	ID_TOP_BARREL,
	0XFFFF,
	ID_MENU_LOGIC
};

uint16 fan6_seq[] = {
	16*64,
	368,
	156,
	0,
	368,
	156,
	1,
	368,
	156,
	2,
	368,
	156,
	3,
	0
};

uint16 fexit_opens[] = {
	89*64,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 fost_push_knob[] = {
	153*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	5,
	SEND_SYNC,
	ID_KNOB,
	2,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 lazer_run_seq[] = {
	60*64,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	0
};

uint16 try_to_open_r0[] = {
	227*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 fast_list_cut2[] = {
	64,
	65,
	66,
	162,
	0
};

uint16 knob_down[] = {
	58*64,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 chip_list_sc0[] = {
	89,
	104,
	159,
	161,
	162,
	18,
	96,
	45,
	168,
	169,
	171,
	172,
	16,
	17,
	227+0X8000,
	64,
	65,
	66,
	75,
	23,
	0
};

uint16 sc0_cut_logic[] = {
	FULL_SS,
	90,
	105,
	97,
	ID_FAN1,
	ID_FAN2,
	ID_FAN3,
	ID_FAN4,
	ID_FAN5,
	ID_FAN6,
	ID_FAN7,
	ID_PRESS,
	ID_UPLOAD,
	ID_NOTICE,
	ID_NOTICE2,
	ID_LFAN1,
	ID_SMOKE1,
	ID_SMOKE2,
	ID_FIRE1,
	ID_FIRE2,
	ID_CAR_UP,
	ID_CAR_DOWN,
	0XFFFF,
	ID_MENU_LOGIC
};

Compact lazer_gun = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	LAZER_GUN_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 up_stairs2[] = {
	15*64,
	203,
	229,
	0,
	203,
	228,
	1,
	202,
	227,
	2,
	202,
	226,
	3,
	202,
	226,
	4,
	202,
	227,
	5,
	202,
	223,
	6,
	202,
	222,
	7,
	200,
	222,
	8,
	200,
	220,
	9,
	199,
	220,
	10,
	199,
	220,
	11,
	199,
	217,
	12,
	198,
	216,
	13,
	198,
	216,
	14,
	198,
	216,
	15,
	198,
	216,
	16,
	198,
	211,
	17,
	198,
	209,
	18,
	198,
	209,
	19,
	198,
	216,
	20,
	196,
	206,
	21,
	195,
	204,
	22,
	195,
	203,
	23,
	194,
	202,
	24,
	194,
	201,
	25,
	187,
	199,
	26,
	187,
	197,
	27,
	186,
	195,
	28,
	186,
	195,
	29,
	185,
	193,
	30,
	185,
	192,
	31,
	185,
	189,
	32,
	184,
	187,
	33,
	184,
	187,
	34,
	183,
	185,
	35,
	183,
	183,
	36,
	182,
	180,
	37,
	181,
	178,
	38,
	181,
	177,
	39,
	180,
	176,
	40,
	179,
	174,
	41,
	179,
	171,
	42,
	178,
	168,
	43,
	177,
	167,
	44,
	176,
	166,
	45,
	176,
	166,
	46,
	175,
	166,
	47,
	175,
	167,
	48,
	175,
	166,
	49,
	0,
	0
};

uint16 barrel_down_seq[] = {
	205*64,
	270,
	141,
	0,
	270,
	141,
	1,
	270,
	141,
	2,
	270,
	146,
	3,
	270,
	151,
	4,
	270,
	156,
	5,
	270,
	160,
	6,
	270,
	165,
	7,
	270,
	169,
	8,
	270,
	173,
	9,
	270,
	177,
	10,
	270,
	182,
	11,
	270,
	186,
	12,
	270,
	191,
	13,
	270,
	196,
	14,
	270,
	201,
	15,
	0
};

uint16 daft_seq[] = {
	161*64,
	193,
	268,
	0,
	192,
	268,
	1,
	191,
	268,
	2,
	190,
	268,
	3,
	189,
	268,
	4,
	188,
	268,
	5,
	187,
	268,
	6,
	187,
	268,
	7,
	187,
	268,
	8,
	187,
	268,
	9,
	187,
	269,
	10,
	187,
	270,
	11,
	187,
	271,
	9,
	187,
	271,
	8,
	187,
	271,
	7,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	6,
	187,
	271,
	12,
	187,
	271,
	13,
	187,
	271,
	14,
	187,
	271,
	15,
	187,
	271,
	16,
	187,
	271,
	17,
	187,
	271,
	18,
	187,
	271,
	19,
	187,
	271,
	19,
	187,
	271,
	20,
	187,
	271,
	21,
	187,
	271,
	22,
	186,
	271,
	23,
	185,
	271,
	24,
	185,
	271,
	25,
	186,
	271,
	26,
	186,
	271,
	27,
	187,
	271,
	28,
	187,
	270,
	29,
	187,
	269,
	30,
	187,
	268,
	28,
	186,
	268,
	27,
	186,
	268,
	26,
	185,
	268,
	25,
	186,
	268,
	31,
	187,
	268,
	32,
	188,
	268,
	33,
	189,
	268,
	34,
	190,
	268,
	35,
	191,
	268,
	36,
	0,
	0
};

uint16 down_stairs2[] = {
	72*64,
	213,
	240,
	0,
	218,
	235,
	1,
	221,
	235,
	2,
	221,
	240,
	3,
	223,
	246,
	4,
	225,
	246,
	5,
	231,
	235,
	6,
	234,
	235,
	7,
	233,
	240,
	8,
	233,
	240,
	9,
	233,
	241,
	10,
	233,
	242,
	11,
	233,
	242,
	12,
	233,
	246,
	13,
	233,
	246,
	14,
	233,
	247,
	15,
	235,
	247,
	16,
	233,
	247,
	17,
	227,
	248,
	18,
	226,
	248,
	19,
	223,
	251,
	20,
	223,
	251,
	21,
	223,
	252,
	22,
	222,
	254,
	23,
	219,
	257,
	24,
	217,
	257,
	25,
	216,
	258,
	26,
	215,
	260,
	19,
	211,
	263,
	20,
	211,
	263,
	21,
	211,
	264,
	22,
	211,
	266,
	23,
	209,
	269,
	24,
	207,
	269,
	25,
	206,
	270,
	26,
	205,
	272,
	19,
	202,
	275,
	20,
	202,
	275,
	21,
	202,
	276,
	22,
	202,
	278,
	23,
	200,
	281,
	24,
	198,
	281,
	25,
	197,
	282,
	26,
	196,
	284,
	19,
	193,
	287,
	20,
	193,
	288,
	27,
	192,
	289,
	28,
	193,
	293,
	29,
	191,
	296,
	30,
	189,
	296,
	31,
	0,
	0
};

uint16 joey_jump_seq[] = {
	201*64,
	228,
	172,
	0,
	228,
	172,
	0,
	228,
	172,
	1,
	228,
	172,
	1,
	228,
	172,
	2,
	228,
	172,
	2,
	228,
	172,
	3,
	228,
	172,
	3,
	228,
	172,
	4,
	228,
	172,
	4,
	228,
	172,
	5,
	228,
	172,
	5,
	228,
	172,
	6,
	228,
	172,
	6,
	228,
	172,
	7,
	228,
	172,
	7,
	228,
	172,
	8,
	228,
	172,
	8,
	228,
	172,
	9,
	228,
	172,
	10,
	228,
	172,
	11,
	228,
	172,
	12,
	228,
	172,
	13,
	228,
	172,
	14,
	228,
	172,
	15,
	228,
	172,
	16,
	228,
	172,
	17,
	228,
	172,
	9,
	228,
	172,
	10,
	228,
	172,
	11,
	228,
	172,
	12,
	228,
	172,
	13,
	228,
	172,
	14,
	228,
	172,
	15,
	228,
	172,
	16,
	228,
	172,
	17,
	228,
	172,
	9,
	228,
	172,
	10,
	228,
	172,
	11,
	228,
	172,
	12,
	228,
	172,
	13,
	228,
	172,
	14,
	228,
	172,
	15,
	228,
	172,
	16,
	228,
	172,
	17,
	228,
	172,
	8,
	228,
	172,
	8,
	228,
	172,
	7,
	228,
	172,
	7,
	228,
	172,
	6,
	228,
	172,
	6,
	228,
	172,
	5,
	228,
	172,
	5,
	228,
	172,
	4,
	228,
	172,
	4,
	228,
	172,
	3,
	228,
	172,
	3,
	228,
	172,
	2,
	228,
	172,
	2,
	228,
	172,
	1,
	228,
	172,
	1,
	228,
	172,
	0,
	0,
	0
};

uint16 fost_lean_seq[] = {
	21*64,
	263,
	201,
	0,
	263,
	201,
	0,
	263,
	201,
	1,
	263,
	201,
	1,
	263,
	201,
	2,
	263,
	201,
	2,
	263,
	201,
	3,
	263,
	201,
	3,
	263,
	201,
	4,
	263,
	201,
	4,
	263,
	201,
	5,
	263,
	201,
	5,
	263,
	201,
	5,
	263,
	201,
	5,
	263,
	201,
	5,
	263,
	201,
	5,
	263,
	201,
	6,
	263,
	201,
	6,
	263,
	201,
	7,
	263,
	201,
	7,
	263,
	201,
	8,
	263,
	201,
	8,
	263,
	201,
	9,
	263,
	201,
	9,
	263,
	201,
	10,
	263,
	201,
	10,
	263,
	201,
	11,
	263,
	201,
	11,
	0,
	0
};

uint16 joey_wake_seq[] = {
	174*64,
	312,
	294,
	0,
	311,
	294,
	1,
	312,
	294,
	0,
	312,
	294,
	2,
	312,
	294,
	3,
	311,
	294,
	1,
	311,
	294,
	4,
	312,
	294,
	5,
	312,
	294,
	0,
	312,
	294,
	2,
	312,
	294,
	3,
	311,
	294,
	1,
	311,
	294,
	4,
	312,
	294,
	5,
	312,
	294,
	0,
	311,
	294,
	1,
	312,
	294,
	0,
	311,
	294,
	1,
	312,
	294,
	0,
	312,
	294,
	2,
	312,
	294,
	3,
	311,
	294,
	1,
	311,
	294,
	4,
	312,
	294,
	5,
	312,
	294,
	6,
	311,
	294,
	7,
	309,
	294,
	8,
	306,
	293,
	9,
	301,
	291,
	10,
	0,
	0
};

uint16 low_lift_down_seq2[] = {
	203*64,
	250,
	141,
	9,
	250,
	141,
	8,
	250,
	141,
	7,
	250,
	141,
	6,
	250,
	141,
	5,
	250,
	141,
	4,
	250,
	141,
	3,
	250,
	141,
	2,
	250,
	141,
	1,
	250,
	146,
	1,
	250,
	151,
	0,
	250,
	156,
	0,
	0
};

uint16 lazer_start_seq[] = {
	60*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 get_the_bar[] = {
	87*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	9,
	0
};

uint16 fan4_seq[] = {
	171*64,
	428,
	216,
	0,
	428,
	216,
	1,
	428,
	216,
	2,
	428,
	216,
	3,
	428,
	216,
	4,
	0
};

uint16 tv_seq[] = {
	56*64,
	270,
	190,
	0,
	270,
	190,
	1,
	270,
	190,
	2,
	270,
	190,
	3,
	270,
	190,
	4,
	270,
	190,
	5,
	270,
	190,
	6,
	270,
	190,
	7,
	0,
	0
};

uint16 bolt2_seq[] = {
	214*64,
	210,
	177,
	0,
	237,
	203,
	1,
	296,
	239,
	2,
	0
};

Compact fan6 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	16*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN6_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 jobs_pull_knob[] = {
	143*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	SEND_SYNC,
	ID_KNOB,
	1,
	1,
	1,
	3,
	0
};

uint16 convey_seq[] = {
	208*64,
	250,
	268,
	0,
	250,
	268,
	1,
	250,
	268,
	2,
	250,
	268,
	3,
	0
};

uint16 fan5_seq[] = {
	172*64,
	374,
	165,
	0,
	374,
	165,
	1,
	374,
	165,
	2,
	374,
	165,
	3,
	374,
	165,
	4,
	0
};

uint32 *grid2 = 0;

uint16 guard_lean_out[] = {
	20*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	0
};

uint32 *c101 = (uint32*)(&full_so);

uint16 put_bar_away[] = {
	88*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	0
};

uint16 fan3_seq[] = {
	169*64,
	229,
	137,
	0,
	229,
	137,
	1,
	229,
	137,
	2,
	229,
	137,
	3,
	0
};

uint16 s1_pal[] = {
	0,
	1024,
	1540,
	1030,
	1540,
	2054,
	1544,
	2566,
	1030,
	1548,
	2564,
	2056,
	2058,
	3594,
	1544,
	2062,
	4616,
	2058,
	2580,
	3590,
	3596,
	3088,
	4620,
	2572,
	2584,
	5638,
	2060,
	3600,
	5140,
	3598,
	3606,
	7180,
	1548,
	3608,
	6154,
	3086,
	4114,
	8466,
	1548,
	4116,
	7186,
	2574,
	4120,
	4622,
	5650,
	3617,
	7176,
	3088,
	4126,
	9482,
	2062,
	4632,
	8980,
	2064,
	5142,
	7702,
	3602,
	3623,
	9994,
	2576,
	5148,
	8978,
	3090,
	4137,
	6666,
	6166,
	5155,
	7694,
	5142,
	4651,
	9994,
	3604,
	5161,
	7180,
	6168,
	6174,
	9494,
	4118,
	6179,
	8978,
	5656,
	5673,
	11024,
	3606,
	6686,
	9500,
	5146,
	6691,
	11032,
	4120,
	6695,
	12052,
	3096,
	7203,
	11034,
	5148,
	7719,
	11032,
	5660,
	7717,
	12060,
	4636,
	7721,
	11032,
	5150,
	8487,
	10526,
	6689,
	8491,
	13082,
	5150,
	8493,
	12056,
	6177,
	9001,
	11553,
	7203,
	8499,
	10518,
	8997,
	9011,
	12056,
	7205,
	9519,
	14110,
	5155,
	10029,
	13089,
	6693,
	10027,
	12583,
	7207,
	9529,
	15128,
	6181,
	10543,
	13093,
	7721,
	10551,
	12570,
	8491,
	11061,
	13598,
	8491,
	11567,
	15657,
	6697,
	11065,
	13084,
	9517,
	11573,
	14627,
	7725,
	11581,
	14620,
	8495,
	12085,
	14633,
	9519,
	12595,
	15149,
	8497,
	12599,
	15145,
	9521,
	13117,
	13601,
	11061,
	13111,
	15663,
	10547,
	13631,
	15139,
	11573,
	13629,
	16171,
	9527,
	14137,
	15665,
	11575,
	14655,
	16167,
	10553,
	14653,
	15151,
	14137,
	15165,
	15667,
	13627,
	15679,
	16173,
	14653,
	6441,
	12307,
	6179,
	4923,
	11781,
	1560,
	3873,
	5121,
	8,
	2064,
	4614,
	1545,
	1804,
	4101,
	1801,
	1803,
	2823,
	2825,
	2828,
	5645,
	1546,
	2842,
	16134,
	21,
	2837,
	5895,
	2317,
	1288,
	3588,
	1544,
	1030,
	2052,
	1029,
	1546,
	16132,
	11581,
	14655,
	16162,
	6195,
	11327,
	16142,
	1829,
	7487,
	13571,
	2844,
	6700,
	8976,
	4632,
	0,
	2816,
	2827,
	2570,
	2058,
	516,
	1546,
	3076,
	1287,
	2062,
	4102,
	1801,
	2578,
	5640,
	2060,
	3100,
	6150,
	2574,
	4124,
	8972,
	2064,
	4638,
	7694,
	5142,
	0,
	7680,
	5142,
	6179,
	9490,
	5146,
	6695,
	8980,
	6684,
	7211,
	10004,
	6174,
	7721,
	12056,
	6177,
	9005,
	11548,
	8487,
	10033,
	12572,
	8491,
	12603,
	15141,
	14137,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	10243,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9227,
	1285,
	287,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	16191,
	63,
	16191,
	16128,
	63,
	16191,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 eye_shoot[] = {
	213*64,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	3,
	1,
	1,
	2,
	0
};

uint16 furnace_door_open[] = {
	215*64,
	398,
	222,
	0,
	398,
	222,
	1,
	398,
	222,
	2,
	398,
	222,
	3,
	398,
	222,
	4,
	398,
	222,
	5,
	398,
	222,
	6,
	398,
	222,
	7,
	398,
	222,
	8,
	398,
	222,
	9,
	398,
	222,
	10,
	398,
	222,
	11,
	0
};

uint16 ss_smokes_4[] = {
	109*64,
	289,
	221,
	0,
	289,
	221,
	0,
	289,
	221,
	1,
	289,
	221,
	1,
	289,
	221,
	2,
	289,
	221,
	2,
	289,
	221,
	3,
	289,
	221,
	3,
	289,
	221,
	4,
	289,
	221,
	4,
	289,
	221,
	5,
	289,
	221,
	5,
	289,
	221,
	6,
	289,
	221,
	6,
	289,
	221,
	7,
	289,
	221,
	7,
	289,
	221,
	8,
	289,
	221,
	8,
	0,
	0
};

Compact fan5 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	172*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN5_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 jobs_close[] = {
	63*64,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	7,
	SEND_SYNC,
	ID_CUPBOARD,
	1,
	1,
	1,
	7,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 cup_open_seq[] = {
	57*64,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 guard_lean_back[] = {
	20*64,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 ss_kick_2[] = {
	100*64,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	9,
	1,
	1,
	10,
	0
};

uint16 shot1_seq[] = {
	219*64,
	355,
	249,
	0,
	349,
	250,
	1,
	347,
	249,
	2,
	346,
	249,
	3,
	347,
	249,
	4,
	341,
	250,
	5,
	331,
	251,
	6,
	331,
	251,
	7,
	331,
	250,
	8,
	331,
	251,
	9,
	331,
	251,
	10,
	331,
	251,
	6,
	331,
	251,
	6,
	340,
	247,
	11,
	348,
	251,
	12,
	354,
	251,
	13,
	355,
	252,
	14,
	359,
	252,
	15,
	368,
	250,
	16,
	367,
	249,
	17,
	371,
	250,
	18,
	376,
	249,
	19,
	376,
	249,
	20,
	376,
	249,
	20,
	376,
	249,
	20,
	375,
	249,
	21,
	376,
	249,
	22,
	376,
	249,
	23,
	376,
	249,
	23,
	376,
	249,
	23,
	376,
	249,
	23,
	376,
	249,
	23,
	376,
	249,
	23,
	0
};

uint16 fexit_closes[] = {
	89*64,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 low_lift_down_seq3[] = {
	202*64,
	250,
	160,
	7,
	250,
	165,
	7,
	250,
	169,
	6,
	250,
	174,
	6,
	250,
	178,
	5,
	250,
	183,
	5,
	250,
	187,
	4,
	250,
	192,
	4,
	250,
	196,
	3,
	250,
	201,
	2,
	250,
	205,
	1,
	250,
	210,
	0,
	0
};

uint16 rs_restart_barrel[] = {
	C_STATUS,
	ST_SORT+ST_LOGIC+ST_RECREATE,
	C_XCOOD,
	264,
	C_YCOOD,
	240,
	C_FRAME,
	155*64,
	65535
};

uint16 open_r0[] = {
	227*64,
	283,
	214,
	0,
	283,
	214,
	1,
	283,
	214,
	2,
	283,
	214,
	3,
	283,
	214,
	4,
	283,
	214,
	5,
	283,
	214,
	5,
	283,
	214,
	5,
	283,
	214,
	6,
	283,
	214,
	0,
	283,
	214,
	0,
	0,
	0
};

uint16 rs_foster_2_4[] = {
	C_XCOOD,
	168+8,
	C_YCOOD,
	248,
	C_SCREEN,
	4,
	C_PLACE,
	ID_S4_FLOOR,
	C_DIR,
	3,
	65535
};

uint16 ss_shoot_seq[] = {
	110*64,
	275,
	261,
	0,
	276,
	261,
	1,
	272,
	261,
	2,
	272,
	261,
	3,
	272,
	261,
	4,
	271,
	261,
	5,
	270,
	262,
	6,
	274,
	259,
	7,
	273,
	261,
	8,
	270,
	262,
	9,
	272,
	261,
	10,
	274,
	261,
	11,
	274,
	261,
	12,
	273,
	261,
	13,
	274,
	262,
	14,
	276,
	262,
	15,
	276,
	261,
	16,
	0,
	0
};

uint16 shut_r1[] = {
	226*64,
	227,
	194,
	0,
	224,
	194,
	1,
	227,
	194,
	2,
	224,
	194,
	3,
	220,
	194,
	4,
	215,
	194,
	5,
	210,
	194,
	6,
	215,
	194,
	7,
	227,
	194,
	8,
	0
};

uint16 down_stairs[] = {
	71*64,
	173,
	159,
	0,
	174,
	161,
	1,
	174,
	164,
	2,
	175,
	167,
	3,
	176,
	169,
	4,
	177,
	170,
	5,
	177,
	172,
	6,
	178,
	175,
	7,
	179,
	177,
	8,
	179,
	179,
	9,
	180,
	180,
	10,
	181,
	181,
	11,
	181,
	184,
	12,
	182,
	186,
	13,
	182,
	188,
	14,
	183,
	188,
	15,
	184,
	190,
	16,
	183,
	193,
	17,
	184,
	194,
	18,
	184,
	196,
	19,
	185,
	196,
	20,
	185,
	198,
	21,
	191,
	200,
	22,
	192,
	202,
	23,
	193,
	203,
	24,
	193,
	204,
	25,
	194,
	205,
	26,
	198,
	216,
	27,
	198,
	216,
	28,
	198,
	216,
	29,
	198,
	216,
	30,
	198,
	216,
	31,
	198,
	216,
	32,
	198,
	216,
	33,
	198,
	216,
	34,
	198,
	216,
	35,
	198,
	217,
	36,
	199,
	220,
	37,
	199,
	222,
	38,
	199,
	222,
	39,
	199,
	222,
	40,
	199,
	223,
	41,
	202,
	228,
	42,
	202,
	228,
	43,
	202,
	228,
	44,
	202,
	228,
	45,
	202,
	228,
	46,
	202,
	229,
	47,
	204,
	232,
	48,
	204,
	232,
	49,
	204,
	232,
	50,
	204,
	232,
	51,
	204,
	233,
	52,
	204,
	234,
	53,
	206,
	240,
	54,
	206,
	240,
	55,
	206,
	240,
	56,
	206,
	240,
	57,
	206,
	240,
	58,
	206,
	240,
	59,
	207,
	235,
	60,
	209,
	235,
	61,
	211,
	246,
	62,
	212,
	240,
	63,
	0
};

uint16 barrel_seq[] = {
	155*64,
	264,
	240,
	0,
	264,
	240,
	1,
	264,
	240,
	2,
	264,
	240,
	3,
	264,
	240,
	4,
	264,
	240,
	5,
	0
};

uint16 jobs_scratch[] = {
	144*64,
	284,
	191,
	0,
	284,
	191,
	1,
	284,
	191,
	2,
	284,
	191,
	3,
	284,
	191,
	4,
	284,
	191,
	3,
	284,
	191,
	4,
	284,
	191,
	3,
	284,
	191,
	4,
	284,
	191,
	3,
	284,
	191,
	4,
	284,
	191,
	3,
	284,
	191,
	2,
	284,
	191,
	1,
	284,
	191,
	0,
	284,
	191,
	0,
	284,
	191,
	0,
	284,
	191,
	0,
	284,
	191,
	0,
	284,
	191,
	0,
	0,
	0
};

uint16 unload_seq2[] = {
	160*64,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	16,
	1,
	1,
	18,
	0
};

uint16 rs_foster_0_2[] = {
	C_XCOOD,
	128-8,
	C_YCOOD,
	264,
	C_SCREEN,
	2,
	C_PLACE,
	115,
	C_DIR,
	3,
	C_FRAME,
	46+12*64,
	65535
};

uint16 r1_closes[] = {
	96*64,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	9,
	0
};

uint16 rs_convey[] = {
	C_STATUS,
	ST_LOGIC+ST_RECREATE+ST_NO_VMASK,
	65535
};

uint16 jobs_push_knob[] = {
	143*64,
	1,
	1,
	3,
	SEND_SYNC,
	ID_KNOB,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 knob_up[] = {
	58*64,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 crouch_talk[] = {
	24*64,
	24*64+3,
	265,
	192,
	0,
	265,
	192,
	1,
	265,
	192,
	1,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	3,
	265,
	192,
	3,
	265,
	192,
	0,
	265,
	192,
	0,
	265,
	192,
	1,
	265,
	192,
	1,
	265,
	192,
	0,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	0,
	265,
	192,
	0,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	3,
	265,
	192,
	3,
	265,
	192,
	0,
	265,
	192,
	0,
	265,
	192,
	1,
	265,
	192,
	1,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	3,
	265,
	192,
	3,
	265,
	192,
	0,
	265,
	192,
	0,
	265,
	192,
	1,
	265,
	192,
	1,
	265,
	192,
	0,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	0,
	265,
	192,
	0,
	265,
	192,
	2,
	265,
	192,
	2,
	265,
	192,
	3,
	265,
	192,
	3,
	265,
	192,
	0,
	0
};

uint16 shot2_seq[] = {
	220*64,
	344,
	249,
	0,
	343,
	256,
	1,
	346,
	260,
	2,
	352,
	257,
	3,
	362,
	257,
	4,
	373,
	249,
	5,
	373,
	242,
	6,
	362,
	244,
	7,
	367,
	251,
	8,
	363,
	261,
	9,
	373,
	273,
	10,
	373,
	273,
	11,
	373,
	273,
	12,
	373,
	273,
	13,
	373,
	273,
	14,
	373,
	273,
	15,
	0
};

uint16 joey_fly2[] = {
	210*64,
	328,
	204,
	0,
	328,
	206,
	1,
	328,
	209,
	0,
	328,
	211,
	1,
	328,
	214,
	0,
	328,
	216,
	1,
	328,
	219,
	0,
	328,
	221,
	1,
	328,
	224,
	0,
	328,
	226,
	1,
	328,
	229,
	0,
	328,
	231,
	1,
	328,
	234,
	0,
	328,
	235,
	1,
	328,
	237,
	0,
	328,
	238,
	1,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	3,
	328,
	238,
	4,
	328,
	238,
	4,
	328,
	238,
	5,
	328,
	238,
	5,
	328,
	238,
	2,
	328,
	238,
	2,
	328,
	238,
	3,
	328,
	238,
	3,
	328,
	237,
	6,
	328,
	235,
	7,
	328,
	235,
	8,
	328,
	236,
	9,
	328,
	237,
	10,
	328,
	240,
	11,
	328,
	245,
	12,
	328,
	244,
	13,
	328,
	245,
	14,
	328,
	246,
	15,
	0,
	0
};

uint16 jobs_key_seq[] = {
	166*64,
	254,
	198,
	0,
	254,
	198,
	1,
	254,
	198,
	1,
	254,
	198,
	2,
	254,
	198,
	2,
	254,
	198,
	2,
	254,
	198,
	1,
	254,
	198,
	1,
	254,
	198,
	0,
	0,
	0
};

uint16 rs_mega_2_0[] = {
	C_XCOOD,
	408,
	C_YCOOD,
	272,
	C_SCREEN,
	0,
	C_PLACE,
	ID_LOW_FLOOR,
	C_DIR,
	2,
	C_MOUSE_REL_X,
	65532,
	C_MOUSE_REL_Y,
	65516,
	C_MOUSE_SIZE_X,
	8,
	C_MOUSE_SIZE_Y,
	28,
	65535
};

uint16 uncrouch_seq[] = {
	76*64,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	0
};

uint16 fost_must_close[] = {
	141*64,
	SEND_SYNC,
	ID_CUPBOARD,
	1,
	1,
	1,
	142*64+2,
	1,
	1,
	142*64+2,
	1,
	1,
	142*64+0,
	1,
	1,
	8,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 joey_fly1[] = {
	209*64,
	268,
	141,
	0,
	263,
	141,
	1,
	258,
	141,
	2,
	253,
	141,
	3,
	249,
	141,
	4,
	247,
	141,
	5,
	245,
	142,
	6,
	243,
	145,
	7,
	242,
	148,
	6,
	240,
	152,
	7,
	239,
	155,
	6,
	238,
	159,
	7,
	237,
	162,
	6,
	237,
	166,
	7,
	237,
	170,
	6,
	237,
	174,
	7,
	239,
	178,
	6,
	240,
	181,
	7,
	243,
	184,
	6,
	246,
	187,
	7,
	249,
	189,
	6,
	252,
	190,
	7,
	256,
	191,
	6,
	260,
	192,
	7,
	263,
	193,
	6,
	267,
	193,
	7,
	271,
	193,
	6,
	275,
	193,
	7,
	279,
	193,
	6,
	283,
	192,
	7,
	287,
	192,
	6,
	290,
	191,
	7,
	294,
	191,
	6,
	298,
	190,
	7,
	302,
	189,
	6,
	305,
	188,
	7,
	309,
	187,
	6,
	312,
	186,
	7,
	316,
	185,
	6,
	319,
	184,
	7,
	322,
	182,
	6,
	323,
	181,
	7,
	324,
	181,
	6,
	325,
	181,
	7,
	326,
	182,
	6,
	327,
	182,
	7,
	328,
	181,
	6,
	328,
	180,
	7,
	328,
	179,
	6,
	328,
	179,
	7,
	328,
	180,
	6,
	328,
	180,
	7,
	328,
	180,
	6,
	328,
	180,
	7,
	328,
	181,
	6,
	328,
	183,
	7,
	328,
	184,
	6,
	328,
	186,
	7,
	328,
	189,
	6,
	328,
	191,
	7,
	328,
	194,
	6,
	328,
	196,
	7,
	328,
	199,
	6,
	328,
	201,
	7,
	0,
	0
};

uint16 lazer_gun_seq[] = {
	224*64,
	245,
	251,
	0,
	237,
	246,
	1,
	236,
	245,
	2,
	238,
	247,
	3,
	0,
	0
};

uint16 rs_mega_0_2[] = {
	C_XCOOD,
	128-16,
	C_YCOOD,
	264,
	C_SCREEN,
	2,
	C_PLACE,
	115,
	C_DIR,
	3,
	C_MOUSE_REL_X,
	65520,
	C_MOUSE_REL_Y,
	65488,
	C_MOUSE_SIZE_X,
	32,
	C_MOUSE_SIZE_Y,
	48,
	65535
};

Compact fan2 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC,	// status
	0,	// sync
	0,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	168*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	FAN2_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 fan2_seq[] = {
	168*64,
	255,
	137,
	0,
	255,
	137,
	1,
	255,
	137,
	2,
	0
};

uint32 *grid0 = 0;

void *data_1[] = {
	0,
	0,
	0,
	0,
	&mini_so,
	&full_so,
	&fan1,
	&right_exit_rm2,
	&sc4_floor,
	&sc4_left_exit,
	l_talk_s4,
	&r_talk_s4,
	&tv_screens_s4,
	&knob_s4,
	&chuck_s4,
	&lazer_s4,
	&cupboard_s4,
	&sarnie_s4,
	&spanner_s4,
	&buttons_s4,
	&top_lift,
	&monitors_s4,
	0,
	&hole,
	&top_barrel,
	&loader,
	&jobsworth,
	rs_test_jobs,
	0,
	&load_point,
	&light_one,
	&panel,
	&alarm_flash,
	0,
	&s3_floor,
	&robot_shell,
	crouch_talk,
	&dead_loader,
	0,
	0,
	0,
	&low_lift,
	&steve_watch,
	&low_barrel,
	&convey,
	&joey_fly,
	&furnace,
	&lights1,
	&eye_ball,
	&eye_bolt,
	&furnace_door,
	&slot,
	&shades,
	&lazer_gun,
	&smoulder,
	&fire_notice,
	&fire_notice2,
	&ss_sign,
	&postcard,
	&notice4,
	joey_list_s2,
	joey_list_s4,
	rs_mini_ss,
	chip_list_0,
	fast_list_cut,
	fast_list_cut2,
	chip_list_sc0,
	0,
	fast_list_sc2,
	chip_list_s2,
	fast_list_sc1,
	fast_list_sc4,
	chip_list_sc4,
	0,
	chip_list_sc3,
	0,
	sc4_logic,
	sc4_mouse,
	sc4_mouse_open,
	sc2_logic,
	sc2_mouse,
	s3_logic,
	s3_mouse,
	sc0_cut_logic,
	screen1_logic,
	screen0_low_logic,
	screen0_high_logic,
	sc1_mouse,
	screen0_high_mouse,
	screen0_low_mouse,
	up_stairs,
	up_stairs2,
	down_stairs,
	down_stairs2,
	crouch_seq,
	uncrouch_seq,
	get_the_bar,
	put_bar_away,
	get_bar_out,
	use_the_bar,
	fexit_closes,
	fexit_opens,
	use_bar2,
	r1_closes,
	r1_opens,
	try_to_open_r0,
	open_r0,
	shut_r1,
	open_r1,
	ss_kick,
	ss_kick_2,
	foster_hanging,
	foster_shot,
	small_closes,
	small_opens,
	ss_smokes_1,
	ss_smokes_2,
	ss_smokes_3,
	ss_smokes_4,
	ss_shoot_seq,
	fan1_seq,
	tv_seq,
	knob_down,
	knob_up,
	chuck_seq,
	lazer_start_seq,
	lazer_run_seq,
	lazer_stop_seq,
	cup_open_seq,
	cup_close_seq,
	jobs_close,
	foster_g_d,
	fost_open_cup,
	fost_close_cup,
	jobs_look_scrn,
	jobs_pull_knob,
	jobs_push_knob,
	jobs_buttons,
	jobs_chuck_look,
	fost_cant_open,
	fost_must_close,
	top_lift_down,
	top_lift_up,
	monitor_seq,
	fost_but_seq,
	fost_pull_knob,
	fost_push_knob,
	jobs_scratch,
	barrel_seq,
	unload_seq1,
	unload_seq2,
	reverse_seq,
	daft_seq,
	panel_seq,
	jobs_key_seq,
	alarm_seq,
	slide_seq,
	slide2_seq,
	joey_wake_seq,
	joey_jump_seq,
	liftc1_up,
	liftc2_up,
	liftc3_up,
	low_lift_down_seq1,
	low_lift_down_seq2,
	low_lift_down_seq3,
	barrel_down_seq,
	barrel_down_seq2,
	barrel_in_seq,
	convey_seq,
	joey_fly1,
	joey_fly2,
	furnace_seq,
	lights1_seq,
	eye_open,
	eye_blink,
	eye_shoot,
	furnace_door_open,
	joey_door_seq,
	shot1_seq,
	shot2_seq,
	bolt1_seq,
	bolt2_seq,
	lazer_gun_seq,
	load_point_seq,
	smoulder_seq,
	rs_mini_foster,
	rs_big_foster,
	rs_foster_to_1,
	rs_foster_to_0,
	rs_ss_to_1,
	rs_foster_0_2,
	rs_foster_2_0,
	rs_mega_0_2,
	rs_mega_2_0,
	rs_foster_to_one,
	rs_foster_2_4,
	rs_foster_4_2,
	rs_jobs_4_2,
	rs_restart_barrel,
	rs_start_alarm,
	rs_foster_s3,
	foster_g_up,
	rs_convey,
	rs_joey_to_furnace,
	rs_start_joey_fly,
	joey_list_s3,
	&fan2,
	fan2_seq,
	&fan3,
	fan3_seq,
	&fan4,
	fan4_seq,
	&fan5,
	fan5_seq,
	&fan6,
	fan6_seq,
	&fan7,
	fan7_seq,
	&left_exit_rm2,
	s0_pal,
	s1_pal,
	s2_pal,
	s3_pal,
	s4_pal,
	&press,
	press_seq,
	fost_knob_locked,
	fost_lean_seq,
	chip_list_1,
	&lfan1,
	lfan1_seq,
	&lfan2,
	lfan2_seq,
	&smoke1,
	smoke1_seq,
	&smoke2,
	smoke2_seq,
	grid0,
	grid1,
	grid2,
	grid3,
	grid4,
	&junk1,
	&junk2,
	rs_foster_5_0,
	rs_low_lift,
	rs_low_barrel,
	&top_lift_2,
	top_lift_2_down,
	top_lift_2_up,
	liftc1_down,
	liftc2_down,
	liftc3_down,
	&low_lift_2,
	&low_lift_3,
	rs_low_lift2,
	rs_low_lift3,
	guard_lean_out,
	guard_lean_back,
	push_small,
	PCONLY_F_R3_1,
	PCONLY_F_R3_2,
	search_seq,
	&fire1,
	fire1_seq,
	&fire2,
	fire2_seq,
	&car_up,
	car_up_seq,
	&car_down,
	car_down_seq
};

} // namespace SkyCompact

} // namespace Sky

#endif
