/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compacts/66comp.h,v 1.10 2004/01/06 12:45:32 fingolfin Exp $ 
 *
 */

#ifndef SKY66COMP_H
#define SKY66COMP_H


#include "67comp.h"
#include "71comp.h"
#include "68comp.h"
#include "72comp.h"
#include "69comp.h"
#include "70comp.h"
#include "73comp.h"
#include "74comp.h"
#include "75comp.h"
#include "76comp.h"
#include "77comp.h"
#include "78comp.h"
#include "79comp.h"
#include "80comp.h"
#include "81comp.h"
#include "82comp.h"


namespace Sky {

namespace SkyCompact {

uint16 sc66_hi_beam_an1[] = {
	98*64,
	205,
	144,
	0,
	205,
	144,
	1,
	205,
	144,
	2,
	0
};

uint16 sc66_door_close[] = {
	105*64,
	161,
	148,
	0,
	161,
	148,
	1,
	161,
	148,
	2,
	161,
	148,
	3,
	161,
	148,
	4,
	0
};

uint16 sc75_dead_tlk[] = {
	162*64,
	162*64,
	167,
	238,
	0,
	167,
	238,
	0,
	167,
	238,
	1,
	167,
	238,
	1,
	167,
	238,
	2,
	167,
	238,
	2,
	167,
	238,
	0,
	167,
	238,
	0,
	167,
	238,
	3,
	167,
	238,
	3,
	167,
	238,
	0,
	167,
	238,
	0,
	167,
	238,
	1,
	167,
	238,
	1,
	167,
	238,
	2,
	167,
	238,
	2,
	167,
	238,
	3,
	167,
	238,
	3,
	167,
	238,
	3,
	167,
	238,
	3,
	167,
	238,
	1,
	167,
	238,
	1,
	167,
	238,
	1,
	167,
	238,
	1,
	0
};

Compact sc66_rock3 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	198,	// xcood
	152,	// ycood
	102*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_ROCK3_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

Compact sc66_lo_beam = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	203,	// xcood
	196,	// ycood
	22*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_LO_BEAM_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc66_stones_anim[] = {
	103*64,
	199,
	144,
	0,
	199,
	144,
	0,
	199,
	144,
	0,
	199,
	144,
	0,
	187,
	144,
	1,
	187,
	152,
	2,
	187,
	165,
	3,
	187,
	187,
	4,
	188,
	217,
	5,
	188,
	224,
	6,
	0
};

uint16 walter_conv[] = {
	129*64,
	129*64,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	1,
	249,
	214,
	1,
	249,
	214,
	2,
	249,
	214,
	2,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	2,
	249,
	214,
	3,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	3,
	249,
	214,
	0,
	249,
	214,
	4,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	4,
	249,
	214,
	4,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	5,
	249,
	214,
	0,
	249,
	214,
	2,
	249,
	214,
	2,
	249,
	214,
	3,
	249,
	214,
	3,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	4,
	249,
	214,
	4,
	249,
	214,
	0,
	249,
	214,
	5,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	5,
	249,
	214,
	0,
	249,
	214,
	2,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	5,
	249,
	214,
	5,
	249,
	214,
	0,
	249,
	214,
	3,
	249,
	214,
	4,
	249,
	214,
	4,
	249,
	214,
	5,
	249,
	214,
	4,
	249,
	214,
	2,
	249,
	214,
	2,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	1,
	249,
	214,
	1,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	3,
	249,
	214,
	3,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	0,
	249,
	214,
	0,
	0
};

uint16 sc66_logic_list[] = {
	ID_FOSTER,
	ID_SC66_HI_BEAM,
	ID_SC66_LO_BEAM,
	ID_SC66_ROCK1,
	ID_SC66_ROCK2,
	ID_SC66_ROCK3,
	ID_SC66_STONES,
	ID_SC66_DOOR,
	ID_SC66_HOLE,
	0XFFFF,
	ID_STD_MENU_LOGIC
};

Compact sc66_stones = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	199,	// xcood
	144,	// ycood
	103*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_STONES_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

Compact sc66_rock1 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	175,	// xcood
	139,	// ycood
	100*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_ROCK1_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc81_ken_talk1[] = {
	191*64,
	191*64,
	259,
	197,
	0,
	259,
	197,
	1,
	259,
	197,
	2,
	259,
	197,
	2,
	259,
	197,
	3,
	259,
	197,
	3,
	259,
	197,
	2,
	259,
	197,
	2,
	259,
	197,
	3,
	259,
	197,
	3,
	259,
	197,
	3,
	259,
	197,
	3,
	259,
	197,
	4,
	259,
	197,
	4,
	259,
	197,
	5,
	259,
	197,
	5,
	259,
	197,
	2,
	259,
	197,
	2,
	259,
	197,
	6,
	259,
	197,
	6,
	259,
	197,
	7,
	259,
	197,
	2,
	259,
	197,
	8,
	259,
	197,
	8,
	259,
	197,
	3,
	259,
	197,
	1,
	259,
	197,
	9,
	259,
	197,
	9,
	259,
	197,
	10,
	259,
	197,
	10,
	259,
	197,
	9,
	259,
	197,
	11,
	259,
	197,
	12,
	259,
	197,
	12,
	259,
	197,
	13,
	259,
	197,
	13,
	259,
	197,
	14,
	259,
	197,
	14,
	259,
	197,
	0,
	259,
	197,
	0,
	259,
	197,
	15,
	259,
	197,
	15,
	259,
	197,
	11,
	259,
	197,
	11,
	259,
	197,
	13,
	259,
	197,
	13,
	259,
	197,
	14,
	259,
	197,
	14,
	259,
	197,
	0,
	259,
	197,
	0,
	259,
	197,
	15,
	259,
	197,
	15,
	259,
	197,
	11,
	259,
	197,
	11,
	259,
	197,
	16,
	259,
	197,
	16,
	259,
	197,
	13,
	259,
	197,
	13,
	259,
	197,
	0,
	259,
	197,
	0,
	259,
	197,
	11,
	259,
	197,
	11,
	259,
	197,
	16,
	259,
	197,
	16,
	0
};

Compact sc66_rock2 = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	185,	// xcood
	149,	// ycood
	101*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_ROCK2_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc66_hi_beam_an2[] = {
	99*64,
	198,
	156,
	0,
	183,
	185,
	1,
	183,
	217,
	2,
	183,
	208,
	3,
	0
};

uint16 stuck_talk[] = {
	102*64,
	102*64,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	3,
	361,
	224,
	3,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	3,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	3,
	361,
	224,
	3,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	3,
	361,
	224,
	3,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	3,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	3,
	361,
	224,
	3,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	3,
	361,
	224,
	3,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	0,
	361,
	224,
	0,
	361,
	224,
	3,
	361,
	224,
	2,
	361,
	224,
	1,
	361,
	224,
	1,
	361,
	224,
	2,
	361,
	224,
	2,
	361,
	224,
	3,
	361,
	224,
	3,
	0
};

uint16 sc66_chip_list[] = {
	IT_SC66_FOS_WALK_IN+DISK_5,
	IT_SC66_FOS_CRUSHED+DISK_5,
	IT_SC66_DOOR+DISK_5,
	IT_SC66_HI_BEAM_AN1+DISK_5,
	IT_SC66_HI_BEAM_AN2+DISK_5,
	IT_SC66_LO_BEAM_ANM+DISK_5,
	IT_SC66_ROCK1+DISK_5,
	IT_SC66_ROCK2+DISK_5,
	IT_SC66_ROCK3+DISK_5,
	IT_SC66_STONES+DISK_5,
	106+DISK_5,
	107+DISK_5,
	0
};

uint16 medi_talk_up[] = {
	0+180*64,
	0+32*64,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	2,
	0
};

uint16 sc82_ken_sat_tlk[] = {
	215*64,
	215*64,
	262,
	209,
	0,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	0,
	262,
	209,
	0,
	262,
	209,
	3,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	0,
	262,
	209,
	0,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	0,
	262,
	209,
	0,
	262,
	209,
	3,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	0,
	262,
	209,
	0,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	0,
	262,
	209,
	0,
	262,
	209,
	3,
	262,
	209,
	2,
	262,
	209,
	1,
	262,
	209,
	1,
	262,
	209,
	2,
	262,
	209,
	2,
	262,
	209,
	3,
	262,
	209,
	3,
	262,
	209,
	0,
	0
};

uint16 sc81_ken_talk2[] = {
	193*64,
	193*64,
	221,
	240,
	0,
	221,
	240,
	1,
	221,
	240,
	1,
	221,
	240,
	0,
	221,
	240,
	0,
	221,
	240,
	2,
	221,
	240,
	2,
	221,
	240,
	3,
	221,
	240,
	1,
	221,
	240,
	0,
	221,
	240,
	0,
	221,
	240,
	3,
	221,
	240,
	3,
	221,
	240,
	2,
	221,
	240,
	2,
	221,
	240,
	1,
	221,
	240,
	1,
	221,
	240,
	3,
	221,
	240,
	3,
	221,
	240,
	2,
	221,
	240,
	1,
	221,
	240,
	0,
	221,
	240,
	0,
	221,
	240,
	1,
	221,
	240,
	1,
	221,
	240,
	0,
	221,
	240,
	0,
	221,
	240,
	2,
	221,
	240,
	2,
	221,
	240,
	3,
	221,
	240,
	1,
	221,
	240,
	0,
	221,
	240,
	0,
	221,
	240,
	3,
	221,
	240,
	3,
	221,
	240,
	2,
	221,
	240,
	2,
	221,
	240,
	1,
	221,
	240,
	1,
	221,
	240,
	3,
	221,
	240,
	3,
	221,
	240,
	2,
	221,
	240,
	1,
	221,
	240,
	0,
	0
};

uint16 android_babble[] = {
	72*64,
	67*64,
	271,
	204,
	0,
	271,
	204,
	0,
	271,
	204,
	1,
	271,
	204,
	1,
	271,
	204,
	2,
	271,
	204,
	2,
	271,
	204,
	1,
	271,
	204,
	1,
	271,
	204,
	2,
	271,
	204,
	2,
	271,
	204,
	1,
	271,
	204,
	1,
	271,
	204,
	0,
	271,
	204,
	0,
	271,
	204,
	1,
	271,
	204,
	1,
	271,
	204,
	0,
	271,
	204,
	0,
	271,
	204,
	2,
	271,
	204,
	2,
	271,
	204,
	0,
	271,
	204,
	0,
	271,
	204,
	1,
	271,
	204,
	1,
	0
};

uint16 sc66_rock2_anim[] = {
	101*64,
	185,
	149,
	0,
	185,
	149,
	0,
	185,
	149,
	0,
	181,
	149,
	1,
	181,
	169,
	2,
	181,
	204,
	2,
	171,
	188,
	3,
	164,
	184,
	4,
	154,
	187,
	5,
	0
};

uint16 sc82_jobs_talk[] = {
	211*64,
	211*64,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	0,
	312,
	200,
	0,
	0
};

uint16 ken_talk_left[] = {
	71*64,
	42+61*64,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	0
};

uint16 sc75_freeze_tlk[] = {
	159*64,
	159*64,
	181,
	240,
	0,
	181,
	240,
	0,
	181,
	240,
	1,
	181,
	240,
	1,
	181,
	240,
	2,
	181,
	240,
	2,
	181,
	240,
	0,
	181,
	240,
	0,
	181,
	240,
	3,
	181,
	240,
	3,
	181,
	240,
	0,
	181,
	240,
	0,
	181,
	240,
	1,
	181,
	240,
	1,
	181,
	240,
	2,
	181,
	240,
	2,
	181,
	240,
	3,
	181,
	240,
	3,
	181,
	240,
	3,
	181,
	240,
	3,
	181,
	240,
	1,
	181,
	240,
	1,
	181,
	240,
	1,
	181,
	240,
	1,
	0
};

uint16 fost_pipe_talk[] = {
	105*64,
	105*64,
	311,
	164,
	0,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	3,
	311,
	164,
	3,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	4,
	311,
	164,
	4,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	4,
	311,
	164,
	4,
	311,
	164,
	3,
	311,
	164,
	3,
	311,
	164,
	4,
	311,
	164,
	4,
	311,
	164,
	0,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	3,
	311,
	164,
	3,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	2,
	311,
	164,
	2,
	311,
	164,
	4,
	311,
	164,
	4,
	311,
	164,
	1,
	311,
	164,
	1,
	311,
	164,
	4,
	311,
	164,
	4,
	311,
	164,
	3,
	311,
	164,
	3,
	311,
	164,
	4,
	311,
	164,
	4,
	0
};

uint16 ken_talk_up[] = {
	71*64,
	44+61*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	0
};

uint16 sc66_mouse_list[] = {
	ID_SC66_HOLE,
	0XFFFF,
	ID_TEXT_MOUSE
};

Compact sc66_hi_beam = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_BACKGROUND+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	205,	// xcood
	144,	// ycood
	98*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_HI_BEAM_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 gall_talk_up[] = {
	91*64,
	36+90*64,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	0
};

uint16 walter_talk_up[] = {
	130*64,
	36+159*64,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	1,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	1,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	1,
	341,
	214,
	1,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	0,
	341,
	214,
	0,
	341,
	214,
	2,
	341,
	214,
	2,
	341,
	214,
	1,
	0
};

uint16 medi_talk_right[] = {
	180*64,
	24+32*64,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	15,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	15,
	0
};

uint16 sc66_rock3_anim[] = {
	102*64,
	198,
	152,
	0,
	198,
	152,
	0,
	198,
	152,
	0,
	198,
	152,
	0,
	198,
	152,
	0,
	194,
	152,
	1,
	194,
	172,
	2,
	194,
	207,
	2,
	202,
	193,
	3,
	209,
	192,
	4,
	219,
	194,
	5,
	226,
	207,
	6,
	225,
	237,
	7,
	232,
	237,
	8,
	237,
	238,
	9,
	242,
	246,
	10,
	247,
	249,
	11,
	250,
	251,
	12,
	0
};

uint16 gall_talk_left[] = {
	91*64,
	34+90*64,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	0,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	1,
	1,
	3,
	0
};

uint16 medi_talk_down[] = {
	180*64,
	8+32*64,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	7,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	7,
	0
};

uint16 sc66_lo_beam_anm[] = {
	22*64,
	203,
	196,
	0,
	203,
	196,
	1,
	0
};

uint16 sc81_dad_tlk[] = {
	173*64,
	173*64,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	4,
	264,
	212,
	4,
	0
};

uint16 reset_66[] = {
	C_SCREEN,
	66,
	65535
};

uint16 sc66_fos_crushed[] = {
	104*64,
	177,
	170,
	0,
	175,
	171,
	1,
	168,
	189,
	2,
	0
};

uint16 fost_conv_left[] = {
	133*64,
	133*64,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	0,
	290,
	194,
	0,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	3,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	2,
	290,
	194,
	1,
	290,
	194,
	1,
	290,
	194,
	3,
	290,
	194,
	3,
	0
};

uint32 *sec5_compacts = (uint32*)data_5;

uint16 sc81_fos_sat_tlk[] = {
	205*64,
	205*64,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	4,
	264,
	212,
	4,
	264,
	212,
	1,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	1,
	0
};

uint16 walter_talk_dwn[] = {
	131*64,
	32+159*64,
	297,
	214,
	0,
	297,
	214,
	0,
	297,
	214,
	1,
	297,
	214,
	2,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	2,
	297,
	214,
	3,
	297,
	214,
	3,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	0,
	297,
	214,
	3,
	297,
	214,
	3,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	1,
	297,
	214,
	1,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	2,
	297,
	214,
	1,
	297,
	214,
	0,
	297,
	214,
	0,
	297,
	214,
	1,
	297,
	214,
	2,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	2,
	297,
	214,
	3,
	297,
	214,
	3,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	0,
	297,
	214,
	3,
	297,
	214,
	3,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	1,
	297,
	214,
	1,
	297,
	214,
	2,
	297,
	214,
	0,
	297,
	214,
	2,
	297,
	214,
	1,
	0
};

uint16 sc66_fos_walk_in[] = {
	21*64,
	161,
	153,
	0,
	161,
	154,
	1,
	161,
	154,
	2,
	162,
	154,
	3,
	162,
	154,
	4,
	162,
	154,
	5,
	162,
	154,
	6,
	164,
	154,
	7,
	165,
	155,
	8,
	166,
	156,
	9,
	167,
	156,
	10,
	167,
	156,
	11,
	168,
	158,
	12,
	170,
	160,
	13,
	170,
	161,
	14,
	171,
	162,
	15,
	172,
	162,
	16,
	173,
	162,
	17,
	174,
	165,
	18,
	178,
	169,
	19,
	179,
	169,
	20,
	178,
	169,
	21,
	179,
	169,
	22,
	179,
	169,
	23,
	178,
	169,
	24,
	177,
	170,
	25,
	177,
	170,
	25,
	177,
	170,
	25,
	177,
	170,
	26,
	0
};

uint16 medi_talk_left[] = {
	180*64,
	16+32*64,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	10,
	1,
	1,
	11,
	0
};

uint16 ken_talk_down[] = {
	71*64,
	40+61*64,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	5,
	0
};

uint16 sc81_dad_tlk2[] = {
	178*64,
	178*64,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	1,
	278,
	256,
	1,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	3,
	278,
	256,
	3,
	278,
	256,
	4,
	278,
	256,
	5,
	278,
	256,
	6,
	278,
	256,
	7,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	7,
	278,
	256,
	7,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	8,
	278,
	256,
	8,
	278,
	256,
	7,
	278,
	256,
	7,
	278,
	256,
	1,
	278,
	256,
	1,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	8,
	278,
	256,
	8,
	278,
	256,
	7,
	278,
	256,
	3,
	278,
	256,
	3,
	278,
	256,
	1,
	278,
	256,
	9,
	278,
	256,
	10,
	278,
	256,
	11,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	8,
	278,
	256,
	8,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	8,
	278,
	256,
	8,
	278,
	256,
	7,
	278,
	256,
	7,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	3,
	278,
	256,
	3,
	278,
	256,
	1,
	278,
	256,
	1,
	278,
	256,
	2,
	278,
	256,
	2,
	278,
	256,
	0,
	278,
	256,
	0,
	278,
	256,
	1,
	0
};

uint16 ken_talk_right[] = {
	71*64,
	46+61*64,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	14,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	13,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	12,
	0
};

uint16 walter_talk_lft[] = {
	132*64,
	34+159*64,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	2,
	380,
	214,
	0,
	380,
	214,
	3,
	380,
	214,
	3,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	2,
	380,
	214,
	3,
	380,
	214,
	2,
	380,
	214,
	3,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	2,
	380,
	214,
	0,
	380,
	214,
	3,
	380,
	214,
	3,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	2,
	380,
	214,
	3,
	380,
	214,
	2,
	380,
	214,
	3,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	380,
	214,
	0,
	380,
	214,
	1,
	380,
	214,
	1,
	0
};

uint16 sc81_ken_sat_tlk[] = {
	198*64,
	198*64,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	3,
	264,
	212,
	2,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	0,
	264,
	212,
	0,
	264,
	212,
	3,
	264,
	212,
	2,
	264,
	212,
	1,
	264,
	212,
	1,
	264,
	212,
	2,
	264,
	212,
	2,
	264,
	212,
	3,
	264,
	212,
	3,
	264,
	212,
	0,
	0
};

uint16 sc82_jobs_talk2[] = {
	212*64,
	212*64,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	4,
	312,
	200,
	4,
	312,
	200,
	5,
	312,
	200,
	5,
	312,
	200,
	6,
	312,
	200,
	6,
	312,
	200,
	7,
	312,
	200,
	7,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	8,
	312,
	200,
	8,
	312,
	200,
	9,
	312,
	200,
	9,
	312,
	200,
	10,
	312,
	200,
	10,
	312,
	200,
	9,
	312,
	200,
	9,
	312,
	200,
	8,
	312,
	200,
	8,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	0,
	312,
	200,
	0,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	1,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	2,
	312,
	200,
	2,
	312,
	200,
	3,
	312,
	200,
	3,
	312,
	200,
	0,
	312,
	200,
	0,
	0
};

Compact sc66_hole = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	385,	// xcood
	282,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	MEGA_CLICK,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	400-385,	// mouseSize_x
	322-282,	// mouseSize_y
	SC66_HOLE_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_TIMER_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 sc66_rock1_anim[] = {
	100*64,
	175,
	139,
	0,
	175,
	150,
	1,
	174,
	173,
	2,
	174,
	204,
	3,
	175,
	205,
	4,
	177,
	206,
	5,
	177,
	206,
	6,
	0
};

uint16 sc66_fast_list[] = {
	135+DISK_5,
	IT_SC66_LAYER_0+DISK_5,
	0
};

uint16 sc66_palette[] = {
	0,
	10752,
	6433,
	6436,
	7697,
	2833,
	2323,
	7,
	0,
	8240,
	11026,
	2585,
	5157,
	8202,
	14,
	2330,
	5120,
	35,
	6154,
	10752,
	10794,
	7453,
	11293,
	2056,
	2579,
	2560,
	0,
	12593,
	6193,
	780,
	1809,
	7168,
	10,
	3872,
	9217,
	1042,
	4124,
	6151,
	6,
	5150,
	8969,
	2838,
	780,
	11520,
	2331,
	1293,
	4864,
	2,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	14392,
	14336,
	56,
	0,
	10752,
	6433,
	9777,
	10781,
	6433,
	6436,
	7697,
	2833,
	2323,
	7,
	0,
	0,
	13312,
	4898,
	8240,
	11026,
	2585,
	5157,
	8202,
	14,
	2330,
	11264,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	14084,
	10798,
	10802,
	10532,
	6178,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	14399,
	56,
	14392,
	14336,
	56,
	14392,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

Compact sc66_door = {
	L_SCRIPT,	// logic
	ST_LOGIC+ST_RECREATE,	// status
	0,	// sync
	66,	// screen
	0,	// place
	0,	// getToTable
	161,	// xcood
	148,	// ycood
	105*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC66_DOOR_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

void *data_5[] = {
	0,
	sc66_fast_list,
	sc66_chip_list,
	sc66_logic_list,
	sc66_mouse_list,
	sc66_palette,
	reset_66,
	&sc66_hole,
	sc67_fast_list,
	sc67_chip_list,
	sc67_logic_list,
	sc67_mouse_list,
	sc67_palette,
	&sc67_pulse1,
	&sc67_pulse2,
	&sc67_pulse3,
	&sc67_pulse4,
	sc67_pulse1_anim,
	sc67_pulse2_anim,
	sc67_pulse3_anim,
	sc67_pulse4_anim,
	&sc67_floor,
	grid67,
	&sc67_brickwork,
	&sc67_rock,
	sc67_rock_anim,
	&sc67_door,
	&sc67_clot,
	sc67_door_open,
	sc67_door_close,
	&sc67_vein,
	&medi,
	sc68_fast_list,
	sc68_chip_list,
	sc68_logic_list,
	sc68_mouse_list,
	sc68_palette,
	reset_67_68,
	&sc68_door,
	&sc68_floor,
	grid68,
	sc67_crawl,
	sc67_dustoff,
	reset_66_67,
	sc67_getbrick,
	sc67_plast_fall,
	&sc67_plaster,
	&sc67_brick,
	sc67_brick_fall,
	reset_68_67,
	&sc68_grill,
	&sc68_sensor,
	&sc68_stairs,
	sc68_door_close,
	&sc68_pulse1,
	&sc68_pulse2,
	&sc68_pulse3,
	&sc68_pulse4,
	&sc68_pulse5,
	&sc68_pulse6,
	sc68_pulse1_anim,
	sc68_pulse2_anim,
	sc68_pulse3_anim,
	sc68_pulse4_anim,
	sc68_pulse5_anim,
	sc68_pulse6_anim,
	sc72_fast_list,
	sc72_chip_list,
	sc72_logic_list,
	sc72_mouse_list,
	sc72_palette,
	&sc72_fake_floor,
	sc69_fast_list,
	sc69_chip_list,
	sc69_logic_list,
	sc69_mouse_list,
	sc69_palette,
	&sc69_floor,
	&sc68_exit,
	reset_68_69,
	&sc69_exit,
	reset_69_68,
	&sc69_grill,
	grid69,
	sc71_fast_list,
	sc71_chip_list,
	sc71_logic_list,
	sc71_mouse_list,
	sc71_palette,
	&sc71_fake_floor,
	&sc69_door,
	reset_69_71,
	&sc71_floor,
	&sc71_door69,
	reset_71_69,
	grid71,
	&sc71_monitor,
	&sc71_recharger,
	&sc71_controls,
	&sc71_door72,
	&sc72_floor,
	reset_71_72,
	reset_72_71,
	&sc72_door,
	&sc72_tank,
	&sc72_chamber1,
	&sc72_chamber2,
	&sc72_grill,
	&sc72_tap,
	sc70_fast_list,
	sc70_chip_list,
	sc70_logic_list,
	sc70_mouse_list,
	sc70_palette,
	reset_68_70,
	&sc70_floor,
	grid72,
	grid70,
	&sc70_door,
	reset_70_68,
	&sc70_iris,
	&sc70_bar,
	&sc70_control,
	&sc70_grill,
	&sc72_exit,
	sc73_fast_list,
	sc73_chip_list,
	sc73_logic_list,
	sc73_mouse_list,
	sc73_palette,
	reset_72_73,
	&sc73_floor,
	grid73,
	&sc73_exit,
	reset_73_72,
	&sc73_chamber4,
	&sc73_chamber5,
	&sc73_big_door,
	&sc73_sensor,
	&sc73_door,
	sc74_fast_list,
	sc74_chip_list,
	sc74_logic_list,
	sc74_mouse_list,
	sc74_palette,
	reset_73_74,
	&sc74_floor,
	grid74,
	&sc74_door,
	reset_74_73,
	&sc74_monitor1,
	&sc74_left_tv,
	&sc74_right_tv,
	&sc74_interface,
	&sc74_terminal,
	&sc69_pulse1,
	&sc69_pulse2,
	&sc69_pulse3,
	&sc69_pulse4,
	&sc69_pulse5,
	&sc69_pulse6,
	sc69_pulse1_anim,
	sc69_pulse2_anim,
	sc69_pulse3_anim,
	sc69_pulse4_anim,
	sc69_pulse5_anim,
	sc69_pulse6_anim,
	sc70_consol_anim,
	&sc70_pit,
	sc70_pit_anim,
	sc67_pick_brick,
	sc67_pick_plast,
	sc67_stick_in,
	sc67_pull_out,
	sc67_brick_hit,
	sc67_plast_hit,
	sc68_sensor_anim,
	sc73_sensor_anim,
	sc73_cham4_anim,
	&sc74_int_slot,
	&sc75_tongs,
	sc67_lpocket,
	sc67_rpocket,
	sc67_rub_head,
	sc75_fast_list,
	sc75_chip_list,
	sc75_logic_list,
	sc75_mouse_list,
	sc75_palette,
	reset_73_75,
	&sc75_floor,
	grid75,
	&sc75_big_door,
	reset_75_73,
	&sc71_locked_door,
	&sc71_medi_slot,
	&sc73_locked_door,
	sc67_try_stick,
	&sc67_crowbar,
	sc67_bar_fall,
	sc67_puss_leak,
	sc67_medifix,
	&sc67_mend,
	sc67_mending,
	sc68_descend,
	sc68_ascend,
	sc720_chip_list,
	sc710_chip_list,
	sc76_fast_list,
	sc76_chip_list,
	sc76_logic_list,
	sc76_mouse_list,
	sc76_palette,
	reset_75_76,
	&sc76_floor,
	grid76,
	&sc75_door,
	&sc76_door75,
	reset_76_75,
	&sc75_nitro_tank,
	&sc75_live_tank,
	sc75_crash_anim,
	sc74_usecard,
	&sc75_console,
	sc74_usecard2,
	&sc76_android_1,
	&sc76_android_2,
	&sc76_android_3,
	0,
	0,
	rs_tongs_timer,
	&sc76_console_1,
	&sc76_console_2,
	&sc76_console_3,
	&sc76_cabinet_1,
	&sc76_cabinet_2,
	&sc76_cabinet_3,
	sc77_fast_list,
	sc77_chip_list,
	sc77_logic_list,
	sc77_mouse_list,
	sc77_palette,
	reset_76_77,
	&sc77_floor,
	grid77,
	&sc76_door77,
	&sc77_door76,
	reset_77_76,
	&sc77_big_door,
	&sc77_tank_1,
	&sc77_tank_2,
	&sc77_hand_1,
	&sc77_hand_2,
	sc78_fast_list,
	sc78_chip_list,
	sc78_logic_list,
	sc78_mouse_list,
	sc78_palette,
	reset_77_78,
	&sc78_ledge,
	grid78,
	&sc78_big_door,
	reset_78_77,
	&sc78_exit,
	sc79_fast_list,
	sc79_chip_list,
	sc79_logic_list,
	sc79_mouse_list,
	sc79_palette,
	reset_78_79,
	&sc79_pipe,
	grid79,
	&sc79_exit,
	reset_79_78,
	&witness,
	sc73_cham5_anim,
	sc70_step_up,
	sc70_step_down,
	sc70_bar_anim,
	sc70_pull_bar,
	sc77_door_open,
	&sc72_chamber3,
	0,
	0,
	0,
	&sc72_computer,
	&sc71_light1,
	sc71_light1_anim,
	sc71_light2_anim,
	&sc71_chlite,
	sc71_chlite_anim,
	sc71_mon_anim,
	sc71_medi_charge,
	sc71_use_board,
	sc71_medi_get_up,
	&sc71_panel2,
	sc71_panel_anim,
	sc71_panel2_anim,
	sc70_enter_anim,
	sc70_exit_anim,
	&sc72_cham1_light,
	sc72_cham1_flash,
	&sc72_cham2_light,
	sc72_cham2_flash,
	sc68_joey_list,
	sc72_tank_anim,
	sc72_comp_flash,
	&sc72_computer2,
	sc72_comp2_flash,
	sc72_cham1_anim,
	sc72_cham2_anim,
	sc72_cham3_anim,
	&sc72_rot_light,
	sc72_rotating,
	sc72_walter_kill,
	sc72_foster_die,
	sc72_joey_tap,
	sc72_drip_anim,
	&sc72_spill,
	sc72_spill_anim,
	sc72_walter_die,
	sc74_mon1_anim,
	&sc74_monitor2,
	sc74_mon2_anim,
	&sc74_monitor3,
	sc74_mon3_anim,
	&sc74_monitor4,
	sc74_mon4_anim,
	sc74_ltv_anim,
	sc74_rtv_anim,
	&sc74_lights,
	sc74_lights_anim,
	&gallagher,
	sc69_joey_list,
	sc71_joey_list,
	sc72_joey_list,
	sc73_joey_list,
	&sc73_chamber3,
	sc73_cham3_anim,
	&sc73_cham4_light,
	sc73_cham4_flash,
	&sc73_cham5_light,
	sc73_cham5_flash,
	&sc74_pod,
	sc74_pod_down,
	sc74_pod_up,
	sc74_fost_sit,
	sc74_get_up,
	sc75_nitro_anim,
	sc75_mon_anim,
	&sc75_light1,
	sc75_light1_anim,
	&sc75_light2,
	sc75_light2_anim,
	&sc76_light1,
	sc76_light1_anim,
	&sc76_light2,
	sc76_light2_anim,
	&sc76_light3,
	sc76_light3_anim,
	&sc76_light4,
	sc76_light4_anim,
	&sc76_light5,
	sc76_light5_anim,
	&sc76_light6,
	sc76_light6_anim,
	sc73_joey_lunge,
	sc73_joey_fight1,
	sc73_gall_fight1,
	sc73_joey_fight2,
	sc73_gall_fight2,
	&sc73_bits,
	sc73_bits_anim,
	&sc73_bits2,
	sc73_bits2_anim,
	&sc73_spray,
	sc73_spray_anim,
	sc75_get_tongs,
	sc75_usecard,
	sc73_get_board,
	sc73_search,
	sc75_rpocket,
	sc74_rpocket,
	sc75_get_tiss,
	sc75_freeze_it,
	sc75_freeze_it2,
	sc75_freeze_ded,
	sc75_freeze_ded2,
	rs_tongs_empty,
	rs_tongs_live,
	rs_tongs_frozen,
	rs_tongs_dead,
	sc75_tank_anim,
	&sc79_support,
	&sc78_support,
	sc75_hand_tank,
	sc80_fast_list,
	sc80_chip_list,
	sc80_logic_list,
	sc80_mouse_list,
	sc80_palette,
	sc78_jump_down,
	reset_79_80,
	sc78_climb_up,
	&sc80_spout,
	&sc80_orifice,
	&sc80_exit,
	&sc79_rope,
	&sc80_rope,
	reset_80_79,
	sc76_cab1_open,
	sc76_cab1_close,
	sc76_cab2_open,
	sc76_cab2_close,
	sc76_cab3_open,
	sc76_cab3_close,
	&sc76_board_1,
	&sc76_board_2,
	&sc76_board_3,
	sc76_open_cab,
	sc76_shut_cab,
	sc76_low_get,
	&sc76_light7,
	sc76_light7_anim,
	&sc76_light8,
	sc76_light8_anim,
	&sc76_light9,
	sc76_light9_anim,
	sc76_hatch_3,
	sc76_hatch_1,
	sc76_hatch_2,
	&ken,
	sc75_joey_list,
	sc76_joey_list,
	sc77_joey_list,
	&sc78_pipe,
	sc76_punch,
	sc76_fostfall,
	sc77_fpushl_1,
	sc77_fpushl_2,
	sc77_fpushr_1,
	sc77_fpushr_2,
	sc77_kpushr_1,
	sc77_kpushr_2,
	sc77_stretch,
	&sc80_goo,
	sc80_goo_anim,
	&sc80_bubble1,
	sc80_bub1_anim,
	&sc80_bubble2,
	&sc80_bubble3,
	&sc80_bubble4,
	&sc80_bubble5,
	&sc80_bubble6,
	&sc80_bubble7,
	&sc80_bubble8,
	&sc80_bubble9,
	&sc80_bubble10,
	&sc80_bubble11,
	&sc80_bubble12,
	&sc79_ladder,
	sc79_crouch_down,
	sc79_crouch_up,
	sc79_climb_down,
	sc79_climb_up,
	sc80_climb_down,
	sc80_climb_up,
	sc80_clamber,
	sc80_get_rope,
	sc80_swing,
	&sc80_ladder,
	sc79_tie_rope,
	sc79_toss_rope,
	sc79_rope_anim,
	sc80_exit_open,
	&sc79_knot,
	sc80_drop,
	&sc80_sample,
	sc80_sample_fall,
	sc801_palette,
	sc802_palette,
	sc803_palette,
	sc804_palette,
	sc791_palette,
	sc781_palette,
	sc80_pipe_shrug,
	&sc66_hi_beam,
	sc66_hi_beam_an1,
	sc66_hi_beam_an2,
	&sc66_lo_beam,
	sc66_lo_beam_anm,
	&sc66_rock1,
	sc66_rock1_anim,
	&sc66_rock2,
	sc66_rock2_anim,
	&sc66_rock3,
	sc66_rock3_anim,
	&sc66_door,
	sc66_door_close,
	&sc66_stones,
	sc66_stones_anim,
	sc66_fos_crushed,
	sc66_fos_walk_in,
	walter_talk_up,
	walter_talk_dwn,
	walter_talk_lft,
	walter_conv,
	medi_talk_up,
	medi_talk_down,
	medi_talk_left,
	medi_talk_right,
	fost_conv_left,
	gall_talk_up,
	gall_talk_left,
	sc75_freeze_tlk,
	sc75_dead_tlk,
	ken_talk_up,
	ken_talk_down,
	ken_talk_left,
	ken_talk_right,
	android_babble,
	stuck_talk,
	fost_pipe_talk,
	sc81_fast_list,
	sc81_chip_list,
	sc81_logic_list,
	sc81_mouse_list,
	sc81_palette,
	reset_80_81,
	0,
	grid81,
	&sc81_door,
	&sc81_chair,
	&sc81_helmet,
	&sc81_father,
	&sc81_father_sat,
	&sc81_foster_sat,
	&sc81_ken_sat,
	sc81_dad_tlk,
	sc81_dad_tlk2,
	sc81_dad_helm_up,
	sc81_dad_breath1,
	sc81_dad_breath2,
	sc81_dad_fall1,
	sc81_dad_fall2,
	&sc81_tent1,
	&sc81_tent2,
	&sc81_tent3,
	&sc81_tent4,
	&sc81_tent5,
	&sc81_tent6,
	sc81_tentwig1,
	sc81_tentwig2,
	sc81_tentwig3,
	sc81_tentwig4,
	sc81_tentwig5,
	sc81_tentwig6,
	&sc81_big_tent1,
	&sc81_big_tent2,
	&sc81_big_tent3,
	sc81_tentdrop1,
	sc81_tentdrop2,
	sc81_tentdrop3,
	reset_ken_81,
	sc81_ken_jump_in,
	sc81_ken_talk1,
	sc81_ken_walk1,
	sc81_ken_talk2,
	sc81_ken_walk2,
	sc81_ken_sit,
	0,
	sc81_ken_helm_dn,
	sc81_ken_sat_tlk,
	sc81_foster_sit,
	0,
	sc81_fos_helm_dn,
	sc81_fos_squirm,
	sc81_father_die,
	sc81_door_close,
	sc81_fos_sat_tlk,
	sc82_fast_list,
	sc82_chip_list,
	sc82_logic_list,
	sc82_mouse_list,
	sc82_palette,
	reset_linc_74,
	reset_foster_82,
	reset_ken_82,
	grid82,
	&sc82_jobsworth,
	sc82_push_button,
	sc82_jobs_turn,
	sc82_jobs_talk,
	sc82_jobs_talk2,
	sc82_jobs_take,
	sc82_foster_give,
	sc82_ken_sat_tlk,
	sc82_jobs_return,
	0,
	0,
	0,
	0,
	0,
	sc74_slot_flash,
	sc83_palette,
	sc83_draw_list,
	reset_foster_spec,
	reset_dad_spec
};

} // namespace SkyCompact

} // namespace Sky

#endif
