/*
    Copyright (C) 2003-2006 Teus Benschop.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef INCLUDED_UTILITIES_H
#define INCLUDED_UTILITIES_H


#include "libraries.h"
#include <glib.h>


ustring trim (const ustring & s);
ustring number_in_string (const ustring & str);
ustring upperCase (const ustring & s);
ustring lowerCase (const ustring & s);
ustring remove_spaces (const ustring & s);
unsigned int convert_to_int (const ustring & str);
ustring convert_to_string (int i);
ustring convert_to_string (unsigned int &i);
ustring convert_to_string (bool b);
ustring convert_to_string (double d);
bool convert_to_bool (const ustring & s);
double convert_to_double (const ustring & s);
bool string_in_file (const ustring & filename, const ustring & line);
ustring gw_build_filename (const ustring& part1, const ustring& part2);
ustring gw_build_filename (const ustring& part1, const ustring& part2, const ustring& part3);
ustring gw_build_filename (const ustring& part1, const ustring& part2, const ustring& part3, const ustring& part4);
ustring usfm_extract_marker (ustring & line);
ustring usfm_extract_marker_within_line (ustring & line);
vector<ustring> usfm_split_on_main_markers (const ustring& line);
vector<ustring> usfm_get_all_markers (const ustring& line);
ustring id_to_biblebook_english (const ustring & id);
void xml_handle_entities (ustring& line, vector <size_t>& positions);
ustring xml_text_embed_in_tags (int level, const ustring& tag, const ustring& text);
ustring xml_tag (int level, const ustring tag, bool closing);
void output_xml_message (const ustring& book, const ustring& chapter, const ustring& verse, const ustring& message);
void output_xml_message (const ustring& book, int chapter, const ustring& verse, const ustring& message);
void quick_sort (vector<unsigned int>& one, vector<ustring>& two, unsigned int beg, unsigned int end);
void quick_sort (vector<ustring>& one, vector<unsigned int>& two, unsigned int beg, unsigned int end);


class ReadDirectories
{
public:
  ReadDirectories (const ustring & path, const ustring & prefix, const ustring & suffix);
  ~ReadDirectories ();
  vector <ustring> directories;
private:
};

class ReadFiles
{
public:
  ReadFiles (const ustring & path, const ustring & prefix, const ustring & suffix);
  ~ReadFiles ();
  vector <ustring> files;
private:
};

class ReadText
{
public:
  ReadText (const ustring & file, bool silent = false, bool trimming = true);
  ~ReadText ();
  vector < ustring > lines;
private:
};

class WriteText
{
public:
  WriteText (const ustring & file, bool append = false);
  ~WriteText ();
  ofstream out;
private:
};

class Parse
{
public:
  Parse (const ustring & line, bool remove_punctuation = true);
  ~Parse ();
  vector < ustring > words;
private:
};

class ParseLine
{
public:
  ParseLine (const ustring & text);
  ~ParseLine ();
  vector <ustring> lines;
private:
};

#endif
