////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#include <engine/ScorchedContext.h>
#include <engine/GameState.h>
#include <engine/ActionController.h>
#include <engine/ViewPoints.h>
#include <engine/ModFiles.h>
#include <coms/NetInterface.h>
#include <coms/ComsMessageHandler.h>
#include <common/OptionsTransient.h>
#include <tank/TankContainer.h>
#include <landscape/LandscapeMaps.h>
#include <weapons/AccessoryStore.h>

ScorchedContext::ScorchedContext(const char *name) : 
	serverMode(false)
{
	actionController = new ActionController();
	accessoryStore = new AccessoryStore();
	gameState = new GameState(name);
	tankContainer = new TankContainer();
	landscapeMaps = new LandscapeMaps();
	comsMessageHandler = new ComsMessageHandler();
	netInterface = (NetInterface *) 0;
	optionsGame = new OptionsGameWrapper();
	optionsTransient = new OptionsTransient(*optionsGame);
	viewPoints = new ViewPoints();
	modFiles = new ModFiles();

	viewPoints->setContext(this);
	actionController->setScorchedContext(this);
}

ScorchedContext::~ScorchedContext()
{
}
