package Scoop;
use strict;

my $DEBUG = 0;

# Function _handle_cookies
# Sets cookies to the browser.
# Gets domain, path, session from Scoop object
# Calculates time.
sub _handle_cookies {
	my $S = shift;
	my $op = $S->cgi->param('op');
	
	# Local time related vars
	my $now = time();

	# Expirey time = user pref or global, or default of 1 30-day month
	my $adj = $S->{prefs}->{cookie_expire} ||	
			  $S->{UI}->{VARS}->{cookie_expire} ||
			  2592000;	

	my $expire = $now + $adj;

	# Now we plonk our formatted string into a var for use.. 
#	my $fexpire = $S->_cookie_time($now + $adj);
#	my $pexpire = $S->_cookie_time(0);

	# Get cookie domain and path from config and vars, respectively
	my %cookie;
	$cookie{domain} = $S->CONFIG()->{cookie_host};
	$cookie{path}   = $S->{UI}->{VARS}->{rootdir} || '/';
	$cookie{name}   = $S->{CONFIG}->{site_id} . '_session';
	
	warn "  (Scoop::ApacheHandler) Cookie path is $cookie{path}\n" if ($DEBUG);

	# If the user wants to logout, set a blank cookie
	# and reset all the user data
	if ($op eq 'logout') {
		warn "  (Scoop::ApacheHandler) Logout requested. Resetting user and cookies.\n" if ($DEBUG);
		$S = $S->reset_user;

		$cookie{expire} = 0;
		$cookie{value}  = undef;
	}
	
	# If Scoop init has determined that we need to expire this session,
	# Just set a blank cookie
	if ($S->{EXPIRE_SESSION}) {
		warn "  (Scoop::ApacheHandler) Expiring session $S->{SESSION_KEY}\n" if ($DEBUG);
		$cookie{expire} = 0;
		$cookie{value}  = undef;
	}
	
	# If we don't already have a cookie, set a fresh one.  Whee.
	unless ($S->{GOT_COOKIE}) {
		warn "  (Scoop::ApacheHandler) Setting fresh cookie $S->{SESSION_KEY}\n" if ($DEBUG);
		$cookie{expire} = $expire;
		$cookie{value}  = $S->{SESSION_KEY};
	}

	# actually set the cookie
	$S->_cookie_set(\%cookie) if exists $cookie{value};

	# That's it.
	return;
}

# Note that sometimes we set another cookie. This is to phase out the old style
# cookie name (plain session) in favor of a session cookie that includes the
# site id.
#
# XXX - remove the second one after awhile (once it's all phased out).
sub _cookie_set {
	my $S = shift;
	my $cookie = shift;

	$cookie->{expire} = $S->_cookie_time($cookie->{expire});

	my $end = "$cookie->{value};expires=$cookie->{expire};path=$cookie->{path};domain=$cookie->{domain}";
	$S->apache->header_out('Set-Cookie' => "$cookie->{name}=$end");

	if ($S->{COOKIES}->{session} && !$cookie->{value}) {
		$S->apache->header_out('Set-Cookie' => "session=$end");
	}
}

sub _cookie_time {
	return &Time::CTime::strftime('%a, %d %b %Y %X GMT', gmtime($_[1]));
}

1;
