/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSCODING_H
#define SMSCODING_H

#include <charsets.h>
#include <smspdu.h>

//These value are static - DO NOT CHANGE
#define MAXSMSSIZE 160
#define MAXSMSSIZEUCS 70

/* This calls all functions that are needed to encode the userdata
 * returns NULL on parameter errors else a char* that must be
 * freed and which contains the data already as HEXSTRING!
 * outsize contains the returned string size after execution
 */
char* sms_data_gsm_encode (ucs4char_t* input, unsigned int* udl);
char* sms_data_ucs2_encode (ucs4char_t* input, unsigned int* udl);

/* This calls all functions that are needed to decode the userdata
 * returns NULL on parameter errors else a ucs4char_t* that must be freed
 * udl must be the user data length field from the PDU
 * (encoded character count for GSM, byte count else),
 * _not_ the string length of input which certainly differs
 */
ucs4char_t* sms_data_decode (enum sms_encoding encoding,
			     char* input, unsigned int udl,
			     int header_present);
ucs4char_t* sms_data_gsm_decode (char* input, unsigned int udl, int header_present);
ucs4char_t* sms_data_ucs2_decode (char* input, unsigned int udl, int header_present);
ucs4char_t* sms_data_8bit_decode (char* input, unsigned int udl, int header_present);

#endif
