/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <atcommand.h>
#include <common.h>
#include <helper.h>

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <errno.h>

void at_gen_phonebook_write (unsigned int slot,
			     const char* number,
			     unsigned int numtype,
			     const char* text)
{
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1
		       +1+str_len(number)+1
		       +1+numlen(numtype)+1
		       +1+str_len(text)+1
		       +1,
		       1);
  if (str_len(number) == 0 && str_len(text) == 0) {
    sprintf(parmlist,"%d",slot);
  } else {
    if (number == NULL) {
      sprintf(parmlist,"%d,\"\",%d,\"%s\"",
	      slot,numtype,text);
    } else if (text == NULL) {
      sprintf(parmlist,"%d,\"%s\",%d,\"\"",
	      slot,number,numtype);
    } else {
      sprintf(parmlist,"%d,\"%s\",%d,\"%s\"",
	      slot,number,numtype,text);
    }
  }
  at_command_send(AT_GEN_PB_WRITE,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_phonebook_read (unsigned int slot_low,
			    unsigned int slot_high)
{
  char* parmlist;

  parmlist = mem_alloc(numlen(slot_low)+1
		       +numlen(slot_high)+1, 1);
  sprintf(parmlist,"%d,%d",slot_low,slot_high);
  at_command_send(AT_GEN_PB_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_phonebook_select (const char* mem) {
  char* parmlist;

  if (mem == NULL) return;
  parmlist = mem_alloc(1+strlen(mem)+2, 1);
  sprintf(parmlist,"\"%s\"",mem);
  at_command_send(AT_GEN_PB_SELECT,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_delete (unsigned int slot) {
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1, 1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_GEN_SMS_DELETE,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_slot_send (unsigned int slot,
			   const char* number)
{
  char* parmlist;

  if (number == NULL) return;
  parmlist = mem_alloc(numlen(slot)
		       +2+strlen(number)+2
		       +numlen(numtype(number))
		       +1,
		       1);
  if (str_len(number) == 0) {
    sprintf(parmlist,"%d",slot);
  } else {
    sprintf(parmlist,"%d,\"%s\",%d",slot,number,numtype(number));
  }
  at_command_send(AT_GEN_SMS_SLOT_SEND,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_send (unsigned int len) {
  char* parmlist;

  parmlist = mem_alloc(numlen(len)+1,1);
  sprintf(parmlist,"%d",len);
  at_command_send(AT_GEN_SMS_SEND,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_store (unsigned int len) {
  char* parmlist;

  parmlist = mem_alloc(numlen(len)+1,1);
  sprintf(parmlist,"%d",len);
  at_command_send(AT_GEN_SMS_STORE,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_mem (const char* mem1,
		     const char* mem2,
		     const char* mem3)
{
  char* parmlist;

  if (mem1 == NULL) return;
  parmlist = mem_alloc(1+strlen(mem1)+2
		       +1+str_len(mem2)+2
		       +1+str_len(mem3)+1
		       +1,
		       1);
  if (mem2 == NULL) {
    sprintf(parmlist,"\"%s\"",mem1);
  } else if (mem3 == NULL) {
    sprintf(parmlist,"\"%s\",\"%s\"",mem1,mem2);
  } else {
    sprintf(parmlist,"\"%s\",\"%s\",\"%s\"",mem1,mem2,mem3);
  }
  at_command_send(AT_GEN_SMS_MEM,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_slot_read (unsigned int slot) {
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1,1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_GEN_SMS_SLOT_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_list_read (unsigned int list_id) {
  char* parmlist;

  parmlist = mem_alloc(numlen(list_id)+1,1);
  sprintf(parmlist,"%d",list_id);
  at_command_send(AT_GEN_SMS_LIST_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_charset (const char* charset) {
  char* parmlist;

  if (charset == NULL) return;
  parmlist = mem_alloc(1+strlen(charset)+2, 1);
  sprintf(parmlist,"\"%s\"",charset);
  at_command_send(AT_GEN_CHARSET,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_smsc (const char* number) {
  char* parmlist;

  if (number == NULL) return;
  parmlist = mem_alloc(1+strlen(number)+2
		       +numlen(numtype(number))+1,
		       1);
  sprintf(parmlist,"\"%s\",%d",number,numtype(number));
  at_command_send(AT_GEN_CHARSET,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_pin (const char* pin) {
  char* parmlist;

  if (pin == NULL) return;
  parmlist = mem_alloc(1+strlen(pin)+2,1);
  sprintf(parmlist,"\"%s\"",pin);
  at_command_send(AT_GEN_PIN,parmlist);
  mem_realloc(parmlist,0);
}
