/** @file scim_private.cpp
 *  @brief Do some library initialize work here.
 */

/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_private.cpp,v 1.1.2.1 2004/05/01 13:23:48 suzhe Exp $
 *
 */

#include "scim_private.h"

#ifdef HAVE_LOCALE_H
  #include <locale.h>
#endif

namespace scim {

class TextdomainInitializer {
public:
    TextdomainInitializer () {

#ifdef HAVE_SETLOCALE
        setlocale (LC_ALL, "");
#endif

        bindtextdomain (GETTEXT_PACKAGE, SCIM_LOCALEDIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    }
};

static TextdomainInitializer __textdomain_initializer;

} // namespace scim

/*
vi:ts=4:ai:nowrap:expandtab
*/
