/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_event.cpp,v 1.13 2003/08/01 04:04:01 suzhe Exp $
 */

#define Uses_SCIM_EVENT
#include "scim_private.h"
#include "scim.h"

namespace scim {

struct __KeyName
{
    char * name;
    int value;
};

__KeyName __scim_key_code_names [] =
{
    {"Shift_L"        ,SCIM_KEY_Shift_L},
    {"Shift_R"        ,SCIM_KEY_Shift_R},
    {"Control_L"    ,SCIM_KEY_Control_L},
    {"Control_R"    ,SCIM_KEY_Control_R},
    {"Caps_Lock"    ,SCIM_KEY_Caps_Lock},
    {"Shift_Lock"    ,SCIM_KEY_Shift_Lock},
                          
    {"Meta_L"        ,SCIM_KEY_Meta_L},
    {"Meta_R"        ,SCIM_KEY_Meta_R},
    {"Alt_L"        ,SCIM_KEY_Alt_L},
    {"Alt_R"        ,SCIM_KEY_Alt_R},
    {"Super_L"        ,SCIM_KEY_Super_L},
    {"Super_R"        ,SCIM_KEY_Super_R},
    {"Hyper_L"        ,SCIM_KEY_Hyper_L},
    {"Hyper_R"        ,SCIM_KEY_Hyper_R},

    {"BackSpace"    ,SCIM_KEY_BackSpace},
    {"Tab"            ,SCIM_KEY_Tab},
    {"Linefeed"        ,SCIM_KEY_Linefeed},
    {"Clear"        ,SCIM_KEY_Clear},
    {"Return"        ,SCIM_KEY_Return},
    {"Pause"        ,SCIM_KEY_Pause},
    {"Scroll_Lock"    ,SCIM_KEY_Scroll_Lock},
    {"Sys_Req"        ,SCIM_KEY_Sys_Req},
    {"Escape"        ,SCIM_KEY_Escape},
    {"Delete"        ,SCIM_KEY_Delete},

    {"Multi_key"        ,SCIM_KEY_Multi_key},
    {"Codeinput"        ,SCIM_KEY_Codeinput},
    {"SingleCandidate"  ,SCIM_KEY_SingleCandidate},
    {"MultipleCandidate",SCIM_KEY_MultipleCandidate},
    {"PreviousCandidate",SCIM_KEY_PreviousCandidate},
                                 
    {"Kanji"            ,SCIM_KEY_Kanji},
    {"Muhenkan"         ,SCIM_KEY_Muhenkan},
    {"Henkan_Mode"      ,SCIM_KEY_Henkan_Mode},
    {"Henkan"           ,SCIM_KEY_Henkan},
    {"Romaji"           ,SCIM_KEY_Romaji},
    {"Hiragana"         ,SCIM_KEY_Hiragana},
    {"Katakana"         ,SCIM_KEY_Katakana},
    {"Hiragana_Katakana",SCIM_KEY_Hiragana_Katakana},
    {"Zenkaku"          ,SCIM_KEY_Zenkaku},
    {"Hankaku"          ,SCIM_KEY_Hankaku},
    {"Zenkaku_Hankaku"  ,SCIM_KEY_Zenkaku_Hankaku},
    {"Touroku"          ,SCIM_KEY_Touroku},
    {"Massyo"           ,SCIM_KEY_Massyo},
    {"Kana_Lock"        ,SCIM_KEY_Kana_Lock},
    {"Kana_Shift"       ,SCIM_KEY_Kana_Shift},
    {"Eisu_Shift"       ,SCIM_KEY_Eisu_Shift},
    {"Eisu_toggle"      ,SCIM_KEY_Eisu_toggle},
    {"Kanji_Bangou"     ,SCIM_KEY_Kanji_Bangou},
    {"Zen_Koho"         ,SCIM_KEY_Zen_Koho},
    {"Mae_Koho"         ,SCIM_KEY_Mae_Koho},

    {"Home"            ,SCIM_KEY_Home},
    {"Left"            ,SCIM_KEY_Left},
    {"Up"            ,SCIM_KEY_Up},
    {"Right"        ,SCIM_KEY_Right},
    {"Down"            ,SCIM_KEY_Down},
    {"Page_Up"        ,SCIM_KEY_Page_Up},
    {"Prior"        ,SCIM_KEY_Prior},
    {"Page_Down"    ,SCIM_KEY_Page_Down},
    {"Next"            ,SCIM_KEY_Next},
    {"End"            ,SCIM_KEY_End},
    {"Begin"        ,SCIM_KEY_Begin},

    {"Select"       ,SCIM_KEY_Select},
    {"Print"        ,SCIM_KEY_Print},
    {"Execute"      ,SCIM_KEY_Execute},
    {"Insert"       ,SCIM_KEY_Insert},
    {"Undo"         ,SCIM_KEY_Undo},
    {"Redo"         ,SCIM_KEY_Redo},
    {"Menu"         ,SCIM_KEY_Menu},
    {"Find"         ,SCIM_KEY_Find},
    {"Cancel"       ,SCIM_KEY_Cancel},
    {"Help"         ,SCIM_KEY_Help},
    {"Break"        ,SCIM_KEY_Break},
    {"Mode_switch"  ,SCIM_KEY_Mode_switch},
    {"Num_Lock"     ,SCIM_KEY_Num_Lock},

    {"KP_Space"        ,SCIM_KEY_KP_Space},
    {"KP_Tab"        ,SCIM_KEY_KP_Tab},
    {"KP_Enter"        ,SCIM_KEY_KP_Enter},
    {"KP_F1"        ,SCIM_KEY_KP_F1},
    {"KP_F2"        ,SCIM_KEY_KP_F2},
    {"KP_F3"        ,SCIM_KEY_KP_F3},
    {"KP_F4"        ,SCIM_KEY_KP_F4},
    {"KP_Home"        ,SCIM_KEY_KP_Home},
    {"KP_Left"        ,SCIM_KEY_KP_Left},
    {"KP_Up"        ,SCIM_KEY_KP_Up},
    {"KP_Right"        ,SCIM_KEY_KP_Right},
    {"KP_Down"        ,SCIM_KEY_KP_Down},
    {"KP_Prior"        ,SCIM_KEY_KP_Prior},
    {"KP_Page_Up"    ,SCIM_KEY_KP_Page_Up},
    {"KP_Next"        ,SCIM_KEY_KP_Next},
    {"KP_Page_Down"    ,SCIM_KEY_KP_Page_Down},
    {"KP_End"        ,SCIM_KEY_KP_End},
    {"KP_Begin"        ,SCIM_KEY_KP_Begin},
    {"KP_Insert"    ,SCIM_KEY_KP_Insert},
    {"KP_Delete"    ,SCIM_KEY_KP_Delete},
    {"KP_Equal"        ,SCIM_KEY_KP_Equal},
    {"KP_Multiply"    ,SCIM_KEY_KP_Multiply},
    {"KP_Add"        ,SCIM_KEY_KP_Add},
    {"KP_Separator"    ,SCIM_KEY_KP_Separator},
    {"KP_Subtract"    ,SCIM_KEY_KP_Subtract},
    {"KP_Decimal"    ,SCIM_KEY_KP_Decimal},
    {"KP_Divide"    ,SCIM_KEY_KP_Divide},
                          
    {"KP_0"            ,SCIM_KEY_KP_0},
    {"KP_1"            ,SCIM_KEY_KP_1},
    {"KP_2"            ,SCIM_KEY_KP_2},
    {"KP_3"            ,SCIM_KEY_KP_3},
    {"KP_4"            ,SCIM_KEY_KP_4},
    {"KP_5"            ,SCIM_KEY_KP_5},
    {"KP_6"            ,SCIM_KEY_KP_6},
    {"KP_7"            ,SCIM_KEY_KP_7},
    {"KP_8"            ,SCIM_KEY_KP_8},
    {"KP_9"            ,SCIM_KEY_KP_9},

    {"F1"            ,SCIM_KEY_F1},
    {"F2"            ,SCIM_KEY_F2},
    {"F3"            ,SCIM_KEY_F3},
    {"F4"            ,SCIM_KEY_F4},
    {"F5"            ,SCIM_KEY_F5},
    {"F6"            ,SCIM_KEY_F6},
    {"F7"            ,SCIM_KEY_F7},
    {"F8"            ,SCIM_KEY_F8},
    {"F9"            ,SCIM_KEY_F9},
    {"F10"            ,SCIM_KEY_F10},
    {"F11"            ,SCIM_KEY_F11},
    {"F12"            ,SCIM_KEY_F12},
                          
    {"space"        ,SCIM_KEY_space},
    {"exclam"        ,SCIM_KEY_exclam},
    {"quotedbl"        ,SCIM_KEY_quotedbl},
    {"numbersign"    ,SCIM_KEY_numbersign},
    {"dollar"        ,SCIM_KEY_dollar},
    {"percent"        ,SCIM_KEY_percent},
    {"ampersand"    ,SCIM_KEY_ampersand},
    {"apostrophe"    ,SCIM_KEY_apostrophe},
    {"quoteright"    ,SCIM_KEY_quoteright},
    {"parenleft"    ,SCIM_KEY_parenleft},
    {"parenright"    ,SCIM_KEY_parenright},
    {"asterisk"        ,SCIM_KEY_asterisk},
    {"plus"            ,SCIM_KEY_plus},
    {"comma"        ,SCIM_KEY_comma},
    {"minus"        ,SCIM_KEY_minus},
    {"period"        ,SCIM_KEY_period},
    {"slash"        ,SCIM_KEY_slash},
    {"0"            ,SCIM_KEY_0},
    {"1"            ,SCIM_KEY_1},
    {"2"            ,SCIM_KEY_2},
    {"3"            ,SCIM_KEY_3},
    {"4"            ,SCIM_KEY_4},
    {"5"            ,SCIM_KEY_5},
    {"6"            ,SCIM_KEY_6},
    {"7"            ,SCIM_KEY_7},
    {"8"            ,SCIM_KEY_8},
    {"9"            ,SCIM_KEY_9},
    {"colon"        ,SCIM_KEY_colon},
    {"semicolon"    ,SCIM_KEY_semicolon},
    {"less"            ,SCIM_KEY_less},
    {"equal"        ,SCIM_KEY_equal},
    {"greater"        ,SCIM_KEY_greater},
    {"question"        ,SCIM_KEY_question},
    {"at"            ,SCIM_KEY_at},
    {"A"            ,SCIM_KEY_A},
    {"B"            ,SCIM_KEY_B},
    {"C"            ,SCIM_KEY_C},
    {"D"            ,SCIM_KEY_D},
    {"E"            ,SCIM_KEY_E},
    {"F"            ,SCIM_KEY_F},
    {"G"            ,SCIM_KEY_G},
    {"H"            ,SCIM_KEY_H},
    {"I"            ,SCIM_KEY_I},
    {"J"            ,SCIM_KEY_J},
    {"K"            ,SCIM_KEY_K},
    {"L"            ,SCIM_KEY_L},
    {"M"            ,SCIM_KEY_M},
    {"N"            ,SCIM_KEY_N},
    {"O"            ,SCIM_KEY_O},
    {"P"            ,SCIM_KEY_P},
    {"Q"            ,SCIM_KEY_Q},
    {"R"            ,SCIM_KEY_R},
    {"S"            ,SCIM_KEY_S},
    {"T"            ,SCIM_KEY_T},
    {"U"            ,SCIM_KEY_U},
    {"V"            ,SCIM_KEY_V},
    {"W"            ,SCIM_KEY_W},
    {"X"            ,SCIM_KEY_X},
    {"Y"            ,SCIM_KEY_Y},
    {"Z"            ,SCIM_KEY_Z},
    {"bracketleft"    ,SCIM_KEY_bracketleft},
    {"backslash"    ,SCIM_KEY_backslash},
    {"bracketright"    ,SCIM_KEY_bracketright},
    {"asciicircum"    ,SCIM_KEY_asciicircum},
    {"underscore"    ,SCIM_KEY_underscore},
    {"grave"        ,SCIM_KEY_grave},
    {"a"            ,SCIM_KEY_a},
    {"b"            ,SCIM_KEY_b},
    {"c"            ,SCIM_KEY_c},
    {"d"            ,SCIM_KEY_d},
    {"e"            ,SCIM_KEY_e},
    {"f"            ,SCIM_KEY_f},
    {"g"            ,SCIM_KEY_g},
    {"h"            ,SCIM_KEY_h},
    {"i"            ,SCIM_KEY_i},
    {"j"            ,SCIM_KEY_j},
    {"k"            ,SCIM_KEY_k},
    {"l"            ,SCIM_KEY_l},
    {"m"            ,SCIM_KEY_m},
    {"n"            ,SCIM_KEY_n},
    {"o"            ,SCIM_KEY_o},
    {"p"            ,SCIM_KEY_p},
    {"q"            ,SCIM_KEY_q},
    {"r"            ,SCIM_KEY_r},
    {"s"            ,SCIM_KEY_s},
    {"t"            ,SCIM_KEY_t},
    {"u"            ,SCIM_KEY_u},
    {"v"            ,SCIM_KEY_v},
    {"w"            ,SCIM_KEY_w},
    {"x"            ,SCIM_KEY_x},
    {"y"            ,SCIM_KEY_y},
    {"z"            ,SCIM_KEY_z},
    {"braceleft"    ,SCIM_KEY_braceleft},
    {"bar"            ,SCIM_KEY_bar},
    {"braceright"    ,SCIM_KEY_braceright},
    {"asciitilde"    ,SCIM_KEY_asciitilde},
    {0,0}
};

__KeyName __scim_key_mask_names [] =
{
    {"Shift",  SCIM_KEY_ShiftMask},
    {"Lock",   SCIM_KEY_LockMask},
    {"Control",SCIM_KEY_ControlMask},
    {"Alt",    SCIM_KEY_Mod1Mask},
    {"Mod2",   SCIM_KEY_Mod2Mask},
    {"Mod3",   SCIM_KEY_Mod3Mask},
    {"Mod4",   SCIM_KEY_Mod4Mask},
    {"Mod5",   SCIM_KEY_Mod5Mask},
    {"NumLock", SCIM_KEY_NumLockMask},
    {"CapsLock", SCIM_KEY_CapsLockMask},
    {"ScrollLock", SCIM_KEY_ScrollLockMask},
    {"KeyRelease", SCIM_KEY_ReleaseMask},
    {"KeyPress", 0},
    {0,0}
};

char
KeyEvent::get_ascii_code () const
{
    if (code >= SCIM_KEY_space && code <= SCIM_KEY_asciitilde)
        return (char) code;

    if (code >= SCIM_KEY_KP_0 && code <= SCIM_KEY_KP_9)
        return (char) (code - SCIM_KEY_KP_0 + SCIM_KEY_0);

    if (code == SCIM_KEY_Return)
        return 0x0d;
    if (code == SCIM_KEY_Linefeed)
        return 0x0a;
    if (code == SCIM_KEY_Tab)
        return 0x09;

    return 0;
}

bool scim_key_to_string (String &str, const KeyEvent & key)
{
    int i;

    str = String ();

    for (i=0; __scim_key_mask_names [i].name; ++i) {
        if (__scim_key_mask_names [i].value & key.mask) {
            if (str.length ())
                str += (String ("+") + String (__scim_key_mask_names [i].name));
            else
                str += String (__scim_key_mask_names [i].name);
        }
    }

    for (i=0; __scim_key_code_names [i].name; ++i) {
        if (__scim_key_code_names [i].value == key.code) {
            if (str.length ())
                str += (String ("+") + String (__scim_key_code_names [i].name));
            else
                str += String (__scim_key_code_names [i].name);
            break;
        }
    }

    return str.length () > 0;
}

bool scim_string_to_key (KeyEvent &key, const String & str)
{
    std::vector <String> list;
    bool skip;
    int i;

    scim_split_string_list (list, str, '+');

    for (std::vector <String>::iterator it=list.begin (); it!=list.end (); ++it) {
        skip = false;
        for (i=0; __scim_key_mask_names [i].name; ++i) {
            if (*it == String (__scim_key_mask_names [i].name)) {
                key.mask |= __scim_key_mask_names [i].value;
                skip = true;
                break;
            }
        }
        if (skip) continue;
        for (i=0; __scim_key_code_names [i].name; ++i) {
            if (*it == String (__scim_key_code_names [i].name)) {
                key.code = __scim_key_code_names [i].value;
                break;
            }
        }
    }

    return key.code != 0;
}

bool scim_key_list_to_string (String &str, const std::vector<KeyEvent> & keylist)
{
    std::vector<String> strlist;

    for (std::vector<KeyEvent>::const_iterator it = keylist.begin (); it != keylist.end (); ++it) {
        if (scim_key_to_string (str, *it))
            strlist.push_back (str);
    }

    str = scim_combine_string_list (strlist, ',');

    return str.length () != 0;
}

bool scim_string_to_key_list (std::vector<KeyEvent> &keylist, const String &str)
{
    std::vector <String> strlist;
    scim_split_string_list (strlist, str, ',');

    keylist.clear ();

    for (std::vector <String>::iterator it = strlist.begin (); it != strlist.end (); ++it) {
        KeyEvent key;
        if (scim_string_to_key (key, *it))
            keylist.push_back (key);
    }
    return keylist.size () > 0;
}

} // namespace scim

/*
vi:ts=4:nowrap:ai:expandtab
*/
