/**
 * @file scim_config_path.h
 * @brief This file defines some common used configuration keys.
 */

/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2004 James Su <suzhe@turbolinux.com.cn>
 * Copyright (c) 2003 James Su <suzhe@turbolinux.com.cn>
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_config_path.h,v 1.16 2004/03/06 15:48:11 suzhe Exp $
 */

#ifndef __SCIM_CONFIG_PATH_H
#define __SCIM_CONFIG_PATH_H

namespace scim {
/**
 * @addtogroup Config
 * @{
 */
#define SCIM_CONFIG_FRONTEND                      "/FrontEnd"
#define SCIM_CONFIG_FRONTEND_KEYS                 "/FrontEnd/Keys"
#define SCIM_CONFIG_FRONTEND_KEYS_TRIGGER         "/FrontEnd/Keys/Trigger"
#define SCIM_CONFIG_FRONTEND_KEYS_NEXT_SERVER     "/FrontEnd/Keys/NextServer"
#define SCIM_CONFIG_FRONTEND_KEYS_PREVIOUS_SERVER "/FrontEnd/Keys/PreviousServer"
#define SCIM_CONFIG_FRONTEND_KEYS_VALID_KEY_MASK  "/FrontEnd/Keys/ValidKeyMask"

#define SCIM_CONFIG_SUPPORTED_UNICODE_LOCALES     "/SupportedUnicodeLocales"

#define SCIM_CONFIG_DEFAULT_SERVER_FACTORY        "/DefaultServerFactory"

#define SCIM_CONFIG_DISABLED_SERVER_FACTORIES	  "/DisabledServerFactories"

/** @} */

} // namespace scim

#endif //__SCIM_CONFIG_PATH_H

