/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2003 James Su <suzhe@turbolinux.com.cn>
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_backend.cpp,v 1.14 2003/12/24 08:17:08 uid67192 Exp $
 *
 */

#define Uses_SCIM_BACKEND
#define Uses_STL_ALGORITHM
#include "scim_private.h"
#include "scim.h"

namespace scim {

BackEndBase::~BackEndBase ()
{
}

String
CommonBackEnd::get_locales () const
{
    String locale;

    std::vector <String> locale_list;
    std::vector <String> real_list;

    for (ServerFactoryPool::const_iterator it=m_factories.begin (); it!=m_factories.end (); it++) {
        if (locale.length () == 0)
            locale += (*it)->get_locales ();
        else
            locale += (String (",") + (*it)->get_locales ());
    }

    if (m_supported_unicode_locales.length ())
        locale += (String (",") + m_supported_unicode_locales);

    scim_split_string_list (locale_list, locale);

    for (std::vector <String>::iterator i = locale_list.begin (); i!= locale_list.end (); i++) {
        locale = scim_validate_locale (*i);
        if (locale.length () && std::find (real_list.begin (), real_list.end (), locale) == real_list.end ())
            real_list.push_back (locale);
    }

    return scim_combine_string_list (real_list);
}

unsigned int
CommonBackEnd::number_of_servers () const
{
    return m_factories.size ();
}

ServerFactoryPointer
CommonBackEnd::get_server_factory (unsigned int index)
{
    if (index < m_factories.size ())
        return m_factories [index];

    return ServerFactoryPointer (0);
}

bool
CommonBackEnd::add_server_factory (const ServerFactoryPointer &factory)
{
    if (!factory.null ()) {
        String uuid = factory->get_uuid ();

        if (uuid.length ()) {
            for (ServerFactoryPool::const_iterator it = m_factories.begin ();
                 it != m_factories.end (); ++ it) {
                if ((*it)->get_uuid () == uuid)
                    return false;
            }
            m_factories.push_back (factory);
            return true;
        }
    }
    return false;
}

void
CommonBackEnd::set_supported_unicode_locales (const String &locales)
{
    std::vector <String> locale_list;
    std::vector <String> real_list;

    scim_split_string_list (locale_list, locales);

    for (std::vector <String>::iterator i = locale_list.begin (); i!= locale_list.end (); ++i) {
        *i = scim_validate_locale (*i);
        if (i->length () && scim_get_locale_encoding (*i) == "UTF-8" &&
            std::find (real_list.begin (), real_list.end (), *i) == real_list.end ())
            real_list.push_back (*i);
    }

    m_supported_unicode_locales = scim_combine_string_list (real_list);
}

String
CommonBackEnd::get_supported_unicode_locales () const
{
    return m_supported_unicode_locales;
}

} // namespace scim

/*
vi:ts=4:nowrap:ai:expandtab
*/
