/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

/**
 * @file
 * @author Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 * @brief This header is used to grab the debug settings.
 */
#ifndef SCIMBRIDGEDEBUG_H_
#define SCIMBRIDGEDEBUG_H_

#include "scim-bridge.h"

/**
 * This is the type of debug level.
 */
typedef unsigned int scim_bridge_debug_level_t;

/**
 * This is the type of debug flags.
 */
typedef unsigned int scim_bridge_debug_flag_t;

/**
 * The debug flags, which means that none of the debug flags are stored.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_NONE = 0;

/**
 * The debug flags, which means that all of the debug flags are stored.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_ALL = 0xFF;

/**
 * The debug flag to debug IMContextes.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_IMCONTEXT = 1 << 0;

/**
 * The debug flag to debug messengers.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_MESSENGER = 1 << 1;

/**
 * The debug flag to debug clients.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_CLIENT = 1 << 2;

/**
 * The debug flag to debug agents.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_AGENT = 1 << 3;

/**
 * The debug flag to debug scim.
 */
static const scim_bridge_debug_flag_t SCIM_BRIDGE_DEBUG_SCIM = 1 << 4;

#ifdef __cplusplus
extern "C"
{
#endif

    /**
     * Get the debug level.
     *
     * @return The debug level.
     */
    scim_bridge_debug_level_t scim_bridge_debug_get_level ();

    /**
     * Get the debug flags.
     *
     * @return The debug flags.
     */
    scim_bridge_debug_flag_t scim_bridge_debug_get_flags ();

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEDEBUG_H_*/
