/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTPROTECTED_H_
#define SCIMBRIDGEAGENTPROTECTED_H_

#define Uses_SCIM_EVENT
#define Uses_SCIM_TRANSACTION

#include <scim.h>

#include "scim-bridge-imcontext.h"

class ScimBridgeAgentProtected
{

    public:

        virtual ~ScimBridgeAgentProtected ();

        virtual void reload_config () = 0;
        virtual void update_lookup_table_page_size (scim_bridge_imcontext_id_t imcontext_id, int page_size) = 0;
        virtual void lookup_table_page_up (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual void lookup_table_page_down (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual void trigger_property (scim_bridge_imcontext_id_t imcontext_id, const scim::String &property) = 0;
        virtual void process_helper_event (scim_bridge_imcontext_id_t imcontext_id, const scim::String &target_uuid, const scim::String &helper_uuid, const scim::Transaction &trans) = 0;
        virtual void panel_move_preedit_caret (scim_bridge_imcontext_id_t imcontext_id, int caret_pos) = 0;
        virtual void lookup_table_select_candidate (scim_bridge_imcontext_id_t imcontext_id, int cand_index) = 0;
        virtual void panel_process_key_event (scim_bridge_imcontext_id_t imcontext_id, const scim::KeyEvent &key_event) = 0;
        virtual void panel_commit (scim_bridge_imcontext_id_t imcontext_id, const scim::WideString &wstr) = 0;
        virtual void panel_forward_key_event (scim_bridge_imcontext_id_t imcontext_id, const scim::KeyEvent &key_event) = 0;
        virtual void panel_request_help (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual void panel_request_factory_menu (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual void panel_change_factory (scim_bridge_imcontext_id_t imcontext_id, const scim::String &uuid) = 0;

    protected:

        ScimBridgeAgentProtected ();

};
#endif                                            /*SCIMBRIDGEAGENTPROTECTED_H_*/
