#include "scim-bridge-keyevent.h"

int scim_bridge_keyevent_is_key_pressed (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->pressed;
}


int scim_bridge_keyevent_is_shift_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_SHIFT;
}


int scim_bridge_keyevent_is_caps_lock_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_CAPS_LOCK;
}


int scim_bridge_keyevent_is_control_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_CONTROL;
}


int scim_bridge_keyevent_is_alt_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_ALT;
}


int scim_bridge_keyevent_is_meta_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_META;
}


int scim_bridge_keyevent_is_super_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_SUPER;
}


int scim_bridge_keyevent_is_hyper_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_HYPER;
}


int scim_bridge_keyevent_is_num_lock_down (const ScimBridgeKeyEvent *keyevent)
{
    return keyevent->mod_state & SCIM_BRIDGE_MODIFIER_MASK_NUM_LOCK;
}
