#include <assert.h>
#include <malloc.h>
#include <string.h>

#include "scim-bridge-exception.h"

static const char EMPTY_MESSAGE[] = "\0";

void scim_bridge_exception_initialize (ScimBridgeException *except)
{
    memset (except, 0, sizeof (ScimBridgeException));
}


void scim_bridge_exception_finalize (ScimBridgeException *except)
{
    if (except->message != NULL) {
        free (except->message);
        except->message = NULL;
    }
}


void scim_bridge_exception_copy (ScimBridgeException *dest, const ScimBridgeException *except)
{
    scim_bridge_exception_set_message (dest, except->message);
    scim_bridge_exception_set_errno (dest, except->err_no);
}


void scim_bridge_exception_set_message (ScimBridgeException *except, const char *new_message)
{
    if (new_message != NULL) {
        const size_t str_len = strlen (new_message);
        except->message = malloc (sizeof (char) * (str_len + 1));
        strcpy (except->message, new_message);
    } else {
        free (except->message);
        except->message = NULL;
    }
}


const char *scim_bridge_exception_get_message (const ScimBridgeException *except)
{
    if (except->message) {
        return except->message;
    } else {
        return EMPTY_MESSAGE;
    }
}


void scim_bridge_exception_set_errno (ScimBridgeException *except, const int new_errno)
{
    except->err_no = new_errno;
}


int scim_bridge_exception_get_errno (const ScimBridgeException *except)
{
    return except->err_no;
}


const char *scim_bridge_exception_get_strerror (const ScimBridgeException *except)
{
    return strerror (except->err_no);
}
