#ifndef SCIMBRIDGEATTRIBUTE_H_
#define SCIMBRIDGEATTRIBUTE_H_

#include "scim-bridge.h"

enum _ScimBridgeAttributeType
{
    SCIM_BRIDGE_ATTRIBUTE_NONE,
    SCIM_BRIDGE_ATTRIBUTE_DECORATE,
    SCIM_BRIDGE_ATTRIBUTE_FOREGROUND,
    SCIM_BRIDGE_ATTRIBUTE_BACKGROUND
};

typedef enum _ScimBridgeAttributeType ScimBridgeAttributeType;

typedef unsigned int ScimBridgeAttributeValue;

typedef struct _ScimBridgeAttribute ScimBridgeAttribute;

struct _ScimBridgeAttribute
{
    unsigned int begin;
    unsigned int end;

    ScimBridgeAttributeType type;
    ScimBridgeAttributeValue value;
};

#define SCIM_BRIDGE_ATTRIBUTE_DECORATE_NONE 0x1000000
#define SCIM_BRIDGE_ATTRIBUTE_DECORATE_UNDERLINE 0x2000000
#define SCIM_BRIDGE_ATTRIBUTE_DECORATE_HIGHLIGHT 0x4000000
#define SCIM_BRIDGE_ATTRIBUTE_DECORATE_REVERSE 0x8000000

#ifdef __cplusplus
extern "C"
{
#endif

    /* Note that the each component of colors is ranged in 0~255 */
    ScimBridgeAttributeValue scim_bridge_attribute_get_color (unsigned int red, unsigned int green, unsigned int blue);
    unsigned int scim_bridge_attribute_get_red (ScimBridgeAttributeValue value);
    unsigned int scim_bridge_attribute_get_green (ScimBridgeAttributeValue value);
    unsigned int scim_bridge_attribute_get_blue (ScimBridgeAttributeValue value);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEATTRIBUTE_H_*/
