#ifndef SCIMBRIDGECLIENTMESSENGER_H_
#define SCIMBRIDGECLIENTMESSENGER_H_

#include "scim-bridge.h"
#include "scim-bridge-attribute.h"
#include "scim-bridge-imcontext-common.h"
#include "scim-bridge-exception.h"

#ifdef __cplusplus
extern "C"
{
#endif

    int scim_bridge_client_initialize_messenger (ScimBridgeException *except);
    int scim_bridge_client_finalize_messenger (ScimBridgeException *except);

    /* Remote functions */
    int scim_bridge_client_call_alloc_imcontext (ScimBridgeException *except, ScimBridgeIMContextID id, ScimBridgeIMContextID *opponent_id);
    int scim_bridge_client_call_free_imcontext (ScimBridgeException *except, ScimBridgeIMContextID opponent_id);
    int scim_bridge_client_call_reset_imcontext (ScimBridgeException *except, ScimBridgeIMContextID opponent_id);

    int scim_bridge_client_call_focus_changed (ScimBridgeException *except, ScimBridgeIMContextID opponent_id, int focus_in);
    int scim_bridge_client_call_keyevent_occured (ScimBridgeException *except, ScimBridgeIMContextID opponent_id, const ScimBridgeKeyEvent *keyevent, int *consumed);
    int scim_bridge_client_call_cursor_location_changed (ScimBridgeException *except, ScimBridgeIMContextID opponent_id, int cursor_x, int cursor_y);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENTMESSENGER_H_*/
