#ifndef SCIMBRIDGECLIENTKERNELPROTECTED_H_
#define SCIMBRIDGECLIENTKERNELPROTECTED_H_

#include "scim-bridge.h"
#include "scim-bridge-attribute.h"
#include "scim-bridge-exception.h"
#include "scim-bridge-imcontext-common.h"
#include "scim-bridge-keyevent.h"
#include "scim-bridge-string.h"

#ifdef __cplusplus
extern "C"
{
#endif

    /* Called from the mesenger */
    void scim_bridge_client_kernel_commit (ScimBridgeIMContextID id);

    void scim_bridge_client_kernel_set_preedit_string (ScimBridgeIMContextID id, ucs4_t *wstr, size_t wstr_len);
    void scim_bridge_client_kernel_set_preedit_attributes (ScimBridgeIMContextID id, ScimBridgeAttribute *attrs, size_t attr_length);
    void scim_bridge_client_kernel_set_preedit_cursor_position (ScimBridgeIMContextID id, int cursor_position);
    void scim_bridge_client_kernel_set_preedit_shown (ScimBridgeIMContextID id, int shown);
    void scim_bridge_client_kernel_update_preedit (ScimBridgeIMContextID id);

    void scim_bridge_client_kernel_forward_keyevent (ScimBridgeIMContextID id, const ScimBridgeKeyEvent *keyevent);
    void scim_bridge_client_kernel_beep (ScimBridgeIMContextID id);

    void scim_bridge_client_kernel_get_surrounding_string (ScimBridgeIMContextID id, ucs4_t *wstr, size_t max_length, size_t *fetch_length, int *cursor_position);
    void scim_bridge_client_kernel_delete_surrounding_string (ScimBridgeIMContextID id, size_t offset, size_t length, int *retval);

    void scim_bridge_client_kernel_exception_occured (ScimBridgeException *except);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENTKERNELPROTECTED_H_*/
