#ifndef SCIMBRIDGEAGENTMESSENGER_H_
#define SCIMBRIDGEAGENTMESSENGER_H_

#include "scim-bridge.h"
#include "scim-bridge-message.h"
#include "scim-bridge-agent-imcontext.h"

class ScimBridgeAgentClientPeerProtected;

class ScimBridgeAgentMessenger
{

    public:

        ScimBridgeAgentMessenger (ScimBridgeAgentClientPeerProtected &client_peer);
        ~ScimBridgeAgentMessenger ();

        bool is_thread_running ();

        void open_connection (int input_fd, int output_fd) throw (ScimBridgeAgentException);
        void close_connection ();

        void connection_closed ();

        ScimBridgeMessengerID get_id ();

        /* Calls from the client */
        void received_message_unknown (ScimBridgeMessageCode code) throw (ScimBridgeAgentException);
        void received_message_alloc_imcontext () throw (ScimBridgeAgentException);
        void received_message_free_imcontext () throw (ScimBridgeAgentException);
        void received_message_reset_imcontext () throw (ScimBridgeAgentException);
        void received_message_focus_changed () throw (ScimBridgeAgentException);
        void received_message_keyevent_occured () throw (ScimBridgeAgentException);
        void received_message_cursor_location_changed () throw (ScimBridgeAgentException);

        /* Remote function */
        void call_commit (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException);

        void call_set_preedit_string (const ScimBridgeAgentIMContext &ic, const scim::WideString &string) throw (ScimBridgeAgentException);
        void call_set_preedit_attributes (const ScimBridgeAgentIMContext &ic, const scim::AttributeList &attributes) throw (ScimBridgeAgentException);
        void call_set_preedit_cursor_position (const ScimBridgeAgentIMContext &ic, int cursor_position) throw (ScimBridgeAgentException);
        void call_set_preedit_shown (const ScimBridgeAgentIMContext &ic, bool shown) throw (ScimBridgeAgentException);
        void call_update_preedit (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException);

        void call_forward_keyevent (const ScimBridgeAgentIMContext &ic, const scim::KeyEvent &keyevent) throw (ScimBridgeAgentException);
        void call_beep (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException);

        bool call_get_surrounding_string (const ScimBridgeAgentIMContext &ic, scim::WideString &surrounding, size_t max_length, int &cursor_pos) throw (ScimBridgeAgentException);
        bool call_delete_surrounding_string (const ScimBridgeAgentIMContext &ic, size_t offset, size_t len) throw (ScimBridgeAgentException);

    private:

        bool thread_running;

        pthread_t thread;

        ScimBridgeMessengerID id;

        ScimBridgeAgentClientPeerProtected &client_peer;

        int input_fd;
        int output_fd;

};
#endif                                            /*SCIMBRIDGEAGENTMESSENGER_H_*/
