#include <map>

#include "scim-bridge-agent-keyevent-utility.h"

using std::map;
using std::pair;

typedef scim::KeyEvent ScimKeyEvent;
typedef unsigned int ScimKeyCode;
typedef unsigned int ScimKeyMask;

static map <ScimBridgeKeyCode, ScimKeyCode> bridge_to_scim_map;
static map <ScimKeyCode, ScimBridgeKeyCode> scim_to_bridge_map;

/* Helper functions */
static void map_keycode (ScimKeyCode keycode, ScimBridgeKeyCode bridge_keycode)
{
    bridge_to_scim_map.insert (pair <ScimBridgeKeyCode, ScimKeyCode> (bridge_keycode, keycode));
    scim_to_bridge_map.insert (pair <ScimKeyCode, ScimBridgeKeyCode> (keycode, bridge_keycode));
}


/* Honestly speaking, scim-bridge uses the same keycodes as scim */
static void init_trans_map ()
{
    if (bridge_to_scim_map.empty ()) {
        map_keycode (scim::SCIM_KEY_NullKey, SCIM_BRIDGE_KEY_NullKey);
        map_keycode (scim::SCIM_KEY_VoidSymbol, SCIM_BRIDGE_KEY_VoidSymbol);

        map_keycode (scim::SCIM_KEY_BackSpace, SCIM_BRIDGE_KEY_BackSpace);
        map_keycode (scim::SCIM_KEY_Tab, SCIM_BRIDGE_KEY_Tab);
        map_keycode (scim::SCIM_KEY_Linefeed, SCIM_BRIDGE_KEY_Linefeed);
        map_keycode (scim::SCIM_KEY_Clear, SCIM_BRIDGE_KEY_Clear);
        map_keycode (scim::SCIM_KEY_Return, SCIM_BRIDGE_KEY_Return);
        map_keycode (scim::SCIM_KEY_Pause, SCIM_BRIDGE_KEY_Pause);
        map_keycode (scim::SCIM_KEY_Scroll_Lock, SCIM_BRIDGE_KEY_Scroll_Lock);
        map_keycode (scim::SCIM_KEY_Sys_Req, SCIM_BRIDGE_KEY_Sys_Req);
        map_keycode (scim::SCIM_KEY_Escape, SCIM_BRIDGE_KEY_Escape);
        map_keycode (scim::SCIM_KEY_Delete, SCIM_BRIDGE_KEY_Delete);

        map_keycode (scim::SCIM_KEY_Multi_key, SCIM_BRIDGE_KEY_Multi_key);
        map_keycode (scim::SCIM_KEY_Codeinput, SCIM_BRIDGE_KEY_Codeinput);
        map_keycode (scim::SCIM_KEY_SingleCandidate, SCIM_BRIDGE_KEY_SingleCandidate);
        map_keycode (scim::SCIM_KEY_MultipleCandidate, SCIM_BRIDGE_KEY_MultipleCandidate);
        map_keycode (scim::SCIM_KEY_PreviousCandidate, SCIM_BRIDGE_KEY_PreviousCandidate);

        map_keycode (scim::SCIM_KEY_Kanji, SCIM_BRIDGE_KEY_Kanji);
        map_keycode (scim::SCIM_KEY_Muhenkan, SCIM_BRIDGE_KEY_Muhenkan);
        map_keycode (scim::SCIM_KEY_Henkan_Mode, SCIM_BRIDGE_KEY_Henkan_Mode);
        map_keycode (scim::SCIM_KEY_Henkan, SCIM_BRIDGE_KEY_Henkan);
        map_keycode (scim::SCIM_KEY_Romaji, SCIM_BRIDGE_KEY_Romaji);
        map_keycode (scim::SCIM_KEY_Hiragana, SCIM_BRIDGE_KEY_Hiragana);
        map_keycode (scim::SCIM_KEY_Katakana, SCIM_BRIDGE_KEY_Katakana);
        map_keycode (scim::SCIM_KEY_Hiragana_Katakana, SCIM_BRIDGE_KEY_Hiragana_Katakana);
        map_keycode (scim::SCIM_KEY_Zenkaku, SCIM_BRIDGE_KEY_Zenkaku);
        map_keycode (scim::SCIM_KEY_Hankaku, SCIM_BRIDGE_KEY_Hankaku);
        map_keycode (scim::SCIM_KEY_Zenkaku_Hankaku, SCIM_BRIDGE_KEY_Zenkaku_Hankaku);
        map_keycode (scim::SCIM_KEY_Touroku, SCIM_BRIDGE_KEY_Touroku);
        map_keycode (scim::SCIM_KEY_Massyo, SCIM_BRIDGE_KEY_Massyo);
        map_keycode (scim::SCIM_KEY_Kana_Lock, SCIM_BRIDGE_KEY_Kana_Lock);
        map_keycode (scim::SCIM_KEY_Kana_Shift, SCIM_BRIDGE_KEY_Kana_Shift);
        map_keycode (scim::SCIM_KEY_Eisu_Shift, SCIM_BRIDGE_KEY_Eisu_Shift);
        map_keycode (scim::SCIM_KEY_Eisu_toggle, SCIM_BRIDGE_KEY_Eisu_toggle);
        map_keycode (scim::SCIM_KEY_Kanji_Bangou, SCIM_BRIDGE_KEY_Kanji_Bangou);
        map_keycode (scim::SCIM_KEY_Zen_Koho, SCIM_BRIDGE_KEY_Zen_Koho);
        map_keycode (scim::SCIM_KEY_Mae_Koho, SCIM_BRIDGE_KEY_Mae_Koho);

        map_keycode (scim::SCIM_KEY_Home, SCIM_BRIDGE_KEY_Home);
        map_keycode (scim::SCIM_KEY_Left, SCIM_BRIDGE_KEY_Left);
        map_keycode (scim::SCIM_KEY_Up, SCIM_BRIDGE_KEY_Up);
        map_keycode (scim::SCIM_KEY_Right, SCIM_BRIDGE_KEY_Right);
        map_keycode (scim::SCIM_KEY_Down, SCIM_BRIDGE_KEY_Down);
        map_keycode (scim::SCIM_KEY_Prior, SCIM_BRIDGE_KEY_Prior);
        map_keycode (scim::SCIM_KEY_Page_Up, SCIM_BRIDGE_KEY_Page_Up);
        map_keycode (scim::SCIM_KEY_Next, SCIM_BRIDGE_KEY_Next);
        map_keycode (scim::SCIM_KEY_Page_Down, SCIM_BRIDGE_KEY_Page_Down);
        map_keycode (scim::SCIM_KEY_End, SCIM_BRIDGE_KEY_End);
        map_keycode (scim::SCIM_KEY_Begin, SCIM_BRIDGE_KEY_Begin);

        map_keycode (scim::SCIM_KEY_Select, SCIM_BRIDGE_KEY_Select);
        map_keycode (scim::SCIM_KEY_Print, SCIM_BRIDGE_KEY_Print);
        map_keycode (scim::SCIM_KEY_Execute, SCIM_BRIDGE_KEY_Execute);
        map_keycode (scim::SCIM_KEY_Insert, SCIM_BRIDGE_KEY_Insert);
        map_keycode (scim::SCIM_KEY_Undo, SCIM_BRIDGE_KEY_Undo);
        map_keycode (scim::SCIM_KEY_Redo, SCIM_BRIDGE_KEY_Redo);
        map_keycode (scim::SCIM_KEY_Menu, SCIM_BRIDGE_KEY_Menu);
        map_keycode (scim::SCIM_KEY_Find, SCIM_BRIDGE_KEY_Find);
        map_keycode (scim::SCIM_KEY_Cancel, SCIM_BRIDGE_KEY_Cancel);
        map_keycode (scim::SCIM_KEY_Help, SCIM_BRIDGE_KEY_Help);
        map_keycode (scim::SCIM_KEY_Break, SCIM_BRIDGE_KEY_Break);
        map_keycode (scim::SCIM_KEY_Mode_switch, SCIM_BRIDGE_KEY_Mode_switch);
        map_keycode (scim::SCIM_KEY_Num_Lock, SCIM_BRIDGE_KEY_Num_Lock);

        map_keycode (scim::SCIM_KEY_KP_Space, SCIM_BRIDGE_KEY_KP_Space);
        map_keycode (scim::SCIM_KEY_KP_Tab, SCIM_BRIDGE_KEY_KP_Tab);
        map_keycode (scim::SCIM_KEY_KP_Enter, SCIM_BRIDGE_KEY_KP_Enter);
        map_keycode (scim::SCIM_KEY_KP_F1, SCIM_BRIDGE_KEY_KP_F1);
        map_keycode (scim::SCIM_KEY_KP_F2, SCIM_BRIDGE_KEY_KP_F2);
        map_keycode (scim::SCIM_KEY_KP_F3, SCIM_BRIDGE_KEY_KP_F3);
        map_keycode (scim::SCIM_KEY_KP_F4, SCIM_BRIDGE_KEY_KP_F4);
        map_keycode (scim::SCIM_KEY_KP_Home, SCIM_BRIDGE_KEY_KP_Home);
        map_keycode (scim::SCIM_KEY_KP_Left, SCIM_BRIDGE_KEY_KP_Left);
        map_keycode (scim::SCIM_KEY_KP_Up, SCIM_BRIDGE_KEY_KP_Up);
        map_keycode (scim::SCIM_KEY_KP_Right, SCIM_BRIDGE_KEY_KP_Right);
        map_keycode (scim::SCIM_KEY_KP_Down, SCIM_BRIDGE_KEY_KP_Down);
        map_keycode (scim::SCIM_KEY_KP_Prior, SCIM_BRIDGE_KEY_KP_Prior);
        map_keycode (scim::SCIM_KEY_KP_Page_Up, SCIM_BRIDGE_KEY_KP_Page_Up);
        map_keycode (scim::SCIM_KEY_KP_Next, SCIM_BRIDGE_KEY_KP_Next);
        map_keycode (scim::SCIM_KEY_KP_Page_Down, SCIM_BRIDGE_KEY_KP_Page_Down);
        map_keycode (scim::SCIM_KEY_KP_End, SCIM_BRIDGE_KEY_KP_End);
        map_keycode (scim::SCIM_KEY_KP_Begin, SCIM_BRIDGE_KEY_KP_Begin);
        map_keycode (scim::SCIM_KEY_KP_Insert, SCIM_BRIDGE_KEY_KP_Insert);
        map_keycode (scim::SCIM_KEY_KP_Delete, SCIM_BRIDGE_KEY_KP_Delete);
        map_keycode (scim::SCIM_KEY_KP_Equal, SCIM_BRIDGE_KEY_KP_Equal);
        map_keycode (scim::SCIM_KEY_KP_Multiply, SCIM_BRIDGE_KEY_KP_Multiply);
        map_keycode (scim::SCIM_KEY_KP_Add, SCIM_BRIDGE_KEY_KP_Add);
        map_keycode (scim::SCIM_KEY_KP_Separator, SCIM_BRIDGE_KEY_KP_Separator);
        map_keycode (scim::SCIM_KEY_KP_Subtract, SCIM_BRIDGE_KEY_KP_Subtract);
        map_keycode (scim::SCIM_KEY_KP_Decimal, SCIM_BRIDGE_KEY_KP_Decimal);
        map_keycode (scim::SCIM_KEY_KP_Divide, SCIM_BRIDGE_KEY_KP_Divide);

        map_keycode (scim::SCIM_KEY_KP_0, SCIM_BRIDGE_KEY_KP_0);
        map_keycode (scim::SCIM_KEY_KP_1, SCIM_BRIDGE_KEY_KP_1);
        map_keycode (scim::SCIM_KEY_KP_2, SCIM_BRIDGE_KEY_KP_2);
        map_keycode (scim::SCIM_KEY_KP_3, SCIM_BRIDGE_KEY_KP_3);
        map_keycode (scim::SCIM_KEY_KP_4, SCIM_BRIDGE_KEY_KP_4);
        map_keycode (scim::SCIM_KEY_KP_5, SCIM_BRIDGE_KEY_KP_5);
        map_keycode (scim::SCIM_KEY_KP_6, SCIM_BRIDGE_KEY_KP_6);
        map_keycode (scim::SCIM_KEY_KP_7, SCIM_BRIDGE_KEY_KP_7);
        map_keycode (scim::SCIM_KEY_KP_8, SCIM_BRIDGE_KEY_KP_8);
        map_keycode (scim::SCIM_KEY_KP_9, SCIM_BRIDGE_KEY_KP_9);

        map_keycode (scim::SCIM_KEY_F1, SCIM_BRIDGE_KEY_F1);
        map_keycode (scim::SCIM_KEY_F2, SCIM_BRIDGE_KEY_F2);
        map_keycode (scim::SCIM_KEY_F3, SCIM_BRIDGE_KEY_F3);
        map_keycode (scim::SCIM_KEY_F4, SCIM_BRIDGE_KEY_F4);
        map_keycode (scim::SCIM_KEY_F5, SCIM_BRIDGE_KEY_F5);
        map_keycode (scim::SCIM_KEY_F6, SCIM_BRIDGE_KEY_F6);
        map_keycode (scim::SCIM_KEY_F7, SCIM_BRIDGE_KEY_F7);
        map_keycode (scim::SCIM_KEY_F8, SCIM_BRIDGE_KEY_F8);
        map_keycode (scim::SCIM_KEY_F9, SCIM_BRIDGE_KEY_F9);
        map_keycode (scim::SCIM_KEY_F10, SCIM_BRIDGE_KEY_F10);
        map_keycode (scim::SCIM_KEY_F11, SCIM_BRIDGE_KEY_F11);
        map_keycode (scim::SCIM_KEY_F12, SCIM_BRIDGE_KEY_F12);
        map_keycode (scim::SCIM_KEY_F13, SCIM_BRIDGE_KEY_F13);
        map_keycode (scim::SCIM_KEY_F14, SCIM_BRIDGE_KEY_F14);
        map_keycode (scim::SCIM_KEY_F15, SCIM_BRIDGE_KEY_F15);
        map_keycode (scim::SCIM_KEY_F16, SCIM_BRIDGE_KEY_F16);
        map_keycode (scim::SCIM_KEY_F17, SCIM_BRIDGE_KEY_F17);
        map_keycode (scim::SCIM_KEY_F18, SCIM_BRIDGE_KEY_F18);
        map_keycode (scim::SCIM_KEY_F19, SCIM_BRIDGE_KEY_F19);
        map_keycode (scim::SCIM_KEY_F20, SCIM_BRIDGE_KEY_F20);
        map_keycode (scim::SCIM_KEY_F21, SCIM_BRIDGE_KEY_F21);
        map_keycode (scim::SCIM_KEY_F22, SCIM_BRIDGE_KEY_F22);
        map_keycode (scim::SCIM_KEY_F23, SCIM_BRIDGE_KEY_F23);
        map_keycode (scim::SCIM_KEY_F24, SCIM_BRIDGE_KEY_F24);
        map_keycode (scim::SCIM_KEY_F25, SCIM_BRIDGE_KEY_F25);
        map_keycode (scim::SCIM_KEY_F26, SCIM_BRIDGE_KEY_F26);
        map_keycode (scim::SCIM_KEY_F27, SCIM_BRIDGE_KEY_F27);
        map_keycode (scim::SCIM_KEY_F28, SCIM_BRIDGE_KEY_F28);
        map_keycode (scim::SCIM_KEY_F29, SCIM_BRIDGE_KEY_F29);
        map_keycode (scim::SCIM_KEY_F30, SCIM_BRIDGE_KEY_F30);
        map_keycode (scim::SCIM_KEY_F31, SCIM_BRIDGE_KEY_F31);
        map_keycode (scim::SCIM_KEY_F32, SCIM_BRIDGE_KEY_F32);
        map_keycode (scim::SCIM_KEY_F33, SCIM_BRIDGE_KEY_F33);
        map_keycode (scim::SCIM_KEY_F34, SCIM_BRIDGE_KEY_F34);
        map_keycode (scim::SCIM_KEY_F35, SCIM_BRIDGE_KEY_F35);

        map_keycode (scim::SCIM_KEY_Shift_L, SCIM_BRIDGE_KEY_Shift_L);
        map_keycode (scim::SCIM_KEY_Shift_R, SCIM_BRIDGE_KEY_Shift_R);
        map_keycode (scim::SCIM_KEY_Control_L, SCIM_BRIDGE_KEY_Control_L);
        map_keycode (scim::SCIM_KEY_Control_R, SCIM_BRIDGE_KEY_Control_R);
        map_keycode (scim::SCIM_KEY_Caps_Lock, SCIM_BRIDGE_KEY_Caps_Lock);
        map_keycode (scim::SCIM_KEY_Shift_Lock, SCIM_BRIDGE_KEY_Shift_Lock);

        map_keycode (scim::SCIM_KEY_Meta_L, SCIM_BRIDGE_KEY_Meta_L);
        map_keycode (scim::SCIM_KEY_Meta_R, SCIM_BRIDGE_KEY_Meta_R);
        map_keycode (scim::SCIM_KEY_Alt_L, SCIM_BRIDGE_KEY_Alt_L);
        map_keycode (scim::SCIM_KEY_Alt_R, SCIM_BRIDGE_KEY_Alt_R);
        map_keycode (scim::SCIM_KEY_Super_L, SCIM_BRIDGE_KEY_Super_L);
        map_keycode (scim::SCIM_KEY_Super_R, SCIM_BRIDGE_KEY_Super_R);
        map_keycode (scim::SCIM_KEY_Hyper_L, SCIM_BRIDGE_KEY_Hyper_L);
        map_keycode (scim::SCIM_KEY_Hyper_R, SCIM_BRIDGE_KEY_Hyper_R);

        /*
         *ISO9995FunctionandModifierKeys
         *Byte3=0xFE
         */

        map_keycode (scim::SCIM_KEY_ISO_Lock, SCIM_BRIDGE_KEY_ISO_Lock);
        map_keycode (scim::SCIM_KEY_ISO_Level2_Latch, SCIM_BRIDGE_KEY_ISO_Level2_Latch);
        map_keycode (scim::SCIM_KEY_ISO_Level3_Shift, SCIM_BRIDGE_KEY_ISO_Level3_Shift);
        map_keycode (scim::SCIM_KEY_ISO_Level3_Latch, SCIM_BRIDGE_KEY_ISO_Level3_Latch);
        map_keycode (scim::SCIM_KEY_ISO_Level3_Lock, SCIM_BRIDGE_KEY_ISO_Level3_Lock);
        map_keycode (scim::SCIM_KEY_ISO_Group_Shift, SCIM_BRIDGE_KEY_ISO_Group_Shift);
        map_keycode (scim::SCIM_KEY_ISO_Group_Latch, SCIM_BRIDGE_KEY_ISO_Group_Latch);
        map_keycode (scim::SCIM_KEY_ISO_Group_Lock, SCIM_BRIDGE_KEY_ISO_Group_Lock);
        map_keycode (scim::SCIM_KEY_ISO_Next_Group, SCIM_BRIDGE_KEY_ISO_Next_Group);
        map_keycode (scim::SCIM_KEY_ISO_Next_Group_Lock, SCIM_BRIDGE_KEY_ISO_Next_Group_Lock);
        map_keycode (scim::SCIM_KEY_ISO_Prev_Group, SCIM_BRIDGE_KEY_ISO_Prev_Group);
        map_keycode (scim::SCIM_KEY_ISO_Prev_Group_Lock, SCIM_BRIDGE_KEY_ISO_Prev_Group_Lock);
        map_keycode (scim::SCIM_KEY_ISO_First_Group, SCIM_BRIDGE_KEY_ISO_First_Group);
        map_keycode (scim::SCIM_KEY_ISO_First_Group_Lock, SCIM_BRIDGE_KEY_ISO_First_Group_Lock);
        map_keycode (scim::SCIM_KEY_ISO_Last_Group, SCIM_BRIDGE_KEY_ISO_Last_Group);
        map_keycode (scim::SCIM_KEY_ISO_Last_Group_Lock, SCIM_BRIDGE_KEY_ISO_Last_Group_Lock);

        map_keycode (scim::SCIM_KEY_ISO_Left_Tab, SCIM_BRIDGE_KEY_ISO_Left_Tab);
        map_keycode (scim::SCIM_KEY_ISO_Move_Line_Up, SCIM_BRIDGE_KEY_ISO_Move_Line_Up);
        map_keycode (scim::SCIM_KEY_ISO_Move_Line_Down, SCIM_BRIDGE_KEY_ISO_Move_Line_Down);
        map_keycode (scim::SCIM_KEY_ISO_Partial_Line_Up, SCIM_BRIDGE_KEY_ISO_Partial_Line_Up);
        map_keycode (scim::SCIM_KEY_ISO_Partial_Line_Down, SCIM_BRIDGE_KEY_ISO_Partial_Line_Down);
        map_keycode (scim::SCIM_KEY_ISO_Partial_Space_Left, SCIM_BRIDGE_KEY_ISO_Partial_Space_Left);
        map_keycode (scim::SCIM_KEY_ISO_Partial_Space_Right, SCIM_BRIDGE_KEY_ISO_Partial_Space_Right);
        map_keycode (scim::SCIM_KEY_ISO_Set_Margin_Left, SCIM_BRIDGE_KEY_ISO_Set_Margin_Left);
        map_keycode (scim::SCIM_KEY_ISO_Set_Margin_Right, SCIM_BRIDGE_KEY_ISO_Set_Margin_Right);
        map_keycode (scim::SCIM_KEY_ISO_Release_Margin_Left, SCIM_BRIDGE_KEY_ISO_Release_Margin_Left);
        map_keycode (scim::SCIM_KEY_ISO_Release_Margin_Right, SCIM_BRIDGE_KEY_ISO_Release_Margin_Right);
        map_keycode (scim::SCIM_KEY_ISO_Release_Both_Margins, SCIM_BRIDGE_KEY_ISO_Release_Both_Margins);
        map_keycode (scim::SCIM_KEY_ISO_Fast_Cursor_Left, SCIM_BRIDGE_KEY_ISO_Fast_Cursor_Left);
        map_keycode (scim::SCIM_KEY_ISO_Fast_Cursor_Right, SCIM_BRIDGE_KEY_ISO_Fast_Cursor_Right);
        map_keycode (scim::SCIM_KEY_ISO_Fast_Cursor_Up, SCIM_BRIDGE_KEY_ISO_Fast_Cursor_Up);
        map_keycode (scim::SCIM_KEY_ISO_Fast_Cursor_Down, SCIM_BRIDGE_KEY_ISO_Fast_Cursor_Down);
        map_keycode (scim::SCIM_KEY_ISO_Continuous_Underline, SCIM_BRIDGE_KEY_ISO_Continuous_Underline);
        map_keycode (scim::SCIM_KEY_ISO_Discontinuous_Underline, SCIM_BRIDGE_KEY_ISO_Discontinuous_Underline);
        map_keycode (scim::SCIM_KEY_ISO_Emphasize, SCIM_BRIDGE_KEY_ISO_Emphasize);
        map_keycode (scim::SCIM_KEY_ISO_Center_Object, SCIM_BRIDGE_KEY_ISO_Center_Object);
        map_keycode (scim::SCIM_KEY_ISO_Enter, SCIM_BRIDGE_KEY_ISO_Enter);

        map_keycode (scim::SCIM_KEY_dead_grave, SCIM_BRIDGE_KEY_dead_grave);
        map_keycode (scim::SCIM_KEY_dead_acute, SCIM_BRIDGE_KEY_dead_acute);
        map_keycode (scim::SCIM_KEY_dead_circumflex, SCIM_BRIDGE_KEY_dead_circumflex);
        map_keycode (scim::SCIM_KEY_dead_tilde, SCIM_BRIDGE_KEY_dead_tilde);
        map_keycode (scim::SCIM_KEY_dead_macron, SCIM_BRIDGE_KEY_dead_macron);
        map_keycode (scim::SCIM_KEY_dead_breve, SCIM_BRIDGE_KEY_dead_breve);
        map_keycode (scim::SCIM_KEY_dead_abovedot, SCIM_BRIDGE_KEY_dead_abovedot);
        map_keycode (scim::SCIM_KEY_dead_diaeresis, SCIM_BRIDGE_KEY_dead_diaeresis);
        map_keycode (scim::SCIM_KEY_dead_abovering, SCIM_BRIDGE_KEY_dead_abovering);
        map_keycode (scim::SCIM_KEY_dead_doubleacute, SCIM_BRIDGE_KEY_dead_doubleacute);
        map_keycode (scim::SCIM_KEY_dead_caron, SCIM_BRIDGE_KEY_dead_caron);
        map_keycode (scim::SCIM_KEY_dead_cedilla, SCIM_BRIDGE_KEY_dead_cedilla);
        map_keycode (scim::SCIM_KEY_dead_ogonek, SCIM_BRIDGE_KEY_dead_ogonek);
        map_keycode (scim::SCIM_KEY_dead_iota, SCIM_BRIDGE_KEY_dead_iota);
        map_keycode (scim::SCIM_KEY_dead_voiced_sound, SCIM_BRIDGE_KEY_dead_voiced_sound);
        map_keycode (scim::SCIM_KEY_dead_semivoiced_sound, SCIM_BRIDGE_KEY_dead_semivoiced_sound);
        map_keycode (scim::SCIM_KEY_dead_belowdot, SCIM_BRIDGE_KEY_dead_belowdot);
        map_keycode (scim::SCIM_KEY_dead_hook, SCIM_BRIDGE_KEY_dead_hook);
        map_keycode (scim::SCIM_KEY_dead_horn, SCIM_BRIDGE_KEY_dead_horn);

        map_keycode (scim::SCIM_KEY_First_Virtual_Screen, SCIM_BRIDGE_KEY_First_Virtual_Screen);
        map_keycode (scim::SCIM_KEY_Prev_Virtual_Screen, SCIM_BRIDGE_KEY_Prev_Virtual_Screen);
        map_keycode (scim::SCIM_KEY_Next_Virtual_Screen, SCIM_BRIDGE_KEY_Next_Virtual_Screen);
        map_keycode (scim::SCIM_KEY_Last_Virtual_Screen, SCIM_BRIDGE_KEY_Last_Virtual_Screen);
        map_keycode (scim::SCIM_KEY_Terminate_Server, SCIM_BRIDGE_KEY_Terminate_Server);

        map_keycode (scim::SCIM_KEY_AccessX_Enable, SCIM_BRIDGE_KEY_AccessX_Enable);
        map_keycode (scim::SCIM_KEY_AccessX_Feedback_Enable, SCIM_BRIDGE_KEY_AccessX_Feedback_Enable);
        map_keycode (scim::SCIM_KEY_RepeatKeys_Enable, SCIM_BRIDGE_KEY_RepeatKeys_Enable);
        map_keycode (scim::SCIM_KEY_SlowKeys_Enable, SCIM_BRIDGE_KEY_SlowKeys_Enable);
        map_keycode (scim::SCIM_KEY_BounceKeys_Enable, SCIM_BRIDGE_KEY_BounceKeys_Enable);
        map_keycode (scim::SCIM_KEY_StickyKeys_Enable, SCIM_BRIDGE_KEY_StickyKeys_Enable);
        map_keycode (scim::SCIM_KEY_MouseKeys_Enable, SCIM_BRIDGE_KEY_MouseKeys_Enable);
        map_keycode (scim::SCIM_KEY_MouseKeys_Accel_Enable, SCIM_BRIDGE_KEY_MouseKeys_Accel_Enable);
        map_keycode (scim::SCIM_KEY_Overlay1_Enable, SCIM_BRIDGE_KEY_Overlay1_Enable);
        map_keycode (scim::SCIM_KEY_Overlay2_Enable, SCIM_BRIDGE_KEY_Overlay2_Enable);
        map_keycode (scim::SCIM_KEY_AudibleBell_Enable, SCIM_BRIDGE_KEY_AudibleBell_Enable);

        map_keycode (scim::SCIM_KEY_Pointer_Left, SCIM_BRIDGE_KEY_Pointer_Left);
        map_keycode (scim::SCIM_KEY_Pointer_Right, SCIM_BRIDGE_KEY_Pointer_Right);
        map_keycode (scim::SCIM_KEY_Pointer_Up, SCIM_BRIDGE_KEY_Pointer_Up);
        map_keycode (scim::SCIM_KEY_Pointer_Down, SCIM_BRIDGE_KEY_Pointer_Down);
        map_keycode (scim::SCIM_KEY_Pointer_UpLeft, SCIM_BRIDGE_KEY_Pointer_UpLeft);
        map_keycode (scim::SCIM_KEY_Pointer_UpRight, SCIM_BRIDGE_KEY_Pointer_UpRight);
        map_keycode (scim::SCIM_KEY_Pointer_DownLeft, SCIM_BRIDGE_KEY_Pointer_DownLeft);
        map_keycode (scim::SCIM_KEY_Pointer_DownRight, SCIM_BRIDGE_KEY_Pointer_DownRight);
        map_keycode (scim::SCIM_KEY_Pointer_Button_Dflt, SCIM_BRIDGE_KEY_Pointer_Button_Dflt);
        map_keycode (scim::SCIM_KEY_Pointer_Button1, SCIM_BRIDGE_KEY_Pointer_Button1);
        map_keycode (scim::SCIM_KEY_Pointer_Button2, SCIM_BRIDGE_KEY_Pointer_Button2);
        map_keycode (scim::SCIM_KEY_Pointer_Button3, SCIM_BRIDGE_KEY_Pointer_Button3);
        map_keycode (scim::SCIM_KEY_Pointer_Button4, SCIM_BRIDGE_KEY_Pointer_Button4);
        map_keycode (scim::SCIM_KEY_Pointer_Button5, SCIM_BRIDGE_KEY_Pointer_Button5);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick_Dflt, SCIM_BRIDGE_KEY_Pointer_DblClick_Dflt);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick1, SCIM_BRIDGE_KEY_Pointer_DblClick1);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick2, SCIM_BRIDGE_KEY_Pointer_DblClick2);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick3, SCIM_BRIDGE_KEY_Pointer_DblClick3);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick4, SCIM_BRIDGE_KEY_Pointer_DblClick4);
        map_keycode (scim::SCIM_KEY_Pointer_DblClick5, SCIM_BRIDGE_KEY_Pointer_DblClick5);
        map_keycode (scim::SCIM_KEY_Pointer_Drag_Dflt, SCIM_BRIDGE_KEY_Pointer_Drag_Dflt);
        map_keycode (scim::SCIM_KEY_Pointer_Drag1, SCIM_BRIDGE_KEY_Pointer_Drag1);
        map_keycode (scim::SCIM_KEY_Pointer_Drag2, SCIM_BRIDGE_KEY_Pointer_Drag2);
        map_keycode (scim::SCIM_KEY_Pointer_Drag3, SCIM_BRIDGE_KEY_Pointer_Drag3);
        map_keycode (scim::SCIM_KEY_Pointer_Drag4, SCIM_BRIDGE_KEY_Pointer_Drag4);
        map_keycode (scim::SCIM_KEY_Pointer_Drag5, SCIM_BRIDGE_KEY_Pointer_Drag5);

        map_keycode (scim::SCIM_KEY_Pointer_EnableKeys, SCIM_BRIDGE_KEY_Pointer_EnableKeys);
        map_keycode (scim::SCIM_KEY_Pointer_Accelerate, SCIM_BRIDGE_KEY_Pointer_Accelerate);
        map_keycode (scim::SCIM_KEY_Pointer_DfltBtnNext, SCIM_BRIDGE_KEY_Pointer_DfltBtnNext);
        map_keycode (scim::SCIM_KEY_Pointer_DfltBtnPrev, SCIM_BRIDGE_KEY_Pointer_DfltBtnPrev);

        /*
         *3270TerminalKeys
         *Byte3=0xFD
         */
        map_keycode (scim::SCIM_KEY_3270_Duplicate, SCIM_BRIDGE_KEY_3270_Duplicate);
        map_keycode (scim::SCIM_KEY_3270_FieldMark, SCIM_BRIDGE_KEY_3270_FieldMark);
        map_keycode (scim::SCIM_KEY_3270_Right2, SCIM_BRIDGE_KEY_3270_Right2);
        map_keycode (scim::SCIM_KEY_3270_Left2, SCIM_BRIDGE_KEY_3270_Left2);
        map_keycode (scim::SCIM_KEY_3270_BackTab, SCIM_BRIDGE_KEY_3270_BackTab);
        map_keycode (scim::SCIM_KEY_3270_EraseEOF, SCIM_BRIDGE_KEY_3270_EraseEOF);
        map_keycode (scim::SCIM_KEY_3270_EraseInput, SCIM_BRIDGE_KEY_3270_EraseInput);
        map_keycode (scim::SCIM_KEY_3270_Reset, SCIM_BRIDGE_KEY_3270_Reset);
        map_keycode (scim::SCIM_KEY_3270_Quit, SCIM_BRIDGE_KEY_3270_Quit);
        map_keycode (scim::SCIM_KEY_3270_PA1, SCIM_BRIDGE_KEY_3270_PA1);
        map_keycode (scim::SCIM_KEY_3270_PA2, SCIM_BRIDGE_KEY_3270_PA2);
        map_keycode (scim::SCIM_KEY_3270_PA3, SCIM_BRIDGE_KEY_3270_PA3);
        map_keycode (scim::SCIM_KEY_3270_Test, SCIM_BRIDGE_KEY_3270_Test);
        map_keycode (scim::SCIM_KEY_3270_Attn, SCIM_BRIDGE_KEY_3270_Attn);
        map_keycode (scim::SCIM_KEY_3270_CursorBlink, SCIM_BRIDGE_KEY_3270_CursorBlink);
        map_keycode (scim::SCIM_KEY_3270_AltCursor, SCIM_BRIDGE_KEY_3270_AltCursor);
        map_keycode (scim::SCIM_KEY_3270_KeyClick, SCIM_BRIDGE_KEY_3270_KeyClick);
        map_keycode (scim::SCIM_KEY_3270_Jump, SCIM_BRIDGE_KEY_3270_Jump);
        map_keycode (scim::SCIM_KEY_3270_Ident, SCIM_BRIDGE_KEY_3270_Ident);
        map_keycode (scim::SCIM_KEY_3270_Rule, SCIM_BRIDGE_KEY_3270_Rule);
        map_keycode (scim::SCIM_KEY_3270_Copy, SCIM_BRIDGE_KEY_3270_Copy);
        map_keycode (scim::SCIM_KEY_3270_Play, SCIM_BRIDGE_KEY_3270_Play);
        map_keycode (scim::SCIM_KEY_3270_Setup, SCIM_BRIDGE_KEY_3270_Setup);
        map_keycode (scim::SCIM_KEY_3270_Record, SCIM_BRIDGE_KEY_3270_Record);
        map_keycode (scim::SCIM_KEY_3270_ChangeScreen, SCIM_BRIDGE_KEY_3270_ChangeScreen);
        map_keycode (scim::SCIM_KEY_3270_DeleteWord, SCIM_BRIDGE_KEY_3270_DeleteWord);
        map_keycode (scim::SCIM_KEY_3270_ExSelect, SCIM_BRIDGE_KEY_3270_ExSelect);
        map_keycode (scim::SCIM_KEY_3270_CursorSelect, SCIM_BRIDGE_KEY_3270_CursorSelect);
        map_keycode (scim::SCIM_KEY_3270_PrintScreen, SCIM_BRIDGE_KEY_3270_PrintScreen);
        map_keycode (scim::SCIM_KEY_3270_Enter, SCIM_BRIDGE_KEY_3270_Enter);

        map_keycode (scim::SCIM_KEY_space, SCIM_BRIDGE_KEY_space);
        map_keycode (scim::SCIM_KEY_exclam, SCIM_BRIDGE_KEY_exclam);
        map_keycode (scim::SCIM_KEY_quotedbl, SCIM_BRIDGE_KEY_quotedbl);
        map_keycode (scim::SCIM_KEY_numbersign, SCIM_BRIDGE_KEY_numbersign);
        map_keycode (scim::SCIM_KEY_dollar, SCIM_BRIDGE_KEY_dollar);
        map_keycode (scim::SCIM_KEY_percent, SCIM_BRIDGE_KEY_percent);
        map_keycode (scim::SCIM_KEY_ampersand, SCIM_BRIDGE_KEY_ampersand);
        map_keycode (scim::SCIM_KEY_apostrophe, SCIM_BRIDGE_KEY_apostrophe);
        map_keycode (scim::SCIM_KEY_quoteright, SCIM_BRIDGE_KEY_quoteright);
        map_keycode (scim::SCIM_KEY_parenleft, SCIM_BRIDGE_KEY_parenleft);
        map_keycode (scim::SCIM_KEY_parenright, SCIM_BRIDGE_KEY_parenright);
        map_keycode (scim::SCIM_KEY_asterisk, SCIM_BRIDGE_KEY_asterisk);
        map_keycode (scim::SCIM_KEY_plus, SCIM_BRIDGE_KEY_plus);
        map_keycode (scim::SCIM_KEY_comma, SCIM_BRIDGE_KEY_comma);
        map_keycode (scim::SCIM_KEY_minus, SCIM_BRIDGE_KEY_minus);
        map_keycode (scim::SCIM_KEY_period, SCIM_BRIDGE_KEY_period);
        map_keycode (scim::SCIM_KEY_slash, SCIM_BRIDGE_KEY_slash);
        map_keycode (scim::SCIM_KEY_0, SCIM_BRIDGE_KEY_0);
        map_keycode (scim::SCIM_KEY_1, SCIM_BRIDGE_KEY_1);
        map_keycode (scim::SCIM_KEY_2, SCIM_BRIDGE_KEY_2);
        map_keycode (scim::SCIM_KEY_3, SCIM_BRIDGE_KEY_3);
        map_keycode (scim::SCIM_KEY_4, SCIM_BRIDGE_KEY_4);
        map_keycode (scim::SCIM_KEY_5, SCIM_BRIDGE_KEY_5);
        map_keycode (scim::SCIM_KEY_6, SCIM_BRIDGE_KEY_6);
        map_keycode (scim::SCIM_KEY_7, SCIM_BRIDGE_KEY_7);
        map_keycode (scim::SCIM_KEY_8, SCIM_BRIDGE_KEY_8);
        map_keycode (scim::SCIM_KEY_9, SCIM_BRIDGE_KEY_9);
        map_keycode (scim::SCIM_KEY_colon, SCIM_BRIDGE_KEY_colon);
        map_keycode (scim::SCIM_KEY_semicolon, SCIM_BRIDGE_KEY_semicolon);
        map_keycode (scim::SCIM_KEY_less, SCIM_BRIDGE_KEY_less);
        map_keycode (scim::SCIM_KEY_equal, SCIM_BRIDGE_KEY_equal);
        map_keycode (scim::SCIM_KEY_greater, SCIM_BRIDGE_KEY_greater);
        map_keycode (scim::SCIM_KEY_question, SCIM_BRIDGE_KEY_question);
        map_keycode (scim::SCIM_KEY_at, SCIM_BRIDGE_KEY_at);
        map_keycode (scim::SCIM_KEY_A, SCIM_BRIDGE_KEY_A);
        map_keycode (scim::SCIM_KEY_B, SCIM_BRIDGE_KEY_B);
        map_keycode (scim::SCIM_KEY_C, SCIM_BRIDGE_KEY_C);
        map_keycode (scim::SCIM_KEY_D, SCIM_BRIDGE_KEY_D);
        map_keycode (scim::SCIM_KEY_E, SCIM_BRIDGE_KEY_E);
        map_keycode (scim::SCIM_KEY_F, SCIM_BRIDGE_KEY_F);
        map_keycode (scim::SCIM_KEY_G, SCIM_BRIDGE_KEY_G);
        map_keycode (scim::SCIM_KEY_H, SCIM_BRIDGE_KEY_H);
        map_keycode (scim::SCIM_KEY_I, SCIM_BRIDGE_KEY_I);
        map_keycode (scim::SCIM_KEY_J, SCIM_BRIDGE_KEY_J);
        map_keycode (scim::SCIM_KEY_K, SCIM_BRIDGE_KEY_K);
        map_keycode (scim::SCIM_KEY_L, SCIM_BRIDGE_KEY_L);
        map_keycode (scim::SCIM_KEY_M, SCIM_BRIDGE_KEY_M);
        map_keycode (scim::SCIM_KEY_N, SCIM_BRIDGE_KEY_N);
        map_keycode (scim::SCIM_KEY_O, SCIM_BRIDGE_KEY_O);
        map_keycode (scim::SCIM_KEY_P, SCIM_BRIDGE_KEY_P);
        map_keycode (scim::SCIM_KEY_Q, SCIM_BRIDGE_KEY_Q);
        map_keycode (scim::SCIM_KEY_R, SCIM_BRIDGE_KEY_R);
        map_keycode (scim::SCIM_KEY_S, SCIM_BRIDGE_KEY_S);
        map_keycode (scim::SCIM_KEY_T, SCIM_BRIDGE_KEY_T);
        map_keycode (scim::SCIM_KEY_U, SCIM_BRIDGE_KEY_U);
        map_keycode (scim::SCIM_KEY_V, SCIM_BRIDGE_KEY_V);
        map_keycode (scim::SCIM_KEY_W, SCIM_BRIDGE_KEY_W);
        map_keycode (scim::SCIM_KEY_X, SCIM_BRIDGE_KEY_X);
        map_keycode (scim::SCIM_KEY_Y, SCIM_BRIDGE_KEY_Y);
        map_keycode (scim::SCIM_KEY_Z, SCIM_BRIDGE_KEY_Z);
        map_keycode (scim::SCIM_KEY_bracketleft, SCIM_BRIDGE_KEY_bracketleft);
        map_keycode (scim::SCIM_KEY_backslash, SCIM_BRIDGE_KEY_backslash);
        map_keycode (scim::SCIM_KEY_bracketright, SCIM_BRIDGE_KEY_bracketright);
        map_keycode (scim::SCIM_KEY_asciicircum, SCIM_BRIDGE_KEY_asciicircum);
        map_keycode (scim::SCIM_KEY_underscore, SCIM_BRIDGE_KEY_underscore);
        map_keycode (scim::SCIM_KEY_grave, SCIM_BRIDGE_KEY_grave);
        map_keycode (scim::SCIM_KEY_a, SCIM_BRIDGE_KEY_a);
        map_keycode (scim::SCIM_KEY_b, SCIM_BRIDGE_KEY_b);
        map_keycode (scim::SCIM_KEY_c, SCIM_BRIDGE_KEY_c);
        map_keycode (scim::SCIM_KEY_d, SCIM_BRIDGE_KEY_d);
        map_keycode (scim::SCIM_KEY_e, SCIM_BRIDGE_KEY_e);
        map_keycode (scim::SCIM_KEY_f, SCIM_BRIDGE_KEY_f);
        map_keycode (scim::SCIM_KEY_g, SCIM_BRIDGE_KEY_g);
        map_keycode (scim::SCIM_KEY_h, SCIM_BRIDGE_KEY_h);
        map_keycode (scim::SCIM_KEY_i, SCIM_BRIDGE_KEY_i);
        map_keycode (scim::SCIM_KEY_j, SCIM_BRIDGE_KEY_j);
        map_keycode (scim::SCIM_KEY_k, SCIM_BRIDGE_KEY_k);
        map_keycode (scim::SCIM_KEY_l, SCIM_BRIDGE_KEY_l);
        map_keycode (scim::SCIM_KEY_m, SCIM_BRIDGE_KEY_m);
        map_keycode (scim::SCIM_KEY_n, SCIM_BRIDGE_KEY_n);
        map_keycode (scim::SCIM_KEY_o, SCIM_BRIDGE_KEY_o);
        map_keycode (scim::SCIM_KEY_p, SCIM_BRIDGE_KEY_p);
        map_keycode (scim::SCIM_KEY_q, SCIM_BRIDGE_KEY_q);
        map_keycode (scim::SCIM_KEY_r, SCIM_BRIDGE_KEY_r);
        map_keycode (scim::SCIM_KEY_s, SCIM_BRIDGE_KEY_s);
        map_keycode (scim::SCIM_KEY_t, SCIM_BRIDGE_KEY_t);
        map_keycode (scim::SCIM_KEY_u, SCIM_BRIDGE_KEY_u);
        map_keycode (scim::SCIM_KEY_v, SCIM_BRIDGE_KEY_v);
        map_keycode (scim::SCIM_KEY_w, SCIM_BRIDGE_KEY_w);
        map_keycode (scim::SCIM_KEY_x, SCIM_BRIDGE_KEY_x);
        map_keycode (scim::SCIM_KEY_y, SCIM_BRIDGE_KEY_y);
        map_keycode (scim::SCIM_KEY_z, SCIM_BRIDGE_KEY_z);
        map_keycode (scim::SCIM_KEY_braceleft, SCIM_BRIDGE_KEY_braceleft);
        map_keycode (scim::SCIM_KEY_bar, SCIM_BRIDGE_KEY_bar);
        map_keycode (scim::SCIM_KEY_braceright, SCIM_BRIDGE_KEY_braceright);
        map_keycode (scim::SCIM_KEY_asciitilde, SCIM_BRIDGE_KEY_asciitilde);

        map_keycode (scim::SCIM_KEY_nobreakspace, SCIM_BRIDGE_KEY_nobreakspace);
        map_keycode (scim::SCIM_KEY_exclamdown, SCIM_BRIDGE_KEY_exclamdown);
        map_keycode (scim::SCIM_KEY_cent, SCIM_BRIDGE_KEY_cent);
        map_keycode (scim::SCIM_KEY_sterling, SCIM_BRIDGE_KEY_sterling);
        map_keycode (scim::SCIM_KEY_currency, SCIM_BRIDGE_KEY_currency);
        map_keycode (scim::SCIM_KEY_yen, SCIM_BRIDGE_KEY_yen);
        map_keycode (scim::SCIM_KEY_brokenbar, SCIM_BRIDGE_KEY_brokenbar);
        map_keycode (scim::SCIM_KEY_section, SCIM_BRIDGE_KEY_section);
        map_keycode (scim::SCIM_KEY_diaeresis, SCIM_BRIDGE_KEY_diaeresis);
        map_keycode (scim::SCIM_KEY_copyright, SCIM_BRIDGE_KEY_copyright);
        map_keycode (scim::SCIM_KEY_ordfeminine, SCIM_BRIDGE_KEY_ordfeminine);
        map_keycode (scim::SCIM_KEY_guillemotleft, SCIM_BRIDGE_KEY_guillemotleft);
        map_keycode (scim::SCIM_KEY_notsign, SCIM_BRIDGE_KEY_notsign);
        map_keycode (scim::SCIM_KEY_hyphen, SCIM_BRIDGE_KEY_hyphen);
        map_keycode (scim::SCIM_KEY_registered, SCIM_BRIDGE_KEY_registered);
        map_keycode (scim::SCIM_KEY_macron, SCIM_BRIDGE_KEY_macron);
        map_keycode (scim::SCIM_KEY_degree, SCIM_BRIDGE_KEY_degree);
        map_keycode (scim::SCIM_KEY_plusminus, SCIM_BRIDGE_KEY_plusminus);
        map_keycode (scim::SCIM_KEY_twosuperior, SCIM_BRIDGE_KEY_twosuperior);
        map_keycode (scim::SCIM_KEY_threesuperior, SCIM_BRIDGE_KEY_threesuperior);
        map_keycode (scim::SCIM_KEY_acute, SCIM_BRIDGE_KEY_acute);
        map_keycode (scim::SCIM_KEY_mu, SCIM_BRIDGE_KEY_mu);
        map_keycode (scim::SCIM_KEY_paragraph, SCIM_BRIDGE_KEY_paragraph);
        map_keycode (scim::SCIM_KEY_periodcentered, SCIM_BRIDGE_KEY_periodcentered);
        map_keycode (scim::SCIM_KEY_cedilla, SCIM_BRIDGE_KEY_cedilla);
        map_keycode (scim::SCIM_KEY_onesuperior, SCIM_BRIDGE_KEY_onesuperior);
        map_keycode (scim::SCIM_KEY_masculine, SCIM_BRIDGE_KEY_masculine);
        map_keycode (scim::SCIM_KEY_guillemotright, SCIM_BRIDGE_KEY_guillemotright);
        map_keycode (scim::SCIM_KEY_onequarter, SCIM_BRIDGE_KEY_onequarter);
        map_keycode (scim::SCIM_KEY_onehalf, SCIM_BRIDGE_KEY_onehalf);
        map_keycode (scim::SCIM_KEY_threequarters, SCIM_BRIDGE_KEY_threequarters);
        map_keycode (scim::SCIM_KEY_questiondown, SCIM_BRIDGE_KEY_questiondown);
        map_keycode (scim::SCIM_KEY_Agrave, SCIM_BRIDGE_KEY_Agrave);
        map_keycode (scim::SCIM_KEY_Aacute, SCIM_BRIDGE_KEY_Aacute);
        map_keycode (scim::SCIM_KEY_Acircumflex, SCIM_BRIDGE_KEY_Acircumflex);
        map_keycode (scim::SCIM_KEY_Atilde, SCIM_BRIDGE_KEY_Atilde);
        map_keycode (scim::SCIM_KEY_Adiaeresis, SCIM_BRIDGE_KEY_Adiaeresis);
        map_keycode (scim::SCIM_KEY_Aring, SCIM_BRIDGE_KEY_Aring);
        map_keycode (scim::SCIM_KEY_AE, SCIM_BRIDGE_KEY_AE);
        map_keycode (scim::SCIM_KEY_Ccedilla, SCIM_BRIDGE_KEY_Ccedilla);
        map_keycode (scim::SCIM_KEY_Egrave, SCIM_BRIDGE_KEY_Egrave);
        map_keycode (scim::SCIM_KEY_Eacute, SCIM_BRIDGE_KEY_Eacute);
        map_keycode (scim::SCIM_KEY_Ecircumflex, SCIM_BRIDGE_KEY_Ecircumflex);
        map_keycode (scim::SCIM_KEY_Ediaeresis, SCIM_BRIDGE_KEY_Ediaeresis);
        map_keycode (scim::SCIM_KEY_Igrave, SCIM_BRIDGE_KEY_Igrave);
        map_keycode (scim::SCIM_KEY_Iacute, SCIM_BRIDGE_KEY_Iacute);
        map_keycode (scim::SCIM_KEY_Icircumflex, SCIM_BRIDGE_KEY_Icircumflex);
        map_keycode (scim::SCIM_KEY_Idiaeresis, SCIM_BRIDGE_KEY_Idiaeresis);
        map_keycode (scim::SCIM_KEY_ETH, SCIM_BRIDGE_KEY_ETH);
        map_keycode (scim::SCIM_KEY_Eth, SCIM_BRIDGE_KEY_Eth);
        map_keycode (scim::SCIM_KEY_Ntilde, SCIM_BRIDGE_KEY_Ntilde);
        map_keycode (scim::SCIM_KEY_Ograve, SCIM_BRIDGE_KEY_Ograve);
        map_keycode (scim::SCIM_KEY_Oacute, SCIM_BRIDGE_KEY_Oacute);
        map_keycode (scim::SCIM_KEY_Ocircumflex, SCIM_BRIDGE_KEY_Ocircumflex);
        map_keycode (scim::SCIM_KEY_Otilde, SCIM_BRIDGE_KEY_Otilde);
        map_keycode (scim::SCIM_KEY_Odiaeresis, SCIM_BRIDGE_KEY_Odiaeresis);
        map_keycode (scim::SCIM_KEY_multiply, SCIM_BRIDGE_KEY_multiply);
        map_keycode (scim::SCIM_KEY_Ooblique, SCIM_BRIDGE_KEY_Ooblique);
        map_keycode (scim::SCIM_KEY_Oslash, SCIM_BRIDGE_KEY_Oslash);
        map_keycode (scim::SCIM_KEY_Ugrave, SCIM_BRIDGE_KEY_Ugrave);
        map_keycode (scim::SCIM_KEY_Uacute, SCIM_BRIDGE_KEY_Uacute);
        map_keycode (scim::SCIM_KEY_Ucircumflex, SCIM_BRIDGE_KEY_Ucircumflex);
        map_keycode (scim::SCIM_KEY_Udiaeresis, SCIM_BRIDGE_KEY_Udiaeresis);
        map_keycode (scim::SCIM_KEY_Yacute, SCIM_BRIDGE_KEY_Yacute);
        map_keycode (scim::SCIM_KEY_THORN, SCIM_BRIDGE_KEY_THORN);
        map_keycode (scim::SCIM_KEY_Thorn, SCIM_BRIDGE_KEY_Thorn);
        map_keycode (scim::SCIM_KEY_ssharp, SCIM_BRIDGE_KEY_ssharp);
        map_keycode (scim::SCIM_KEY_agrave, SCIM_BRIDGE_KEY_agrave);
        map_keycode (scim::SCIM_KEY_aacute, SCIM_BRIDGE_KEY_aacute);
        map_keycode (scim::SCIM_KEY_acircumflex, SCIM_BRIDGE_KEY_acircumflex);
        map_keycode (scim::SCIM_KEY_atilde, SCIM_BRIDGE_KEY_atilde);
        map_keycode (scim::SCIM_KEY_adiaeresis, SCIM_BRIDGE_KEY_adiaeresis);
        map_keycode (scim::SCIM_KEY_aring, SCIM_BRIDGE_KEY_aring);
        map_keycode (scim::SCIM_KEY_ae, SCIM_BRIDGE_KEY_ae);
        map_keycode (scim::SCIM_KEY_ccedilla, SCIM_BRIDGE_KEY_ccedilla);
        map_keycode (scim::SCIM_KEY_egrave, SCIM_BRIDGE_KEY_egrave);
        map_keycode (scim::SCIM_KEY_eacute, SCIM_BRIDGE_KEY_eacute);
        map_keycode (scim::SCIM_KEY_ecircumflex, SCIM_BRIDGE_KEY_ecircumflex);
        map_keycode (scim::SCIM_KEY_ediaeresis, SCIM_BRIDGE_KEY_ediaeresis);
        map_keycode (scim::SCIM_KEY_igrave, SCIM_BRIDGE_KEY_igrave);
        map_keycode (scim::SCIM_KEY_iacute, SCIM_BRIDGE_KEY_iacute);
        map_keycode (scim::SCIM_KEY_icircumflex, SCIM_BRIDGE_KEY_icircumflex);
        map_keycode (scim::SCIM_KEY_idiaeresis, SCIM_BRIDGE_KEY_idiaeresis);
        map_keycode (scim::SCIM_KEY_eth, SCIM_BRIDGE_KEY_eth);
        map_keycode (scim::SCIM_KEY_ntilde, SCIM_BRIDGE_KEY_ntilde);
        map_keycode (scim::SCIM_KEY_ograve, SCIM_BRIDGE_KEY_ograve);
        map_keycode (scim::SCIM_KEY_oacute, SCIM_BRIDGE_KEY_oacute);
        map_keycode (scim::SCIM_KEY_ocircumflex, SCIM_BRIDGE_KEY_ocircumflex);
        map_keycode (scim::SCIM_KEY_otilde, SCIM_BRIDGE_KEY_otilde);
        map_keycode (scim::SCIM_KEY_odiaeresis, SCIM_BRIDGE_KEY_odiaeresis);
        map_keycode (scim::SCIM_KEY_division, SCIM_BRIDGE_KEY_division);
        map_keycode (scim::SCIM_KEY_oslash, SCIM_BRIDGE_KEY_oslash);
        map_keycode (scim::SCIM_KEY_ooblique, SCIM_BRIDGE_KEY_ooblique);
        map_keycode (scim::SCIM_KEY_ugrave, SCIM_BRIDGE_KEY_ugrave);
        map_keycode (scim::SCIM_KEY_uacute, SCIM_BRIDGE_KEY_uacute);
        map_keycode (scim::SCIM_KEY_ucircumflex, SCIM_BRIDGE_KEY_ucircumflex);
        map_keycode (scim::SCIM_KEY_udiaeresis, SCIM_BRIDGE_KEY_udiaeresis);
        map_keycode (scim::SCIM_KEY_yacute, SCIM_BRIDGE_KEY_yacute);
        map_keycode (scim::SCIM_KEY_thorn, SCIM_BRIDGE_KEY_thorn);
        map_keycode (scim::SCIM_KEY_ydiaeresis, SCIM_BRIDGE_KEY_ydiaeresis);

        /*
         *Latin2
         *Byte3=1
         */
        map_keycode (scim::SCIM_KEY_Aogonek, SCIM_BRIDGE_KEY_Aogonek);
        map_keycode (scim::SCIM_KEY_breve, SCIM_BRIDGE_KEY_breve);
        map_keycode (scim::SCIM_KEY_Lstroke, SCIM_BRIDGE_KEY_Lstroke);
        map_keycode (scim::SCIM_KEY_Lcaron, SCIM_BRIDGE_KEY_Lcaron);
        map_keycode (scim::SCIM_KEY_Sacute, SCIM_BRIDGE_KEY_Sacute);
        map_keycode (scim::SCIM_KEY_Scaron, SCIM_BRIDGE_KEY_Scaron);
        map_keycode (scim::SCIM_KEY_Scedilla, SCIM_BRIDGE_KEY_Scedilla);
        map_keycode (scim::SCIM_KEY_Tcaron, SCIM_BRIDGE_KEY_Tcaron);
        map_keycode (scim::SCIM_KEY_Zacute, SCIM_BRIDGE_KEY_Zacute);
        map_keycode (scim::SCIM_KEY_Zcaron, SCIM_BRIDGE_KEY_Zcaron);
        map_keycode (scim::SCIM_KEY_Zabovedot, SCIM_BRIDGE_KEY_Zabovedot);
        map_keycode (scim::SCIM_KEY_aogonek, SCIM_BRIDGE_KEY_aogonek);
        map_keycode (scim::SCIM_KEY_ogonek, SCIM_BRIDGE_KEY_ogonek);
        map_keycode (scim::SCIM_KEY_lstroke, SCIM_BRIDGE_KEY_lstroke);
        map_keycode (scim::SCIM_KEY_lcaron, SCIM_BRIDGE_KEY_lcaron);
        map_keycode (scim::SCIM_KEY_sacute, SCIM_BRIDGE_KEY_sacute);
        map_keycode (scim::SCIM_KEY_caron, SCIM_BRIDGE_KEY_caron);
        map_keycode (scim::SCIM_KEY_scaron, SCIM_BRIDGE_KEY_scaron);
        map_keycode (scim::SCIM_KEY_scedilla, SCIM_BRIDGE_KEY_scedilla);
        map_keycode (scim::SCIM_KEY_tcaron, SCIM_BRIDGE_KEY_tcaron);
        map_keycode (scim::SCIM_KEY_zacute, SCIM_BRIDGE_KEY_zacute);
        map_keycode (scim::SCIM_KEY_doubleacute, SCIM_BRIDGE_KEY_doubleacute);
        map_keycode (scim::SCIM_KEY_zcaron, SCIM_BRIDGE_KEY_zcaron);
        map_keycode (scim::SCIM_KEY_zabovedot, SCIM_BRIDGE_KEY_zabovedot);
        map_keycode (scim::SCIM_KEY_Racute, SCIM_BRIDGE_KEY_Racute);
        map_keycode (scim::SCIM_KEY_Abreve, SCIM_BRIDGE_KEY_Abreve);
        map_keycode (scim::SCIM_KEY_Lacute, SCIM_BRIDGE_KEY_Lacute);
        map_keycode (scim::SCIM_KEY_Cacute, SCIM_BRIDGE_KEY_Cacute);
        map_keycode (scim::SCIM_KEY_Ccaron, SCIM_BRIDGE_KEY_Ccaron);
        map_keycode (scim::SCIM_KEY_Eogonek, SCIM_BRIDGE_KEY_Eogonek);
        map_keycode (scim::SCIM_KEY_Ecaron, SCIM_BRIDGE_KEY_Ecaron);
        map_keycode (scim::SCIM_KEY_Dcaron, SCIM_BRIDGE_KEY_Dcaron);
        map_keycode (scim::SCIM_KEY_Dstroke, SCIM_BRIDGE_KEY_Dstroke);
        map_keycode (scim::SCIM_KEY_Nacute, SCIM_BRIDGE_KEY_Nacute);
        map_keycode (scim::SCIM_KEY_Ncaron, SCIM_BRIDGE_KEY_Ncaron);
        map_keycode (scim::SCIM_KEY_Odoubleacute, SCIM_BRIDGE_KEY_Odoubleacute);
        map_keycode (scim::SCIM_KEY_Rcaron, SCIM_BRIDGE_KEY_Rcaron);
        map_keycode (scim::SCIM_KEY_Uring, SCIM_BRIDGE_KEY_Uring);
        map_keycode (scim::SCIM_KEY_Udoubleacute, SCIM_BRIDGE_KEY_Udoubleacute);
        map_keycode (scim::SCIM_KEY_Tcedilla, SCIM_BRIDGE_KEY_Tcedilla);
        map_keycode (scim::SCIM_KEY_racute, SCIM_BRIDGE_KEY_racute);
        map_keycode (scim::SCIM_KEY_abreve, SCIM_BRIDGE_KEY_abreve);
        map_keycode (scim::SCIM_KEY_lacute, SCIM_BRIDGE_KEY_lacute);
        map_keycode (scim::SCIM_KEY_cacute, SCIM_BRIDGE_KEY_cacute);
        map_keycode (scim::SCIM_KEY_ccaron, SCIM_BRIDGE_KEY_ccaron);
        map_keycode (scim::SCIM_KEY_eogonek, SCIM_BRIDGE_KEY_eogonek);
        map_keycode (scim::SCIM_KEY_ecaron, SCIM_BRIDGE_KEY_ecaron);
        map_keycode (scim::SCIM_KEY_dcaron, SCIM_BRIDGE_KEY_dcaron);
        map_keycode (scim::SCIM_KEY_dstroke, SCIM_BRIDGE_KEY_dstroke);
        map_keycode (scim::SCIM_KEY_nacute, SCIM_BRIDGE_KEY_nacute);
        map_keycode (scim::SCIM_KEY_ncaron, SCIM_BRIDGE_KEY_ncaron);
        map_keycode (scim::SCIM_KEY_odoubleacute, SCIM_BRIDGE_KEY_odoubleacute);
        map_keycode (scim::SCIM_KEY_udoubleacute, SCIM_BRIDGE_KEY_udoubleacute);
        map_keycode (scim::SCIM_KEY_rcaron, SCIM_BRIDGE_KEY_rcaron);
        map_keycode (scim::SCIM_KEY_uring, SCIM_BRIDGE_KEY_uring);
        map_keycode (scim::SCIM_KEY_tcedilla, SCIM_BRIDGE_KEY_tcedilla);
        map_keycode (scim::SCIM_KEY_abovedot, SCIM_BRIDGE_KEY_abovedot);

        /*
         *Latin3
         *Byte3=2
         */
        map_keycode (scim::SCIM_KEY_Hstroke, SCIM_BRIDGE_KEY_Hstroke);
        map_keycode (scim::SCIM_KEY_Hcircumflex, SCIM_BRIDGE_KEY_Hcircumflex);
        map_keycode (scim::SCIM_KEY_Iabovedot, SCIM_BRIDGE_KEY_Iabovedot);
        map_keycode (scim::SCIM_KEY_Gbreve, SCIM_BRIDGE_KEY_Gbreve);
        map_keycode (scim::SCIM_KEY_Jcircumflex, SCIM_BRIDGE_KEY_Jcircumflex);
        map_keycode (scim::SCIM_KEY_hstroke, SCIM_BRIDGE_KEY_hstroke);
        map_keycode (scim::SCIM_KEY_hcircumflex, SCIM_BRIDGE_KEY_hcircumflex);
        map_keycode (scim::SCIM_KEY_idotless, SCIM_BRIDGE_KEY_idotless);
        map_keycode (scim::SCIM_KEY_gbreve, SCIM_BRIDGE_KEY_gbreve);
        map_keycode (scim::SCIM_KEY_jcircumflex, SCIM_BRIDGE_KEY_jcircumflex);
        map_keycode (scim::SCIM_KEY_Cabovedot, SCIM_BRIDGE_KEY_Cabovedot);
        map_keycode (scim::SCIM_KEY_Ccircumflex, SCIM_BRIDGE_KEY_Ccircumflex);
        map_keycode (scim::SCIM_KEY_Gabovedot, SCIM_BRIDGE_KEY_Gabovedot);
        map_keycode (scim::SCIM_KEY_Gcircumflex, SCIM_BRIDGE_KEY_Gcircumflex);
        map_keycode (scim::SCIM_KEY_Ubreve, SCIM_BRIDGE_KEY_Ubreve);
        map_keycode (scim::SCIM_KEY_Scircumflex, SCIM_BRIDGE_KEY_Scircumflex);
        map_keycode (scim::SCIM_KEY_cabovedot, SCIM_BRIDGE_KEY_cabovedot);
        map_keycode (scim::SCIM_KEY_ccircumflex, SCIM_BRIDGE_KEY_ccircumflex);
        map_keycode (scim::SCIM_KEY_gabovedot, SCIM_BRIDGE_KEY_gabovedot);
        map_keycode (scim::SCIM_KEY_gcircumflex, SCIM_BRIDGE_KEY_gcircumflex);
        map_keycode (scim::SCIM_KEY_ubreve, SCIM_BRIDGE_KEY_ubreve);
        map_keycode (scim::SCIM_KEY_scircumflex, SCIM_BRIDGE_KEY_scircumflex);

        /*
         *Latin4
         *Byte3=3
         */
        map_keycode (scim::SCIM_KEY_kra, SCIM_BRIDGE_KEY_kra);
        map_keycode (scim::SCIM_KEY_kappa, SCIM_BRIDGE_KEY_kappa);
        map_keycode (scim::SCIM_KEY_Rcedilla, SCIM_BRIDGE_KEY_Rcedilla);
        map_keycode (scim::SCIM_KEY_Itilde, SCIM_BRIDGE_KEY_Itilde);
        map_keycode (scim::SCIM_KEY_Lcedilla, SCIM_BRIDGE_KEY_Lcedilla);
        map_keycode (scim::SCIM_KEY_Emacron, SCIM_BRIDGE_KEY_Emacron);
        map_keycode (scim::SCIM_KEY_Gcedilla, SCIM_BRIDGE_KEY_Gcedilla);
        map_keycode (scim::SCIM_KEY_Tslash, SCIM_BRIDGE_KEY_Tslash);
        map_keycode (scim::SCIM_KEY_rcedilla, SCIM_BRIDGE_KEY_rcedilla);
        map_keycode (scim::SCIM_KEY_itilde, SCIM_BRIDGE_KEY_itilde);
        map_keycode (scim::SCIM_KEY_lcedilla, SCIM_BRIDGE_KEY_lcedilla);
        map_keycode (scim::SCIM_KEY_emacron, SCIM_BRIDGE_KEY_emacron);
        map_keycode (scim::SCIM_KEY_gcedilla, SCIM_BRIDGE_KEY_gcedilla);
        map_keycode (scim::SCIM_KEY_tslash, SCIM_BRIDGE_KEY_tslash);
        map_keycode (scim::SCIM_KEY_ENG, SCIM_BRIDGE_KEY_ENG);
        map_keycode (scim::SCIM_KEY_eng, SCIM_BRIDGE_KEY_eng);
        map_keycode (scim::SCIM_KEY_Amacron, SCIM_BRIDGE_KEY_Amacron);
        map_keycode (scim::SCIM_KEY_Iogonek, SCIM_BRIDGE_KEY_Iogonek);
        map_keycode (scim::SCIM_KEY_Eabovedot, SCIM_BRIDGE_KEY_Eabovedot);
        map_keycode (scim::SCIM_KEY_Imacron, SCIM_BRIDGE_KEY_Imacron);
        map_keycode (scim::SCIM_KEY_Ncedilla, SCIM_BRIDGE_KEY_Ncedilla);
        map_keycode (scim::SCIM_KEY_Omacron, SCIM_BRIDGE_KEY_Omacron);
        map_keycode (scim::SCIM_KEY_Kcedilla, SCIM_BRIDGE_KEY_Kcedilla);
        map_keycode (scim::SCIM_KEY_Uogonek, SCIM_BRIDGE_KEY_Uogonek);
        map_keycode (scim::SCIM_KEY_Utilde, SCIM_BRIDGE_KEY_Utilde);
        map_keycode (scim::SCIM_KEY_Umacron, SCIM_BRIDGE_KEY_Umacron);
        map_keycode (scim::SCIM_KEY_amacron, SCIM_BRIDGE_KEY_amacron);
        map_keycode (scim::SCIM_KEY_iogonek, SCIM_BRIDGE_KEY_iogonek);
        map_keycode (scim::SCIM_KEY_eabovedot, SCIM_BRIDGE_KEY_eabovedot);
        map_keycode (scim::SCIM_KEY_imacron, SCIM_BRIDGE_KEY_imacron);
        map_keycode (scim::SCIM_KEY_ncedilla, SCIM_BRIDGE_KEY_ncedilla);
        map_keycode (scim::SCIM_KEY_omacron, SCIM_BRIDGE_KEY_omacron);
        map_keycode (scim::SCIM_KEY_kcedilla, SCIM_BRIDGE_KEY_kcedilla);
        map_keycode (scim::SCIM_KEY_uogonek, SCIM_BRIDGE_KEY_uogonek);
        map_keycode (scim::SCIM_KEY_utilde, SCIM_BRIDGE_KEY_utilde);
        map_keycode (scim::SCIM_KEY_umacron, SCIM_BRIDGE_KEY_umacron);

        /*
         *Latin-8
         *Byte3=18
         */
        map_keycode (scim::SCIM_KEY_Babovedot, SCIM_BRIDGE_KEY_Babovedot);
        map_keycode (scim::SCIM_KEY_babovedot, SCIM_BRIDGE_KEY_babovedot);
        map_keycode (scim::SCIM_KEY_Dabovedot, SCIM_BRIDGE_KEY_Dabovedot);
        map_keycode (scim::SCIM_KEY_Wgrave, SCIM_BRIDGE_KEY_Wgrave);
        map_keycode (scim::SCIM_KEY_Wacute, SCIM_BRIDGE_KEY_Wacute);
        map_keycode (scim::SCIM_KEY_dabovedot, SCIM_BRIDGE_KEY_dabovedot);
        map_keycode (scim::SCIM_KEY_Ygrave, SCIM_BRIDGE_KEY_Ygrave);
        map_keycode (scim::SCIM_KEY_Fabovedot, SCIM_BRIDGE_KEY_Fabovedot);
        map_keycode (scim::SCIM_KEY_fabovedot, SCIM_BRIDGE_KEY_fabovedot);
        map_keycode (scim::SCIM_KEY_Mabovedot, SCIM_BRIDGE_KEY_Mabovedot);
        map_keycode (scim::SCIM_KEY_mabovedot, SCIM_BRIDGE_KEY_mabovedot);
        map_keycode (scim::SCIM_KEY_Pabovedot, SCIM_BRIDGE_KEY_Pabovedot);
        map_keycode (scim::SCIM_KEY_wgrave, SCIM_BRIDGE_KEY_wgrave);
        map_keycode (scim::SCIM_KEY_pabovedot, SCIM_BRIDGE_KEY_pabovedot);
        map_keycode (scim::SCIM_KEY_wacute, SCIM_BRIDGE_KEY_wacute);
        map_keycode (scim::SCIM_KEY_Sabovedot, SCIM_BRIDGE_KEY_Sabovedot);
        map_keycode (scim::SCIM_KEY_ygrave, SCIM_BRIDGE_KEY_ygrave);
        map_keycode (scim::SCIM_KEY_Wdiaeresis, SCIM_BRIDGE_KEY_Wdiaeresis);
        map_keycode (scim::SCIM_KEY_wdiaeresis, SCIM_BRIDGE_KEY_wdiaeresis);
        map_keycode (scim::SCIM_KEY_sabovedot, SCIM_BRIDGE_KEY_sabovedot);
        map_keycode (scim::SCIM_KEY_Wcircumflex, SCIM_BRIDGE_KEY_Wcircumflex);
        map_keycode (scim::SCIM_KEY_Tabovedot, SCIM_BRIDGE_KEY_Tabovedot);
        map_keycode (scim::SCIM_KEY_Ycircumflex, SCIM_BRIDGE_KEY_Ycircumflex);
        map_keycode (scim::SCIM_KEY_wcircumflex, SCIM_BRIDGE_KEY_wcircumflex);
        map_keycode (scim::SCIM_KEY_tabovedot, SCIM_BRIDGE_KEY_tabovedot);
        map_keycode (scim::SCIM_KEY_ycircumflex, SCIM_BRIDGE_KEY_ycircumflex);

        /*
         *Latin-9 (a.k.a.Latin-0)
         *Byte3=19
         */

        map_keycode (scim::SCIM_KEY_OE, SCIM_BRIDGE_KEY_OE);
        map_keycode (scim::SCIM_KEY_oe, SCIM_BRIDGE_KEY_oe);
        map_keycode (scim::SCIM_KEY_Ydiaeresis, SCIM_BRIDGE_KEY_Ydiaeresis);

        /*
         *Katakana
         *Byte3=4
         */

        map_keycode (scim::SCIM_KEY_overline, SCIM_BRIDGE_KEY_overline);
        map_keycode (scim::SCIM_KEY_kana_fullstop, SCIM_BRIDGE_KEY_kana_fullstop);
        map_keycode (scim::SCIM_KEY_kana_openingbracket, SCIM_BRIDGE_KEY_kana_openingbracket);
        map_keycode (scim::SCIM_KEY_kana_closingbracket, SCIM_BRIDGE_KEY_kana_closingbracket);
        map_keycode (scim::SCIM_KEY_kana_comma, SCIM_BRIDGE_KEY_kana_comma);
        map_keycode (scim::SCIM_KEY_kana_conjunctive, SCIM_BRIDGE_KEY_kana_conjunctive);
        map_keycode (scim::SCIM_KEY_kana_middledot, SCIM_BRIDGE_KEY_kana_middledot);
        map_keycode (scim::SCIM_KEY_kana_WO, SCIM_BRIDGE_KEY_kana_WO);
        map_keycode (scim::SCIM_KEY_kana_a, SCIM_BRIDGE_KEY_kana_a);
        map_keycode (scim::SCIM_KEY_kana_i, SCIM_BRIDGE_KEY_kana_i);
        map_keycode (scim::SCIM_KEY_kana_u, SCIM_BRIDGE_KEY_kana_u);
        map_keycode (scim::SCIM_KEY_kana_e, SCIM_BRIDGE_KEY_kana_e);
        map_keycode (scim::SCIM_KEY_kana_o, SCIM_BRIDGE_KEY_kana_o);
        map_keycode (scim::SCIM_KEY_kana_ya, SCIM_BRIDGE_KEY_kana_ya);
        map_keycode (scim::SCIM_KEY_kana_yu, SCIM_BRIDGE_KEY_kana_yu);
        map_keycode (scim::SCIM_KEY_kana_yo, SCIM_BRIDGE_KEY_kana_yo);
        map_keycode (scim::SCIM_KEY_kana_tsu, SCIM_BRIDGE_KEY_kana_tsu);
        map_keycode (scim::SCIM_KEY_kana_tu, SCIM_BRIDGE_KEY_kana_tu);
        map_keycode (scim::SCIM_KEY_prolongedsound, SCIM_BRIDGE_KEY_prolongedsound);
        map_keycode (scim::SCIM_KEY_kana_A, SCIM_BRIDGE_KEY_kana_A);
        map_keycode (scim::SCIM_KEY_kana_I, SCIM_BRIDGE_KEY_kana_I);
        map_keycode (scim::SCIM_KEY_kana_U, SCIM_BRIDGE_KEY_kana_U);
        map_keycode (scim::SCIM_KEY_kana_E, SCIM_BRIDGE_KEY_kana_E);
        map_keycode (scim::SCIM_KEY_kana_O, SCIM_BRIDGE_KEY_kana_O);
        map_keycode (scim::SCIM_KEY_kana_KA, SCIM_BRIDGE_KEY_kana_KA);
        map_keycode (scim::SCIM_KEY_kana_KI, SCIM_BRIDGE_KEY_kana_KI);
        map_keycode (scim::SCIM_KEY_kana_KU, SCIM_BRIDGE_KEY_kana_KU);
        map_keycode (scim::SCIM_KEY_kana_KE, SCIM_BRIDGE_KEY_kana_KE);
        map_keycode (scim::SCIM_KEY_kana_KO, SCIM_BRIDGE_KEY_kana_KO);
        map_keycode (scim::SCIM_KEY_kana_SA, SCIM_BRIDGE_KEY_kana_SA);
        map_keycode (scim::SCIM_KEY_kana_SHI, SCIM_BRIDGE_KEY_kana_SHI);
        map_keycode (scim::SCIM_KEY_kana_SU, SCIM_BRIDGE_KEY_kana_SU);
        map_keycode (scim::SCIM_KEY_kana_SE, SCIM_BRIDGE_KEY_kana_SE);
        map_keycode (scim::SCIM_KEY_kana_SO, SCIM_BRIDGE_KEY_kana_SO);
        map_keycode (scim::SCIM_KEY_kana_TA, SCIM_BRIDGE_KEY_kana_TA);
        map_keycode (scim::SCIM_KEY_kana_CHI, SCIM_BRIDGE_KEY_kana_CHI);
        map_keycode (scim::SCIM_KEY_kana_TI, SCIM_BRIDGE_KEY_kana_TI);
        map_keycode (scim::SCIM_KEY_kana_TSU, SCIM_BRIDGE_KEY_kana_TSU);
        map_keycode (scim::SCIM_KEY_kana_TU, SCIM_BRIDGE_KEY_kana_TU);
        map_keycode (scim::SCIM_KEY_kana_TE, SCIM_BRIDGE_KEY_kana_TE);
        map_keycode (scim::SCIM_KEY_kana_TO, SCIM_BRIDGE_KEY_kana_TO);
        map_keycode (scim::SCIM_KEY_kana_NA, SCIM_BRIDGE_KEY_kana_NA);
        map_keycode (scim::SCIM_KEY_kana_NI, SCIM_BRIDGE_KEY_kana_NI);
        map_keycode (scim::SCIM_KEY_kana_NU, SCIM_BRIDGE_KEY_kana_NU);
        map_keycode (scim::SCIM_KEY_kana_NE, SCIM_BRIDGE_KEY_kana_NE);
        map_keycode (scim::SCIM_KEY_kana_NO, SCIM_BRIDGE_KEY_kana_NO);
        map_keycode (scim::SCIM_KEY_kana_HA, SCIM_BRIDGE_KEY_kana_HA);
        map_keycode (scim::SCIM_KEY_kana_HI, SCIM_BRIDGE_KEY_kana_HI);
        map_keycode (scim::SCIM_KEY_kana_FU, SCIM_BRIDGE_KEY_kana_FU);
        map_keycode (scim::SCIM_KEY_kana_HU, SCIM_BRIDGE_KEY_kana_HU);
        map_keycode (scim::SCIM_KEY_kana_HE, SCIM_BRIDGE_KEY_kana_HE);
        map_keycode (scim::SCIM_KEY_kana_HO, SCIM_BRIDGE_KEY_kana_HO);
        map_keycode (scim::SCIM_KEY_kana_MA, SCIM_BRIDGE_KEY_kana_MA);
        map_keycode (scim::SCIM_KEY_kana_MI, SCIM_BRIDGE_KEY_kana_MI);
        map_keycode (scim::SCIM_KEY_kana_MU, SCIM_BRIDGE_KEY_kana_MU);
        map_keycode (scim::SCIM_KEY_kana_ME, SCIM_BRIDGE_KEY_kana_ME);
        map_keycode (scim::SCIM_KEY_kana_MO, SCIM_BRIDGE_KEY_kana_MO);
        map_keycode (scim::SCIM_KEY_kana_YA, SCIM_BRIDGE_KEY_kana_YA);
        map_keycode (scim::SCIM_KEY_kana_YU, SCIM_BRIDGE_KEY_kana_YU);
        map_keycode (scim::SCIM_KEY_kana_YO, SCIM_BRIDGE_KEY_kana_YO);
        map_keycode (scim::SCIM_KEY_kana_RA, SCIM_BRIDGE_KEY_kana_RA);
        map_keycode (scim::SCIM_KEY_kana_RI, SCIM_BRIDGE_KEY_kana_RI);
        map_keycode (scim::SCIM_KEY_kana_RU, SCIM_BRIDGE_KEY_kana_RU);
        map_keycode (scim::SCIM_KEY_kana_RE, SCIM_BRIDGE_KEY_kana_RE);
        map_keycode (scim::SCIM_KEY_kana_RO, SCIM_BRIDGE_KEY_kana_RO);
        map_keycode (scim::SCIM_KEY_kana_WA, SCIM_BRIDGE_KEY_kana_WA);
        map_keycode (scim::SCIM_KEY_kana_N, SCIM_BRIDGE_KEY_kana_N);
        map_keycode (scim::SCIM_KEY_voicedsound, SCIM_BRIDGE_KEY_voicedsound);
        map_keycode (scim::SCIM_KEY_semivoicedsound, SCIM_BRIDGE_KEY_semivoicedsound);
        map_keycode (scim::SCIM_KEY_kana_switch, SCIM_BRIDGE_KEY_kana_switch);

        /*
         *Arabic
         *Byte3=5
         */
        map_keycode (scim::SCIM_KEY_Farsi_0, SCIM_BRIDGE_KEY_Farsi_0);
        map_keycode (scim::SCIM_KEY_Farsi_1, SCIM_BRIDGE_KEY_Farsi_1);
        map_keycode (scim::SCIM_KEY_Farsi_2, SCIM_BRIDGE_KEY_Farsi_2);
        map_keycode (scim::SCIM_KEY_Farsi_3, SCIM_BRIDGE_KEY_Farsi_3);
        map_keycode (scim::SCIM_KEY_Farsi_4, SCIM_BRIDGE_KEY_Farsi_4);
        map_keycode (scim::SCIM_KEY_Farsi_5, SCIM_BRIDGE_KEY_Farsi_5);
        map_keycode (scim::SCIM_KEY_Farsi_6, SCIM_BRIDGE_KEY_Farsi_6);
        map_keycode (scim::SCIM_KEY_Farsi_7, SCIM_BRIDGE_KEY_Farsi_7);
        map_keycode (scim::SCIM_KEY_Farsi_8, SCIM_BRIDGE_KEY_Farsi_8);
        map_keycode (scim::SCIM_KEY_Farsi_9, SCIM_BRIDGE_KEY_Farsi_9);
        map_keycode (scim::SCIM_KEY_Arabic_percent, SCIM_BRIDGE_KEY_Arabic_percent);
        map_keycode (scim::SCIM_KEY_Arabic_superscript_alef, SCIM_BRIDGE_KEY_Arabic_superscript_alef);
        map_keycode (scim::SCIM_KEY_Arabic_tteh, SCIM_BRIDGE_KEY_Arabic_tteh);
        map_keycode (scim::SCIM_KEY_Arabic_peh, SCIM_BRIDGE_KEY_Arabic_peh);
        map_keycode (scim::SCIM_KEY_Arabic_tcheh, SCIM_BRIDGE_KEY_Arabic_tcheh);
        map_keycode (scim::SCIM_KEY_Arabic_ddal, SCIM_BRIDGE_KEY_Arabic_ddal);
        map_keycode (scim::SCIM_KEY_Arabic_rreh, SCIM_BRIDGE_KEY_Arabic_rreh);
        map_keycode (scim::SCIM_KEY_Arabic_comma, SCIM_BRIDGE_KEY_Arabic_comma);
        map_keycode (scim::SCIM_KEY_Arabic_fullstop, SCIM_BRIDGE_KEY_Arabic_fullstop);
        map_keycode (scim::SCIM_KEY_Arabic_0, SCIM_BRIDGE_KEY_Arabic_0);
        map_keycode (scim::SCIM_KEY_Arabic_1, SCIM_BRIDGE_KEY_Arabic_1);
        map_keycode (scim::SCIM_KEY_Arabic_2, SCIM_BRIDGE_KEY_Arabic_2);
        map_keycode (scim::SCIM_KEY_Arabic_3, SCIM_BRIDGE_KEY_Arabic_3);
        map_keycode (scim::SCIM_KEY_Arabic_4, SCIM_BRIDGE_KEY_Arabic_4);
        map_keycode (scim::SCIM_KEY_Arabic_5, SCIM_BRIDGE_KEY_Arabic_5);
        map_keycode (scim::SCIM_KEY_Arabic_6, SCIM_BRIDGE_KEY_Arabic_6);
        map_keycode (scim::SCIM_KEY_Arabic_7, SCIM_BRIDGE_KEY_Arabic_7);
        map_keycode (scim::SCIM_KEY_Arabic_8, SCIM_BRIDGE_KEY_Arabic_8);
        map_keycode (scim::SCIM_KEY_Arabic_9, SCIM_BRIDGE_KEY_Arabic_9);
        map_keycode (scim::SCIM_KEY_Arabic_semicolon, SCIM_BRIDGE_KEY_Arabic_semicolon);
        map_keycode (scim::SCIM_KEY_Arabic_question_mark, SCIM_BRIDGE_KEY_Arabic_question_mark);
        map_keycode (scim::SCIM_KEY_Arabic_hamza, SCIM_BRIDGE_KEY_Arabic_hamza);
        map_keycode (scim::SCIM_KEY_Arabic_maddaonalef, SCIM_BRIDGE_KEY_Arabic_maddaonalef);
        map_keycode (scim::SCIM_KEY_Arabic_hamzaonalef, SCIM_BRIDGE_KEY_Arabic_hamzaonalef);
        map_keycode (scim::SCIM_KEY_Arabic_hamzaonwaw, SCIM_BRIDGE_KEY_Arabic_hamzaonwaw);
        map_keycode (scim::SCIM_KEY_Arabic_hamzaunderalef, SCIM_BRIDGE_KEY_Arabic_hamzaunderalef);
        map_keycode (scim::SCIM_KEY_Arabic_hamzaonyeh, SCIM_BRIDGE_KEY_Arabic_hamzaonyeh);
        map_keycode (scim::SCIM_KEY_Arabic_alef, SCIM_BRIDGE_KEY_Arabic_alef);
        map_keycode (scim::SCIM_KEY_Arabic_beh, SCIM_BRIDGE_KEY_Arabic_beh);
        map_keycode (scim::SCIM_KEY_Arabic_tehmarbuta, SCIM_BRIDGE_KEY_Arabic_tehmarbuta);
        map_keycode (scim::SCIM_KEY_Arabic_teh, SCIM_BRIDGE_KEY_Arabic_teh);
        map_keycode (scim::SCIM_KEY_Arabic_theh, SCIM_BRIDGE_KEY_Arabic_theh);
        map_keycode (scim::SCIM_KEY_Arabic_jeem, SCIM_BRIDGE_KEY_Arabic_jeem);
        map_keycode (scim::SCIM_KEY_Arabic_hah, SCIM_BRIDGE_KEY_Arabic_hah);
        map_keycode (scim::SCIM_KEY_Arabic_khah, SCIM_BRIDGE_KEY_Arabic_khah);
        map_keycode (scim::SCIM_KEY_Arabic_dal, SCIM_BRIDGE_KEY_Arabic_dal);
        map_keycode (scim::SCIM_KEY_Arabic_thal, SCIM_BRIDGE_KEY_Arabic_thal);
        map_keycode (scim::SCIM_KEY_Arabic_ra, SCIM_BRIDGE_KEY_Arabic_ra);
        map_keycode (scim::SCIM_KEY_Arabic_zain, SCIM_BRIDGE_KEY_Arabic_zain);
        map_keycode (scim::SCIM_KEY_Arabic_seen, SCIM_BRIDGE_KEY_Arabic_seen);
        map_keycode (scim::SCIM_KEY_Arabic_sheen, SCIM_BRIDGE_KEY_Arabic_sheen);
        map_keycode (scim::SCIM_KEY_Arabic_sad, SCIM_BRIDGE_KEY_Arabic_sad);
        map_keycode (scim::SCIM_KEY_Arabic_dad, SCIM_BRIDGE_KEY_Arabic_dad);
        map_keycode (scim::SCIM_KEY_Arabic_tah, SCIM_BRIDGE_KEY_Arabic_tah);
        map_keycode (scim::SCIM_KEY_Arabic_zah, SCIM_BRIDGE_KEY_Arabic_zah);
        map_keycode (scim::SCIM_KEY_Arabic_ain, SCIM_BRIDGE_KEY_Arabic_ain);
        map_keycode (scim::SCIM_KEY_Arabic_ghain, SCIM_BRIDGE_KEY_Arabic_ghain);
        map_keycode (scim::SCIM_KEY_Arabic_tatweel, SCIM_BRIDGE_KEY_Arabic_tatweel);
        map_keycode (scim::SCIM_KEY_Arabic_feh, SCIM_BRIDGE_KEY_Arabic_feh);
        map_keycode (scim::SCIM_KEY_Arabic_qaf, SCIM_BRIDGE_KEY_Arabic_qaf);
        map_keycode (scim::SCIM_KEY_Arabic_kaf, SCIM_BRIDGE_KEY_Arabic_kaf);
        map_keycode (scim::SCIM_KEY_Arabic_lam, SCIM_BRIDGE_KEY_Arabic_lam);
        map_keycode (scim::SCIM_KEY_Arabic_meem, SCIM_BRIDGE_KEY_Arabic_meem);
        map_keycode (scim::SCIM_KEY_Arabic_noon, SCIM_BRIDGE_KEY_Arabic_noon);
        map_keycode (scim::SCIM_KEY_Arabic_ha, SCIM_BRIDGE_KEY_Arabic_ha);
        map_keycode (scim::SCIM_KEY_Arabic_heh, SCIM_BRIDGE_KEY_Arabic_heh);
        map_keycode (scim::SCIM_KEY_Arabic_waw, SCIM_BRIDGE_KEY_Arabic_waw);
        map_keycode (scim::SCIM_KEY_Arabic_alefmaksura, SCIM_BRIDGE_KEY_Arabic_alefmaksura);
        map_keycode (scim::SCIM_KEY_Arabic_yeh, SCIM_BRIDGE_KEY_Arabic_yeh);
        map_keycode (scim::SCIM_KEY_Arabic_fathatan, SCIM_BRIDGE_KEY_Arabic_fathatan);
        map_keycode (scim::SCIM_KEY_Arabic_dammatan, SCIM_BRIDGE_KEY_Arabic_dammatan);
        map_keycode (scim::SCIM_KEY_Arabic_kasratan, SCIM_BRIDGE_KEY_Arabic_kasratan);
        map_keycode (scim::SCIM_KEY_Arabic_fatha, SCIM_BRIDGE_KEY_Arabic_fatha);
        map_keycode (scim::SCIM_KEY_Arabic_damma, SCIM_BRIDGE_KEY_Arabic_damma);
        map_keycode (scim::SCIM_KEY_Arabic_kasra, SCIM_BRIDGE_KEY_Arabic_kasra);
        map_keycode (scim::SCIM_KEY_Arabic_shadda, SCIM_BRIDGE_KEY_Arabic_shadda);
        map_keycode (scim::SCIM_KEY_Arabic_sukun, SCIM_BRIDGE_KEY_Arabic_sukun);
        map_keycode (scim::SCIM_KEY_Arabic_madda_above, SCIM_BRIDGE_KEY_Arabic_madda_above);
        map_keycode (scim::SCIM_KEY_Arabic_hamza_above, SCIM_BRIDGE_KEY_Arabic_hamza_above);
        map_keycode (scim::SCIM_KEY_Arabic_hamza_below, SCIM_BRIDGE_KEY_Arabic_hamza_below);
        map_keycode (scim::SCIM_KEY_Arabic_jeh, SCIM_BRIDGE_KEY_Arabic_jeh);
        map_keycode (scim::SCIM_KEY_Arabic_veh, SCIM_BRIDGE_KEY_Arabic_veh);
        map_keycode (scim::SCIM_KEY_Arabic_keheh, SCIM_BRIDGE_KEY_Arabic_keheh);
        map_keycode (scim::SCIM_KEY_Arabic_gaf, SCIM_BRIDGE_KEY_Arabic_gaf);
        map_keycode (scim::SCIM_KEY_Arabic_noon_ghunna, SCIM_BRIDGE_KEY_Arabic_noon_ghunna);
        map_keycode (scim::SCIM_KEY_Arabic_heh_doachashmee, SCIM_BRIDGE_KEY_Arabic_heh_doachashmee);
        map_keycode (scim::SCIM_KEY_Farsi_yeh, SCIM_BRIDGE_KEY_Farsi_yeh);
        map_keycode (scim::SCIM_KEY_Arabic_farsi_yeh, SCIM_BRIDGE_KEY_Arabic_farsi_yeh);
        map_keycode (scim::SCIM_KEY_Arabic_yeh_baree, SCIM_BRIDGE_KEY_Arabic_yeh_baree);
        map_keycode (scim::SCIM_KEY_Arabic_heh_goal, SCIM_BRIDGE_KEY_Arabic_heh_goal);
        map_keycode (scim::SCIM_KEY_Arabic_switch, SCIM_BRIDGE_KEY_Arabic_switch);

        /*
         *Cyrillic
         *Byte3=6
         */
        map_keycode (scim::SCIM_KEY_Cyrillic_GHE_bar, SCIM_BRIDGE_KEY_Cyrillic_GHE_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_ghe_bar, SCIM_BRIDGE_KEY_Cyrillic_ghe_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_ZHE_descender, SCIM_BRIDGE_KEY_Cyrillic_ZHE_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_zhe_descender, SCIM_BRIDGE_KEY_Cyrillic_zhe_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_KA_descender, SCIM_BRIDGE_KEY_Cyrillic_KA_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_ka_descender, SCIM_BRIDGE_KEY_Cyrillic_ka_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_KA_vertstroke, SCIM_BRIDGE_KEY_Cyrillic_KA_vertstroke);
        map_keycode (scim::SCIM_KEY_Cyrillic_ka_vertstroke, SCIM_BRIDGE_KEY_Cyrillic_ka_vertstroke);
        map_keycode (scim::SCIM_KEY_Cyrillic_EN_descender, SCIM_BRIDGE_KEY_Cyrillic_EN_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_en_descender, SCIM_BRIDGE_KEY_Cyrillic_en_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_U_straight, SCIM_BRIDGE_KEY_Cyrillic_U_straight);
        map_keycode (scim::SCIM_KEY_Cyrillic_u_straight, SCIM_BRIDGE_KEY_Cyrillic_u_straight);
        map_keycode (scim::SCIM_KEY_Cyrillic_U_straight_bar, SCIM_BRIDGE_KEY_Cyrillic_U_straight_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_u_straight_bar, SCIM_BRIDGE_KEY_Cyrillic_u_straight_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_HA_descender, SCIM_BRIDGE_KEY_Cyrillic_HA_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_ha_descender, SCIM_BRIDGE_KEY_Cyrillic_ha_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_CHE_descender, SCIM_BRIDGE_KEY_Cyrillic_CHE_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_che_descender, SCIM_BRIDGE_KEY_Cyrillic_che_descender);
        map_keycode (scim::SCIM_KEY_Cyrillic_CHE_vertstroke, SCIM_BRIDGE_KEY_Cyrillic_CHE_vertstroke);
        map_keycode (scim::SCIM_KEY_Cyrillic_che_vertstroke, SCIM_BRIDGE_KEY_Cyrillic_che_vertstroke);
        map_keycode (scim::SCIM_KEY_Cyrillic_SHHA, SCIM_BRIDGE_KEY_Cyrillic_SHHA);
        map_keycode (scim::SCIM_KEY_Cyrillic_shha, SCIM_BRIDGE_KEY_Cyrillic_shha);

        map_keycode (scim::SCIM_KEY_Cyrillic_SCHWA, SCIM_BRIDGE_KEY_Cyrillic_SCHWA);
        map_keycode (scim::SCIM_KEY_Cyrillic_schwa, SCIM_BRIDGE_KEY_Cyrillic_schwa);
        map_keycode (scim::SCIM_KEY_Cyrillic_I_macron, SCIM_BRIDGE_KEY_Cyrillic_I_macron);
        map_keycode (scim::SCIM_KEY_Cyrillic_i_macron, SCIM_BRIDGE_KEY_Cyrillic_i_macron);
        map_keycode (scim::SCIM_KEY_Cyrillic_O_bar, SCIM_BRIDGE_KEY_Cyrillic_O_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_o_bar, SCIM_BRIDGE_KEY_Cyrillic_o_bar);
        map_keycode (scim::SCIM_KEY_Cyrillic_U_macron, SCIM_BRIDGE_KEY_Cyrillic_U_macron);
        map_keycode (scim::SCIM_KEY_Cyrillic_u_macron, SCIM_BRIDGE_KEY_Cyrillic_u_macron);

        map_keycode (scim::SCIM_KEY_Serbian_dje, SCIM_BRIDGE_KEY_Serbian_dje);
        map_keycode (scim::SCIM_KEY_Macedonia_gje, SCIM_BRIDGE_KEY_Macedonia_gje);
        map_keycode (scim::SCIM_KEY_Cyrillic_io, SCIM_BRIDGE_KEY_Cyrillic_io);
        map_keycode (scim::SCIM_KEY_Ukrainian_ie, SCIM_BRIDGE_KEY_Ukrainian_ie);
        map_keycode (scim::SCIM_KEY_Ukranian_je, SCIM_BRIDGE_KEY_Ukranian_je);
        map_keycode (scim::SCIM_KEY_Macedonia_dse, SCIM_BRIDGE_KEY_Macedonia_dse);
        map_keycode (scim::SCIM_KEY_Ukrainian_i, SCIM_BRIDGE_KEY_Ukrainian_i);
        map_keycode (scim::SCIM_KEY_Ukranian_i, SCIM_BRIDGE_KEY_Ukranian_i);
        map_keycode (scim::SCIM_KEY_Ukrainian_yi, SCIM_BRIDGE_KEY_Ukrainian_yi);
        map_keycode (scim::SCIM_KEY_Ukranian_yi, SCIM_BRIDGE_KEY_Ukranian_yi);
        map_keycode (scim::SCIM_KEY_Cyrillic_je, SCIM_BRIDGE_KEY_Cyrillic_je);
        map_keycode (scim::SCIM_KEY_Serbian_je, SCIM_BRIDGE_KEY_Serbian_je);
        map_keycode (scim::SCIM_KEY_Cyrillic_lje, SCIM_BRIDGE_KEY_Cyrillic_lje);
        map_keycode (scim::SCIM_KEY_Serbian_lje, SCIM_BRIDGE_KEY_Serbian_lje);
        map_keycode (scim::SCIM_KEY_Cyrillic_nje, SCIM_BRIDGE_KEY_Cyrillic_nje);
        map_keycode (scim::SCIM_KEY_Serbian_nje, SCIM_BRIDGE_KEY_Serbian_nje);
        map_keycode (scim::SCIM_KEY_Serbian_tshe, SCIM_BRIDGE_KEY_Serbian_tshe);
        map_keycode (scim::SCIM_KEY_Macedonia_kje, SCIM_BRIDGE_KEY_Macedonia_kje);
        map_keycode (scim::SCIM_KEY_Ukrainian_ghe_with_upturn, SCIM_BRIDGE_KEY_Ukrainian_ghe_with_upturn);
        map_keycode (scim::SCIM_KEY_Byelorussian_shortu, SCIM_BRIDGE_KEY_Byelorussian_shortu);
        map_keycode (scim::SCIM_KEY_Cyrillic_dzhe, SCIM_BRIDGE_KEY_Cyrillic_dzhe);
        map_keycode (scim::SCIM_KEY_Serbian_dze, SCIM_BRIDGE_KEY_Serbian_dze);
        map_keycode (scim::SCIM_KEY_numerosign, SCIM_BRIDGE_KEY_numerosign);
        map_keycode (scim::SCIM_KEY_Serbian_DJE, SCIM_BRIDGE_KEY_Serbian_DJE);
        map_keycode (scim::SCIM_KEY_Macedonia_GJE, SCIM_BRIDGE_KEY_Macedonia_GJE);
        map_keycode (scim::SCIM_KEY_Cyrillic_IO, SCIM_BRIDGE_KEY_Cyrillic_IO);
        map_keycode (scim::SCIM_KEY_Ukrainian_IE, SCIM_BRIDGE_KEY_Ukrainian_IE);
        map_keycode (scim::SCIM_KEY_Ukranian_JE, SCIM_BRIDGE_KEY_Ukranian_JE);
        map_keycode (scim::SCIM_KEY_Macedonia_DSE, SCIM_BRIDGE_KEY_Macedonia_DSE);
        map_keycode (scim::SCIM_KEY_Ukrainian_I, SCIM_BRIDGE_KEY_Ukrainian_I);
        map_keycode (scim::SCIM_KEY_Ukranian_I, SCIM_BRIDGE_KEY_Ukranian_I);
        map_keycode (scim::SCIM_KEY_Ukrainian_YI, SCIM_BRIDGE_KEY_Ukrainian_YI);
        map_keycode (scim::SCIM_KEY_Ukranian_YI, SCIM_BRIDGE_KEY_Ukranian_YI);
        map_keycode (scim::SCIM_KEY_Cyrillic_JE, SCIM_BRIDGE_KEY_Cyrillic_JE);
        map_keycode (scim::SCIM_KEY_Serbian_JE, SCIM_BRIDGE_KEY_Serbian_JE);
        map_keycode (scim::SCIM_KEY_Cyrillic_LJE, SCIM_BRIDGE_KEY_Cyrillic_LJE);
        map_keycode (scim::SCIM_KEY_Serbian_LJE, SCIM_BRIDGE_KEY_Serbian_LJE);
        map_keycode (scim::SCIM_KEY_Cyrillic_NJE, SCIM_BRIDGE_KEY_Cyrillic_NJE);
        map_keycode (scim::SCIM_KEY_Serbian_NJE, SCIM_BRIDGE_KEY_Serbian_NJE);
        map_keycode (scim::SCIM_KEY_Serbian_TSHE, SCIM_BRIDGE_KEY_Serbian_TSHE);
        map_keycode (scim::SCIM_KEY_Macedonia_KJE, SCIM_BRIDGE_KEY_Macedonia_KJE);
        map_keycode (scim::SCIM_KEY_Ukrainian_GHE_WITH_UPTURN, SCIM_BRIDGE_KEY_Ukrainian_GHE_WITH_UPTURN);
        map_keycode (scim::SCIM_KEY_Byelorussian_SHORTU, SCIM_BRIDGE_KEY_Byelorussian_SHORTU);
        map_keycode (scim::SCIM_KEY_Cyrillic_DZHE, SCIM_BRIDGE_KEY_Cyrillic_DZHE);
        map_keycode (scim::SCIM_KEY_Serbian_DZE, SCIM_BRIDGE_KEY_Serbian_DZE);
        map_keycode (scim::SCIM_KEY_Cyrillic_yu, SCIM_BRIDGE_KEY_Cyrillic_yu);
        map_keycode (scim::SCIM_KEY_Cyrillic_a, SCIM_BRIDGE_KEY_Cyrillic_a);
        map_keycode (scim::SCIM_KEY_Cyrillic_be, SCIM_BRIDGE_KEY_Cyrillic_be);
        map_keycode (scim::SCIM_KEY_Cyrillic_tse, SCIM_BRIDGE_KEY_Cyrillic_tse);
        map_keycode (scim::SCIM_KEY_Cyrillic_de, SCIM_BRIDGE_KEY_Cyrillic_de);
        map_keycode (scim::SCIM_KEY_Cyrillic_ie, SCIM_BRIDGE_KEY_Cyrillic_ie);
        map_keycode (scim::SCIM_KEY_Cyrillic_ef, SCIM_BRIDGE_KEY_Cyrillic_ef);
        map_keycode (scim::SCIM_KEY_Cyrillic_ghe, SCIM_BRIDGE_KEY_Cyrillic_ghe);
        map_keycode (scim::SCIM_KEY_Cyrillic_ha, SCIM_BRIDGE_KEY_Cyrillic_ha);
        map_keycode (scim::SCIM_KEY_Cyrillic_i, SCIM_BRIDGE_KEY_Cyrillic_i);
        map_keycode (scim::SCIM_KEY_Cyrillic_shorti, SCIM_BRIDGE_KEY_Cyrillic_shorti);
        map_keycode (scim::SCIM_KEY_Cyrillic_ka, SCIM_BRIDGE_KEY_Cyrillic_ka);
        map_keycode (scim::SCIM_KEY_Cyrillic_el, SCIM_BRIDGE_KEY_Cyrillic_el);
        map_keycode (scim::SCIM_KEY_Cyrillic_em, SCIM_BRIDGE_KEY_Cyrillic_em);
        map_keycode (scim::SCIM_KEY_Cyrillic_en, SCIM_BRIDGE_KEY_Cyrillic_en);
        map_keycode (scim::SCIM_KEY_Cyrillic_o, SCIM_BRIDGE_KEY_Cyrillic_o);
        map_keycode (scim::SCIM_KEY_Cyrillic_pe, SCIM_BRIDGE_KEY_Cyrillic_pe);
        map_keycode (scim::SCIM_KEY_Cyrillic_ya, SCIM_BRIDGE_KEY_Cyrillic_ya);
        map_keycode (scim::SCIM_KEY_Cyrillic_er, SCIM_BRIDGE_KEY_Cyrillic_er);
        map_keycode (scim::SCIM_KEY_Cyrillic_es, SCIM_BRIDGE_KEY_Cyrillic_es);
        map_keycode (scim::SCIM_KEY_Cyrillic_te, SCIM_BRIDGE_KEY_Cyrillic_te);
        map_keycode (scim::SCIM_KEY_Cyrillic_u, SCIM_BRIDGE_KEY_Cyrillic_u);
        map_keycode (scim::SCIM_KEY_Cyrillic_zhe, SCIM_BRIDGE_KEY_Cyrillic_zhe);
        map_keycode (scim::SCIM_KEY_Cyrillic_ve, SCIM_BRIDGE_KEY_Cyrillic_ve);
        map_keycode (scim::SCIM_KEY_Cyrillic_softsign, SCIM_BRIDGE_KEY_Cyrillic_softsign);
        map_keycode (scim::SCIM_KEY_Cyrillic_yeru, SCIM_BRIDGE_KEY_Cyrillic_yeru);
        map_keycode (scim::SCIM_KEY_Cyrillic_ze, SCIM_BRIDGE_KEY_Cyrillic_ze);
        map_keycode (scim::SCIM_KEY_Cyrillic_sha, SCIM_BRIDGE_KEY_Cyrillic_sha);
        map_keycode (scim::SCIM_KEY_Cyrillic_e, SCIM_BRIDGE_KEY_Cyrillic_e);
        map_keycode (scim::SCIM_KEY_Cyrillic_shcha, SCIM_BRIDGE_KEY_Cyrillic_shcha);
        map_keycode (scim::SCIM_KEY_Cyrillic_che, SCIM_BRIDGE_KEY_Cyrillic_che);
        map_keycode (scim::SCIM_KEY_Cyrillic_hardsign, SCIM_BRIDGE_KEY_Cyrillic_hardsign);
        map_keycode (scim::SCIM_KEY_Cyrillic_YU, SCIM_BRIDGE_KEY_Cyrillic_YU);
        map_keycode (scim::SCIM_KEY_Cyrillic_A, SCIM_BRIDGE_KEY_Cyrillic_A);
        map_keycode (scim::SCIM_KEY_Cyrillic_BE, SCIM_BRIDGE_KEY_Cyrillic_BE);
        map_keycode (scim::SCIM_KEY_Cyrillic_TSE, SCIM_BRIDGE_KEY_Cyrillic_TSE);
        map_keycode (scim::SCIM_KEY_Cyrillic_DE, SCIM_BRIDGE_KEY_Cyrillic_DE);
        map_keycode (scim::SCIM_KEY_Cyrillic_IE, SCIM_BRIDGE_KEY_Cyrillic_IE);
        map_keycode (scim::SCIM_KEY_Cyrillic_EF, SCIM_BRIDGE_KEY_Cyrillic_EF);
        map_keycode (scim::SCIM_KEY_Cyrillic_GHE, SCIM_BRIDGE_KEY_Cyrillic_GHE);
        map_keycode (scim::SCIM_KEY_Cyrillic_HA, SCIM_BRIDGE_KEY_Cyrillic_HA);
        map_keycode (scim::SCIM_KEY_Cyrillic_I, SCIM_BRIDGE_KEY_Cyrillic_I);
        map_keycode (scim::SCIM_KEY_Cyrillic_SHORTI, SCIM_BRIDGE_KEY_Cyrillic_SHORTI);
        map_keycode (scim::SCIM_KEY_Cyrillic_KA, SCIM_BRIDGE_KEY_Cyrillic_KA);
        map_keycode (scim::SCIM_KEY_Cyrillic_EL, SCIM_BRIDGE_KEY_Cyrillic_EL);
        map_keycode (scim::SCIM_KEY_Cyrillic_EM, SCIM_BRIDGE_KEY_Cyrillic_EM);
        map_keycode (scim::SCIM_KEY_Cyrillic_EN, SCIM_BRIDGE_KEY_Cyrillic_EN);
        map_keycode (scim::SCIM_KEY_Cyrillic_O, SCIM_BRIDGE_KEY_Cyrillic_O);
        map_keycode (scim::SCIM_KEY_Cyrillic_PE, SCIM_BRIDGE_KEY_Cyrillic_PE);
        map_keycode (scim::SCIM_KEY_Cyrillic_YA, SCIM_BRIDGE_KEY_Cyrillic_YA);
        map_keycode (scim::SCIM_KEY_Cyrillic_ER, SCIM_BRIDGE_KEY_Cyrillic_ER);
        map_keycode (scim::SCIM_KEY_Cyrillic_ES, SCIM_BRIDGE_KEY_Cyrillic_ES);
        map_keycode (scim::SCIM_KEY_Cyrillic_TE, SCIM_BRIDGE_KEY_Cyrillic_TE);
        map_keycode (scim::SCIM_KEY_Cyrillic_U, SCIM_BRIDGE_KEY_Cyrillic_U);
        map_keycode (scim::SCIM_KEY_Cyrillic_ZHE, SCIM_BRIDGE_KEY_Cyrillic_ZHE);
        map_keycode (scim::SCIM_KEY_Cyrillic_VE, SCIM_BRIDGE_KEY_Cyrillic_VE);
        map_keycode (scim::SCIM_KEY_Cyrillic_SOFTSIGN, SCIM_BRIDGE_KEY_Cyrillic_SOFTSIGN);
        map_keycode (scim::SCIM_KEY_Cyrillic_YERU, SCIM_BRIDGE_KEY_Cyrillic_YERU);
        map_keycode (scim::SCIM_KEY_Cyrillic_ZE, SCIM_BRIDGE_KEY_Cyrillic_ZE);
        map_keycode (scim::SCIM_KEY_Cyrillic_SHA, SCIM_BRIDGE_KEY_Cyrillic_SHA);
        map_keycode (scim::SCIM_KEY_Cyrillic_E, SCIM_BRIDGE_KEY_Cyrillic_E);
        map_keycode (scim::SCIM_KEY_Cyrillic_SHCHA, SCIM_BRIDGE_KEY_Cyrillic_SHCHA);
        map_keycode (scim::SCIM_KEY_Cyrillic_CHE, SCIM_BRIDGE_KEY_Cyrillic_CHE);
        map_keycode (scim::SCIM_KEY_Cyrillic_HARDSIGN, SCIM_BRIDGE_KEY_Cyrillic_HARDSIGN);

        /*
         *Greek
         *Byte3=7
         */
        map_keycode (scim::SCIM_KEY_Greek_ALPHAaccent, SCIM_BRIDGE_KEY_Greek_ALPHAaccent);
        map_keycode (scim::SCIM_KEY_Greek_EPSILONaccent, SCIM_BRIDGE_KEY_Greek_EPSILONaccent);
        map_keycode (scim::SCIM_KEY_Greek_ETAaccent, SCIM_BRIDGE_KEY_Greek_ETAaccent);
        map_keycode (scim::SCIM_KEY_Greek_IOTAaccent, SCIM_BRIDGE_KEY_Greek_IOTAaccent);
        map_keycode (scim::SCIM_KEY_Greek_IOTAdieresis, SCIM_BRIDGE_KEY_Greek_IOTAdieresis);
        map_keycode (scim::SCIM_KEY_Greek_IOTAdiaeresis, SCIM_BRIDGE_KEY_Greek_IOTAdiaeresis);
        map_keycode (scim::SCIM_KEY_Greek_OMICRONaccent, SCIM_BRIDGE_KEY_Greek_OMICRONaccent);
        map_keycode (scim::SCIM_KEY_Greek_UPSILONaccent, SCIM_BRIDGE_KEY_Greek_UPSILONaccent);
        map_keycode (scim::SCIM_KEY_Greek_UPSILONdieresis, SCIM_BRIDGE_KEY_Greek_UPSILONdieresis);
        map_keycode (scim::SCIM_KEY_Greek_OMEGAaccent, SCIM_BRIDGE_KEY_Greek_OMEGAaccent);
        map_keycode (scim::SCIM_KEY_Greek_accentdieresis, SCIM_BRIDGE_KEY_Greek_accentdieresis);
        map_keycode (scim::SCIM_KEY_Greek_horizbar, SCIM_BRIDGE_KEY_Greek_horizbar);
        map_keycode (scim::SCIM_KEY_Greek_alphaaccent, SCIM_BRIDGE_KEY_Greek_alphaaccent);
        map_keycode (scim::SCIM_KEY_Greek_epsilonaccent, SCIM_BRIDGE_KEY_Greek_epsilonaccent);
        map_keycode (scim::SCIM_KEY_Greek_etaaccent, SCIM_BRIDGE_KEY_Greek_etaaccent);
        map_keycode (scim::SCIM_KEY_Greek_iotaaccent, SCIM_BRIDGE_KEY_Greek_iotaaccent);
        map_keycode (scim::SCIM_KEY_Greek_iotadieresis, SCIM_BRIDGE_KEY_Greek_iotadieresis);
        map_keycode (scim::SCIM_KEY_Greek_iotaaccentdieresis, SCIM_BRIDGE_KEY_Greek_iotaaccentdieresis);
        map_keycode (scim::SCIM_KEY_Greek_omicronaccent, SCIM_BRIDGE_KEY_Greek_omicronaccent);
        map_keycode (scim::SCIM_KEY_Greek_upsilonaccent, SCIM_BRIDGE_KEY_Greek_upsilonaccent);
        map_keycode (scim::SCIM_KEY_Greek_upsilondieresis, SCIM_BRIDGE_KEY_Greek_upsilondieresis);
        map_keycode (scim::SCIM_KEY_Greek_upsilonaccentdieresis, SCIM_BRIDGE_KEY_Greek_upsilonaccentdieresis);
        map_keycode (scim::SCIM_KEY_Greek_omegaaccent, SCIM_BRIDGE_KEY_Greek_omegaaccent);
        map_keycode (scim::SCIM_KEY_Greek_ALPHA, SCIM_BRIDGE_KEY_Greek_ALPHA);
        map_keycode (scim::SCIM_KEY_Greek_BETA, SCIM_BRIDGE_KEY_Greek_BETA);
        map_keycode (scim::SCIM_KEY_Greek_GAMMA, SCIM_BRIDGE_KEY_Greek_GAMMA);
        map_keycode (scim::SCIM_KEY_Greek_DELTA, SCIM_BRIDGE_KEY_Greek_DELTA);
        map_keycode (scim::SCIM_KEY_Greek_EPSILON, SCIM_BRIDGE_KEY_Greek_EPSILON);
        map_keycode (scim::SCIM_KEY_Greek_ZETA, SCIM_BRIDGE_KEY_Greek_ZETA);
        map_keycode (scim::SCIM_KEY_Greek_ETA, SCIM_BRIDGE_KEY_Greek_ETA);
        map_keycode (scim::SCIM_KEY_Greek_THETA, SCIM_BRIDGE_KEY_Greek_THETA);
        map_keycode (scim::SCIM_KEY_Greek_IOTA, SCIM_BRIDGE_KEY_Greek_IOTA);
        map_keycode (scim::SCIM_KEY_Greek_KAPPA, SCIM_BRIDGE_KEY_Greek_KAPPA);
        map_keycode (scim::SCIM_KEY_Greek_LAMDA, SCIM_BRIDGE_KEY_Greek_LAMDA);
        map_keycode (scim::SCIM_KEY_Greek_LAMBDA, SCIM_BRIDGE_KEY_Greek_LAMBDA);
        map_keycode (scim::SCIM_KEY_Greek_MU, SCIM_BRIDGE_KEY_Greek_MU);
        map_keycode (scim::SCIM_KEY_Greek_NU, SCIM_BRIDGE_KEY_Greek_NU);
        map_keycode (scim::SCIM_KEY_Greek_XI, SCIM_BRIDGE_KEY_Greek_XI);
        map_keycode (scim::SCIM_KEY_Greek_OMICRON, SCIM_BRIDGE_KEY_Greek_OMICRON);
        map_keycode (scim::SCIM_KEY_Greek_PI, SCIM_BRIDGE_KEY_Greek_PI);
        map_keycode (scim::SCIM_KEY_Greek_RHO, SCIM_BRIDGE_KEY_Greek_RHO);
        map_keycode (scim::SCIM_KEY_Greek_SIGMA, SCIM_BRIDGE_KEY_Greek_SIGMA);
        map_keycode (scim::SCIM_KEY_Greek_TAU, SCIM_BRIDGE_KEY_Greek_TAU);
        map_keycode (scim::SCIM_KEY_Greek_UPSILON, SCIM_BRIDGE_KEY_Greek_UPSILON);
        map_keycode (scim::SCIM_KEY_Greek_PHI, SCIM_BRIDGE_KEY_Greek_PHI);
        map_keycode (scim::SCIM_KEY_Greek_CHI, SCIM_BRIDGE_KEY_Greek_CHI);
        map_keycode (scim::SCIM_KEY_Greek_PSI, SCIM_BRIDGE_KEY_Greek_PSI);
        map_keycode (scim::SCIM_KEY_Greek_OMEGA, SCIM_BRIDGE_KEY_Greek_OMEGA);
        map_keycode (scim::SCIM_KEY_Greek_alpha, SCIM_BRIDGE_KEY_Greek_alpha);
        map_keycode (scim::SCIM_KEY_Greek_beta, SCIM_BRIDGE_KEY_Greek_beta);
        map_keycode (scim::SCIM_KEY_Greek_gamma, SCIM_BRIDGE_KEY_Greek_gamma);
        map_keycode (scim::SCIM_KEY_Greek_delta, SCIM_BRIDGE_KEY_Greek_delta);
        map_keycode (scim::SCIM_KEY_Greek_epsilon, SCIM_BRIDGE_KEY_Greek_epsilon);
        map_keycode (scim::SCIM_KEY_Greek_zeta, SCIM_BRIDGE_KEY_Greek_zeta);
        map_keycode (scim::SCIM_KEY_Greek_eta, SCIM_BRIDGE_KEY_Greek_eta);
        map_keycode (scim::SCIM_KEY_Greek_theta, SCIM_BRIDGE_KEY_Greek_theta);
        map_keycode (scim::SCIM_KEY_Greek_iota, SCIM_BRIDGE_KEY_Greek_iota);
        map_keycode (scim::SCIM_KEY_Greek_kappa, SCIM_BRIDGE_KEY_Greek_kappa);
        map_keycode (scim::SCIM_KEY_Greek_lamda, SCIM_BRIDGE_KEY_Greek_lamda);
        map_keycode (scim::SCIM_KEY_Greek_lambda, SCIM_BRIDGE_KEY_Greek_lambda);
        map_keycode (scim::SCIM_KEY_Greek_mu, SCIM_BRIDGE_KEY_Greek_mu);
        map_keycode (scim::SCIM_KEY_Greek_nu, SCIM_BRIDGE_KEY_Greek_nu);
        map_keycode (scim::SCIM_KEY_Greek_xi, SCIM_BRIDGE_KEY_Greek_xi);
        map_keycode (scim::SCIM_KEY_Greek_omicron, SCIM_BRIDGE_KEY_Greek_omicron);
        map_keycode (scim::SCIM_KEY_Greek_pi, SCIM_BRIDGE_KEY_Greek_pi);
        map_keycode (scim::SCIM_KEY_Greek_rho, SCIM_BRIDGE_KEY_Greek_rho);
        map_keycode (scim::SCIM_KEY_Greek_sigma, SCIM_BRIDGE_KEY_Greek_sigma);
        map_keycode (scim::SCIM_KEY_Greek_finalsmallsigma, SCIM_BRIDGE_KEY_Greek_finalsmallsigma);
        map_keycode (scim::SCIM_KEY_Greek_tau, SCIM_BRIDGE_KEY_Greek_tau);
        map_keycode (scim::SCIM_KEY_Greek_upsilon, SCIM_BRIDGE_KEY_Greek_upsilon);
        map_keycode (scim::SCIM_KEY_Greek_phi, SCIM_BRIDGE_KEY_Greek_phi);
        map_keycode (scim::SCIM_KEY_Greek_chi, SCIM_BRIDGE_KEY_Greek_chi);
        map_keycode (scim::SCIM_KEY_Greek_psi, SCIM_BRIDGE_KEY_Greek_psi);
        map_keycode (scim::SCIM_KEY_Greek_omega, SCIM_BRIDGE_KEY_Greek_omega);
        map_keycode (scim::SCIM_KEY_Greek_switch, SCIM_BRIDGE_KEY_Greek_switch);

        /*
         *Technical
         *Byte3=8
         */
        map_keycode (scim::SCIM_KEY_leftradical, SCIM_BRIDGE_KEY_leftradical);
        map_keycode (scim::SCIM_KEY_topleftradical, SCIM_BRIDGE_KEY_topleftradical);
        map_keycode (scim::SCIM_KEY_horizconnector, SCIM_BRIDGE_KEY_horizconnector);
        map_keycode (scim::SCIM_KEY_topintegral, SCIM_BRIDGE_KEY_topintegral);
        map_keycode (scim::SCIM_KEY_botintegral, SCIM_BRIDGE_KEY_botintegral);
        map_keycode (scim::SCIM_KEY_vertconnector, SCIM_BRIDGE_KEY_vertconnector);
        map_keycode (scim::SCIM_KEY_topleftsqbracket, SCIM_BRIDGE_KEY_topleftsqbracket);
        map_keycode (scim::SCIM_KEY_botleftsqbracket, SCIM_BRIDGE_KEY_botleftsqbracket);
        map_keycode (scim::SCIM_KEY_toprightsqbracket, SCIM_BRIDGE_KEY_toprightsqbracket);
        map_keycode (scim::SCIM_KEY_botrightsqbracket, SCIM_BRIDGE_KEY_botrightsqbracket);
        map_keycode (scim::SCIM_KEY_topleftparens, SCIM_BRIDGE_KEY_topleftparens);
        map_keycode (scim::SCIM_KEY_botleftparens, SCIM_BRIDGE_KEY_botleftparens);
        map_keycode (scim::SCIM_KEY_toprightparens, SCIM_BRIDGE_KEY_toprightparens);
        map_keycode (scim::SCIM_KEY_botrightparens, SCIM_BRIDGE_KEY_botrightparens);
        map_keycode (scim::SCIM_KEY_leftmiddlecurlybrace, SCIM_BRIDGE_KEY_leftmiddlecurlybrace);
        map_keycode (scim::SCIM_KEY_rightmiddlecurlybrace, SCIM_BRIDGE_KEY_rightmiddlecurlybrace);
        map_keycode (scim::SCIM_KEY_topleftsummation, SCIM_BRIDGE_KEY_topleftsummation);
        map_keycode (scim::SCIM_KEY_botleftsummation, SCIM_BRIDGE_KEY_botleftsummation);
        map_keycode (scim::SCIM_KEY_topvertsummationconnector, SCIM_BRIDGE_KEY_topvertsummationconnector);
        map_keycode (scim::SCIM_KEY_botvertsummationconnector, SCIM_BRIDGE_KEY_botvertsummationconnector);
        map_keycode (scim::SCIM_KEY_toprightsummation, SCIM_BRIDGE_KEY_toprightsummation);
        map_keycode (scim::SCIM_KEY_botrightsummation, SCIM_BRIDGE_KEY_botrightsummation);
        map_keycode (scim::SCIM_KEY_rightmiddlesummation, SCIM_BRIDGE_KEY_rightmiddlesummation);
        map_keycode (scim::SCIM_KEY_lessthanequal, SCIM_BRIDGE_KEY_lessthanequal);
        map_keycode (scim::SCIM_KEY_notequal, SCIM_BRIDGE_KEY_notequal);
        map_keycode (scim::SCIM_KEY_greaterthanequal, SCIM_BRIDGE_KEY_greaterthanequal);
        map_keycode (scim::SCIM_KEY_integral, SCIM_BRIDGE_KEY_integral);
        map_keycode (scim::SCIM_KEY_therefore, SCIM_BRIDGE_KEY_therefore);
        map_keycode (scim::SCIM_KEY_variation, SCIM_BRIDGE_KEY_variation);
        map_keycode (scim::SCIM_KEY_infinity, SCIM_BRIDGE_KEY_infinity);
        map_keycode (scim::SCIM_KEY_nabla, SCIM_BRIDGE_KEY_nabla);
        map_keycode (scim::SCIM_KEY_approximate, SCIM_BRIDGE_KEY_approximate);
        map_keycode (scim::SCIM_KEY_similarequal, SCIM_BRIDGE_KEY_similarequal);
        map_keycode (scim::SCIM_KEY_ifonlyif, SCIM_BRIDGE_KEY_ifonlyif);
        map_keycode (scim::SCIM_KEY_implies, SCIM_BRIDGE_KEY_implies);
        map_keycode (scim::SCIM_KEY_identical, SCIM_BRIDGE_KEY_identical);
        map_keycode (scim::SCIM_KEY_radical, SCIM_BRIDGE_KEY_radical);
        map_keycode (scim::SCIM_KEY_includedin, SCIM_BRIDGE_KEY_includedin);
        map_keycode (scim::SCIM_KEY_includes, SCIM_BRIDGE_KEY_includes);
        map_keycode (scim::SCIM_KEY_intersection, SCIM_BRIDGE_KEY_intersection);
        map_keycode (scim::SCIM_KEY_union, SCIM_BRIDGE_KEY_union);
        map_keycode (scim::SCIM_KEY_logicaland, SCIM_BRIDGE_KEY_logicaland);
        map_keycode (scim::SCIM_KEY_logicalor, SCIM_BRIDGE_KEY_logicalor);
        map_keycode (scim::SCIM_KEY_partialderivative, SCIM_BRIDGE_KEY_partialderivative);
        map_keycode (scim::SCIM_KEY_function, SCIM_BRIDGE_KEY_function);
        map_keycode (scim::SCIM_KEY_leftarrow, SCIM_BRIDGE_KEY_leftarrow);
        map_keycode (scim::SCIM_KEY_uparrow, SCIM_BRIDGE_KEY_uparrow);
        map_keycode (scim::SCIM_KEY_rightarrow, SCIM_BRIDGE_KEY_rightarrow);
        map_keycode (scim::SCIM_KEY_downarrow, SCIM_BRIDGE_KEY_downarrow);

        /*
         *Special
         *Byte3=9
         */
        map_keycode (scim::SCIM_KEY_blank, SCIM_BRIDGE_KEY_blank);
        map_keycode (scim::SCIM_KEY_soliddiamond, SCIM_BRIDGE_KEY_soliddiamond);
        map_keycode (scim::SCIM_KEY_checkerboard, SCIM_BRIDGE_KEY_checkerboard);
        map_keycode (scim::SCIM_KEY_ht, SCIM_BRIDGE_KEY_ht);
        map_keycode (scim::SCIM_KEY_ff, SCIM_BRIDGE_KEY_ff);
        map_keycode (scim::SCIM_KEY_cr, SCIM_BRIDGE_KEY_cr);
        map_keycode (scim::SCIM_KEY_lf, SCIM_BRIDGE_KEY_lf);
        map_keycode (scim::SCIM_KEY_nl, SCIM_BRIDGE_KEY_nl);
        map_keycode (scim::SCIM_KEY_vt, SCIM_BRIDGE_KEY_vt);
        map_keycode (scim::SCIM_KEY_lowrightcorner, SCIM_BRIDGE_KEY_lowrightcorner);
        map_keycode (scim::SCIM_KEY_uprightcorner, SCIM_BRIDGE_KEY_uprightcorner);
        map_keycode (scim::SCIM_KEY_upleftcorner, SCIM_BRIDGE_KEY_upleftcorner);
        map_keycode (scim::SCIM_KEY_lowleftcorner, SCIM_BRIDGE_KEY_lowleftcorner);
        map_keycode (scim::SCIM_KEY_crossinglines, SCIM_BRIDGE_KEY_crossinglines);
        map_keycode (scim::SCIM_KEY_horizlinescan1, SCIM_BRIDGE_KEY_horizlinescan1);
        map_keycode (scim::SCIM_KEY_horizlinescan3, SCIM_BRIDGE_KEY_horizlinescan3);
        map_keycode (scim::SCIM_KEY_horizlinescan5, SCIM_BRIDGE_KEY_horizlinescan5);
        map_keycode (scim::SCIM_KEY_horizlinescan7, SCIM_BRIDGE_KEY_horizlinescan7);
        map_keycode (scim::SCIM_KEY_horizlinescan9, SCIM_BRIDGE_KEY_horizlinescan9);
        map_keycode (scim::SCIM_KEY_leftt, SCIM_BRIDGE_KEY_leftt);
        map_keycode (scim::SCIM_KEY_rightt, SCIM_BRIDGE_KEY_rightt);
        map_keycode (scim::SCIM_KEY_bott, SCIM_BRIDGE_KEY_bott);
        map_keycode (scim::SCIM_KEY_topt, SCIM_BRIDGE_KEY_topt);
        map_keycode (scim::SCIM_KEY_vertbar, SCIM_BRIDGE_KEY_vertbar);

        /*
         *Publishing
         *Byte3=a
         */
        map_keycode (scim::SCIM_KEY_emspace, SCIM_BRIDGE_KEY_emspace);
        map_keycode (scim::SCIM_KEY_enspace, SCIM_BRIDGE_KEY_enspace);
        map_keycode (scim::SCIM_KEY_em3space, SCIM_BRIDGE_KEY_em3space);
        map_keycode (scim::SCIM_KEY_em4space, SCIM_BRIDGE_KEY_em4space);
        map_keycode (scim::SCIM_KEY_digitspace, SCIM_BRIDGE_KEY_digitspace);
        map_keycode (scim::SCIM_KEY_punctspace, SCIM_BRIDGE_KEY_punctspace);
        map_keycode (scim::SCIM_KEY_thinspace, SCIM_BRIDGE_KEY_thinspace);
        map_keycode (scim::SCIM_KEY_hairspace, SCIM_BRIDGE_KEY_hairspace);
        map_keycode (scim::SCIM_KEY_emdash, SCIM_BRIDGE_KEY_emdash);
        map_keycode (scim::SCIM_KEY_endash, SCIM_BRIDGE_KEY_endash);
        map_keycode (scim::SCIM_KEY_signifblank, SCIM_BRIDGE_KEY_signifblank);
        map_keycode (scim::SCIM_KEY_ellipsis, SCIM_BRIDGE_KEY_ellipsis);
        map_keycode (scim::SCIM_KEY_doubbaselinedot, SCIM_BRIDGE_KEY_doubbaselinedot);
        map_keycode (scim::SCIM_KEY_onethird, SCIM_BRIDGE_KEY_onethird);
        map_keycode (scim::SCIM_KEY_twothirds, SCIM_BRIDGE_KEY_twothirds);
        map_keycode (scim::SCIM_KEY_onefifth, SCIM_BRIDGE_KEY_onefifth);
        map_keycode (scim::SCIM_KEY_twofifths, SCIM_BRIDGE_KEY_twofifths);
        map_keycode (scim::SCIM_KEY_threefifths, SCIM_BRIDGE_KEY_threefifths);
        map_keycode (scim::SCIM_KEY_fourfifths, SCIM_BRIDGE_KEY_fourfifths);
        map_keycode (scim::SCIM_KEY_onesixth, SCIM_BRIDGE_KEY_onesixth);
        map_keycode (scim::SCIM_KEY_fivesixths, SCIM_BRIDGE_KEY_fivesixths);
        map_keycode (scim::SCIM_KEY_careof, SCIM_BRIDGE_KEY_careof);
        map_keycode (scim::SCIM_KEY_figdash, SCIM_BRIDGE_KEY_figdash);
        map_keycode (scim::SCIM_KEY_leftanglebracket, SCIM_BRIDGE_KEY_leftanglebracket);
        map_keycode (scim::SCIM_KEY_decimalpoint, SCIM_BRIDGE_KEY_decimalpoint);
        map_keycode (scim::SCIM_KEY_rightanglebracket, SCIM_BRIDGE_KEY_rightanglebracket);
        map_keycode (scim::SCIM_KEY_marker, SCIM_BRIDGE_KEY_marker);
        map_keycode (scim::SCIM_KEY_oneeighth, SCIM_BRIDGE_KEY_oneeighth);
        map_keycode (scim::SCIM_KEY_threeeighths, SCIM_BRIDGE_KEY_threeeighths);
        map_keycode (scim::SCIM_KEY_fiveeighths, SCIM_BRIDGE_KEY_fiveeighths);
        map_keycode (scim::SCIM_KEY_seveneighths, SCIM_BRIDGE_KEY_seveneighths);
        map_keycode (scim::SCIM_KEY_trademark, SCIM_BRIDGE_KEY_trademark);
        map_keycode (scim::SCIM_KEY_signaturemark, SCIM_BRIDGE_KEY_signaturemark);
        map_keycode (scim::SCIM_KEY_trademarkincircle, SCIM_BRIDGE_KEY_trademarkincircle);
        map_keycode (scim::SCIM_KEY_leftopentriangle, SCIM_BRIDGE_KEY_leftopentriangle);
        map_keycode (scim::SCIM_KEY_rightopentriangle, SCIM_BRIDGE_KEY_rightopentriangle);
        map_keycode (scim::SCIM_KEY_emopencircle, SCIM_BRIDGE_KEY_emopencircle);
        map_keycode (scim::SCIM_KEY_emopenrectangle, SCIM_BRIDGE_KEY_emopenrectangle);
        map_keycode (scim::SCIM_KEY_leftsinglequotemark, SCIM_BRIDGE_KEY_leftsinglequotemark);
        map_keycode (scim::SCIM_KEY_rightsinglequotemark, SCIM_BRIDGE_KEY_rightsinglequotemark);
        map_keycode (scim::SCIM_KEY_leftdoublequotemark, SCIM_BRIDGE_KEY_leftdoublequotemark);
        map_keycode (scim::SCIM_KEY_rightdoublequotemark, SCIM_BRIDGE_KEY_rightdoublequotemark);
        map_keycode (scim::SCIM_KEY_prescription, SCIM_BRIDGE_KEY_prescription);
        map_keycode (scim::SCIM_KEY_minutes, SCIM_BRIDGE_KEY_minutes);
        map_keycode (scim::SCIM_KEY_seconds, SCIM_BRIDGE_KEY_seconds);
        map_keycode (scim::SCIM_KEY_latincross, SCIM_BRIDGE_KEY_latincross);
        map_keycode (scim::SCIM_KEY_hexagram, SCIM_BRIDGE_KEY_hexagram);
        map_keycode (scim::SCIM_KEY_filledrectbullet, SCIM_BRIDGE_KEY_filledrectbullet);
        map_keycode (scim::SCIM_KEY_filledlefttribullet, SCIM_BRIDGE_KEY_filledlefttribullet);
        map_keycode (scim::SCIM_KEY_filledrighttribullet, SCIM_BRIDGE_KEY_filledrighttribullet);
        map_keycode (scim::SCIM_KEY_emfilledcircle, SCIM_BRIDGE_KEY_emfilledcircle);
        map_keycode (scim::SCIM_KEY_emfilledrect, SCIM_BRIDGE_KEY_emfilledrect);
        map_keycode (scim::SCIM_KEY_enopencircbullet, SCIM_BRIDGE_KEY_enopencircbullet);
        map_keycode (scim::SCIM_KEY_enopensquarebullet, SCIM_BRIDGE_KEY_enopensquarebullet);
        map_keycode (scim::SCIM_KEY_openrectbullet, SCIM_BRIDGE_KEY_openrectbullet);
        map_keycode (scim::SCIM_KEY_opentribulletup, SCIM_BRIDGE_KEY_opentribulletup);
        map_keycode (scim::SCIM_KEY_opentribulletdown, SCIM_BRIDGE_KEY_opentribulletdown);
        map_keycode (scim::SCIM_KEY_openstar, SCIM_BRIDGE_KEY_openstar);
        map_keycode (scim::SCIM_KEY_enfilledcircbullet, SCIM_BRIDGE_KEY_enfilledcircbullet);
        map_keycode (scim::SCIM_KEY_enfilledsqbullet, SCIM_BRIDGE_KEY_enfilledsqbullet);
        map_keycode (scim::SCIM_KEY_filledtribulletup, SCIM_BRIDGE_KEY_filledtribulletup);
        map_keycode (scim::SCIM_KEY_filledtribulletdown, SCIM_BRIDGE_KEY_filledtribulletdown);
        map_keycode (scim::SCIM_KEY_leftpointer, SCIM_BRIDGE_KEY_leftpointer);
        map_keycode (scim::SCIM_KEY_rightpointer, SCIM_BRIDGE_KEY_rightpointer);
        map_keycode (scim::SCIM_KEY_club, SCIM_BRIDGE_KEY_club);
        map_keycode (scim::SCIM_KEY_diamond, SCIM_BRIDGE_KEY_diamond);
        map_keycode (scim::SCIM_KEY_heart, SCIM_BRIDGE_KEY_heart);
        map_keycode (scim::SCIM_KEY_maltesecross, SCIM_BRIDGE_KEY_maltesecross);
        map_keycode (scim::SCIM_KEY_dagger, SCIM_BRIDGE_KEY_dagger);
        map_keycode (scim::SCIM_KEY_doubledagger, SCIM_BRIDGE_KEY_doubledagger);
        map_keycode (scim::SCIM_KEY_checkmark, SCIM_BRIDGE_KEY_checkmark);
        map_keycode (scim::SCIM_KEY_ballotcross, SCIM_BRIDGE_KEY_ballotcross);
        map_keycode (scim::SCIM_KEY_musicalsharp, SCIM_BRIDGE_KEY_musicalsharp);
        map_keycode (scim::SCIM_KEY_musicalflat, SCIM_BRIDGE_KEY_musicalflat);
        map_keycode (scim::SCIM_KEY_malesymbol, SCIM_BRIDGE_KEY_malesymbol);
        map_keycode (scim::SCIM_KEY_femalesymbol, SCIM_BRIDGE_KEY_femalesymbol);
        map_keycode (scim::SCIM_KEY_telephone, SCIM_BRIDGE_KEY_telephone);
        map_keycode (scim::SCIM_KEY_telephonerecorder, SCIM_BRIDGE_KEY_telephonerecorder);
        map_keycode (scim::SCIM_KEY_phonographcopyright, SCIM_BRIDGE_KEY_phonographcopyright);
        map_keycode (scim::SCIM_KEY_caret, SCIM_BRIDGE_KEY_caret);
        map_keycode (scim::SCIM_KEY_singlelowquotemark, SCIM_BRIDGE_KEY_singlelowquotemark);
        map_keycode (scim::SCIM_KEY_doublelowquotemark, SCIM_BRIDGE_KEY_doublelowquotemark);
        map_keycode (scim::SCIM_KEY_cursor, SCIM_BRIDGE_KEY_cursor);

        /*
         *APL
         *Byte3=b
         */
        map_keycode (scim::SCIM_KEY_leftcaret, SCIM_BRIDGE_KEY_leftcaret);
        map_keycode (scim::SCIM_KEY_rightcaret, SCIM_BRIDGE_KEY_rightcaret);
        map_keycode (scim::SCIM_KEY_downcaret, SCIM_BRIDGE_KEY_downcaret);
        map_keycode (scim::SCIM_KEY_upcaret, SCIM_BRIDGE_KEY_upcaret);
        map_keycode (scim::SCIM_KEY_overbar, SCIM_BRIDGE_KEY_overbar);
        map_keycode (scim::SCIM_KEY_downtack, SCIM_BRIDGE_KEY_downtack);
        map_keycode (scim::SCIM_KEY_upshoe, SCIM_BRIDGE_KEY_upshoe);
        map_keycode (scim::SCIM_KEY_downstile, SCIM_BRIDGE_KEY_downstile);
        map_keycode (scim::SCIM_KEY_underbar, SCIM_BRIDGE_KEY_underbar);
        map_keycode (scim::SCIM_KEY_jot, SCIM_BRIDGE_KEY_jot);
        map_keycode (scim::SCIM_KEY_quad, SCIM_BRIDGE_KEY_quad);
        map_keycode (scim::SCIM_KEY_uptack, SCIM_BRIDGE_KEY_uptack);
        map_keycode (scim::SCIM_KEY_circle, SCIM_BRIDGE_KEY_circle);
        map_keycode (scim::SCIM_KEY_upstile, SCIM_BRIDGE_KEY_upstile);
        map_keycode (scim::SCIM_KEY_downshoe, SCIM_BRIDGE_KEY_downshoe);
        map_keycode (scim::SCIM_KEY_rightshoe, SCIM_BRIDGE_KEY_rightshoe);
        map_keycode (scim::SCIM_KEY_leftshoe, SCIM_BRIDGE_KEY_leftshoe);
        map_keycode (scim::SCIM_KEY_lefttack, SCIM_BRIDGE_KEY_lefttack);
        map_keycode (scim::SCIM_KEY_righttack, SCIM_BRIDGE_KEY_righttack);

        /*
         *Hebrew
         *Byte3=c
         */
        map_keycode (scim::SCIM_KEY_hebrew_doublelowline, SCIM_BRIDGE_KEY_hebrew_doublelowline);
        map_keycode (scim::SCIM_KEY_hebrew_aleph, SCIM_BRIDGE_KEY_hebrew_aleph);
        map_keycode (scim::SCIM_KEY_hebrew_bet, SCIM_BRIDGE_KEY_hebrew_bet);
        map_keycode (scim::SCIM_KEY_hebrew_beth, SCIM_BRIDGE_KEY_hebrew_beth);
        map_keycode (scim::SCIM_KEY_hebrew_gimel, SCIM_BRIDGE_KEY_hebrew_gimel);
        map_keycode (scim::SCIM_KEY_hebrew_gimmel, SCIM_BRIDGE_KEY_hebrew_gimmel);
        map_keycode (scim::SCIM_KEY_hebrew_dalet, SCIM_BRIDGE_KEY_hebrew_dalet);
        map_keycode (scim::SCIM_KEY_hebrew_daleth, SCIM_BRIDGE_KEY_hebrew_daleth);
        map_keycode (scim::SCIM_KEY_hebrew_he, SCIM_BRIDGE_KEY_hebrew_he);
        map_keycode (scim::SCIM_KEY_hebrew_waw, SCIM_BRIDGE_KEY_hebrew_waw);
        map_keycode (scim::SCIM_KEY_hebrew_zain, SCIM_BRIDGE_KEY_hebrew_zain);
        map_keycode (scim::SCIM_KEY_hebrew_zayin, SCIM_BRIDGE_KEY_hebrew_zayin);
        map_keycode (scim::SCIM_KEY_hebrew_chet, SCIM_BRIDGE_KEY_hebrew_chet);
        map_keycode (scim::SCIM_KEY_hebrew_het, SCIM_BRIDGE_KEY_hebrew_het);
        map_keycode (scim::SCIM_KEY_hebrew_tet, SCIM_BRIDGE_KEY_hebrew_tet);
        map_keycode (scim::SCIM_KEY_hebrew_teth, SCIM_BRIDGE_KEY_hebrew_teth);
        map_keycode (scim::SCIM_KEY_hebrew_yod, SCIM_BRIDGE_KEY_hebrew_yod);
        map_keycode (scim::SCIM_KEY_hebrew_finalkaph, SCIM_BRIDGE_KEY_hebrew_finalkaph);
        map_keycode (scim::SCIM_KEY_hebrew_kaph, SCIM_BRIDGE_KEY_hebrew_kaph);
        map_keycode (scim::SCIM_KEY_hebrew_lamed, SCIM_BRIDGE_KEY_hebrew_lamed);
        map_keycode (scim::SCIM_KEY_hebrew_finalmem, SCIM_BRIDGE_KEY_hebrew_finalmem);
        map_keycode (scim::SCIM_KEY_hebrew_mem, SCIM_BRIDGE_KEY_hebrew_mem);
        map_keycode (scim::SCIM_KEY_hebrew_finalnun, SCIM_BRIDGE_KEY_hebrew_finalnun);
        map_keycode (scim::SCIM_KEY_hebrew_nun, SCIM_BRIDGE_KEY_hebrew_nun);
        map_keycode (scim::SCIM_KEY_hebrew_samech, SCIM_BRIDGE_KEY_hebrew_samech);
        map_keycode (scim::SCIM_KEY_hebrew_samekh, SCIM_BRIDGE_KEY_hebrew_samekh);
        map_keycode (scim::SCIM_KEY_hebrew_ayin, SCIM_BRIDGE_KEY_hebrew_ayin);
        map_keycode (scim::SCIM_KEY_hebrew_finalpe, SCIM_BRIDGE_KEY_hebrew_finalpe);
        map_keycode (scim::SCIM_KEY_hebrew_pe, SCIM_BRIDGE_KEY_hebrew_pe);
        map_keycode (scim::SCIM_KEY_hebrew_finalzade, SCIM_BRIDGE_KEY_hebrew_finalzade);
        map_keycode (scim::SCIM_KEY_hebrew_finalzadi, SCIM_BRIDGE_KEY_hebrew_finalzadi);
        map_keycode (scim::SCIM_KEY_hebrew_zade, SCIM_BRIDGE_KEY_hebrew_zade);
        map_keycode (scim::SCIM_KEY_hebrew_zadi, SCIM_BRIDGE_KEY_hebrew_zadi);
        map_keycode (scim::SCIM_KEY_hebrew_qoph, SCIM_BRIDGE_KEY_hebrew_qoph);
        map_keycode (scim::SCIM_KEY_hebrew_kuf, SCIM_BRIDGE_KEY_hebrew_kuf);
        map_keycode (scim::SCIM_KEY_hebrew_resh, SCIM_BRIDGE_KEY_hebrew_resh);
        map_keycode (scim::SCIM_KEY_hebrew_shin, SCIM_BRIDGE_KEY_hebrew_shin);
        map_keycode (scim::SCIM_KEY_hebrew_taw, SCIM_BRIDGE_KEY_hebrew_taw);
        map_keycode (scim::SCIM_KEY_hebrew_taf, SCIM_BRIDGE_KEY_hebrew_taf);
        map_keycode (scim::SCIM_KEY_Hebrew_switch, SCIM_BRIDGE_KEY_Hebrew_switch);

        /*
         *Thai
         *Byte3=d
         */
        map_keycode (scim::SCIM_KEY_Thai_kokai, SCIM_BRIDGE_KEY_Thai_kokai);
        map_keycode (scim::SCIM_KEY_Thai_khokhai, SCIM_BRIDGE_KEY_Thai_khokhai);
        map_keycode (scim::SCIM_KEY_Thai_khokhuat, SCIM_BRIDGE_KEY_Thai_khokhuat);
        map_keycode (scim::SCIM_KEY_Thai_khokhwai, SCIM_BRIDGE_KEY_Thai_khokhwai);
        map_keycode (scim::SCIM_KEY_Thai_khokhon, SCIM_BRIDGE_KEY_Thai_khokhon);
        map_keycode (scim::SCIM_KEY_Thai_khorakhang, SCIM_BRIDGE_KEY_Thai_khorakhang);
        map_keycode (scim::SCIM_KEY_Thai_ngongu, SCIM_BRIDGE_KEY_Thai_ngongu);
        map_keycode (scim::SCIM_KEY_Thai_chochan, SCIM_BRIDGE_KEY_Thai_chochan);
        map_keycode (scim::SCIM_KEY_Thai_choching, SCIM_BRIDGE_KEY_Thai_choching);
        map_keycode (scim::SCIM_KEY_Thai_chochang, SCIM_BRIDGE_KEY_Thai_chochang);
        map_keycode (scim::SCIM_KEY_Thai_soso, SCIM_BRIDGE_KEY_Thai_soso);
        map_keycode (scim::SCIM_KEY_Thai_chochoe, SCIM_BRIDGE_KEY_Thai_chochoe);
        map_keycode (scim::SCIM_KEY_Thai_yoying, SCIM_BRIDGE_KEY_Thai_yoying);
        map_keycode (scim::SCIM_KEY_Thai_dochada, SCIM_BRIDGE_KEY_Thai_dochada);
        map_keycode (scim::SCIM_KEY_Thai_topatak, SCIM_BRIDGE_KEY_Thai_topatak);
        map_keycode (scim::SCIM_KEY_Thai_thothan, SCIM_BRIDGE_KEY_Thai_thothan);
        map_keycode (scim::SCIM_KEY_Thai_thonangmontho, SCIM_BRIDGE_KEY_Thai_thonangmontho);
        map_keycode (scim::SCIM_KEY_Thai_thophuthao, SCIM_BRIDGE_KEY_Thai_thophuthao);
        map_keycode (scim::SCIM_KEY_Thai_nonen, SCIM_BRIDGE_KEY_Thai_nonen);
        map_keycode (scim::SCIM_KEY_Thai_dodek, SCIM_BRIDGE_KEY_Thai_dodek);
        map_keycode (scim::SCIM_KEY_Thai_totao, SCIM_BRIDGE_KEY_Thai_totao);
        map_keycode (scim::SCIM_KEY_Thai_thothung, SCIM_BRIDGE_KEY_Thai_thothung);
        map_keycode (scim::SCIM_KEY_Thai_thothahan, SCIM_BRIDGE_KEY_Thai_thothahan);
        map_keycode (scim::SCIM_KEY_Thai_thothong, SCIM_BRIDGE_KEY_Thai_thothong);
        map_keycode (scim::SCIM_KEY_Thai_nonu, SCIM_BRIDGE_KEY_Thai_nonu);
        map_keycode (scim::SCIM_KEY_Thai_bobaimai, SCIM_BRIDGE_KEY_Thai_bobaimai);
        map_keycode (scim::SCIM_KEY_Thai_popla, SCIM_BRIDGE_KEY_Thai_popla);
        map_keycode (scim::SCIM_KEY_Thai_phophung, SCIM_BRIDGE_KEY_Thai_phophung);
        map_keycode (scim::SCIM_KEY_Thai_fofa, SCIM_BRIDGE_KEY_Thai_fofa);
        map_keycode (scim::SCIM_KEY_Thai_phophan, SCIM_BRIDGE_KEY_Thai_phophan);
        map_keycode (scim::SCIM_KEY_Thai_fofan, SCIM_BRIDGE_KEY_Thai_fofan);
        map_keycode (scim::SCIM_KEY_Thai_phosamphao, SCIM_BRIDGE_KEY_Thai_phosamphao);
        map_keycode (scim::SCIM_KEY_Thai_moma, SCIM_BRIDGE_KEY_Thai_moma);
        map_keycode (scim::SCIM_KEY_Thai_yoyak, SCIM_BRIDGE_KEY_Thai_yoyak);
        map_keycode (scim::SCIM_KEY_Thai_rorua, SCIM_BRIDGE_KEY_Thai_rorua);
        map_keycode (scim::SCIM_KEY_Thai_ru, SCIM_BRIDGE_KEY_Thai_ru);
        map_keycode (scim::SCIM_KEY_Thai_loling, SCIM_BRIDGE_KEY_Thai_loling);
        map_keycode (scim::SCIM_KEY_Thai_lu, SCIM_BRIDGE_KEY_Thai_lu);
        map_keycode (scim::SCIM_KEY_Thai_wowaen, SCIM_BRIDGE_KEY_Thai_wowaen);
        map_keycode (scim::SCIM_KEY_Thai_sosala, SCIM_BRIDGE_KEY_Thai_sosala);
        map_keycode (scim::SCIM_KEY_Thai_sorusi, SCIM_BRIDGE_KEY_Thai_sorusi);
        map_keycode (scim::SCIM_KEY_Thai_sosua, SCIM_BRIDGE_KEY_Thai_sosua);
        map_keycode (scim::SCIM_KEY_Thai_hohip, SCIM_BRIDGE_KEY_Thai_hohip);
        map_keycode (scim::SCIM_KEY_Thai_lochula, SCIM_BRIDGE_KEY_Thai_lochula);
        map_keycode (scim::SCIM_KEY_Thai_oang, SCIM_BRIDGE_KEY_Thai_oang);
        map_keycode (scim::SCIM_KEY_Thai_honokhuk, SCIM_BRIDGE_KEY_Thai_honokhuk);
        map_keycode (scim::SCIM_KEY_Thai_paiyannoi, SCIM_BRIDGE_KEY_Thai_paiyannoi);
        map_keycode (scim::SCIM_KEY_Thai_saraa, SCIM_BRIDGE_KEY_Thai_saraa);
        map_keycode (scim::SCIM_KEY_Thai_maihanakat, SCIM_BRIDGE_KEY_Thai_maihanakat);
        map_keycode (scim::SCIM_KEY_Thai_saraaa, SCIM_BRIDGE_KEY_Thai_saraaa);
        map_keycode (scim::SCIM_KEY_Thai_saraam, SCIM_BRIDGE_KEY_Thai_saraam);
        map_keycode (scim::SCIM_KEY_Thai_sarai, SCIM_BRIDGE_KEY_Thai_sarai);
        map_keycode (scim::SCIM_KEY_Thai_saraii, SCIM_BRIDGE_KEY_Thai_saraii);
        map_keycode (scim::SCIM_KEY_Thai_saraue, SCIM_BRIDGE_KEY_Thai_saraue);
        map_keycode (scim::SCIM_KEY_Thai_sarauee, SCIM_BRIDGE_KEY_Thai_sarauee);
        map_keycode (scim::SCIM_KEY_Thai_sarau, SCIM_BRIDGE_KEY_Thai_sarau);
        map_keycode (scim::SCIM_KEY_Thai_sarauu, SCIM_BRIDGE_KEY_Thai_sarauu);
        map_keycode (scim::SCIM_KEY_Thai_phinthu, SCIM_BRIDGE_KEY_Thai_phinthu);
        map_keycode (scim::SCIM_KEY_Thai_maihanakat_maitho, SCIM_BRIDGE_KEY_Thai_maihanakat_maitho);
        map_keycode (scim::SCIM_KEY_Thai_baht, SCIM_BRIDGE_KEY_Thai_baht);
        map_keycode (scim::SCIM_KEY_Thai_sarae, SCIM_BRIDGE_KEY_Thai_sarae);
        map_keycode (scim::SCIM_KEY_Thai_saraae, SCIM_BRIDGE_KEY_Thai_saraae);
        map_keycode (scim::SCIM_KEY_Thai_sarao, SCIM_BRIDGE_KEY_Thai_sarao);
        map_keycode (scim::SCIM_KEY_Thai_saraaimaimuan, SCIM_BRIDGE_KEY_Thai_saraaimaimuan);
        map_keycode (scim::SCIM_KEY_Thai_saraaimaimalai, SCIM_BRIDGE_KEY_Thai_saraaimaimalai);
        map_keycode (scim::SCIM_KEY_Thai_lakkhangyao, SCIM_BRIDGE_KEY_Thai_lakkhangyao);
        map_keycode (scim::SCIM_KEY_Thai_maiyamok, SCIM_BRIDGE_KEY_Thai_maiyamok);
        map_keycode (scim::SCIM_KEY_Thai_maitaikhu, SCIM_BRIDGE_KEY_Thai_maitaikhu);
        map_keycode (scim::SCIM_KEY_Thai_maiek, SCIM_BRIDGE_KEY_Thai_maiek);
        map_keycode (scim::SCIM_KEY_Thai_maitho, SCIM_BRIDGE_KEY_Thai_maitho);
        map_keycode (scim::SCIM_KEY_Thai_maitri, SCIM_BRIDGE_KEY_Thai_maitri);
        map_keycode (scim::SCIM_KEY_Thai_maichattawa, SCIM_BRIDGE_KEY_Thai_maichattawa);
        map_keycode (scim::SCIM_KEY_Thai_thanthakhat, SCIM_BRIDGE_KEY_Thai_thanthakhat);
        map_keycode (scim::SCIM_KEY_Thai_nikhahit, SCIM_BRIDGE_KEY_Thai_nikhahit);
        map_keycode (scim::SCIM_KEY_Thai_leksun, SCIM_BRIDGE_KEY_Thai_leksun);
        map_keycode (scim::SCIM_KEY_Thai_leknung, SCIM_BRIDGE_KEY_Thai_leknung);
        map_keycode (scim::SCIM_KEY_Thai_leksong, SCIM_BRIDGE_KEY_Thai_leksong);
        map_keycode (scim::SCIM_KEY_Thai_leksam, SCIM_BRIDGE_KEY_Thai_leksam);
        map_keycode (scim::SCIM_KEY_Thai_leksi, SCIM_BRIDGE_KEY_Thai_leksi);
        map_keycode (scim::SCIM_KEY_Thai_lekha, SCIM_BRIDGE_KEY_Thai_lekha);
        map_keycode (scim::SCIM_KEY_Thai_lekhok, SCIM_BRIDGE_KEY_Thai_lekhok);
        map_keycode (scim::SCIM_KEY_Thai_lekchet, SCIM_BRIDGE_KEY_Thai_lekchet);
        map_keycode (scim::SCIM_KEY_Thai_lekpaet, SCIM_BRIDGE_KEY_Thai_lekpaet);
        map_keycode (scim::SCIM_KEY_Thai_lekkao, SCIM_BRIDGE_KEY_Thai_lekkao);

        /*
         *Korean
         *Byte3=e
         */
        map_keycode (scim::SCIM_KEY_Hangul, SCIM_BRIDGE_KEY_Hangul);
        map_keycode (scim::SCIM_KEY_Hangul_Start, SCIM_BRIDGE_KEY_Hangul_Start);
        map_keycode (scim::SCIM_KEY_Hangul_End, SCIM_BRIDGE_KEY_Hangul_End);
        map_keycode (scim::SCIM_KEY_Hangul_Hanja, SCIM_BRIDGE_KEY_Hangul_Hanja);
        map_keycode (scim::SCIM_KEY_Hangul_Jamo, SCIM_BRIDGE_KEY_Hangul_Jamo);
        map_keycode (scim::SCIM_KEY_Hangul_Romaja, SCIM_BRIDGE_KEY_Hangul_Romaja);
        map_keycode (scim::SCIM_KEY_Hangul_Codeinput, SCIM_BRIDGE_KEY_Hangul_Codeinput);
        map_keycode (scim::SCIM_KEY_Hangul_Jeonja, SCIM_BRIDGE_KEY_Hangul_Jeonja);
        map_keycode (scim::SCIM_KEY_Hangul_Banja, SCIM_BRIDGE_KEY_Hangul_Banja);
        map_keycode (scim::SCIM_KEY_Hangul_PreHanja, SCIM_BRIDGE_KEY_Hangul_PreHanja);
        map_keycode (scim::SCIM_KEY_Hangul_PostHanja, SCIM_BRIDGE_KEY_Hangul_PostHanja);
        map_keycode (scim::SCIM_KEY_Hangul_SingleCandidate, SCIM_BRIDGE_KEY_Hangul_SingleCandidate);
        map_keycode (scim::SCIM_KEY_Hangul_MultipleCandidate, SCIM_BRIDGE_KEY_Hangul_MultipleCandidate);
        map_keycode (scim::SCIM_KEY_Hangul_PreviousCandidate, SCIM_BRIDGE_KEY_Hangul_PreviousCandidate);
        map_keycode (scim::SCIM_KEY_Hangul_Special, SCIM_BRIDGE_KEY_Hangul_Special);
        map_keycode (scim::SCIM_KEY_Hangul_switch, SCIM_BRIDGE_KEY_Hangul_switch);

        map_keycode (scim::SCIM_KEY_Hangul_Kiyeog, SCIM_BRIDGE_KEY_Hangul_Kiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_SsangKiyeog, SCIM_BRIDGE_KEY_Hangul_SsangKiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_KiyeogSios, SCIM_BRIDGE_KEY_Hangul_KiyeogSios);
        map_keycode (scim::SCIM_KEY_Hangul_Nieun, SCIM_BRIDGE_KEY_Hangul_Nieun);
        map_keycode (scim::SCIM_KEY_Hangul_NieunJieuj, SCIM_BRIDGE_KEY_Hangul_NieunJieuj);
        map_keycode (scim::SCIM_KEY_Hangul_NieunHieuh, SCIM_BRIDGE_KEY_Hangul_NieunHieuh);
        map_keycode (scim::SCIM_KEY_Hangul_Dikeud, SCIM_BRIDGE_KEY_Hangul_Dikeud);
        map_keycode (scim::SCIM_KEY_Hangul_SsangDikeud, SCIM_BRIDGE_KEY_Hangul_SsangDikeud);
        map_keycode (scim::SCIM_KEY_Hangul_Rieul, SCIM_BRIDGE_KEY_Hangul_Rieul);
        map_keycode (scim::SCIM_KEY_Hangul_RieulKiyeog, SCIM_BRIDGE_KEY_Hangul_RieulKiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_RieulMieum, SCIM_BRIDGE_KEY_Hangul_RieulMieum);
        map_keycode (scim::SCIM_KEY_Hangul_RieulPieub, SCIM_BRIDGE_KEY_Hangul_RieulPieub);
        map_keycode (scim::SCIM_KEY_Hangul_RieulSios, SCIM_BRIDGE_KEY_Hangul_RieulSios);
        map_keycode (scim::SCIM_KEY_Hangul_RieulTieut, SCIM_BRIDGE_KEY_Hangul_RieulTieut);
        map_keycode (scim::SCIM_KEY_Hangul_RieulPhieuf, SCIM_BRIDGE_KEY_Hangul_RieulPhieuf);
        map_keycode (scim::SCIM_KEY_Hangul_RieulHieuh, SCIM_BRIDGE_KEY_Hangul_RieulHieuh);
        map_keycode (scim::SCIM_KEY_Hangul_Mieum, SCIM_BRIDGE_KEY_Hangul_Mieum);
        map_keycode (scim::SCIM_KEY_Hangul_Pieub, SCIM_BRIDGE_KEY_Hangul_Pieub);
        map_keycode (scim::SCIM_KEY_Hangul_SsangPieub, SCIM_BRIDGE_KEY_Hangul_SsangPieub);
        map_keycode (scim::SCIM_KEY_Hangul_PieubSios, SCIM_BRIDGE_KEY_Hangul_PieubSios);
        map_keycode (scim::SCIM_KEY_Hangul_Sios, SCIM_BRIDGE_KEY_Hangul_Sios);
        map_keycode (scim::SCIM_KEY_Hangul_SsangSios, SCIM_BRIDGE_KEY_Hangul_SsangSios);
        map_keycode (scim::SCIM_KEY_Hangul_Ieung, SCIM_BRIDGE_KEY_Hangul_Ieung);
        map_keycode (scim::SCIM_KEY_Hangul_Jieuj, SCIM_BRIDGE_KEY_Hangul_Jieuj);
        map_keycode (scim::SCIM_KEY_Hangul_SsangJieuj, SCIM_BRIDGE_KEY_Hangul_SsangJieuj);
        map_keycode (scim::SCIM_KEY_Hangul_Cieuc, SCIM_BRIDGE_KEY_Hangul_Cieuc);
        map_keycode (scim::SCIM_KEY_Hangul_Khieuq, SCIM_BRIDGE_KEY_Hangul_Khieuq);
        map_keycode (scim::SCIM_KEY_Hangul_Tieut, SCIM_BRIDGE_KEY_Hangul_Tieut);
        map_keycode (scim::SCIM_KEY_Hangul_Phieuf, SCIM_BRIDGE_KEY_Hangul_Phieuf);
        map_keycode (scim::SCIM_KEY_Hangul_Hieuh, SCIM_BRIDGE_KEY_Hangul_Hieuh);

        map_keycode (scim::SCIM_KEY_Hangul_A, SCIM_BRIDGE_KEY_Hangul_A);
        map_keycode (scim::SCIM_KEY_Hangul_AE, SCIM_BRIDGE_KEY_Hangul_AE);
        map_keycode (scim::SCIM_KEY_Hangul_YA, SCIM_BRIDGE_KEY_Hangul_YA);
        map_keycode (scim::SCIM_KEY_Hangul_YAE, SCIM_BRIDGE_KEY_Hangul_YAE);
        map_keycode (scim::SCIM_KEY_Hangul_EO, SCIM_BRIDGE_KEY_Hangul_EO);
        map_keycode (scim::SCIM_KEY_Hangul_E, SCIM_BRIDGE_KEY_Hangul_E);
        map_keycode (scim::SCIM_KEY_Hangul_YEO, SCIM_BRIDGE_KEY_Hangul_YEO);
        map_keycode (scim::SCIM_KEY_Hangul_YE, SCIM_BRIDGE_KEY_Hangul_YE);
        map_keycode (scim::SCIM_KEY_Hangul_O, SCIM_BRIDGE_KEY_Hangul_O);
        map_keycode (scim::SCIM_KEY_Hangul_WA, SCIM_BRIDGE_KEY_Hangul_WA);
        map_keycode (scim::SCIM_KEY_Hangul_WAE, SCIM_BRIDGE_KEY_Hangul_WAE);
        map_keycode (scim::SCIM_KEY_Hangul_OE, SCIM_BRIDGE_KEY_Hangul_OE);
        map_keycode (scim::SCIM_KEY_Hangul_YO, SCIM_BRIDGE_KEY_Hangul_YO);
        map_keycode (scim::SCIM_KEY_Hangul_U, SCIM_BRIDGE_KEY_Hangul_U);
        map_keycode (scim::SCIM_KEY_Hangul_WEO, SCIM_BRIDGE_KEY_Hangul_WEO);
        map_keycode (scim::SCIM_KEY_Hangul_WE, SCIM_BRIDGE_KEY_Hangul_WE);
        map_keycode (scim::SCIM_KEY_Hangul_WI, SCIM_BRIDGE_KEY_Hangul_WI);
        map_keycode (scim::SCIM_KEY_Hangul_YU, SCIM_BRIDGE_KEY_Hangul_YU);
        map_keycode (scim::SCIM_KEY_Hangul_EU, SCIM_BRIDGE_KEY_Hangul_EU);
        map_keycode (scim::SCIM_KEY_Hangul_YI, SCIM_BRIDGE_KEY_Hangul_YI);
        map_keycode (scim::SCIM_KEY_Hangul_I, SCIM_BRIDGE_KEY_Hangul_I);

        map_keycode (scim::SCIM_KEY_Hangul_J_Kiyeog, SCIM_BRIDGE_KEY_Hangul_J_Kiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_J_SsangKiyeog, SCIM_BRIDGE_KEY_Hangul_J_SsangKiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_J_KiyeogSios, SCIM_BRIDGE_KEY_Hangul_J_KiyeogSios);
        map_keycode (scim::SCIM_KEY_Hangul_J_Nieun, SCIM_BRIDGE_KEY_Hangul_J_Nieun);
        map_keycode (scim::SCIM_KEY_Hangul_J_NieunJieuj, SCIM_BRIDGE_KEY_Hangul_J_NieunJieuj);
        map_keycode (scim::SCIM_KEY_Hangul_J_NieunHieuh, SCIM_BRIDGE_KEY_Hangul_J_NieunHieuh);
        map_keycode (scim::SCIM_KEY_Hangul_J_Dikeud, SCIM_BRIDGE_KEY_Hangul_J_Dikeud);
        map_keycode (scim::SCIM_KEY_Hangul_J_Rieul, SCIM_BRIDGE_KEY_Hangul_J_Rieul);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulKiyeog, SCIM_BRIDGE_KEY_Hangul_J_RieulKiyeog);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulMieum, SCIM_BRIDGE_KEY_Hangul_J_RieulMieum);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulPieub, SCIM_BRIDGE_KEY_Hangul_J_RieulPieub);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulSios, SCIM_BRIDGE_KEY_Hangul_J_RieulSios);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulTieut, SCIM_BRIDGE_KEY_Hangul_J_RieulTieut);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulPhieuf, SCIM_BRIDGE_KEY_Hangul_J_RieulPhieuf);
        map_keycode (scim::SCIM_KEY_Hangul_J_RieulHieuh, SCIM_BRIDGE_KEY_Hangul_J_RieulHieuh);
        map_keycode (scim::SCIM_KEY_Hangul_J_Mieum, SCIM_BRIDGE_KEY_Hangul_J_Mieum);
        map_keycode (scim::SCIM_KEY_Hangul_J_Pieub, SCIM_BRIDGE_KEY_Hangul_J_Pieub);
        map_keycode (scim::SCIM_KEY_Hangul_J_PieubSios, SCIM_BRIDGE_KEY_Hangul_J_PieubSios);
        map_keycode (scim::SCIM_KEY_Hangul_J_Sios, SCIM_BRIDGE_KEY_Hangul_J_Sios);
        map_keycode (scim::SCIM_KEY_Hangul_J_SsangSios, SCIM_BRIDGE_KEY_Hangul_J_SsangSios);
        map_keycode (scim::SCIM_KEY_Hangul_J_Ieung, SCIM_BRIDGE_KEY_Hangul_J_Ieung);
        map_keycode (scim::SCIM_KEY_Hangul_J_Jieuj, SCIM_BRIDGE_KEY_Hangul_J_Jieuj);
        map_keycode (scim::SCIM_KEY_Hangul_J_Cieuc, SCIM_BRIDGE_KEY_Hangul_J_Cieuc);
        map_keycode (scim::SCIM_KEY_Hangul_J_Khieuq, SCIM_BRIDGE_KEY_Hangul_J_Khieuq);
        map_keycode (scim::SCIM_KEY_Hangul_J_Tieut, SCIM_BRIDGE_KEY_Hangul_J_Tieut);
        map_keycode (scim::SCIM_KEY_Hangul_J_Phieuf, SCIM_BRIDGE_KEY_Hangul_J_Phieuf);
        map_keycode (scim::SCIM_KEY_Hangul_J_Hieuh, SCIM_BRIDGE_KEY_Hangul_J_Hieuh);

        map_keycode (scim::SCIM_KEY_Hangul_RieulYeorinHieuh, SCIM_BRIDGE_KEY_Hangul_RieulYeorinHieuh);
        map_keycode (scim::SCIM_KEY_Hangul_SunkyeongeumMieum, SCIM_BRIDGE_KEY_Hangul_SunkyeongeumMieum);
        map_keycode (scim::SCIM_KEY_Hangul_SunkyeongeumPieub, SCIM_BRIDGE_KEY_Hangul_SunkyeongeumPieub);
        map_keycode (scim::SCIM_KEY_Hangul_PanSios, SCIM_BRIDGE_KEY_Hangul_PanSios);
        map_keycode (scim::SCIM_KEY_Hangul_KkogjiDalrinIeung, SCIM_BRIDGE_KEY_Hangul_KkogjiDalrinIeung);
        map_keycode (scim::SCIM_KEY_Hangul_SunkyeongeumPhieuf, SCIM_BRIDGE_KEY_Hangul_SunkyeongeumPhieuf);
        map_keycode (scim::SCIM_KEY_Hangul_YeorinHieuh, SCIM_BRIDGE_KEY_Hangul_YeorinHieuh);

        map_keycode (scim::SCIM_KEY_Hangul_AraeA, SCIM_BRIDGE_KEY_Hangul_AraeA);
        map_keycode (scim::SCIM_KEY_Hangul_AraeAE, SCIM_BRIDGE_KEY_Hangul_AraeAE);

        map_keycode (scim::SCIM_KEY_Hangul_J_PanSios, SCIM_BRIDGE_KEY_Hangul_J_PanSios);
        map_keycode (scim::SCIM_KEY_Hangul_J_KkogjiDalrinIeung, SCIM_BRIDGE_KEY_Hangul_J_KkogjiDalrinIeung);
        map_keycode (scim::SCIM_KEY_Hangul_J_YeorinHieuh, SCIM_BRIDGE_KEY_Hangul_J_YeorinHieuh);

        map_keycode (scim::SCIM_KEY_Korean_Won, SCIM_BRIDGE_KEY_Korean_Won);

        /*
         *Armenian
         *Byte3=0x14
         */
        map_keycode (scim::SCIM_KEY_Armenian_eternity, SCIM_BRIDGE_KEY_Armenian_eternity);
        map_keycode (scim::SCIM_KEY_Armenian_ligature_ew, SCIM_BRIDGE_KEY_Armenian_ligature_ew);
        map_keycode (scim::SCIM_KEY_Armenian_full_stop, SCIM_BRIDGE_KEY_Armenian_full_stop);
        map_keycode (scim::SCIM_KEY_Armenian_verjaket, SCIM_BRIDGE_KEY_Armenian_verjaket);
        map_keycode (scim::SCIM_KEY_Armenian_parenright, SCIM_BRIDGE_KEY_Armenian_parenright);
        map_keycode (scim::SCIM_KEY_Armenian_parenleft, SCIM_BRIDGE_KEY_Armenian_parenleft);
        map_keycode (scim::SCIM_KEY_Armenian_guillemotright, SCIM_BRIDGE_KEY_Armenian_guillemotright);
        map_keycode (scim::SCIM_KEY_Armenian_guillemotleft, SCIM_BRIDGE_KEY_Armenian_guillemotleft);
        map_keycode (scim::SCIM_KEY_Armenian_em_dash, SCIM_BRIDGE_KEY_Armenian_em_dash);
        map_keycode (scim::SCIM_KEY_Armenian_dot, SCIM_BRIDGE_KEY_Armenian_dot);
        map_keycode (scim::SCIM_KEY_Armenian_mijaket, SCIM_BRIDGE_KEY_Armenian_mijaket);
        map_keycode (scim::SCIM_KEY_Armenian_separation_mark, SCIM_BRIDGE_KEY_Armenian_separation_mark);
        map_keycode (scim::SCIM_KEY_Armenian_but, SCIM_BRIDGE_KEY_Armenian_but);
        map_keycode (scim::SCIM_KEY_Armenian_comma, SCIM_BRIDGE_KEY_Armenian_comma);
        map_keycode (scim::SCIM_KEY_Armenian_en_dash, SCIM_BRIDGE_KEY_Armenian_en_dash);
        map_keycode (scim::SCIM_KEY_Armenian_hyphen, SCIM_BRIDGE_KEY_Armenian_hyphen);
        map_keycode (scim::SCIM_KEY_Armenian_yentamna, SCIM_BRIDGE_KEY_Armenian_yentamna);
        map_keycode (scim::SCIM_KEY_Armenian_ellipsis, SCIM_BRIDGE_KEY_Armenian_ellipsis);
        map_keycode (scim::SCIM_KEY_Armenian_exclam, SCIM_BRIDGE_KEY_Armenian_exclam);
        map_keycode (scim::SCIM_KEY_Armenian_amanak, SCIM_BRIDGE_KEY_Armenian_amanak);
        map_keycode (scim::SCIM_KEY_Armenian_accent, SCIM_BRIDGE_KEY_Armenian_accent);
        map_keycode (scim::SCIM_KEY_Armenian_shesht, SCIM_BRIDGE_KEY_Armenian_shesht);
        map_keycode (scim::SCIM_KEY_Armenian_question, SCIM_BRIDGE_KEY_Armenian_question);
        map_keycode (scim::SCIM_KEY_Armenian_paruyk, SCIM_BRIDGE_KEY_Armenian_paruyk);
        map_keycode (scim::SCIM_KEY_Armenian_AYB, SCIM_BRIDGE_KEY_Armenian_AYB);
        map_keycode (scim::SCIM_KEY_Armenian_ayb, SCIM_BRIDGE_KEY_Armenian_ayb);
        map_keycode (scim::SCIM_KEY_Armenian_BEN, SCIM_BRIDGE_KEY_Armenian_BEN);
        map_keycode (scim::SCIM_KEY_Armenian_ben, SCIM_BRIDGE_KEY_Armenian_ben);
        map_keycode (scim::SCIM_KEY_Armenian_GIM, SCIM_BRIDGE_KEY_Armenian_GIM);
        map_keycode (scim::SCIM_KEY_Armenian_gim, SCIM_BRIDGE_KEY_Armenian_gim);
        map_keycode (scim::SCIM_KEY_Armenian_DA, SCIM_BRIDGE_KEY_Armenian_DA);
        map_keycode (scim::SCIM_KEY_Armenian_da, SCIM_BRIDGE_KEY_Armenian_da);
        map_keycode (scim::SCIM_KEY_Armenian_YECH, SCIM_BRIDGE_KEY_Armenian_YECH);
        map_keycode (scim::SCIM_KEY_Armenian_yech, SCIM_BRIDGE_KEY_Armenian_yech);
        map_keycode (scim::SCIM_KEY_Armenian_ZA, SCIM_BRIDGE_KEY_Armenian_ZA);
        map_keycode (scim::SCIM_KEY_Armenian_za, SCIM_BRIDGE_KEY_Armenian_za);
        map_keycode (scim::SCIM_KEY_Armenian_E, SCIM_BRIDGE_KEY_Armenian_E);
        map_keycode (scim::SCIM_KEY_Armenian_e, SCIM_BRIDGE_KEY_Armenian_e);
        map_keycode (scim::SCIM_KEY_Armenian_AT, SCIM_BRIDGE_KEY_Armenian_AT);
        map_keycode (scim::SCIM_KEY_Armenian_at, SCIM_BRIDGE_KEY_Armenian_at);
        map_keycode (scim::SCIM_KEY_Armenian_TO, SCIM_BRIDGE_KEY_Armenian_TO);
        map_keycode (scim::SCIM_KEY_Armenian_to, SCIM_BRIDGE_KEY_Armenian_to);
        map_keycode (scim::SCIM_KEY_Armenian_ZHE, SCIM_BRIDGE_KEY_Armenian_ZHE);
        map_keycode (scim::SCIM_KEY_Armenian_zhe, SCIM_BRIDGE_KEY_Armenian_zhe);
        map_keycode (scim::SCIM_KEY_Armenian_INI, SCIM_BRIDGE_KEY_Armenian_INI);
        map_keycode (scim::SCIM_KEY_Armenian_ini, SCIM_BRIDGE_KEY_Armenian_ini);
        map_keycode (scim::SCIM_KEY_Armenian_LYUN, SCIM_BRIDGE_KEY_Armenian_LYUN);
        map_keycode (scim::SCIM_KEY_Armenian_lyun, SCIM_BRIDGE_KEY_Armenian_lyun);
        map_keycode (scim::SCIM_KEY_Armenian_KHE, SCIM_BRIDGE_KEY_Armenian_KHE);
        map_keycode (scim::SCIM_KEY_Armenian_khe, SCIM_BRIDGE_KEY_Armenian_khe);
        map_keycode (scim::SCIM_KEY_Armenian_TSA, SCIM_BRIDGE_KEY_Armenian_TSA);
        map_keycode (scim::SCIM_KEY_Armenian_tsa, SCIM_BRIDGE_KEY_Armenian_tsa);
        map_keycode (scim::SCIM_KEY_Armenian_KEN, SCIM_BRIDGE_KEY_Armenian_KEN);
        map_keycode (scim::SCIM_KEY_Armenian_ken, SCIM_BRIDGE_KEY_Armenian_ken);
        map_keycode (scim::SCIM_KEY_Armenian_HO, SCIM_BRIDGE_KEY_Armenian_HO);
        map_keycode (scim::SCIM_KEY_Armenian_ho, SCIM_BRIDGE_KEY_Armenian_ho);
        map_keycode (scim::SCIM_KEY_Armenian_DZA, SCIM_BRIDGE_KEY_Armenian_DZA);
        map_keycode (scim::SCIM_KEY_Armenian_dza, SCIM_BRIDGE_KEY_Armenian_dza);
        map_keycode (scim::SCIM_KEY_Armenian_GHAT, SCIM_BRIDGE_KEY_Armenian_GHAT);
        map_keycode (scim::SCIM_KEY_Armenian_ghat, SCIM_BRIDGE_KEY_Armenian_ghat);
        map_keycode (scim::SCIM_KEY_Armenian_TCHE, SCIM_BRIDGE_KEY_Armenian_TCHE);
        map_keycode (scim::SCIM_KEY_Armenian_tche, SCIM_BRIDGE_KEY_Armenian_tche);
        map_keycode (scim::SCIM_KEY_Armenian_MEN, SCIM_BRIDGE_KEY_Armenian_MEN);
        map_keycode (scim::SCIM_KEY_Armenian_men, SCIM_BRIDGE_KEY_Armenian_men);
        map_keycode (scim::SCIM_KEY_Armenian_HI, SCIM_BRIDGE_KEY_Armenian_HI);
        map_keycode (scim::SCIM_KEY_Armenian_hi, SCIM_BRIDGE_KEY_Armenian_hi);
        map_keycode (scim::SCIM_KEY_Armenian_NU, SCIM_BRIDGE_KEY_Armenian_NU);
        map_keycode (scim::SCIM_KEY_Armenian_nu, SCIM_BRIDGE_KEY_Armenian_nu);
        map_keycode (scim::SCIM_KEY_Armenian_SHA, SCIM_BRIDGE_KEY_Armenian_SHA);
        map_keycode (scim::SCIM_KEY_Armenian_sha, SCIM_BRIDGE_KEY_Armenian_sha);
        map_keycode (scim::SCIM_KEY_Armenian_VO, SCIM_BRIDGE_KEY_Armenian_VO);
        map_keycode (scim::SCIM_KEY_Armenian_vo, SCIM_BRIDGE_KEY_Armenian_vo);
        map_keycode (scim::SCIM_KEY_Armenian_CHA, SCIM_BRIDGE_KEY_Armenian_CHA);
        map_keycode (scim::SCIM_KEY_Armenian_cha, SCIM_BRIDGE_KEY_Armenian_cha);
        map_keycode (scim::SCIM_KEY_Armenian_PE, SCIM_BRIDGE_KEY_Armenian_PE);
        map_keycode (scim::SCIM_KEY_Armenian_pe, SCIM_BRIDGE_KEY_Armenian_pe);
        map_keycode (scim::SCIM_KEY_Armenian_JE, SCIM_BRIDGE_KEY_Armenian_JE);
        map_keycode (scim::SCIM_KEY_Armenian_je, SCIM_BRIDGE_KEY_Armenian_je);
        map_keycode (scim::SCIM_KEY_Armenian_RA, SCIM_BRIDGE_KEY_Armenian_RA);
        map_keycode (scim::SCIM_KEY_Armenian_ra, SCIM_BRIDGE_KEY_Armenian_ra);
        map_keycode (scim::SCIM_KEY_Armenian_SE, SCIM_BRIDGE_KEY_Armenian_SE);
        map_keycode (scim::SCIM_KEY_Armenian_se, SCIM_BRIDGE_KEY_Armenian_se);
        map_keycode (scim::SCIM_KEY_Armenian_VEV, SCIM_BRIDGE_KEY_Armenian_VEV);
        map_keycode (scim::SCIM_KEY_Armenian_vev, SCIM_BRIDGE_KEY_Armenian_vev);
        map_keycode (scim::SCIM_KEY_Armenian_TYUN, SCIM_BRIDGE_KEY_Armenian_TYUN);
        map_keycode (scim::SCIM_KEY_Armenian_tyun, SCIM_BRIDGE_KEY_Armenian_tyun);
        map_keycode (scim::SCIM_KEY_Armenian_RE, SCIM_BRIDGE_KEY_Armenian_RE);
        map_keycode (scim::SCIM_KEY_Armenian_re, SCIM_BRIDGE_KEY_Armenian_re);
        map_keycode (scim::SCIM_KEY_Armenian_TSO, SCIM_BRIDGE_KEY_Armenian_TSO);
        map_keycode (scim::SCIM_KEY_Armenian_tso, SCIM_BRIDGE_KEY_Armenian_tso);
        map_keycode (scim::SCIM_KEY_Armenian_VYUN, SCIM_BRIDGE_KEY_Armenian_VYUN);
        map_keycode (scim::SCIM_KEY_Armenian_vyun, SCIM_BRIDGE_KEY_Armenian_vyun);
        map_keycode (scim::SCIM_KEY_Armenian_PYUR, SCIM_BRIDGE_KEY_Armenian_PYUR);
        map_keycode (scim::SCIM_KEY_Armenian_pyur, SCIM_BRIDGE_KEY_Armenian_pyur);
        map_keycode (scim::SCIM_KEY_Armenian_KE, SCIM_BRIDGE_KEY_Armenian_KE);
        map_keycode (scim::SCIM_KEY_Armenian_ke, SCIM_BRIDGE_KEY_Armenian_ke);
        map_keycode (scim::SCIM_KEY_Armenian_O, SCIM_BRIDGE_KEY_Armenian_O);
        map_keycode (scim::SCIM_KEY_Armenian_o, SCIM_BRIDGE_KEY_Armenian_o);
        map_keycode (scim::SCIM_KEY_Armenian_FE, SCIM_BRIDGE_KEY_Armenian_FE);
        map_keycode (scim::SCIM_KEY_Armenian_fe, SCIM_BRIDGE_KEY_Armenian_fe);
        map_keycode (scim::SCIM_KEY_Armenian_apostrophe, SCIM_BRIDGE_KEY_Armenian_apostrophe);
        map_keycode (scim::SCIM_KEY_Armenian_section_sign, SCIM_BRIDGE_KEY_Armenian_section_sign);

        /*
         *Georgian
         *Byte3=0x15
         */

        map_keycode (scim::SCIM_KEY_Georgian_an, SCIM_BRIDGE_KEY_Georgian_an);
        map_keycode (scim::SCIM_KEY_Georgian_ban, SCIM_BRIDGE_KEY_Georgian_ban);
        map_keycode (scim::SCIM_KEY_Georgian_gan, SCIM_BRIDGE_KEY_Georgian_gan);
        map_keycode (scim::SCIM_KEY_Georgian_don, SCIM_BRIDGE_KEY_Georgian_don);
        map_keycode (scim::SCIM_KEY_Georgian_en, SCIM_BRIDGE_KEY_Georgian_en);
        map_keycode (scim::SCIM_KEY_Georgian_vin, SCIM_BRIDGE_KEY_Georgian_vin);
        map_keycode (scim::SCIM_KEY_Georgian_zen, SCIM_BRIDGE_KEY_Georgian_zen);
        map_keycode (scim::SCIM_KEY_Georgian_tan, SCIM_BRIDGE_KEY_Georgian_tan);
        map_keycode (scim::SCIM_KEY_Georgian_in, SCIM_BRIDGE_KEY_Georgian_in);
        map_keycode (scim::SCIM_KEY_Georgian_kan, SCIM_BRIDGE_KEY_Georgian_kan);
        map_keycode (scim::SCIM_KEY_Georgian_las, SCIM_BRIDGE_KEY_Georgian_las);
        map_keycode (scim::SCIM_KEY_Georgian_man, SCIM_BRIDGE_KEY_Georgian_man);
        map_keycode (scim::SCIM_KEY_Georgian_nar, SCIM_BRIDGE_KEY_Georgian_nar);
        map_keycode (scim::SCIM_KEY_Georgian_on, SCIM_BRIDGE_KEY_Georgian_on);
        map_keycode (scim::SCIM_KEY_Georgian_par, SCIM_BRIDGE_KEY_Georgian_par);
        map_keycode (scim::SCIM_KEY_Georgian_zhar, SCIM_BRIDGE_KEY_Georgian_zhar);
        map_keycode (scim::SCIM_KEY_Georgian_rae, SCIM_BRIDGE_KEY_Georgian_rae);
        map_keycode (scim::SCIM_KEY_Georgian_san, SCIM_BRIDGE_KEY_Georgian_san);
        map_keycode (scim::SCIM_KEY_Georgian_tar, SCIM_BRIDGE_KEY_Georgian_tar);
        map_keycode (scim::SCIM_KEY_Georgian_un, SCIM_BRIDGE_KEY_Georgian_un);
        map_keycode (scim::SCIM_KEY_Georgian_phar, SCIM_BRIDGE_KEY_Georgian_phar);
        map_keycode (scim::SCIM_KEY_Georgian_khar, SCIM_BRIDGE_KEY_Georgian_khar);
        map_keycode (scim::SCIM_KEY_Georgian_ghan, SCIM_BRIDGE_KEY_Georgian_ghan);
        map_keycode (scim::SCIM_KEY_Georgian_qar, SCIM_BRIDGE_KEY_Georgian_qar);
        map_keycode (scim::SCIM_KEY_Georgian_shin, SCIM_BRIDGE_KEY_Georgian_shin);
        map_keycode (scim::SCIM_KEY_Georgian_chin, SCIM_BRIDGE_KEY_Georgian_chin);
        map_keycode (scim::SCIM_KEY_Georgian_can, SCIM_BRIDGE_KEY_Georgian_can);
        map_keycode (scim::SCIM_KEY_Georgian_jil, SCIM_BRIDGE_KEY_Georgian_jil);
        map_keycode (scim::SCIM_KEY_Georgian_cil, SCIM_BRIDGE_KEY_Georgian_cil);
        map_keycode (scim::SCIM_KEY_Georgian_char, SCIM_BRIDGE_KEY_Georgian_char);
        map_keycode (scim::SCIM_KEY_Georgian_xan, SCIM_BRIDGE_KEY_Georgian_xan);
        map_keycode (scim::SCIM_KEY_Georgian_jhan, SCIM_BRIDGE_KEY_Georgian_jhan);
        map_keycode (scim::SCIM_KEY_Georgian_hae, SCIM_BRIDGE_KEY_Georgian_hae);
        map_keycode (scim::SCIM_KEY_Georgian_he, SCIM_BRIDGE_KEY_Georgian_he);
        map_keycode (scim::SCIM_KEY_Georgian_hie, SCIM_BRIDGE_KEY_Georgian_hie);
        map_keycode (scim::SCIM_KEY_Georgian_we, SCIM_BRIDGE_KEY_Georgian_we);
        map_keycode (scim::SCIM_KEY_Georgian_har, SCIM_BRIDGE_KEY_Georgian_har);
        map_keycode (scim::SCIM_KEY_Georgian_hoe, SCIM_BRIDGE_KEY_Georgian_hoe);
        map_keycode (scim::SCIM_KEY_Georgian_fi, SCIM_BRIDGE_KEY_Georgian_fi);

        /*
         *Azeri (andotherTurkicorCaucasianlanguagesofex-USSR)
         *Byte3=0x16
         */

        map_keycode (scim::SCIM_KEY_Ccedillaabovedot, SCIM_BRIDGE_KEY_Ccedillaabovedot);
        map_keycode (scim::SCIM_KEY_Xabovedot, SCIM_BRIDGE_KEY_Xabovedot);
        map_keycode (scim::SCIM_KEY_Qabovedot, SCIM_BRIDGE_KEY_Qabovedot);
        map_keycode (scim::SCIM_KEY_Ibreve, SCIM_BRIDGE_KEY_Ibreve);
        map_keycode (scim::SCIM_KEY_IE, SCIM_BRIDGE_KEY_IE);
        map_keycode (scim::SCIM_KEY_UO, SCIM_BRIDGE_KEY_UO);
        map_keycode (scim::SCIM_KEY_Zstroke, SCIM_BRIDGE_KEY_Zstroke);
        map_keycode (scim::SCIM_KEY_Gcaron, SCIM_BRIDGE_KEY_Gcaron);
        map_keycode (scim::SCIM_KEY_Obarred, SCIM_BRIDGE_KEY_Obarred);
        map_keycode (scim::SCIM_KEY_ccedillaabovedot, SCIM_BRIDGE_KEY_ccedillaabovedot);
        map_keycode (scim::SCIM_KEY_xabovedot, SCIM_BRIDGE_KEY_xabovedot);
        map_keycode (scim::SCIM_KEY_Ocaron, SCIM_BRIDGE_KEY_Ocaron);
        map_keycode (scim::SCIM_KEY_qabovedot, SCIM_BRIDGE_KEY_qabovedot);
        map_keycode (scim::SCIM_KEY_ibreve, SCIM_BRIDGE_KEY_ibreve);
        map_keycode (scim::SCIM_KEY_ie, SCIM_BRIDGE_KEY_ie);
        map_keycode (scim::SCIM_KEY_uo, SCIM_BRIDGE_KEY_uo);
        map_keycode (scim::SCIM_KEY_zstroke, SCIM_BRIDGE_KEY_zstroke);
        map_keycode (scim::SCIM_KEY_gcaron, SCIM_BRIDGE_KEY_gcaron);
        map_keycode (scim::SCIM_KEY_ocaron, SCIM_BRIDGE_KEY_ocaron);
        map_keycode (scim::SCIM_KEY_obarred, SCIM_BRIDGE_KEY_obarred);
        map_keycode (scim::SCIM_KEY_SCHWA, SCIM_BRIDGE_KEY_SCHWA);
        map_keycode (scim::SCIM_KEY_schwa, SCIM_BRIDGE_KEY_schwa);

        map_keycode (scim::SCIM_KEY_Lbelowdot, SCIM_BRIDGE_KEY_Lbelowdot);
        map_keycode (scim::SCIM_KEY_Lstrokebelowdot, SCIM_BRIDGE_KEY_Lstrokebelowdot);
        map_keycode (scim::SCIM_KEY_lbelowdot, SCIM_BRIDGE_KEY_lbelowdot);
        map_keycode (scim::SCIM_KEY_lstrokebelowdot, SCIM_BRIDGE_KEY_lstrokebelowdot);

        map_keycode (scim::SCIM_KEY_Gtilde, SCIM_BRIDGE_KEY_Gtilde);
        map_keycode (scim::SCIM_KEY_gtilde, SCIM_BRIDGE_KEY_gtilde);

        /*
         *Vietnamese
         *Byte3=0x1e
         */

        map_keycode (scim::SCIM_KEY_Abelowdot, SCIM_BRIDGE_KEY_Abelowdot);
        map_keycode (scim::SCIM_KEY_abelowdot, SCIM_BRIDGE_KEY_abelowdot);
        map_keycode (scim::SCIM_KEY_Ahook, SCIM_BRIDGE_KEY_Ahook);
        map_keycode (scim::SCIM_KEY_ahook, SCIM_BRIDGE_KEY_ahook);
        map_keycode (scim::SCIM_KEY_Acircumflexacute, SCIM_BRIDGE_KEY_Acircumflexacute);
        map_keycode (scim::SCIM_KEY_acircumflexacute, SCIM_BRIDGE_KEY_acircumflexacute);
        map_keycode (scim::SCIM_KEY_Acircumflexgrave, SCIM_BRIDGE_KEY_Acircumflexgrave);
        map_keycode (scim::SCIM_KEY_acircumflexgrave, SCIM_BRIDGE_KEY_acircumflexgrave);
        map_keycode (scim::SCIM_KEY_Acircumflexhook, SCIM_BRIDGE_KEY_Acircumflexhook);
        map_keycode (scim::SCIM_KEY_acircumflexhook, SCIM_BRIDGE_KEY_acircumflexhook);
        map_keycode (scim::SCIM_KEY_Acircumflextilde, SCIM_BRIDGE_KEY_Acircumflextilde);
        map_keycode (scim::SCIM_KEY_acircumflextilde, SCIM_BRIDGE_KEY_acircumflextilde);
        map_keycode (scim::SCIM_KEY_Acircumflexbelowdot, SCIM_BRIDGE_KEY_Acircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_acircumflexbelowdot, SCIM_BRIDGE_KEY_acircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_Abreveacute, SCIM_BRIDGE_KEY_Abreveacute);
        map_keycode (scim::SCIM_KEY_abreveacute, SCIM_BRIDGE_KEY_abreveacute);
        map_keycode (scim::SCIM_KEY_Abrevegrave, SCIM_BRIDGE_KEY_Abrevegrave);
        map_keycode (scim::SCIM_KEY_abrevegrave, SCIM_BRIDGE_KEY_abrevegrave);
        map_keycode (scim::SCIM_KEY_Abrevehook, SCIM_BRIDGE_KEY_Abrevehook);
        map_keycode (scim::SCIM_KEY_abrevehook, SCIM_BRIDGE_KEY_abrevehook);
        map_keycode (scim::SCIM_KEY_Abrevetilde, SCIM_BRIDGE_KEY_Abrevetilde);
        map_keycode (scim::SCIM_KEY_abrevetilde, SCIM_BRIDGE_KEY_abrevetilde);
        map_keycode (scim::SCIM_KEY_Abrevebelowdot, SCIM_BRIDGE_KEY_Abrevebelowdot);
        map_keycode (scim::SCIM_KEY_abrevebelowdot, SCIM_BRIDGE_KEY_abrevebelowdot);
        map_keycode (scim::SCIM_KEY_Ebelowdot, SCIM_BRIDGE_KEY_Ebelowdot);
        map_keycode (scim::SCIM_KEY_ebelowdot, SCIM_BRIDGE_KEY_ebelowdot);
        map_keycode (scim::SCIM_KEY_Ehook, SCIM_BRIDGE_KEY_Ehook);
        map_keycode (scim::SCIM_KEY_ehook, SCIM_BRIDGE_KEY_ehook);
        map_keycode (scim::SCIM_KEY_Etilde, SCIM_BRIDGE_KEY_Etilde);
        map_keycode (scim::SCIM_KEY_etilde, SCIM_BRIDGE_KEY_etilde);
        map_keycode (scim::SCIM_KEY_Ecircumflexacute, SCIM_BRIDGE_KEY_Ecircumflexacute);
        map_keycode (scim::SCIM_KEY_ecircumflexacute, SCIM_BRIDGE_KEY_ecircumflexacute);
        map_keycode (scim::SCIM_KEY_Ecircumflexgrave, SCIM_BRIDGE_KEY_Ecircumflexgrave);
        map_keycode (scim::SCIM_KEY_ecircumflexgrave, SCIM_BRIDGE_KEY_ecircumflexgrave);
        map_keycode (scim::SCIM_KEY_Ecircumflexhook, SCIM_BRIDGE_KEY_Ecircumflexhook);
        map_keycode (scim::SCIM_KEY_ecircumflexhook, SCIM_BRIDGE_KEY_ecircumflexhook);
        map_keycode (scim::SCIM_KEY_Ecircumflextilde, SCIM_BRIDGE_KEY_Ecircumflextilde);
        map_keycode (scim::SCIM_KEY_ecircumflextilde, SCIM_BRIDGE_KEY_ecircumflextilde);
        map_keycode (scim::SCIM_KEY_Ecircumflexbelowdot, SCIM_BRIDGE_KEY_Ecircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_ecircumflexbelowdot, SCIM_BRIDGE_KEY_ecircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_Ihook, SCIM_BRIDGE_KEY_Ihook);
        map_keycode (scim::SCIM_KEY_ihook, SCIM_BRIDGE_KEY_ihook);
        map_keycode (scim::SCIM_KEY_Ibelowdot, SCIM_BRIDGE_KEY_Ibelowdot);
        map_keycode (scim::SCIM_KEY_ibelowdot, SCIM_BRIDGE_KEY_ibelowdot);
        map_keycode (scim::SCIM_KEY_Obelowdot, SCIM_BRIDGE_KEY_Obelowdot);
        map_keycode (scim::SCIM_KEY_obelowdot, SCIM_BRIDGE_KEY_obelowdot);
        map_keycode (scim::SCIM_KEY_Ohook, SCIM_BRIDGE_KEY_Ohook);
        map_keycode (scim::SCIM_KEY_ohook, SCIM_BRIDGE_KEY_ohook);
        map_keycode (scim::SCIM_KEY_Ocircumflexacute, SCIM_BRIDGE_KEY_Ocircumflexacute);
        map_keycode (scim::SCIM_KEY_ocircumflexacute, SCIM_BRIDGE_KEY_ocircumflexacute);
        map_keycode (scim::SCIM_KEY_Ocircumflexgrave, SCIM_BRIDGE_KEY_Ocircumflexgrave);
        map_keycode (scim::SCIM_KEY_ocircumflexgrave, SCIM_BRIDGE_KEY_ocircumflexgrave);
        map_keycode (scim::SCIM_KEY_Ocircumflexhook, SCIM_BRIDGE_KEY_Ocircumflexhook);
        map_keycode (scim::SCIM_KEY_ocircumflexhook, SCIM_BRIDGE_KEY_ocircumflexhook);
        map_keycode (scim::SCIM_KEY_Ocircumflextilde, SCIM_BRIDGE_KEY_Ocircumflextilde);
        map_keycode (scim::SCIM_KEY_ocircumflextilde, SCIM_BRIDGE_KEY_ocircumflextilde);
        map_keycode (scim::SCIM_KEY_Ocircumflexbelowdot, SCIM_BRIDGE_KEY_Ocircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_ocircumflexbelowdot, SCIM_BRIDGE_KEY_ocircumflexbelowdot);
        map_keycode (scim::SCIM_KEY_Ohornacute, SCIM_BRIDGE_KEY_Ohornacute);
        map_keycode (scim::SCIM_KEY_ohornacute, SCIM_BRIDGE_KEY_ohornacute);
        map_keycode (scim::SCIM_KEY_Ohorngrave, SCIM_BRIDGE_KEY_Ohorngrave);
        map_keycode (scim::SCIM_KEY_ohorngrave, SCIM_BRIDGE_KEY_ohorngrave);
        map_keycode (scim::SCIM_KEY_Ohornhook, SCIM_BRIDGE_KEY_Ohornhook);
        map_keycode (scim::SCIM_KEY_ohornhook, SCIM_BRIDGE_KEY_ohornhook);
        map_keycode (scim::SCIM_KEY_Ohorntilde, SCIM_BRIDGE_KEY_Ohorntilde);
        map_keycode (scim::SCIM_KEY_ohorntilde, SCIM_BRIDGE_KEY_ohorntilde);
        map_keycode (scim::SCIM_KEY_Ohornbelowdot, SCIM_BRIDGE_KEY_Ohornbelowdot);
        map_keycode (scim::SCIM_KEY_ohornbelowdot, SCIM_BRIDGE_KEY_ohornbelowdot);
        map_keycode (scim::SCIM_KEY_Ubelowdot, SCIM_BRIDGE_KEY_Ubelowdot);
        map_keycode (scim::SCIM_KEY_ubelowdot, SCIM_BRIDGE_KEY_ubelowdot);
        map_keycode (scim::SCIM_KEY_Uhook, SCIM_BRIDGE_KEY_Uhook);
        map_keycode (scim::SCIM_KEY_uhook, SCIM_BRIDGE_KEY_uhook);
        map_keycode (scim::SCIM_KEY_Uhornacute, SCIM_BRIDGE_KEY_Uhornacute);
        map_keycode (scim::SCIM_KEY_uhornacute, SCIM_BRIDGE_KEY_uhornacute);
        map_keycode (scim::SCIM_KEY_Uhorngrave, SCIM_BRIDGE_KEY_Uhorngrave);
        map_keycode (scim::SCIM_KEY_uhorngrave, SCIM_BRIDGE_KEY_uhorngrave);
        map_keycode (scim::SCIM_KEY_Uhornhook, SCIM_BRIDGE_KEY_Uhornhook);
        map_keycode (scim::SCIM_KEY_uhornhook, SCIM_BRIDGE_KEY_uhornhook);
        map_keycode (scim::SCIM_KEY_Uhorntilde, SCIM_BRIDGE_KEY_Uhorntilde);
        map_keycode (scim::SCIM_KEY_uhorntilde, SCIM_BRIDGE_KEY_uhorntilde);
        map_keycode (scim::SCIM_KEY_Uhornbelowdot, SCIM_BRIDGE_KEY_Uhornbelowdot);
        map_keycode (scim::SCIM_KEY_uhornbelowdot, SCIM_BRIDGE_KEY_uhornbelowdot);
        map_keycode (scim::SCIM_KEY_Ybelowdot, SCIM_BRIDGE_KEY_Ybelowdot);
        map_keycode (scim::SCIM_KEY_ybelowdot, SCIM_BRIDGE_KEY_ybelowdot);
        map_keycode (scim::SCIM_KEY_Yhook, SCIM_BRIDGE_KEY_Yhook);
        map_keycode (scim::SCIM_KEY_yhook, SCIM_BRIDGE_KEY_yhook);
        map_keycode (scim::SCIM_KEY_Ytilde, SCIM_BRIDGE_KEY_Ytilde);
        map_keycode (scim::SCIM_KEY_ytilde, SCIM_BRIDGE_KEY_ytilde);
        map_keycode (scim::SCIM_KEY_Ohorn, SCIM_BRIDGE_KEY_Ohorn);
        map_keycode (scim::SCIM_KEY_ohorn, SCIM_BRIDGE_KEY_ohorn);
        map_keycode (scim::SCIM_KEY_Uhorn, SCIM_BRIDGE_KEY_Uhorn);
        map_keycode (scim::SCIM_KEY_uhorn, SCIM_BRIDGE_KEY_uhorn);

        map_keycode (scim::SCIM_KEY_combining_tilde, SCIM_BRIDGE_KEY_combining_tilde);
        map_keycode (scim::SCIM_KEY_combining_grave, SCIM_BRIDGE_KEY_combining_grave);
        map_keycode (scim::SCIM_KEY_combining_acute, SCIM_BRIDGE_KEY_combining_acute);
        map_keycode (scim::SCIM_KEY_combining_hook, SCIM_BRIDGE_KEY_combining_hook);
        map_keycode (scim::SCIM_KEY_combining_belowdot, SCIM_BRIDGE_KEY_combining_belowdot);

        map_keycode (scim::SCIM_KEY_EcuSign, SCIM_BRIDGE_KEY_EcuSign);
        map_keycode (scim::SCIM_KEY_ColonSign, SCIM_BRIDGE_KEY_ColonSign);
        map_keycode (scim::SCIM_KEY_CruzeiroSign, SCIM_BRIDGE_KEY_CruzeiroSign);
        map_keycode (scim::SCIM_KEY_FFrancSign, SCIM_BRIDGE_KEY_FFrancSign);
        map_keycode (scim::SCIM_KEY_LiraSign, SCIM_BRIDGE_KEY_LiraSign);
        map_keycode (scim::SCIM_KEY_MillSign, SCIM_BRIDGE_KEY_MillSign);
        map_keycode (scim::SCIM_KEY_NairaSign, SCIM_BRIDGE_KEY_NairaSign);
        map_keycode (scim::SCIM_KEY_PesetaSign, SCIM_BRIDGE_KEY_PesetaSign);
        map_keycode (scim::SCIM_KEY_RupeeSign, SCIM_BRIDGE_KEY_RupeeSign);
        map_keycode (scim::SCIM_KEY_WonSign, SCIM_BRIDGE_KEY_WonSign);
        map_keycode (scim::SCIM_KEY_NewSheqelSign, SCIM_BRIDGE_KEY_NewSheqelSign);
        map_keycode (scim::SCIM_KEY_DongSign, SCIM_BRIDGE_KEY_DongSign);
        map_keycode (scim::SCIM_KEY_EuroSign, SCIM_BRIDGE_KEY_EuroSign);
    }
}


/* Implementations */
ScimBridgeKeyEvent scim_bridge_keyevent_scim_to_bridge (const ScimKeyEvent &keyevent)
{
    init_trans_map ();

    ScimBridgeKeyEvent new_keyevent;
    new_keyevent.mod_state = 0;
    if (keyevent.is_shift_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_SHIFT;
    if (keyevent.is_caps_lock_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_CAPS_LOCK;
    if (keyevent.is_control_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_CONTROL;
    if (keyevent.is_alt_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_ALT;
    if (keyevent.is_meta_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_META;
    if (keyevent.is_super_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_SUPER;
    if (keyevent.is_hyper_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_HYPER;
    if (keyevent.is_num_lock_down ())
        new_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_NUM_LOCK;
    if (keyevent.is_key_press ()) {
        new_keyevent.pressed = true;
    } else {
        new_keyevent.pressed = false;
    }

    map <ScimKeyCode, ScimBridgeKeyCode>::iterator iter = scim_to_bridge_map.find (keyevent.code);
    if (iter == scim_to_bridge_map.end ()) {
        /* Is this right dicision? */
        new_keyevent.code = SCIM_BRIDGE_KEY_NullKey;
    } else {
        pair <ScimKeyCode, ScimBridgeKeyCode> found_pair = *iter;
        new_keyevent.code = found_pair.second;
    }

    return new_keyevent;
}


ScimKeyEvent scim_bridge_keyevent_bridge_to_scim (const ScimBridgeKeyEvent &keyevent, const ScimKeyLayout &layout)
{
    init_trans_map ();

    ScimKeyMask new_mod_state = 0;
    if (scim_bridge_keyevent_is_shift_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_ShiftMask;
    if (scim_bridge_keyevent_is_caps_lock_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_CapsLockMask;
    if (scim_bridge_keyevent_is_control_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_ControlMask;
    if (scim_bridge_keyevent_is_alt_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_AltMask;
    if (scim_bridge_keyevent_is_meta_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_MetaMask;
    if (scim_bridge_keyevent_is_super_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_SuperMask;
    if (scim_bridge_keyevent_is_hyper_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_HyperMask;
    if (scim_bridge_keyevent_is_num_lock_down (&keyevent))
        new_mod_state |= scim::SCIM_KEY_NumLockMask;
    if (!scim_bridge_keyevent_is_key_pressed (&keyevent))
        new_mod_state |= scim::SCIM_KEY_ReleaseMask;

    ScimKeyCode new_keycode;
    map <ScimBridgeKeyCode, ScimKeyCode>::iterator iter = bridge_to_scim_map.find (keyevent.code);
    if (iter == bridge_to_scim_map.end ()) {
        /* Is this right dicision? */
        new_keycode = scim::SCIM_KEY_NullKey;
    } else {
        pair <ScimBridgeKeyCode, ScimKeyCode> found_pair = *iter;
        new_keycode = found_pair.second;
    }

    return ScimKeyEvent (new_keycode, new_mod_state, layout);
}
