#include <string.h>

#include "scim-bridge-agent-exception.h"

using std::runtime_error;
using std::string;

ScimBridgeAgentException::ScimBridgeAgentException (const string &message): runtime_error (message)
{
}


ScimBridgeAgentException::ScimBridgeAgentException (const ScimBridgeException &parent):
runtime_error (string (scim_bridge_exception_get_message (&parent)) + ": " + string (scim_bridge_exception_get_strerror (&parent)))
{
}


ScimBridgeAgentException::~ScimBridgeAgentException () throw ()
{
}
