//  Scicos
//
//  Copyright (C) INRIA - METALAU Project <scicos@inria.fr>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// See the file ../license.txt
//

function param_name=get_param_name(mo_param,Pars)
  // any old scicos macros, will be removed on 5.4.0
  warnobsolete(scilabRemovedVersion="5.4.0")

//Copyright INRIA
//## return an unique name for a modelica parameter
//## for the compiled modelica structure
//##
//## inputs :
//##   mo_param : a string that gives the name of the parameters
//##              in the modelica list (equations) of a modelica block.
//##
//##   Pars     : vector of strings of already attribuate parameters name
//##
//## output :
//##   param_name : the output string of the parameters name
//##

  ind = 1
  param_name=strsubst(mo_param," ","")+...
                      string(ind)
  while find(param_name==Pars)<>[] then
    ind = ind + 1
    param_name=strsubst(mo_param," ","")+...
                        string(ind)
  end

endfunction
