//
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//

function demo_colormap()
	
	global margin_x;
	global margin_y;
	
	global padding_x;
	global padding_y;
	
	global frame_w;
	global frame_h;
	
	global plot_w;
	global plot_h;
	
	// Parameters
	// =========================================================================
	
	frame_w              = 200;     // Frame width
	frame_h              = 330;     // Frame height
	
	plot_w               = 600;     // Plot width
	plot_h               = 550;     // Plot height
	
	margin_x             = 15;      // Horizontal margin between each elements
	margin_y             = 15;      // Vertical margin between each elements
	
	padding_x            = 10;      // Horizontal padding between each elements
	padding_y            = 10;      // Vertical padding between each elements
	
	defaultfont          = "arial"; // Default Font
	frametitle_font_size = 16;      // Title font size
	text_font_size       = 12;      // Text font size
	
	// Figure creation
	// ========================================================================= 
	
	axes_w       = 3*margin_x + frame_w + plot_w;    // axes width
	axes_h       = 2*margin_y + max(frame_h,plot_h); // axes height
	
	demo_plot3d = figure(100001);
	
	demo_plot3d.background      = -2;
	demo_plot3d.color_map       = jetcolormap(128);
	demo_plot3d.figure_position = [0 0];
	demo_plot3d.axes_size       = [axes_w axes_h];
	demo_plot3d.figure_name     = "Colormap";
	
	my_frame_pos_x = margin_x;
	my_frame_pos_y = (axes_h/2-frame_h/2);
	
	// Frames creation [Control Panel]
	// =========================================================================
	
	my_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_frame_pos_x my_frame_pos_y frame_w frame_h],...
		"fontname"            , "arial",...
		"fontunits"           , "points",...
		"fontsize"            , 13,...
		"fontweight"          , "bold", ...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_control" ...
	);
	
	// Frame title
	my_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Colormap",...
		"units"               , "pixels",...
		"position"            , [ 30+my_frame_pos_x my_frame_pos_y+frame_h-10 frame_w-60 20 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , frametitle_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_control" ...
	);
	
	// Colormap frame creation
	// =========================================================================
	
	my_cmap_frame_w     = frame_w;
	my_cmap_frame_h     = frame_h;
	
	// Colormap : Jetcolormap
	
	jetcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Jet",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-50 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "jetcolormap_radio");
	
	// Colormap : HSVcolormap
	
	HSVcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "HSV",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-70 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "HSVcolormap_radio");
	
	// Colormap : Hotcolormap
	
	hotcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Hot",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-90 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "hotcolormap_radio");
	
	// Colormap : Graycolormap
	
	graycolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Gray",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-110 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "graycolormap_radio");
	
	// Colormap : Wintercolormap
	
	wintercolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Winter",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-130 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "wintercolormap_radio");
	
	// Colormap : Springcolormap
	
	springcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Spring",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-150 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "springcolormap_radio");
	
	// Colormap : Summercolormap
	
	summercolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Summer",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-170 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "summercolormap_radio");
	
	// Colormap : Autumncolormap
	
	autumncolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Autumn",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-190 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "autumncolormap_radio");
		
	// Colormap : Bonecolormap
	
	bonecolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Bone",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-210 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "bonecolormap_radio");	
	
	// Colormap : Coppercolormap
	
	coppercolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Copper",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-230 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "coppercolormap_radio");
	
	// Colormap : Pinkcolormap
	
	pinkcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Pink",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-250 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "pinkcolormap_radio");
	
	// Colormap : Rainbowcolormap
	
	rainbowcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Rainbow",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-270 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "rainbowcolormap_radio");
		
	// Colormap : Oceancolormap
	
	oceancolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Ocean",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-290 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "oceancolormap_radio");
		
	// Colormap : Whitecolormap
	
	whitecolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "White",...
		"position"           , [ my_frame_pos_x+10 my_frame_pos_y+my_cmap_frame_h-310 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "demo_update_colormap",...
		"tag"                , "whitecolormap_radio");
	
	// Plot3d creation
	// =========================================================================
	
	drawlater();
	
	newaxes();
	my_plot_axes = gca();
	
	my_plot_axes.x_label.text       = "";
	my_plot_axes.y_label.text       = "";
	my_plot_axes.z_label.text       = "";
	my_plot_axes.title.text         = "";
	my_plot_axes.title.font_size    = 5;
	my_plot_axes.rotation_angles(1) = 80;
	my_plot_axes.axes_bounds        = [ ((2*margin_x+frame_w)/axes_w)  0  1-((2*margin_x+frame_w)/axes_w)  1];
	
	// define colormap
	colormapSize = 128;
	f = gcf();
	f.color_map = jetcolormap(128);
	
	// generate facet coordinates
	x = %pi * [-1:0.05:1]';z = sin(x)*cos(x)';
	[x,y,z] = genfac3d(x,x,z);
	
	// generate colors
	// colors depending on z, between 1 and colormap size
	facetsColors = (z + 1) * (colormapSize - 1) / 2 + 1;
	
	// plot
	plot3d(x,y,list(z, facetsColors));
	
	// Colorbar
	z_min = min(z);
	z_max = max(z);
	colorbar(z_min,z_max);
	
	// Background
	my_plot_axes.background = color(240,240,240);
	
	my_plot3d = gce();
	
	my_plot_axes.rotation_angles(1) = 80;
	
	drawnow();
	
endfunction


function demo_update_colormap()
	
	my_figure    = gcf();
	my_plot_axes = gca();
	
	my_figure.immediate_drawing = "off";
	
	set(findobj("tag", "jetcolormap_radio")     , "value", 0);
	set(findobj("tag", "hotcolormap_radio")     , "value", 0);
	set(findobj("tag", "graycolormap_radio")    , "value", 0);
	set(findobj("tag", "wintercolormap_radio")  , "value", 0);
	set(findobj("tag", "springcolormap_radio")  , "value", 0);
	set(findobj("tag", "summercolormap_radio")  , "value", 0);
	set(findobj("tag", "autumncolormap_radio")  , "value", 0);
	set(findobj("tag", "bonecolormap_radio")    , "value", 0);
	set(findobj("tag", "coppercolormap_radio")  , "value", 0);
	set(findobj("tag", "pinkcolormap_radio")    , "value", 0);
	set(findobj("tag", "HSVcolormap_radio")     , "value", 0);
	set(findobj("tag", "rainbowcolormap_radio") , "value", 0);
	set(findobj("tag", "oceancolormap_radio")   , "value", 0);
	set(findobj("tag", "whitecolormap_radio")   , "value", 0);
	
	set(gcbo, "value", 1);
	
	my_wanted_colormap = get(gcbo,"tag");
	
	if get(gcbo, "tag") == "jetcolormap_radio" then
		my_figure.color_map = jetcolormap(128);
	elseif get(gcbo, "tag") == "hotcolormap_radio" then
		my_figure.color_map = hotcolormap(128);
	elseif get(gcbo, "tag") == "graycolormap_radio" then
		my_figure.color_map = graycolormap(128);
	elseif get(gcbo, "tag") == "wintercolormap_radio" then
		my_figure.color_map = wintercolormap(128);
	elseif get(gcbo, "tag") == "springcolormap_radio" then
		my_figure.color_map = springcolormap(128);
	elseif get(gcbo, "tag") == "summercolormap_radio" then
		my_figure.color_map = summercolormap(128);
	elseif get(gcbo, "tag") == "autumncolormap_radio" then
		my_figure.color_map = autumncolormap(128);
	elseif get(gcbo, "tag") == "bonecolormap_radio" then
		my_figure.color_map = bonecolormap(128);
	elseif get(gcbo, "tag") == "coppercolormap_radio" then
		my_figure.color_map = coppercolormap(128);
	elseif get(gcbo, "tag") == "pinkcolormap_radio" then
		my_figure.color_map = pinkcolormap(128);
	elseif get(gcbo, "tag") == "HSVcolormap_radio" then
		my_figure.color_map = hsvcolormap(128);
	elseif get(gcbo, "tag") == "rainbowcolormap_radio" then
		my_figure.color_map = rainbowcolormap(128);
	elseif get(gcbo, "tag") == "oceancolormap_radio" then
		my_figure.color_map = oceancolormap(128);
	elseif get(gcbo, "tag") == "whitecolormap_radio" then
		my_figure.color_map = whitecolormap(128);
	end
	
	// Background
	my_plot_axes.background = color(240,240,240);
	
	my_figure.immediate_drawing = "on";
	
endfunction

