#include "IsometricCameraGL.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_subwinDrawing {

// Returns the current env

JNIEnv * IsometricCameraGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

IsometricCameraGL::~IsometricCameraGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors

IsometricCameraGL::IsometricCameraGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL; 
voidinitializeDrawingjintID=NULL; 
voidendDrawingID=NULL; 
voidshowjintID=NULL; 
voiddestroyjintID=NULL; 
voidsetViewingAreajdoublejdoublejdoublejdoubleID=NULL; 
voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID=NULL; 
voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID=NULL; 
voidsetFittingScalejdoublejdoublejdoubleID=NULL; 
voidplaceCameraID=NULL; 
voidredrawCameraID=NULL; 
voidreplaceCameraID=NULL; 
voidsetAxesReversejbooleanjbooleanjbooleanID=NULL; 
jintArraygetPixelCoordinatesjdoublejdoublejdoubleID=NULL; 
jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID=NULL; 
jdoubleArraygetProjectionMatrixID=NULL; 
jdoubleArraygetUnprojectMatrixID=NULL; 
jdoubleArrayget2dViewProjectionMatrixID=NULL; 
jdoubleArrayget2dViewUnprojectMatrixID=NULL; 
jdoubleArraygetViewPortID=NULL; 
voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID=NULL; 


}

IsometricCameraGL::IsometricCameraGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL; 
voidinitializeDrawingjintID=NULL; 
voidendDrawingID=NULL; 
voidshowjintID=NULL; 
voiddestroyjintID=NULL; 
voidsetViewingAreajdoublejdoublejdoublejdoubleID=NULL; 
voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID=NULL; 
voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID=NULL; 
voidsetFittingScalejdoublejdoublejdoubleID=NULL; 
voidplaceCameraID=NULL; 
voidredrawCameraID=NULL; 
voidreplaceCameraID=NULL; 
voidsetAxesReversejbooleanjbooleanjbooleanID=NULL; 
jintArraygetPixelCoordinatesjdoublejdoublejdoubleID=NULL; 
jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID=NULL; 
jdoubleArraygetProjectionMatrixID=NULL; 
jdoubleArraygetUnprojectMatrixID=NULL; 
jdoubleArrayget2dViewProjectionMatrixID=NULL; 
jdoubleArrayget2dViewUnprojectMatrixID=NULL; 
jdoubleArraygetViewPortID=NULL; 
voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID=NULL; 


}

// Generic methods


void IsometricCameraGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void IsometricCameraGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

void IsometricCameraGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache Luke */ voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintID==NULL) { /* Use the cache Luke */ voidinitializeDrawingjintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache Luke */ voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintID==NULL) { /* Use the cache Luke */ voidshowjintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintID==NULL) { /* Use the cache Luke */ voiddestroyjintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintID ,parentFigureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setViewingArea (double transX, double transY, double scaleX, double scaleY){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetViewingAreajdoublejdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ voidsetViewingAreajdoublejdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "setViewingArea", "(DDDD)V" ) ;
if (voidsetViewingAreajdoublejdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setViewingArea");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetViewingAreajdoublejdoublejdoublejdoubleID ,transX, transY, scaleX, scaleY);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setNormalizationParameters (double normalizeScaleX, double normalizeScaleY, double normalizeScaleZ, double transX, double transY, double transZ){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "setNormalizationParameters", "(DDDDDD)V" ) ;
if (voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setNormalizationParameters");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetNormalizationParametersjdoublejdoublejdoublejdoublejdoublejdoubleID ,normalizeScaleX, normalizeScaleY, normalizeScaleZ, transX, transY, transZ);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setAxesRotationParameters (double centerX, double centerY, double centerZ, double alpha, double theta){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "setAxesRotationParameters", "(DDDDD)V" ) ;
if (voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesRotationParameters");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetAxesRotationParametersjdoublejdoublejdoublejdoublejdoubleID ,centerX, centerY, centerZ, alpha, theta);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setFittingScale (double scaleX, double scaleY, double scaleZ){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetFittingScalejdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ voidsetFittingScalejdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "setFittingScale", "(DDD)V" ) ;
if (voidsetFittingScalejdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFittingScale");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetFittingScalejdoublejdoublejdoubleID ,scaleX, scaleY, scaleZ);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::placeCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidplaceCameraID==NULL) { /* Use the cache Luke */ voidplaceCameraID = curEnv->GetMethodID(this->instanceClass, "placeCamera", "()V" ) ;
if (voidplaceCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "placeCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidplaceCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::redrawCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidredrawCameraID==NULL) { /* Use the cache Luke */ voidredrawCameraID = curEnv->GetMethodID(this->instanceClass, "redrawCamera", "()V" ) ;
if (voidredrawCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "redrawCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidredrawCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::replaceCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidreplaceCameraID==NULL) { /* Use the cache Luke */ voidreplaceCameraID = curEnv->GetMethodID(this->instanceClass, "replaceCamera", "()V" ) ;
if (voidreplaceCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "replaceCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidreplaceCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setAxesReverse (bool xAxisRevert, bool yAxisRevert, bool zAxisRevert){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesReversejbooleanjbooleanjbooleanID==NULL) { /* Use the cache Luke */ voidsetAxesReversejbooleanjbooleanjbooleanID = curEnv->GetMethodID(this->instanceClass, "setAxesReverse", "(ZZZ)V" ) ;
if (voidsetAxesReversejbooleanjbooleanjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesReverse");
}
}
jboolean xAxisRevert_ = ((bool) xAxisRevert ? JNI_TRUE : JNI_FALSE);

jboolean yAxisRevert_ = ((bool) yAxisRevert ? JNI_TRUE : JNI_FALSE);

jboolean zAxisRevert_ = ((bool) zAxisRevert ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallVoidMethod( this->instance, voidsetAxesReversejbooleanjbooleanjbooleanID ,xAxisRevert_, yAxisRevert_, zAxisRevert_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int * IsometricCameraGL::getPixelCoordinates (double userCoordX, double userCoordY, double userCoordZ){

JNIEnv * curEnv = getCurrentEnv();

if (jintArraygetPixelCoordinatesjdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ jintArraygetPixelCoordinatesjdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "getPixelCoordinates", "(DDD)[I" ) ;
if (jintArraygetPixelCoordinatesjdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getPixelCoordinates");
}
}
                        jintArray res =  (jintArray) curEnv->CallObjectMethod( this->instance, jintArraygetPixelCoordinatesjdoublejdoublejdoubleID ,userCoordX, userCoordY, userCoordZ);
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

int * IsometricCameraGL::get2dViewPixelCoordinates (double userCoordX, double userCoordY, double userCoordZ){

JNIEnv * curEnv = getCurrentEnv();

if (jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "get2dViewPixelCoordinates", "(DDD)[I" ) ;
if (jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewPixelCoordinates");
}
}
                        jintArray res =  (jintArray) curEnv->CallObjectMethod( this->instance, jintArrayget2dViewPixelCoordinatesjdoublejdoublejdoubleID ,userCoordX, userCoordY, userCoordZ);
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double * IsometricCameraGL::getProjectionMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArraygetProjectionMatrixID==NULL) { /* Use the cache Luke */ jdoubleArraygetProjectionMatrixID = curEnv->GetMethodID(this->instanceClass, "getProjectionMatrix", "()[D" ) ;
if (jdoubleArraygetProjectionMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getProjectionMatrix");
}
}
                        jdoubleArray res =  (jdoubleArray) curEnv->CallObjectMethod( this->instance, jdoubleArraygetProjectionMatrixID );
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jdouble *resultsArray = (jdouble *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
double * myArray= new double[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double * IsometricCameraGL::getUnprojectMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArraygetUnprojectMatrixID==NULL) { /* Use the cache Luke */ jdoubleArraygetUnprojectMatrixID = curEnv->GetMethodID(this->instanceClass, "getUnprojectMatrix", "()[D" ) ;
if (jdoubleArraygetUnprojectMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getUnprojectMatrix");
}
}
                        jdoubleArray res =  (jdoubleArray) curEnv->CallObjectMethod( this->instance, jdoubleArraygetUnprojectMatrixID );
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jdouble *resultsArray = (jdouble *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
double * myArray= new double[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double * IsometricCameraGL::get2dViewProjectionMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArrayget2dViewProjectionMatrixID==NULL) { /* Use the cache Luke */ jdoubleArrayget2dViewProjectionMatrixID = curEnv->GetMethodID(this->instanceClass, "get2dViewProjectionMatrix", "()[D" ) ;
if (jdoubleArrayget2dViewProjectionMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewProjectionMatrix");
}
}
                        jdoubleArray res =  (jdoubleArray) curEnv->CallObjectMethod( this->instance, jdoubleArrayget2dViewProjectionMatrixID );
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jdouble *resultsArray = (jdouble *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
double * myArray= new double[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double * IsometricCameraGL::get2dViewUnprojectMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArrayget2dViewUnprojectMatrixID==NULL) { /* Use the cache Luke */ jdoubleArrayget2dViewUnprojectMatrixID = curEnv->GetMethodID(this->instanceClass, "get2dViewUnprojectMatrix", "()[D" ) ;
if (jdoubleArrayget2dViewUnprojectMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewUnprojectMatrix");
}
}
                        jdoubleArray res =  (jdoubleArray) curEnv->CallObjectMethod( this->instance, jdoubleArrayget2dViewUnprojectMatrixID );
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jdouble *resultsArray = (jdouble *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
double * myArray= new double[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double * IsometricCameraGL::getViewPort (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArraygetViewPortID==NULL) { /* Use the cache Luke */ jdoubleArraygetViewPortID = curEnv->GetMethodID(this->instanceClass, "getViewPort", "()[D" ) ;
if (jdoubleArraygetViewPortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getViewPort");
}
}
                        jdoubleArray res =  (jdoubleArray) curEnv->CallObjectMethod( this->instance, jdoubleArraygetViewPortID );
                        
jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jdouble *resultsArray = (jdouble *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
double * myArray= new double[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void IsometricCameraGL::setAxesBounds (double xMin, double xMax, double yMin, double yMax, double zMin, double zMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID==NULL) { /* Use the cache Luke */ voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID = curEnv->GetMethodID(this->instanceClass, "setAxesBounds", "(DDDDDD)V" ) ;
if (voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesBounds");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetAxesBoundsjdoublejdoublejdoublejdoublejdoublejdoubleID ,xMin, xMax, yMin, yMax, zMin, zMax);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
