// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) INRIA/ENPC
// 
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//==========================================
// Generate a shared library which can be used by link command. 
function libn = ilib_for_link(names, ..
                              files, ..
                              libs, ..
                              flag, ..
                              makename, ..
                              loadername, ..
                              libname, ..
                              ldflags, ..
                              cflags, ..
                              fflags, ..
                              cc)

  [lhs,rhs] = argn(0);
  
  if rhs <= 4 then makename = "Makelib";end
  if rhs <= 5 then loadername = "loader.sce";end
  if rhs <= 6 then libname = ""; end
  if rhs <= 7 then ldflags = ""; end 
  if rhs <= 8 then cflags  = ""; end 
  if rhs <= 9 then fflags  = ""; end 
  if rhs <= 10 then cc  = ""; end 
  
  // generate a loader file
  write(%io(2),gettext("   Generate a loader file"));
  ilib_link_gen_loader(names,flag,loadername,libs,libname);
  
  // generate a Makefile
  write(%io(2),gettext("   Generate a Makefile"));

  ilib_link_gen_Make(names, ..
                     files, ..
                     libs, ..
                     makename, ..
                     libname, ..
		                 ldflags, ..
		                 cflags, ..
		                 fflags, ..
		                 cc, ..
		                 flag);
		                 
  // we call make
  write(%io(2),gettext("   Running the Makefile"));
  if (libname == "") then libname = names(1);end
  libn = ilib_compile('lib' + libname, makename, files);
  
endfunction
//==========================================
function ilib_link_gen_Make(names, ..
                            files, ..
                            libs, ..
                            makename, ..
                            libname, ..
                            ldflags, ..
                            cflags, ..
                            fflags, ..
                            cc, ..
                            flag)

  // generate a Makefile for gateway
  [lhs,rhs] = argn(0);
  if rhs <= 2 then libs = [];end
  if rhs <= 3 then makename = 'Makelib';end
  if rhs <= 4 then libname = "";end
  if rhs <= 5 then ldflags = ""; end 
  if rhs <= 6 then cflags  = ""; end 
  if rhs <= 7 then fflags  = ""; end 
  if rhs <= 8 then cc  = ""; end 
  if rhs <= 9 then flag  = "c"; end 
  
  if MSDOS then // Windows
    // Visual Studio C++ 
    if ( findmsvccompiler() <> 'unknown' ) then 
      Makename = makename+'.mak';
      ilib_link_gen_Make_msvc(names, ..
                              files, ..
                              libs, ..
                              Makename, ..
                              libname, ..
			                        ldflags, ..
			                        cflags, ..
			                        fflags, ..
			                        cc);
    else
      // LCC-WIN32
      if findlcccompiler() then
        Makename = makename+'.lcc';
  	    ilib_link_gen_Make_lcc(names, ..
  	                           files, ..
  	                           libs, ..
  	                           Makename, ..
  	                           libname, ..
  	                           ldflags, ..
  	                           cflags, ..
  	                           fflags, ..
  	                           cc, ..
  	                           flag);
      else
      // TO DO : Add another compiler here
      end
    end
  
  else // LINUX
   Makename = makename;

   ilib_gen_Make_unix(names, ..
                           files, ..
                           libs, ..
                           libname, ..
                           ldflags, ..
                           cflags, ..
                           fflags, ..
                           cc);
  end
  
endfunction
//==========================================

function ilib_link_gen_loader(names,flag,loadername,libs,libname)

  rhs = argn(2);
  if rhs <= 4 then libname = ""; end 
  if rhs <= 3 then libs=[]; end 
  if rhs <= 2 then loadername = 'loader.sce' ; end 
  
  lib_suf = getdynlibext();
  if libname=="" then libname = names(1);end 
  
  if ( length(libname) + length('_path') ) > 24 then
   shortlibname_path = part(libname,1:(24 - length('_path')));
  else
   shortlibname_path = libname;
  end
  
  fd=mopen(loadername,"w");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"\n");
  mfprintf(fd,"%s_path = get_absolute_file_path(''%s'');\n",shortlibname_path,basename(loadername+'.x'));
  mfprintf(fd,"\n");
  
  //** first "link" : external libraries 
  if libs=="" then 
    //** do nothing : you don't need to link any "external" lib(s)
  else
    //** add one "link" line for each library (with the appropriate extension)
      nl = size(libs,'*') ;
      for i=1:nl 
         if ( part(libs(i),1) == '/') then
           mfprintf(fd,"link(''%s%s'');\n",libs(i),lib_suf);
         else
           [diri, basenamei, exti] = fileparts(libs(i));
           if (diri == '') then
            mfprintf(fd,"link(%s_path+''%s%s'');\n",shortlibname_path,libs(i),lib_suf);
           else
            mfprintf(fd,"link(''%s%s'');\n",libs(i),lib_suf);
           end
         end
      end
  end  
  
  //** second "link" : user defined functions  
  mfprintf(fd,"link(%s_path+''lib%s%s'',[",shortlibname_path,libname,lib_suf);
  
  names = names(:)';
  n = size(names,'*');
  for i=1:n
    mfprintf(fd,"''%s''",names(i))
    if i <>n ; mfprintf(fd,","); else mfprintf(fd,"],");end
  end
  
  // we manage .f90 as .f on windows
  if MSDOS then 
   if findmsifortcompiler()<> 'unknown' then
     if flag == 'f90' then
      flag = 'f';
     end
   else
     if flag == 'f90' then
      error(gettext('F2C cannot build fortran 90'));
     end
   end
  end

  mfprintf(fd,"''%s'');\n",flag);
  mfprintf(fd,"// remove temp. variables on stack\n");
  mfprintf(fd,"clear %s_path;\n",shortlibname_path);
  mfprintf(fd,"clear get_file_path;\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mclose(fd);
endfunction
//==========================================    
function ilib_link_gen_Make_msvc(names, ..
                                  files, ..
                                  libs, ..
                                  Makename, ..
                                  libname, ..
                                  ldflags, ..
                                  cflags, ..
                                  fflags, ..
                                  cc)
  try
    MAKEFILE_VC = mgetl(SCI+'/modules/dynamic_link/src/scripts/TEMPLATE_MAKEFILE.VC');
  catch
    MAKEFILE_VC = '';
  end

	if ( MAKEFILE_VC <> '') then
	  MAKEFILE_VC = strsubst(MAKEFILE_VC,"__SCI__",SCI);
	  MAKEFILE_VC = strsubst(MAKEFILE_VC,"__SCIDIR1__",pathconvert(SCI,%f,%f,'w'));
	  
	  if (libname == '') then libname = names(1);end 
    MAKEFILE_VC = strsubst(MAKEFILE_VC,"__LIBNAME__",sprintf("lib%s",libname));
    
    if (files <> []) then
      OBJS = '';
      for x = files(:)'
        [ptmp,ftmp,fext] = fileparts(x);
        OBJ = ptmp + ftmp + '.obj';
        OBJS = OBJS + ' ' + OBJ;
      end
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__OBJS__",OBJS);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__OBJS__","");
    end
    
    if (libs <> []) then
      LIBS = '';
      for x = libs(:)'
        if x <> '' then
          LIBS = LIBS + ' ' + sprintf("%s.lib",x);
        end
      end
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__OTHERSLIBS__",LIBS);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__OTHERSLIBS__","");
    end
    
    if cc <> "" then
    
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__CC__",cc);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"CC = __CC__","#CC = ");
    end
    
    if cflags <> "" then
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__CFLAGS__",cflags);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__CFLAGS__","");    
    end
    
    if fflags <> "" then
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__FFLAGS__",fflags);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__FFLAGS__","");    
    end
    
    if ldflags <> "" then
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__LDFLAGS__",ldflags);
    else
      MAKEFILE_VC = strsubst(MAKEFILE_VC,"__LDFLAGS__","");
    end
    
    fd = mopen(Makename,"w");
    mputl(MAKEFILE_VC,fd);
    mclose(fd);
    
	else
	 // TEMPLATE_MAKEFILE.VC not found
	 warning(SCI+'/modules/dynamic_link/src/scripts/TEMPLATE_MAKEFILE.VC'+ 'not found.');
	end
                                  
endfunction
//==========================================    
function ilib_link_gen_Make_lcc(names, ..
                                files, ..
                                libs, ..
                                Makename, ..
                                libname, ..
                                ldflags, ..
                                cflags, ..
                                fflags, ..
                                cc, ..
                                flag)
                                
  // TO DO rewrite with a template 
  
  if libname == "" then libname = names(1);end 
  fd = mopen(Makename,"w");
  mfprintf(fd,"# ------------------------------------------------------------\n");
  mfprintf(fd,"# generated by builder.sce (lcc): Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------------\n\n");
  mfprintf(fd,"SCIDIR = %s\n",SCI);
  mfprintf(fd,"SCIDIR1 = %s\n",pathconvert(SCI,%f,%f,'w'));
  mfprintf(fd,"LCCLIBDIR =%s\n",getshortpathname(SCIHOME+filesep()+'lcclib'));
  mfprintf(fd,"DUMPEXTS = ""$(SCIDIR1)\\bin\\dumpexts""\n");
  mfprintf(fd,"SCIIMPLIB=$(LCCLIBDIR)\\LibScilab.lib $(LCCLIBDIR)\\blasplus.lib $(LCCLIBDIR)\\libf2c.lib $(LCCLIBDIR)\\intersci.lib $(LCCLIBDIR)\\lapack.lib $(LCCLIBDIR)\\scicos.lib\n\n");
  mfprintf(fd,"CC = lcc\n");
  mfprintf(fd,"LINKER = lcclnk\n");
  mfprintf(fd,"CFLAGS= -ansic msvcrt.lib -I""$(SCIDIR)/modules/core/includes"" -I""$(SCIDIR)/modules/output_stream/includes"" -I""$(SCIDIR)/libs/f2c"" -I""$(SCIDIR)/modules/mexlib/includes"" -Dmexfunction_=mex$*_ -DmexFunction=mex_$* -DWIN32 -DSTRICT -DFORDLL -D__STDC__  -DHAVE_EXP10"+ cflags +" \n"); 
  mfprintf(fd,"LINKER_FLAGS = -dll -nounderscores\n");
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"O=.obj\n");
 
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = lib%s\n",libname);
  mfprintf(fd,"\n# list of objects file\n");
  
  if (flag =='c') then
  	mfprintf(fd,"OBJSC =");
  	for x = files(:)' ;
  	  [ptmp,ftmp,fext] = fileparts(x);
  		x = ptmp + ftmp;
   		mfprintf(fd," %s$(O)",x);
   	end
  
  	mfprintf(fd,"\nOBJSF=\n");
  else
  	mfprintf(fd,"OBJSC =\n");
  	mfprintf(fd,"\nOBJSF=");
  	for x = files(:)' ;
      [ptmp,ftmp,fext] = fileparts(x);
  		x = ptmp + ftmp;
   		mfprintf(fd," %s$(O)",x);
   	end
  end
  
  mfprintf(fd,"\nOBJS = $(OBJSC) $(OBJSF)\n");
  
  mfprintf(fd,"\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS =");
  for x = libs(:)' ;
  	mfprintf(fd," ""%s.lib""",x);
  end
  mfprintf(fd,"\n");
  
  mfprintf(fd,"\nall :: $(LIBRARY).dll\n");
  mfprintf(fd,"\n$(LIBRARY).dll: $(OBJS)\n");
  mfprintf(fd,"\t"+"$(DUMPEXTS) -o ""$(LIBRARY).def"" ""$*"" $(OBJS)\n");
  mfprintf(fd,"\t"+"$(LINKER) $(LINKER_FLAGS) $(OBJS) $(OTHERLIBS) $(SCIIMPLIB) $(EXTRA_LDFLAGS) $*.def -o $(LIBRARY).dll\n\n");
 
  for x = files(:)' 
    [ptmp,ftmp,fext] = fileparts(x);
    x = ptmp + ftmp;
  	mfprintf(fd,"%s$(O):\n",x);
  	if (flag =='c') then
  		mfprintf(fd,"\t"+"$(CC) $(CFLAGS) $*.c\n\n");
  	else
  		mfprintf(fd,"\t"+"@$(SCIDIR1)\\bin\\f2c.exe $*.f \n");
		  mfprintf(fd,"\t"+"@$(CC) $(CFLAGS) $*.c \n");
		  mfprintf(fd,"\t"+"del $*.c \n");
	  end
  end
	
  mfprintf(fd,"clean:\n");
  mfprintf(fd,"\t"+"del *.obj\n");
  mfprintf(fd,"\t"+"del *.dll\n");
  mfprintf(fd,"\t"+"del *.lib\n");
  mfprintf(fd,"\t"+"del *.def\n");
 
  mclose(fd);
endfunction
//==========================================    
